/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.translator;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import org.apache.asterix.active.ActivityState;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.active.IRetryPolicyFactory;
import org.apache.asterix.active.NoRetryPolicyFactory;
import org.apache.asterix.algebra.extension.ExtensionStatement;
import org.apache.asterix.api.common.APIFramework;
import org.apache.asterix.api.common.ResultMetadata;
import org.apache.asterix.api.http.server.AbstractQueryApiServlet;
import org.apache.asterix.app.active.ActiveEntityEventsListener;
import org.apache.asterix.app.active.ActiveNotificationHandler;
import org.apache.asterix.app.active.FeedEventsListener;
import org.apache.asterix.app.external.ExternalLibraryUtil;
import org.apache.asterix.app.result.ExecutionError;
import org.apache.asterix.app.result.ResultHandle;
import org.apache.asterix.app.result.ResultReader;
import org.apache.asterix.app.result.fields.ErrorsPrinter;
import org.apache.asterix.app.result.fields.ResultHandlePrinter;
import org.apache.asterix.app.result.fields.ResultsPrinter;
import org.apache.asterix.app.result.fields.StatusPrinter;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.IClientRequest;
import org.apache.asterix.common.api.ICommonRequestParameters;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.api.IRequestTracker;
import org.apache.asterix.common.api.IResponseFieldPrinter;
import org.apache.asterix.common.api.IResponsePrinter;
import org.apache.asterix.common.api.ISchedulableClientRequest;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ExceptionUtils;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.exceptions.WarningCollector;
import org.apache.asterix.common.exceptions.WarningUtil;
import org.apache.asterix.common.external.IDataSourceAdapter;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.IDataset;
import org.apache.asterix.common.metadata.IMetadataLockUtil;
import org.apache.asterix.common.utils.JobUtils;
import org.apache.asterix.common.utils.StorageConstants;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.external.dataset.adapter.AdapterIdentifier;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.external.operators.FeedIntakeOperatorNodePushable;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.base.IRewriterFactory;
import org.apache.asterix.lang.common.base.IStatementRewriter;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.IndexedTypeExpression;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.expression.TypeReferenceExpression;
import org.apache.asterix.lang.common.statement.AdapterDropStatement;
import org.apache.asterix.lang.common.statement.CompactStatement;
import org.apache.asterix.lang.common.statement.ConnectFeedStatement;
import org.apache.asterix.lang.common.statement.CreateAdapterStatement;
import org.apache.asterix.lang.common.statement.CreateDataverseStatement;
import org.apache.asterix.lang.common.statement.CreateFeedPolicyStatement;
import org.apache.asterix.lang.common.statement.CreateFeedStatement;
import org.apache.asterix.lang.common.statement.CreateFunctionStatement;
import org.apache.asterix.lang.common.statement.CreateIndexStatement;
import org.apache.asterix.lang.common.statement.CreateLibraryStatement;
import org.apache.asterix.lang.common.statement.CreateSynonymStatement;
import org.apache.asterix.lang.common.statement.DatasetDecl;
import org.apache.asterix.lang.common.statement.DataverseDecl;
import org.apache.asterix.lang.common.statement.DataverseDropStatement;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.DisconnectFeedStatement;
import org.apache.asterix.lang.common.statement.DropDatasetStatement;
import org.apache.asterix.lang.common.statement.ExternalDetailsDecl;
import org.apache.asterix.lang.common.statement.FeedDropStatement;
import org.apache.asterix.lang.common.statement.FeedPolicyDropStatement;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.FunctionDropStatement;
import org.apache.asterix.lang.common.statement.IndexDropStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.InternalDetailsDecl;
import org.apache.asterix.lang.common.statement.LibraryDropStatement;
import org.apache.asterix.lang.common.statement.LoadStatement;
import org.apache.asterix.lang.common.statement.NodeGroupDropStatement;
import org.apache.asterix.lang.common.statement.NodegroupDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.statement.RefreshExternalDatasetStatement;
import org.apache.asterix.lang.common.statement.SetStatement;
import org.apache.asterix.lang.common.statement.StartFeedStatement;
import org.apache.asterix.lang.common.statement.StopFeedStatement;
import org.apache.asterix.lang.common.statement.SynonymDropStatement;
import org.apache.asterix.lang.common.statement.TypeDecl;
import org.apache.asterix.lang.common.statement.TypeDropStatement;
import org.apache.asterix.lang.common.statement.WriteStatement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.bootstrap.MetadataBuiltinEntities;
import org.apache.asterix.metadata.dataset.hints.DatasetHints;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.entities.Synonym;
import org.apache.asterix.metadata.feeds.FeedMetadataUtil;
import org.apache.asterix.metadata.functions.ExternalFunctionCompilerUtil;
import org.apache.asterix.metadata.lock.ExternalDatasetsRegistry;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.ExternalIndexingOperations;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.metadata.utils.KeyFieldTypeUtil;
import org.apache.asterix.metadata.utils.MetadataConstants;
import org.apache.asterix.metadata.utils.TypeUtil;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.asterix.transaction.management.service.transaction.DatasetIdFactory;
import org.apache.asterix.translator.AbstractLangTranslator;
import org.apache.asterix.translator.ClientRequest;
import org.apache.asterix.translator.CompiledStatements;
import org.apache.asterix.translator.ExecutionPlans;
import org.apache.asterix.translator.ExecutionPlansHtmlPrintUtil;
import org.apache.asterix.translator.IRequestParameters;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.SchedulableClientRequest;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.SessionOutput;
import org.apache.asterix.translator.TypeTranslator;
import org.apache.asterix.translator.util.ValidateUtil;
import org.apache.asterix.utils.DataverseUtil;
import org.apache.asterix.utils.FeedOperations;
import org.apache.asterix.utils.FlushDatasetUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.data.IAWriterFactory;
import org.apache.hyracks.algebricks.data.IResultSerializerFactoryProvider;
import org.apache.hyracks.algebricks.runtime.serializer.ResultSerializerFactoryProvider;
import org.apache.hyracks.algebricks.runtime.writers.PrinterBasedWriterFactory;
import org.apache.hyracks.api.client.IClusterInfoCollector;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.UnmanagedFileSplit;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.result.IResultSet;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryTranslator
extends AbstractLangTranslator
implements IStatementExecutor {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean IS_DEBUG_MODE = false;
    protected final List<Statement> statements;
    protected final ICcApplicationContext appCtx;
    protected final SessionOutput sessionOutput;
    protected final SessionConfig sessionConfig;
    protected Dataverse activeDataverse;
    protected final List<FunctionDecl> declaredFunctions;
    protected final ILangCompilationProvider compilationProvider;
    protected final APIFramework apiFramework;
    protected final IRewriterFactory rewriterFactory;
    protected final ExecutorService executorService;
    protected final EnumSet<JobFlag> jobFlags = EnumSet.noneOf(JobFlag.class);
    protected final IMetadataLockManager lockManager;
    protected final IMetadataLockUtil lockUtil;
    protected final IResponsePrinter responsePrinter;
    protected final WarningCollector warningCollector;

    public QueryTranslator(ICcApplicationContext appCtx, List<Statement> statements, SessionOutput output, ILangCompilationProvider compilationProvider, ExecutorService executorService, IResponsePrinter responsePrinter) {
        this.appCtx = appCtx;
        this.lockManager = appCtx.getMetadataLockManager();
        this.lockUtil = appCtx.getMetadataLockUtil();
        this.statements = statements;
        this.sessionOutput = output;
        this.sessionConfig = output.config();
        this.compilationProvider = compilationProvider;
        this.declaredFunctions = new ArrayList<FunctionDecl>();
        this.apiFramework = new APIFramework(compilationProvider);
        this.rewriterFactory = compilationProvider.getRewriterFactory();
        this.activeDataverse = MetadataBuiltinEntities.DEFAULT_DATAVERSE;
        this.executorService = executorService;
        this.responsePrinter = responsePrinter;
        this.warningCollector = new WarningCollector();
        if (appCtx.getServiceContext().getAppConfig().getBoolean((IOption)CCConfig.Option.ENFORCE_FRAME_WRITER_PROTOCOL)) {
            this.jobFlags.add(JobFlag.ENFORCE_CONTRACT);
        }
    }

    public SessionOutput getSessionOutput() {
        return this.sessionOutput;
    }

    public IWarningCollector getWarningCollector() {
        return this.warningCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileAndExecute(IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        this.validateStatements(requestParameters);
        this.trackRequest(requestParameters);
        int resultSetIdCounter = 0;
        FileSplit outputFile = null;
        PrinterBasedWriterFactory writerFactory = PrinterBasedWriterFactory.INSTANCE;
        ResultSerializerFactoryProvider resultSerializerFactoryProvider = ResultSerializerFactoryProvider.INSTANCE;
        String threadName = Thread.currentThread().getName();
        Thread.currentThread().setName(QueryTranslator.class.getSimpleName() + ":" + requestParameters.getRequestReference().getUuid());
        HashMap<String, String> config = new HashMap<String, String>();
        IResultSet resultSet = requestParameters.getResultSet();
        IStatementExecutor.ResultDelivery resultDelivery = requestParameters.getResultProperties().getDelivery();
        long maxResultReads = requestParameters.getResultProperties().getMaxReads();
        IStatementExecutor.Stats stats = requestParameters.getStats();
        IStatementExecutor.StatementProperties statementProperties = requestParameters.getStatementProperties();
        IStatementExecutor.ResultMetadata outMetadata = requestParameters.getOutMetadata();
        Map stmtParams = requestParameters.getStatementParameters();
        this.warningCollector.setMaxWarnings(this.sessionConfig.getMaxWarnings());
        try {
            block42: for (Statement stmt : this.statements) {
                if (this.sessionConfig.is("format-html")) {
                    this.sessionOutput.out().println("<!-- BEGIN -->");
                }
                this.validateOperation(this.appCtx, this.activeDataverse, stmt);
                MetadataProvider metadataProvider = MetadataProvider.create((ICcApplicationContext)this.appCtx, (Dataverse)this.activeDataverse);
                metadataProvider.getConfig().putAll(config);
                metadataProvider.setWriterFactory((IAWriterFactory)writerFactory);
                metadataProvider.setResultSerializerFactoryProvider((IResultSerializerFactoryProvider)resultSerializerFactoryProvider);
                metadataProvider.setOutputFile(outputFile);
                IStatementRewriter stmtRewriter = this.rewriterFactory.createStatementRewriter();
                this.rewriteStatement(stmt, stmtRewriter, metadataProvider);
                Statement.Kind kind = stmt.getKind();
                statementProperties.setKind(kind);
                switch (kind) {
                    case SET: {
                        this.handleSetStatement(stmt, config);
                        continue block42;
                    }
                    case DATAVERSE_DECL: {
                        this.activeDataverse = this.handleUseDataverseStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case CREATE_DATAVERSE: {
                        this.handleCreateDataverseStatement(metadataProvider, stmt, requestParameters);
                        continue block42;
                    }
                    case DATASET_DECL: {
                        this.handleCreateDatasetStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block42;
                    }
                    case CREATE_INDEX: {
                        this.handleCreateIndexStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block42;
                    }
                    case TYPE_DECL: {
                        this.handleCreateTypeStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case NODEGROUP_DECL: {
                        this.handleCreateNodeGroupStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case DATAVERSE_DROP: {
                        this.handleDataverseDropStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block42;
                    }
                    case DATASET_DROP: {
                        this.handleDatasetDropStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block42;
                    }
                    case INDEX_DROP: {
                        this.handleIndexDropStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block42;
                    }
                    case TYPE_DROP: {
                        this.handleTypeDropStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case NODEGROUP_DROP: {
                        this.handleNodegroupDropStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case CREATE_ADAPTER: {
                        this.handleCreateAdapterStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case ADAPTER_DROP: {
                        this.handleAdapterDropStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case CREATE_FUNCTION: {
                        this.handleCreateFunctionStatement(metadataProvider, stmt, stmtRewriter);
                        continue block42;
                    }
                    case FUNCTION_DROP: {
                        this.handleFunctionDropStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case CREATE_LIBRARY: {
                        this.handleCreateLibraryStatement(metadataProvider, stmt, hcc);
                        continue block42;
                    }
                    case LIBRARY_DROP: {
                        this.handleLibraryDropStatement(metadataProvider, stmt, hcc);
                        continue block42;
                    }
                    case CREATE_SYNONYM: {
                        this.handleCreateSynonymStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case SYNONYM_DROP: {
                        this.handleDropSynonymStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case LOAD: {
                        this.handleLoadStatement(metadataProvider, stmt, hcc);
                        continue block42;
                    }
                    case INSERT: 
                    case UPSERT: {
                        if (((InsertStatement)stmt).getReturnExpression() != null) {
                            metadataProvider.setResultSetId(new ResultSetId((long)resultSetIdCounter++));
                            metadataProvider.setResultAsyncMode(resultDelivery == IStatementExecutor.ResultDelivery.ASYNC || resultDelivery == IStatementExecutor.ResultDelivery.DEFERRED);
                            metadataProvider.setMaxResultReads(maxResultReads);
                        }
                        this.handleInsertUpsertStatement(metadataProvider, stmt, hcc, resultSet, resultDelivery, outMetadata, stats, false, requestParameters, stmtParams, stmtRewriter);
                        continue block42;
                    }
                    case DELETE: {
                        this.handleDeleteStatement(metadataProvider, stmt, hcc, false, stmtParams, stmtRewriter);
                        continue block42;
                    }
                    case CREATE_FEED: {
                        this.handleCreateFeedStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case DROP_FEED: {
                        this.handleDropFeedStatement(metadataProvider, stmt, hcc);
                        continue block42;
                    }
                    case DROP_FEED_POLICY: {
                        this.handleDropFeedPolicyStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case CONNECT_FEED: {
                        this.handleConnectFeedStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case DISCONNECT_FEED: {
                        this.handleDisconnectFeedStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case START_FEED: {
                        this.handleStartFeedStatement(metadataProvider, stmt, hcc);
                        continue block42;
                    }
                    case STOP_FEED: {
                        this.handleStopFeedStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case CREATE_FEED_POLICY: {
                        this.handleCreateFeedPolicyStatement(metadataProvider, stmt);
                        continue block42;
                    }
                    case QUERY: {
                        metadataProvider.setResultSetId(new ResultSetId((long)resultSetIdCounter++));
                        metadataProvider.setResultAsyncMode(resultDelivery == IStatementExecutor.ResultDelivery.ASYNC || resultDelivery == IStatementExecutor.ResultDelivery.DEFERRED);
                        metadataProvider.setMaxResultReads(maxResultReads);
                        if (stats.getProfileType() == IStatementExecutor.Stats.ProfileType.FULL) {
                            this.jobFlags.add(JobFlag.PROFILE_RUNTIME);
                        }
                        this.handleQuery(metadataProvider, (Query)stmt, hcc, resultSet, resultDelivery, outMetadata, stats, requestParameters, stmtParams, stmtRewriter);
                        continue block42;
                    }
                    case COMPACT: {
                        this.handleCompactStatement(metadataProvider, stmt, hcc);
                        continue block42;
                    }
                    case EXTERNAL_DATASET_REFRESH: {
                        this.handleExternalDatasetRefreshStatement(metadataProvider, stmt, hcc);
                        continue block42;
                    }
                    case WRITE: {
                        Pair<IAWriterFactory, FileSplit> result = this.handleWriteStatement(stmt);
                        writerFactory = result.first != null ? (IAWriterFactory)result.first : writerFactory;
                        outputFile = (FileSplit)result.second;
                        continue block42;
                    }
                    case FUNCTION_DECL: {
                        this.handleDeclareFunctionStatement(stmt);
                        continue block42;
                    }
                    case EXTENSION: {
                        ExtensionStatement extStmt = (ExtensionStatement)stmt;
                        statementProperties.setName(extStmt.getName());
                        extStmt.handle(hcc, (IStatementExecutor)this, requestParameters, metadataProvider, resultSetIdCounter);
                        continue block42;
                    }
                }
                throw new CompilationException(1038, stmt.getSourceLocation(), new Serializable[]{"Unexpected statement: " + kind});
            }
        }
        finally {
            if (IStatementExecutor.ResultDelivery.ASYNC != resultDelivery) {
                this.appCtx.getRequestTracker().complete(requestParameters.getRequestReference().getUuid());
            }
            Thread.currentThread().setName(threadName);
        }
    }

    protected void handleSetStatement(Statement stmt, Map<String, String> config) throws CompilationException {
        SetStatement ss = (SetStatement)stmt;
        String pname = ss.getPropName();
        String pvalue = ss.getPropValue();
        if (pname.startsWith("_internal")) {
            throw new CompilationException(1092, new Serializable[]{pname});
        }
        config.put(pname, pvalue);
    }

    protected Pair<IAWriterFactory, FileSplit> handleWriteStatement(Statement stmt) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        WriteStatement ws = (WriteStatement)stmt;
        File f = new File(ws.getFileName());
        UnmanagedFileSplit outputFile = new UnmanagedFileSplit(ws.getNcName().getValue(), f.getPath());
        IAWriterFactory writerFactory = null;
        if (ws.getWriterClassName() != null) {
            writerFactory = (IAWriterFactory)Class.forName(ws.getWriterClassName()).newInstance();
        }
        return new Pair(writerFactory, (Object)outputFile);
    }

    protected Dataverse handleUseDataverseStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        DataverseDecl dvd = (DataverseDecl)stmt;
        SourceLocation sourceLoc = dvd.getSourceLocation();
        DataverseName dvName = dvd.getDataverseName();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockManager.acquireDataverseReadLock(metadataProvider.getLocks(), dvName);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(metadataProvider.getMetadataTxnContext(), dvName);
            if (dv == null) {
                throw new MetadataException(1063, sourceLoc, new Serializable[]{dvName});
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            Dataverse dataverse = dv;
            return dataverse;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw new MetadataException(1070, (Throwable)e, sourceLoc, new Serializable[]{e.toString()});
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateDataverseStatement(MetadataProvider metadataProvider, Statement stmt, IRequestParameters requestParameters) throws Exception {
        CreateDataverseStatement stmtCreateDataverse = (CreateDataverseStatement)stmt;
        DataverseName dvName = stmtCreateDataverse.getDataverseName();
        this.lockUtil.createDataverseBegin(this.lockManager, metadataProvider.getLocks(), dvName);
        try {
            this.doCreateDataverseStatement(metadataProvider, stmtCreateDataverse, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doCreateDataverseStatement(MetadataProvider metadataProvider, CreateDataverseStatement stmtCreateDataverse, IRequestParameters requestParameters) throws Exception {
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            DataverseName dvName = stmtCreateDataverse.getDataverseName();
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(metadataProvider.getMetadataTxnContext(), dvName);
            if (dv != null) {
                if (stmtCreateDataverse.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(1071, stmtCreateDataverse.getSourceLocation(), new Serializable[]{dvName});
            }
            MetadataManager.INSTANCE.addDataverse(metadataProvider.getMetadataTxnContext(), new Dataverse(dvName, stmtCreateDataverse.getFormat(), 0));
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    protected static void validateCompactionPolicy(String compactionPolicy, Map<String, String> compactionPolicyProperties, MetadataTransactionContext mdTxnCtx, boolean isExternalDataset, SourceLocation sourceLoc) throws CompilationException, Exception {
        CompactionPolicy compactionPolicyEntity = MetadataManager.INSTANCE.getCompactionPolicy(mdTxnCtx, MetadataConstants.METADATA_DATAVERSE_NAME, compactionPolicy);
        if (compactionPolicyEntity == null) {
            throw new CompilationException(1079, sourceLoc, new Serializable[]{"Unknown compaction policy: " + compactionPolicy});
        }
        String compactionPolicyFactoryClassName = compactionPolicyEntity.getClassName();
        ILSMMergePolicyFactory mergePolicyFactory = (ILSMMergePolicyFactory)Class.forName(compactionPolicyFactoryClassName).newInstance();
        if (isExternalDataset && mergePolicyFactory.getName().compareTo("correlated-prefix") == 0) {
            throw new CompilationException(1079, sourceLoc, new Serializable[]{"The correlated-prefix merge policy cannot be used with external dataset."});
        }
        if (compactionPolicyProperties == null) {
            if (mergePolicyFactory.getName().compareTo("no-merge") != 0) {
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"Compaction policy properties are missing."});
            }
        } else {
            for (Map.Entry<String, String> entry : compactionPolicyProperties.entrySet()) {
                if (mergePolicyFactory.getPropertiesNames().contains(entry.getKey())) continue;
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"Invalid compaction policy property: " + entry.getKey()});
            }
            for (String p : mergePolicyFactory.getPropertiesNames()) {
                if (compactionPolicyProperties.containsKey(p)) continue;
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"Missing compaction policy property: " + p});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCreateDatasetStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        boolean metaItemTypeAnonymous;
        String metaItemTypeName;
        DataverseName metaItemTypeDataverseName;
        TypeExpression metaItemTypeExpr;
        boolean itemTypeAnonymous;
        String itemTypeName;
        DataverseName itemTypeDataverseName;
        TypeExpression itemTypeExpr;
        String datasetName;
        DataverseName dataverseName;
        DatasetDecl dd;
        block13: {
            block12: {
                dd = (DatasetDecl)stmt;
                dataverseName = this.getActiveDataverseName(dd.getDataverse());
                datasetName = dd.getName().getValue();
                itemTypeExpr = dd.getItemType();
                switch (itemTypeExpr.getTypeKind()) {
                    case TYPEREFERENCE: {
                        TypeReferenceExpression itemTypeRefExpr = (TypeReferenceExpression)itemTypeExpr;
                        Pair itemTypeIdent = itemTypeRefExpr.getIdent();
                        itemTypeDataverseName = itemTypeIdent.first != null ? (DataverseName)itemTypeIdent.first : dataverseName;
                        itemTypeName = ((Identifier)itemTypeRefExpr.getIdent().second).getValue();
                        itemTypeAnonymous = false;
                        break;
                    }
                    case RECORD: {
                        itemTypeDataverseName = dataverseName;
                        itemTypeName = TypeUtil.createDatasetInlineTypeName((String)datasetName, (boolean)false);
                        itemTypeAnonymous = true;
                        break;
                    }
                    default: {
                        throw new CompilationException(1038, stmt.getSourceLocation(), new Serializable[]{String.valueOf(itemTypeExpr.getTypeKind())});
                    }
                }
                metaItemTypeExpr = dd.getMetaItemType();
                metaItemTypeDataverseName = null;
                metaItemTypeName = null;
                if (metaItemTypeExpr == null) break block12;
                switch (metaItemTypeExpr.getTypeKind()) {
                    case TYPEREFERENCE: {
                        TypeReferenceExpression metaItemTypeRefExpr = (TypeReferenceExpression)metaItemTypeExpr;
                        Pair metaItemTypeIdent = metaItemTypeRefExpr.getIdent();
                        metaItemTypeDataverseName = metaItemTypeIdent.first != null ? (DataverseName)metaItemTypeIdent.first : dataverseName;
                        metaItemTypeName = ((Identifier)metaItemTypeRefExpr.getIdent().second).getValue();
                        metaItemTypeAnonymous = false;
                        break block13;
                    }
                    case RECORD: {
                        metaItemTypeDataverseName = dataverseName;
                        metaItemTypeName = TypeUtil.createDatasetInlineTypeName((String)datasetName, (boolean)true);
                        metaItemTypeAnonymous = true;
                        break block13;
                    }
                    default: {
                        throw new CompilationException(1038, stmt.getSourceLocation(), new Serializable[]{String.valueOf(metaItemTypeExpr.getTypeKind())});
                    }
                }
            }
            metaItemTypeAnonymous = true;
        }
        String nodegroupName = dd.getNodegroupName();
        String compactionPolicy = dd.getCompactionPolicy();
        boolean defaultCompactionPolicy = compactionPolicy == null;
        this.lockUtil.createDatasetBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, datasetName, itemTypeDataverseName, itemTypeName, itemTypeAnonymous, metaItemTypeDataverseName, metaItemTypeName, metaItemTypeAnonymous, nodegroupName, compactionPolicy, defaultCompactionPolicy, dd.getDatasetType(), (Object)dd.getDatasetDetailsDecl());
        try {
            this.doCreateDatasetStatement(metadataProvider, dd, dataverseName, datasetName, itemTypeDataverseName, itemTypeExpr, itemTypeName, metaItemTypeExpr, metaItemTypeDataverseName, metaItemTypeName, hcc, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void doCreateDatasetStatement(MetadataProvider metadataProvider, DatasetDecl dd, DataverseName dataverseName, String datasetName, DataverseName itemTypeDataverseName, TypeExpression itemTypeExpr, String itemTypeName, TypeExpression metaItemTypeExpr, DataverseName metaItemTypeDataverseName, String metaItemTypeName, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        MutableObject progress = new MutableObject((Object)JobUtils.ProgressState.NO_PROGRESS);
        SourceLocation sourceLoc = dd.getSourceLocation();
        DatasetConfig.DatasetType dsType = dd.getDatasetType();
        String ngNameId = dd.getNodegroupName();
        String compactionPolicy = dd.getCompactionPolicy();
        Map compactionPolicyProperties = dd.getCompactionPolicyProperties();
        String compressionScheme = metadataProvider.getCompressionManager().getDdlOrDefaultCompressionScheme(dd.getDatasetCompressionScheme());
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        Dataset dataset = null;
        Datatype itemTypeEntity = null;
        Datatype metaItemTypeEntity = null;
        boolean itemTypeAdded = false;
        boolean metaItemTypeAdded = false;
        try {
            ExternalDatasetDetails datasetDetails;
            String ngName;
            IAType itemType;
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverseName);
            if (dv == null) {
                throw new CompilationException(1063, sourceLoc, new Serializable[]{dataverseName});
            }
            Dataset ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds != null) {
                if (dd.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(1072, sourceLoc, new Serializable[]{datasetName, dataverseName});
            }
            boolean itemTypeIsInline = false;
            switch (itemTypeExpr.getTypeKind()) {
                case TYPEREFERENCE: {
                    itemTypeEntity = metadataProvider.findTypeEntity(itemTypeDataverseName, itemTypeName);
                    if (itemTypeEntity == null || itemTypeEntity.getIsAnonymous()) {
                        throw new AsterixException(1082, sourceLoc, new Serializable[]{DatasetUtil.getFullyQualifiedDisplayName((DataverseName)itemTypeDataverseName, (String)itemTypeName)});
                    }
                    itemType = itemTypeEntity.getDatatype();
                    this.validateDatasetItemType(dsType, itemType, false, sourceLoc);
                    break;
                }
                case RECORD: {
                    itemType = this.translateType(itemTypeDataverseName, itemTypeName, itemTypeExpr, mdTxnCtx);
                    this.validateDatasetItemType(dsType, itemType, false, sourceLoc);
                    itemTypeEntity = new Datatype(itemTypeDataverseName, itemTypeName, itemType, true);
                    itemTypeIsInline = true;
                    break;
                }
                default: {
                    throw new CompilationException(1038, sourceLoc, new Serializable[]{String.valueOf(itemTypeExpr.getTypeKind())});
                }
            }
            String string = ngName = ngNameId != null ? ngNameId : QueryTranslator.configureNodegroupForDataset(this.appCtx, dd.getHints(), dataverseName, datasetName, metadataProvider, sourceLoc);
            if (compactionPolicy == null) {
                compactionPolicy = "concurrent";
                compactionPolicyProperties = StorageConstants.DEFAULT_COMPACTION_POLICY_PROPERTIES;
            } else {
                QueryTranslator.validateCompactionPolicy(compactionPolicy, compactionPolicyProperties, mdTxnCtx, false, sourceLoc);
            }
            IAType metaItemType = null;
            boolean metaItemTypeIsInline = false;
            switch (dsType) {
                case INTERNAL: {
                    if (metaItemTypeExpr != null) {
                        switch (metaItemTypeExpr.getTypeKind()) {
                            case TYPEREFERENCE: {
                                metaItemTypeEntity = metadataProvider.findTypeEntity(metaItemTypeDataverseName, metaItemTypeName);
                                if (metaItemTypeEntity == null || metaItemTypeEntity.getIsAnonymous()) {
                                    throw new AsterixException(1082, sourceLoc, new Serializable[]{DatasetUtil.getFullyQualifiedDisplayName((DataverseName)metaItemTypeDataverseName, (String)metaItemTypeName)});
                                }
                                metaItemType = metaItemTypeEntity.getDatatype();
                                this.validateDatasetItemType(dsType, metaItemType, true, sourceLoc);
                                break;
                            }
                            case RECORD: {
                                metaItemType = this.translateType(metaItemTypeDataverseName, metaItemTypeName, metaItemTypeExpr, mdTxnCtx);
                                this.validateDatasetItemType(dsType, metaItemType, true, sourceLoc);
                                metaItemTypeEntity = new Datatype(metaItemTypeDataverseName, metaItemTypeName, metaItemType, true);
                                metaItemTypeIsInline = true;
                                break;
                            }
                            default: {
                                throw new CompilationException(1038, sourceLoc, new Serializable[]{String.valueOf(metaItemTypeExpr.getTypeKind())});
                            }
                        }
                    }
                    ARecordType metaRecType = (ARecordType)metaItemType;
                    List partitioningExprs = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getPartitioningExprs();
                    List keySourceIndicators = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getKeySourceIndicators();
                    boolean autogenerated = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).isAutogenerated();
                    ARecordType aRecordType = (ARecordType)itemType;
                    List partitioningTypes = ValidateUtil.validatePartitioningExpressions((ARecordType)aRecordType, (ARecordType)metaRecType, (List)partitioningExprs, (List)keySourceIndicators, (boolean)autogenerated, (SourceLocation)sourceLoc);
                    List filterField = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getFilterField();
                    Integer filterSourceIndicator = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getFilterSourceIndicator();
                    if (filterField != null) {
                        ValidateUtil.validateFilterField((ARecordType)aRecordType, (ARecordType)metaRecType, (Integer)filterSourceIndicator, (List)filterField, (SourceLocation)sourceLoc);
                    }
                    if (compactionPolicy == null && filterField != null) {
                        compactionPolicy = "correlated-prefix";
                        compactionPolicyProperties = StorageConstants.DEFAULT_COMPACTION_POLICY_PROPERTIES;
                    }
                    datasetDetails = new InternalDatasetDetails(InternalDatasetDetails.FileStructure.BTREE, InternalDatasetDetails.PartitioningStrategy.HASH, partitioningExprs, partitioningExprs, keySourceIndicators, partitioningTypes, autogenerated, filterSourceIndicator, filterField);
                    break;
                }
                case EXTERNAL: {
                    ExternalDetailsDecl externalDetails = (ExternalDetailsDecl)dd.getDatasetDetailsDecl();
                    Map<String, String> properties = this.createExternalDatasetProperties(dataverseName, dd, itemTypeEntity, metadataProvider, mdTxnCtx);
                    ExternalDataUtils.normalize(properties);
                    ExternalDataUtils.validate(properties);
                    this.validateExternalDatasetProperties(externalDetails, properties, dd.getSourceLocation(), mdTxnCtx);
                    datasetDetails = new ExternalDatasetDetails(externalDetails.getAdapter(), properties, new Date(), DatasetConfig.TransactionState.COMMIT);
                    break;
                }
                default: {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"Unknown dataset type " + dsType});
                }
            }
            if (!DatasetIdFactory.isInitialized()) {
                DatasetIdFactory.initialize((int)MetadataManager.INSTANCE.getMostRecentDatasetId());
            }
            dataset = new Dataset(dataverseName, datasetName, itemTypeDataverseName, itemTypeName, metaItemTypeDataverseName, metaItemTypeName, ngName, compactionPolicy, compactionPolicyProperties, (IDatasetDetails)datasetDetails, dd.getHints(), dsType, DatasetIdFactory.generateDatasetId(), 1, compressionScheme);
            MetadataManager.INSTANCE.addDataset(metadataProvider.getMetadataTxnContext(), dataset);
            if (itemTypeIsInline) {
                MetadataManager.INSTANCE.addDatatype(mdTxnCtx, itemTypeEntity);
                itemTypeAdded = true;
            }
            if (metaItemTypeIsInline) {
                MetadataManager.INSTANCE.addDatatype(mdTxnCtx, metaItemTypeEntity);
                metaItemTypeAdded = true;
            }
            if (dsType == DatasetConfig.DatasetType.INTERNAL) {
                JobSpecification jobSpec = DatasetUtil.createDatasetJobSpec((Dataset)dataset, (MetadataProvider)metadataProvider);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                progress.setValue((Object)JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA);
                this.runJob(hcc, jobSpec);
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
            }
            MetadataManager.INSTANCE.dropDataset(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName);
            dataset.setPendingOp(0);
            MetadataManager.INSTANCE.addDataset(metadataProvider.getMetadataTxnContext(), dataset);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress.getValue() == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                block36: {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    bActiveTxn = true;
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    try {
                        JobSpecification jobSpec = DatasetUtil.dropDatasetJobSpec(dataset, (MetadataProvider)metadataProvider);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        bActiveTxn = false;
                        this.runJob(hcc, jobSpec);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        if (!bActiveTxn) break block36;
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                    }
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                try {
                    MetadataManager.INSTANCE.dropDataset(mdTxnCtx, dataverseName, datasetName);
                    if (itemTypeAdded) {
                        MetadataManager.INSTANCE.dropDatatype(mdTxnCtx, itemTypeEntity.getDataverseName(), itemTypeEntity.getDatatypeName());
                    }
                    if (metaItemTypeAdded) {
                        MetadataManager.INSTANCE.dropDatatype(mdTxnCtx, metaItemTypeEntity.getDataverseName(), metaItemTypeEntity.getDatatypeName());
                    }
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending dataset(" + dataverseName + "." + datasetName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
    }

    protected void validateDatasetItemType(DatasetConfig.DatasetType datasetType, IAType itemType, boolean isMetaItemType, SourceLocation sourceLoc) throws AlgebricksException {
        if (itemType.getTypeTag() != ATypeTag.OBJECT) {
            throw new CompilationException(1079, sourceLoc, new Serializable[]{String.format("Dataset %s has to be a record type.", isMetaItemType ? "meta type" : "type")});
        }
    }

    protected Map<String, String> createExternalDatasetProperties(DataverseName dataverseName, DatasetDecl dd, Datatype itemType, MetadataProvider metadataProvider, MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        ExternalDetailsDecl externalDetails = (ExternalDetailsDecl)dd.getDatasetDetailsDecl();
        return externalDetails.getProperties();
    }

    protected static void validateIfResourceIsActiveInFeed(ICcApplicationContext appCtx, Dataset dataset, SourceLocation sourceLoc) throws CompilationException {
        IActiveEntityEventsListener[] listeners;
        ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)appCtx.getActiveNotificationHandler();
        for (IActiveEntityEventsListener listener : listeners = activeEventHandler.getEventListeners()) {
            if (!listener.isEntityUsingDataset((IDataset)dataset) || !listener.isActive()) continue;
            throw new CompilationException(1023, sourceLoc, new Serializable[]{DatasetUtil.getFullyQualifiedDisplayName((Dataset)dataset), listener.getEntityId().toString()});
        }
    }

    protected static String configureNodegroupForDataset(ICcApplicationContext appCtx, Map<String, String> hints, DataverseName dataverseName, String datasetName, MetadataProvider metadataProvider, SourceLocation sourceLoc) throws Exception {
        IClusterStateManager csm = appCtx.getClusterStateManager();
        Set allNodes = csm.getParticipantNodes(true);
        LinkedHashSet selectedNodes = new LinkedHashSet();
        String hintValue = hints.get("NODEGROUP_CARDINALITY");
        if (hintValue == null) {
            selectedNodes.addAll(allNodes);
        } else {
            Pair validation = DatasetHints.validate((ICcApplicationContext)appCtx, (String)"NODEGROUP_CARDINALITY", (String)hints.get("NODEGROUP_CARDINALITY"));
            boolean valid = (Boolean)validation.first;
            if (!valid) {
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"Incorrect use of hint 'NODEGROUP_CARDINALITY': " + (String)validation.second});
            }
            int nodegroupCardinality = Integer.parseInt(hints.get("NODEGROUP_CARDINALITY"));
            ArrayList allNodeList = new ArrayList(allNodes);
            Collections.shuffle(allNodeList);
            selectedNodes.addAll(allNodeList.subList(0, nodegroupCardinality));
        }
        return DatasetUtil.createNodeGroupForNewDataset((DataverseName)dataverseName, (String)datasetName, selectedNodes, (MetadataProvider)metadataProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCreateIndexStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        CreateIndexStatement stmtCreateIndex = (CreateIndexStatement)stmt;
        DataverseName dataverseName = this.getActiveDataverseName(stmtCreateIndex.getDataverseName());
        String datasetName = stmtCreateIndex.getDatasetName().getValue();
        this.lockUtil.createIndexBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, datasetName);
        try {
            this.doCreateIndex(metadataProvider, stmtCreateIndex, dataverseName, datasetName, hcc, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void doCreateIndex(MetadataProvider metadataProvider, CreateIndexStatement stmtCreateIndex, DataverseName dataverseName, String datasetName, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        SourceLocation sourceLoc = stmtCreateIndex.getSourceLocation();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverseName);
            if (dv == null) {
                throw new CompilationException(1063, sourceLoc, new Serializable[]{dataverseName});
            }
            Dataset ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds == null) {
                throw new CompilationException(1050, sourceLoc, new Serializable[]{datasetName, dataverseName});
            }
            DatasetConfig.DatasetType datasetType = ds.getDatasetType();
            DatasetConfig.IndexType indexType = stmtCreateIndex.getIndexType();
            boolean isSecondaryPrimary = stmtCreateIndex.getFieldExprs().isEmpty();
            this.validateIndexType(datasetType, indexType, isSecondaryPrimary, sourceLoc);
            String indexName = stmtCreateIndex.getIndexName().getValue();
            Index index = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, indexName);
            if (index != null) {
                if (stmtCreateIndex.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(1084, sourceLoc, new Serializable[]{indexName});
            }
            List keySourceIndicators = isSecondaryPrimary && datasetType == DatasetConfig.DatasetType.INTERNAL ? ((InternalDatasetDetails)ds.getDatasetDetails()).getKeySourceIndicator() : stmtCreateIndex.getFieldSourceIndicators();
            if (keySourceIndicators.stream().anyMatch(fieldSource -> fieldSource == 1) && !isSecondaryPrimary) {
                throw new AsterixException(1079, sourceLoc, new Serializable[]{"Cannot create index on meta fields"});
            }
            Datatype dt = MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), ds.getItemTypeDataverseName(), ds.getItemTypeName());
            ARecordType aRecordType = (ARecordType)dt.getDatatype();
            ARecordType metaRecordType = null;
            if (ds.hasMetaPart()) {
                Datatype metaDt = MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), ds.getMetaItemTypeDataverseName(), ds.getMetaItemTypeName());
                metaRecordType = (ARecordType)metaDt.getDatatype();
            }
            ArrayList<List<String>> indexFields = new ArrayList<List<String>>();
            ArrayList<IAType> indexFieldTypes = new ArrayList<IAType>();
            int keyIndex = 0;
            boolean overridesFieldTypes = false;
            HashSet<Pair> indexKeysSet = new HashSet<Pair>();
            for (Pair fieldExpr : stmtCreateIndex.getFieldExprs()) {
                int i;
                IAType fieldType = null;
                ARecordType subType = KeyFieldTypeUtil.chooseSource((List)keySourceIndicators, (int)keyIndex, (ARecordType)aRecordType, (ARecordType)metaRecordType);
                boolean isOpen = subType.isOpen();
                if (((List)fieldExpr.first).size() > 1 && !isOpen) {
                    for (i = 0; i < ((List)fieldExpr.first).size() - 1 && !isOpen; ++i) {
                        subType = (ARecordType)subType.getFieldType((String)((List)fieldExpr.first).get(i));
                        isOpen = subType.isOpen();
                    }
                }
                if (fieldExpr.second == null) {
                    fieldType = subType.getSubFieldType(((List)fieldExpr.first).subList(i, ((List)fieldExpr.first).size()));
                } else {
                    if (!stmtCreateIndex.isEnforced() && indexType != DatasetConfig.IndexType.BTREE) {
                        throw new AsterixException(1042, sourceLoc, new Serializable[]{indexType});
                    }
                    if (stmtCreateIndex.isEnforced() && !((IndexedTypeExpression)fieldExpr.second).isUnknownable()) {
                        throw new AsterixException(1041, sourceLoc, new Serializable[]{String.valueOf(fieldExpr.first)});
                    }
                    if (stmtCreateIndex.isEnforced() && subType.getSubFieldType(((List)fieldExpr.first).subList(i, ((List)fieldExpr.first).size())) != null) {
                        throw new AsterixException(1051, sourceLoc, new Serializable[]{String.valueOf(fieldExpr.first)});
                    }
                    if (!isOpen) {
                        throw new CompilationException(1079, sourceLoc, new Serializable[]{"Typed index on \"" + fieldExpr.first + "\" field could be created only for open datatype"});
                    }
                    if (stmtCreateIndex.hasMetaField()) {
                        throw new CompilationException(1079, sourceLoc, new Serializable[]{"Typed open index can only be created on the record part"});
                    }
                    Map typeMap = TypeTranslator.computeTypes((DataverseName)dataverseName, (String)indexName, (TypeExpression)((IndexedTypeExpression)fieldExpr.second).getType(), (DataverseName)dataverseName, (MetadataTransactionContext)mdTxnCtx);
                    TypeSignature typeSignature = new TypeSignature(dataverseName, indexName);
                    fieldType = (IAType)typeMap.get(typeSignature);
                    overridesFieldTypes = true;
                }
                if (fieldType == null) {
                    throw new CompilationException(1082, sourceLoc, new Serializable[]{fieldExpr.second == null ? String.valueOf(fieldExpr.first) : String.valueOf(fieldExpr.second)});
                }
                if (!indexKeysSet.add(new Pair(fieldExpr.first, stmtCreateIndex.getFieldSourceIndicators().get(keyIndex)))) {
                    throw new AsterixException(1052, sourceLoc, new Serializable[]{String.valueOf(fieldExpr.first)});
                }
                indexFields.add((List<String>)fieldExpr.first);
                indexFieldTypes.add(fieldType);
                ++keyIndex;
            }
            this.validateIndexKeyFields(stmtCreateIndex, keySourceIndicators, aRecordType, metaRecordType, indexFields, indexFieldTypes);
            Index newIndex = new Index(dataverseName, datasetName, indexName, indexType, indexFields, keySourceIndicators, indexFieldTypes, stmtCreateIndex.getGramLength(), overridesFieldTypes, stmtCreateIndex.isEnforced(), false, 1);
            bActiveTxn = false;
            this.doCreateIndexImpl(hcc, metadataProvider, ds, newIndex, this.jobFlags, sourceLoc);
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
    }

    private void doCreateIndexImpl(IHyracksClientConnection hcc, MetadataProvider metadataProvider, Dataset ds, Index index, EnumSet<JobFlag> jobFlags, SourceLocation sourceLoc) throws Exception {
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        boolean bActiveTxn = true;
        Index filesIndex = null;
        boolean firstExternalDatasetIndex = false;
        boolean datasetLocked = false;
        MetadataTransactionContext mdTxnCtx = metadataProvider.getMetadataTxnContext();
        boolean filesIndexReplicated = false;
        try {
            JobSpecification spec;
            index.setPendingOp(1);
            if (ds.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                this.validateDatasetState(metadataProvider, ds, sourceLoc);
            } else {
                if (!ExternalIndexingOperations.isIndexible((ExternalDatasetDetails)((ExternalDatasetDetails)ds.getDatasetDetails()))) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"dataset using " + ((ExternalDatasetDetails)ds.getDatasetDetails()).getAdapter() + " Adapter can't be indexed"});
                }
                if (!ExternalIndexingOperations.isValidIndexName((String)index.getDatasetName(), (String)index.getIndexName())) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"external dataset index name is invalid"});
                }
                filesIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), index.getDataverseName(), index.getDatasetName(), IndexingConstants.getFilesIndexName((String)index.getDatasetName()));
                firstExternalDatasetIndex = filesIndex == null;
                ExternalDatasetsRegistry.INSTANCE.buildIndexBegin(ds, firstExternalDatasetIndex);
                datasetLocked = true;
                if (firstExternalDatasetIndex && (filesIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), index.getDataverseName(), index.getDatasetName(), IndexingConstants.getFilesIndexName((String)index.getDatasetName()))) != null) {
                    ExternalDatasetsRegistry.INSTANCE.buildIndexEnd(ds, firstExternalDatasetIndex);
                    firstExternalDatasetIndex = false;
                    ExternalDatasetsRegistry.INSTANCE.buildIndexBegin(ds, firstExternalDatasetIndex);
                }
                if (firstExternalDatasetIndex) {
                    List externalFilesSnapshot = ExternalIndexingOperations.getSnapshotFromExternalFileSystem((Dataset)ds);
                    filesIndex = new Index(index.getDataverseName(), index.getDatasetName(), IndexingConstants.getFilesIndexName((String)index.getDatasetName()), DatasetConfig.IndexType.BTREE, ExternalIndexingOperations.FILE_INDEX_FIELD_NAMES, null, ExternalIndexingOperations.FILE_INDEX_FIELD_TYPES, false, false, false, 1);
                    MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), filesIndex);
                    for (ExternalFile file : externalFilesSnapshot) {
                        MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                    }
                    spec = ExternalIndexingOperations.buildFilesIndexCreateJobSpec((Dataset)ds, (List)externalFilesSnapshot, (MetadataProvider)metadataProvider);
                    if (spec == null) {
                        throw new CompilationException(1079, sourceLoc, new Serializable[]{"Failed to create job spec for replicating Files Index For external dataset"});
                    }
                    filesIndexReplicated = true;
                    QueryTranslator.runJob(hcc, spec, jobFlags);
                }
            }
            if (index.isEnforced()) {
                List indexes = MetadataManager.INSTANCE.getDatasetIndexes(metadataProvider.getMetadataTxnContext(), index.getDataverseName(), index.getDatasetName());
                for (Index existingIndex : indexes) {
                    if (!existingIndex.getKeyFieldNames().equals(index.getKeyFieldNames()) || existingIndex.getKeyFieldTypes().equals(index.getKeyFieldTypes()) || !existingIndex.isEnforced()) continue;
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"Cannot create index " + index.getIndexName() + " , enforced index " + existingIndex.getIndexName() + " on field \"" + StringUtils.join((Iterable)index.getKeyFieldNames(), (char)',') + "\" is already defined with type \"" + existingIndex.getKeyFieldTypes() + "\""});
                }
            }
            MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), index);
            spec = IndexUtil.buildSecondaryIndexCreationJobSpec((Dataset)ds, (Index)index, (MetadataProvider)metadataProvider, (SourceLocation)sourceLoc);
            if (spec == null) {
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"Failed to create job spec for creating index '" + ds.getDatasetName() + "." + index.getIndexName() + "'"});
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
            QueryTranslator.runJob(hcc, spec, jobFlags);
            if (ds.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                FlushDatasetUtil.flushDataset(hcc, metadataProvider, index.getDataverseName(), index.getDatasetName());
            }
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            spec = IndexUtil.buildSecondaryIndexLoadingJobSpec((Dataset)ds, (Index)index, (MetadataProvider)metadataProvider, (SourceLocation)sourceLoc);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            QueryTranslator.runJob(hcc, spec, jobFlags);
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), index.getDataverseName(), index.getDatasetName(), index.getIndexName());
            index.setPendingOp(0);
            MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), index);
            if (firstExternalDatasetIndex) {
                MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), index.getDataverseName(), index.getDatasetName(), filesIndex.getIndexName());
                filesIndex.setPendingOp(0);
                MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), filesIndex);
                ((ExternalDatasetDetails)ds.getDatasetDetails()).setRefreshTimestamp(new Date());
                MetadataManager.INSTANCE.updateDataset(mdTxnCtx, ds);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            JobSpecification jobSpec;
            block34: {
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                if (filesIndexReplicated) {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    bActiveTxn = true;
                    try {
                        jobSpec = ExternalIndexingOperations.buildDropFilesIndexJobSpec((MetadataProvider)metadataProvider, (Dataset)ds);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        bActiveTxn = false;
                        QueryTranslator.runJob(hcc, jobSpec, jobFlags);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        if (!bActiveTxn) break block34;
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                    }
                }
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                block35: {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    bActiveTxn = true;
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    try {
                        jobSpec = IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)ds, (SourceLocation)sourceLoc);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        bActiveTxn = false;
                        QueryTranslator.runJob(hcc, jobSpec, jobFlags);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        if (!bActiveTxn) break block35;
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                    }
                }
                if (firstExternalDatasetIndex) {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    try {
                        MetadataManager.INSTANCE.dropDatasetExternalFiles(mdTxnCtx, ds);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                        throw new IllegalStateException("System is inconsistent state: pending files for(" + index.getDataverseName() + "." + index.getDatasetName() + ") couldn't be removed from the metadata", e);
                    }
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    try {
                        MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), index.getDataverseName(), index.getDatasetName(), IndexingConstants.getFilesIndexName((String)index.getDatasetName()));
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                        throw new IllegalStateException("System is inconsistent state: pending index(" + index.getDataverseName() + "." + index.getDatasetName() + "." + IndexingConstants.getFilesIndexName((String)index.getDatasetName()) + ") couldn't be removed from the metadata", e);
                    }
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                try {
                    MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), index.getDataverseName(), index.getDatasetName(), index.getIndexName());
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is in inconsistent state: pending index(" + index.getDataverseName() + "." + index.getDatasetName() + "." + index.getIndexName() + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
        finally {
            if (datasetLocked) {
                ExternalDatasetsRegistry.INSTANCE.buildIndexEnd(ds, firstExternalDatasetIndex);
            }
        }
    }

    protected void validateIndexType(DatasetConfig.DatasetType datasetType, DatasetConfig.IndexType indexType, boolean isSecondaryPrimaryIndex, SourceLocation sourceLoc) throws AlgebricksException {
        if (datasetType == DatasetConfig.DatasetType.EXTERNAL && isSecondaryPrimaryIndex) {
            throw new CompilationException(1053, new Serializable[0]);
        }
    }

    protected void validateIndexKeyFields(CreateIndexStatement stmtCreateIndex, List<Integer> keySourceIndicators, ARecordType aRecordType, ARecordType metaRecordType, List<List<String>> indexFields, List<IAType> indexFieldTypes) throws AlgebricksException {
        ValidateUtil.validateKeyFields((ARecordType)aRecordType, (ARecordType)metaRecordType, indexFields, keySourceIndicators, indexFieldTypes, (DatasetConfig.IndexType)stmtCreateIndex.getIndexType());
    }

    protected void handleCreateTypeStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        TypeDecl stmtCreateType = (TypeDecl)stmt;
        SourceLocation sourceLoc = stmtCreateType.getSourceLocation();
        DataverseName dataverseName = this.getActiveDataverseName(stmtCreateType.getDataverseName());
        String typeName = stmtCreateType.getIdent().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockUtil.createTypeBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, typeName);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverseName);
            if (dv == null) {
                throw new CompilationException(1063, sourceLoc, new Serializable[]{dataverseName});
            }
            Datatype dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, dataverseName, typeName);
            if (dt != null) {
                if (!stmtCreateType.getIfNotExists()) {
                    throw new CompilationException(1085, sourceLoc, new Serializable[]{typeName});
                }
            } else {
                if (BuiltinTypeMap.getBuiltinType((String)typeName) != null) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"Cannot redefine builtin type " + typeName + "."});
                }
                if (TypeUtil.isReservedInlineTypeName((String)typeName)) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"Reserved type name " + typeName + "."});
                }
                IAType type = this.translateType(dataverseName, typeName, stmtCreateType.getTypeDef(), mdTxnCtx);
                MetadataManager.INSTANCE.addDatatype(mdTxnCtx, new Datatype(dataverseName, typeName, type, false));
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    private IAType translateType(DataverseName dataverseName, String typeName, TypeExpression typeDef, MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        Map typeMap = TypeTranslator.computeTypes((DataverseName)dataverseName, (String)typeName, (TypeExpression)typeDef, (DataverseName)dataverseName, (MetadataTransactionContext)mdTxnCtx);
        TypeSignature typeSignature = new TypeSignature(dataverseName, typeName);
        return (IAType)typeMap.get(typeSignature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDataverseDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        DataverseDropStatement stmtDropDataverse = (DataverseDropStatement)stmt;
        SourceLocation sourceLoc = stmtDropDataverse.getSourceLocation();
        DataverseName dataverseName = stmtDropDataverse.getDataverseName();
        if (dataverseName.equals((Object)MetadataBuiltinEntities.DEFAULT_DATAVERSE_NAME) || dataverseName.equals((Object)MetadataConstants.METADATA_DATAVERSE_NAME)) {
            throw new CompilationException(1079, sourceLoc, new Serializable[]{dataverseName + " dataverse can't be dropped"});
        }
        this.lockUtil.dropDataverseBegin(this.lockManager, metadataProvider.getLocks(), dataverseName);
        try {
            this.doDropDataverse(stmtDropDataverse, metadataProvider, hcc, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
            ExternalDatasetsRegistry.INSTANCE.releaseAcquiredLocks(metadataProvider);
        }
    }

    protected boolean doDropDataverse(DataverseDropStatement stmtDropDataverse, MetadataProvider metadataProvider, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        SourceLocation sourceLoc = stmtDropDataverse.getSourceLocation();
        DataverseName dataverseName = stmtDropDataverse.getDataverseName();
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        ArrayList<FeedEventsListener> feedsToStop = new ArrayList<FeedEventsListener>();
        ArrayList<Dataset> externalDatasetsToDeregister = new ArrayList<Dataset>();
        ArrayList<JobSpecification> jobsToExecute = new ArrayList<JobSpecification>();
        try {
            IActiveEntityEventsListener[] activeListeners;
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverseName);
            if (dv == null) {
                if (stmtDropDataverse.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(1063, sourceLoc, new Serializable[]{dataverseName});
            }
            if (stmtDropDataverse.getIfEmpty() && this.isDataverseNotEmpty(dataverseName, mdTxnCtx)) {
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                return false;
            }
            this.validateDataverseStateBeforeDrop(metadataProvider, dv, sourceLoc);
            ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
            for (IActiveEntityEventsListener listener : activeListeners = activeEventHandler.getEventListeners()) {
                EntityId activeEntityId = listener.getEntityId();
                if (!activeEntityId.getExtensionName().equals("Feed") || !activeEntityId.getDataverseName().equals((Object)dataverseName)) continue;
                FeedEventsListener feedListener = (FeedEventsListener)listener;
                feedsToStop.add(feedListener);
                jobsToExecute.add(FeedOperations.buildRemoveFeedStorageJob(metadataProvider, feedListener.getFeed()));
            }
            List datasets = MetadataManager.INSTANCE.getDataverseDatasets(mdTxnCtx, dataverseName);
            for (Dataset dataset : datasets) {
                String datasetName = dataset.getDatasetName();
                List indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName);
                DatasetConfig.DatasetType dsType = dataset.getDatasetType();
                if (dsType == DatasetConfig.DatasetType.INTERNAL) {
                    for (Index index : indexes) {
                        jobsToExecute.add(IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)dataset, (SourceLocation)sourceLoc));
                    }
                    continue;
                }
                if (dsType != DatasetConfig.DatasetType.EXTERNAL) continue;
                for (Index index : indexes) {
                    if (ExternalIndexingOperations.isFileIndex((Index)index)) {
                        jobsToExecute.add(ExternalIndexingOperations.buildDropFilesIndexJobSpec((MetadataProvider)metadataProvider, (Dataset)dataset));
                        continue;
                    }
                    jobsToExecute.add(IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)dataset, (SourceLocation)sourceLoc));
                }
                externalDatasetsToDeregister.add(dataset);
            }
            List libraries = MetadataManager.INSTANCE.getDataverseLibraries(mdTxnCtx, dataverseName);
            for (Library library : libraries) {
                jobsToExecute.add(ExternalLibraryUtil.buildDropLibraryJobSpec(dataverseName, library.getName(), metadataProvider));
            }
            jobsToExecute.add(DataverseUtil.dropDataverseJobSpec(dv, metadataProvider));
            MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, dataverseName);
            MetadataManager.INSTANCE.addDataverse(mdTxnCtx, new Dataverse(dataverseName, dv.getDataFormat(), 2));
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
            for (Dataset externalDataset : externalDatasetsToDeregister) {
                ExternalDatasetsRegistry.INSTANCE.removeDatasetInfo(externalDataset);
            }
            for (FeedEventsListener feedListener : feedsToStop) {
                if (feedListener.getState() != ActivityState.STOPPED) {
                    feedListener.stop(metadataProvider);
                }
                feedListener.unregister();
            }
            for (JobSpecification jobSpec : jobsToExecute) {
                this.runJob(hcc, jobSpec);
            }
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, dataverseName);
            for (Dataset dataset : datasets) {
                String nodeGroup = dataset.getNodeGroupName();
                this.lockManager.acquireNodeGroupWriteLock(metadataProvider.getLocks(), nodeGroup);
                if (MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, nodeGroup) == null) continue;
                MetadataManager.INSTANCE.dropNodegroup(mdTxnCtx, nodeGroup, true);
            }
            if (this.activeDataverse.getDataverseName().equals((Object)dataverseName)) {
                this.activeDataverse = MetadataBuiltinEntities.DEFAULT_DATAVERSE;
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                if (this.activeDataverse.getDataverseName().equals((Object)dataverseName)) {
                    this.activeDataverse = MetadataBuiltinEntities.DEFAULT_DATAVERSE;
                }
                try {
                    for (JobSpecification jobSpec : jobsToExecute) {
                        this.runJob(hcc, jobSpec);
                    }
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                try {
                    MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, dataverseName);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending dataverse(" + dataverseName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
    }

    protected boolean isDataverseNotEmpty(DataverseName dataverseName, MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        return MetadataManager.INSTANCE.isDataverseNotEmpty(mdTxnCtx, dataverseName);
    }

    protected void validateDataverseStateBeforeDrop(MetadataProvider metadataProvider, Dataverse dataverse, SourceLocation sourceLoc) throws AlgebricksException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDatasetDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        DropDatasetStatement stmtDelete = (DropDatasetStatement)stmt;
        SourceLocation sourceLoc = stmtDelete.getSourceLocation();
        DataverseName dataverseName = this.getActiveDataverseName(stmtDelete.getDataverseName());
        String datasetName = stmtDelete.getDatasetName().getValue();
        this.lockUtil.dropDatasetBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, datasetName);
        try {
            this.doDropDataset(dataverseName, datasetName, metadataProvider, stmtDelete.getIfExists(), hcc, requestParameters, true, sourceLoc);
        }
        finally {
            metadataProvider.getLocks().unlock();
            ExternalDatasetsRegistry.INSTANCE.releaseAcquiredLocks(metadataProvider);
        }
    }

    protected boolean doDropDataset(DataverseName dataverseName, String datasetName, MetadataProvider metadataProvider, boolean ifExists, IHyracksClientConnection hcc, IRequestParameters requestParameters, boolean dropCorrespondingNodeGroup, SourceLocation sourceLoc) throws Exception {
        MutableObject progress = new MutableObject((Object)JobUtils.ProgressState.NO_PROGRESS);
        MutableObject mdTxnCtx = new MutableObject((Object)MetadataManager.INSTANCE.beginTransaction());
        MutableBoolean bActiveTxn = new MutableBoolean(true);
        metadataProvider.setMetadataTxnContext((MetadataTransactionContext)mdTxnCtx.getValue());
        ArrayList jobsToExecute = new ArrayList();
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse((MetadataTransactionContext)mdTxnCtx.getValue(), dataverseName);
            if (dv == null) {
                if (ifExists) {
                    if (this.warningCollector.shouldWarn()) {
                        this.warningCollector.warn(WarningUtil.forAsterix((SourceLocation)sourceLoc, (int)1063, (Serializable[])new Serializable[]{dataverseName}));
                    }
                    MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
                    return false;
                }
                throw new CompilationException(1063, sourceLoc, new Serializable[]{dataverseName});
            }
            Dataset ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds == null) {
                if (ifExists) {
                    MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
                    return false;
                }
                throw new CompilationException(1050, sourceLoc, new Serializable[]{datasetName, dataverseName});
            }
            this.validateDatasetState(metadataProvider, ds, sourceLoc);
            ds.drop(metadataProvider, mdTxnCtx, jobsToExecute, bActiveTxn, progress, hcc, dropCorrespondingNodeGroup, sourceLoc);
            MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
            return true;
        }
        catch (Exception e) {
            if (bActiveTxn.booleanValue()) {
                QueryTranslator.abort(e, e, (MetadataTransactionContext)mdTxnCtx.getValue());
            }
            if (progress.getValue() == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                try {
                    for (JobSpecification jobSpec : jobsToExecute) {
                        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
                    }
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                mdTxnCtx.setValue((Object)MetadataManager.INSTANCE.beginTransaction());
                metadataProvider.setMetadataTxnContext((MetadataTransactionContext)mdTxnCtx.getValue());
                try {
                    MetadataManager.INSTANCE.dropDataset(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName);
                    MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, (MetadataTransactionContext)mdTxnCtx.getValue());
                    throw new IllegalStateException("System is inconsistent state: pending dataset(" + dataverseName + "." + datasetName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleIndexDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        IndexDropStatement stmtIndexDrop = (IndexDropStatement)stmt;
        DataverseName dataverseName = this.getActiveDataverseName(stmtIndexDrop.getDataverseName());
        String datasetName = stmtIndexDrop.getDatasetName().getValue();
        this.lockUtil.dropIndexBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, datasetName);
        try {
            this.doDropIndex(metadataProvider, stmtIndexDrop, dataverseName, datasetName, hcc, requestParameters);
        }
        finally {
            metadataProvider.getLocks().unlock();
            ExternalDatasetsRegistry.INSTANCE.releaseAcquiredLocks(metadataProvider);
        }
    }

    protected boolean doDropIndex(MetadataProvider metadataProvider, IndexDropStatement stmtIndexDrop, DataverseName dataverseName, String datasetName, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        SourceLocation sourceLoc = stmtIndexDrop.getSourceLocation();
        String indexName = stmtIndexDrop.getIndexName().getValue();
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        ArrayList<JobSpecification> jobsToExecute = new ArrayList<JobSpecification>();
        boolean dropFilesIndex = false;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Dataset ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds == null) {
                throw new CompilationException(1050, sourceLoc, new Serializable[]{datasetName, dataverseName});
            }
            if (ds.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                Index index = MetadataManager.INSTANCE.getIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                if (index == null) {
                    if (stmtIndexDrop.getIfExists()) {
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        return false;
                    }
                    throw new CompilationException(1083, sourceLoc, new Serializable[]{indexName});
                }
                this.ensureNonPrimaryIndexDrop(index, sourceLoc);
                this.validateDatasetState(metadataProvider, ds, sourceLoc);
                jobsToExecute.add(IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)ds, (SourceLocation)sourceLoc));
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                MetadataManager.INSTANCE.addIndex(mdTxnCtx, new Index(dataverseName, datasetName, indexName, index.getIndexType(), index.getKeyFieldNames(), index.getKeyFieldSourceIndicators(), index.getKeyFieldTypes(), index.isOverridingKeyFieldTypes(), index.isEnforced(), index.isPrimaryIndex(), 2));
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
                for (JobSpecification jobSpec : jobsToExecute) {
                    this.runJob(hcc, jobSpec);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, indexName);
            } else {
                indexName = stmtIndexDrop.getIndexName().getValue();
                Index index = MetadataManager.INSTANCE.getIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                if (index == null) {
                    if (stmtIndexDrop.getIfExists()) {
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        return false;
                    }
                    throw new CompilationException(1083, sourceLoc, new Serializable[]{indexName});
                }
                if (ExternalIndexingOperations.isFileIndex((Index)index)) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"Dropping a dataset's files index is not allowed."});
                }
                this.ensureNonPrimaryIndexDrop(index, sourceLoc);
                jobsToExecute.add(IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)ds, (SourceLocation)sourceLoc));
                List datasetIndexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName);
                if (datasetIndexes.size() == 2) {
                    dropFilesIndex = true;
                    for (Index externalIndex : datasetIndexes) {
                        if (!ExternalIndexingOperations.isFileIndex((Index)externalIndex)) continue;
                        jobsToExecute.add(ExternalIndexingOperations.buildDropFilesIndexJobSpec((MetadataProvider)metadataProvider, (Dataset)ds));
                        MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, externalIndex.getIndexName());
                        MetadataManager.INSTANCE.addIndex(mdTxnCtx, new Index(dataverseName, datasetName, externalIndex.getIndexName(), externalIndex.getIndexType(), externalIndex.getKeyFieldNames(), externalIndex.getKeyFieldSourceIndicators(), index.getKeyFieldTypes(), index.isOverridingKeyFieldTypes(), index.isEnforced(), externalIndex.isPrimaryIndex(), 2));
                    }
                }
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                MetadataManager.INSTANCE.addIndex(mdTxnCtx, new Index(dataverseName, datasetName, indexName, index.getIndexType(), index.getKeyFieldNames(), index.getKeyFieldSourceIndicators(), index.getKeyFieldTypes(), index.isOverridingKeyFieldTypes(), index.isEnforced(), index.isPrimaryIndex(), 2));
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
                for (JobSpecification jobSpec : jobsToExecute) {
                    this.runJob(hcc, jobSpec);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                if (dropFilesIndex) {
                    MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, IndexingConstants.getFilesIndexName((String)datasetName));
                    MetadataManager.INSTANCE.dropDatasetExternalFiles(mdTxnCtx, ds);
                    ExternalDatasetsRegistry.INSTANCE.removeDatasetInfo(ds);
                }
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                try {
                    for (JobSpecification jobSpec : jobsToExecute) {
                        this.runJob(hcc, jobSpec);
                    }
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                try {
                    MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, indexName);
                    if (dropFilesIndex) {
                        MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, IndexingConstants.getFilesIndexName((String)datasetName));
                    }
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending index(" + dataverseName + "." + datasetName + "." + indexName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
    }

    protected void handleTypeDropStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        TypeDropStatement stmtTypeDrop = (TypeDropStatement)stmt;
        SourceLocation sourceLoc = stmtTypeDrop.getSourceLocation();
        DataverseName dataverseName = this.getActiveDataverseName(stmtTypeDrop.getDataverseName());
        String typeName = stmtTypeDrop.getTypeName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockUtil.dropTypeBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, typeName);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverseName);
            if (dv == null) {
                if (stmtTypeDrop.getIfExists()) {
                    if (this.warningCollector.shouldWarn()) {
                        this.warningCollector.warn(WarningUtil.forAsterix((SourceLocation)sourceLoc, (int)1063, (Serializable[])new Serializable[]{dataverseName}));
                    }
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(1063, sourceLoc, new Serializable[]{dataverseName});
            }
            Datatype dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, dataverseName, typeName);
            if (dt == null) {
                if (!stmtTypeDrop.getIfExists()) {
                    throw new CompilationException(1082, sourceLoc, new Serializable[]{typeName});
                }
            } else {
                MetadataManager.INSTANCE.dropDatatype(mdTxnCtx, dataverseName, typeName);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleNodegroupDropStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        NodeGroupDropStatement stmtDelete = (NodeGroupDropStatement)stmt;
        SourceLocation sourceLoc = stmtDelete.getSourceLocation();
        String nodegroupName = stmtDelete.getNodeGroupName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockManager.acquireNodeGroupWriteLock(metadataProvider.getLocks(), nodegroupName);
        try {
            NodeGroup ng = MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, nodegroupName);
            if (ng == null) {
                if (!stmtDelete.getIfExists()) {
                    throw new CompilationException(1080, sourceLoc, new Serializable[]{nodegroupName});
                }
            } else {
                MetadataManager.INSTANCE.dropNodegroup(mdTxnCtx, nodegroupName, false);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleDeclareFunctionStatement(Statement stmt) {
        FunctionDecl fds = (FunctionDecl)stmt;
        FunctionSignature signature = fds.getSignature();
        signature.setDataverseName(this.getActiveDataverseName(signature.getDataverseName()));
        this.declaredFunctions.add(fds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCreateFunctionStatement(MetadataProvider metadataProvider, Statement stmt, IStatementRewriter stmtRewriter) throws Exception {
        CreateFunctionStatement cfs = (CreateFunctionStatement)stmt;
        FunctionSignature signature = cfs.getFunctionSignature();
        DataverseName dataverseName = this.getActiveDataverseName(signature.getDataverseName());
        signature.setDataverseName(dataverseName);
        DataverseName libraryDataverseName = null;
        String libraryName = cfs.getLibraryName();
        if (libraryName != null && (libraryDataverseName = cfs.getLibraryDataverseName()) == null) {
            libraryDataverseName = dataverseName;
        }
        this.lockUtil.createFunctionBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, signature.getName(), libraryDataverseName, libraryName);
        try {
            this.doCreateFunction(metadataProvider, cfs, signature, stmtRewriter);
        }
        finally {
            metadataProvider.getLocks().unlock();
            metadataProvider.setDefaultDataverse(this.activeDataverse);
        }
    }

    protected void doCreateFunction(MetadataProvider metadataProvider, CreateFunctionStatement cfs, FunctionSignature functionSignature, IStatementRewriter stmtRewriter) throws Exception {
        DataverseName dataverseName = functionSignature.getDataverseName();
        SourceLocation sourceLoc = cfs.getSourceLocation();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Function function;
            Map newInlineTypes;
            int paramCount;
            List paramList;
            List existingInlineTypes;
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverseName);
            if (dv == null) {
                throw new CompilationException(1063, sourceLoc, new Serializable[]{dataverseName});
            }
            Function existingFunction = MetadataManager.INSTANCE.getFunction(mdTxnCtx, functionSignature);
            if (existingFunction != null) {
                if (cfs.getReplaceIfExists()) {
                    if (cfs.getIfNotExists()) {
                        throw new CompilationException(1001, cfs.getSourceLocation(), new Serializable[]{"IF NOT EXISTS"});
                    }
                } else {
                    if (cfs.getIfNotExists()) {
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        return;
                    }
                    throw new CompilationException(1123, cfs.getSourceLocation(), new Serializable[]{functionSignature.toString(false)});
                }
                existingInlineTypes = TypeUtil.getFunctionInlineTypes((Function)existingFunction);
            } else {
                existingInlineTypes = Collections.emptyList();
            }
            if (cfs.isExternal()) {
                String libraryName;
                Library library;
                DataverseName libraryDataverseName;
                Datatype returnInlineTypeEntity;
                TypeSignature returnDepTypeSignature;
                TypeSignature returnTypeSignature;
                paramList = cfs.getParameters();
                paramCount = paramList.size();
                ArrayList<String> paramNames = new ArrayList<String>(paramCount);
                ArrayList<TypeSignature> paramTypes = new ArrayList<TypeSignature>(paramCount);
                LinkedHashSet depTypes = new LinkedHashSet();
                newInlineTypes = new HashMap<TypeSignature, Datatype>();
                for (int i = 0; i < paramCount; ++i) {
                    Datatype paramInlineTypeEntity;
                    TypeSignature paramDepTypeSignature;
                    TypeSignature paramTypeSignature;
                    Pair paramPair = (Pair)paramList.get(i);
                    TypeExpression paramTypeExpr = (TypeExpression)paramPair.getSecond();
                    if (paramTypeExpr != null) {
                        org.apache.hyracks.algebricks.common.utils.Triple<TypeSignature, TypeSignature, Datatype> paramTypeInfo = this.translateFunctionParameterType(functionSignature, i, paramTypeExpr, sourceLoc, metadataProvider, mdTxnCtx);
                        paramTypeSignature = (TypeSignature)paramTypeInfo.first;
                        paramDepTypeSignature = (TypeSignature)paramTypeInfo.second;
                        paramInlineTypeEntity = (Datatype)paramTypeInfo.third;
                    } else {
                        paramTypeSignature = null;
                        paramDepTypeSignature = null;
                        paramInlineTypeEntity = null;
                    }
                    paramTypes.add(paramTypeSignature);
                    if (paramDepTypeSignature != null) {
                        depTypes.add(paramDepTypeSignature);
                    }
                    if (paramInlineTypeEntity != null) {
                        newInlineTypes.put(paramTypeSignature, paramInlineTypeEntity);
                    }
                    VarIdentifier paramName = (VarIdentifier)paramPair.getFirst();
                    paramNames.add(stmtRewriter.toFunctionParameterName(paramName));
                }
                TypeExpression returnTypeExpr = cfs.getReturnType();
                if (returnTypeExpr != null) {
                    org.apache.hyracks.algebricks.common.utils.Triple<TypeSignature, TypeSignature, Datatype> returnTypeInfo = this.translateFunctionParameterType(functionSignature, -1, returnTypeExpr, sourceLoc, metadataProvider, mdTxnCtx);
                    returnTypeSignature = (TypeSignature)returnTypeInfo.first;
                    returnDepTypeSignature = (TypeSignature)returnTypeInfo.second;
                    returnInlineTypeEntity = (Datatype)returnTypeInfo.third;
                } else {
                    returnTypeSignature = null;
                    returnDepTypeSignature = null;
                    returnInlineTypeEntity = null;
                }
                if (returnDepTypeSignature != null) {
                    depTypes.add(returnDepTypeSignature);
                }
                if (returnInlineTypeEntity != null) {
                    newInlineTypes.put(returnTypeSignature, returnInlineTypeEntity);
                }
                if ((libraryDataverseName = cfs.getLibraryDataverseName()) == null) {
                    libraryDataverseName = dataverseName;
                }
                if ((library = MetadataManager.INSTANCE.getLibrary(mdTxnCtx, libraryDataverseName, libraryName = cfs.getLibraryName())) == null) {
                    throw new CompilationException(1117, sourceLoc, new Serializable[]{libraryName});
                }
                ExternalFunctionLanguage language = ExternalFunctionCompilerUtil.getExternalFunctionLanguage((String)library.getLanguage());
                List externalIdentifier = cfs.getExternalIdentifier();
                ExternalFunctionCompilerUtil.validateExternalIdentifier((List)externalIdentifier, (ExternalFunctionLanguage)language, (SourceLocation)cfs.getSourceLocation());
                List dependencies = FunctionUtil.getExternalFunctionDependencies((Collection)depTypes);
                function = new Function(functionSignature, paramNames, paramTypes, returnTypeSignature, null, AbstractFunctionCallExpression.FunctionKind.SCALAR.toString(), library.getLanguage(), libraryDataverseName, libraryName, externalIdentifier, Boolean.valueOf(cfs.getNullCall()), Boolean.valueOf(cfs.getDeterministic()), cfs.getResources(), dependencies);
            } else {
                paramList = cfs.getParameters();
                paramCount = paramList.size();
                ArrayList<VarIdentifier> paramVars = new ArrayList<VarIdentifier>(paramCount);
                ArrayList<String> paramNames = new ArrayList<String>(paramCount);
                for (Pair paramPair : paramList) {
                    VarIdentifier paramName = (VarIdentifier)paramPair.getFirst();
                    paramVars.add(paramName);
                    paramNames.add(stmtRewriter.toFunctionParameterName(paramName));
                    if (paramPair.getSecond() == null) continue;
                    throw new CompilationException(1038, sourceLoc, new Serializable[]{paramName.toString()});
                }
                metadataProvider.setDefaultDataverse(dv);
                Query wrappedQuery = new Query(false);
                wrappedQuery.setSourceLocation(sourceLoc);
                wrappedQuery.setBody(cfs.getFunctionBodyExpression());
                wrappedQuery.setTopLevel(false);
                this.apiFramework.reWriteQuery(this.declaredFunctions, metadataProvider, (IReturningStatement)wrappedQuery, this.sessionOutput, false, paramVars, (IWarningCollector)this.warningCollector);
                List dependencies = FunctionUtil.getFunctionDependencies((IQueryRewriter)this.rewriterFactory.createQueryRewriter(), (Expression)cfs.getFunctionBodyExpression(), (MetadataProvider)metadataProvider);
                newInlineTypes = Collections.emptyMap();
                function = new Function(functionSignature, paramNames, null, null, cfs.getFunctionBody(), AbstractFunctionCallExpression.FunctionKind.SCALAR.toString(), this.compilationProvider.getParserFactory().getLanguage(), null, null, null, null, null, null, dependencies);
            }
            if (existingFunction == null) {
                for (Datatype newInlineType : newInlineTypes.values()) {
                    MetadataManager.INSTANCE.addDatatype(mdTxnCtx, newInlineType);
                }
                MetadataManager.INSTANCE.addFunction(mdTxnCtx, function);
            } else {
                for (TypeSignature existingInlineType : existingInlineTypes) {
                    Datatype newInlineType;
                    Datatype datatype = newInlineType = newInlineTypes.isEmpty() ? null : (Datatype)newInlineTypes.remove(existingInlineType);
                    if (newInlineType == null) {
                        MetadataManager.INSTANCE.dropDatatype(mdTxnCtx, existingInlineType.getDataverseName(), existingInlineType.getName());
                        continue;
                    }
                    MetadataManager.INSTANCE.updateDatatype(mdTxnCtx, newInlineType);
                }
                for (Datatype inlineType : newInlineTypes.values()) {
                    MetadataManager.INSTANCE.addDatatype(mdTxnCtx, inlineType);
                }
                MetadataManager.INSTANCE.updateFunction(mdTxnCtx, function);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Installed function: " + functionSignature);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    private org.apache.hyracks.algebricks.common.utils.Triple<TypeSignature, TypeSignature, Datatype> translateFunctionParameterType(FunctionSignature functionSignature, int paramIdx, TypeExpression paramTypeExpr, SourceLocation sourceLoc, MetadataProvider metadataProvider, MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        TypeSignature depTypeSignature;
        TypeSignature paramTypeSignature;
        Datatype paramInlineTypeEntity = null;
        switch (paramTypeExpr.getTypeKind()) {
            case TYPEREFERENCE: {
                Datatype paramTypeEntity;
                TypeReferenceExpression paramTypeRefExpr = (TypeReferenceExpression)paramTypeExpr;
                String paramTypeName = ((Identifier)paramTypeRefExpr.getIdent().second).getValue();
                BuiltinType builtinType = BuiltinTypeMap.getBuiltinType((String)paramTypeName);
                if (builtinType != null) {
                    paramTypeSignature = new TypeSignature(builtinType);
                    depTypeSignature = null;
                    break;
                }
                DataverseName paramTypeDataverseName = (DataverseName)paramTypeRefExpr.getIdent().first;
                if (paramTypeDataverseName == null) {
                    paramTypeDataverseName = functionSignature.getDataverseName();
                }
                if ((paramTypeEntity = metadataProvider.findTypeEntity(paramTypeDataverseName, paramTypeName)) == null || paramTypeEntity.getIsAnonymous()) {
                    throw new CompilationException(1082, sourceLoc, new Serializable[]{paramTypeName});
                }
                paramTypeSignature = depTypeSignature = new TypeSignature(paramTypeDataverseName, paramTypeName);
                break;
            }
            case ORDEREDLIST: 
            case UNORDEREDLIST: {
                DataverseName paramTypeDataverseName = functionSignature.getDataverseName();
                String paramTypeName = TypeUtil.createFunctionParameterTypeName((String)functionSignature.getName(), (int)functionSignature.getArity(), (int)paramIdx);
                IAType paramType = this.translateType(paramTypeDataverseName, paramTypeName, paramTypeExpr, mdTxnCtx);
                paramTypeSignature = new TypeSignature(paramTypeDataverseName, paramTypeName);
                depTypeSignature = FunctionUtil.getTypeDependencyFromFunctionParameter((TypeExpression)paramTypeExpr, (DataverseName)paramTypeDataverseName);
                paramInlineTypeEntity = new Datatype(paramTypeDataverseName, paramTypeName, paramType, true);
                break;
            }
            default: {
                throw new CompilationException(1038, sourceLoc, new Serializable[0]);
            }
        }
        return new org.apache.hyracks.algebricks.common.utils.Triple((Object)paramTypeSignature, (Object)depTypeSignature, paramInlineTypeEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFunctionDropStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        FunctionDropStatement stmtDropFunction = (FunctionDropStatement)stmt;
        FunctionSignature signature = stmtDropFunction.getFunctionSignature();
        DataverseName dataverseName = this.getActiveDataverseName(signature.getDataverseName());
        signature.setDataverseName(dataverseName);
        this.lockUtil.dropFunctionBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, signature.getName());
        try {
            this.doDropFunction(metadataProvider, stmtDropFunction, signature);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doDropFunction(MetadataProvider metadataProvider, FunctionDropStatement stmtDropFunction, FunctionSignature signature) throws Exception {
        DataverseName dataverseName = signature.getDataverseName();
        SourceLocation sourceLoc = stmtDropFunction.getSourceLocation();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Dataverse dataverse = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverseName);
            if (dataverse == null) {
                if (stmtDropFunction.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(1063, sourceLoc, new Serializable[]{dataverseName});
            }
            Function function = MetadataManager.INSTANCE.getFunction(mdTxnCtx, signature);
            if (function == null) {
                if (stmtDropFunction.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(1081, sourceLoc, new Serializable[]{signature.toString()});
            }
            List inlineTypes = TypeUtil.getFunctionInlineTypes((Function)function);
            MetadataManager.INSTANCE.dropFunction(mdTxnCtx, signature);
            for (TypeSignature inlineType : inlineTypes) {
                MetadataManager.INSTANCE.dropDatatype(mdTxnCtx, inlineType.getDataverseName(), inlineType.getName());
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateAdapterStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        CreateAdapterStatement cas = (CreateAdapterStatement)stmt;
        DataverseName dataverseName = this.getActiveDataverseName(cas.getDataverseName());
        DataverseName libraryDataverseName = cas.getLibraryDataverseName();
        if (libraryDataverseName == null) {
            libraryDataverseName = dataverseName;
        }
        String libraryName = cas.getLibraryName();
        this.lockUtil.createAdapterBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, cas.getAdapterName(), libraryDataverseName, libraryName);
        try {
            this.doCreateAdapter(metadataProvider, cas);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void doCreateAdapter(MetadataProvider metadataProvider, CreateAdapterStatement cas) throws Exception {
        SourceLocation sourceLoc = cas.getSourceLocation();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            String libraryName;
            Library library;
            DataverseName dataverseName = this.getActiveDataverseName(cas.getDataverseName());
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverseName);
            if (dv == null) {
                throw new CompilationException(1063, sourceLoc, new Serializable[]{dataverseName});
            }
            String adapterName = cas.getAdapterName();
            DatasourceAdapter adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, dataverseName, adapterName);
            if (adapter != null) {
                if (cas.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(1124, sourceLoc, new Serializable[]{adapterName});
            }
            DataverseName libraryDataverseName = cas.getLibraryDataverseName();
            if (libraryDataverseName == null) {
                libraryDataverseName = dataverseName;
            }
            if ((library = MetadataManager.INSTANCE.getLibrary(mdTxnCtx, libraryDataverseName, libraryName = cas.getLibraryName())) == null) {
                throw new CompilationException(1117, sourceLoc, new Serializable[]{libraryName});
            }
            ExternalFunctionLanguage language = ExternalFunctionCompilerUtil.getExternalFunctionLanguage((String)library.getLanguage());
            List externalIdentifier = cas.getExternalIdentifier();
            ExternalFunctionCompilerUtil.validateExternalIdentifier((List)externalIdentifier, (ExternalFunctionLanguage)language, (SourceLocation)cas.getSourceLocation());
            if (language != ExternalFunctionLanguage.JAVA) {
                throw new CompilationException(1127, cas.getSourceLocation(), new Serializable[]{language.name()});
            }
            String adapterFactoryClass = (String)externalIdentifier.get(0);
            adapter = new DatasourceAdapter(new AdapterIdentifier(dataverseName, adapterName), IDataSourceAdapter.AdapterType.EXTERNAL, adapterFactoryClass, libraryDataverseName, libraryName);
            MetadataManager.INSTANCE.addAdapter(mdTxnCtx, adapter);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Installed adapter: " + adapterName);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAdapterDropStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        AdapterDropStatement stmtDropAdapter = (AdapterDropStatement)stmt;
        DataverseName dataverseName = this.getActiveDataverseName(stmtDropAdapter.getDataverseName());
        String adapterName = stmtDropAdapter.getAdapterName();
        this.lockUtil.dropAdapterBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, adapterName);
        try {
            this.doDropAdapter(metadataProvider, stmtDropAdapter, dataverseName, adapterName);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doDropAdapter(MetadataProvider metadataProvider, AdapterDropStatement stmtDropAdapter, DataverseName dataverseName, String adapterName) throws Exception {
        SourceLocation sourceLoc = stmtDropAdapter.getSourceLocation();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Dataverse dataverse = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverseName);
            if (dataverse == null) {
                if (stmtDropAdapter.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(1063, sourceLoc, new Serializable[]{dataverseName});
            }
            DatasourceAdapter adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, dataverseName, adapterName);
            if (adapter == null) {
                if (stmtDropAdapter.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(1125, sourceLoc, new Serializable[]{adapterName});
            }
            MetadataManager.INSTANCE.dropAdapter(mdTxnCtx, dataverseName, adapterName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateLibraryStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        CreateLibraryStatement cls = (CreateLibraryStatement)stmt;
        DataverseName dataverseName = this.getActiveDataverseName(cls.getDataverseName());
        String libraryName = cls.getLibraryName();
        this.lockUtil.createLibraryBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, libraryName);
        try {
            this.doCreateLibrary(metadataProvider, dataverseName, libraryName, cls, hcc);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    private void doCreateLibrary(MetadataProvider metadataProvider, DataverseName dataverseName, String libraryName, CreateLibraryStatement cls, IHyracksClientConnection hcc) throws Exception {
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        boolean prepareJobSuccessful = false;
        JobSpecification abortJobSpec = null;
        Library existingLibrary = null;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverseName);
            if (dv == null) {
                throw new CompilationException(1063, new Serializable[]{dataverseName});
            }
            ExternalFunctionLanguage language = cls.getLang();
            existingLibrary = MetadataManager.INSTANCE.getLibrary(mdTxnCtx, dataverseName, libraryName);
            if (existingLibrary != null && !cls.getReplaceIfExists()) {
                throw new CompilationException(1079, new Serializable[]{"A library with this name " + libraryName + " already exists."});
            }
            Library libraryPendingAdd = new Library(dataverseName, libraryName, language.name(), 1);
            if (existingLibrary == null) {
                MetadataManager.INSTANCE.addLibrary(mdTxnCtx, libraryPendingAdd);
            } else {
                MetadataManager.INSTANCE.updateLibrary(mdTxnCtx, libraryPendingAdd);
            }
            org.apache.hyracks.algebricks.common.utils.Triple<JobSpecification, JobSpecification, JobSpecification> jobSpecs = ExternalLibraryUtil.buildCreateLibraryJobSpec(dataverseName, libraryName, language, cls.getLocation(), cls.getAuthToken(), metadataProvider);
            JobSpecification prepareJobSpec = (JobSpecification)jobSpecs.first;
            JobSpecification commitJobSpec = (JobSpecification)jobSpecs.second;
            abortJobSpec = (JobSpecification)jobSpecs.third;
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
            QueryTranslator.runJob(hcc, prepareJobSpec, this.jobFlags);
            prepareJobSuccessful = true;
            QueryTranslator.runJob(hcc, commitJobSpec, this.jobFlags);
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            Library newLibrary = new Library(dataverseName, libraryName, language.name(), 0);
            MetadataManager.INSTANCE.updateLibrary(mdTxnCtx, newLibrary);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                boolean undoFailure = false;
                if (!prepareJobSuccessful) {
                    try {
                        QueryTranslator.runJob(hcc, abortJobSpec, this.jobFlags);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        undoFailure = true;
                    }
                } else if (existingLibrary == null) {
                    try {
                        JobSpecification dropLibraryJobSpec = ExternalLibraryUtil.buildDropLibraryJobSpec(dataverseName, libraryName, metadataProvider);
                        QueryTranslator.runJob(hcc, dropLibraryJobSpec, this.jobFlags);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        undoFailure = true;
                    }
                } else {
                    undoFailure = true;
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                try {
                    if (existingLibrary == null) {
                        MetadataManager.INSTANCE.dropLibrary(mdTxnCtx, dataverseName, libraryName);
                    } else {
                        MetadataManager.INSTANCE.updateLibrary(mdTxnCtx, existingLibrary);
                    }
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending library(" + libraryName + ") couldn't be reverted/removed from the metadata", e);
                }
                if (undoFailure) {
                    throw new IllegalStateException("System is inconsistent state: library(" + libraryName + ") couldn't be deployed", e);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLibraryDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        LibraryDropStatement stmtDropLibrary = (LibraryDropStatement)stmt;
        DataverseName dataverseName = this.getActiveDataverseName(stmtDropLibrary.getDataverseName());
        String libraryName = stmtDropLibrary.getLibraryName();
        this.lockUtil.dropLibraryBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, libraryName);
        try {
            this.doDropLibrary(metadataProvider, stmtDropLibrary, dataverseName, libraryName, hcc);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doDropLibrary(MetadataProvider metadataProvider, LibraryDropStatement stmtDropLibrary, DataverseName dataverseName, String libraryName, IHyracksClientConnection hcc) throws Exception {
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Dataverse dataverse = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverseName);
            if (dataverse == null) {
                if (stmtDropLibrary.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(1063, stmtDropLibrary.getSourceLocation(), new Serializable[]{dataverseName});
            }
            Library library = MetadataManager.INSTANCE.getLibrary(mdTxnCtx, dataverseName, libraryName);
            if (library == null) {
                if (stmtDropLibrary.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(1117, stmtDropLibrary.getSourceLocation(), new Serializable[]{libraryName});
            }
            MetadataManager.INSTANCE.dropLibrary(mdTxnCtx, dataverseName, libraryName);
            MetadataManager.INSTANCE.addLibrary(mdTxnCtx, new Library(dataverseName, libraryName, library.getLanguage(), 2));
            JobSpecification jobSpec = ExternalLibraryUtil.buildDropLibraryJobSpec(dataverseName, libraryName, metadataProvider);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
            QueryTranslator.runJob(hcc, jobSpec, this.jobFlags);
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            MetadataManager.INSTANCE.dropLibrary(mdTxnCtx, dataverseName, libraryName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                try {
                    MetadataManager.INSTANCE.dropLibrary(mdTxnCtx, dataverseName, libraryName);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending library(" + libraryName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateSynonymStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        CreateSynonymStatement css = (CreateSynonymStatement)stmt;
        DataverseName dataverseName = this.getActiveDataverseName(css.getDataverseName());
        String synonymName = css.getSynonymName();
        DataverseName objectDataverseName = this.getActiveDataverseName(css.getObjectDataverseName());
        String objectName = css.getObjectName();
        this.lockUtil.createSynonymBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, synonymName);
        try {
            this.doCreateSynonym(metadataProvider, css, dataverseName, synonymName, objectDataverseName, objectName);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void doCreateSynonym(MetadataProvider metadataProvider, CreateSynonymStatement css, DataverseName dataverseName, String synonymName, DataverseName objectDataverseName, String objectName) throws Exception {
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Synonym synonym = MetadataManager.INSTANCE.getSynonym(metadataProvider.getMetadataTxnContext(), dataverseName, synonymName);
            if (synonym != null) {
                if (css.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(1115, css.getSourceLocation(), new Serializable[]{synonymName});
            }
            synonym = new Synonym(dataverseName, synonymName, objectDataverseName, objectName);
            MetadataManager.INSTANCE.addSynonym(metadataProvider.getMetadataTxnContext(), synonym);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDropSynonymStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        SynonymDropStatement stmtSynDrop = (SynonymDropStatement)stmt;
        DataverseName dataverseName = this.getActiveDataverseName(stmtSynDrop.getDataverseName());
        String synonymName = stmtSynDrop.getSynonymName();
        this.lockUtil.dropSynonymBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, synonymName);
        try {
            this.doDropSynonym(metadataProvider, stmtSynDrop, dataverseName, synonymName);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected boolean doDropSynonym(MetadataProvider metadataProvider, SynonymDropStatement stmtSynDrop, DataverseName dataverseName, String synonymName) throws Exception {
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            Synonym synonym = MetadataManager.INSTANCE.getSynonym(mdTxnCtx, dataverseName, synonymName);
            if (synonym == null) {
                if (stmtSynDrop.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return false;
                }
                throw new CompilationException(1116, stmtSynDrop.getSourceLocation(), new Serializable[]{synonymName});
            }
            MetadataManager.INSTANCE.dropSynonym(mdTxnCtx, dataverseName, synonymName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            return true;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    protected void handleLoadStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        LoadStatement loadStmt = (LoadStatement)stmt;
        DataverseName dataverseName = this.getActiveDataverseName(loadStmt.getDataverseName());
        String datasetName = loadStmt.getDatasetName();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockUtil.modifyDatasetBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, datasetName);
        try {
            Map properties = loadStmt.getProperties();
            ExternalDataUtils.normalize((Map)properties);
            ExternalDataUtils.validate((Map)properties);
            CompiledStatements.CompiledLoadFromFileStatement cls = new CompiledStatements.CompiledLoadFromFileStatement(dataverseName, loadStmt.getDatasetName(), loadStmt.getAdapter(), properties, loadStmt.dataIsAlreadySorted());
            cls.setSourceLocation(stmt.getSourceLocation());
            JobSpecification spec = this.apiFramework.compileQuery((IClusterInfoCollector)hcc, metadataProvider, null, 0, null, this.sessionOutput, (CompiledStatements.ICompiledDmlStatement)cls, null, this.responsePrinter, (IWarningCollector)this.warningCollector);
            this.afterCompile();
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            if (spec != null) {
                this.runJob(hcc, spec);
            }
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobSpecification handleInsertUpsertStatement(final MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IResultSet resultSet, IStatementExecutor.ResultDelivery resultDelivery, IStatementExecutor.ResultMetadata outMetadata, IStatementExecutor.Stats stats, boolean compileOnly, IRequestParameters requestParameters, Map<String, IAObject> stmtParams, IStatementRewriter stmtRewriter) throws Exception {
        final InsertStatement stmtInsertUpsert = (InsertStatement)stmt;
        final DataverseName dataverseName = this.getActiveDataverseName(stmtInsertUpsert.getDataverseName());
        IMetadataLocker locker = new IMetadataLocker(){

            @Override
            public void lock() throws AlgebricksException {
                QueryTranslator.this.lockUtil.insertDeleteUpsertBegin(QueryTranslator.this.lockManager, metadataProvider.getLocks(), dataverseName, stmtInsertUpsert.getDatasetName());
            }

            @Override
            public void unlock() {
                metadataProvider.getLocks().unlock();
            }
        };
        IStatementCompiler compiler = () -> {
            MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            boolean bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            try {
                metadataProvider.setWriteTransaction(true);
                JobSpecification jobSpec = this.rewriteCompileInsertUpsert((IClusterInfoCollector)hcc, metadataProvider, stmtInsertUpsert, stmtParams, stmtRewriter);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                return jobSpec;
            }
            catch (Exception e) {
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                throw e;
            }
        };
        if (compileOnly) {
            locker.lock();
            try {
                JobSpecification jobSpecification = compiler.compile();
                return jobSpecification;
            }
            finally {
                locker.unlock();
            }
        }
        if (stmtInsertUpsert.getReturnExpression() != null) {
            this.deliverResult(hcc, resultSet, compiler, metadataProvider, locker, resultDelivery, outMetadata, stats, requestParameters, false);
        } else {
            locker.lock();
            try {
                JobSpecification jobSpec = compiler.compile();
                if (jobSpec == null) {
                    JobSpecification jobSpecification = jobSpec;
                    return jobSpecification;
                }
                this.runJob(hcc, jobSpec);
            }
            finally {
                locker.unlock();
            }
        }
        return null;
    }

    public JobSpecification handleDeleteStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, boolean compileOnly, Map<String, IAObject> stmtParams, IStatementRewriter stmtRewriter) throws Exception {
        DeleteStatement stmtDelete = (DeleteStatement)stmt;
        DataverseName dataverseName = this.getActiveDataverseName(stmtDelete.getDataverseName());
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockUtil.insertDeleteUpsertBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, stmtDelete.getDatasetName());
        try {
            metadataProvider.setWriteTransaction(true);
            CompiledStatements.CompiledDeleteStatement clfrqs = new CompiledStatements.CompiledDeleteStatement(stmtDelete.getVariableExpr(), dataverseName, stmtDelete.getDatasetName(), stmtDelete.getCondition(), stmtDelete.getVarCounter(), stmtDelete.getQuery());
            clfrqs.setSourceLocation(stmt.getSourceLocation());
            JobSpecification jobSpec = this.rewriteCompileQuery((IClusterInfoCollector)hcc, metadataProvider, clfrqs.getQuery(), (CompiledStatements.ICompiledDmlStatement)clfrqs, stmtParams, stmtRewriter);
            this.afterCompile();
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            if (jobSpec != null && !compileOnly) {
                this.runJob(hcc, jobSpec);
            }
            JobSpecification jobSpecification = jobSpec;
            return jobSpecification;
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    public JobSpecification rewriteCompileQuery(IClusterInfoCollector clusterInfoCollector, MetadataProvider metadataProvider, Query query, CompiledStatements.ICompiledDmlStatement stmt, Map<String, IAObject> stmtParams, IStatementRewriter stmtRewriter) throws AlgebricksException, ACIDException {
        Map<VarIdentifier, IAObject> externalVars = this.createExternalVariables(stmtParams, stmtRewriter);
        Pair<IReturningStatement, Integer> rewrittenResult = this.apiFramework.reWriteQuery(this.declaredFunctions, metadataProvider, (IReturningStatement)query, this.sessionOutput, true, externalVars.keySet(), (IWarningCollector)this.warningCollector);
        return this.apiFramework.compileQuery(clusterInfoCollector, metadataProvider, (Query)rewrittenResult.first, (Integer)rewrittenResult.second, stmt == null ? null : stmt.getDatasetName(), this.sessionOutput, stmt, externalVars, this.responsePrinter, (IWarningCollector)this.warningCollector);
    }

    private JobSpecification rewriteCompileInsertUpsert(IClusterInfoCollector clusterInfoCollector, MetadataProvider metadataProvider, InsertStatement insertUpsert, Map<String, IAObject> stmtParams, IStatementRewriter stmtRewriter) throws AlgebricksException, ACIDException {
        CompiledStatements.CompiledInsertStatement clfrqs;
        SourceLocation sourceLoc = insertUpsert.getSourceLocation();
        Map<VarIdentifier, IAObject> externalVars = this.createExternalVariables(stmtParams, stmtRewriter);
        Pair<IReturningStatement, Integer> rewrittenResult = this.apiFramework.reWriteQuery(this.declaredFunctions, metadataProvider, (IReturningStatement)insertUpsert, this.sessionOutput, true, externalVars.keySet(), (IWarningCollector)this.warningCollector);
        InsertStatement rewrittenInsertUpsert = (InsertStatement)rewrittenResult.first;
        DataverseName dataverseName = this.getActiveDataverseName(rewrittenInsertUpsert.getDataverseName());
        String datasetName = rewrittenInsertUpsert.getDatasetName();
        switch (insertUpsert.getKind()) {
            case INSERT: {
                clfrqs = new CompiledStatements.CompiledInsertStatement(dataverseName, datasetName, rewrittenInsertUpsert.getQuery(), rewrittenInsertUpsert.getVarCounter(), rewrittenInsertUpsert.getVar(), rewrittenInsertUpsert.getReturnExpression());
                clfrqs.setSourceLocation(insertUpsert.getSourceLocation());
                break;
            }
            case UPSERT: {
                clfrqs = new CompiledStatements.CompiledUpsertStatement(dataverseName, datasetName, rewrittenInsertUpsert.getQuery(), rewrittenInsertUpsert.getVarCounter(), rewrittenInsertUpsert.getVar(), rewrittenInsertUpsert.getReturnExpression());
                clfrqs.setSourceLocation(insertUpsert.getSourceLocation());
                break;
            }
            default: {
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"Unsupported statement type " + rewrittenInsertUpsert.getKind()});
            }
        }
        return this.apiFramework.compileQuery(clusterInfoCollector, metadataProvider, rewrittenInsertUpsert.getQuery(), (Integer)rewrittenResult.second, datasetName, this.sessionOutput, (CompiledStatements.ICompiledDmlStatement)clfrqs, externalVars, this.responsePrinter, (IWarningCollector)this.warningCollector);
    }

    protected void handleCreateFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        CreateFeedStatement cfs = (CreateFeedStatement)stmt;
        SourceLocation sourceLoc = cfs.getSourceLocation();
        DataverseName dataverseName = this.getActiveDataverseName(cfs.getDataverseName());
        String feedName = cfs.getFeedName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockUtil.createFeedBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, feedName);
        try {
            Feed feed = MetadataManager.INSTANCE.getFeed(metadataProvider.getMetadataTxnContext(), dataverseName, feedName);
            if (feed != null) {
                if (cfs.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"A feed with this name " + feedName + " already exists."});
            }
            Map configuration = cfs.getConfiguration();
            ExternalDataUtils.normalize((Map)configuration);
            ExternalDataUtils.validate((Map)configuration);
            feed = new Feed(dataverseName, feedName, configuration);
            FeedMetadataUtil.validateFeed((Feed)feed, (MetadataTransactionContext)mdTxnCtx, (ICcApplicationContext)this.appCtx, (IWarningCollector)this.warningCollector);
            MetadataManager.INSTANCE.addFeed(metadataProvider.getMetadataTxnContext(), feed);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleCreateFeedPolicyStatement(MetadataProvider metadataProvider, Statement stmt) throws AlgebricksException, HyracksDataException {
        MetadataTransactionContext mdTxnCtx = null;
        CreateFeedPolicyStatement cfps = (CreateFeedPolicyStatement)stmt;
        SourceLocation sourceLoc = cfps.getSourceLocation();
        DataverseName dataverseName = this.getActiveDataverseName(null);
        String policyName = cfps.getPolicyName();
        this.lockUtil.createFeedPolicyBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, policyName);
        try {
            FeedPolicyEntity newPolicy;
            String description;
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            FeedPolicyEntity feedPolicy = MetadataManager.INSTANCE.getFeedPolicy(metadataProvider.getMetadataTxnContext(), dataverseName, policyName);
            if (feedPolicy != null) {
                if (cfps.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"A policy with this name " + policyName + " already exists."});
            }
            boolean extendingExisting = cfps.getSourcePolicyName() != null;
            String string = description = cfps.getDescription() == null ? "" : cfps.getDescription();
            if (extendingExisting) {
                FeedPolicyEntity sourceFeedPolicy = MetadataManager.INSTANCE.getFeedPolicy(metadataProvider.getMetadataTxnContext(), dataverseName, cfps.getSourcePolicyName());
                if (sourceFeedPolicy == null && (sourceFeedPolicy = MetadataManager.INSTANCE.getFeedPolicy(metadataProvider.getMetadataTxnContext(), MetadataConstants.METADATA_DATAVERSE_NAME, cfps.getSourcePolicyName())) == null) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"Unknown policy " + cfps.getSourcePolicyName()});
                }
                Map policyProperties = sourceFeedPolicy.getProperties();
                policyProperties.putAll(cfps.getProperties());
                newPolicy = new FeedPolicyEntity(dataverseName, policyName, description, policyProperties);
            } else {
                Properties prop = new Properties();
                try {
                    FileInputStream stream = new FileInputStream(cfps.getSourcePolicyFile());
                    prop.load(stream);
                }
                catch (Exception e) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"Unable to read policy file" + cfps.getSourcePolicyFile(), e});
                }
                HashMap policyProperties = new HashMap();
                prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> policyProperties.put((String)key, (String)value)));
                newPolicy = new FeedPolicyEntity(dataverseName, policyName, description, policyProperties);
            }
            MetadataManager.INSTANCE.addFeedPolicy(mdTxnCtx, newPolicy);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (RemoteException | ACIDException e) {
            QueryTranslator.abort((Exception)e, (Exception)e, mdTxnCtx);
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleDropFeedStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        FeedDropStatement stmtFeedDrop = (FeedDropStatement)stmt;
        SourceLocation sourceLoc = stmtFeedDrop.getSourceLocation();
        DataverseName dataverseName = this.getActiveDataverseName(stmtFeedDrop.getDataverseName());
        String feedName = stmtFeedDrop.getFeedName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockUtil.dropFeedBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, feedName);
        try {
            Feed feed = MetadataManager.INSTANCE.getFeed(mdTxnCtx, dataverseName, feedName);
            if (feed == null) {
                if (!stmtFeedDrop.getIfExists()) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"There is no feed with this name " + feedName + "."});
                }
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                return;
            }
            this.doDropFeed(hcc, metadataProvider, feed, sourceLoc);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void doDropFeed(IHyracksClientConnection hcc, MetadataProvider metadataProvider, Feed feed, SourceLocation sourceLoc) throws Exception {
        MetadataTransactionContext mdTxnCtx = metadataProvider.getMetadataTxnContext();
        EntityId feedId = feed.getFeedId();
        ActiveNotificationHandler activeNotificationHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
        ActiveEntityEventsListener listener = (ActiveEntityEventsListener)activeNotificationHandler.getListener(feedId);
        if (listener != null && listener.getState() != ActivityState.STOPPED) {
            throw new CompilationException(1079, sourceLoc, new Serializable[]{"Feed " + feedId + " is currently active and connected to the following dataset(s) \n" + listener.toString()});
        }
        if (listener != null) {
            listener.unregister();
        }
        JobSpecification spec = FeedOperations.buildRemoveFeedStorageJob(metadataProvider, MetadataManager.INSTANCE.getFeed(mdTxnCtx, feedId.getDataverseName(), feedId.getEntityName()));
        this.runJob(hcc, spec);
        MetadataManager.INSTANCE.dropFeed(mdTxnCtx, feed.getDataverseName(), feed.getFeedName());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Removed feed " + feedId);
        }
    }

    protected void handleDropFeedPolicyStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        FeedPolicyDropStatement stmtFeedPolicyDrop = (FeedPolicyDropStatement)stmt;
        SourceLocation sourceLoc = stmtFeedPolicyDrop.getSourceLocation();
        DataverseName dataverseName = this.getActiveDataverseName(stmtFeedPolicyDrop.getDataverseName());
        String policyName = stmtFeedPolicyDrop.getPolicyName().getValue();
        this.lockUtil.dropFeedPolicyBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, policyName);
        try {
            FeedPolicyEntity feedPolicy = MetadataManager.INSTANCE.getFeedPolicy(mdTxnCtx, dataverseName, policyName);
            if (feedPolicy == null) {
                if (!stmtFeedPolicyDrop.getIfExists()) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"Unknown policy " + policyName + " in dataverse " + dataverseName});
                }
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                return;
            }
            MetadataManager.INSTANCE.dropFeedPolicy(mdTxnCtx, dataverseName, policyName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleStartFeedStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        StartFeedStatement sfs = (StartFeedStatement)stmt;
        SourceLocation sourceLoc = sfs.getSourceLocation();
        DataverseName dataverseName = this.getActiveDataverseName(sfs.getDataverseName());
        String feedName = sfs.getFeedName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean committed = false;
        this.lockUtil.startFeedBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, feedName);
        try {
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            EntityId entityId = new EntityId("Feed", dataverseName, feedName);
            Feed feed = FeedMetadataUtil.validateIfFeedExists((DataverseName)dataverseName, (String)feedName, (MetadataTransactionContext)metadataProvider.getMetadataTxnContext());
            List feedConnections = MetadataManager.INSTANCE.getFeedConections(metadataProvider.getMetadataTxnContext(), dataverseName, feedName);
            if (feedConnections.isEmpty()) {
                throw new CompilationException(3111, sourceLoc, new Serializable[]{feedName});
            }
            for (FeedConnection feedConnection : feedConnections) {
                this.lockManager.acquireDatasetReadLock(metadataProvider.getLocks(), feedConnection.getDataverseName(), feedConnection.getDatasetName());
            }
            ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
            ActiveEntityEventsListener listener = (ActiveEntityEventsListener)activeEventHandler.getListener(entityId);
            if (listener == null) {
                ArrayList<Dataset> datasets = new ArrayList<Dataset>();
                for (FeedConnection connection : feedConnections) {
                    Dataset ds = metadataProvider.findDataset(connection.getDataverseName(), connection.getDatasetName());
                    datasets.add(ds);
                }
                listener = new FeedEventsListener(this, metadataProvider.getApplicationContext(), hcc, entityId, datasets, null, FeedIntakeOperatorNodePushable.class.getSimpleName(), (IRetryPolicyFactory)NoRetryPolicyFactory.INSTANCE, feed, feedConnections, this.compilationProvider.getLanguage());
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            committed = true;
            listener.start(metadataProvider);
        }
        catch (Exception e) {
            if (!committed) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleStopFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        StopFeedStatement sfst = (StopFeedStatement)stmt;
        SourceLocation sourceLoc = sfst.getSourceLocation();
        DataverseName dataverseName = this.getActiveDataverseName(sfst.getDataverseName());
        String feedName = sfst.getFeedName().getValue();
        EntityId entityId = new EntityId("Feed", dataverseName, feedName);
        ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
        ActiveEntityEventsListener listener = (ActiveEntityEventsListener)activeEventHandler.getListener(entityId);
        if (listener == null) {
            throw new CompilationException(1079, sourceLoc, new Serializable[]{"Feed " + feedName + " is not started."});
        }
        this.lockUtil.stopFeedBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, feedName);
        try {
            listener.stop(metadataProvider);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    private void handleConnectFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        ConnectFeedStatement cfs = (ConnectFeedStatement)stmt;
        SourceLocation sourceLoc = cfs.getSourceLocation();
        DataverseName dataverseName = this.getActiveDataverseName(cfs.getDataverseName());
        String feedName = cfs.getFeedName();
        String datasetName = cfs.getDatasetName().getValue();
        String policyName = cfs.getPolicy();
        String whereClauseBody = cfs.getWhereClauseBody();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
        this.lockUtil.connectFeedBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, datasetName, feedName);
        try {
            Dataset dataset = FeedMetadataUtil.validateIfDatasetExists((MetadataProvider)metadataProvider, (DataverseName)dataverseName, (String)datasetName);
            Feed feed = FeedMetadataUtil.validateIfFeedExists((DataverseName)dataverseName, (String)feedName, (MetadataTransactionContext)metadataProvider.getMetadataTxnContext());
            FeedEventsListener listener = (FeedEventsListener)activeEventHandler.getListener(feed.getFeedId());
            if (listener != null && listener.isActive()) {
                throw new CompilationException(3020, sourceLoc, new Serializable[]{feedName});
            }
            ARecordType outputType = FeedMetadataUtil.getOutputType((IFeed)feed, (String)((String)feed.getConfiguration().get("type-name")));
            List appliedFunctions = cfs.getAppliedFunctions();
            for (FunctionSignature func : appliedFunctions) {
                if (MetadataManager.INSTANCE.getFunction(mdTxnCtx, func) != null) continue;
                throw new CompilationException(3087, sourceLoc, new Serializable[]{func.getName()});
            }
            FeedConnection fc = MetadataManager.INSTANCE.getFeedConnection(metadataProvider.getMetadataTxnContext(), dataverseName, feedName, datasetName);
            if (fc != null) {
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"Feed" + feedName + " is already connected dataset " + datasetName});
            }
            fc = new FeedConnection(dataverseName, feedName, datasetName, appliedFunctions, policyName, whereClauseBody, outputType.getTypeName());
            MetadataManager.INSTANCE.addFeedConnection(metadataProvider.getMetadataTxnContext(), fc);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            if (listener != null) {
                listener.add(dataset);
                listener.addFeedConnection(fc);
            }
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleDisconnectFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        DisconnectFeedStatement cfs = (DisconnectFeedStatement)stmt;
        SourceLocation sourceLoc = cfs.getSourceLocation();
        DataverseName dataverseName = this.getActiveDataverseName(cfs.getDataverseName());
        String datasetName = cfs.getDatasetName().getValue();
        String feedName = cfs.getFeedName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockUtil.disconnectFeedBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, datasetName, feedName);
        try {
            ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
            ActiveEntityEventsListener listener = (ActiveEntityEventsListener)activeEventHandler.getListener(new EntityId("Feed", dataverseName, feedName));
            if (listener != null && listener.isActive()) {
                throw new CompilationException(3020, sourceLoc, new Serializable[]{feedName});
            }
            FeedMetadataUtil.validateIfDatasetExists((MetadataProvider)metadataProvider, (DataverseName)dataverseName, (String)cfs.getDatasetName().getValue());
            FeedMetadataUtil.validateIfFeedExists((DataverseName)dataverseName, (String)cfs.getFeedName().getValue(), (MetadataTransactionContext)mdTxnCtx);
            FeedConnection fc = MetadataManager.INSTANCE.getFeedConnection(metadataProvider.getMetadataTxnContext(), dataverseName, feedName, datasetName);
            Dataset ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds == null) {
                throw new CompilationException(1050, sourceLoc, new Serializable[]{datasetName, dataverseName});
            }
            if (fc == null) {
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"Feed " + feedName + " is currently not connected to " + cfs.getDatasetName().getValue() + ". Invalid operation!"});
            }
            MetadataManager.INSTANCE.dropFeedConnection(mdTxnCtx, dataverseName, feedName, datasetName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            if (listener != null) {
                listener.remove(ds);
            }
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleCompactStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        CompactStatement compactStatement = (CompactStatement)stmt;
        SourceLocation sourceLoc = compactStatement.getSourceLocation();
        DataverseName dataverseName = this.getActiveDataverseName(compactStatement.getDataverseName());
        String datasetName = compactStatement.getDatasetName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        ArrayList<JobSpecification> jobsToExecute = new ArrayList<JobSpecification>();
        this.lockUtil.compactBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, datasetName);
        try {
            Dataset ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds == null) {
                throw new CompilationException(1050, sourceLoc, new Serializable[]{datasetName, dataverseName});
            }
            List indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName);
            if (indexes.isEmpty()) {
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"Cannot compact the extrenal dataset " + datasetName + " because it has no indexes"});
            }
            Dataverse dataverse = MetadataManager.INSTANCE.getDataverse(metadataProvider.getMetadataTxnContext(), dataverseName);
            jobsToExecute.add(DatasetUtil.compactDatasetJobSpec((Dataverse)dataverse, (String)datasetName, (MetadataProvider)metadataProvider));
            if (ds.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                for (Index index : indexes) {
                    if (!index.isSecondaryIndex()) continue;
                    jobsToExecute.add(IndexUtil.buildSecondaryIndexCompactJobSpec((Dataset)ds, (Index)index, (MetadataProvider)metadataProvider, (SourceLocation)sourceLoc));
                }
            } else {
                this.prepareCompactJobsForExternalDataset(indexes, ds, jobsToExecute, metadataProvider, sourceLoc);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            for (JobSpecification jobSpec : jobsToExecute) {
                this.runJob(hcc, jobSpec);
            }
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
            ExternalDatasetsRegistry.INSTANCE.releaseAcquiredLocks(metadataProvider);
        }
    }

    protected void prepareCompactJobsForExternalDataset(List<Index> indexes, Dataset ds, List<JobSpecification> jobsToExecute, MetadataProvider metadataProvider, SourceLocation sourceLoc) throws AlgebricksException {
        for (int j = 0; j < indexes.size(); ++j) {
            jobsToExecute.add(IndexUtil.buildSecondaryIndexCompactJobSpec((Dataset)ds, (Index)indexes.get(j), (MetadataProvider)metadataProvider, (SourceLocation)sourceLoc));
        }
    }

    protected void handleQuery(final MetadataProvider metadataProvider, Query query, IHyracksClientConnection hcc, IResultSet resultSet, IStatementExecutor.ResultDelivery resultDelivery, IStatementExecutor.ResultMetadata outMetadata, IStatementExecutor.Stats stats, IRequestParameters requestParameters, Map<String, IAObject> stmtParams, IStatementRewriter stmtRewriter) throws Exception {
        IMetadataLocker locker = new IMetadataLocker(){

            @Override
            public void lock() {
            }

            @Override
            public void unlock() {
                metadataProvider.getLocks().unlock();
                ExternalDatasetsRegistry.INSTANCE.releaseAcquiredLocks(metadataProvider);
            }
        };
        IStatementCompiler compiler = () -> {
            MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            boolean bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            try {
                JobSpecification jobSpec = this.rewriteCompileQuery((IClusterInfoCollector)hcc, metadataProvider, query, null, stmtParams, stmtRewriter);
                stats.updateTotalWarningsCount(this.warningCollector.getTotalWarningsCount());
                this.afterCompile();
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                return query.isExplain() || !this.sessionConfig.isExecuteQuery() ? null : jobSpec;
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, e.getMessage(), (Throwable)e);
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                throw e;
            }
        };
        this.deliverResult(hcc, resultSet, compiler, metadataProvider, locker, resultDelivery, outMetadata, stats, requestParameters, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverResult(IHyracksClientConnection hcc, IResultSet resultSet, IStatementCompiler compiler, MetadataProvider metadataProvider, IMetadataLocker locker, IStatementExecutor.ResultDelivery resultDelivery, IStatementExecutor.ResultMetadata outMetadata, IStatementExecutor.Stats stats, IRequestParameters requestParameters, boolean cancellable) throws Exception {
        ResultSetId resultSetId = metadataProvider.getResultSetId();
        switch (resultDelivery) {
            case ASYNC: {
                MutableBoolean printed = new MutableBoolean(false);
                this.executorService.submit(() -> this.asyncCreateAndRunJob(hcc, compiler, locker, resultDelivery, requestParameters, cancellable, resultSetId, printed, metadataProvider));
                MutableBoolean mutableBoolean = printed;
                synchronized (mutableBoolean) {
                    while (!printed.booleanValue()) {
                        printed.wait();
                    }
                    break;
                }
            }
            case IMMEDIATE: {
                QueryTranslator.createAndRunJob(hcc, this.jobFlags, null, compiler, locker, resultDelivery, id -> {
                    ResultReader resultReader = new ResultReader(resultSet, id, resultSetId);
                    this.updateJobStats(id, stats, metadataProvider.getResultSetId());
                    this.responsePrinter.addResultPrinter((IResponseFieldPrinter)new ResultsPrinter((IApplicationContext)this.appCtx, resultReader, metadataProvider.findOutputRecordType(), stats, this.sessionOutput));
                    this.responsePrinter.printResults();
                }, requestParameters, cancellable, this.appCtx, metadataProvider);
                break;
            }
            case DEFERRED: {
                QueryTranslator.createAndRunJob(hcc, this.jobFlags, null, compiler, locker, resultDelivery, id -> {
                    this.updateJobStats(id, stats, metadataProvider.getResultSetId());
                    this.responsePrinter.addResultPrinter((IResponseFieldPrinter)new ResultHandlePrinter(this.sessionOutput, new ResultHandle(id, resultSetId)));
                    this.responsePrinter.printResults();
                    if (outMetadata != null) {
                        outMetadata.getResultSets().add(Triple.of((Object)id, (Object)resultSetId, (Object)metadataProvider.findOutputRecordType()));
                    }
                }, requestParameters, cancellable, this.appCtx, metadataProvider);
                break;
            }
        }
    }

    private void updateJobStats(JobId jobId, IStatementExecutor.Stats stats, ResultSetId rsId) throws HyracksDataException {
        ClusterControllerService controllerService = (ClusterControllerService)this.appCtx.getServiceContext().getControllerService();
        ResultMetadata resultMetadata = (ResultMetadata)controllerService.getResultDirectoryService().getResultMetadata(jobId, rsId);
        stats.setProcessedObjects(resultMetadata.getProcessedObjects());
        if (this.jobFlags.contains(JobFlag.PROFILE_RUNTIME)) {
            stats.setJobProfile(resultMetadata.getJobProfile());
        }
        stats.updateTotalWarningsCount(resultMetadata.getTotalWarningsCount());
        WarningUtil.mergeWarnings(resultMetadata.getWarnings(), (IWarningCollector)this.warningCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncCreateAndRunJob(IHyracksClientConnection hcc, IStatementCompiler compiler, IMetadataLocker locker, IStatementExecutor.ResultDelivery resultDelivery, IRequestParameters requestParameters, boolean cancellable, ResultSetId resultSetId, MutableBoolean printed, MetadataProvider metadataProvider) {
        MutableObject jobId = new MutableObject((Object)JobId.INVALID);
        try {
            QueryTranslator.createAndRunJob(hcc, this.jobFlags, (Mutable<JobId>)jobId, compiler, locker, resultDelivery, id -> {
                ResultHandle handle = new ResultHandle(id, resultSetId);
                this.responsePrinter.addResultPrinter((IResponseFieldPrinter)new StatusPrinter(AbstractQueryApiServlet.ResultStatus.RUNNING));
                this.responsePrinter.addResultPrinter((IResponseFieldPrinter)new ResultHandlePrinter(this.sessionOutput, handle));
                this.responsePrinter.printResults();
                MutableBoolean mutableBoolean = printed;
                synchronized (mutableBoolean) {
                    printed.setTrue();
                    printed.notify();
                }
            }, requestParameters, cancellable, this.appCtx, metadataProvider);
        }
        catch (Exception e) {
            if (Objects.equals(JobId.INVALID, jobId.getValue())) {
                this.responsePrinter.addResultPrinter((IResponseFieldPrinter)new StatusPrinter(AbstractQueryApiServlet.ResultStatus.FAILED));
                this.responsePrinter.addResultPrinter((IResponseFieldPrinter)new ErrorsPrinter(Collections.singletonList(ExecutionError.of(e))));
                try {
                    this.responsePrinter.printResults();
                }
                catch (HyracksDataException ex) {
                    LOGGER.error("failed to print result", (Throwable)ex);
                }
            } else {
                GlobalConfig.ASTERIX_LOGGER.log(Level.ERROR, resultDelivery.name() + " job with id " + jobId.getValue() + " failed", (Throwable)e);
            }
        }
        finally {
            MutableBoolean mutableBoolean = printed;
            synchronized (mutableBoolean) {
                if (printed.isFalse()) {
                    printed.setTrue();
                    printed.notify();
                }
            }
        }
    }

    private void runJob(IHyracksClientConnection hcc, JobSpecification jobSpec) throws Exception {
        QueryTranslator.runJob(hcc, jobSpec, this.jobFlags);
    }

    private static void runJob(IHyracksClientConnection hcc, JobSpecification jobSpec, EnumSet<JobFlag> jobFlags) throws Exception {
        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, jobFlags, (boolean)true);
    }

    private static void createAndRunJob(IHyracksClientConnection hcc, EnumSet<JobFlag> jobFlags, Mutable<JobId> jId, IStatementCompiler compiler, IMetadataLocker locker, IStatementExecutor.ResultDelivery resultDelivery, IResultPrinter printer, IRequestParameters requestParameters, boolean cancellable, ICcApplicationContext appCtx, MetadataProvider metadataProvider) throws Exception {
        IRequestTracker requestTracker = appCtx.getRequestTracker();
        ClientRequest clientRequest = (ClientRequest)requestTracker.get(requestParameters.getRequestReference().getUuid());
        locker.lock();
        try {
            JobSpecification jobSpec = compiler.compile();
            if (jobSpec == null) {
                return;
            }
            if (cancellable) {
                clientRequest.markCancellable();
            }
            SchedulableClientRequest schedulableRequest = SchedulableClientRequest.of((IClientRequest)clientRequest, (ICommonRequestParameters)requestParameters, (IMetadataProvider)metadataProvider, (JobSpecification)jobSpec);
            appCtx.getReceptionist().ensureSchedulable((ISchedulableClientRequest)schedulableRequest);
            JobId jobId = JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, jobFlags, (boolean)false);
            clientRequest.setJobId(jobId);
            if (jId != null) {
                jId.setValue((Object)jobId);
            }
            if (IStatementExecutor.ResultDelivery.ASYNC == resultDelivery) {
                printer.print(jobId);
                hcc.waitForCompletion(jobId);
            } else {
                hcc.waitForCompletion(jobId);
                QueryTranslator.ensureNotCancelled(clientRequest);
                printer.print(jobId);
            }
        }
        catch (Exception e) {
            if (ExceptionUtils.getRootCause((Throwable)e) instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeDataException(41, new Serializable[]{clientRequest.getId()});
            }
            throw e;
        }
        finally {
            if (IStatementExecutor.ResultDelivery.ASYNC == resultDelivery) {
                requestTracker.complete(clientRequest.getId());
            }
            locker.unlock();
        }
    }

    protected void handleCreateNodeGroupStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        NodegroupDecl stmtCreateNodegroup = (NodegroupDecl)stmt;
        SourceLocation sourceLoc = stmtCreateNodegroup.getSourceLocation();
        String ngName = stmtCreateNodegroup.getNodegroupName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockManager.acquireNodeGroupWriteLock(metadataProvider.getLocks(), ngName);
        try {
            NodeGroup ng = MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, ngName);
            if (ng != null) {
                if (!stmtCreateNodegroup.getIfNotExists()) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"A nodegroup with this name " + ngName + " already exists."});
                }
            } else {
                List ncIdentifiers = stmtCreateNodegroup.getNodeControllerNames();
                ArrayList<String> ncNames = new ArrayList<String>(ncIdentifiers.size());
                for (Identifier id : ncIdentifiers) {
                    ncNames.add(id.getValue());
                }
                MetadataManager.INSTANCE.addNodegroup(mdTxnCtx, new NodeGroup(ngName, ncNames));
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleExternalDatasetRefreshStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        block30: {
            RefreshExternalDatasetStatement stmtRefresh = (RefreshExternalDatasetStatement)stmt;
            SourceLocation sourceLoc = stmtRefresh.getSourceLocation();
            DataverseName dataverseName = this.getActiveDataverseName(stmtRefresh.getDataverseName());
            String datasetName = stmtRefresh.getDatasetName().getValue();
            DatasetConfig.TransactionState transactionState = DatasetConfig.TransactionState.COMMIT;
            MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            boolean bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            JobSpecification spec = null;
            Dataset ds = null;
            List metadataFiles = null;
            ArrayList deletedFiles = null;
            ArrayList addedFiles = null;
            ArrayList appendedFiles = null;
            List indexes = null;
            Dataset transactionDataset = null;
            boolean lockAquired = false;
            boolean success = false;
            this.lockUtil.refreshDatasetBegin(this.lockManager, metadataProvider.getLocks(), dataverseName, datasetName);
            try {
                ds = metadataProvider.findDataset(dataverseName, datasetName);
                if (ds == null) {
                    throw new CompilationException(1050, sourceLoc, new Serializable[]{datasetName, dataverseName});
                }
                if (ds.getDatasetType() != DatasetConfig.DatasetType.EXTERNAL) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"dataset " + datasetName + " in dataverse " + dataverseName + " is not an external dataset"});
                }
                indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName);
                if (indexes.isEmpty()) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"External dataset " + datasetName + " in dataverse " + dataverseName + " doesn't have any index"});
                }
                Date txnTime = new Date();
                ExternalDatasetsRegistry.INSTANCE.refreshBegin(ds);
                lockAquired = true;
                metadataFiles = MetadataManager.INSTANCE.getDatasetExternalFiles(mdTxnCtx, ds);
                deletedFiles = new ArrayList();
                addedFiles = new ArrayList();
                appendedFiles = new ArrayList();
                if (ExternalIndexingOperations.isDatasetUptodate((Dataset)ds, (List)metadataFiles, addedFiles, deletedFiles, appendedFiles)) {
                    ((ExternalDatasetDetails)ds.getDatasetDetails()).setRefreshTimestamp(txnTime);
                    MetadataManager.INSTANCE.updateDataset(mdTxnCtx, ds);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                transactionDataset = ExternalIndexingOperations.createTransactionDataset((Dataset)ds);
                MetadataManager.INSTANCE.updateDataset(mdTxnCtx, transactionDataset);
                for (ExternalFile file : addedFiles) {
                    MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                }
                for (ExternalFile file : appendedFiles) {
                    MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                }
                for (ExternalFile file : deletedFiles) {
                    MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                }
                spec = ExternalIndexingOperations.buildFilesIndexUpdateOp((Dataset)ds, (List)metadataFiles, addedFiles, appendedFiles, (MetadataProvider)metadataProvider);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                transactionState = DatasetConfig.TransactionState.BEGIN;
                this.runJob(hcc, spec);
                for (Index index : indexes) {
                    if (ExternalIndexingOperations.isFileIndex((Index)index)) continue;
                    spec = ExternalIndexingOperations.buildIndexUpdateOp((Dataset)ds, (Index)index, (List)metadataFiles, addedFiles, appendedFiles, (MetadataProvider)metadataProvider, (SourceLocation)sourceLoc);
                    this.runJob(hcc, spec);
                }
                spec = ExternalIndexingOperations.buildCommitJob((Dataset)ds, (List)indexes, (MetadataProvider)metadataProvider);
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                bActiveTxn = true;
                ((ExternalDatasetDetails)transactionDataset.getDatasetDetails()).setState(DatasetConfig.TransactionState.READY_TO_COMMIT);
                ((ExternalDatasetDetails)transactionDataset.getDatasetDetails()).setRefreshTimestamp(txnTime);
                MetadataManager.INSTANCE.updateDataset(mdTxnCtx, transactionDataset);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                transactionState = DatasetConfig.TransactionState.READY_TO_COMMIT;
                this.runJob(hcc, spec);
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                bActiveTxn = true;
                for (ExternalFile file : metadataFiles) {
                    if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.DROP_OP) {
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                        continue;
                    }
                    if (file.getPendingOp() != DatasetConfig.ExternalFilePendingOp.NO_OP) continue;
                    Iterator iterator = appendedFiles.iterator();
                    while (iterator.hasNext()) {
                        ExternalFile appendedFile = (ExternalFile)iterator.next();
                        if (!file.getFileName().equals(appendedFile.getFileName())) continue;
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, appendedFile);
                        appendedFile.setFileNumber(file.getFileNumber());
                        appendedFile.setPendingOp(DatasetConfig.ExternalFilePendingOp.NO_OP);
                        MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, appendedFile);
                        iterator.remove();
                    }
                }
                for (ExternalFile file : deletedFiles) {
                    MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                }
                for (ExternalFile file : addedFiles) {
                    MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                    file.setPendingOp(DatasetConfig.ExternalFilePendingOp.NO_OP);
                    MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                }
                ((ExternalDatasetDetails)transactionDataset.getDatasetDetails()).setState(DatasetConfig.TransactionState.COMMIT);
                MetadataManager.INSTANCE.updateDataset(mdTxnCtx, transactionDataset);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                success = true;
            }
            catch (Exception e) {
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                if (transactionState == DatasetConfig.TransactionState.READY_TO_COMMIT) {
                    throw new IllegalStateException("System is inconsistent state: commit of (" + dataverseName + "." + datasetName + ") refresh couldn't carry out the commit phase", e);
                }
                if (transactionState == DatasetConfig.TransactionState.COMMIT) {
                    throw e;
                }
                if (transactionState != DatasetConfig.TransactionState.BEGIN) break block30;
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                spec = ExternalIndexingOperations.buildAbortOp((Dataset)ds, (List)indexes, (MetadataProvider)metadataProvider);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                try {
                    this.runJob(hcc, spec);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    throw new IllegalStateException("System is in inconsistent state. Failed to abort refresh", e);
                }
                try {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    for (ExternalFile file : deletedFiles) {
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                    }
                    for (ExternalFile file : addedFiles) {
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                    }
                    for (ExternalFile file : appendedFiles) {
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                    }
                    MetadataManager.INSTANCE.updateDataset(mdTxnCtx, ds);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    e.addSuppressed(e2);
                    throw new IllegalStateException("System is in inconsistent state. Failed to drop delta files", e);
                }
            }
            finally {
                if (lockAquired) {
                    ExternalDatasetsRegistry.INSTANCE.refreshEnd(ds, success);
                }
                metadataProvider.getLocks().unlock();
            }
        }
    }

    public DataverseName getActiveDataverseName(DataverseName dataverseName) {
        return dataverseName != null ? dataverseName : this.activeDataverse.getDataverseName();
    }

    public ExecutionPlans getExecutionPlans() {
        return this.apiFramework.getExecutionPlans();
    }

    public IResponsePrinter getResponsePrinter() {
        return this.responsePrinter;
    }

    public void getWarnings(Collection<? super Warning> outWarnings, long maxWarnings) {
        this.warningCollector.getWarnings(outWarnings, maxWarnings);
    }

    public static void abort(Exception rootE, Exception parentE, MetadataTransactionContext mdTxnCtx) {
        boolean interrupted = Thread.interrupted();
        try {
            if (mdTxnCtx != null) {
                MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            }
        }
        catch (Exception e2) {
            parentE.addSuppressed(e2);
            throw new IllegalStateException(rootE);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void rewriteStatement(Statement stmt, IStatementRewriter rewriter, MetadataProvider metadataProvider) throws CompilationException, RemoteException {
        if (!rewriter.isRewritable(stmt.getKind())) {
            return;
        }
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            rewriter.rewrite(stmt, metadataProvider);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    private void ensureNonPrimaryIndexDrop(Index index, SourceLocation sourceLoc) throws AlgebricksException {
        if (index.isPrimaryIndex()) {
            throw new MetadataException(1069, sourceLoc, new Serializable[]{index.getIndexName(), index.getDatasetName()});
        }
    }

    protected void afterCompile() {
        if (this.sessionOutput.config().is("format-html")) {
            ExecutionPlansHtmlPrintUtil.print((PrintWriter)this.sessionOutput.out(), (ExecutionPlans)this.getExecutionPlans());
        }
    }

    protected void trackRequest(IRequestParameters requestParameters) throws HyracksDataException {
        IClientRequest clientRequest = this.appCtx.getReceptionist().requestReceived((ICommonRequestParameters)requestParameters);
        this.appCtx.getRequestTracker().track(clientRequest);
    }

    protected void validateStatements(IRequestParameters requestParameters) throws CompilationException {
        QueryTranslator.validateStatements(this.statements, requestParameters.isMultiStatement(), requestParameters.getStatementCategoryRestrictionMask());
    }

    public static void validateStatements(List<Statement> statements, boolean allowMultiStatement, int stmtCategoryRestrictionMask) throws CompilationException {
        if (!allowMultiStatement && statements.stream().filter(QueryTranslator::isNotAllowedMultiStatement).count() > 1L) {
            throw new CompilationException(35, new Serializable[0]);
        }
        if (stmtCategoryRestrictionMask != 0) {
            for (Statement stmt : statements) {
                if (!QueryTranslator.isNotAllowedStatementCategory(stmt, stmtCategoryRestrictionMask)) continue;
                throw new CompilationException(44, stmt.getSourceLocation(), new Serializable[]{stmt.getKind()});
            }
        }
    }

    protected static boolean isNotAllowedMultiStatement(Statement statement) {
        switch (statement.getKind()) {
            case SET: 
            case DATAVERSE_DECL: 
            case WRITE: 
            case FUNCTION_DECL: {
                return false;
            }
        }
        return true;
    }

    private static boolean isNotAllowedStatementCategory(Statement statement, int categoryRestrictionMask) {
        byte category = statement.getCategory();
        if (category <= 0) {
            throw new IllegalArgumentException(String.valueOf(category));
        }
        int i = category & categoryRestrictionMask;
        return i == 0;
    }

    private Map<VarIdentifier, IAObject> createExternalVariables(Map<String, IAObject> stmtParams, IStatementRewriter stmtRewriter) {
        if (stmtParams == null || stmtParams.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<VarIdentifier, IAObject> m = new HashMap<VarIdentifier, IAObject>();
        for (Map.Entry<String, IAObject> me : stmtParams.entrySet()) {
            String paramName = me.getKey();
            String extVarName = stmtRewriter.toExternalVariableName(paramName);
            if (extVarName == null) continue;
            m.put(new VarIdentifier(extVarName), me.getValue());
        }
        return m;
    }

    protected void validateDatasetState(MetadataProvider metadataProvider, Dataset dataset, SourceLocation sourceLoc) throws Exception {
        QueryTranslator.validateIfResourceIsActiveInFeed(metadataProvider.getApplicationContext(), dataset, sourceLoc);
    }

    private static void ensureNotCancelled(ClientRequest clientRequest) throws RuntimeDataException {
        if (clientRequest.isCancelled()) {
            throw new RuntimeDataException(41, new Serializable[]{clientRequest.getId()});
        }
    }

    protected void validateExternalDatasetProperties(ExternalDetailsDecl externalDetails, Map<String, String> properties, SourceLocation srcLoc, MetadataTransactionContext mdTxnCtx) throws AlgebricksException, HyracksDataException {
        String adapter = externalDetails.getAdapter();
        HashMap<String, String> details = new HashMap<String, String>(properties);
        details.put("type", adapter);
        this.validateAdapterSpecificProperties(details, srcLoc);
    }

    protected void validateAdapterSpecificProperties(Map<String, String> configuration, SourceLocation srcLoc) throws CompilationException {
        ExternalDataUtils.validateAdapterSpecificProperties(configuration, (SourceLocation)srcLoc, (IWarningCollector)this.warningCollector);
    }

    private static interface IStatementCompiler {
        public JobSpecification compile() throws AlgebricksException, RemoteException, ACIDException;
    }

    private static interface IResultPrinter {
        public void print(JobId var1) throws HyracksDataException, AlgebricksException;
    }

    private static interface IMetadataLocker {
        public void lock() throws AlgebricksException;

        public void unlock() throws AlgebricksException;
    }
}

