/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class IndexInsertDeleteUpsertOperator
extends AbstractLogicalOperator {
    private final IDataSourceIndex<?, ?> dataSourceIndex;
    private final List<Mutable<ILogicalExpression>> primaryKeyExprs;
    private final List<Mutable<ILogicalExpression>> secondaryKeyExprs;
    private final Mutable<ILogicalExpression> filterExpr;
    private final InsertDeleteUpsertOperator.Kind operation;
    private final boolean bulkload;
    private List<Mutable<ILogicalExpression>> additionalFilteringExpressions;
    private List<Mutable<ILogicalExpression>> prevSecondaryKeyExprs;
    private Mutable<ILogicalExpression> prevAdditionalFilteringExpression;
    private Mutable<ILogicalExpression> upsertIndicatorExpr;
    private final int numberOfAdditionalNonFilteringFields;

    public IndexInsertDeleteUpsertOperator(IDataSourceIndex<?, ?> dataSourceIndex, List<Mutable<ILogicalExpression>> primaryKeyExprs, List<Mutable<ILogicalExpression>> secondaryKeyExprs, Mutable<ILogicalExpression> filterExpr, InsertDeleteUpsertOperator.Kind operation, boolean bulkload, int numberOfAdditionalNonFilteringFields) {
        this.dataSourceIndex = dataSourceIndex;
        this.primaryKeyExprs = primaryKeyExprs;
        this.secondaryKeyExprs = secondaryKeyExprs;
        this.filterExpr = filterExpr;
        this.operation = operation;
        this.bulkload = bulkload;
        this.numberOfAdditionalNonFilteringFields = numberOfAdditionalNonFilteringFields;
    }

    @Override
    public void recomputeSchema() throws AlgebricksException {
        this.schema = new ArrayList();
        this.schema.addAll(((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue()).getSchema());
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) throws AlgebricksException {
        int i;
        boolean b = false;
        for (i = 0; i < this.primaryKeyExprs.size(); ++i) {
            if (!visitor.transform(this.primaryKeyExprs.get(i))) continue;
            b = true;
        }
        for (i = 0; i < this.secondaryKeyExprs.size(); ++i) {
            if (!visitor.transform(this.secondaryKeyExprs.get(i))) continue;
            b = true;
        }
        if (this.additionalFilteringExpressions != null) {
            for (i = 0; i < this.additionalFilteringExpressions.size(); ++i) {
                if (!visitor.transform(this.additionalFilteringExpressions.get(i))) continue;
                b = true;
            }
        }
        if (this.upsertIndicatorExpr != null && visitor.transform(this.upsertIndicatorExpr)) {
            b = true;
        }
        if (this.prevSecondaryKeyExprs != null) {
            for (i = 0; i < this.prevSecondaryKeyExprs.size(); ++i) {
                if (!visitor.transform(this.prevSecondaryKeyExprs.get(i))) continue;
                b = true;
            }
        }
        if (this.prevAdditionalFilteringExpression != null) {
            visitor.transform(this.prevAdditionalFilteringExpression);
        }
        return b;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitIndexInsertDeleteUpsertOperator(this, arg);
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return VariablePropagationPolicy.ALL;
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.INDEX_INSERT_DELETE_UPSERT;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        return this.createPropagatingAllInputsTypeEnvironment(ctx);
    }

    public List<Mutable<ILogicalExpression>> getPrimaryKeyExpressions() {
        return this.primaryKeyExprs;
    }

    public IDataSourceIndex<?, ?> getDataSourceIndex() {
        return this.dataSourceIndex;
    }

    public String getIndexName() {
        return this.dataSourceIndex.getId().toString();
    }

    public List<Mutable<ILogicalExpression>> getSecondaryKeyExpressions() {
        return this.secondaryKeyExprs;
    }

    public Mutable<ILogicalExpression> getFilterExpression() {
        return this.filterExpr;
    }

    public InsertDeleteUpsertOperator.Kind getOperation() {
        return this.operation;
    }

    public boolean isBulkload() {
        return this.bulkload;
    }

    public void setAdditionalFilteringExpressions(List<Mutable<ILogicalExpression>> additionalFilteringExpressions) {
        this.additionalFilteringExpressions = additionalFilteringExpressions;
    }

    public List<Mutable<ILogicalExpression>> getAdditionalFilteringExpressions() {
        return this.additionalFilteringExpressions;
    }

    public List<Mutable<ILogicalExpression>> getPrevSecondaryKeyExprs() {
        return this.prevSecondaryKeyExprs;
    }

    public void setBeforeOpSecondaryKeyExprs(List<Mutable<ILogicalExpression>> prevSecondaryKeyExprs) {
        this.prevSecondaryKeyExprs = prevSecondaryKeyExprs;
    }

    public Mutable<ILogicalExpression> getPrevAdditionalFilteringExpression() {
        return this.prevAdditionalFilteringExpression;
    }

    public void setBeforeOpAdditionalFilteringExpression(Mutable<ILogicalExpression> prevAdditionalFilteringExpression) {
        this.prevAdditionalFilteringExpression = prevAdditionalFilteringExpression;
    }

    public int getNumberOfAdditionalNonFilteringFields() {
        return this.numberOfAdditionalNonFilteringFields;
    }

    public Mutable<ILogicalExpression> getUpsertIndicatorExpr() {
        return this.upsertIndicatorExpr;
    }

    public void setUpsertIndicatorExpr(Mutable<ILogicalExpression> upsertIndicatorExpr) {
        this.upsertIndicatorExpr = upsertIndicatorExpr;
    }
}

