/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import com.google.common.collect.ImmutableMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.NoOpWarningCollector;
import org.apache.asterix.common.exceptions.WarningCollector;
import org.apache.asterix.common.exceptions.WarningUtil;
import org.apache.asterix.dataflow.data.common.ExpressionTypeComputer;
import org.apache.asterix.dataflow.data.nontagged.MissingWriterFactory;
import org.apache.asterix.formats.nontagged.ADMPrinterFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryBooleanInspector;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFamilyProvider;
import org.apache.asterix.formats.nontagged.BinaryIntegerInspector;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.jobgen.QueryLogicalExpressionJobGen;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.runtime.base.UnnestingPositionWriterFactory;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.ILogicalExpressionJobGen;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import org.apache.hyracks.algebricks.data.IBinaryHashFunctionFactoryProvider;
import org.apache.hyracks.algebricks.data.IBinaryHashFunctionFamilyProvider;
import org.apache.hyracks.algebricks.data.IPrinterFactoryProvider;
import org.apache.hyracks.algebricks.data.ISerializerDeserializerProvider;
import org.apache.hyracks.algebricks.data.ITypeTraitProvider;
import org.apache.hyracks.algebricks.data.IUnnestingPositionWriterFactory;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.comm.util.ByteBufferInputStream;

public class ConstantFoldingRule
implements IAlgebraicRewriteRule {
    private final ConstantFoldingVisitor cfv = new ConstantFoldingVisitor();
    private final JobGenContext jobGenCtx;
    private static final Map<FunctionIdentifier, IAObject> FUNC_ID_TO_CONSTANT = ImmutableMap.of((Object)BuiltinFunctions.NUMERIC_E, (Object)new ADouble(Math.E), (Object)BuiltinFunctions.NUMERIC_PI, (Object)new ADouble(Math.PI));
    private static final IVariableTypeEnvironment _emptyTypeEnv = new IVariableTypeEnvironment(){

        public boolean substituteProducedVariable(LogicalVariable v1, LogicalVariable v2) {
            throw new IllegalStateException();
        }

        public void setVarType(LogicalVariable var, Object type) {
            throw new IllegalStateException();
        }

        public Object getVarType(LogicalVariable var, List<LogicalVariable> nonNullVariables, List<List<LogicalVariable>> correlatedNullableVariableLists) {
            throw new IllegalStateException();
        }

        public Object getVarType(LogicalVariable var) {
            throw new IllegalStateException();
        }

        public Object getType(ILogicalExpression expr) throws AlgebricksException {
            return ExpressionTypeComputer.INSTANCE.getType(expr, null, (IVariableTypeEnvironment)this);
        }
    };
    private static final IOperatorSchema[] _emptySchemas = new IOperatorSchema[0];

    public ConstantFoldingRule(ICcApplicationContext appCtx) {
        MetadataProvider metadataProvider = MetadataProvider.create((ICcApplicationContext)appCtx, null);
        this.jobGenCtx = new JobGenContext(null, (IMetadataProvider)metadataProvider, (Object)appCtx, (ISerializerDeserializerProvider)SerializerDeserializerProvider.INSTANCE, (IBinaryHashFunctionFactoryProvider)BinaryHashFunctionFactoryProvider.INSTANCE, (IBinaryHashFunctionFamilyProvider)BinaryHashFunctionFamilyProvider.INSTANCE, (IBinaryComparatorFactoryProvider)BinaryComparatorFactoryProvider.INSTANCE, (ITypeTraitProvider)TypeTraitProvider.INSTANCE, BinaryBooleanInspector.FACTORY, BinaryIntegerInspector.FACTORY, (IPrinterFactoryProvider)ADMPrinterFactoryProvider.INSTANCE, (IMissingWriterFactory)MissingWriterFactory.INSTANCE, (IUnnestingPositionWriterFactory)UnnestingPositionWriterFactory.INSTANCE, null, (IExpressionRuntimeProvider)new ExpressionRuntimeProvider((ILogicalExpressionJobGen)new QueryLogicalExpressionJobGen(metadataProvider.getFunctionManager())), (IExpressionTypeComputer)ExpressionTypeComputer.INSTANCE, null, null, null, null, 32768, null, NoOpWarningCollector.INSTANCE, 0L);
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, op)) {
            return false;
        }
        this.cfv.reset(context);
        return op.acceptExpressionTransform((ILogicalExpressionReferenceTransform)this.cfv);
    }

    private class ConstantFoldingVisitor
    implements ILogicalExpressionVisitor<Pair<Boolean, ILogicalExpression>, Void>,
    ILogicalExpressionReferenceTransform,
    IEvaluatorContext {
        private final IPointable p = VoidPointable.FACTORY.createPointable();
        private final ByteBufferInputStream bbis = new ByteBufferInputStream();
        private final DataInputStream dis = new DataInputStream((InputStream)this.bbis);
        private final WarningCollector warningCollector = new WarningCollector();
        private IOptimizationContext optContext;
        private IServiceContext serviceContext;

        private ConstantFoldingVisitor() {
        }

        private void reset(IOptimizationContext context) {
            this.optContext = context;
            this.serviceContext = ((MetadataProvider)context.getMetadataProvider()).getApplicationContext().getServiceContext();
        }

        public boolean transform(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
            AbstractLogicalExpression expr = (AbstractLogicalExpression)exprRef.getValue();
            Pair newExpression = (Pair)expr.accept((ILogicalExpressionVisitor)this, null);
            if (((Boolean)newExpression.first).booleanValue()) {
                exprRef.setValue(newExpression.second);
            }
            return (Boolean)newExpression.first;
        }

        public Pair<Boolean, ILogicalExpression> visitConstantExpression(ConstantExpression expr, Void arg) {
            return new Pair((Object)false, (Object)expr);
        }

        public Pair<Boolean, ILogicalExpression> visitVariableReferenceExpression(VariableReferenceExpression expr, Void arg) {
            return new Pair((Object)false, (Object)expr);
        }

        public Pair<Boolean, ILogicalExpression> visitScalarFunctionCallExpression(ScalarFunctionCallExpression expr, Void arg) throws AlgebricksException {
            boolean changed = this.constantFoldArgs((AbstractFunctionCallExpression)expr, arg);
            List argList = expr.getArguments();
            int argConstantCount = this.countConstantArgs(argList);
            if (argConstantCount != argList.size()) {
                if (argConstantCount > 0 && expr.getFunctionIdentifier().equals((Object)BuiltinFunctions.OR) && expr.isFunctional() && this.foldOrArgs(expr)) {
                    ScalarFunctionCallExpression changedExpr = expr.getArguments().size() == 1 ? (ILogicalExpression)((Mutable)expr.getArguments().get(0)).getValue() : expr;
                    return new Pair((Object)true, (Object)changedExpr);
                }
                return new Pair((Object)changed, (Object)expr);
            }
            if (!expr.isFunctional() || !this.canConstantFold(expr)) {
                return new Pair((Object)changed, (Object)expr);
            }
            try {
                String str;
                ARecordType rt;
                int k;
                if (expr.getFunctionIdentifier().equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_NAME) && (k = (rt = (ARecordType)_emptyTypeEnv.getType((ILogicalExpression)((Mutable)expr.getArguments().get(0)).getValue())).getFieldIndex(str = ConstantExpressionUtil.getStringConstant((ILogicalExpression)((ILogicalExpression)((Mutable)expr.getArguments().get(1)).getValue())))) >= 0) {
                    return new Pair((Object)changed, (Object)expr);
                }
                IAObject c = (IAObject)FUNC_ID_TO_CONSTANT.get(expr.getFunctionIdentifier());
                if (c != null) {
                    ConstantExpression constantExpression = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(c));
                    constantExpression.setSourceLocation(expr.getSourceLocation());
                    return new Pair((Object)true, (Object)constantExpression);
                }
                IScalarEvaluatorFactory fact = ConstantFoldingRule.this.jobGenCtx.getExpressionRuntimeProvider().createEvaluatorFactory((ILogicalExpression)expr, _emptyTypeEnv, _emptySchemas, ConstantFoldingRule.this.jobGenCtx);
                this.warningCollector.clear();
                IScalarEvaluator eval = fact.createScalarEvaluator((IEvaluatorContext)this);
                eval.evaluate(null, this.p);
                IAType returnType = (IAType)_emptyTypeEnv.getType((ILogicalExpression)expr);
                ATypeTag runtimeType = PointableHelper.getTypeTag((IValueReference)this.p);
                returnType = runtimeType.isDerivedType() ? TypeComputeUtils.getActualType((IAType)returnType) : TypeTagUtil.getBuiltinTypeByTag((ATypeTag)runtimeType);
                ISerializerDeserializer serde = ConstantFoldingRule.this.jobGenCtx.getSerializerDeserializerProvider().getSerializerDeserializer((Object)returnType);
                this.bbis.setByteBuffer(ByteBuffer.wrap(this.p.getByteArray(), this.p.getStartOffset(), this.p.getLength()), 0);
                IAObject o = (IAObject)serde.deserialize((DataInput)this.dis);
                this.warningCollector.getWarnings(this.optContext.getWarningCollector());
                ConstantExpression constantExpression = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(o));
                constantExpression.setSourceLocation(expr.getSourceLocation());
                return new Pair((Object)true, (Object)constantExpression);
            }
            catch (AlgebricksException | HyracksDataException e) {
                if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
                    AlgebricksConfig.ALGEBRICKS_LOGGER.trace("Exception caught at constant folding: " + e, e);
                }
                return new Pair((Object)false, null);
            }
        }

        public Pair<Boolean, ILogicalExpression> visitAggregateFunctionCallExpression(AggregateFunctionCallExpression expr, Void arg) throws AlgebricksException {
            boolean changed = this.constantFoldArgs((AbstractFunctionCallExpression)expr, arg);
            return new Pair((Object)changed, (Object)expr);
        }

        public Pair<Boolean, ILogicalExpression> visitStatefulFunctionCallExpression(StatefulFunctionCallExpression expr, Void arg) throws AlgebricksException {
            boolean changed = this.constantFoldArgs((AbstractFunctionCallExpression)expr, arg);
            return new Pair((Object)changed, (Object)expr);
        }

        public Pair<Boolean, ILogicalExpression> visitUnnestingFunctionCallExpression(UnnestingFunctionCallExpression expr, Void arg) throws AlgebricksException {
            boolean changed = this.constantFoldArgs((AbstractFunctionCallExpression)expr, arg);
            return new Pair((Object)changed, (Object)expr);
        }

        private boolean constantFoldArgs(AbstractFunctionCallExpression expr, Void arg) throws AlgebricksException {
            return expr.getFunctionIdentifier().equals((Object)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR) ? this.foldRecordArgs(expr, arg) : this.foldFunctionArgs(expr, arg);
        }

        private boolean foldFunctionArgs(AbstractFunctionCallExpression expr, Void arg) throws AlgebricksException {
            boolean changed = false;
            for (Mutable exprArgRef : expr.getArguments()) {
                changed |= this.foldArg((Mutable<ILogicalExpression>)exprArgRef, arg);
            }
            return changed;
        }

        private boolean foldRecordArgs(AbstractFunctionCallExpression expr, Void arg) throws AlgebricksException {
            if (expr.getArguments().size() % 2 != 0) {
                String functionName = expr.getFunctionIdentifier().getName();
                throw CompilationException.create((int)1087, (SourceLocation)expr.getSourceLocation(), (Serializable[])new Serializable[]{functionName});
            }
            boolean changed = false;
            Iterator iterator = expr.getArguments().iterator();
            int fieldNameIdx = 0;
            while (iterator.hasNext()) {
                Mutable fieldNameExprRef = (Mutable)iterator.next();
                Pair fieldNameExpr = (Pair)((ILogicalExpression)fieldNameExprRef.getValue()).accept((ILogicalExpressionVisitor)this, (Object)arg);
                boolean isDuplicate = false;
                if (((Boolean)fieldNameExpr.first).booleanValue()) {
                    String fieldName = ConstantExpressionUtil.getStringConstant((ILogicalExpression)((ILogicalExpression)fieldNameExpr.second));
                    if (fieldName != null) {
                        isDuplicate = this.isDuplicateField(fieldName, fieldNameIdx, expr.getArguments());
                    }
                    if (isDuplicate) {
                        IWarningCollector warningCollector = this.optContext.getWarningCollector();
                        if (warningCollector.shouldWarn()) {
                            warningCollector.warn(WarningUtil.forAsterix((SourceLocation)((ILogicalExpression)fieldNameExpr.second).getSourceLocation(), (int)1006, (Serializable[])new Serializable[]{fieldName}));
                        }
                        iterator.remove();
                        iterator.next();
                        iterator.remove();
                    } else {
                        fieldNameExprRef.setValue(fieldNameExpr.second);
                    }
                    changed = true;
                }
                if (isDuplicate) continue;
                Mutable fieldValue = (Mutable)iterator.next();
                changed |= this.foldArg((Mutable<ILogicalExpression>)fieldValue, arg);
                fieldNameIdx += 2;
            }
            return changed;
        }

        private boolean isDuplicateField(String fName, int fIdx, List<Mutable<ILogicalExpression>> args) {
            int size = args.size();
            for (int i = 0; i < size; i += 2) {
                if (i == fIdx || !fName.equals(ConstantExpressionUtil.getStringConstant((ILogicalExpression)((ILogicalExpression)args.get(i).getValue())))) continue;
                return true;
            }
            return false;
        }

        private boolean foldArg(Mutable<ILogicalExpression> exprArgRef, Void arg) throws AlgebricksException {
            Pair newExpr = (Pair)((ILogicalExpression)exprArgRef.getValue()).accept((ILogicalExpressionVisitor)this, (Object)arg);
            if (((Boolean)newExpr.first).booleanValue()) {
                exprArgRef.setValue(newExpr.second);
                return true;
            }
            return false;
        }

        private int countConstantArgs(List<Mutable<ILogicalExpression>> argList) {
            int n = 0;
            for (Mutable<ILogicalExpression> r : argList) {
                if (((ILogicalExpression)r.getValue()).getExpressionTag() != LogicalExpressionTag.CONSTANT) continue;
                ++n;
            }
            return n;
        }

        private boolean canConstantFold(ScalarFunctionCallExpression function) throws AlgebricksException {
            IFunctionInfo fi = function.getFunctionInfo();
            if (fi instanceof IExternalFunctionInfo) {
                return false;
            }
            if (function.getFunctionIdentifier().equals((Object)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR)) {
                return false;
            }
            IAType returnType = (IAType)_emptyTypeEnv.getType((ILogicalExpression)function);
            return this.canConstantFoldType(returnType);
        }

        private boolean canConstantFoldType(IAType returnType) {
            ATypeTag tag = returnType.getTypeTag();
            if (tag == ATypeTag.ANY) {
                return false;
            }
            if (tag == ATypeTag.OBJECT) {
                ARecordType recordType = (ARecordType)returnType;
                if (recordType.isOpen()) {
                    return false;
                }
                IAType[] fieldTypes = recordType.getFieldTypes();
                for (int i = 0; i < fieldTypes.length; ++i) {
                    if (this.canConstantFoldType(fieldTypes[i])) continue;
                    return false;
                }
            } else {
                if (tag.isListType()) {
                    AbstractCollectionType listType = (AbstractCollectionType)returnType;
                    return this.canConstantFoldType(listType.getItemType());
                }
                if (tag == ATypeTag.UNION) {
                    return this.canConstantFoldType(((AUnionType)returnType).getActualType());
                }
            }
            return true;
        }

        private boolean foldOrArgs(ScalarFunctionCallExpression expr) {
            boolean changed = false;
            List argList = expr.getArguments();
            Iterator argIter = argList.iterator();
            Mutable argFalse = null;
            while (argIter.hasNext()) {
                Mutable argExprRef = (Mutable)argIter.next();
                ILogicalExpression argExpr = (ILogicalExpression)argExprRef.getValue();
                if (argExpr.getExpressionTag() != LogicalExpressionTag.CONSTANT) continue;
                ConstantExpression cExpr = (ConstantExpression)argExpr;
                IAlgebricksConstantValue cValue = cExpr.getValue();
                if (cValue.isTrue()) {
                    argList.clear();
                    argList.add(argExprRef);
                    return true;
                }
                if (!cValue.isFalse()) continue;
                argFalse = argExprRef;
                argIter.remove();
                changed = true;
            }
            if (argList.isEmpty() && argFalse != null) {
                argList.add(argFalse);
            }
            return changed;
        }

        public IServiceContext getServiceContext() {
            return this.serviceContext;
        }

        public IHyracksTaskContext getTaskContext() {
            return null;
        }

        public IWarningCollector getWarningCollector() {
            return this.warningCollector;
        }
    }
}

