/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.thrift;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.thrift.DelegationTokenIdentifier;
import org.apache.hadoop.hive.thrift.DelegationTokenStore;
import org.apache.hadoop.hive.thrift.TokenStoreDelegationTokenSecretManager;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.HiveDelegationTokenSupport;

public class DBTokenStore
implements DelegationTokenStore {
    private Object hmsHandler;

    @Override
    public int addMasterKey(String s) throws DelegationTokenStore.TokenStoreException {
        return (Integer)this.invokeOnRawStore("addMasterKey", new Object[]{s}, String.class);
    }

    @Override
    public void updateMasterKey(int keySeq, String s) throws DelegationTokenStore.TokenStoreException {
        this.invokeOnRawStore("updateMasterKey", new Object[]{keySeq, s}, Integer.class, String.class);
    }

    @Override
    public boolean removeMasterKey(int keySeq) {
        return (Boolean)this.invokeOnRawStore("removeMasterKey", new Object[]{keySeq}, Integer.class);
    }

    @Override
    public String[] getMasterKeys() throws DelegationTokenStore.TokenStoreException {
        return (String[])this.invokeOnRawStore("getMasterKeys", new Object[0], new Class[0]);
    }

    @Override
    public boolean addToken(DelegationTokenIdentifier tokenIdentifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation token) throws DelegationTokenStore.TokenStoreException {
        try {
            String identifier = TokenStoreDelegationTokenSecretManager.encodeWritable((Writable)tokenIdentifier);
            String tokenStr = Base64.encodeBase64URLSafeString((byte[])HiveDelegationTokenSupport.encodeDelegationTokenInformation(token));
            return (Boolean)this.invokeOnRawStore("addToken", new Object[]{identifier, tokenStr}, String.class, String.class);
        }
        catch (IOException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
    }

    @Override
    public AbstractDelegationTokenSecretManager.DelegationTokenInformation getToken(DelegationTokenIdentifier tokenIdentifier) throws DelegationTokenStore.TokenStoreException {
        try {
            String tokenStr = (String)this.invokeOnRawStore("getToken", new Object[]{TokenStoreDelegationTokenSecretManager.encodeWritable((Writable)tokenIdentifier)}, String.class);
            return null == tokenStr ? null : HiveDelegationTokenSupport.decodeDelegationTokenInformation(Base64.decodeBase64((String)tokenStr));
        }
        catch (IOException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
    }

    @Override
    public boolean removeToken(DelegationTokenIdentifier tokenIdentifier) throws DelegationTokenStore.TokenStoreException {
        try {
            return (Boolean)this.invokeOnRawStore("removeToken", new Object[]{TokenStoreDelegationTokenSecretManager.encodeWritable((Writable)tokenIdentifier)}, String.class);
        }
        catch (IOException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
    }

    @Override
    public List<DelegationTokenIdentifier> getAllDelegationTokenIdentifiers() throws DelegationTokenStore.TokenStoreException {
        List tokenIdents = (List)this.invokeOnRawStore("getAllTokenIdentifiers", new Object[0], new Class[0]);
        ArrayList<DelegationTokenIdentifier> delTokenIdents = new ArrayList<DelegationTokenIdentifier>(tokenIdents.size());
        for (String tokenIdent : tokenIdents) {
            DelegationTokenIdentifier delToken = new DelegationTokenIdentifier();
            try {
                TokenStoreDelegationTokenSecretManager.decodeWritable((Writable)delToken, tokenIdent);
            }
            catch (IOException e) {
                throw new DelegationTokenStore.TokenStoreException(e);
            }
            delTokenIdents.add(delToken);
        }
        return delTokenIdents;
    }

    @Override
    public void setStore(Object hms) throws DelegationTokenStore.TokenStoreException {
        this.hmsHandler = hms;
    }

    private Object invokeOnRawStore(String methName, Object[] params, Class<?> ... paramTypes) throws DelegationTokenStore.TokenStoreException {
        try {
            Object rawStore = this.hmsHandler.getClass().getMethod("getMS", new Class[0]).invoke(this.hmsHandler, new Object[0]);
            return rawStore.getClass().getMethod(methName, paramTypes).invoke(rawStore, params);
        }
        catch (IllegalArgumentException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
        catch (SecurityException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
        catch (IllegalAccessException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
        catch (InvocationTargetException e) {
            throw new DelegationTokenStore.TokenStoreException(e.getCause());
        }
        catch (NoSuchMethodException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
    }

    public void setConf(Configuration conf) {
    }

    public Configuration getConf() {
        return null;
    }

    @Override
    public void close() throws IOException {
    }
}

