/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tracing.SpanReceiverInfo;
import org.apache.hadoop.tracing.TraceAdminProtocol;
import org.apache.hadoop.tracing.TraceUtils;
import org.apache.htrace.core.SpanReceiver;
import org.apache.htrace.core.TracerPool;

@InterfaceAudience.Private
public class TracerConfigurationManager
implements TraceAdminProtocol {
    private static final Log LOG = LogFactory.getLog(TracerConfigurationManager.class);
    private final String confPrefix;
    private final Configuration conf;

    public TracerConfigurationManager(String confPrefix, Configuration conf) {
        this.confPrefix = confPrefix;
        this.conf = conf;
    }

    @Override
    public synchronized SpanReceiverInfo[] listSpanReceivers() throws IOException {
        TracerPool pool = TracerPool.getGlobalTracerPool();
        SpanReceiver[] receivers = pool.getReceivers();
        SpanReceiverInfo[] info = new SpanReceiverInfo[receivers.length];
        for (int i = 0; i < receivers.length; ++i) {
            SpanReceiver receiver = receivers[i];
            info[i] = new SpanReceiverInfo(receiver.getId(), receiver.getClass().getName());
        }
        return info;
    }

    @Override
    public synchronized long addSpanReceiver(SpanReceiverInfo info) throws IOException {
        StringBuilder configStringBuilder = new StringBuilder();
        String prefix = "";
        for (SpanReceiverInfo.ConfigurationPair pair : info.configPairs) {
            configStringBuilder.append(prefix).append(pair.getKey()).append(" = ").append(pair.getValue());
            prefix = ", ";
        }
        SpanReceiver rcvr = null;
        try {
            rcvr = new SpanReceiver.Builder(TraceUtils.wrapHadoopConf(this.confPrefix, this.conf, info.configPairs)).className(info.getClassName().trim()).build();
        }
        catch (RuntimeException e) {
            LOG.info((Object)("Failed to add SpanReceiver " + info.getClassName() + " with configuration " + configStringBuilder.toString()), (Throwable)e);
            throw e;
        }
        TracerPool.getGlobalTracerPool().addReceiver(rcvr);
        LOG.info((Object)("Successfully added SpanReceiver " + info.getClassName() + " with configuration " + configStringBuilder.toString()));
        return rcvr.getId();
    }

    @Override
    public synchronized void removeSpanReceiver(long spanReceiverId) throws IOException {
        SpanReceiver[] receivers;
        for (SpanReceiver receiver : receivers = TracerPool.getGlobalTracerPool().getReceivers()) {
            if (receiver.getId() != spanReceiverId) continue;
            TracerPool.getGlobalTracerPool().removeAndCloseReceiver(receiver);
            LOG.info((Object)("Successfully removed SpanReceiver " + spanReceiverId + " with class " + receiver.getClass().getName()));
            return;
        }
        throw new IOException("There is no span receiver with id " + spanReceiverId);
    }
}

