/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.util;

import java.io.IOException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IToken;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexTokenizingTupleIterator;

public class PartitionedInvertedIndexTokenizingTupleIterator
extends InvertedIndexTokenizingTupleIterator {
    protected short numTokens = 0;

    public PartitionedInvertedIndexTokenizingTupleIterator(int tokensFieldCount, int invListFieldCount, IBinaryTokenizer tokenizer) {
        super(tokensFieldCount, invListFieldCount, tokenizer);
    }

    @Override
    public void reset(ITupleReference inputTuple) {
        super.reset(inputTuple);
        this.numTokens = 0;
        while (this.tokenizer.hasNext()) {
            this.tokenizer.next();
            this.numTokens = (short)(this.numTokens + 1);
        }
        super.reset(inputTuple);
    }

    @Override
    public void next() throws HyracksDataException {
        this.tokenizer.next();
        IToken token = this.tokenizer.getToken();
        this.tupleBuilder.reset();
        try {
            token.serializeToken(this.tupleBuilder.getFieldData());
            this.tupleBuilder.addFieldEndOffset();
            this.tupleBuilder.getDataOutput().writeShort(this.numTokens);
            this.tupleBuilder.addFieldEndOffset();
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        for (int i = 0; i < this.invListFieldCount; ++i) {
            this.tupleBuilder.addField(this.inputTuple.getFieldData(i + 1), this.inputTuple.getFieldStart(i + 1), this.inputTuple.getFieldLength(i + 1));
        }
        this.tupleReference.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
    }

    public short getNumTokens() {
        return this.numTokens;
    }
}

