/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.aries.transaction.internal.NLS;
import org.apache.aries.transaction.internal.TransactionManagerService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
ManagedService {
    public static final String PID = "org.apache.aries.transaction";
    private static final Logger log = LoggerFactory.getLogger((String)"org.apache.aries.transaction");
    private BundleContext bundleContext;
    private TransactionManagerService manager;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.updated(null);
        bundleContext.registerService(ManagedService.class.getName(), (Object)this, this.getProps());
    }

    private Dictionary<String, Object> getProps() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.pid", PID);
        return props;
    }

    public void stop(BundleContext context) throws Exception {
        this.deleted();
    }

    public synchronized void updated(Dictionary properties) throws ConfigurationException {
        if (properties == null) {
            properties = this.getProps();
        }
        this.deleted();
        this.manager = new TransactionManagerService(PID, properties, this.bundleContext);
        try {
            this.manager.start();
        }
        catch (Exception e) {
            log.error(NLS.MESSAGES.getMessage("exception.tx.manager.start", new Object[0]), (Throwable)e);
        }
    }

    public synchronized void deleted() {
        if (this.manager != null) {
            try {
                this.manager.close();
            }
            catch (Exception e) {
                log.error(NLS.MESSAGES.getMessage("exception.tx.manager.stop", new Object[0]), (Throwable)e);
            }
            finally {
                this.manager = null;
            }
        }
    }
}

