/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jdbc.internal;

import java.util.ArrayList;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.CommonDataSource;
import org.tranql.connector.AllExceptionsAreFatalSorter;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.NoExceptionsAreFatalSorter;
import org.tranql.connector.jdbc.ConfigurableSQLStateExceptionSorter;
import org.tranql.connector.jdbc.KnownSQLStateExceptionSorter;

public abstract class AbstractMCFFactory {
    private CommonDataSource dataSource;
    private ExceptionSorter exceptionSorter = new AllExceptionsAreFatalSorter();
    private String userName;
    private String password;
    ManagedConnectionFactory connectionFactory;

    public ManagedConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public abstract void init() throws Exception;

    public void setExceptionSorterAsString(String sorter) {
        if ("all".equalsIgnoreCase(sorter)) {
            this.exceptionSorter = new AllExceptionsAreFatalSorter();
        } else if ("none".equalsIgnoreCase(sorter)) {
            this.exceptionSorter = new NoExceptionsAreFatalSorter();
        } else if ("known".equalsIgnoreCase(sorter)) {
            this.exceptionSorter = new KnownSQLStateExceptionSorter();
        } else if (sorter.toLowerCase().startsWith("custom(") && sorter.endsWith(")")) {
            ArrayList<String> states = new ArrayList<String>();
            for (String s : sorter.substring(7, sorter.length() - 2).split(",")) {
                if (s == null || s.length() <= 0) continue;
                states.add(s);
            }
            this.exceptionSorter = new ConfigurableSQLStateExceptionSorter(states);
        } else {
            throw new IllegalArgumentException("Unknown exceptionSorter " + sorter);
        }
    }

    public CommonDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(CommonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public ExceptionSorter getExceptionSorter() {
        return this.exceptionSorter;
    }

    public void setExceptionSorter(ExceptionSorter exceptionSorter) {
        this.exceptionSorter = exceptionSorter;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

