/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.health.HealthCheckResolver;
import org.apache.camel.spi.FactoryFinder;

public class DefaultHealthCheckResolver
implements HealthCheckResolver,
CamelContextAware {
    public static final String HEALTH_CHECK_RESOURCE_PATH = "META-INF/services/org/apache/camel/health-check/";
    protected FactoryFinder healthCheckFactory;
    private CamelContext camelContext;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public HealthCheck resolveHealthCheck(String id) {
        HealthCheck answer = (HealthCheck)this.camelContext.getRegistry().lookupByNameAndType(id + "-health-check", HealthCheck.class);
        if (answer == null) {
            answer = (HealthCheck)this.camelContext.getRegistry().lookupByNameAndType(id, HealthCheck.class);
        }
        if (answer != null) {
            return answer;
        }
        Class<?> type = null;
        try {
            type = this.findHealthCheck(id, this.camelContext);
        }
        catch (NoFactoryAvailableException noFactoryAvailableException) {
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI, no HealthCheck registered for id: " + id, e);
        }
        if (type != null) {
            if (HealthCheck.class.isAssignableFrom(type)) {
                return (HealthCheck)this.camelContext.getInjector().newInstance(type, false);
            }
            throw new IllegalArgumentException("Resolving health-check: " + id + " detected type conflict: Not a HealthCheck implementation. Found: " + type.getName());
        }
        return null;
    }

    public HealthCheckRepository resolveHealthCheckRepository(String id) {
        HealthCheckRepository answer = (HealthCheckRepository)this.camelContext.getRegistry().lookupByNameAndType(id + "-health-check-repository", HealthCheckRepository.class);
        if (answer == null) {
            answer = (HealthCheckRepository)this.camelContext.getRegistry().lookupByNameAndType(id, HealthCheckRepository.class);
        }
        if (answer != null) {
            return answer;
        }
        Class<?> type = null;
        try {
            type = this.findHealthCheckRepository(id, this.camelContext);
        }
        catch (NoFactoryAvailableException noFactoryAvailableException) {
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI, no HealthCheckRepository registered for id: " + id, e);
        }
        if (type != null) {
            if (HealthCheckRepository.class.isAssignableFrom(type)) {
                return (HealthCheckRepository)this.camelContext.getInjector().newInstance(type, false);
            }
            throw new IllegalArgumentException("Resolving health-check-repository: " + id + " detected type conflict: Not a HealthCheckRepository implementation. Found: " + type.getName());
        }
        return null;
    }

    protected Class<?> findHealthCheck(String name, CamelContext context) throws Exception {
        if (this.healthCheckFactory == null) {
            this.healthCheckFactory = context.getCamelContextExtension().getFactoryFinder(HEALTH_CHECK_RESOURCE_PATH);
        }
        return this.healthCheckFactory.findOptionalClass(name + "-check").orElse(null);
    }

    protected Class<?> findHealthCheckRepository(String name, CamelContext context) throws Exception {
        if (this.healthCheckFactory == null) {
            this.healthCheckFactory = context.getCamelContextExtension().getFactoryFinder(HEALTH_CHECK_RESOURCE_PATH);
        }
        return this.healthCheckFactory.findOptionalClass(name + "-repository").orElse(null);
    }
}

