/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web.view;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.QueueBrowser;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.apache.activemq.web.view.MessageRenderer;

public class SimpleMessageRenderer
implements MessageRenderer {
    private String contentType = "text/xml";
    private int maxMessages;

    @Override
    public void renderMessages(HttpServletRequest request, HttpServletResponse response, QueueBrowser browser) throws IOException, JMSException, ServletException {
        response.setContentType(this.getContentType());
        PrintWriter writer = response.getWriter();
        this.printHeader(writer, browser, request);
        Enumeration iter = browser.getEnumeration();
        for (int counter = 0; iter.hasMoreElements() && (this.maxMessages <= 0 || counter < this.maxMessages); ++counter) {
            Message message = (Message)iter.nextElement();
            this.renderMessage(writer, request, response, browser, message);
        }
        this.printFooter(writer, browser, request);
    }

    @Override
    public void renderMessage(PrintWriter writer, HttpServletRequest request, HttpServletResponse response, QueueBrowser browser, Message message) throws JMSException, ServletException {
        writer.print("<message id='");
        writer.print(message.getJMSMessageID());
        writer.println("'/>");
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    protected void printHeader(PrintWriter writer, QueueBrowser browser, HttpServletRequest request) throws IOException, JMSException, ServletException {
        writer.println("");
        writer.print("<messages queue='");
        writer.print(browser.getQueue());
        writer.print("'");
        String selector = browser.getMessageSelector();
        if (selector != null) {
            writer.print(" selector='");
            writer.print(selector);
            writer.print("'");
        }
        writer.println(">");
    }

    protected void printFooter(PrintWriter writer, QueueBrowser browser, HttpServletRequest request) throws IOException, JMSException, ServletException {
        writer.println("</messages>");
    }
}

