/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.com.github.benmanes.caffeine.cache;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.camel.com.github.benmanes.caffeine.cache.Caffeine;

public final class CaffeineSpec {
    static final String SPLIT_OPTIONS = ",";
    static final String SPLIT_KEY_VALUE = "=";
    final String specification;
    int initialCapacity = -1;
    long maximumWeight = -1L;
    long maximumSize = -1L;
    boolean recordStats;
    @Nullable
    Caffeine.Strength keyStrength;
    @Nullable
    Caffeine.Strength valueStrength;
    long expireAfterAccessDuration = -1L;
    @Nullable
    TimeUnit expireAfterAccessTimeUnit;
    long expireAfterWriteDuration = -1L;
    @Nullable
    TimeUnit expireAfterWriteTimeUnit;
    long refreshAfterWriteDuration = -1L;
    @Nullable
    TimeUnit refreshAfterWriteTimeUnit;

    private CaffeineSpec(String specification) {
        this.specification = Objects.requireNonNull(specification);
    }

    Caffeine<Object, Object> toBuilder() {
        Caffeine<Object, Object> builder = Caffeine.newBuilder();
        if (this.initialCapacity != -1) {
            builder.initialCapacity(this.initialCapacity);
        }
        if (this.maximumSize != -1L) {
            builder.maximumSize(this.maximumSize);
        }
        if (this.maximumWeight != -1L) {
            builder.maximumWeight(this.maximumWeight);
        }
        if (this.keyStrength != null) {
            Caffeine.requireState(this.keyStrength == Caffeine.Strength.WEAK);
            builder.weakKeys();
        }
        if (this.valueStrength != null) {
            if (this.valueStrength == Caffeine.Strength.WEAK) {
                builder.weakValues();
            } else if (this.valueStrength == Caffeine.Strength.SOFT) {
                builder.softValues();
            } else {
                throw new IllegalStateException();
            }
        }
        if (this.expireAfterAccessTimeUnit != null) {
            builder.expireAfterAccess(this.expireAfterAccessDuration, this.expireAfterAccessTimeUnit);
        }
        if (this.expireAfterWriteTimeUnit != null) {
            builder.expireAfterWrite(this.expireAfterWriteDuration, this.expireAfterWriteTimeUnit);
        }
        if (this.refreshAfterWriteTimeUnit != null) {
            builder.refreshAfterWrite(this.refreshAfterWriteDuration, this.refreshAfterWriteTimeUnit);
        }
        if (this.recordStats) {
            builder.recordStats();
        }
        return builder;
    }

    public static CaffeineSpec parse(String specification) {
        CaffeineSpec spec = new CaffeineSpec(specification);
        for (String option : specification.split(SPLIT_OPTIONS)) {
            spec.parseOption(option.trim());
        }
        return spec;
    }

    void parseOption(String option) {
        if (option.isEmpty()) {
            return;
        }
        String[] keyAndValue = option.split(SPLIT_KEY_VALUE);
        Caffeine.requireArgument(keyAndValue.length <= 2, "key-value pair %s with more than one equals sign", option);
        String key = keyAndValue[0].trim();
        String value = keyAndValue.length == 1 ? null : keyAndValue[1].trim();
        this.configure(key, value);
    }

    void configure(String key, @Nullable String value) {
        switch (key) {
            case "initialCapacity": {
                this.initialCapacity(key, value);
                return;
            }
            case "maximumSize": {
                this.maximumSize(key, value);
                return;
            }
            case "maximumWeight": {
                this.maximumWeight(key, value);
                return;
            }
            case "weakKeys": {
                this.weakKeys(value);
                return;
            }
            case "weakValues": {
                this.valueStrength(key, value, Caffeine.Strength.WEAK);
                return;
            }
            case "softValues": {
                this.valueStrength(key, value, Caffeine.Strength.SOFT);
                return;
            }
            case "expireAfterAccess": {
                this.expireAfterAccess(key, value);
                return;
            }
            case "expireAfterWrite": {
                this.expireAfterWrite(key, value);
                return;
            }
            case "refreshAfterWrite": {
                this.refreshAfterWrite(key, value);
                return;
            }
            case "recordStats": {
                this.recordStats(value);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown key " + key);
    }

    void initialCapacity(String key, @Nullable String value) {
        Caffeine.requireArgument(this.initialCapacity == -1, "initial capacity was already set to %,d", this.initialCapacity);
        this.initialCapacity = CaffeineSpec.parseInt(key, value);
    }

    void maximumSize(String key, @Nullable String value) {
        Caffeine.requireArgument(this.maximumSize == -1L, "maximum size was already set to %,d", this.maximumSize);
        Caffeine.requireArgument(this.maximumWeight == -1L, "maximum weight was already set to %,d", this.maximumWeight);
        this.maximumSize = CaffeineSpec.parseLong(key, value);
    }

    void maximumWeight(String key, @Nullable String value) {
        Caffeine.requireArgument(this.maximumWeight == -1L, "maximum weight was already set to %,d", this.maximumWeight);
        Caffeine.requireArgument(this.maximumSize == -1L, "maximum size was already set to %,d", this.maximumSize);
        this.maximumWeight = CaffeineSpec.parseLong(key, value);
    }

    void weakKeys(@Nullable String value) {
        Caffeine.requireArgument(value == null, "weak keys does not take a value", new Object[0]);
        Caffeine.requireArgument(this.keyStrength == null, "weak keys was already set", new Object[0]);
        this.keyStrength = Caffeine.Strength.WEAK;
    }

    void valueStrength(String key, @Nullable String value, Caffeine.Strength strength) {
        Caffeine.requireArgument(value == null, "%s does not take a value", key);
        Caffeine.requireArgument(this.valueStrength == null, "%s was already set to %s", new Object[]{key, this.valueStrength});
        this.valueStrength = strength;
    }

    void expireAfterAccess(String key, @Nullable String value) {
        Caffeine.requireArgument(this.expireAfterAccessDuration == -1L, "expireAfterAccess was already set", new Object[0]);
        this.expireAfterAccessDuration = CaffeineSpec.parseDuration(key, value);
        this.expireAfterAccessTimeUnit = CaffeineSpec.parseTimeUnit(key, value);
    }

    void expireAfterWrite(String key, @Nullable String value) {
        Caffeine.requireArgument(this.expireAfterWriteDuration == -1L, "expireAfterWrite was already set", new Object[0]);
        this.expireAfterWriteDuration = CaffeineSpec.parseDuration(key, value);
        this.expireAfterWriteTimeUnit = CaffeineSpec.parseTimeUnit(key, value);
    }

    void refreshAfterWrite(String key, @Nullable String value) {
        Caffeine.requireArgument(this.refreshAfterWriteDuration == -1L, "refreshAfterWrite was already set", new Object[0]);
        this.refreshAfterWriteDuration = CaffeineSpec.parseDuration(key, value);
        this.refreshAfterWriteTimeUnit = CaffeineSpec.parseTimeUnit(key, value);
    }

    void recordStats(@Nullable String value) {
        Caffeine.requireArgument(value == null, "record stats does not take a value", new Object[0]);
        Caffeine.requireArgument(!this.recordStats, "record stats was already set", new Object[0]);
        this.recordStats = true;
    }

    static int parseInt(String key, @Nullable String value) {
        Caffeine.requireArgument(value != null && !value.isEmpty(), "value of key %s was omitted", key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("key %s value was set to %s, must be an integer", key, value), e);
        }
    }

    static long parseLong(String key, @Nullable String value) {
        Caffeine.requireArgument(value != null && !value.isEmpty(), "value of key %s was omitted", key);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("key %s value was set to %s, must be a long", key, value), e);
        }
    }

    static long parseDuration(String key, @Nullable String value) {
        Caffeine.requireArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
        String duration = value.substring(0, value.length() - 1);
        return CaffeineSpec.parseLong(key, duration);
    }

    static TimeUnit parseTimeUnit(String key, @Nullable String value) {
        Caffeine.requireArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
        char lastChar = Character.toLowerCase(value.charAt(value.length() - 1));
        switch (lastChar) {
            case 'd': {
                return TimeUnit.DAYS;
            }
            case 'h': {
                return TimeUnit.HOURS;
            }
            case 'm': {
                return TimeUnit.MINUTES;
            }
            case 's': {
                return TimeUnit.SECONDS;
            }
        }
        throw new IllegalArgumentException(String.format("key %s invalid format; was %s, must end with one of [dDhHmMsS]", key, value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CaffeineSpec)) {
            return false;
        }
        CaffeineSpec spec = (CaffeineSpec)o;
        return Objects.equals(this.initialCapacity, spec.initialCapacity) && Objects.equals(this.maximumSize, spec.maximumSize) && Objects.equals(this.maximumWeight, spec.maximumWeight) && Objects.equals((Object)this.keyStrength, (Object)spec.keyStrength) && Objects.equals((Object)this.valueStrength, (Object)spec.valueStrength) && Objects.equals(this.recordStats, spec.recordStats) && CaffeineSpec.durationInNanos(this.expireAfterAccessDuration, this.expireAfterAccessTimeUnit) == CaffeineSpec.durationInNanos(spec.expireAfterAccessDuration, spec.expireAfterAccessTimeUnit) && CaffeineSpec.durationInNanos(this.expireAfterWriteDuration, this.expireAfterWriteTimeUnit) == CaffeineSpec.durationInNanos(spec.expireAfterWriteDuration, spec.expireAfterWriteTimeUnit) && CaffeineSpec.durationInNanos(this.refreshAfterWriteDuration, this.refreshAfterWriteTimeUnit) == CaffeineSpec.durationInNanos(spec.refreshAfterWriteDuration, spec.refreshAfterWriteTimeUnit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.initialCapacity, this.maximumSize, this.maximumWeight, this.keyStrength, this.valueStrength, this.recordStats, CaffeineSpec.durationInNanos(this.expireAfterAccessDuration, this.expireAfterAccessTimeUnit), CaffeineSpec.durationInNanos(this.expireAfterWriteDuration, this.expireAfterWriteTimeUnit), CaffeineSpec.durationInNanos(this.refreshAfterWriteDuration, this.refreshAfterWriteTimeUnit)});
    }

    static long durationInNanos(long duration, @Nullable TimeUnit unit) {
        return unit == null ? -1L : unit.toNanos(duration);
    }

    public String toParsableString() {
        return this.specification;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + this.toParsableString() + '}';
    }
}

