/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.spi.fs.VolumeChooserEnvironment;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface VolumeManager
extends AutoCloseable {
    public static final Logger log = LoggerFactory.getLogger(VolumeManager.class);

    @Override
    public void close() throws IOException;

    public FSDataOutputStream create(Path var1) throws IOException;

    public FSDataOutputStream overwrite(Path var1) throws IOException;

    public FSDataOutputStream create(Path var1, boolean var2, int var3, short var4, long var5) throws IOException;

    public boolean createNewFile(Path var1) throws IOException;

    public FSDataOutputStream createSyncable(Path var1, int var2, short var3, long var4) throws IOException;

    public boolean delete(Path var1) throws IOException;

    public boolean deleteRecursively(Path var1) throws IOException;

    public boolean exists(Path var1) throws IOException;

    public FileStatus getFileStatus(Path var1) throws IOException;

    public FileSystem getFileSystemByPath(Path var1);

    public Path matchingFileSystem(Path var1, Set<String> var2);

    public RemoteIterator<LocatedFileStatus> listFiles(Path var1, boolean var2) throws IOException;

    public FileStatus[] listStatus(Path var1) throws IOException;

    public boolean mkdirs(Path var1) throws IOException;

    public boolean mkdirs(Path var1, FsPermission var2) throws IOException;

    public FSDataInputStream open(Path var1) throws IOException;

    public boolean rename(Path var1, Path var2) throws IOException;

    public void bulkRename(Map<Path, Path> var1, int var2, String var3, String var4) throws IOException;

    public boolean moveToTrash(Path var1) throws IOException;

    public short getDefaultReplication(Path var1);

    public boolean isReady() throws IOException;

    public FileStatus[] globStatus(Path var1) throws IOException;

    public String choose(VolumeChooserEnvironment var1, Set<String> var2);

    public Set<String> choosable(VolumeChooserEnvironment var1, Set<String> var2);

    public boolean canSyncAndFlush(Path var1);

    default public Volume getFirst() {
        return this.getVolumes().iterator().next();
    }

    public Collection<Volume> getVolumes();

    public static InstanceId getInstanceIDFromHdfs(Path instanceDirectory, Configuration hadoopConf) {
        try {
            FileSystem fs = VolumeConfiguration.fileSystemForPath((String)instanceDirectory.toString(), (Configuration)hadoopConf);
            FileStatus[] files = null;
            try {
                files = fs.listStatus(instanceDirectory);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            log.debug("Trying to read instance id from {}", (Object)instanceDirectory);
            if (files == null || files.length == 0) {
                log.error("unable to obtain instance id at {}", (Object)instanceDirectory);
                throw new IllegalStateException("Accumulo not initialized, there is no instance id at " + instanceDirectory);
            }
            if (files.length != 1) {
                log.error("multiple potential instances in {}", (Object)instanceDirectory);
                throw new IllegalStateException("Accumulo found multiple possible instance ids in " + instanceDirectory);
            }
            return InstanceId.of((String)files[0].getPath().getName());
        }
        catch (IOException e) {
            log.error("Problem reading instance id out of hdfs at " + instanceDirectory, (Throwable)e);
            throw new UncheckedIOException("Can't tell if Accumulo is initialized; can't read instance id at " + instanceDirectory, e);
        }
        catch (IllegalArgumentException exception) {
            if (exception.getCause() instanceof UnknownHostException) {
                log.error("Problem reading instance id out of hdfs at " + instanceDirectory, (Throwable)exception);
            }
            throw exception;
        }
    }

    public static enum FileType {
        TABLE("tables"),
        WAL("wal"),
        RECOVERY("recovery");

        private String dir;

        private FileType(String dir) {
            this.dir = dir;
        }

        public String getDirectory() {
            return this.dir;
        }

        private static int endOfVolumeIndex(String path, String dir) {
            int dirIndex = path.indexOf("/" + dir + "/");
            if (dirIndex != -1) {
                return dirIndex;
            }
            if (path.endsWith("/" + dir)) {
                return path.length() - (dir.length() + 1);
            }
            if (path.contains(":")) {
                throw new IllegalArgumentException(path + " is absolute, but does not contain " + dir);
            }
            return -1;
        }

        public Path getVolume(Path path) {
            String pathString = path.toString();
            int eopi = FileType.endOfVolumeIndex(pathString, this.dir);
            if (eopi != -1) {
                return new Path(pathString.substring(0, eopi + 1));
            }
            return null;
        }

        public Path removeVolume(Path path) {
            String pathString = path.toString();
            int eopi = FileType.endOfVolumeIndex(pathString, this.dir);
            if (eopi != -1) {
                return new Path(pathString.substring(eopi + 1));
            }
            return null;
        }
    }
}

