/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.fs;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.spi.fs.PreferredVolumeChooser;
import org.apache.accumulo.core.spi.fs.VolumeChooserEnvironment;
import org.apache.accumulo.core.util.LazySingletons;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceAwareVolumeChooser
extends PreferredVolumeChooser {
    public static final String RECOMPUTE_INTERVAL = "spaceaware.volume.chooser.recompute.interval";
    private long defaultComputationCacheDuration = 300000L;
    private LoadingCache<Set<String>, WeightedRandomCollection> choiceCache = null;
    private static final Logger log = LoggerFactory.getLogger(SpaceAwareVolumeChooser.class);
    private Configuration conf = new Configuration();

    protected double getFreeSpace(String uri) throws IOException {
        FileSystem pathFs = new Path(uri).getFileSystem(this.conf);
        FsStatus optionStatus = pathFs.getStatus();
        return (double)optionStatus.getRemaining() / (double)optionStatus.getCapacity();
    }

    @Override
    public String choose(VolumeChooserEnvironment env, Set<String> options) {
        return ((WeightedRandomCollection)this.getCache(env).get(this.getPreferredVolumes(env, options))).next();
    }

    private synchronized LoadingCache<Set<String>, WeightedRandomCollection> getCache(VolumeChooserEnvironment env) {
        if (this.choiceCache == null) {
            String propertyValue = env.getServiceEnv().getConfiguration().getCustom(RECOMPUTE_INTERVAL);
            long computationCacheDuration = StringUtils.isNotBlank((CharSequence)propertyValue) ? Long.parseLong(propertyValue) : this.defaultComputationCacheDuration;
            this.choiceCache = Caffeine.newBuilder().expireAfterWrite(computationCacheDuration, TimeUnit.MILLISECONDS).build(key -> new WeightedRandomCollection((Set<String>)key, env));
        }
        return this.choiceCache;
    }

    private class WeightedRandomCollection {
        private final NavigableMap<Double, String> map = new TreeMap<Double, String>();
        private double total = 0.0;

        private WeightedRandomCollection(Set<String> options, VolumeChooserEnvironment env) {
            if (options.size() < 1) {
                throw new IllegalStateException("Options was empty! No valid volumes to choose from.");
            }
            for (String option : options) {
                try {
                    double percentFree = SpaceAwareVolumeChooser.this.getFreeSpace(option);
                    this.add(percentFree, option);
                }
                catch (IOException e) {
                    log.error("Unable to get file system status for" + option, (Throwable)e);
                }
            }
            if (this.map.size() < 1) {
                throw new IllegalStateException("Weighted options was empty! Could indicate an issue getting file system status or no free space on any volume");
            }
        }

        public WeightedRandomCollection add(double weight, String result) {
            if (weight <= 0.0) {
                log.info("Weight was 0. Not adding " + result);
                return this;
            }
            this.total += weight;
            this.map.put(this.total, result);
            return this;
        }

        public String next() {
            double value = LazySingletons.RANDOM.get().nextDouble() * this.total;
            return this.map.higherEntry(value).getValue();
        }
    }
}

