/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.balancer;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.manager.balancer.AssignmentParamsImpl;
import org.apache.accumulo.core.manager.balancer.BalanceParamsImpl;
import org.apache.accumulo.core.spi.balancer.BalancerEnvironment;
import org.apache.accumulo.core.spi.balancer.SimpleLoadBalancer;
import org.apache.accumulo.core.spi.balancer.TabletBalancer;
import org.apache.accumulo.core.spi.balancer.data.TabletMigration;
import org.apache.accumulo.core.spi.balancer.data.TabletServerId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableLoadBalancer
implements TabletBalancer {
    private static final Logger log = LoggerFactory.getLogger(TableLoadBalancer.class);
    protected BalancerEnvironment environment;
    Map<TableId, TabletBalancer> perTableBalancers = new HashMap<TableId, TabletBalancer>();

    @Override
    public void init(BalancerEnvironment balancerEnvironment) {
        this.environment = balancerEnvironment;
    }

    private TabletBalancer constructNewBalancerForTable(String clazzName, TableId tableId) throws Exception {
        String context = this.environment.tableContext(tableId);
        Class<TabletBalancer> clazz = ClassLoaderUtil.loadClass(context, clazzName, TabletBalancer.class);
        Constructor<TabletBalancer> constructor = clazz.getConstructor(TableId.class);
        return constructor.newInstance(tableId);
    }

    protected String getLoadBalancerClassNameForTable(TableId table) {
        if (this.environment.isTableOnline(table)) {
            return this.environment.getConfiguration(table).get(Property.TABLE_LOAD_BALANCER.getKey());
        }
        return null;
    }

    protected TabletBalancer getBalancerForTable(TableId tableId) {
        TabletBalancer balancer = this.perTableBalancers.get(tableId);
        String clazzName = this.getLoadBalancerClassNameForTable(tableId);
        if (clazzName == null) {
            clazzName = SimpleLoadBalancer.class.getName();
        }
        if (balancer != null && !clazzName.equals(balancer.getClass().getName())) {
            try {
                balancer = this.constructNewBalancerForTable(clazzName, tableId);
                this.perTableBalancers.put(tableId, balancer);
                balancer.init(this.environment);
                log.info("Loaded new class {} for table {}", (Object)clazzName, (Object)tableId);
            }
            catch (Exception e) {
                log.warn("Failed to load table balancer class {} for table {}", new Object[]{clazzName, tableId, e});
            }
        }
        if (balancer == null) {
            try {
                balancer = this.constructNewBalancerForTable(clazzName, tableId);
                log.info("Loaded class {} for table {}", (Object)clazzName, (Object)tableId);
            }
            catch (Exception e) {
                log.warn("Failed to load table balancer class {} for table {}", new Object[]{clazzName, tableId, e});
            }
            if (balancer == null) {
                log.info("Using balancer {} for table {}", (Object)SimpleLoadBalancer.class.getName(), (Object)tableId);
                balancer = new SimpleLoadBalancer(tableId);
            }
            this.perTableBalancers.put(tableId, balancer);
            balancer.init(this.environment);
        }
        return balancer;
    }

    @Override
    public void getAssignments(TabletBalancer.AssignmentParameters params) {
        HashMap groupedUnassigned = new HashMap();
        params.unassignedTablets().forEach((tid, lastTserver) -> groupedUnassigned.computeIfAbsent(tid.getTable(), k -> new HashMap()).put(tid, lastTserver));
        for (Map.Entry e : groupedUnassigned.entrySet()) {
            HashMap<TabletId, TabletServerId> newAssignments = new HashMap<TabletId, TabletServerId>();
            this.getBalancerForTable((TableId)e.getKey()).getAssignments(new AssignmentParamsImpl(params.currentStatus(), (Map)e.getValue(), newAssignments));
            newAssignments.forEach(params::addAssignment);
        }
    }

    @Override
    public long balance(TabletBalancer.BalanceParameters params) {
        long minBalanceTime = 5000L;
        for (TableId tableId : this.environment.getTableIdMap().values()) {
            ArrayList<TabletMigration> newMigrations = new ArrayList<TabletMigration>();
            long tableBalanceTime = this.getBalancerForTable(tableId).balance(new BalanceParamsImpl(params.currentStatus(), params.currentMigrations(), newMigrations));
            if (tableBalanceTime < minBalanceTime) {
                minBalanceTime = tableBalanceTime;
            }
            params.migrationsOut().addAll(newMigrations);
        }
        return minBalanceTime;
    }
}

