/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iteratorsImpl.system;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.ServerSkippingIterator;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.system.InterruptibleIterator;

public class ColumnFamilySkippingIterator
extends ServerSkippingIterator
implements InterruptibleIterator {
    protected Set<ByteSequence> colFamSet = null;
    protected TreeSet<ByteSequence> sortedColFams = null;
    protected boolean inclusive = false;
    protected Range range;

    public ColumnFamilySkippingIterator(SortedKeyValueIterator<Key, Value> source) {
        super(source);
    }

    protected ColumnFamilySkippingIterator(SortedKeyValueIterator<Key, Value> source, Set<ByteSequence> colFamSet, boolean inclusive) {
        this(source);
        this.colFamSet = colFamSet;
        this.inclusive = inclusive;
    }

    @Override
    protected void consume() throws IOException {
        block7: {
            int count;
            block6: {
                count = 0;
                if (!this.inclusive) break block6;
                while (this.source.hasTop() && !this.colFamSet.contains(((Key)this.source.getTopKey()).getColumnFamilyData())) {
                    if (count < 10) {
                        this.source.next();
                        ++count;
                        continue;
                    }
                    ByteSequence higherCF = this.sortedColFams.higher(((Key)this.source.getTopKey()).getColumnFamilyData());
                    if (higherCF == null) {
                        this.reseek(((Key)this.source.getTopKey()).followingKey(PartialKey.ROW));
                    } else {
                        this.reseek(new Key(((Key)this.source.getTopKey()).getRowData().toArray(), higherCF.toArray(), new byte[0], new byte[0], Long.MAX_VALUE));
                    }
                    count = 0;
                }
                break block7;
            }
            if (this.colFamSet == null || this.colFamSet.isEmpty()) break block7;
            while (this.source.hasTop() && this.colFamSet.contains(((Key)this.source.getTopKey()).getColumnFamilyData())) {
                if (count < 10) {
                    this.source.next();
                    ++count;
                    continue;
                }
                this.reseek(((Key)this.source.getTopKey()).followingKey(PartialKey.ROW_COLFAM));
                count = 0;
            }
        }
    }

    private void reseek(Key key) throws IOException {
        if (this.range.afterEndKey(key)) {
            this.range = new Range(this.range.getEndKey(), true, this.range.getEndKey(), this.range.isEndKeyInclusive());
            this.source.seek(this.range, this.colFamSet, this.inclusive);
        } else {
            this.range = new Range(key, true, this.range.getEndKey(), this.range.isEndKeyInclusive());
            this.source.seek(this.range, this.colFamSet, this.inclusive);
        }
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new ColumnFamilySkippingIterator(this.source.deepCopy(env), this.colFamSet, this.inclusive);
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        if (columnFamilies instanceof Set) {
            this.colFamSet = (Set)columnFamilies;
        } else {
            this.colFamSet = new HashSet<ByteSequence>();
            this.colFamSet.addAll(columnFamilies);
        }
        this.sortedColFams = inclusive ? new TreeSet<ByteSequence>(this.colFamSet) : null;
        this.range = range;
        this.inclusive = inclusive;
        super.seek(range, this.colFamSet, inclusive);
    }

    @Override
    public void setInterruptFlag(AtomicBoolean flag) {
        ((InterruptibleIterator)this.source).setInterruptFlag(flag);
    }
}

