/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.namespace.delete;

import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.namespace.delete.NamespaceCleanUp;

public class DeleteNamespace
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private NamespaceId namespaceId;

    public DeleteNamespace(NamespaceId namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    public long isReady(long id, Manager environment) throws Exception {
        return Utils.reserveNamespace(environment, this.namespaceId, id, true, true, TableOperation.DELETE);
    }

    @Override
    public Repo<Manager> call(long tid, Manager environment) {
        environment.getEventCoordinator().event("deleting namespace %s ", this.namespaceId);
        return new NamespaceCleanUp(this.namespaceId);
    }

    @Override
    public void undo(long id, Manager environment) {
        Utils.unreserveNamespace(environment, this.namespaceId, id, true);
    }
}

