//==========================================================================
//
//	title		: DS-1E playback sample
//	company		: YAMAHA
//	author		: Taichi Sugiyama
//	create Data : 12/Oct/99
//	version		: 1.00
//
//==========================================================================
#include <dos.h>
#include <math.h>
#include <malloc.h>
#include <string.h>
#include <signal.h>
#include "dpmi.h"
#include "define.h"
#include "wavfile.h"
#include "prottype.h"


//#define	TRACE_MAIN
#ifdef TRACE_MAIN
#define	DPF(X)		cprintf("TRACE_MAIN:");cprintf X
#define	dprintf(X)	cprintf X
#else
#define	DPF(X)
#define	dprintf(X)
#endif


//==== global values =======================================================
HWINFO		hwi;
DATAINFO	dinf;
BYTE		gszWavFile[128];
#include "Hwmcode.h"


//==========================================================================
//	version
//	
//	
//==========================================================================
void	version(void)
{
	cprintf("DS-1E Playback utility.  ver %s\n\r",  "1.00");
	cprintf("Copyright (c) YAMAHA Corporation 1998-1999. All rights reserved.\n\r");
}


//==========================================================================
//	usage
//	
//	
//==========================================================================
void	usage(BYTE* pbExName)
{
	BYTE* p;

	p = &pbExName[strlen(pbExName)];
	while(*(--p) != '\\');

	printf("\n usage:Program Name \"%s\"\n", ++p);
	printf("  %s [fname][/?]\n", p);
	printf("   /?   : This screen (Help).\n\n");
	exit(0);
}


//==========================================================================
//	check option
//	
//	
//==========================================================================
int	checkOption(int argc, char** argv)
{
	int	i;


	strcpy(gszWavFile, "test.wav");
	for(i=1; i<argc; i++) {
		if((argv[i][0] == '-') || (argv[i][0] == '/')) {
			switch(argv[i][1]) {
				case '?':
					usage(argv[0]);
					break;

				default :
					break;
			}
		}
		else {
			strcpy(gszWavFile, argv[i]);
		}
	}

	return 0;
}


//==========================================================================
//	check DS-XG
//	
//	
//==========================================================================
int	checkDSXG(PPCIKEY ppkey)
{
	if(PCIFindDevice(YAMAHA, YMF754,  0, ppkey)==0)
		return 0;
	else
		return 1;
}


//==========================================================================
//	check CODEC
//	
//	
//==========================================================================
int	checkCODEC(PHWINFO phwi)
{
	//---- hardware C# reset -----------------------------------------------
	Hw_AC97LinkReset(phwi);

	//---- check primary busy ----------------------------------------------
	if(Hw_CheckPrimaryBusy(phwi)) {
		DPF(("Error : AC-Link too busy!!\n\r"));
		return 1;
	}

	return 0;
}


//==========================================================================
//	setup instruction code
//
//
//==========================================================================
int	SetupInstruction(PHWINFO phwi)
{
	WORD	wGCtrl;
	DWORD	i;

	Hw_WriteRegDword(phwi, YDSXGR_NATIVEDACOUTVOL, 0x00000000);	// mute native DAC
	Hw_DisableDSP(&hwi);										// disable DSP
	Hw_WriteRegDword(phwi, YDSXGR_MODE, 0x00010000);			// DS-XG software reset
	Hw_WriteRegDword(phwi, YDSXGR_MODE, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_MAPOFREC, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_MAPOFEFFECT, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_PLAYCTRLBASE, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_RECCTRLBASE, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_EFFCTRLBASE, 0x00000000);
	wGCtrl = Hw_ReadRegWord(phwi, YDSXGR_GLOBALCTRL);
	Hw_WriteRegWord(phwi, YDSXGR_GLOBALCTRL, (WORD)(wGCtrl & ~0x0007));

	//---- setup DSP instruction code --------------------------------------
	for(i=0; i<YDSXG_DSPLENGTH; i+=4) {
		Hw_WriteRegDword(phwi, (DWORD)(YDSXGR_DSPINSTRAM + i), gdwDSPCode[i >> 2]);
	}

	//---- setup control instruction code ----------------------------------
	for(i=0; i<YDSXG_CTRLLENGTH; i+=4)
		Hw_WriteRegDword(phwi, (DWORD)(YDSXGR_CTRLINSTRAM + i), gdwCtrl1eCode[i >> 2]);

	//---- enable DSP ------------------------------------------------------
	Hw_EnableDSP(phwi);

	return 0;
}


//==========================================================================
//	allocate external memory
//
//
//==========================================================================
int	AllocateExtMemory(PHWINFO phwi)
{
	DWORD	i, j;
	DWORD	dwBase;
	DWORD	dwOffset;


	//---- calculate allocate size -----------------------------------------
	phwi->dwWodBankByteSize = (DWORD)(Hw_ReadRegDword(phwi, YDSXGR_PLAYCTRLSIZE) << 2);
	phwi->dwWidBankByteSize = (DWORD)(Hw_ReadRegDword(phwi, YDSXGR_RECCTRLSIZE) << 2);
	phwi->dwEffBankByteSize = (DWORD)(Hw_ReadRegDword(phwi, YDSXGR_EFFCTRLSIZE) << 2);
	phwi->dwWodBuffByteSize = DEF_WODBUFFLENGTH;
	phwi->dwWidBuffByteSize = DEF_WIDBUFFLENGTH;
	phwi->dwEffBuffByteSize = DEF_EFFBUFFLENGTH;
	phwi->dwWorkBuffByteSize = DEF_WORKBUFFLENGTH;
	phwi->dwBuffSize = (2 * phwi->dwWodBankByteSize * DEF_MAXWOD) +	\
			 (2 * phwi->dwWidBankByteSize * DEF_MAXWID) +	\
			 (2 * phwi->dwEffBankByteSize * DEF_MAXEFF) +	\
			phwi->dwWodBuffByteSize +	\
			phwi->dwWidBuffByteSize +	\
			phwi->dwEffBuffByteSize +	\
			phwi->dwWorkBuffByteSize +	\
			0x1000 + 0x100;
	//	wod control bank size +
	//	wid control bank size +
	//	effect control bank size +
	//	wod buffer size       +
	//	wid buffer size       +
	//	effect buffer size    +
	//	work buffer size      +
	//	dummy buffer size     +
	//	wod control table size

	//---- debug information ----------------------------------------------
	DPF(("dwWodBankByteSize :%08lX\n\r", phwi->dwWodBankByteSize));
	DPF(("dwWidBankByteSize :%08lX\n\r", phwi->dwWidBankByteSize));
	DPF(("dwEffBankByteSize :%08lX\n\r", phwi->dwEffBankByteSize));
	DPF(("dwWodBuffByteSize :%08lX\n\r", phwi->dwWodBuffByteSize));
	DPF(("dwWidBuffByteSize :%08lX\n\r", phwi->dwWidBuffByteSize));
	DPF(("dwEffBuffByteSize :%08lX\n\r", phwi->dwEffBuffByteSize));
	DPF(("dwWorkBuffByteSize:%08lX\n\r", phwi->dwWorkBuffByteSize));
	DPF(("dwSize:%08lX\n\r", phwi->dwBuffSize));

	//---- allocate memory -------------------------------------------------
	if(DPMIAllocRMMemory(((phwi->dwBuffSize >> 4) + 1), &phwi->wExtSeg, &phwi->wExtSel) != 0) {
		return 1;
	}

	//---- play control table ----------------------------------------------
	dwOffset = 0L;
	dwBase = (DWORD)phwi->wExtSeg << 4;
	phwi->dwWodCtrlBase = dwBase;
	phwi->lpdWodCtrlTable = (LPDWORD)phwi->dwWodCtrlBase;
	dwOffset += 0x100;

	//---- play control slot -----------------------------------------------
	for(i=0; i<DEF_MAXWOD; i++) {
		phwi->wodinfo[i].dwBankBaseAdr = dwBase + dwOffset;
		for(j=0; j<2; j++) {
			phwi->wodinfo[i].lpWodBank[j] = (WODBANK far*)(dwBase + dwOffset);
			dwOffset += phwi->dwWodBankByteSize;
		}
	}

	//---- recording control slot -----------------------------------------
	phwi->dwWidCtrlBase = dwBase + dwOffset;
	for(i=0; i<DEF_MAXWID; i++) {
		for(j=0; j<2; j++) {
			phwi->widinfo[i].lpWidBank[j] = (WIDBANK far*)(dwBase + dwOffset);
			dwOffset += phwi->dwWidBankByteSize;
		}
	}

	//---- effect control slot --------------------------------------------
	phwi->dwEffCtrlBase = dwBase + dwOffset;
	for(i=0; i<DEF_MAXEFF; i++) {
		for(j=0; j<2; j++) {
			phwi->effinfo[i].lpEffBank[j] = (EFFBANK far*)(dwBase + dwOffset);
			dwOffset += phwi->dwEffBankByteSize;
		}
	}

	//---- wod buffer -----------------------------------------------------
	phwi->dwWodBuffBase = dwBase + dwOffset;
	phwi->lpbWodBuffer = (LPBYTE)phwi->dwWodBuffBase;
	dwOffset += phwi->dwWodBuffByteSize;

	//---- wid buffer -----------------------------------------------------
	dwOffset += 0x800;	//	dummy buffer
	phwi->dwWidBuffBase = dwBase + dwOffset;
	phwi->lpbWidBuffer = (LPBYTE)phwi->dwWidBuffBase;
	dwOffset += phwi->dwWidBuffByteSize;

	//---- effect buffer --------------------------------------------------
	dwOffset += 0x800;	//	dummy buffer
	phwi->dwEffBuffBase = dwBase + dwOffset;
	phwi->lpbEffBuffer = (LPBYTE)phwi->dwEffBuffBase;
	dwOffset += phwi->dwEffBuffByteSize;

	//---- work buffer ----------------------------------------------------
	phwi->dwWorkBuffBase = dwBase + dwOffset;
	phwi->lpbWorkBuffer = (LPBYTE)phwi->dwWorkBuffBase;
	
	//---- 0 fill ---------------------------------------------------------
	for(i=0; i<(phwi->dwBuffSize >> 2); i++)
		*(phwi->lpdWodCtrlTable + i) = 0x0000000;

	//---- debug information ----------------------------------------------
	DPF(("dwWodCtrlBase :%08lX\n\r", phwi->dwWodCtrlBase));
	DPF(("dwWidCtrlBase :%08lX\n\r", phwi->dwWidCtrlBase));
	DPF(("dwEffCtrlBase :%08lX\n\r", phwi->dwEffCtrlBase));
	DPF(("dwWodBuffBase :%08lX\n\r", phwi->dwWodBuffBase));
	DPF(("dwWidBuffBase :%08lX\n\r", phwi->dwWidBuffBase));
	DPF(("dwEffBuffBase :%08lX\n\r", phwi->dwEffBuffBase));
	DPF(("dwWorkBuffBase:%08lX\n\r", phwi->dwWorkBuffBase));

	return 0;
}


//==========================================================================
//	free external memory
//
//
//==========================================================================
int	FreeExtMemory(PHWINFO phwi)
{
	DPMIFreeRMMemory(phwi->wExtSel);
	return 0;
}


//==========================================================================
//	map of native register use DPMI host
//
//
//==========================================================================
int	MapOfNativeReg(PHWINFO phwi)
{
	//---- allocate local descriptor table ---------------------------------
	phwi->wNatSeg = DPMIAllocLDT();
	if(phwi->wNatSeg == 0 )
		return 1;

	//---- map of external register ----------------------------------------
	phwi->dwLinearAdr = DPMIPhysicalToLinear(phwi->dwBaseAdr, YDSXG_MAPLENGTH);
	if(phwi->dwLinearAdr == 0L)
		return 1;

	DPMISetRights(phwi->wNatSeg);
	DPMISetBaseAddr(phwi->wNatSeg, phwi->dwLinearAdr);
	DPMISetLimit(phwi->wNatSeg, YDSXG_MAPLENGTH);

	//---- make pointer to native register ---------------------------------
	phwi->lpbNativeReg = (LPBYTE)MK_FP(phwi->wNatSeg, 0x0000);
	phwi->lpwNativeReg = (LPWORD)MK_FP(phwi->wNatSeg, 0x0000);
	phwi->lpdNativeReg = (LPDWORD)MK_FP(phwi->wNatSeg, 0x0000);

	return 0;
}


//==========================================================================
//	initialize DS-XG
//
//
//==========================================================================
int	InitializeDSXG(PHWINFO phwi)
{
	WORD	wCmd;


	//---- save hardware information ---------------------------------------
	phwi->wVendorID = PCIReadConfigWord(&phwi->pcikey, PCIR_VID);
	phwi->wDeviceID = PCIReadConfigWord(&phwi->pcikey, PCIR_DID);
	phwi->bRevisionID = PCIReadConfigByte(&phwi->pcikey, PCIR_RID);
	phwi->dwBaseAdr = PCIReadConfigDword(&phwi->pcikey, PCIR_NAMBAR);
	phwi->bIrq = PCIReadConfigByte(&phwi->pcikey, PCIR_INTR_LN);

	//---- debug -----------------------------------------------------------
	DPF(("vendor ID    : %04X\n\r", phwi->wVendorID));
	DPF(("device ID    : %04X\n\r", phwi->wDeviceID));
	DPF(("revision ID  : %02X\n\r", phwi->bRevisionID));
	DPF(("base address : %08lX\n\r", phwi->dwBaseAdr));
	DPF(("IRQ          : %02X\n\r", phwi->bIrq));

	//---- check resource --------------------------------------------------
	if((phwi->dwBaseAdr == 0x00000000) || (phwi->bIrq == 0x00)) {
		DPF(("Error : Resorces can not assign.\n\r"));
		return 1;
	}

	//---- map of native register ------------------------------------------
	if(MapOfNativeReg(phwi) != 0) {
		DPF(("Error : Can not mapping native register.\n\r"));
		return 1;
	}

	//---- enable BMS and MS -----------------------------------------------
	wCmd = PCIReadConfigWord(&phwi->pcikey, PCIR_PCICMD);
	PCIWriteConfigWord(&phwi->pcikey, PCIR_PCICMD, (WORD)(wCmd | 0x06));

	//---- check CODEC -----------------------------------------------------
	if(checkCODEC(phwi)!=0) {
		DPF(("Error : CODEC might be not connected.\n\r"));
		return 1;
	}

	//---- setup instruction code ------------------------------------------
	SetupInstruction(phwi);

	//---- allocate external memory ----------------------------------------
	if(AllocateExtMemory(phwi) != 0) {
		DPF(("Error : Can not allocate external memory.\n\r"));
		return 1;
	}

	//---- setup interrupt -------------------------------------------------
	SetupInterrupt(phwi);

	//---- set base address etc---------------------------------------------
	Hw_WriteRegDword(phwi, YDSXGR_PLAYCTRLBASE, phwi->dwWodCtrlBase);
	Hw_WriteRegDword(phwi, YDSXGR_RECCTRLBASE, phwi->dwWidCtrlBase);
	Hw_WriteRegDword(phwi, YDSXGR_EFFCTRLBASE, phwi->dwEffCtrlBase);
	Hw_WriteRegDword(phwi, YDSXGR_WORKBASE, phwi->dwWorkBuffBase);
	Hw_WriteRegDword(phwi, YDSXGR_WORKSIZE, phwi->dwWorkBuffByteSize >> 2);

	return 0;
}


//==========================================================================
//	terminate DS-XG
//
//
//==========================================================================
int	TerminateDSXG(void)
{
	WORD	wGCtrl;

	DPF(("Terminate"));

	//---- mute ------------------------------------------------------------
	Hw_WriteRegDword(&hwi, YDSXGR_NATIVEDACOUTVOL, 0x00000000);

	//---- stop hardware ---------------------------------------------------
	Hw_Stop(&hwi);

	//---- uninstall interrupt ---------------------------------------------
	Hw_WriteRegDword(&hwi, YDSXGR_STATUS, 0xFFFFFFFF);		//	clear interrupt
	UninstallInterrupt(&hwi);

	//---- free externl memory ---------------------------------------------
	FreeExtMemory(&hwi);

	Hw_WriteRegDword(&hwi, YDSXGR_NATIVEDACOUTVOL, 0x00000000);	// mute native DAC
	Hw_DisableDSP(&hwi);										// disable DSP
	Hw_WriteRegDword(&hwi, YDSXGR_MAPOFREC, 0x00000000);
	Hw_WriteRegDword(&hwi, YDSXGR_MAPOFEFFECT, 0x00000000);
	Hw_WriteRegDword(&hwi, YDSXGR_PLAYCTRLBASE, 0x00000000);
	Hw_WriteRegDword(&hwi, YDSXGR_RECCTRLBASE, 0x00000000);
	Hw_WriteRegDword(&hwi, YDSXGR_EFFCTRLBASE, 0x00000000);
	Hw_WriteRegDword(&hwi, YDSXGR_WORKBASE, 0x00000000);
	wGCtrl = Hw_ReadRegWord(&hwi, YDSXGR_GLOBALCTRL);
	Hw_WriteRegWord(&hwi, YDSXGR_GLOBALCTRL, (WORD)(wGCtrl & ~0x0007));

	//---- free native register --------------------------------------------
	DPMIFreePhysical(hwi.wNatSeg, hwi.dwLinearAdr);

	dprintf(("/End\n\r"));

	return 0;
}


//==========================================================================
//	signal(ctrl+break or ctrl+c)
//	
//	
//==========================================================================
void	break_service(int sin_number)
{
	DPF(("break_service"));

	TerminateDSXG();

	dprintf(("/End\n\r"));
	exit(1);
}


//==========================================================================
//	mute native mixer
//
//
//==========================================================================
void	MuteNativeMixer(PHWINFO phwi)
{
	DPF(("MuteNativeMixer"));

	Hw_WriteRegDword(phwi, YDSXGR_LEGACYOUTVOL, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_NATIVEDACOUTVOL, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_SPDIFOUTVOL, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_AC3OUTVOL, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_PRIADCOUTVOL, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_NATIVEADCINVOL, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_NATIVEDACINVOL, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_NATIVEDACLOOPVOLL, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_AC3LOOPVOL, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_PRIADCLOOPVOL, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_LEGACYLOOPVOL, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_SPDIFLOOPVOL, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_SPDIFOUTVOL2, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_SPDIFLOOPVOL2, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_BUF441OUTVOL, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_BUF441LOOPVOL, 0x00000000);

	dprintf(("/End\n\r"));
}


//==========================================================================
//	main routine
//
//
//==========================================================================
BYTE	FileOpen(BYTE* fname, PDATAINFO pdinf)
{
	if((pdinf->fp = fopen(fname, "rb")) == NULL)
		return 1;

	pdinf->dwDataSize = Wav_GetInfo(pdinf->fp, &pdinf->bChannel, &pdinf->bBit, &pdinf->dwSampling);
	if(pdinf->dwDataSize == 0L)
		return 1;

	pdinf->dwRemain = pdinf->dwDataSize;
	pdinf->lDataHead = ftell(pdinf->fp);
	return 0;
}


//==========================================================================
//	main routine
//
//
//==========================================================================
BYTE	FileCreate(BYTE* fname, PDATAINFO pdinf)
{
	if((pdinf->fp = fopen(fname, "wb")) == NULL)
		return 1;

	Wav_CreateHeader(pdinf->fp, pdinf->bChannel, pdinf->bBit, pdinf->dwSampling);

	pdinf->dwDataSize = 0L;
	pdinf->dwRemain = 0L;
	pdinf->lDataHead = ftell(pdinf->fp);
	return 0;
}


//==========================================================================
//	main routine
//
//
//==========================================================================
int	main(int argc, char** argv)
{
	version();

	//	check option
	if(checkOption(argc, argv) != 0) {
		cprintf("Error : Invalid options.\n\r");
		return 1;
	}

	//	check DS-XG
	if(checkDSXG(&hwi.pcikey) != 0) {
		cprintf("Error : Can not find DS-1E.\n\r");
		return 1;
	}

	//	initialize DS-XG
	if(InitializeDSXG(&hwi) != 0) {
		return 1;
	}

	//	set signal(ctrl+c)
	signal(SIGINT,	 break_service);
	signal(SIGBREAK, SIG_IGN);

	//	wodproc
	Hw_WritePrimaryCodec(&hwi, AC97R_PCMOUT, 0x0808);
	Hw_WritePrimaryCodec(&hwi, AC97R_MASTER, 0x0000);
	if(FileOpen(gszWavFile, &dinf) == 0) {
		cprintf("\n\r file name : %s\n\r", gszWavFile);
		cprintf(" format    : %d-bit %s\n\r", dinf.bBit, 
			((dinf.bChannel > 1) ? "stereo" : "mono"));
		cprintf(" sampling  : %ldHz\n\r", dinf.dwSampling);
		cprintf(" remain    : %08lx\r", dinf.dwRemain);
		hwi.dwHwStatus = 0x00000000;
		WodProc(&hwi, &dinf);
		fclose(dinf.fp);
		cprintf("\n\r");
	}
	else {
		cprintf("\n\r Error : Can not access WAV file(%s).\n\r", gszWavFile);
	}

	//	terminate DS-XG
	TerminateDSXG();

	return 0;
}
