//==========================================================================
//
//	title		: define functions to call PCI BIOS
//	company		: YAMAHA
//	author		: Taichi Sugiyama
//	create Data : 28/Sep/99
//
//==========================================================================
typedef unsigned char	BYTE;
typedef unsigned short	WORD;
typedef unsigned long	DWORD;


#define	HiW(dw)	(WORD)((DWORD)dw >> 16)
#define	LoW(dw)	(WORD)((DWORD)dw & 0xFFFF)


#define PCI_FUNCTION_ID		0xB1
#define PCI_BIOS_PRESENT	0x01
#define PCI_FIND_DEVICE		0x02
#define PCI_READ_BYTE		0x08
#define PCI_READ_WORD		0x09
#define PCI_READ_DWORD		0x0A
#define PCI_WRITE_BYTE		0x0B
#define PCI_WRITE_WORD		0x0C
#define PCI_WRITE_DWORD		0x0D
#define PCI_GET_ROUTING		0x0E
#define PCI_SET_INTERRUPT	0x0F
#define PCI_SERVICE			0x1A


#define PCI_SUCCESSFUL		0x00
#define PCI_NOT_SUPPORTED	0x81
#define PCI_BAD_VEMDERID	0x83
#define PCI_DEVICE_NOTFOUND	0x86
#define PCI_BAD_REGNUMBER	0x87
#define PCI_SET_FAILED		0x88
#define PCI_BUFFER_SMALL	0x98


#define PCIR_VID			0x00
#define	PCIR_DID			0x02
#define	PCIR_PCICMD			0x04
#define	PCIR_RID			0x08
#define	PCIR_CCODE			0x0A
#define	PCIR_HEADT			0x0E
#define	PCIR_NAMBAR			0x10
#define	PCIR_NABMBAR		0x14
#define	PCIR_SSVID			0x2C
#define	PCIR_SSID			0x2E
#define	PCIR_INTR_LN		0x3C
#define	PCIR_INTR_PIN		0x3D


//---- for YAMAHA DS-XG -----------------------------------------------
#define	PCIR_DSXGCTRL		0x48


typedef struct _tagPciKey {
	BYTE	bBus;
	BYTE	bDev;
	BYTE	bFunc;
} PCIKEY,	*PPCIKEY;


BYTE	PCIGetBus			(void );
BYTE	PCIFindDevice		(WORD, WORD, BYTE, PPCIKEY);
BYTE	PCIReadConfigByte	(PPCIKEY, WORD);
WORD	PCIReadConfigWord	(PPCIKEY, WORD);
DWORD	PCIReadConfigDword	(PPCIKEY, WORD);
void	PCIWriteConfigByte	(PPCIKEY, WORD, BYTE);
void	PCIWriteConfigWord	(PPCIKEY, WORD, WORD);
void	PCIWriteConfigDword (PPCIKEY, WORD, DWORD);
