//*****************************************************************************
//* Name:
//*      12pmctrl.h
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file contains the declaration of the controls class for the
//*      Korg 1212 I/O mixer driver.  This class defines controls that the
//*      mixer driver can access and modify for the 1212 I/O wave devices. 
//*
//* Modification Log:
//*
//*      1.1   04/07/97 Bill
//*      Initial version created.  
//*
//*
//* Copyright (c) 1997 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#ifndef K12PMCTRL_H
#define K12PMCTRL_H

#include <mmsystem.h>

#ifndef K1212API_H
#include "1212api.h" 
#endif

// ----------------------------------------------------------------------
// The following constants are defined for mixer controls
// ----------------------------------------------------------------------
#define NUM_MIX_DESTINATIONS  1
#define NUM_MIX_SOURCES       k1212NumWaveDevices
#define NUM_MIX_CHANNELS      2
#define NUM_MIX_CONNECTIONS   k1212NumWaveDevices

typedef enum {
   K1212_CTRL_VOLUME_LEFT = 0,   // left side volume control for a wave device
   K1212_CTRL_VOLUME_RIGHT,      // right side volume control for a wave device
   K1212_CTRL_MUTE,              // mute for a wave device
   K1212_CTRL_MAX
} mixerControlIds;


#define MIXCTRL_MIN_VOL   0x0000              // minimum volume for wave device volume adjustment
#define MIXCTRL_MAX_VOL   k1212MaxWaveVolume  // maximum volume   "
#define MIXCTRL_VOL_STEPS 0xFF                // 256 points of volume resolution


           
// ------------------------------------------------------------------------------
// Mixer control class declaration.
// ------------------------------------------------------------------------------
class CKorg1212ApiImpl;

class CKorg1212MixControl {

   friend class CKorg1212ApiImpl;
  
   public:
      DWORD       GetControlType   (void) __far const   {return controlType;}
      DWORD       GetMinValue      (void) __far const   {return minValue;}
      DWORD       GetMaxValue      (void) __far const   {return maxValue;}
      DWORD       GetNumSteps      (void) __far const   {return numSteps;}
      char __far* GetShortName     (void) __far const   {return lpszName;}
      char __far* GetName          (void) __far const   {return lpszShortName;}
   
   private:
      DWORD          controlType;
      char __far*    lpszName;
      char __far*    lpszShortName;
      DWORD          minValue;
      DWORD          maxValue;
      DWORD          numSteps;

      void        SetControlType  (DWORD       dwType)   __far   {controlType   = dwType;}
      void        SetMinValue     (DWORD       dwValue)  __far   {minValue      = dwValue;}
      void        SetMaxValue     (DWORD       dwValue)  __far   {maxValue      = dwValue;}
      void        SetNumSteps     (DWORD       dwValue)  __far   {numSteps      = dwValue;}
      void        SetShortName    (char __far* lpszStr)  __far   {lpszShortName = lpszStr;}
      void        SetName         (char __far* lpszStr)  __far   {lpszName      = lpszStr;}
};

#endif // K12PMCTRL_H
