//*****************************************************************************
//* Name:
//*      1212WavDefs.h
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file contains public declarations for the implementation of the
//*      Win16 application to Korg1212 VxD interface.
//*
//* Modification Log:
//*
//*      1.1   03/21/97 Bill
//*      Initial version.  
//*
//*
//* Copyright (c) 1997 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#ifndef K1212WAVDEFS_H
#define K1212WAVDEFS_H

#ifndef  K1212API_H
#include "1212api.h"
#endif


// ----------------------------------------------------------------------------
// The following enumeration defines the different wave formats we support.
// The values will be used to index into arrays of function pointers that
// handle each particular format.
// ----------------------------------------------------------------------------
typedef enum {
   WAVFMT_UNSUPPORTED = 0,          // unsupported - silence in playback and record

   WAVFMT_48000_STEREO_16,          // 48 kHz, stereo, 16 bit PCM
   WAVFMT_48000_STEREO_8,           // 48 kHz, stereo, 8 bit PCM
   WAVFMT_48000_MONO_16,            // 48 kHz, mono, 16 bit PCM
   WAVFMT_48000_MONO_8,             // 48 kHz, mono, 8 bit PCM

   WAVFMT_44100_STEREO_16,          // 44.1 kHz, stereo, 16 bit PCM
   WAVFMT_44100_STEREO_8,           // 44.1 kHz, stereo, 8 bit PCM
   WAVFMT_44100_MONO_16,            // 44.1 kHz, mono, 16 bit PCM
   WAVFMT_44100_MONO_8,             // 44.1 kHz, mono, 8 bit PCM

   WAVFMT_22050_STEREO_16,          // 22.05 kHz, stereo, 16 bit PCM
   WAVFMT_22050_STEREO_8,           // 22.05 kHz, stereo, 8 bit PCM
   WAVFMT_22050_MONO_16,            // 22.05 kHz, mono, 16 bit PCM
   WAVFMT_22050_MONO_8,             // 22.05 kHz, mono, 8 bit PCM
   
   WAVFMT_11025_STEREO_16,          // 11.025 kHz, stereo, 16 bit PCM
   WAVFMT_11025_STEREO_8,           // 11.025 kHz, stereo, 8 bit PCM
   WAVFMT_11025_MONO_16,            // 11.025 kHz, mono, 16 bit PCM
   WAVFMT_11025_MONO_8,             // 11.025 kHz, mono, 8 bit PCM

   WAVFMT_NUMFUNCTIONS              // number of buffer translation functions
} K1212WaveFormat;


// ----------------------------------------------------------------------------
// The following enumeration defines the wave device identifiers.
// ----------------------------------------------------------------------------
typedef enum {
   K1212_DEVICE_0_ID = 0,        // ADAT channels 1-2
   K1212_DEVICE_1_ID,            // ADAT channels 3-4
   K1212_DEVICE_2_ID,            // ADAT channels 5-6
   K1212_DEVICE_3_ID,            // ADAT channels 7-8
   K1212_DEVICE_4_ID,            // Analog left/right
   K1212_DEVICE_5_ID,            // S/PDIF left/right
   K1212_NUM_DEVICES
} K1212WaveDeviceID;

// ----------------------------------------------------------------------------
// The following enumeration defines the channel identifiers for a card.
// (A similar enum is defined in 1212api.h for use by developers.  If anything
//  changes here, make sure that is updated as well.)
// ----------------------------------------------------------------------------
typedef enum {
   K1212_ADAT_1 = 0,        // ADAT channel 1
   K1212_ADAT_2,            // ADAT channel 2
   K1212_ADAT_3,            // ADAT channel 3
   K1212_ADAT_4,            // ADAT channel 4
   K1212_ADAT_5,            // ADAT channel 5
   K1212_ADAT_6,            // ADAT channel 6
   K1212_ADAT_7,            // ADAT channel 7
   K1212_ADAT_8,            // ADAT channel 8
   K1212_ANALOG_LEFT,       // Analog left
   K1212_ANALOG_RIGHT,      // Analog right
   K1212_SPDIF_LEFT,        // S/PDIF left
   K1212_SPDIF_RIGHT,       // S/PDIF right
   K1212_NUM_CHANNELS
} K1212ChannelIDs;

#define LEFT_CHANNEL   0
#define RIGHT_CHANNEL  1

#define PCM_8BIT_HIPT   0xFF
#define PCM_8BIT_MIDPT  0x80
#define PCM_8BIT_LOWPT  0x00

#define LEFT_PAN_MASK   0x8000      // used for stereo panning - negative
                                    // values indicate the slider is to the
                                    // left of center.


// ------------------------------------------------------------------------
// Protected Mode interface specific structures
// ------------------------------------------------------------------------

   // ------------------------------------------------------------------------
   // The following struct is used for reporting card information from the 
   // GetCardInfo call.  An array of these structs is also used to report
   // all cards configured in the system for the QueryAllCards call. 
   // ------------------------------------------------------------------------
typedef struct k1212CardInfoPM {
   WORD            busNum;            // PCI bus number on which the card resides
   WORD            deviceNum;         // device number of the card on the PCI bus
   WORD            irqNum;            // interrupt level for the card
   WORD            state;             // current state of the card
   DWORD           devNode;           // device node of the card from the config mgr.
} k1212CardInfoPM;


   // ------------------------------------------------------------------------
   // The following struct is used to specify PCM wave format parameters 
   // ------------------------------------------------------------------------
typedef struct k1212WaveBufferInfo {
   LPWAVEHDR   waveBufferPtr;   // 16:16 pointer to the wave buffer
   LPVOID      lpClient;        // 16:16 pointer to client info
} k1212WaveBufferInfo;

   // ------------------------------------------------------------------------
   // The following struct is used to specify left/right volume levels 
   // ------------------------------------------------------------------------
typedef struct k1212PMLeftRight {
   WORD  leftValue;
   WORD  rightValue;
} k1212PMLeftRight;

   // ------------------------------------------------------------------------
   // The following struct is used to specify PCM wave format parameters 
   // ------------------------------------------------------------------------
typedef struct k1212WaveFormatData {
   DWORD    sampleRate;       // requested sample rate for the device
   WORD     bitsPerSample;    // number of bits per sample
   WORD     nChannels;        // number of channels (valid values are 1 or 2)
} k1212WaveFormatData;

   // ------------------------------------------------------------------------
   // The following struct is used to provide 32/16 mapping for the MMTIME
   // structure since the boneheads defined the type as a UINT, which is
   // a different size in 32 vs 16 bit realms and is not accounted for in
   // the structure's definition.
   // ------------------------------------------------------------------------
typedef struct k1212MMTimeData {
   DWORD    type;     // what kind of value is it
   DWORD    value;    // # samples, milliseconds, or whatever
} k1212MMTimeData;

   // ------------------------------------------------------------------------
   // The following struct is used for opening a wave device 
   // ------------------------------------------------------------------------
typedef struct k1212DeviceOpenData {
   k1212WaveFormatData waveFormatParams;
   DWORD               driverCallbackAddress;
   DWORD               clientHandle;            // contains a far pointer to pClient
}k1212DeviceOpenData;


#endif // K1212WAVDEFS_H
