//*****************************************************************************
//* Name:
//*      1212registry.h - Header file for system registry access module 
//*                       for VxD KORG1212.
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file declares constants, structures, and functions used for
//*      accessing the system registry for the Korg 1212 I/O card.
//*
//*
//* Modification Log:
//*
//*      1.2   08/21/97 Bill
//*      (v1.0B6) Changed the muteFlagsarray to be WORDs instead of BOOLs.  
//*      This frees up 5 extra WORDs for future use.  (The sixth was used
//*      for Auto Sync).
//*
//*      1.1   02/14/97 Bill
//*      Initial version created.  
//*
//*
//* Copyright (c) 1997 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#ifndef  K1212REGISTRY_H
#define  K1212REGISTRY_H

#ifndef K1212API_H
#include "1212api.h"
#endif


// ------------------------------------------------------------------------
// The following structure is defined for passing card configuration data 
// between the system registry and the VxD.
// ------------------------------------------------------------------------
typedef struct k1212RegistryData {
   WORD              routing[kAudioChannels];
   short             volume [kAudioChannels];
   WORD              leftADCSens;
   WORD              rightADCSens;
   ClockSourceIndex  clkSrcRate;
} k1212RegistryData;


// ------------------------------------------------------------------------
// The following structure is defined for passing card wave device 
// configuration data between the system registry and the VxD.
// ------------------------------------------------------------------------
typedef struct k1212RegistryWaveData {
   WORD              leftWaveVolume    [k1212NumWaveDevices];
   WORD              rightWaveVolume   [k1212NumWaveDevices];
   BOOL              volumeEnableFlags [k1212NumWaveDevices];
   WORD              muteFlags         [k1212NumWaveDevices];
   WORD              extra1;           // 
   WORD              extra2;           // 
   WORD              extra3;           // 
   WORD              extra4;           // 
   WORD              extra5;           // 
   WORD              autoSync;         // indicates whether the card is in auto sync mode.
   BOOL              recSyncFlags      [k1212NumWaveDevices];
   BOOL              playSyncFlags     [k1212NumWaveDevices];
} k1212RegistryWaveData;


// ------------------------------------------------------------------------
// PrepareRegistryDataStruct
//
//    This function, given a card index, sets up the k1212RegistryData 
//    structure based on the card's current values.  This call should 
//    be made prior to writing the data to the system registry.  A
//    similar function is provided for wave device data.
// ------------------------------------------------------------------------
BOOL PrepareRegistryDataStruct(DWORD              cardIndex,
                               k1212RegistryData* registryData
     );
BOOL PrepareRegistryWaveDataStruct(DWORD                  cardIndex,
                                   k1212RegistryWaveData* registryData
     );

// ------------------------------------------------------------------------
// WriteRegistryValues
//
//    This function, given a card index, writes the card's configuration
//    data to the system registry.  If the information cannot be stored, 
//    FALSE is returned.
// ------------------------------------------------------------------------
BOOL WriteRegistryValues(DWORD              cardIndex,
                         k1212RegistryData* registryData
     );
BOOL WriteRegistryWaveValues(DWORD                  cardIndex,
                             k1212RegistryWaveData* registryData
     );


// ------------------------------------------------------------------------
// ReadRegistryValues
//
//    This function, given a card index, reads any stored configuration 
//    data from the system registry for that card.  If the information
//    cannot be retrieved, FALSE is returned.
// ------------------------------------------------------------------------
BOOL ReadRegistryValues(DWORD              cardIndex,
                        k1212RegistryData* registryData
     );
BOOL ReadRegistryWaveValues(DWORD                  cardIndex,
                            k1212RegistryWaveData* registryData
     );

// ------------------------------------------------------------------------
// RestoreRegistryValues
//
//    This function, given a card index, restores the values contained in
//    the k1212RegistryData structure to the card.
// ------------------------------------------------------------------------
BOOL RestoreRegistryValues(DWORD                    cardIndex,
                           const k1212RegistryData* registryData
     );
BOOL RestoreRegistryWaveValues(DWORD                       cardIndex,
                               const k1212RegistryWaveData* registryData
     );
                                       
                                       


#endif  // K1212REGISTRY_H
