PROGRAM GUS1;

{ Simple example program TO show how TO basically set up the card and
  load some sound effects.  Step through the program TO see how it
  works.  It should be fairly self-explanatory.

  This file is copyright <C> 1994, by Kurt Kennett of Ingenuity Software.
  Modification of it is a violation of copyright.
}

USES
  UltraDrv, { Ultrasound Driver       }
  GusInit,  { Auto-Init and Shut-Down }
  CRT;      { Screen/Keyboard         }

CONST
  FileNames : ARRAY[1..3] OF STRING[12] = ('LASER.SND',
                                           'PHOTON.SND',
                                           'PHOTON2.SND');

VAR
  InF      : FILE;
  LoadBuf  : POINTER;
  Count    : WORD;
  SndLoc,
  SndLen   : ARRAY[1..3] OF LONGINT;
  CH       : Char;

BEGIN
  { Get a buffer to load the sounds into for transfer to the GUS }
  GetMem(LoadBuf, 20000);

  { Load all three sounds and download them to the GUS as you go }
  FOR Count := 1 TO 3 DO
    BEGIN
      Assign(InF, FileNames[Count]);
      {$I-}
      Reset(InF,1);
      {$I+}
      IF IOResult <> 0 THEN
        BEGIN
          Writeln('File Read error: ',FileNames[Count]);
          HALT(1);
        END;

      SndLen[Count] := FileSize(InF);

      { Assuming all sounds are less than 20000 bytes, I can do: }
      {$I-}
      BlockRead(InF, LoadBuf^, SndLen[Count]);
      {$I+}
      IF IOResult <> 0 THEN
        BEGIN
          Writeln('File Read error: ',FileNames[Count]);
          HALT(1);
        END;
      IF UltraMemAlloc(SndLen[Count],SndLoc[Count]) THEN
        IF NOT UltraDownLoad(LoadBuf,
                             Convert_Data,
                             SndLoc[Count],
                             SndLen[Count],
                             TRUE) THEN
          BEGIN
            UltraMemFree(SndLen[Count],SndLoc[Count]);
            Writeln('Error downloading to GUS.');
            HALT(1);
          END;


      {$I-}
      Close(InF);
      {$I+}

      { All sounds have 'center' balance }
      UltraSetBalance(Count, 7);

      { All sounds have reasonable volume }
      UltraSetLinearVolume(Count, 400);

      { Set the known frequencies 1&2 are 22kHz, 3 is 11kHz}
      IF Count < 3 THEN
        UltraSetFrequency(Count,Khz_22)
      ELSE
        UltraSetFrequency(Count,Khz_11);
    END;

  { Finished with the buffer, get rid of it }
  FreeMem(LoadBuf, 20000);

  { Write instructions and allow user to play sounds }
  Writeln('Successfully loaded the 3 sounds.  Press corresponding keys:');
  Writeln;
  Writeln(' <1>   Laser Blast');
  Writeln(' <2>   Photon Torpedo');
  Writeln(' <3>   Fissle Missle');
  Writeln(' <ESC> Exit');
  Writeln;
  Write(' < >',#8,#8);
  REPEAT
    CH := Readkey;
    CASE CH OF
      #0: BEGIN
            CH := Readkey; { dump extended keypresses }
            CH := ' ';
          END;
      '1'..'3' :  { start a sound! }
        BEGIN
          Count := Ord(CH)-Ord('1')+1;
          UltraStartVoice(Count,
                          SndLoc[Count],
                          SndLoc[Count],
                          SndLoc[Count]+SndLen[Count],
                          0);
        END;
     END;
  UNTIL CH=#27;
  Writeln;
END.
