
/***************************************************************************
*	NAME:  PEEKPOKE.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	06/01/93		Original
***************************************************************************/

#include <dos.h>
#include <conio.h>

#include "forte.h"
#include "gf1proto.h"
#include "gf1hware.h"
#include "gf1os.h"

extern ULTRA_DATA _gf1_data;

unsigned char
UltraPeekData (unsigned int port,unsigned long address)
{
    unsigned char	ret;

    ENTER_CRITICAL;

    outp(port+GF1_REG_SELECT,SET_DRAM_LOW);
    outpw(port+GF1_DATA_LOW,LSW(address));	/* 16 bits */
    outp(port+GF1_REG_SELECT,SET_DRAM_HIGH);
    outp(port+GF1_DATA_HI,LSB(MSW(address)));	/* 8 bits */
    ret = inp(port+GF1_DRAM);

    LEAVE_CRITICAL;
    return (ret);
}

void
UltraPokeData (unsigned int port, unsigned long address, unsigned char data)
{
    ENTER_CRITICAL;

    outp(port+GF1_REG_SELECT,SET_DRAM_LOW);
    outpw(port+GF1_DATA_LOW,LSW(address));	/* 16 bits */
    outp(port+GF1_REG_SELECT,SET_DRAM_HIGH);
    outp(port+GF1_DATA_HI,LSB(MSW(address)));	/* 8 bits */
    outp(port+GF1_DRAM,data);

    LEAVE_CRITICAL;
}
