;;; xcb-xvmc.el --- X11 XvMC extension  -*- lexical-binding: t -*-

;; Copyright (C) 2015-2018 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; This file was generated by 'el_client.el' from 'xvmc.xml',
;; which you can retrieve from <git://anongit.freedesktop.org/xcb/proto>.

;;; Code:

(require 'xcb-types)

(defconst xcb:xvmc:-extension-xname "XVideo-MotionCompensation")
(defconst xcb:xvmc:-extension-name "XvMC")
(defconst xcb:xvmc:-major-version 1)
(defconst xcb:xvmc:-minor-version 1)

(require 'xcb-xv)

(xcb:deftypealias 'xcb:xvmc:CONTEXT 'xcb:-u4)

(xcb:deftypealias 'xcb:xvmc:SURFACE 'xcb:-u4)

(xcb:deftypealias 'xcb:xvmc:SUBPICTURE 'xcb:-u4)

(defclass xcb:xvmc:SurfaceInfo
  (xcb:-struct)
  ((id :initarg :id :type xcb:xvmc:SURFACE)
   (chroma-format :initarg :chroma-format :type xcb:CARD16)
   (pad0 :initarg :pad0 :type xcb:CARD16)
   (max-width :initarg :max-width :type xcb:CARD16)
   (max-height :initarg :max-height :type xcb:CARD16)
   (subpicture-max-width :initarg :subpicture-max-width :type xcb:CARD16)
   (subpicture-max-height :initarg :subpicture-max-height :type xcb:CARD16)
   (mc-type :initarg :mc-type :type xcb:CARD32)
   (flags :initarg :flags :type xcb:CARD32)))

(defclass xcb:xvmc:QueryVersion
  (xcb:-request)
  ((~opcode :initform 0 :type xcb:-u1)))
(defclass xcb:xvmc:QueryVersion~reply
  (xcb:-reply)
  ((pad~0 :initform 1 :type xcb:-pad)
   (~sequence :type xcb:CARD16)
   (length :type xcb:CARD32)
   (major :initarg :major :type xcb:CARD32)
   (minor :initarg :minor :type xcb:CARD32)))

(defclass xcb:xvmc:ListSurfaceTypes
  (xcb:-request)
  ((~opcode :initform 1 :type xcb:-u1)
   (port-id :initarg :port-id :type xcb:xv:PORT)))
(defclass xcb:xvmc:ListSurfaceTypes~reply
  (xcb:-reply)
  ((pad~0 :initform 1 :type xcb:-pad)
   (~sequence :type xcb:CARD16)
   (length :type xcb:CARD32)
   (num :initarg :num :type xcb:CARD32)
   (pad~1 :initform 20 :type xcb:-pad)
   (surfaces~ :initform
	      '(name surfaces type xcb:xvmc:SurfaceInfo size
		     (xcb:-fieldref 'num))
	      :type xcb:-list)
   (surfaces :initarg :surfaces :type xcb:-ignore)))

(defclass xcb:xvmc:CreateContext
  (xcb:-request)
  ((~opcode :initform 2 :type xcb:-u1)
   (context-id :initarg :context-id :type xcb:xvmc:CONTEXT)
   (port-id :initarg :port-id :type xcb:xv:PORT)
   (surface-id :initarg :surface-id :type xcb:xvmc:SURFACE)
   (width :initarg :width :type xcb:CARD16)
   (height :initarg :height :type xcb:CARD16)
   (flags :initarg :flags :type xcb:CARD32)))
(defclass xcb:xvmc:CreateContext~reply
  (xcb:-reply)
  ((pad~0 :initform 1 :type xcb:-pad)
   (~sequence :type xcb:CARD16)
   (length :type xcb:CARD32)
   (width-actual :initarg :width-actual :type xcb:CARD16)
   (height-actual :initarg :height-actual :type xcb:CARD16)
   (flags-return :initarg :flags-return :type xcb:CARD32)
   (pad~1 :initform 20 :type xcb:-pad)
   (priv-data~ :initform
	       '(name priv-data type xcb:CARD32 size
		      (xcb:-fieldref 'length))
	       :type xcb:-list)
   (priv-data :initarg :priv-data :type xcb:-ignore)))

(defclass xcb:xvmc:DestroyContext
  (xcb:-request)
  ((~opcode :initform 3 :type xcb:-u1)
   (context-id :initarg :context-id :type xcb:xvmc:CONTEXT)))

(defclass xcb:xvmc:CreateSurface
  (xcb:-request)
  ((~opcode :initform 4 :type xcb:-u1)
   (surface-id :initarg :surface-id :type xcb:xvmc:SURFACE)
   (context-id :initarg :context-id :type xcb:xvmc:CONTEXT)))
(defclass xcb:xvmc:CreateSurface~reply
  (xcb:-reply)
  ((pad~0 :initform 1 :type xcb:-pad)
   (~sequence :type xcb:CARD16)
   (length :type xcb:CARD32)
   (pad~1 :initform 24 :type xcb:-pad)
   (priv-data~ :initform
	       '(name priv-data type xcb:CARD32 size
		      (xcb:-fieldref 'length))
	       :type xcb:-list)
   (priv-data :initarg :priv-data :type xcb:-ignore)))

(defclass xcb:xvmc:DestroySurface
  (xcb:-request)
  ((~opcode :initform 5 :type xcb:-u1)
   (surface-id :initarg :surface-id :type xcb:xvmc:SURFACE)))

(defclass xcb:xvmc:CreateSubpicture
  (xcb:-request)
  ((~opcode :initform 6 :type xcb:-u1)
   (subpicture-id :initarg :subpicture-id :type xcb:xvmc:SUBPICTURE)
   (context :initarg :context :type xcb:xvmc:CONTEXT)
   (xvimage-id :initarg :xvimage-id :type xcb:CARD32)
   (width :initarg :width :type xcb:CARD16)
   (height :initarg :height :type xcb:CARD16)))
(defclass xcb:xvmc:CreateSubpicture~reply
  (xcb:-reply)
  ((pad~0 :initform 1 :type xcb:-pad)
   (~sequence :type xcb:CARD16)
   (length :type xcb:CARD32)
   (width-actual :initarg :width-actual :type xcb:CARD16)
   (height-actual :initarg :height-actual :type xcb:CARD16)
   (num-palette-entries :initarg :num-palette-entries :type xcb:CARD16)
   (entry-bytes :initarg :entry-bytes :type xcb:CARD16)
   (component-order~ :initform
		     '(name component-order type xcb:CARD8 size 4)
		     :type xcb:-list)
   (component-order :initarg :component-order :type xcb:-ignore)
   (pad~1 :initform 12 :type xcb:-pad)
   (priv-data~ :initform
	       '(name priv-data type xcb:CARD32 size
		      (xcb:-fieldref 'length))
	       :type xcb:-list)
   (priv-data :initarg :priv-data :type xcb:-ignore)))

(defclass xcb:xvmc:DestroySubpicture
  (xcb:-request)
  ((~opcode :initform 7 :type xcb:-u1)
   (subpicture-id :initarg :subpicture-id :type xcb:xvmc:SUBPICTURE)))

(defclass xcb:xvmc:ListSubpictureTypes
  (xcb:-request)
  ((~opcode :initform 8 :type xcb:-u1)
   (port-id :initarg :port-id :type xcb:xv:PORT)
   (surface-id :initarg :surface-id :type xcb:xvmc:SURFACE)))
(defclass xcb:xvmc:ListSubpictureTypes~reply
  (xcb:-reply)
  ((pad~0 :initform 1 :type xcb:-pad)
   (~sequence :type xcb:CARD16)
   (length :type xcb:CARD32)
   (num :initarg :num :type xcb:CARD32)
   (pad~1 :initform 20 :type xcb:-pad)
   (types~ :initform
	   '(name types type xcb:xv:ImageFormatInfo size
		  (xcb:-fieldref 'num))
	   :type xcb:-list)
   (types :initarg :types :type xcb:-ignore)))



(provide 'xcb-xvmc)

;;; xcb-xvmc.el ends here
