;;; xcb-res.el --- X11 Res extension  -*- lexical-binding: t -*-

;; Copyright (C) 2015-2018 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; This file was generated by 'el_client.el' from 'res.xml',
;; which you can retrieve from <git://anongit.freedesktop.org/xcb/proto>.

;;; Code:

(require 'xcb-types)

(defconst xcb:res:-extension-xname "X-Resource")
(defconst xcb:res:-extension-name "Res")
(defconst xcb:res:-major-version 1)
(defconst xcb:res:-minor-version 2)

(require 'xcb-xproto)

(defclass xcb:res:Client
  (xcb:-struct)
  ((resource-base :initarg :resource-base :type xcb:CARD32)
   (resource-mask :initarg :resource-mask :type xcb:CARD32)))

(defclass xcb:res:Type
  (xcb:-struct)
  ((resource-type :initarg :resource-type :type xcb:ATOM)
   (count :initarg :count :type xcb:CARD32)))

(defconst xcb:res:ClientIdMask:ClientXID 1)
(defconst xcb:res:ClientIdMask:LocalClientPID 2)

(defclass xcb:res:ClientIdSpec
  (xcb:-struct)
  ((client :initarg :client :type xcb:CARD32)
   (mask :initarg :mask :type xcb:CARD32)))

(defclass xcb:res:ClientIdValue
  (xcb:-struct)
  ((spec :initarg :spec :type xcb:res:ClientIdSpec)
   (length :initarg :length :type xcb:CARD32)
   (value~ :initform
	   '(name value type xcb:CARD32 size
		  (/
		   (xcb:-fieldref 'length)
		   4))
	   :type xcb:-list)
   (value :initarg :value :type xcb:-ignore)))

(defclass xcb:res:ResourceIdSpec
  (xcb:-struct)
  ((resource :initarg :resource :type xcb:CARD32)
   (type :initarg :type :type xcb:CARD32)))

(defclass xcb:res:ResourceSizeSpec
  (xcb:-struct)
  ((spec :initarg :spec :type xcb:res:ResourceIdSpec)
   (bytes :initarg :bytes :type xcb:CARD32)
   (ref-count :initarg :ref-count :type xcb:CARD32)
   (use-count :initarg :use-count :type xcb:CARD32)))

(defclass xcb:res:ResourceSizeValue
  (xcb:-struct)
  ((size :initarg :size :type xcb:res:ResourceSizeSpec)
   (num-cross-references :initarg :num-cross-references :type xcb:CARD32)
   (cross-references~ :initform
		      '(name cross-references type xcb:res:ResourceSizeSpec size
			     (xcb:-fieldref 'num-cross-references))
		      :type xcb:-list)
   (cross-references :initarg :cross-references :type xcb:-ignore)))

(defclass xcb:res:QueryVersion
  (xcb:-request)
  ((~opcode :initform 0 :type xcb:-u1)
   (client-major :initarg :client-major :type xcb:CARD8)
   (client-minor :initarg :client-minor :type xcb:CARD8)))
(defclass xcb:res:QueryVersion~reply
  (xcb:-reply)
  ((pad~0 :initform 1 :type xcb:-pad)
   (~sequence :type xcb:CARD16)
   (length :type xcb:CARD32)
   (server-major :initarg :server-major :type xcb:CARD16)
   (server-minor :initarg :server-minor :type xcb:CARD16)))

(defclass xcb:res:QueryClients
  (xcb:-request)
  ((~opcode :initform 1 :type xcb:-u1)))
(defclass xcb:res:QueryClients~reply
  (xcb:-reply)
  ((pad~0 :initform 1 :type xcb:-pad)
   (~sequence :type xcb:CARD16)
   (length :type xcb:CARD32)
   (num-clients :initarg :num-clients :type xcb:CARD32)
   (pad~1 :initform 20 :type xcb:-pad)
   (clients~ :initform
	     '(name clients type xcb:res:Client size
		    (xcb:-fieldref 'num-clients))
	     :type xcb:-list)
   (clients :initarg :clients :type xcb:-ignore)))

(defclass xcb:res:QueryClientResources
  (xcb:-request)
  ((~opcode :initform 2 :type xcb:-u1)
   (xid :initarg :xid :type xcb:CARD32)))
(defclass xcb:res:QueryClientResources~reply
  (xcb:-reply)
  ((pad~0 :initform 1 :type xcb:-pad)
   (~sequence :type xcb:CARD16)
   (length :type xcb:CARD32)
   (num-types :initarg :num-types :type xcb:CARD32)
   (pad~1 :initform 20 :type xcb:-pad)
   (types~ :initform
	   '(name types type xcb:res:Type size
		  (xcb:-fieldref 'num-types))
	   :type xcb:-list)
   (types :initarg :types :type xcb:-ignore)))

(defclass xcb:res:QueryClientPixmapBytes
  (xcb:-request)
  ((~opcode :initform 3 :type xcb:-u1)
   (xid :initarg :xid :type xcb:CARD32)))
(defclass xcb:res:QueryClientPixmapBytes~reply
  (xcb:-reply)
  ((pad~0 :initform 1 :type xcb:-pad)
   (~sequence :type xcb:CARD16)
   (length :type xcb:CARD32)
   (bytes :initarg :bytes :type xcb:CARD32)
   (bytes-overflow :initarg :bytes-overflow :type xcb:CARD32)))

(defclass xcb:res:QueryClientIds
  (xcb:-request)
  ((~opcode :initform 4 :type xcb:-u1)
   (num-specs :initarg :num-specs :type xcb:CARD32)
   (specs~ :initform
	   '(name specs type xcb:res:ClientIdSpec size
		  (xcb:-fieldref 'num-specs))
	   :type xcb:-list)
   (specs :initarg :specs :type xcb:-ignore)))
(defclass xcb:res:QueryClientIds~reply
  (xcb:-reply)
  ((pad~0 :initform 1 :type xcb:-pad)
   (~sequence :type xcb:CARD16)
   (length :type xcb:CARD32)
   (num-ids :initarg :num-ids :type xcb:CARD32)
   (pad~1 :initform 20 :type xcb:-pad)
   (ids~ :initform
	 '(name ids type xcb:res:ClientIdValue size
		(xcb:-fieldref 'num-ids))
	 :type xcb:-list)
   (ids :initarg :ids :type xcb:-ignore)))

(defclass xcb:res:QueryResourceBytes
  (xcb:-request)
  ((~opcode :initform 5 :type xcb:-u1)
   (client :initarg :client :type xcb:CARD32)
   (num-specs :initarg :num-specs :type xcb:CARD32)
   (specs~ :initform
	   '(name specs type xcb:res:ResourceIdSpec size
		  (xcb:-fieldref 'num-specs))
	   :type xcb:-list)
   (specs :initarg :specs :type xcb:-ignore)))
(defclass xcb:res:QueryResourceBytes~reply
  (xcb:-reply)
  ((pad~0 :initform 1 :type xcb:-pad)
   (~sequence :type xcb:CARD16)
   (length :type xcb:CARD32)
   (num-sizes :initarg :num-sizes :type xcb:CARD32)
   (pad~1 :initform 20 :type xcb:-pad)
   (sizes~ :initform
	   '(name sizes type xcb:res:ResourceSizeValue size
		  (xcb:-fieldref 'num-sizes))
	   :type xcb:-list)
   (sizes :initarg :sizes :type xcb:-ignore)))



(provide 'xcb-res)

;;; xcb-res.el ends here
