--  Abstract :
--
--  Types and operations for a packrat parser runtime, with nonterm
--  parsing subprograms generated by wisi-generate.
--
--  References:
--
--  see parent.
--
--  Copyright (C) 2018 - 2019 Free Software Foundation, Inc.
--
--  This library is free software;  you can redistribute it and/or modify it
--  under terms of the  GNU General Public License  as published by the Free
--  Software  Foundation;  either version 3,  or (at your  option) any later
--  version. This library is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN-
--  TABILITY or FITNESS FOR A PARTICULAR PURPOSE.

--  As a special exception under Section 7 of GPL version 3, you are granted
--  additional permissions described in the GCC Runtime Library Exception,
--  version 3.1, as published by the Free Software Foundation.

pragma License (Modified_GPL);
with WisiToken.Syntax_Trees;
package WisiToken.Parse.Packrat.Generated is

   Recursive : exception; -- FIXME: delete

   type Memo_State is (No_Result, Failure, Success);
   subtype Result_States is Memo_State range Failure .. Success;

   type Memo_Entry (State : Memo_State := No_Result) is record

      case State is
      when No_Result =>
         Recursive : Boolean := False; --  FIXME: delete

      when Failure =>
         null;

      when Success =>
         Result : aliased WisiToken.Syntax_Trees.Valid_Node_Index;

         Last_Token : Base_Token_Index; --  FIXME: change to Last_Pos

      end case;
   end record;

   package Memos is new SAL.Gen_Unbounded_Definite_Vectors
     (Token_Index, Memo_Entry, Default_Element => (others => <>));

   subtype Result_Type is Memo_Entry
   with Dynamic_Predicate => Result_Type.State in Result_States;

   package Derivs is new SAL.Gen_Unbounded_Definite_Vectors
     (Token_ID, Memos.Vector, Default_Element => Memos.Empty_Vector);

   type Parse_WisiToken_Accept is access
     --  WORKAROUND: using Packrat.Parser'Class here hits a GNAT Bug box in GPL 2018.
     function (Parser : in out Base_Parser'Class; Last_Pos : in Base_Token_Index) return Result_Type;

   type Parser is new Packrat.Parser with record
      Derivs : Generated.Derivs.Vector; --  FIXME: use discriminated array, as in procedural

      Parse_WisiToken_Accept : Generated.Parse_WisiToken_Accept;
   end record;

   overriding procedure Parse (Parser : aliased in out Generated.Parser);
   overriding function Tree (Parser : in Generated.Parser) return Syntax_Trees.Tree;
   overriding function Any_Errors (Parser : in Generated.Parser) return Boolean;
   overriding procedure Put_Errors (Parser : in Generated.Parser);

end WisiToken.Parse.Packrat.Generated;
