;;; math-symbol-lists.el --- Lists of Unicode math symbols and latex commands
;;
;; Copyright (C) 2014, 2015 Free Software Foundation, Inc.
;; Author: Vitalie Spinu <spinuvit@gmail.com>
;; URL: https://github.com/vspinu/math-symbol-lists
;; Keywords: Unicode, symbols, mathematics
;; Version: 1.1
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; This file is part of GNU Emacs.
;;
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 3, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 51 Franklin Street, Fifth
;; Floor, Boston, MA 02110-1301, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;; Commentary:
;;
;; This is a "storage" package used by completion engines such as
;; `company-math.el` and `ac-math.el`.
;;
;; Defined (a)lists are:
;;
;;          symbols-math-basic
;;          symbols-math-extended
;;          symbols-latex-commands
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;; Code:

(defconst math-symbol-list-basic
  '(("Greek Lowercase"	"\\alpha"	#X3B1)
    ("Greek Lowercase"	"\\beta"	#X3B2)
    ("Greek Lowercase"	"\\gamma"	#X3B3)
    ("Greek Lowercase"	"\\delta"	#X3B4)
    ("Greek Lowercase"	"\\epsilon"	#X3F5)
    ("Greek Lowercase"	"\\zeta"	#X3B6)
    ("Greek Lowercase"	"\\eta"	#X3B7)
    ("Greek Lowercase"	"\\theta"	#X3B8)
    ("Greek Lowercase"	"\\iota"	#X3B9)
    ("Greek Lowercase"	"\\kappa"	#X3BA)
    ("Greek Lowercase"	"\\lambda"	#X3BB)
    ("Greek Lowercase"	"\\mu"	#X3BC)
    ("Greek Lowercase"	"\\nu"	#X3BD)
    ("Greek Lowercase"	"\\xi"	#X3BE)
    ("Greek Lowercase"	"\\pi"	#X3C0)
    ("Greek Lowercase"	"\\rho"	#X3C1)
    ("Greek Lowercase"	"\\sigma"	#X3C3)
    ("Greek Lowercase"	"\\tau"	#X3C4)
    ("Greek Lowercase"	"\\upsilon"	#X3C5)
    ("Greek Lowercase"	"\\phi"	#X3D5)
    ("Greek Lowercase"	"\\chi"	#X3C7)
    ("Greek Lowercase"	"\\psi"	#X3C8)
    ("Greek Lowercase"	"\\omega"	#X3C9)
    ("Greek Lowercase"	"\\varepsilon"	#X3B5)
    ("Greek Lowercase"	"\\vartheta"	#X3D1)
    ("Greek Lowercase"	"\\varpi"	#X3D6)
    ("Greek Lowercase"	"\\varrho"	#X3F1)
    ("Greek Lowercase"	"\\varsigma"	#X3C2)
    ("Greek Lowercase"	"\\varphi"	#X3C6)
    ("Greek Uppercase"	"\\Gamma"	#X393)
    ("Greek Uppercase"	"\\Delta"	#X394)
    ("Greek Uppercase"	"\\Theta"	#X398)
    ("Greek Uppercase"	"\\Lambda"	#X39B)
    ("Greek Uppercase"	"\\Xi"	#X39E)
    ("Greek Uppercase"	"\\Pi"	#X3A0)
    ("Greek Uppercase"	"\\Sigma"	#X3A3)
    ("Greek Uppercase"	"\\Upsilon"	#X3D2)
    ("Greek Uppercase"	"\\Phi"	#X3A6)
    ("Greek Uppercase"	"\\Psi"	#X3A8)
    ("Greek Uppercase"	"\\Omega"	#X3A9)
    ("Binary Op"	"\\pm"	#XB1)
    ("Binary Op"	"\\mp"	#X2213)
    ("Binary Op"	"\\times"	#XD7)
    ("Binary Op"	"\\div"	#XF7)
    ("Binary Op"	"\\ast"	#X2217)
    ("Binary Op"	"\\star"	#X22C6)
    ("Binary Op"	"\\circ"	#X2218)
    ("Binary Op"	"\\bullet"	#X2219)
    ("Binary Op"	"\\cdot"	#X22C5)
    ("Binary Op"	"\\cap"	#X2229)
    ("Binary Op"	"\\cup"	#X222A)
    ("Binary Op"	"\\uplus"	#X228E)
    ("Binary Op"	"\\sqcap"	#X2293)
    ("Binary Op"	"\\vee"	#X2228)
    ("Binary Op"	"\\wedge"	#X2227)
    ("Binary Op"	"\\setminus"	#X2216)
    ("Binary Op"	"\\wr"	#X2240)
    ("Binary Op"	"\\diamond"	#X22C4)
    ("Binary Op"	"\\bigtriangleup"	#X25B3)
    ("Binary Op"	"\\bigtriangledown"	#X25BD)
    ("Binary Op"	"\\triangleleft"	#X25C1)
    ("Binary Op"	"\\triangleright"	#X25B7)
    ("Binary Op"	"\\lhd")
    ("Binary Op"	"\\rhd")
    ("Binary Op"	"\\unlhd")
    ("Binary Op"	"\\unrhd")
    ("Binary Op"	"\\oplus"	#X2295)
    ("Binary Op"	"\\ominus"	#X2296)
    ("Binary Op"	"\\otimes"	#X2297)
    ("Binary Op"	"\\oslash"	#X2205)
    ("Binary Op"	"\\odot"	#X2299)
    ("Binary Op"	"\\bigcirc"	#X25CB)
    ("Binary Op"	"\\dagger"	#X2020)
    ("Binary Op"	"\\ddagger"	#X2021)
    ("Binary Op"	"\\amalg"	#X2A3F)
    ("Relational"	"\\leq"	#X2264)
    ("Relational"	"\\geq"	#X2265)
    ("Relational"	"\\qed"	#X220E)
    ("Relational"	"\\equiv"	#X2261)
    ("Relational"	"\\models"	#X22A7)
    ("Relational"	"\\prec"	#X227A)
    ("Relational"	"\\succ"	#X227B)
    ("Relational"	"\\sim"	#X223C)
    ("Relational"	"\\perp"	#X27C2)
    ("Relational"	"\\preceq"	#X2AAF)
    ("Relational"	"\\succeq"	#X2AB0)
    ("Relational"	"\\simeq"	#X2243)
    ("Relational"	"\\mid"	#X2223)
    ("Relational"	"\\ll"	#X226A)
    ("Relational"	"\\gg"	#X226B)
    ("Relational"	"\\asymp"	#X224D)
    ("Relational"	"\\parallel"	#X2225)
    ("Relational"	"\\subset"	#X2282)
    ("Relational"	"\\supset"	#X2283)
    ("Relational"	"\\approx"	#X2248)
    ("Relational"	"\\bowtie"	#X22C8)
    ("Relational"	"\\subseteq"	#X2286)
    ("Relational"	"\\supseteq"	#X2287)
    ("Relational"	"\\cong"	#X2245)
    ("Relational"	"\\Join"	#X2A1D)
    ("Relational"	"\\sqsubset"	#X228F)
    ("Relational"	"\\sqsupset"	#X2290)
    ("Relational"	"\\neq"	#X2260)
    ("Relational"	"\\smile"	#X2323)
    ("Relational"	"\\sqsubseteq"	#X2291)
    ("Relational"	"\\sqsupseteq"	#X2292)
    ("Relational"	"\\doteq"	#X2250)
    ("Relational"	"\\frown"	#X2322)
    ("Relational"	"\\in"	#X2208)
    ("Relational"	"\\ni"	#X220B)
    ("Relational"	"\\propto"	#X221D)
    ("Relational"	"\\vdash"	#X22A2)
    ("Relational"	"\\dashv"	#X22A3)
    ("Arrows"	"\\leftarrow"	#X2190)
    ("Arrows"	"\\Leftarrow"	#X21D0)
    ("Arrows"	"\\rightarrow"	#X2192)
    ("Arrows"	"\\Rightarrow"	#X21D2)
    ("Arrows"	"\\leftrightarrow"	#X2194)
    ("Arrows"	"\\Leftrightarrow"	#X21D4)
    ("Arrows"	"\\mapsto"	#X21A6)
    ("Arrows"	"\\hookleftarrow"	#X21A9)
    ("Arrows"	"\\leftharpoonup"	#X21BC)
    ("Arrows"	"\\leftharpoondown"	#X21BD)
    ("Arrows"	"\\longleftarrow"	#X27F5)
    ("Arrows"	"\\Longleftarrow"	#X27F8)
    ("Arrows"	"\\longrightarrow"	#X27F6)
    ("Arrows"	"\\Longrightarrow"	#X27F9)
    ("Arrows"	"\\longleftrightarrow"	#X27F7)
    ("Arrows"	"\\Longleftrightarrow"	#X27FA)
    ("Arrows"	"\\longmapsto"	#X27FC)
    ("Arrows"	"\\hookrightarrow"	#X21AA)
    ("Arrows"	"\\rightharpoonup"	#X21C0)
    ("Arrows"	"\\rightharpoondown"	#X21C1)
    ("Arrows"	"\\uparrow"	#X2191)
    ("Arrows"	"\\Uparrow"	#X21D1)
    ("Arrows"	"\\downarrow"	#X2193)
    ("Arrows"	"\\Downarrow"	#X21D3)
    ("Arrows"	"\\updownarrow"	#X2195)
    ("Arrows"	"\\Updownarrow"	#X21D5)
    ("Arrows"	"\\nearrow"	#X2197)
    ("Arrows"	"\\searrow"	#X2198)
    ("Arrows"	"\\swarrow"	#X2199)
    ("Arrows"	"\\nwarrow"	#X2196)
    ("Punctuation"	"\\ldots"	#X2026)
    ("Punctuation"	"\\cdots"	#X22EF)
    ("Punctuation"	"\\vdots"	#X22EE)
    ("Punctuation"	"\\ddots"	#X22F1)
    ("Punctuation"	"\\colon"	#X3A)
    ("Misc Symbol"	"\\nabla"	#X2207)
    ("Misc Symbol"	"\\aleph"	#X2135)
    ("Misc Symbol"	"\\prime"	#X2032)
    ("Misc Symbol"	"\\forall"	#X2200)
    ("Misc Symbol"	"\\infty"	#X221E)
    ("Misc Symbol"	"\\hbar"	#X210F)
    ("Misc Symbol"	"\\emptyset"	#X2205)
    ("Misc Symbol"	"\\exists"	#X2203)
    ("Misc Symbol"	"\\surd"	#X221A)
    ("Misc Symbol"	"\\Box")
    ("Misc Symbol"	"\\triangle"	#X25B3)
    ("Misc Symbol"	"\\Diamond")
    ("Misc Symbol"	"\\imath"	#X131)
    ("Misc Symbol"	"\\jmath"	#X1D6A5)
    ("Misc Symbol"	"\\ell"	#X2113)
    ("Misc Symbol"	"\\neg"	#XAC)
    ("Misc Symbol"	"\\not"	#X338)
    ("Misc Symbol"	"\\top"	#X22A4)
    ("Misc Symbol"	"\\flat"	#X266D)
    ("Misc Symbol"	"\\natural"	#X266E)
    ("Misc Symbol"	"\\sharp"	#X266F)
    ("Misc Symbol"	"\\wp"	#X2118)
    ("Misc Symbol"	"\\bot"	#X22A5)
    ("Misc Symbol"	"\\clubsuit"	#X2663)
    ("Misc Symbol"	"\\diamondsuit"	#X2662)
    ("Misc Symbol"	"\\heartsuit"	#X2661)
    ("Misc Symbol"	"\\spadesuit"	#X2660)
    ("Misc Symbol"	"\\mho"	#X2127)
    ("Misc Symbol"	"\\Re"	#X211C)
    ("Misc Symbol"	"\\Im"	#X2111)
    ("Misc Symbol"	"\\angle"	#X2220)
    ("Misc Symbol"	"\\partial"	#X2202)
    ("Var Symbol"	"\\sum"	#X2211)
    ("Var Symbol"	"\\prod"	#X220F)
    ("Var Symbol"	"\\coprod"	#X2210)
    ("Var Symbol"	"\\int"	#X222B)
    ("Var Symbol"	"\\oint"	#X222E)
    ("Var Symbol"	"\\bigcap"	#X22C2)
    ("Var Symbol"	"\\bigcup"	#X22C3)
    ("Var Symbol"	"\\bigsqcup"	#X2A06)
    ("Var Symbol"	"\\bigvee"	#X22C1)
    ("Var Symbol"	"\\bigwedge"	#X22C0)
    ("Var Symbol"	"\\bigodot"	#X2A00)
    ("Var Symbol"	"\\bigotimes"	#X2A02)
    ("Var Symbol"	"\\bigoplus"	#X2A01)
    ("Var Symbol"	"\\biguplus"	#X2A04)
    ("Log-like"	"\\arccos")
    ("Log-like"	"\\arcsin")
    ("Log-like"	"\\arctan")
    ("Log-like"	"\\arg")
    ("Log-like"	"\\cos")
    ("Log-like"	"\\cosh")
    ("Log-like"	"\\cot")
    ("Log-like"	"\\coth")
    ("Log-like"	"\\csc")
    ("Log-like"	"\\deg")
    ("Log-like"	"\\det")
    ("Log-like"	"\\dim")
    ("Log-like"	"\\exp")
    ("Log-like"	"\\gcd")
    ("Log-like"	"\\hom")
    ("Log-like"	"\\inf")
    ("Log-like"	"\\ker")
    ("Log-like"	"\\lg")
    ("Log-like"	"\\lim")
    ("Log-like"	"\\liminf")
    ("Log-like"	"\\limsup")
    ("Log-like"	"\\ln")
    ("Log-like"	"\\log")
    ("Log-like"	"\\max")
    ("Log-like"	"\\min")
    ("Log-like"	"\\Pr")
    ("Log-like"	"\\sec")
    ("Log-like"	"\\sin")
    ("Log-like"	"\\sinh")
    ("Log-like"	"\\sup")
    ("Log-like"	"\\tan")
    ("Log-like"	"\\tanh")
    ("Delimiters"	"\\{")
    ("Delimiters"	"\\}")
    ("Delimiters"	"\\lfloor"	#X230A)
    ("Delimiters"	"\\rfloor"	#X230B)
    ("Delimiters"	"\\lceil"	#X2308)
    ("Delimiters"	"\\rceil"	#X2309)
    ("Delimiters"	"\\langle"	#X27E8)
    ("Delimiters"	"\\rangle"	#X27E9)
    ("Delimiters"	"\\rmoustache"	#X23B1)
    ("Delimiters"	"\\lmoustache"	#X23B0)
    ("Delimiters"	"\\rgroup")
    ("Delimiters"	"\\lgroup")
    ("Delimiters"	"\\backslash"	#X5C)
    ("Delimiters"	"\\|")
    ("Delimiters"	"\\arrowvert")
    ("Delimiters"	"\\Arrowvert")
    ("Delimiters"	"\\bracevert")
    ("Constructs"	"\\widetilde"	#X303)
    ("Constructs"	"\\widehat"	#X302)
    ("Constructs"	"\\overleftarrow"	#X20D6)
    ("Constructs"	"\\overrightarrow")
    ("Constructs"	"\\overline")
    ("Constructs"	"\\underline")
    ("Constructs"	"\\overbrace"	#XFE37)
    ("Constructs"	"\\underbrace"	#XFE38)
    ("Constructs"	"\\sqrt"	#X221A)
    ("Constructs"	"\\frac")
    ("Accents"	"\\hat"	#X302)
    ("Accents"	"\\acute"	#X301)
    ("Accents"	"\\bar"	#X304)
    ("Accents"	"\\dot"	#X307)
    ("Accents"	"\\breve"	#X306)
    ("Accents"	"\\check"	#X30C)
    ("Accents"	"\\grave"	#X300)
    ("Accents"	"\\vec"	#X20D7)
    ("Accents"	"\\ddot"	#X308)
    ("Accents"	"\\tilde"	#X303)
    ("AMS/Hebrew"	"\\digamma"	#X3DD)
    ("AMS/Hebrew"	"\\varkappa"	#X3F0)
    ("AMS/Hebrew"	"\\beth"	#X2136)
    ("AMS/Hebrew"	"\\daleth"	#X2138)
    ("AMS/Hebrew"	"\\gimel"	#X2137)
    ("AMS/Greek Uppercase"	"\\varGamma")
    ("AMS/Greek Uppercase"	"\\varDelta")
    ("AMS/Greek Uppercase"	"\\varTheta")
    ("AMS/Greek Uppercase"	"\\varLambda")
    ("AMS/Greek Uppercase"	"\\varXi")
    ("AMS/Greek Uppercase"	"\\varPi")
    ("AMS/Greek Uppercase"	"\\varSigma")
    ("AMS/Greek Uppercase"	"\\varUpsilon")
    ("AMS/Greek Uppercase"	"\\varPhi")
    ("AMS/Greek Uppercase"	"\\varPsi")
    ("AMS/Greek Uppercase"	"\\varOmega")
    ("AMS/Arrows"	"\\dashrightarrow")
    ("AMS/Arrows"	"\\dashleftarrow")
    ("AMS/Arrows"	"\\leftleftarrows"	#X21C7)
    ("AMS/Arrows"	"\\leftrightarrows"	#X21C6)
    ("AMS/Arrows"	"\\Lleftarrow"	#X21DA)
    ("AMS/Arrows"	"\\twoheadleftarrow"	#X219E)
    ("AMS/Arrows"	"\\leftarrowtail"	#X21A2)
    ("AMS/Arrows"	"\\looparrowleft"	#X21AB)
    ("AMS/Arrows"	"\\leftrightharpoons"	#X21CB)
    ("AMS/Arrows"	"\\curvearrowleft"	#X21B6)
    ("AMS/Arrows"	"\\circlearrowleft")
    ("AMS/Arrows"	"\\Lsh"	#X21B0)
    ("AMS/Arrows"	"\\upuparrows"	#X21C8)
    ("AMS/Arrows"	"\\upharpoonleft"	#X21BF)
    ("AMS/Arrows"	"\\downharpoonleft"	#X21C3)
    ("AMS/Arrows"	"\\multimap"	#X22B8)
    ("AMS/Arrows"	"\\leftrightsquigarrow"	#X21AD)
    ("AMS/Arrows"	"\\looparrowright"	#X21AC)
    ("AMS/Arrows"	"\\rightleftharpoons"	#X21CC)
    ("AMS/Arrows"	"\\curvearrowright"	#X21B7)
    ("AMS/Arrows"	"\\circlearrowright")
    ("AMS/Arrows"	"\\Rsh"	#X21B1)
    ("AMS/Arrows"	"\\downdownarrows"	#X21CA)
    ("AMS/Arrows"	"\\upharpoonright"	#X21BE)
    ("AMS/Arrows"	"\\downharpoonright"	#X21C2)
    ("AMS/Arrows"	"\\rightsquigarrow"	#X219D)
    ("AMS/Neg Arrows"	"\\nleftarrow"	#X219A)
    ("AMS/Neg Arrows"	"\\nrightarrow"	#X219B)
    ("AMS/Neg Arrows"	"\\nLeftarrow"	#X21CD)
    ("AMS/Neg Arrows"	"\\nRightarrow"	#X21CF)
    ("AMS/Neg Arrows"	"\\nleftrightarrow"	#X21AE)
    ("AMS/Neg Arrows"	"\\nLeftrightarrow"	#X21CE)
    ("AMS/Relational I"	"\\leqq"	#X2266)
    ("AMS/Relational I"	"\\leqslant"	#X2A7D)
    ("AMS/Relational I"	"\\eqslantless"	#X2A95)
    ("AMS/Relational I"	"\\lesssim"	#X2272)
    ("AMS/Relational I"	"\\lessapprox"	#X2A85)
    ("AMS/Relational I"	"\\approxeq"	#X224A)
    ("AMS/Relational I"	"\\lessdot"	#X22D6)
    ("AMS/Relational I"	"\\lll"	#X22D8)
    ("AMS/Relational I"	"\\lessgtr"	#X2276)
    ("AMS/Relational I"	"\\lesseqgtr"	#X22DA)
    ("AMS/Relational I"	"\\lesseqqgtr"	#X2A8B)
    ("AMS/Relational I"	"\\doteqdot")
    ("AMS/Relational I"	"\\risingdotseq"	#X2253)
    ("AMS/Relational I"	"\\fallingdotseq"	#X2252)
    ("AMS/Relational I"	"\\backsim"	#X223D)
    ("AMS/Relational I"	"\\backsimeq"	#X22CD)
    ("AMS/Relational I"	"\\subseteqq"	#X2AC5)
    ("AMS/Relational I"	"\\Subset"	#X22D0)
    ("AMS/Relational I"	"\\sqsubset"	#X228F)
    ("AMS/Relational I"	"\\preccurlyeq"	#X227C)
    ("AMS/Relational I"	"\\curlyeqprec"	#X22DE)
    ("AMS/Relational I"	"\\precsim"	#X227E)
    ("AMS/Relational I"	"\\precapprox"	#X2AB7)
    ("AMS/Relational I"	"\\vartriangleleft"	#X22B2)
    ("AMS/Relational I"	"\\trianglelefteq"	#X22B4)
    ("AMS/Relational I"	"\\vDash"	#X22A8)
    ("AMS/Relational I"	"\\Vvdash"	#X22AA)
    ("AMS/Relational I"	"\\smallsmile"	#X2323)
    ("AMS/Relational I"	"\\smallfrown"	#X2322)
    ("AMS/Relational I"	"\\bumpeq"	#X224F)
    ("AMS/Relational I"	"\\Bumpeq"	#X224E)
    ("AMS/Relational II"	"\\geqq"	#X2267)
    ("AMS/Relational II"	"\\geqslant"	#X2A7E)
    ("AMS/Relational II"	"\\eqslantgtr"	#X2A96)
    ("AMS/Relational II"	"\\gtrsim"	#X2273)
    ("AMS/Relational II"	"\\gtrapprox"	#X2A86)
    ("AMS/Relational II"	"\\gtrdot"	#X22D7)
    ("AMS/Relational II"	"\\ggg"	#X22D9)
    ("AMS/Relational II"	"\\gtrless"	#X2277)
    ("AMS/Relational II"	"\\gtreqless"	#X22DB)
    ("AMS/Relational II"	"\\gtreqqless"	#X2A8C)
    ("AMS/Relational II"	"\\eqcirc"	#X2256)
    ("AMS/Relational II"	"\\circeq"	#X2257)
    ("AMS/Relational II"	"\\triangleq"	#X225C)
    ("AMS/Relational II"	"\\thicksim"	#X223C)
    ("AMS/Relational II"	"\\thickapprox"	#X2248)
    ("AMS/Relational II"	"\\supseteqq"	#X2AC6)
    ("AMS/Relational II"	"\\Supset"	#X22D1)
    ("AMS/Relational II"	"\\sqsupset"	#X2290)
    ("AMS/Relational II"	"\\succcurlyeq"	#X227D)
    ("AMS/Relational II"	"\\curlyeqsucc"	#X22DF)
    ("AMS/Relational II"	"\\succsim"	#X227F)
    ("AMS/Relational II"	"\\succapprox"	#X2AB8)
    ("AMS/Relational II"	"\\vartriangleright"	#X22B3)
    ("AMS/Relational II"	"\\trianglerighteq"	#X22B5)
    ("AMS/Relational II"	"\\Vdash"	#X22A9)
    ("AMS/Relational II"	"\\shortmid"	#X2223)
    ("AMS/Relational II"	"\\shortparallel"	#X2225)
    ("AMS/Relational II"	"\\between"	#X226C)
    ("AMS/Relational II"	"\\pitchfork"	#X22D4)
    ("AMS/Relational II"	"\\varpropto"	#X221D)
    ("AMS/Relational II"	"\\blacktriangleleft"	#X25C0)
    ("AMS/Relational II"	"\\therefore"	#X2234)
    ("AMS/Relational II"	"\\backepsilon"	#X3F6)
    ("AMS/Relational II"	"\\blacktriangleright"	#X25B6)
    ("AMS/Relational II"	"\\because"	#X2235)
    ("AMS/Neg Rel I"	"\\nless"	#X226E)
    ("AMS/Neg Rel I"	"\\nleq"	#X2270)
    ("AMS/Neg Rel I"	"\\nleqslant")
    ("AMS/Neg Rel I"	"\\nleqq")
    ("AMS/Neg Rel I"	"\\lneq"	#X2A87)
    ("AMS/Neg Rel I"	"\\lneqq"	#X2268)
    ("AMS/Neg Rel I"	"\\lvertneqq")
    ("AMS/Neg Rel I"	"\\lnsim"	#X22E6)
    ("AMS/Neg Rel I"	"\\lnapprox"	#X2A89)
    ("AMS/Neg Rel I"	"\\nprec"	#X2280)
    ("AMS/Neg Rel I"	"\\npreceq")
    ("AMS/Neg Rel I"	"\\precnsim"	#X22E8)
    ("AMS/Neg Rel I"	"\\precnapprox"	#X2AB9)
    ("AMS/Neg Rel I"	"\\nsim"	#X2241)
    ("AMS/Neg Rel I"	"\\nshortmid"	#X2224)
    ("AMS/Neg Rel I"	"\\nmid"	#X2224)
    ("AMS/Neg Rel I"	"\\nvdash"	#X22AC)
    ("AMS/Neg Rel I"	"\\nvDash"	#X22AD)
    ("AMS/Neg Rel I"	"\\ntriangleleft"	#X22EA)
    ("AMS/Neg Rel I"	"\\ntrianglelefteq"	#X22EC)
    ("AMS/Neg Rel I"	"\\nsubseteq"	#X2288)
    ("AMS/Neg Rel I"	"\\subsetneq"	#X228A)
    ("AMS/Neg Rel I"	"\\varsubsetneq")
    ("AMS/Neg Rel I"	"\\subsetneqq"	#X2ACB)
    ("AMS/Neg Rel I"	"\\varsubsetneqq")
    ("AMS/Neg Rel II"	"\\ngtr"	#X226F)
    ("AMS/Neg Rel II"	"\\ngeq"	#X2271)
    ("AMS/Neg Rel II"	"\\ngeqslant")
    ("AMS/Neg Rel II"	"\\ngeqq")
    ("AMS/Neg Rel II"	"\\gneq"	#X2A88)
    ("AMS/Neg Rel II"	"\\gneqq"	#X2269)
    ("AMS/Neg Rel II"	"\\gvertneqq")
    ("AMS/Neg Rel II"	"\\gnsim"	#X22E7)
    ("AMS/Neg Rel II"	"\\gnapprox"	#X2A8A)
    ("AMS/Neg Rel II"	"\\nsucc"	#X2281)
    ("AMS/Neg Rel II"	"\\nsucceq")
    ("AMS/Neg Rel II"	"\\succnsim"	#X22E9)
    ("AMS/Neg Rel II"	"\\succnapprox"	#X2ABA)
    ("AMS/Neg Rel II"	"\\ncong"	#X2247)
    ("AMS/Neg Rel II"	"\\nshortparallel"	#X2226)
    ("AMS/Neg Rel II"	"\\nparallel"	#X2226)
    ("AMS/Neg Rel II"	"\\nvDash"	#X22AD)
    ("AMS/Neg Rel II"	"\\nVDash"	#X22AF)
    ("AMS/Neg Rel II"	"\\ntriangleright"	#X22EB)
    ("AMS/Neg Rel II"	"\\ntrianglerighteq"	#X22ED)
    ("AMS/Neg Rel II"	"\\nsupseteq"	#X2289)
    ("AMS/Neg Rel II"	"\\nsupseteqq")
    ("AMS/Neg Rel II"	"\\supsetneq"	#X228B)
    ("AMS/Neg Rel II"	"\\varsupsetneq")
    ("AMS/Neg Rel II"	"\\supsetneqq"	#X2ACC)
    ("AMS/Neg Rel II"	"\\varsupsetneqq")
    ("AMS/Binary Op"	"\\dotplus"	#X2214)
    ("AMS/Binary Op"	"\\smallsetminus"	#X2216)
    ("AMS/Binary Op"	"\\Cap"	#X22D2)
    ("AMS/Binary Op"	"\\Cup"	#X22D3)
    ("AMS/Binary Op"	"\\barwedge"	#X22BC)
    ("AMS/Binary Op"	"\\veebar"	#X22BB)
    ("AMS/Binary Op"	"\\doublebarwedge"	#X2306)
    ("AMS/Binary Op"	"\\boxminus"	#X229F)
    ("AMS/Binary Op"	"\\boxtimes"	#X22A0)
    ("AMS/Binary Op"	"\\boxdot"	#X22A1)
    ("AMS/Binary Op"	"\\boxplus"	#X229E)
    ("AMS/Binary Op"	"\\divideontimes"	#X22C7)
    ("AMS/Binary Op"	"\\ltimes"	#X22C9)
    ("AMS/Binary Op"	"\\rtimes"	#X22CA)
    ("AMS/Binary Op"	"\\leftthreetimes"	#X22CB)
    ("AMS/Binary Op"	"\\rightthreetimes"	#X22CC)
    ("AMS/Binary Op"	"\\curlywedge"	#X22CF)
    ("AMS/Binary Op"	"\\curlyvee"	#X22CE)
    ("AMS/Binary Op"	"\\circleddash"	#X229D)
    ("AMS/Binary Op"	"\\circledast"	#X229B)
    ("AMS/Binary Op"	"\\circledcirc"	#X229A)
    ("AMS/Binary Op"	"\\centerdot")
    ("AMS/Binary Op"	"\\intercal"	#X22BA)
    ("AMS/Misc"	"\\hbar"	#X210F)
    ("AMS/Misc"	"\\hslash"	#X210F)
    ("AMS/Misc"	"\\vartriangle"	#X25B5)
    ("AMS/Misc"	"\\triangledown"	#X25BF)
    ("AMS/Misc"	"\\square"	#X25A1)
    ("AMS/Misc"	"\\lozenge"	#X25CA)
    ("AMS/Misc"	"\\circledS"	#X24C8)
    ("AMS/Misc"	"\\angle"	#X2220)
    ("AMS/Misc"	"\\measuredangle"	#X2221)
    ("AMS/Misc"	"\\nexists"	#X2204)
    ("AMS/Misc"	"\\mho"	#X2127)
    ("AMS/Misc"	"\\Finv"	#X2132)
    ("AMS/Misc"	"\\Game"	#X2141)
    ("AMS/Misc"	"\\Bbbk"	#X1D55C)
    ("AMS/Misc"	"\\backprime"	#X2035)
    ("AMS/Misc"	"\\varnothing"	#X2205)
    ("AMS/Misc"	"\\blacktriangle"	#X25B4)
    ("AMS/Misc"	"\\blacktriangledown"	#X25BE)
    ("AMS/Misc"	"\\blacksquare"	#X25A0)
    ("AMS/Misc"	"\\blacklozenge"	#X29EB)
    ("AMS/Misc"	"\\bigstar"	#X2605)
    ("AMS/Misc"	"\\sphericalangle"	#X2222)
    ("AMS/Misc"	"\\complement"	#X2201)
    ("AMS/Misc"	"\\eth"	#XF0)
    ("AMS/Misc"	"\\diagup"	#X2571)
    ("AMS/Misc"	"\\diagdown"	#X2572)
    ("AMS/Accents"	"\\dddot"	#X20DB)
    ("AMS/Accents"	"\\ddddot"	#X20DC)
    ("AMS/Delimiters"	"\\bigl")
    ("AMS/Delimiters"	"\\bigr")
    ("AMS/Delimiters"	"\\Bigl")
    ("AMS/Delimiters"	"\\Bigr")
    ("AMS/Delimiters"	"\\biggl")
    ("AMS/Delimiters"	"\\biggr")
    ("AMS/Delimiters"	"\\Biggl")
    ("AMS/Delimiters"	"\\Biggr")
    ("AMS/Delimiters"	"\\lvert")
    ("AMS/Delimiters"	"\\rvert")
    ("AMS/Delimiters"	"\\lVert")
    ("AMS/Delimiters"	"\\rVert")
    ("AMS/Delimiters"	"\\ulcorner"	#X231C)
    ("AMS/Delimiters"	"\\urcorner"	#X231D)
    ("AMS/Delimiters"	"\\llcorner"	#X231E)
    ("AMS/Delimiters"	"\\lrcorner"	#X231F)
    ("AMS/Special"	"\\nobreakdash")
    ("AMS/Special"	"\\leftroot")
    ("AMS/Special"	"\\uproot")
    ("AMS/Special"	"\\accentedsymbol")
    ("AMS/Special"	"\\xleftarrow")
    ("AMS/Special"	"\\xrightarrow")
    ("AMS/Special"	"\\overset")
    ("AMS/Special"	"\\underset")
    ("AMS/Special"	"\\dfrac")
    ("AMS/Special"	"\\genfrac")
    ("AMS/Special"	"\\tfrac")
    ("AMS/Special"	"\\binom")
    ("AMS/Special"	"\\dbinom")
    ("AMS/Special"	"\\tbinom")
    ("AMS/Special"	"\\smash")
    ("AMS/Special"	"\\eucal")
    ("AMS/Special"	"\\boldsymbol")
    ("AMS/Special"	"\\text")
    ("AMS/Special"	"\\intertext")
    ("AMS/Special"	"\\substack")
    ("AMS/Special"	"\\subarray")
    ("AMS/Special"	"\\sideset"))
  "List of basic mathematical symbols.
Processed from `LaTeX-math-default' in AucTeX/latex.el. This list
contains a mapping of standard LaTeX math commands to unicode
characters. See also `math-symbol-list-extended'.")

(defconst math-symbol-list-extended
  '(("mathaccent" "\\acute" #X00301 "́")
    ("mathaccent" "\\annuity" #X020E7 "⃧")
    ("mathaccent" "\\asteraccent" #X020F0 "⃰")
    ("mathaccent" "\\bar" #X00304 "̄")
    ("mathaccent" "\\breve" #X00306 "̆")
    ("mathaccent" "\\candra" #X00310 "̐")
    ("mathaccent" "\\check" #X0030C "̌")
    ("mathaccent" "\\ddddot" #X020DC "⃜")
    ("mathaccent" "\\dddot" #X020DB "⃛")
    ("mathaccent" "\\ddot" #X00308 "̈")
    ("mathaccent" "\\dot" #X00307 "̇")
    ("mathaccent" "\\droang" #X0031A "̚")
    ("mathaccent" "\\enclosecircle" #X020DD "⃝")
    ("mathaccent" "\\enclosediamond" #X020DF "⃟")
    ("mathaccent" "\\enclosesquare" #X020DE "⃞")
    ("mathaccent" "\\enclosetriangle" #X020E4 "⃤")
    ("mathaccent" "\\grave" #X00300 "̀")
    ("mathaccent" "\\hat" #X00302 "̂")
    ("mathaccent" "\\leftharpoonaccent" #X020D0 "⃐")
    ("mathaccent" "\\not" #X00338 "̸")
    ("mathaccent" "\\ocirc" #X0030A "̊")
    ("mathaccent" "\\ocommatopright" #X00315 "̕")
    ("mathaccent" "\\oturnedcomma" #X00312 "̒")
    ("mathaccent" "\\overbar" #X00305 "̅")
    ("mathaccent" "\\overleftarrow" #X020D6 "⃖")
    ("mathaccent" "\\overleftrightarrow" #X020E1 "⃡")
    ("mathaccent" "\\ovhook" #X00309 "̉")
    ("mathaccent" "\\rightharpoonaccent" #X020D1 "⃑")
    ("mathaccent" "\\threeunderdot" #X020E8 "⃨")
    ("mathaccent" "\\tilde" #X00303 "̃")
    ("mathaccent" "\\underbar" #X00331 "̱")
    ("mathaccent" "\\underleftarrow" #X020EE "⃮")
    ("mathaccent" "\\underleftharpoondown" #X020ED "⃭")
    ("mathaccent" "\\underrightarrow" #X020EF "⃯")
    ("mathaccent" "\\underrightharpoondown" #X020EC "⃬")
    ("mathaccent" "\\vec" #X020D7 "⃗")
    ("mathaccent" "\\vertoverlay" #X020D2 "⃒")
    ("mathaccent" "\\widebridgeabove" #X020E9 "⃩")
    ("mathaccent" "\\wideutilde" #X00330 "̰")
    ("mathalpha" "\\Angstrom" #X0212B "Å")
    ("mathalpha" "\\BbbA" #X1D538 "𝔸")
    ("mathalpha" "\\BbbB" #X1D539 "𝔹")
    ("mathalpha" "\\BbbC" #X02102 "ℂ")
    ("mathalpha" "\\BbbD" #X1D53B "𝔻")
    ("mathalpha" "\\BbbE" #X1D53C "𝔼")
    ("mathalpha" "\\BbbF" #X1D53D "𝔽")
    ("mathalpha" "\\BbbG" #X1D53E "𝔾")
    ("mathalpha" "\\BbbGamma" #X0213E "ℾ")
    ("mathalpha" "\\BbbH" #X0210D "ℍ")
    ("mathalpha" "\\BbbI" #X1D540 "𝕀")
    ("mathalpha" "\\BbbJ" #X1D541 "𝕁")
    ("mathalpha" "\\BbbK" #X1D542 "𝕂")
    ("mathalpha" "\\BbbL" #X1D543 "𝕃")
    ("mathalpha" "\\BbbM" #X1D544 "𝕄")
    ("mathalpha" "\\BbbN" #X02115 "ℕ")
    ("mathalpha" "\\BbbO" #X1D546 "𝕆")
    ("mathalpha" "\\BbbP" #X02119 "ℙ")
    ("mathalpha" "\\BbbPi" #X0213F "ℿ")
    ("mathalpha" "\\BbbQ" #X0211A "ℚ")
    ("mathalpha" "\\BbbR" #X0211D "ℝ")
    ("mathalpha" "\\BbbS" #X1D54A "𝕊")
    ("mathalpha" "\\BbbT" #X1D54B "𝕋")
    ("mathalpha" "\\BbbU" #X1D54C "𝕌")
    ("mathalpha" "\\BbbV" #X1D54D "𝕍")
    ("mathalpha" "\\BbbW" #X1D54E "𝕎")
    ("mathalpha" "\\BbbX" #X1D54F "𝕏")
    ("mathalpha" "\\BbbY" #X1D550 "𝕐")
    ("mathalpha" "\\BbbZ" #X02124 "ℤ")
    ("mathalpha" "\\Bbba" #X1D552 "𝕒")
    ("mathalpha" "\\Bbbb" #X1D553 "𝕓")
    ("mathalpha" "\\Bbbc" #X1D554 "𝕔")
    ("mathalpha" "\\Bbbd" #X1D555 "𝕕")
    ("mathalpha" "\\Bbbe" #X1D556 "𝕖")
    ("mathalpha" "\\Bbbf" #X1D557 "𝕗")
    ("mathalpha" "\\Bbbg" #X1D558 "𝕘")
    ("mathalpha" "\\Bbbgamma" #X0213D "ℽ")
    ("mathalpha" "\\Bbbh" #X1D559 "𝕙")
    ("mathalpha" "\\Bbbi" #X1D55A "𝕚")
    ("mathalpha" "\\Bbbj" #X1D55B "𝕛")
    ("mathalpha" "\\Bbbk" #X1D55C "𝕜")
    ("mathalpha" "\\Bbbl" #X1D55D "𝕝")
    ("mathalpha" "\\Bbbm" #X1D55E "𝕞")
    ("mathalpha" "\\Bbbn" #X1D55F "𝕟")
    ("mathalpha" "\\Bbbo" #X1D560 "𝕠")
    ("mathalpha" "\\Bbbp" #X1D561 "𝕡")
    ("mathalpha" "\\Bbbq" #X1D562 "𝕢")
    ("mathalpha" "\\Bbbr" #X1D563 "𝕣")
    ("mathalpha" "\\Bbbs" #X1D564 "𝕤")
    ("mathalpha" "\\Bbbt" #X1D565 "𝕥")
    ("mathalpha" "\\Bbbu" #X1D566 "𝕦")
    ("mathalpha" "\\Bbbv" #X1D567 "𝕧")
    ("mathalpha" "\\Bbbw" #X1D568 "𝕨")
    ("mathalpha" "\\Bbbx" #X1D569 "𝕩")
    ("mathalpha" "\\Bbby" #X1D56A "𝕪")
    ("mathalpha" "\\Bbbz" #X1D56B "𝕫")
    ("mathalpha" "\\Im" #X02111 "ℑ")
    ("mathalpha" "\\Re" #X0211C "ℜ")
    ("mathalpha" "\\aleph" #X02135 "ℵ")
    ("mathalpha" "\\beth" #X02136 "ℶ")
    ("mathalpha" "\\daleth" #X02138 "ℸ")
    ("mathalpha" "\\ell" #X02113 "ℓ")
    ("mathalpha" "\\gimel" #X02137 "ℷ")
    ("mathalpha" "\\hslash" #X0210F "ℏ")
    ("mathalpha" "\\imath" #X1D6A4 "𝚤")
    ("mathalpha" "\\jmath" #X1D6A5 "𝚥")
    ("mathalpha" "\\matheth" #X000F0 "ð")
    ("mathalpha" "\\mbfA" #X1D400 "𝐀")
    ("mathalpha" "\\mbfAlpha" #X1D6A8 "𝚨")
    ("mathalpha" "\\mbfB" #X1D401 "𝐁")
    ("mathalpha" "\\mbfBeta" #X1D6A9 "𝚩")
    ("mathalpha" "\\mbfC" #X1D402 "𝐂")
    ("mathalpha" "\\mbfChi" #X1D6BE "𝚾")
    ("mathalpha" "\\mbfD" #X1D403 "𝐃")
    ("mathalpha" "\\mbfDelta" #X1D6AB "𝚫")
    ("mathalpha" "\\mbfDigamma" #X1D7CA "𝟊")
    ("mathalpha" "\\mbfE" #X1D404 "𝐄")
    ("mathalpha" "\\mbfEpsilon" #X1D6AC "𝚬")
    ("mathalpha" "\\mbfEta" #X1D6AE "𝚮")
    ("mathalpha" "\\mbfF" #X1D405 "𝐅")
    ("mathalpha" "\\mbfG" #X1D406 "𝐆")
    ("mathalpha" "\\mbfGamma" #X1D6AA "𝚪")
    ("mathalpha" "\\mbfH" #X1D407 "𝐇")
    ("mathalpha" "\\mbfI" #X1D408 "𝐈")
    ("mathalpha" "\\mbfIota" #X1D6B0 "𝚰")
    ("mathalpha" "\\mbfJ" #X1D409 "𝐉")
    ("mathalpha" "\\mbfK" #X1D40A "𝐊")
    ("mathalpha" "\\mbfKappa" #X1D6B1 "𝚱")
    ("mathalpha" "\\mbfL" #X1D40B "𝐋")
    ("mathalpha" "\\mbfLambda" #X1D6B2 "𝚲")
    ("mathalpha" "\\mbfM" #X1D40C "𝐌")
    ("mathalpha" "\\mbfMu" #X1D6B3 "𝚳")
    ("mathalpha" "\\mbfN" #X1D40D "𝐍")
    ("mathalpha" "\\mbfNu" #X1D6B4 "𝚴")
    ("mathalpha" "\\mbfO" #X1D40E "𝐎")
    ("mathalpha" "\\mbfOmega" #X1D6C0 "𝛀")
    ("mathalpha" "\\mbfOmicron" #X1D6B6 "𝚶")
    ("mathalpha" "\\mbfP" #X1D40F "𝐏")
    ("mathalpha" "\\mbfPhi" #X1D6BD "𝚽")
    ("mathalpha" "\\mbfPi" #X1D6B7 "𝚷")
    ("mathalpha" "\\mbfPsi" #X1D6BF "𝚿")
    ("mathalpha" "\\mbfQ" #X1D410 "𝐐")
    ("mathalpha" "\\mbfR" #X1D411 "𝐑")
    ("mathalpha" "\\mbfRho" #X1D6B8 "𝚸")
    ("mathalpha" "\\mbfS" #X1D412 "𝐒")
    ("mathalpha" "\\mbfSigma" #X1D6BA "𝚺")
    ("mathalpha" "\\mbfT" #X1D413 "𝐓")
    ("mathalpha" "\\mbfTau" #X1D6BB "𝚻")
    ("mathalpha" "\\mbfTheta" #X1D6AF "𝚯")
    ("mathalpha" "\\mbfU" #X1D414 "𝐔")
    ("mathalpha" "\\mbfUpsilon" #X1D6BC "𝚼")
    ("mathalpha" "\\mbfV" #X1D415 "𝐕")
    ("mathalpha" "\\mbfW" #X1D416 "𝐖")
    ("mathalpha" "\\mbfX" #X1D417 "𝐗")
    ("mathalpha" "\\mbfXi" #X1D6B5 "𝚵")
    ("mathalpha" "\\mbfY" #X1D418 "𝐘")
    ("mathalpha" "\\mbfZ" #X1D419 "𝐙")
    ("mathalpha" "\\mbfZeta" #X1D6AD "𝚭")
    ("mathalpha" "\\mbfa" #X1D41A "𝐚")
    ("mathalpha" "\\mbfalpha" #X1D6C2 "𝛂")
    ("mathalpha" "\\mbfb" #X1D41B "𝐛")
    ("mathalpha" "\\mbfbeta" #X1D6C3 "𝛃")
    ("mathalpha" "\\mbfc" #X1D41C "𝐜")
    ("mathalpha" "\\mbfchi" #X1D6D8 "𝛘")
    ("mathalpha" "\\mbfd" #X1D41D "𝐝")
    ("mathalpha" "\\mbfdelta" #X1D6C5 "𝛅")
    ("mathalpha" "\\mbfdigamma" #X1D7CB "𝟋")
    ("mathalpha" "\\mbfe" #X1D41E "𝐞")
    ("mathalpha" "\\mbfepsilon" #X1D6C6 "𝛆")
    ("mathalpha" "\\mbfeta" #X1D6C8 "𝛈")
    ("mathalpha" "\\mbff" #X1D41F "𝐟")
    ("mathalpha" "\\mbffrakA" #X1D56C "𝕬")
    ("mathalpha" "\\mbffrakB" #X1D56D "𝕭")
    ("mathalpha" "\\mbffrakC" #X1D56E "𝕮")
    ("mathalpha" "\\mbffrakD" #X1D56F "𝕯")
    ("mathalpha" "\\mbffrakE" #X1D570 "𝕰")
    ("mathalpha" "\\mbffrakF" #X1D571 "𝕱")
    ("mathalpha" "\\mbffrakG" #X1D572 "𝕲")
    ("mathalpha" "\\mbffrakH" #X1D573 "𝕳")
    ("mathalpha" "\\mbffrakI" #X1D574 "𝕴")
    ("mathalpha" "\\mbffrakJ" #X1D575 "𝕵")
    ("mathalpha" "\\mbffrakK" #X1D576 "𝕶")
    ("mathalpha" "\\mbffrakL" #X1D577 "𝕷")
    ("mathalpha" "\\mbffrakM" #X1D578 "𝕸")
    ("mathalpha" "\\mbffrakN" #X1D579 "𝕹")
    ("mathalpha" "\\mbffrakO" #X1D57A "𝕺")
    ("mathalpha" "\\mbffrakP" #X1D57B "𝕻")
    ("mathalpha" "\\mbffrakQ" #X1D57C "𝕼")
    ("mathalpha" "\\mbffrakR" #X1D57D "𝕽")
    ("mathalpha" "\\mbffrakS" #X1D57E "𝕾")
    ("mathalpha" "\\mbffrakT" #X1D57F "𝕿")
    ("mathalpha" "\\mbffrakU" #X1D580 "𝖀")
    ("mathalpha" "\\mbffrakV" #X1D581 "𝖁")
    ("mathalpha" "\\mbffrakW" #X1D582 "𝖂")
    ("mathalpha" "\\mbffrakX" #X1D583 "𝖃")
    ("mathalpha" "\\mbffrakY" #X1D584 "𝖄")
    ("mathalpha" "\\mbffrakZ" #X1D585 "𝖅")
    ("mathalpha" "\\mbffraka" #X1D586 "𝖆")
    ("mathalpha" "\\mbffrakb" #X1D587 "𝖇")
    ("mathalpha" "\\mbffrakc" #X1D588 "𝖈")
    ("mathalpha" "\\mbffrakd" #X1D589 "𝖉")
    ("mathalpha" "\\mbffrake" #X1D58A "𝖊")
    ("mathalpha" "\\mbffrakf" #X1D58B "𝖋")
    ("mathalpha" "\\mbffrakg" #X1D58C "𝖌")
    ("mathalpha" "\\mbffrakh" #X1D58D "𝖍")
    ("mathalpha" "\\mbffraki" #X1D58E "𝖎")
    ("mathalpha" "\\mbffrakj" #X1D58F "𝖏")
    ("mathalpha" "\\mbffrakk" #X1D590 "𝖐")
    ("mathalpha" "\\mbffrakl" #X1D591 "𝖑")
    ("mathalpha" "\\mbffrakm" #X1D592 "𝖒")
    ("mathalpha" "\\mbffrakn" #X1D593 "𝖓")
    ("mathalpha" "\\mbffrako" #X1D594 "𝖔")
    ("mathalpha" "\\mbffrakp" #X1D595 "𝖕")
    ("mathalpha" "\\mbffrakq" #X1D596 "𝖖")
    ("mathalpha" "\\mbffrakr" #X1D597 "𝖗")
    ("mathalpha" "\\mbffraks" #X1D598 "𝖘")
    ("mathalpha" "\\mbffrakt" #X1D599 "𝖙")
    ("mathalpha" "\\mbffraku" #X1D59A "𝖚")
    ("mathalpha" "\\mbffrakv" #X1D59B "𝖛")
    ("mathalpha" "\\mbffrakw" #X1D59C "𝖜")
    ("mathalpha" "\\mbffrakx" #X1D59D "𝖝")
    ("mathalpha" "\\mbffraky" #X1D59E "𝖞")
    ("mathalpha" "\\mbffrakz" #X1D59F "𝖟")
    ("mathalpha" "\\mbfg" #X1D420 "𝐠")
    ("mathalpha" "\\mbfgamma" #X1D6C4 "𝛄")
    ("mathalpha" "\\mbfh" #X1D421 "𝐡")
    ("mathalpha" "\\mbfi" #X1D422 "𝐢")
    ("mathalpha" "\\mbfiota" #X1D6CA "𝛊")
    ("mathalpha" "\\mbfitA" #X1D468 "𝑨")
    ("mathalpha" "\\mbfitAlpha" #X1D71C "𝜜")
    ("mathalpha" "\\mbfitB" #X1D469 "𝑩")
    ("mathalpha" "\\mbfitBeta" #X1D71D "𝜝")
    ("mathalpha" "\\mbfitC" #X1D46A "𝑪")
    ("mathalpha" "\\mbfitChi" #X1D732 "𝜲")
    ("mathalpha" "\\mbfitD" #X1D46B "𝑫")
    ("mathalpha" "\\mbfitDelta" #X1D71F "𝜟")
    ("mathalpha" "\\mbfitE" #X1D46C "𝑬")
    ("mathalpha" "\\mbfitEpsilon" #X1D720 "𝜠")
    ("mathalpha" "\\mbfitEta" #X1D722 "𝜢")
    ("mathalpha" "\\mbfitF" #X1D46D "𝑭")
    ("mathalpha" "\\mbfitG" #X1D46E "𝑮")
    ("mathalpha" "\\mbfitGamma" #X1D71E "𝜞")
    ("mathalpha" "\\mbfitH" #X1D46F "𝑯")
    ("mathalpha" "\\mbfitI" #X1D470 "𝑰")
    ("mathalpha" "\\mbfitIota" #X1D724 "𝜤")
    ("mathalpha" "\\mbfitJ" #X1D471 "𝑱")
    ("mathalpha" "\\mbfitK" #X1D472 "𝑲")
    ("mathalpha" "\\mbfitKappa" #X1D725 "𝜥")
    ("mathalpha" "\\mbfitL" #X1D473 "𝑳")
    ("mathalpha" "\\mbfitLambda" #X1D726 "𝜦")
    ("mathalpha" "\\mbfitM" #X1D474 "𝑴")
    ("mathalpha" "\\mbfitMu" #X1D727 "𝜧")
    ("mathalpha" "\\mbfitN" #X1D475 "𝑵")
    ("mathalpha" "\\mbfitNu" #X1D728 "𝜨")
    ("mathalpha" "\\mbfitO" #X1D476 "𝑶")
    ("mathalpha" "\\mbfitOmega" #X1D734 "𝜴")
    ("mathalpha" "\\mbfitOmicron" #X1D72A "𝜪")
    ("mathalpha" "\\mbfitP" #X1D477 "𝑷")
    ("mathalpha" "\\mbfitPhi" #X1D731 "𝜱")
    ("mathalpha" "\\mbfitPi" #X1D72B "𝜫")
    ("mathalpha" "\\mbfitPsi" #X1D733 "𝜳")
    ("mathalpha" "\\mbfitQ" #X1D478 "𝑸")
    ("mathalpha" "\\mbfitR" #X1D479 "𝑹")
    ("mathalpha" "\\mbfitRho" #X1D72C "𝜬")
    ("mathalpha" "\\mbfitS" #X1D47A "𝑺")
    ("mathalpha" "\\mbfitSigma" #X1D72E "𝜮")
    ("mathalpha" "\\mbfitT" #X1D47B "𝑻")
    ("mathalpha" "\\mbfitTau" #X1D72F "𝜯")
    ("mathalpha" "\\mbfitTheta" #X1D723 "𝜣")
    ("mathalpha" "\\mbfitU" #X1D47C "𝑼")
    ("mathalpha" "\\mbfitUpsilon" #X1D730 "𝜰")
    ("mathalpha" "\\mbfitV" #X1D47D "𝑽")
    ("mathalpha" "\\mbfitW" #X1D47E "𝑾")
    ("mathalpha" "\\mbfitX" #X1D47F "𝑿")
    ("mathalpha" "\\mbfitXi" #X1D729 "𝜩")
    ("mathalpha" "\\mbfitY" #X1D480 "𝒀")
    ("mathalpha" "\\mbfitZ" #X1D481 "𝒁")
    ("mathalpha" "\\mbfitZeta" #X1D721 "𝜡")
    ("mathalpha" "\\mbfita" #X1D482 "𝒂")
    ("mathalpha" "\\mbfitalpha" #X1D736 "𝜶")
    ("mathalpha" "\\mbfitb" #X1D483 "𝒃")
    ("mathalpha" "\\mbfitbeta" #X1D737 "𝜷")
    ("mathalpha" "\\mbfitc" #X1D484 "𝒄")
    ("mathalpha" "\\mbfitchi" #X1D74C "𝝌")
    ("mathalpha" "\\mbfitd" #X1D485 "𝒅")
    ("mathalpha" "\\mbfitdelta" #X1D739 "𝜹")
    ("mathalpha" "\\mbfite" #X1D486 "𝒆")
    ("mathalpha" "\\mbfitepsilon" #X1D73A "𝜺")
    ("mathalpha" "\\mbfiteta" #X1D73C "𝜼")
    ("mathalpha" "\\mbfitf" #X1D487 "𝒇")
    ("mathalpha" "\\mbfitg" #X1D488 "𝒈")
    ("mathalpha" "\\mbfitgamma" #X1D738 "𝜸")
    ("mathalpha" "\\mbfith" #X1D489 "𝒉")
    ("mathalpha" "\\mbfiti" #X1D48A "𝒊")
    ("mathalpha" "\\mbfitiota" #X1D73E "𝜾")
    ("mathalpha" "\\mbfitj" #X1D48B "𝒋")
    ("mathalpha" "\\mbfitk" #X1D48C "𝒌")
    ("mathalpha" "\\mbfitkappa" #X1D73F "𝜿")
    ("mathalpha" "\\mbfitl" #X1D48D "𝒍")
    ("mathalpha" "\\mbfitlambda" #X1D740 "𝝀")
    ("mathalpha" "\\mbfitm" #X1D48E "𝒎")
    ("mathalpha" "\\mbfitmu" #X1D741 "𝝁")
    ("mathalpha" "\\mbfitn" #X1D48F "𝒏")
    ("mathalpha" "\\mbfitnu" #X1D742 "𝝂")
    ("mathalpha" "\\mbfito" #X1D490 "𝒐")
    ("mathalpha" "\\mbfitomega" #X1D74E "𝝎")
    ("mathalpha" "\\mbfitomicron" #X1D744 "𝝄")
    ("mathalpha" "\\mbfitp" #X1D491 "𝒑")
    ("mathalpha" "\\mbfitphi" #X1D74B "𝝋")
    ("mathalpha" "\\mbfitpi" #X1D745 "𝝅")
    ("mathalpha" "\\mbfitpsi" #X1D74D "𝝍")
    ("mathalpha" "\\mbfitq" #X1D492 "𝒒")
    ("mathalpha" "\\mbfitr" #X1D493 "𝒓")
    ("mathalpha" "\\mbfitrho" #X1D746 "𝝆")
    ("mathalpha" "\\mbfits" #X1D494 "𝒔")
    ("mathalpha" "\\mbfitsansA" #X1D63C "𝘼")
    ("mathalpha" "\\mbfitsansAlpha" #X1D790 "𝞐")
    ("mathalpha" "\\mbfitsansB" #X1D63D "𝘽")
    ("mathalpha" "\\mbfitsansBeta" #X1D791 "𝞑")
    ("mathalpha" "\\mbfitsansC" #X1D63E "𝘾")
    ("mathalpha" "\\mbfitsansChi" #X1D7A6 "𝞦")
    ("mathalpha" "\\mbfitsansD" #X1D63F "𝘿")
    ("mathalpha" "\\mbfitsansDelta" #X1D793 "𝞓")
    ("mathalpha" "\\mbfitsansE" #X1D640 "𝙀")
    ("mathalpha" "\\mbfitsansEpsilon" #X1D794 "𝞔")
    ("mathalpha" "\\mbfitsansEta" #X1D796 "𝞖")
    ("mathalpha" "\\mbfitsansF" #X1D641 "𝙁")
    ("mathalpha" "\\mbfitsansG" #X1D642 "𝙂")
    ("mathalpha" "\\mbfitsansGamma" #X1D792 "𝞒")
    ("mathalpha" "\\mbfitsansH" #X1D643 "𝙃")
    ("mathalpha" "\\mbfitsansI" #X1D644 "𝙄")
    ("mathalpha" "\\mbfitsansIota" #X1D798 "𝞘")
    ("mathalpha" "\\mbfitsansJ" #X1D645 "𝙅")
    ("mathalpha" "\\mbfitsansK" #X1D646 "𝙆")
    ("mathalpha" "\\mbfitsansKappa" #X1D799 "𝞙")
    ("mathalpha" "\\mbfitsansL" #X1D647 "𝙇")
    ("mathalpha" "\\mbfitsansLambda" #X1D79A "𝞚")
    ("mathalpha" "\\mbfitsansM" #X1D648 "𝙈")
    ("mathalpha" "\\mbfitsansMu" #X1D79B "𝞛")
    ("mathalpha" "\\mbfitsansN" #X1D649 "𝙉")
    ("mathalpha" "\\mbfitsansNu" #X1D79C "𝞜")
    ("mathalpha" "\\mbfitsansO" #X1D64A "𝙊")
    ("mathalpha" "\\mbfitsansOmega" #X1D7A8 "𝞨")
    ("mathalpha" "\\mbfitsansOmicron" #X1D79E "𝞞")
    ("mathalpha" "\\mbfitsansP" #X1D64B "𝙋")
    ("mathalpha" "\\mbfitsansPhi" #X1D7A5 "𝞥")
    ("mathalpha" "\\mbfitsansPi" #X1D79F "𝞟")
    ("mathalpha" "\\mbfitsansPsi" #X1D7A7 "𝞧")
    ("mathalpha" "\\mbfitsansQ" #X1D64C "𝙌")
    ("mathalpha" "\\mbfitsansR" #X1D64D "𝙍")
    ("mathalpha" "\\mbfitsansRho" #X1D7A0 "𝞠")
    ("mathalpha" "\\mbfitsansS" #X1D64E "𝙎")
    ("mathalpha" "\\mbfitsansSigma" #X1D7A2 "𝞢")
    ("mathalpha" "\\mbfitsansT" #X1D64F "𝙏")
    ("mathalpha" "\\mbfitsansTau" #X1D7A3 "𝞣")
    ("mathalpha" "\\mbfitsansTheta" #X1D797 "𝞗")
    ("mathalpha" "\\mbfitsansU" #X1D650 "𝙐")
    ("mathalpha" "\\mbfitsansUpsilon" #X1D7A4 "𝞤")
    ("mathalpha" "\\mbfitsansV" #X1D651 "𝙑")
    ("mathalpha" "\\mbfitsansW" #X1D652 "𝙒")
    ("mathalpha" "\\mbfitsansX" #X1D653 "𝙓")
    ("mathalpha" "\\mbfitsansXi" #X1D79D "𝞝")
    ("mathalpha" "\\mbfitsansY" #X1D654 "𝙔")
    ("mathalpha" "\\mbfitsansZ" #X1D655 "𝙕")
    ("mathalpha" "\\mbfitsansZeta" #X1D795 "𝞕")
    ("mathalpha" "\\mbfitsansa" #X1D656 "𝙖")
    ("mathalpha" "\\mbfitsansalpha" #X1D7AA "𝞪")
    ("mathalpha" "\\mbfitsansb" #X1D657 "𝙗")
    ("mathalpha" "\\mbfitsansbeta" #X1D7AB "𝞫")
    ("mathalpha" "\\mbfitsansc" #X1D658 "𝙘")
    ("mathalpha" "\\mbfitsanschi" #X1D7C0 "𝟀")
    ("mathalpha" "\\mbfitsansd" #X1D659 "𝙙")
    ("mathalpha" "\\mbfitsansdelta" #X1D7AD "𝞭")
    ("mathalpha" "\\mbfitsanse" #X1D65A "𝙚")
    ("mathalpha" "\\mbfitsansepsilon" #X1D7AE "𝞮")
    ("mathalpha" "\\mbfitsanseta" #X1D7B0 "𝞰")
    ("mathalpha" "\\mbfitsansf" #X1D65B "𝙛")
    ("mathalpha" "\\mbfitsansg" #X1D65C "𝙜")
    ("mathalpha" "\\mbfitsansgamma" #X1D7AC "𝞬")
    ("mathalpha" "\\mbfitsansh" #X1D65D "𝙝")
    ("mathalpha" "\\mbfitsansi" #X1D65E "𝙞")
    ("mathalpha" "\\mbfitsansiota" #X1D7B2 "𝞲")
    ("mathalpha" "\\mbfitsansj" #X1D65F "𝙟")
    ("mathalpha" "\\mbfitsansk" #X1D660 "𝙠")
    ("mathalpha" "\\mbfitsanskappa" #X1D7B3 "𝞳")
    ("mathalpha" "\\mbfitsansl" #X1D661 "𝙡")
    ("mathalpha" "\\mbfitsanslambda" #X1D7B4 "𝞴")
    ("mathalpha" "\\mbfitsansm" #X1D662 "𝙢")
    ("mathalpha" "\\mbfitsansmu" #X1D7B5 "𝞵")
    ("mathalpha" "\\mbfitsansn" #X1D663 "𝙣")
    ("mathalpha" "\\mbfitsansnu" #X1D7B6 "𝞶")
    ("mathalpha" "\\mbfitsanso" #X1D664 "𝙤")
    ("mathalpha" "\\mbfitsansomega" #X1D7C2 "𝟂")
    ("mathalpha" "\\mbfitsansomicron" #X1D7B8 "𝞸")
    ("mathalpha" "\\mbfitsansp" #X1D665 "𝙥")
    ("mathalpha" "\\mbfitsansphi" #X1D7BF "𝞿")
    ("mathalpha" "\\mbfitsanspi" #X1D7B9 "𝞹")
    ("mathalpha" "\\mbfitsanspsi" #X1D7C1 "𝟁")
    ("mathalpha" "\\mbfitsansq" #X1D666 "𝙦")
    ("mathalpha" "\\mbfitsansr" #X1D667 "𝙧")
    ("mathalpha" "\\mbfitsansrho" #X1D7BA "𝞺")
    ("mathalpha" "\\mbfitsanss" #X1D668 "𝙨")
    ("mathalpha" "\\mbfitsanssigma" #X1D7BC "𝞼")
    ("mathalpha" "\\mbfitsanst" #X1D669 "𝙩")
    ("mathalpha" "\\mbfitsanstau" #X1D7BD "𝞽")
    ("mathalpha" "\\mbfitsanstheta" #X1D7B1 "𝞱")
    ("mathalpha" "\\mbfitsansu" #X1D66A "𝙪")
    ("mathalpha" "\\mbfitsansupsilon" #X1D7BE "𝞾")
    ("mathalpha" "\\mbfitsansv" #X1D66B "𝙫")
    ("mathalpha" "\\mbfitsansvarTheta" #X1D7A1 "𝞡")
    ("mathalpha" "\\mbfitsansvarepsilon" #X1D7C4 "𝟄")
    ("mathalpha" "\\mbfitsansvarkappa" #X1D7C6 "𝟆")
    ("mathalpha" "\\mbfitsansvarphi" #X1D7C7 "𝟇")
    ("mathalpha" "\\mbfitsansvarpi" #X1D7C9 "𝟉")
    ("mathalpha" "\\mbfitsansvarrho" #X1D7C8 "𝟈")
    ("mathalpha" "\\mbfitsansvarsigma" #X1D7BB "𝞻")
    ("mathalpha" "\\mbfitsansvartheta" #X1D7C5 "𝟅")
    ("mathalpha" "\\mbfitsansw" #X1D66C "𝙬")
    ("mathalpha" "\\mbfitsansx" #X1D66D "𝙭")
    ("mathalpha" "\\mbfitsansxi" #X1D7B7 "𝞷")
    ("mathalpha" "\\mbfitsansy" #X1D66E "𝙮")
    ("mathalpha" "\\mbfitsansz" #X1D66F "𝙯")
    ("mathalpha" "\\mbfitsanszeta" #X1D7AF "𝞯")
    ("mathalpha" "\\mbfitsigma" #X1D748 "𝝈")
    ("mathalpha" "\\mbfitt" #X1D495 "𝒕")
    ("mathalpha" "\\mbfittau" #X1D749 "𝝉")
    ("mathalpha" "\\mbfittheta" #X1D73D "𝜽")
    ("mathalpha" "\\mbfitu" #X1D496 "𝒖")
    ("mathalpha" "\\mbfitupsilon" #X1D74A "𝝊")
    ("mathalpha" "\\mbfitv" #X1D497 "𝒗")
    ("mathalpha" "\\mbfitvarTheta" #X1D72D "𝜭")
    ("mathalpha" "\\mbfitvarepsilon" #X1D750 "𝝐")
    ("mathalpha" "\\mbfitvarkappa" #X1D752 "𝝒")
    ("mathalpha" "\\mbfitvarphi" #X1D753 "𝝓")
    ("mathalpha" "\\mbfitvarpi" #X1D755 "𝝕")
    ("mathalpha" "\\mbfitvarrho" #X1D754 "𝝔")
    ("mathalpha" "\\mbfitvarsigma" #X1D747 "𝝇")
    ("mathalpha" "\\mbfitvartheta" #X1D751 "𝝑")
    ("mathalpha" "\\mbfitw" #X1D498 "𝒘")
    ("mathalpha" "\\mbfitx" #X1D499 "𝒙")
    ("mathalpha" "\\mbfitxi" #X1D743 "𝝃")
    ("mathalpha" "\\mbfity" #X1D49A "𝒚")
    ("mathalpha" "\\mbfitz" #X1D49B "𝒛")
    ("mathalpha" "\\mbfitzeta" #X1D73B "𝜻")
    ("mathalpha" "\\mbfj" #X1D423 "𝐣")
    ("mathalpha" "\\mbfk" #X1D424 "𝐤")
    ("mathalpha" "\\mbfkappa" #X1D6CB "𝛋")
    ("mathalpha" "\\mbfl" #X1D425 "𝐥")
    ("mathalpha" "\\mbflambda" #X1D6CC "𝛌")
    ("mathalpha" "\\mbfm" #X1D426 "𝐦")
    ("mathalpha" "\\mbfmu" #X1D6CD "𝛍")
    ("mathalpha" "\\mbfn" #X1D427 "𝐧")
    ("mathalpha" "\\mbfnu" #X1D6CE "𝛎")
    ("mathalpha" "\\mbfo" #X1D428 "𝐨")
    ("mathalpha" "\\mbfomega" #X1D6DA "𝛚")
    ("mathalpha" "\\mbfomicron" #X1D6D0 "𝛐")
    ("mathalpha" "\\mbfp" #X1D429 "𝐩")
    ("mathalpha" "\\mbfphi" #X1D6DF "𝛟")
    ("mathalpha" "\\mbfpi" #X1D6D1 "𝛑")
    ("mathalpha" "\\mbfpsi" #X1D6D9 "𝛙")
    ("mathalpha" "\\mbfq" #X1D42A "𝐪")
    ("mathalpha" "\\mbfr" #X1D42B "𝐫")
    ("mathalpha" "\\mbfrho" #X1D6D2 "𝛒")
    ("mathalpha" "\\mbfs" #X1D42C "𝐬")
    ("mathalpha" "\\mbfsansA" #X1D5D4 "𝗔")
    ("mathalpha" "\\mbfsansAlpha" #X1D756 "𝝖")
    ("mathalpha" "\\mbfsansB" #X1D5D5 "𝗕")
    ("mathalpha" "\\mbfsansBeta" #X1D757 "𝝗")
    ("mathalpha" "\\mbfsansC" #X1D5D6 "𝗖")
    ("mathalpha" "\\mbfsansChi" #X1D76C "𝝬")
    ("mathalpha" "\\mbfsansD" #X1D5D7 "𝗗")
    ("mathalpha" "\\mbfsansDelta" #X1D759 "𝝙")
    ("mathalpha" "\\mbfsansE" #X1D5D8 "𝗘")
    ("mathalpha" "\\mbfsansEpsilon" #X1D75A "𝝚")
    ("mathalpha" "\\mbfsansEta" #X1D75C "𝝜")
    ("mathalpha" "\\mbfsansF" #X1D5D9 "𝗙")
    ("mathalpha" "\\mbfsansG" #X1D5DA "𝗚")
    ("mathalpha" "\\mbfsansGamma" #X1D758 "𝝘")
    ("mathalpha" "\\mbfsansH" #X1D5DB "𝗛")
    ("mathalpha" "\\mbfsansI" #X1D5DC "𝗜")
    ("mathalpha" "\\mbfsansIota" #X1D75E "𝝞")
    ("mathalpha" "\\mbfsansJ" #X1D5DD "𝗝")
    ("mathalpha" "\\mbfsansK" #X1D5DE "𝗞")
    ("mathalpha" "\\mbfsansKappa" #X1D75F "𝝟")
    ("mathalpha" "\\mbfsansL" #X1D5DF "𝗟")
    ("mathalpha" "\\mbfsansLambda" #X1D760 "𝝠")
    ("mathalpha" "\\mbfsansM" #X1D5E0 "𝗠")
    ("mathalpha" "\\mbfsansMu" #X1D761 "𝝡")
    ("mathalpha" "\\mbfsansN" #X1D5E1 "𝗡")
    ("mathalpha" "\\mbfsansNu" #X1D762 "𝝢")
    ("mathalpha" "\\mbfsansO" #X1D5E2 "𝗢")
    ("mathalpha" "\\mbfsansOmega" #X1D76E "𝝮")
    ("mathalpha" "\\mbfsansOmicron" #X1D764 "𝝤")
    ("mathalpha" "\\mbfsansP" #X1D5E3 "𝗣")
    ("mathalpha" "\\mbfsansPhi" #X1D76B "𝝫")
    ("mathalpha" "\\mbfsansPi" #X1D765 "𝝥")
    ("mathalpha" "\\mbfsansPsi" #X1D76D "𝝭")
    ("mathalpha" "\\mbfsansQ" #X1D5E4 "𝗤")
    ("mathalpha" "\\mbfsansR" #X1D5E5 "𝗥")
    ("mathalpha" "\\mbfsansRho" #X1D766 "𝝦")
    ("mathalpha" "\\mbfsansS" #X1D5E6 "𝗦")
    ("mathalpha" "\\mbfsansSigma" #X1D768 "𝝨")
    ("mathalpha" "\\mbfsansT" #X1D5E7 "𝗧")
    ("mathalpha" "\\mbfsansTau" #X1D769 "𝝩")
    ("mathalpha" "\\mbfsansTheta" #X1D75D "𝝝")
    ("mathalpha" "\\mbfsansU" #X1D5E8 "𝗨")
    ("mathalpha" "\\mbfsansUpsilon" #X1D76A "𝝪")
    ("mathalpha" "\\mbfsansV" #X1D5E9 "𝗩")
    ("mathalpha" "\\mbfsansW" #X1D5EA "𝗪")
    ("mathalpha" "\\mbfsansX" #X1D5EB "𝗫")
    ("mathalpha" "\\mbfsansXi" #X1D763 "𝝣")
    ("mathalpha" "\\mbfsansY" #X1D5EC "𝗬")
    ("mathalpha" "\\mbfsansZ" #X1D5ED "𝗭")
    ("mathalpha" "\\mbfsansZeta" #X1D75B "𝝛")
    ("mathalpha" "\\mbfsansa" #X1D5EE "𝗮")
    ("mathalpha" "\\mbfsansalpha" #X1D770 "𝝰")
    ("mathalpha" "\\mbfsansb" #X1D5EF "𝗯")
    ("mathalpha" "\\mbfsansbeta" #X1D771 "𝝱")
    ("mathalpha" "\\mbfsansc" #X1D5F0 "𝗰")
    ("mathalpha" "\\mbfsanschi" #X1D786 "𝞆")
    ("mathalpha" "\\mbfsansd" #X1D5F1 "𝗱")
    ("mathalpha" "\\mbfsansdelta" #X1D773 "𝝳")
    ("mathalpha" "\\mbfsanse" #X1D5F2 "𝗲")
    ("mathalpha" "\\mbfsansepsilon" #X1D774 "𝝴")
    ("mathalpha" "\\mbfsanseta" #X1D776 "𝝶")
    ("mathalpha" "\\mbfsansf" #X1D5F3 "𝗳")
    ("mathalpha" "\\mbfsansg" #X1D5F4 "𝗴")
    ("mathalpha" "\\mbfsansgamma" #X1D772 "𝝲")
    ("mathalpha" "\\mbfsansh" #X1D5F5 "𝗵")
    ("mathalpha" "\\mbfsansi" #X1D5F6 "𝗶")
    ("mathalpha" "\\mbfsansiota" #X1D778 "𝝸")
    ("mathalpha" "\\mbfsansj" #X1D5F7 "𝗷")
    ("mathalpha" "\\mbfsansk" #X1D5F8 "𝗸")
    ("mathalpha" "\\mbfsanskappa" #X1D779 "𝝹")
    ("mathalpha" "\\mbfsansl" #X1D5F9 "𝗹")
    ("mathalpha" "\\mbfsanslambda" #X1D77A "𝝺")
    ("mathalpha" "\\mbfsansm" #X1D5FA "𝗺")
    ("mathalpha" "\\mbfsansmu" #X1D77B "𝝻")
    ("mathalpha" "\\mbfsansn" #X1D5FB "𝗻")
    ("mathalpha" "\\mbfsansnu" #X1D77C "𝝼")
    ("mathalpha" "\\mbfsanso" #X1D5FC "𝗼")
    ("mathalpha" "\\mbfsansomega" #X1D788 "𝞈")
    ("mathalpha" "\\mbfsansomicron" #X1D77E "𝝾")
    ("mathalpha" "\\mbfsansp" #X1D5FD "𝗽")
    ("mathalpha" "\\mbfsansphi" #X1D785 "𝞅")
    ("mathalpha" "\\mbfsanspi" #X1D77F "𝝿")
    ("mathalpha" "\\mbfsanspsi" #X1D787 "𝞇")
    ("mathalpha" "\\mbfsansq" #X1D5FE "𝗾")
    ("mathalpha" "\\mbfsansr" #X1D5FF "𝗿")
    ("mathalpha" "\\mbfsansrho" #X1D780 "𝞀")
    ("mathalpha" "\\mbfsanss" #X1D600 "𝘀")
    ("mathalpha" "\\mbfsanssigma" #X1D782 "𝞂")
    ("mathalpha" "\\mbfsanst" #X1D601 "𝘁")
    ("mathalpha" "\\mbfsanstau" #X1D783 "𝞃")
    ("mathalpha" "\\mbfsanstheta" #X1D777 "𝝷")
    ("mathalpha" "\\mbfsansu" #X1D602 "𝘂")
    ("mathalpha" "\\mbfsansupsilon" #X1D784 "𝞄")
    ("mathalpha" "\\mbfsansv" #X1D603 "𝘃")
    ("mathalpha" "\\mbfsansvarTheta" #X1D767 "𝝧")
    ("mathalpha" "\\mbfsansvarepsilon" #X1D78A "𝞊")
    ("mathalpha" "\\mbfsansvarkappa" #X1D78C "𝞌")
    ("mathalpha" "\\mbfsansvarphi" #X1D78D "𝞍")
    ("mathalpha" "\\mbfsansvarpi" #X1D78F "𝞏")
    ("mathalpha" "\\mbfsansvarrho" #X1D78E "𝞎")
    ("mathalpha" "\\mbfsansvarsigma" #X1D781 "𝞁")
    ("mathalpha" "\\mbfsansvartheta" #X1D78B "𝞋")
    ("mathalpha" "\\mbfsansw" #X1D604 "𝘄")
    ("mathalpha" "\\mbfsansx" #X1D605 "𝘅")
    ("mathalpha" "\\mbfsansxi" #X1D77D "𝝽")
    ("mathalpha" "\\mbfsansy" #X1D606 "𝘆")
    ("mathalpha" "\\mbfsansz" #X1D607 "𝘇")
    ("mathalpha" "\\mbfsanszeta" #X1D775 "𝝵")
    ("mathalpha" "\\mbfscrA" #X1D4D0 "𝓐")
    ("mathalpha" "\\mbfscrB" #X1D4D1 "𝓑")
    ("mathalpha" "\\mbfscrC" #X1D4D2 "𝓒")
    ("mathalpha" "\\mbfscrD" #X1D4D3 "𝓓")
    ("mathalpha" "\\mbfscrE" #X1D4D4 "𝓔")
    ("mathalpha" "\\mbfscrF" #X1D4D5 "𝓕")
    ("mathalpha" "\\mbfscrG" #X1D4D6 "𝓖")
    ("mathalpha" "\\mbfscrH" #X1D4D7 "𝓗")
    ("mathalpha" "\\mbfscrI" #X1D4D8 "𝓘")
    ("mathalpha" "\\mbfscrJ" #X1D4D9 "𝓙")
    ("mathalpha" "\\mbfscrK" #X1D4DA "𝓚")
    ("mathalpha" "\\mbfscrL" #X1D4DB "𝓛")
    ("mathalpha" "\\mbfscrM" #X1D4DC "𝓜")
    ("mathalpha" "\\mbfscrN" #X1D4DD "𝓝")
    ("mathalpha" "\\mbfscrO" #X1D4DE "𝓞")
    ("mathalpha" "\\mbfscrP" #X1D4DF "𝓟")
    ("mathalpha" "\\mbfscrQ" #X1D4E0 "𝓠")
    ("mathalpha" "\\mbfscrR" #X1D4E1 "𝓡")
    ("mathalpha" "\\mbfscrS" #X1D4E2 "𝓢")
    ("mathalpha" "\\mbfscrT" #X1D4E3 "𝓣")
    ("mathalpha" "\\mbfscrU" #X1D4E4 "𝓤")
    ("mathalpha" "\\mbfscrV" #X1D4E5 "𝓥")
    ("mathalpha" "\\mbfscrW" #X1D4E6 "𝓦")
    ("mathalpha" "\\mbfscrX" #X1D4E7 "𝓧")
    ("mathalpha" "\\mbfscrY" #X1D4E8 "𝓨")
    ("mathalpha" "\\mbfscrZ" #X1D4E9 "𝓩")
    ("mathalpha" "\\mbfscra" #X1D4EA "𝓪")
    ("mathalpha" "\\mbfscrb" #X1D4EB "𝓫")
    ("mathalpha" "\\mbfscrc" #X1D4EC "𝓬")
    ("mathalpha" "\\mbfscrd" #X1D4ED "𝓭")
    ("mathalpha" "\\mbfscre" #X1D4EE "𝓮")
    ("mathalpha" "\\mbfscrf" #X1D4EF "𝓯")
    ("mathalpha" "\\mbfscrg" #X1D4F0 "𝓰")
    ("mathalpha" "\\mbfscrh" #X1D4F1 "𝓱")
    ("mathalpha" "\\mbfscri" #X1D4F2 "𝓲")
    ("mathalpha" "\\mbfscrj" #X1D4F3 "𝓳")
    ("mathalpha" "\\mbfscrk" #X1D4F4 "𝓴")
    ("mathalpha" "\\mbfscrl" #X1D4F5 "𝓵")
    ("mathalpha" "\\mbfscrm" #X1D4F6 "𝓶")
    ("mathalpha" "\\mbfscrn" #X1D4F7 "𝓷")
    ("mathalpha" "\\mbfscro" #X1D4F8 "𝓸")
    ("mathalpha" "\\mbfscrp" #X1D4F9 "𝓹")
    ("mathalpha" "\\mbfscrq" #X1D4FA "𝓺")
    ("mathalpha" "\\mbfscrr" #X1D4FB "𝓻")
    ("mathalpha" "\\mbfscrs" #X1D4FC "𝓼")
    ("mathalpha" "\\mbfscrt" #X1D4FD "𝓽")
    ("mathalpha" "\\mbfscru" #X1D4FE "𝓾")
    ("mathalpha" "\\mbfscrv" #X1D4FF "𝓿")
    ("mathalpha" "\\mbfscrw" #X1D500 "𝔀")
    ("mathalpha" "\\mbfscrx" #X1D501 "𝔁")
    ("mathalpha" "\\mbfscry" #X1D502 "𝔂")
    ("mathalpha" "\\mbfscrz" #X1D503 "𝔃")
    ("mathalpha" "\\mbfsigma" #X1D6D4 "𝛔")
    ("mathalpha" "\\mbft" #X1D42D "𝐭")
    ("mathalpha" "\\mbftau" #X1D6D5 "𝛕")
    ("mathalpha" "\\mbftheta" #X1D6C9 "𝛉")
    ("mathalpha" "\\mbfu" #X1D42E "𝐮")
    ("mathalpha" "\\mbfupsilon" #X1D6D6 "𝛖")
    ("mathalpha" "\\mbfv" #X1D42F "𝐯")
    ("mathalpha" "\\mbfvarTheta" #X1D6B9 "𝚹")
    ("mathalpha" "\\mbfvarepsilon" #X1D6DC "𝛜")
    ("mathalpha" "\\mbfvarkappa" #X1D6DE "𝛞")
    ("mathalpha" "\\mbfvarphi" #X1D6D7 "𝛗")
    ("mathalpha" "\\mbfvarpi" #X1D6E1 "𝛡")
    ("mathalpha" "\\mbfvarrho" #X1D6E0 "𝛠")
    ("mathalpha" "\\mbfvarsigma" #X1D6D3 "𝛓")
    ("mathalpha" "\\mbfvartheta" #X1D6DD "𝛝")
    ("mathalpha" "\\mbfw" #X1D430 "𝐰")
    ("mathalpha" "\\mbfx" #X1D431 "𝐱")
    ("mathalpha" "\\mbfxi" #X1D6CF "𝛏")
    ("mathalpha" "\\mbfy" #X1D432 "𝐲")
    ("mathalpha" "\\mbfz" #X1D433 "𝐳")
    ("mathalpha" "\\mbfzeta" #X1D6C7 "𝛇")
    ("mathalpha" "\\mfrakA" #X1D504 "𝔄")
    ("mathalpha" "\\mfrakB" #X1D505 "𝔅")
    ("mathalpha" "\\mfrakC" #X0212D "ℭ")
    ("mathalpha" "\\mfrakD" #X1D507 "𝔇")
    ("mathalpha" "\\mfrakE" #X1D508 "𝔈")
    ("mathalpha" "\\mfrakF" #X1D509 "𝔉")
    ("mathalpha" "\\mfrakG" #X1D50A "𝔊")
    ("mathalpha" "\\mfrakH" #X0210C "ℌ")
    ("mathalpha" "\\mfrakJ" #X1D50D "𝔍")
    ("mathalpha" "\\mfrakK" #X1D50E "𝔎")
    ("mathalpha" "\\mfrakL" #X1D50F "𝔏")
    ("mathalpha" "\\mfrakM" #X1D510 "𝔐")
    ("mathalpha" "\\mfrakN" #X1D511 "𝔑")
    ("mathalpha" "\\mfrakO" #X1D512 "𝔒")
    ("mathalpha" "\\mfrakP" #X1D513 "𝔓")
    ("mathalpha" "\\mfrakQ" #X1D514 "𝔔")
    ("mathalpha" "\\mfrakS" #X1D516 "𝔖")
    ("mathalpha" "\\mfrakT" #X1D517 "𝔗")
    ("mathalpha" "\\mfrakU" #X1D518 "𝔘")
    ("mathalpha" "\\mfrakV" #X1D519 "𝔙")
    ("mathalpha" "\\mfrakW" #X1D51A "𝔚")
    ("mathalpha" "\\mfrakX" #X1D51B "𝔛")
    ("mathalpha" "\\mfrakY" #X1D51C "𝔜")
    ("mathalpha" "\\mfrakZ" #X02128 "ℨ")
    ("mathalpha" "\\mfraka" #X1D51E "𝔞")
    ("mathalpha" "\\mfrakb" #X1D51F "𝔟")
    ("mathalpha" "\\mfrakc" #X1D520 "𝔠")
    ("mathalpha" "\\mfrakd" #X1D521 "𝔡")
    ("mathalpha" "\\mfrake" #X1D522 "𝔢")
    ("mathalpha" "\\mfrakf" #X1D523 "𝔣")
    ("mathalpha" "\\mfrakg" #X1D524 "𝔤")
    ("mathalpha" "\\mfrakh" #X1D525 "𝔥")
    ("mathalpha" "\\mfraki" #X1D526 "𝔦")
    ("mathalpha" "\\mfrakj" #X1D527 "𝔧")
    ("mathalpha" "\\mfrakk" #X1D528 "𝔨")
    ("mathalpha" "\\mfrakl" #X1D529 "𝔩")
    ("mathalpha" "\\mfrakm" #X1D52A "𝔪")
    ("mathalpha" "\\mfrakn" #X1D52B "𝔫")
    ("mathalpha" "\\mfrako" #X1D52C "𝔬")
    ("mathalpha" "\\mfrakp" #X1D52D "𝔭")
    ("mathalpha" "\\mfrakq" #X1D52E "𝔮")
    ("mathalpha" "\\mfrakr" #X1D52F "𝔯")
    ("mathalpha" "\\mfraks" #X1D530 "𝔰")
    ("mathalpha" "\\mfrakt" #X1D531 "𝔱")
    ("mathalpha" "\\mfraku" #X1D532 "𝔲")
    ("mathalpha" "\\mfrakv" #X1D533 "𝔳")
    ("mathalpha" "\\mfrakw" #X1D534 "𝔴")
    ("mathalpha" "\\mfrakx" #X1D535 "𝔵")
    ("mathalpha" "\\mfraky" #X1D536 "𝔶")
    ("mathalpha" "\\mfrakz" #X1D537 "𝔷")
    ("mathalpha" "\\mitA" #X1D434 "𝐴")
    ("mathalpha" "\\mitAlpha" #X1D6E2 "𝛢")
    ("mathalpha" "\\mitB" #X1D435 "𝐵")
    ("mathalpha" "\\mitBeta" #X1D6E3 "𝛣")
    ("mathalpha" "\\mitC" #X1D436 "𝐶")
    ("mathalpha" "\\mitChi" #X1D6F8 "𝛸")
    ("mathalpha" "\\mitD" #X1D437 "𝐷")
    ("mathalpha" "\\mitDelta" #X1D6E5 "𝛥")
    ("mathalpha" "\\mitE" #X1D438 "𝐸")
    ("mathalpha" "\\mitEpsilon" #X1D6E6 "𝛦")
    ("mathalpha" "\\mitEta" #X1D6E8 "𝛨")
    ("mathalpha" "\\mitF" #X1D439 "𝐹")
    ("mathalpha" "\\mitG" #X1D43A "𝐺")
    ("mathalpha" "\\mitGamma" #X1D6E4 "𝛤")
    ("mathalpha" "\\mitH" #X1D43B "𝐻")
    ("mathalpha" "\\mitI" #X1D43C "𝐼")
    ("mathalpha" "\\mitIota" #X1D6EA "𝛪")
    ("mathalpha" "\\mitJ" #X1D43D "𝐽")
    ("mathalpha" "\\mitK" #X1D43E "𝐾")
    ("mathalpha" "\\mitKappa" #X1D6EB "𝛫")
    ("mathalpha" "\\mitL" #X1D43F "𝐿")
    ("mathalpha" "\\mitLambda" #X1D6EC "𝛬")
    ("mathalpha" "\\mitM" #X1D440 "𝑀")
    ("mathalpha" "\\mitMu" #X1D6ED "𝛭")
    ("mathalpha" "\\mitN" #X1D441 "𝑁")
    ("mathalpha" "\\mitNu" #X1D6EE "𝛮")
    ("mathalpha" "\\mitO" #X1D442 "𝑂")
    ("mathalpha" "\\mitOmega" #X1D6FA "𝛺")
    ("mathalpha" "\\mitOmicron" #X1D6F0 "𝛰")
    ("mathalpha" "\\mitP" #X1D443 "𝑃")
    ("mathalpha" "\\mitPhi" #X1D6F7 "𝛷")
    ("mathalpha" "\\mitPi" #X1D6F1 "𝛱")
    ("mathalpha" "\\mitPsi" #X1D6F9 "𝛹")
    ("mathalpha" "\\mitQ" #X1D444 "𝑄")
    ("mathalpha" "\\mitR" #X1D445 "𝑅")
    ("mathalpha" "\\mitRho" #X1D6F2 "𝛲")
    ("mathalpha" "\\mitS" #X1D446 "𝑆")
    ("mathalpha" "\\mitSigma" #X1D6F4 "𝛴")
    ("mathalpha" "\\mitT" #X1D447 "𝑇")
    ("mathalpha" "\\mitTau" #X1D6F5 "𝛵")
    ("mathalpha" "\\mitTheta" #X1D6E9 "𝛩")
    ("mathalpha" "\\mitU" #X1D448 "𝑈")
    ("mathalpha" "\\mitUpsilon" #X1D6F6 "𝛶")
    ("mathalpha" "\\mitV" #X1D449 "𝑉")
    ("mathalpha" "\\mitW" #X1D44A "𝑊")
    ("mathalpha" "\\mitX" #X1D44B "𝑋")
    ("mathalpha" "\\mitXi" #X1D6EF "𝛯")
    ("mathalpha" "\\mitY" #X1D44C "𝑌")
    ("mathalpha" "\\mitZ" #X1D44D "𝑍")
    ("mathalpha" "\\mitZeta" #X1D6E7 "𝛧")
    ("mathalpha" "\\mita" #X1D44E "𝑎")
    ("mathalpha" "\\mitalpha" #X1D6FC "𝛼")
    ("mathalpha" "\\mitb" #X1D44F "𝑏")
    ("mathalpha" "\\mitbeta" #X1D6FD "𝛽")
    ("mathalpha" "\\mitc" #X1D450 "𝑐")
    ("mathalpha" "\\mitchi" #X1D712 "𝜒")
    ("mathalpha" "\\mitd" #X1D451 "𝑑")
    ("mathalpha" "\\mitdelta" #X1D6FF "𝛿")
    ("mathalpha" "\\mite" #X1D452 "𝑒")
    ("mathalpha" "\\mitepsilon" #X1D700 "𝜀")
    ("mathalpha" "\\miteta" #X1D702 "𝜂")
    ("mathalpha" "\\mitf" #X1D453 "𝑓")
    ("mathalpha" "\\mitg" #X1D454 "𝑔")
    ("mathalpha" "\\mitgamma" #X1D6FE "𝛾")
    ("mathalpha" "\\miti" #X1D456 "𝑖")
    ("mathalpha" "\\mitiota" #X1D704 "𝜄")
    ("mathalpha" "\\mitj" #X1D457 "𝑗")
    ("mathalpha" "\\mitk" #X1D458 "𝑘")
    ("mathalpha" "\\mitkappa" #X1D705 "𝜅")
    ("mathalpha" "\\mitl" #X1D459 "𝑙")
    ("mathalpha" "\\mitlambda" #X1D706 "𝜆")
    ("mathalpha" "\\mitm" #X1D45A "𝑚")
    ("mathalpha" "\\mitmu" #X1D707 "𝜇")
    ("mathalpha" "\\mitn" #X1D45B "𝑛")
    ("mathalpha" "\\mitnu" #X1D708 "𝜈")
    ("mathalpha" "\\mito" #X1D45C "𝑜")
    ("mathalpha" "\\mitomega" #X1D714 "𝜔")
    ("mathalpha" "\\mitomicron" #X1D70A "𝜊")
    ("mathalpha" "\\mitp" #X1D45D "𝑝")
    ("mathalpha" "\\mitphi" #X1D711 "𝜑")
    ("mathalpha" "\\mitpi" #X1D70B "𝜋")
    ("mathalpha" "\\mitpsi" #X1D713 "𝜓")
    ("mathalpha" "\\mitq" #X1D45E "𝑞")
    ("mathalpha" "\\mitr" #X1D45F "𝑟")
    ("mathalpha" "\\mitrho" #X1D70C "𝜌")
    ("mathalpha" "\\mits" #X1D460 "𝑠")
    ("mathalpha" "\\mitsansA" #X1D608 "𝘈")
    ("mathalpha" "\\mitsansB" #X1D609 "𝘉")
    ("mathalpha" "\\mitsansC" #X1D60A "𝘊")
    ("mathalpha" "\\mitsansD" #X1D60B "𝘋")
    ("mathalpha" "\\mitsansE" #X1D60C "𝘌")
    ("mathalpha" "\\mitsansF" #X1D60D "𝘍")
    ("mathalpha" "\\mitsansG" #X1D60E "𝘎")
    ("mathalpha" "\\mitsansH" #X1D60F "𝘏")
    ("mathalpha" "\\mitsansI" #X1D610 "𝘐")
    ("mathalpha" "\\mitsansJ" #X1D611 "𝘑")
    ("mathalpha" "\\mitsansK" #X1D612 "𝘒")
    ("mathalpha" "\\mitsansL" #X1D613 "𝘓")
    ("mathalpha" "\\mitsansM" #X1D614 "𝘔")
    ("mathalpha" "\\mitsansN" #X1D615 "𝘕")
    ("mathalpha" "\\mitsansO" #X1D616 "𝘖")
    ("mathalpha" "\\mitsansP" #X1D617 "𝘗")
    ("mathalpha" "\\mitsansQ" #X1D618 "𝘘")
    ("mathalpha" "\\mitsansR" #X1D619 "𝘙")
    ("mathalpha" "\\mitsansS" #X1D61A "𝘚")
    ("mathalpha" "\\mitsansT" #X1D61B "𝘛")
    ("mathalpha" "\\mitsansU" #X1D61C "𝘜")
    ("mathalpha" "\\mitsansV" #X1D61D "𝘝")
    ("mathalpha" "\\mitsansW" #X1D61E "𝘞")
    ("mathalpha" "\\mitsansX" #X1D61F "𝘟")
    ("mathalpha" "\\mitsansY" #X1D620 "𝘠")
    ("mathalpha" "\\mitsansZ" #X1D621 "𝘡")
    ("mathalpha" "\\mitsansa" #X1D622 "𝘢")
    ("mathalpha" "\\mitsansb" #X1D623 "𝘣")
    ("mathalpha" "\\mitsansc" #X1D624 "𝘤")
    ("mathalpha" "\\mitsansd" #X1D625 "𝘥")
    ("mathalpha" "\\mitsanse" #X1D626 "𝘦")
    ("mathalpha" "\\mitsansf" #X1D627 "𝘧")
    ("mathalpha" "\\mitsansg" #X1D628 "𝘨")
    ("mathalpha" "\\mitsansh" #X1D629 "𝘩")
    ("mathalpha" "\\mitsansi" #X1D62A "𝘪")
    ("mathalpha" "\\mitsansj" #X1D62B "𝘫")
    ("mathalpha" "\\mitsansk" #X1D62C "𝘬")
    ("mathalpha" "\\mitsansl" #X1D62D "𝘭")
    ("mathalpha" "\\mitsansm" #X1D62E "𝘮")
    ("mathalpha" "\\mitsansn" #X1D62F "𝘯")
    ("mathalpha" "\\mitsanso" #X1D630 "𝘰")
    ("mathalpha" "\\mitsansp" #X1D631 "𝘱")
    ("mathalpha" "\\mitsansq" #X1D632 "𝘲")
    ("mathalpha" "\\mitsansr" #X1D633 "𝘳")
    ("mathalpha" "\\mitsanss" #X1D634 "𝘴")
    ("mathalpha" "\\mitsanst" #X1D635 "𝘵")
    ("mathalpha" "\\mitsansu" #X1D636 "𝘶")
    ("mathalpha" "\\mitsansv" #X1D637 "𝘷")
    ("mathalpha" "\\mitsansw" #X1D638 "𝘸")
    ("mathalpha" "\\mitsansx" #X1D639 "𝘹")
    ("mathalpha" "\\mitsansy" #X1D63A "𝘺")
    ("mathalpha" "\\mitsansz" #X1D63B "𝘻")
    ("mathalpha" "\\mitsigma" #X1D70E "𝜎")
    ("mathalpha" "\\mitt" #X1D461 "𝑡")
    ("mathalpha" "\\mittau" #X1D70F "𝜏")
    ("mathalpha" "\\mittheta" #X1D703 "𝜃")
    ("mathalpha" "\\mitu" #X1D462 "𝑢")
    ("mathalpha" "\\mitupsilon" #X1D710 "𝜐")
    ("mathalpha" "\\mitv" #X1D463 "𝑣")
    ("mathalpha" "\\mitvarTheta" #X1D6F3 "𝛳")
    ("mathalpha" "\\mitvarepsilon" #X1D716 "𝜖")
    ("mathalpha" "\\mitvarkappa" #X1D718 "𝜘")
    ("mathalpha" "\\mitvarphi" #X1D719 "𝜙")
    ("mathalpha" "\\mitvarpi" #X1D71B "𝜛")
    ("mathalpha" "\\mitvarrho" #X1D71A "𝜚")
    ("mathalpha" "\\mitvarsigma" #X1D70D "𝜍")
    ("mathalpha" "\\mitvartheta" #X1D717 "𝜗")
    ("mathalpha" "\\mitw" #X1D464 "𝑤")
    ("mathalpha" "\\mitx" #X1D465 "𝑥")
    ("mathalpha" "\\mitxi" #X1D709 "𝜉")
    ("mathalpha" "\\mity" #X1D466 "𝑦")
    ("mathalpha" "\\mitz" #X1D467 "𝑧")
    ("mathalpha" "\\mitzeta" #X1D701 "𝜁")
    ("mathalpha" "\\msansA" #X1D5A0 "𝖠")
    ("mathalpha" "\\msansB" #X1D5A1 "𝖡")
    ("mathalpha" "\\msansC" #X1D5A2 "𝖢")
    ("mathalpha" "\\msansD" #X1D5A3 "𝖣")
    ("mathalpha" "\\msansE" #X1D5A4 "𝖤")
    ("mathalpha" "\\msansF" #X1D5A5 "𝖥")
    ("mathalpha" "\\msansG" #X1D5A6 "𝖦")
    ("mathalpha" "\\msansH" #X1D5A7 "𝖧")
    ("mathalpha" "\\msansI" #X1D5A8 "𝖨")
    ("mathalpha" "\\msansJ" #X1D5A9 "𝖩")
    ("mathalpha" "\\msansK" #X1D5AA "𝖪")
    ("mathalpha" "\\msansL" #X1D5AB "𝖫")
    ("mathalpha" "\\msansM" #X1D5AC "𝖬")
    ("mathalpha" "\\msansN" #X1D5AD "𝖭")
    ("mathalpha" "\\msansO" #X1D5AE "𝖮")
    ("mathalpha" "\\msansP" #X1D5AF "𝖯")
    ("mathalpha" "\\msansQ" #X1D5B0 "𝖰")
    ("mathalpha" "\\msansR" #X1D5B1 "𝖱")
    ("mathalpha" "\\msansS" #X1D5B2 "𝖲")
    ("mathalpha" "\\msansT" #X1D5B3 "𝖳")
    ("mathalpha" "\\msansU" #X1D5B4 "𝖴")
    ("mathalpha" "\\msansV" #X1D5B5 "𝖵")
    ("mathalpha" "\\msansW" #X1D5B6 "𝖶")
    ("mathalpha" "\\msansX" #X1D5B7 "𝖷")
    ("mathalpha" "\\msansY" #X1D5B8 "𝖸")
    ("mathalpha" "\\msansZ" #X1D5B9 "𝖹")
    ("mathalpha" "\\msansa" #X1D5BA "𝖺")
    ("mathalpha" "\\msansb" #X1D5BB "𝖻")
    ("mathalpha" "\\msansc" #X1D5BC "𝖼")
    ("mathalpha" "\\msansd" #X1D5BD "𝖽")
    ("mathalpha" "\\msanse" #X1D5BE "𝖾")
    ("mathalpha" "\\msansf" #X1D5BF "𝖿")
    ("mathalpha" "\\msansg" #X1D5C0 "𝗀")
    ("mathalpha" "\\msansh" #X1D5C1 "𝗁")
    ("mathalpha" "\\msansi" #X1D5C2 "𝗂")
    ("mathalpha" "\\msansj" #X1D5C3 "𝗃")
    ("mathalpha" "\\msansk" #X1D5C4 "𝗄")
    ("mathalpha" "\\msansl" #X1D5C5 "𝗅")
    ("mathalpha" "\\msansm" #X1D5C6 "𝗆")
    ("mathalpha" "\\msansn" #X1D5C7 "𝗇")
    ("mathalpha" "\\msanso" #X1D5C8 "𝗈")
    ("mathalpha" "\\msansp" #X1D5C9 "𝗉")
    ("mathalpha" "\\msansq" #X1D5CA "𝗊")
    ("mathalpha" "\\msansr" #X1D5CB "𝗋")
    ("mathalpha" "\\msanss" #X1D5CC "𝗌")
    ("mathalpha" "\\msanst" #X1D5CD "𝗍")
    ("mathalpha" "\\msansu" #X1D5CE "𝗎")
    ("mathalpha" "\\msansv" #X1D5CF "𝗏")
    ("mathalpha" "\\msansw" #X1D5D0 "𝗐")
    ("mathalpha" "\\msansx" #X1D5D1 "𝗑")
    ("mathalpha" "\\msansy" #X1D5D2 "𝗒")
    ("mathalpha" "\\msansz" #X1D5D3 "𝗓")
    ("mathalpha" "\\mscrA" #X1D49C "𝒜")
    ("mathalpha" "\\mscrB" #X0212C "ℬ")
    ("mathalpha" "\\mscrC" #X1D49E "𝒞")
    ("mathalpha" "\\mscrD" #X1D49F "𝒟")
    ("mathalpha" "\\mscrE" #X02130 "ℰ")
    ("mathalpha" "\\mscrF" #X02131 "ℱ")
    ("mathalpha" "\\mscrG" #X1D4A2 "𝒢")
    ("mathalpha" "\\mscrH" #X0210B "ℋ")
    ("mathalpha" "\\mscrI" #X02110 "ℐ")
    ("mathalpha" "\\mscrJ" #X1D4A5 "𝒥")
    ("mathalpha" "\\mscrK" #X1D4A6 "𝒦")
    ("mathalpha" "\\mscrL" #X02112 "ℒ")
    ("mathalpha" "\\mscrM" #X02133 "ℳ")
    ("mathalpha" "\\mscrN" #X1D4A9 "𝒩")
    ("mathalpha" "\\mscrO" #X1D4AA "𝒪")
    ("mathalpha" "\\mscrP" #X1D4AB "𝒫")
    ("mathalpha" "\\mscrQ" #X1D4AC "𝒬")
    ("mathalpha" "\\mscrR" #X0211B "ℛ")
    ("mathalpha" "\\mscrS" #X1D4AE "𝒮")
    ("mathalpha" "\\mscrT" #X1D4AF "𝒯")
    ("mathalpha" "\\mscrU" #X1D4B0 "𝒰")
    ("mathalpha" "\\mscrV" #X1D4B1 "𝒱")
    ("mathalpha" "\\mscrW" #X1D4B2 "𝒲")
    ("mathalpha" "\\mscrX" #X1D4B3 "𝒳")
    ("mathalpha" "\\mscrY" #X1D4B4 "𝒴")
    ("mathalpha" "\\mscrZ" #X1D4B5 "𝒵")
    ("mathalpha" "\\mscra" #X1D4B6 "𝒶")
    ("mathalpha" "\\mscrb" #X1D4B7 "𝒷")
    ("mathalpha" "\\mscrc" #X1D4B8 "𝒸")
    ("mathalpha" "\\mscrd" #X1D4B9 "𝒹")
    ("mathalpha" "\\mscre" #X0212F "ℯ")
    ("mathalpha" "\\mscrf" #X1D4BB "𝒻")
    ("mathalpha" "\\mscrg" #X0210A "ℊ")
    ("mathalpha" "\\mscrh" #X1D4BD "𝒽")
    ("mathalpha" "\\mscri" #X1D4BE "𝒾")
    ("mathalpha" "\\mscrj" #X1D4BF "𝒿")
    ("mathalpha" "\\mscrk" #X1D4C0 "𝓀")
    ("mathalpha" "\\mscrl" #X1D4C1 "𝓁")
    ("mathalpha" "\\mscrm" #X1D4C2 "𝓂")
    ("mathalpha" "\\mscrn" #X1D4C3 "𝓃")
    ("mathalpha" "\\mscro" #X02134 "ℴ")
    ("mathalpha" "\\mscrp" #X1D4C5 "𝓅")
    ("mathalpha" "\\mscrq" #X1D4C6 "𝓆")
    ("mathalpha" "\\mscrr" #X1D4C7 "𝓇")
    ("mathalpha" "\\mscrs" #X1D4C8 "𝓈")
    ("mathalpha" "\\mscrt" #X1D4C9 "𝓉")
    ("mathalpha" "\\mscru" #X1D4CA "𝓊")
    ("mathalpha" "\\mscrv" #X1D4CB "𝓋")
    ("mathalpha" "\\mscrw" #X1D4CC "𝓌")
    ("mathalpha" "\\mscrx" #X1D4CD "𝓍")
    ("mathalpha" "\\mscry" #X1D4CE "𝓎")
    ("mathalpha" "\\mscrz" #X1D4CF "𝓏")
    ("mathalpha" "\\mttA" #X1D670 "𝙰")
    ("mathalpha" "\\mttB" #X1D671 "𝙱")
    ("mathalpha" "\\mttC" #X1D672 "𝙲")
    ("mathalpha" "\\mttD" #X1D673 "𝙳")
    ("mathalpha" "\\mttE" #X1D674 "𝙴")
    ("mathalpha" "\\mttF" #X1D675 "𝙵")
    ("mathalpha" "\\mttG" #X1D676 "𝙶")
    ("mathalpha" "\\mttH" #X1D677 "𝙷")
    ("mathalpha" "\\mttI" #X1D678 "𝙸")
    ("mathalpha" "\\mttJ" #X1D679 "𝙹")
    ("mathalpha" "\\mttK" #X1D67A "𝙺")
    ("mathalpha" "\\mttL" #X1D67B "𝙻")
    ("mathalpha" "\\mttM" #X1D67C "𝙼")
    ("mathalpha" "\\mttN" #X1D67D "𝙽")
    ("mathalpha" "\\mttO" #X1D67E "𝙾")
    ("mathalpha" "\\mttP" #X1D67F "𝙿")
    ("mathalpha" "\\mttQ" #X1D680 "𝚀")
    ("mathalpha" "\\mttR" #X1D681 "𝚁")
    ("mathalpha" "\\mttS" #X1D682 "𝚂")
    ("mathalpha" "\\mttT" #X1D683 "𝚃")
    ("mathalpha" "\\mttU" #X1D684 "𝚄")
    ("mathalpha" "\\mttV" #X1D685 "𝚅")
    ("mathalpha" "\\mttW" #X1D686 "𝚆")
    ("mathalpha" "\\mttX" #X1D687 "𝚇")
    ("mathalpha" "\\mttY" #X1D688 "𝚈")
    ("mathalpha" "\\mttZ" #X1D689 "𝚉")
    ("mathalpha" "\\mtta" #X1D68A "𝚊")
    ("mathalpha" "\\mttb" #X1D68B "𝚋")
    ("mathalpha" "\\mttc" #X1D68C "𝚌")
    ("mathalpha" "\\mttd" #X1D68D "𝚍")
    ("mathalpha" "\\mtte" #X1D68E "𝚎")
    ("mathalpha" "\\mttf" #X1D68F "𝚏")
    ("mathalpha" "\\mttg" #X1D690 "𝚐")
    ("mathalpha" "\\mtth" #X1D691 "𝚑")
    ("mathalpha" "\\mtti" #X1D692 "𝚒")
    ("mathalpha" "\\mttj" #X1D693 "𝚓")
    ("mathalpha" "\\mttk" #X1D694 "𝚔")
    ("mathalpha" "\\mttl" #X1D695 "𝚕")
    ("mathalpha" "\\mttm" #X1D696 "𝚖")
    ("mathalpha" "\\mttn" #X1D697 "𝚗")
    ("mathalpha" "\\mtto" #X1D698 "𝚘")
    ("mathalpha" "\\mttp" #X1D699 "𝚙")
    ("mathalpha" "\\mttq" #X1D69A "𝚚")
    ("mathalpha" "\\mttr" #X1D69B "𝚛")
    ("mathalpha" "\\mtts" #X1D69C "𝚜")
    ("mathalpha" "\\mttt" #X1D69D "𝚝")
    ("mathalpha" "\\mttu" #X1D69E "𝚞")
    ("mathalpha" "\\mttv" #X1D69F "𝚟")
    ("mathalpha" "\\mttw" #X1D6A0 "𝚠")
    ("mathalpha" "\\mttx" #X1D6A1 "𝚡")
    ("mathalpha" "\\mtty" #X1D6A2 "𝚢")
    ("mathalpha" "\\mttz" #X1D6A3 "𝚣")
    ("mathalpha" "\\period" #X0002E ".")
    ("mathalpha" "\\turnediota" #X02129 "℩")
    ("mathalpha" "\\upAlpha" #X00391 "Α")
    ("mathalpha" "\\upBeta" #X00392 "Β")
    ("mathalpha" "\\upChi" #X003A7 "Χ")
    ("mathalpha" "\\upDelta" #X00394 "Δ")
    ("mathalpha" "\\upDigamma" #X003DC "Ϝ")
    ("mathalpha" "\\upEpsilon" #X00395 "Ε")
    ("mathalpha" "\\upEta" #X00397 "Η")
    ("mathalpha" "\\upGamma" #X00393 "Γ")
    ("mathalpha" "\\upIota" #X00399 "Ι")
    ("mathalpha" "\\upKappa" #X0039A "Κ")
    ("mathalpha" "\\upKoppa" #X003DE "Ϟ")
    ("mathalpha" "\\upLambda" #X0039B "Λ")
    ("mathalpha" "\\upMu" #X0039C "Μ")
    ("mathalpha" "\\upNu" #X0039D "Ν")
    ("mathalpha" "\\upOmega" #X003A9 "Ω")
    ("mathalpha" "\\upOmicron" #X0039F "Ο")
    ("mathalpha" "\\upPhi" #X003A6 "Φ")
    ("mathalpha" "\\upPi" #X003A0 "Π")
    ("mathalpha" "\\upPsi" #X003A8 "Ψ")
    ("mathalpha" "\\upRho" #X003A1 "Ρ")
    ("mathalpha" "\\upSampi" #X003E0 "Ϡ")
    ("mathalpha" "\\upSigma" #X003A3 "Σ")
    ("mathalpha" "\\upStigma" #X003DA "Ϛ")
    ("mathalpha" "\\upTau" #X003A4 "Τ")
    ("mathalpha" "\\upTheta" #X00398 "Θ")
    ("mathalpha" "\\upUpsilon" #X003A5 "Υ")
    ("mathalpha" "\\upUpsilon" #X003D2 "ϒ")
    ("mathalpha" "\\upXi" #X0039E "Ξ")
    ("mathalpha" "\\upZeta" #X00396 "Ζ")
    ("mathalpha" "\\upalpha" #X003B1 "α")
    ("mathalpha" "\\upbeta" #X003B2 "β")
    ("mathalpha" "\\upchi" #X003C7 "χ")
    ("mathalpha" "\\updelta" #X003B4 "δ")
    ("mathalpha" "\\updigamma" #X003DD "ϝ")
    ("mathalpha" "\\upepsilon" #X003B5 "ε")
    ("mathalpha" "\\upeta" #X003B7 "η")
    ("mathalpha" "\\upgamma" #X003B3 "γ")
    ("mathalpha" "\\upiota" #X003B9 "ι")
    ("mathalpha" "\\upkappa" #X003BA "κ")
    ("mathalpha" "\\upkoppa" #X003DF "ϟ")
    ("mathalpha" "\\uplambda" #X003BB "λ")
    ("mathalpha" "\\upmu" #X003BC "μ")
    ("mathalpha" "\\upnu" #X003BD "ν")
    ("mathalpha" "\\upomega" #X003C9 "ω")
    ("mathalpha" "\\upomicron" #X003BF "ο")
    ("mathalpha" "\\upphi" #X003D5 "ϕ")
    ("mathalpha" "\\uppi" #X003C0 "π")
    ("mathalpha" "\\uppsi" #X003C8 "ψ")
    ("mathalpha" "\\uprho" #X003C1 "ρ")
    ("mathalpha" "\\upsampi" #X003E1 "ϡ")
    ("mathalpha" "\\upsigma" #X003C3 "σ")
    ("mathalpha" "\\upstigma" #X003DB "ϛ")
    ("mathalpha" "\\uptau" #X003C4 "τ")
    ("mathalpha" "\\uptheta" #X003B8 "θ")
    ("mathalpha" "\\upupsilon" #X003C5 "υ")
    ("mathalpha" "\\upvarTheta" #X003F4 "ϴ")
    ("mathalpha" "\\upvarbeta" #X003D0 "ϐ")
    ("mathalpha" "\\upvarepsilon" #X003F5 "ϵ")
    ("mathalpha" "\\upvarkappa" #X003F0 "ϰ")
    ("mathalpha" "\\upvarphi" #X003C6 "φ")
    ("mathalpha" "\\upvarpi" #X003D6 "ϖ")
    ("mathalpha" "\\upvarrho" #X003F1 "ϱ")
    ("mathalpha" "\\upvarsigma" #X003C2 "ς")
    ("mathalpha" "\\upvartheta" #X003D1 "ϑ")
    ("mathalpha" "\\upxi" #X003BE "ξ")
    ("mathalpha" "\\upzeta" #X003B6 "ζ")
    ("mathalpha" "\\wp" #X02118 "℘")
    ("mathbin" "\\Cap" #X022D2 "⋒")
    ("mathbin" "\\Cup" #X022D3 "⋓")
    ("mathbin" "\\Otimes" #X02A37 "⨷")
    ("mathbin" "\\Sqcap" #X02A4E "⩎")
    ("mathbin" "\\Sqcup" #X02A4F "⩏")
    ("mathbin" "\\Vee" #X02A54 "⩔")
    ("mathbin" "\\Wedge" #X02A53 "⩓")
    ("mathbin" "\\amalg" #X02A3F "⨿")
    ("mathbin" "\\ast" #X02217 "∗")
    ("mathbin" "\\barcap" #X02A43 "⩃")
    ("mathbin" "\\barcup" #X02A42 "⩂")
    ("mathbin" "\\barvee" #X022BD "⊽")
    ("mathbin" "\\barwedge" #X022BC "⊼")
    ("mathbin" "\\bigslopedvee" #X02A57 "⩗")
    ("mathbin" "\\bigslopedwedge" #X02A58 "⩘")
    ("mathbin" "\\bigtriangledown" #X025BD "▽")
    ("mathbin" "\\bigtriangleup" #X025B3 "△")
    ("mathbin" "\\blackhourglass" #X029D7 "⧗")
    ("mathbin" "\\blacktriangle" #X025B4 "▴")
    ("mathbin" "\\blacktriangledown" #X025BE "▾")
    ("mathbin" "\\blacktriangleleft" #X025C0 "◀")
    ("mathbin" "\\blacktriangleright" #X025B6 "▶")
    ("mathbin" "\\boxast" #X029C6 "⧆")
    ("mathbin" "\\boxbar" #X025EB "◫")
    ("mathbin" "\\boxbox" #X029C8 "⧈")
    ("mathbin" "\\boxbslash" #X029C5 "⧅")
    ("mathbin" "\\boxcircle" #X029C7 "⧇")
    ("mathbin" "\\boxdiag" #X029C4 "⧄")
    ("mathbin" "\\boxdot" #X022A1 "⊡")
    ("mathbin" "\\boxminus" #X0229F "⊟")
    ("mathbin" "\\boxplus" #X0229E "⊞")
    ("mathbin" "\\boxtimes" #X022A0 "⊠")
    ("mathbin" "\\btimes" #X02A32 "⨲")
    ("mathbin" "\\cap" #X02229 "∩")
    ("mathbin" "\\capbarcup" #X02A49 "⩉")
    ("mathbin" "\\capdot" #X02A40 "⩀")
    ("mathbin" "\\capovercup" #X02A47 "⩇")
    ("mathbin" "\\capwedge" #X02A44 "⩄")
    ("mathbin" "\\cdot" #X022C5 "⋅")
    ("mathbin" "\\cdotp" #X000B7 "·")
    ("mathbin" "\\circledast" #X0229B "⊛")
    ("mathbin" "\\circledcirc" #X0229A "⊚")
    ("mathbin" "\\circleddash" #X0229D "⊝")
    ("mathbin" "\\circledequal" #X0229C "⊜")
    ("mathbin" "\\circledparallel" #X029B7 "⦷")
    ("mathbin" "\\circledvert" #X029B6 "⦶")
    ("mathbin" "\\circlehbar" #X029B5 "⦵")
    ("mathbin" "\\closedvarcap" #X02A4D "⩍")
    ("mathbin" "\\closedvarcup" #X02A4C "⩌")
    ("mathbin" "\\closedvarcupsmashprod" #X02A50 "⩐")
    ("mathbin" "\\commaminus" #X02A29 "⨩")
    ("mathbin" "\\concavediamond" #X027E1 "⟡")
    ("mathbin" "\\concavediamondtickleft" #X027E2 "⟢")
    ("mathbin" "\\concavediamondtickright" #X027E3 "⟣")
    ("mathbin" "\\cup" #X0222A "∪")
    ("mathbin" "\\cupbarcap" #X02A48 "⩈")
    ("mathbin" "\\cupdot" #X0228D "⊍")
    ("mathbin" "\\cupleftarrow" #X0228C "⊌")
    ("mathbin" "\\cupovercap" #X02A46 "⩆")
    ("mathbin" "\\cupvee" #X02A45 "⩅")
    ("mathbin" "\\curlyvee" #X022CE "⋎")
    ("mathbin" "\\curlywedge" #X022CF "⋏")
    ("mathbin" "\\dagger" #X02020 "†")
    ("mathbin" "\\ddagger" #X02021 "‡")
    ("mathbin" "\\div" #X000F7 "÷")
    ("mathbin" "\\divideontimes" #X022C7 "⋇")
    ("mathbin" "\\divslash" #X02215 "∕")
    ("mathbin" "\\dotminus" #X02238 "∸")
    ("mathbin" "\\dotplus" #X02214 "∔")
    ("mathbin" "\\dottimes" #X02A30 "⨰")
    ("mathbin" "\\doublebarvee" #X02A62 "⩢")
    ("mathbin" "\\doublebarwedge" #X02A5E "⩞")
    ("mathbin" "\\doubleplus" #X029FA "⧺")
    ("mathbin" "\\dsol" #X029F6 "⧶")
    ("mathbin" "\\dsub" #X02A64 "⩤")
    ("mathbin" "\\eqqplus" #X02A71 "⩱")
    ("mathbin" "\\fcmp" #X02A3E "⨾")
    ("mathbin" "\\fracslash" #X02044 "⁄")
    ("mathbin" "\\hourglass" #X029D6 "⧖")
    ("mathbin" "\\intercal" #X022BA "⊺")
    ("mathbin" "\\interleave" #X02AF4 "⫴")
    ("mathbin" "\\intprod" #X02A3C "⨼")
    ("mathbin" "\\intprodr" #X02A3D "⨽")
    ("mathbin" "\\invlazys" #X0223E "∾")
    ("mathbin" "\\leftthreetimes" #X022CB "⋋")
    ("mathbin" "\\lozengeminus" #X027E0 "⟠")
    ("mathbin" "\\ltimes" #X022C9 "⋉")
    ("mathbin" "\\mdlgblklozenge" #X029EB "⧫")
    ("mathbin" "\\mdlgwhtcircle" #X025CB "○")
    ("mathbin" "\\midbarvee" #X02A5D "⩝")
    ("mathbin" "\\midbarwedge" #X02A5C "⩜")
    ("mathbin" "\\minus" #X02212 "−")
    ("mathbin" "\\minusdot" #X02A2A "⨪")
    ("mathbin" "\\minusfdots" #X02A2B "⨫")
    ("mathbin" "\\minusrdots" #X02A2C "⨬")
    ("mathbin" "\\mp" #X02213 "∓")
    ("mathbin" "\\nhVvert" #X02AF5 "⫵")
    ("mathbin" "\\obar" #X0233D "⌽")
    ("mathbin" "\\obslash" #X029B8 "⦸")
    ("mathbin" "\\odiv" #X02A38 "⨸")
    ("mathbin" "\\odot" #X02299 "⊙")
    ("mathbin" "\\ogreaterthan" #X029C1 "⧁")
    ("mathbin" "\\olessthan" #X029C0 "⧀")
    ("mathbin" "\\ominus" #X02296 "⊖")
    ("mathbin" "\\operp" #X029B9 "⦹")
    ("mathbin" "\\oplus" #X02295 "⊕")
    ("mathbin" "\\opluslhrim" #X02A2D "⨭")
    ("mathbin" "\\oplusrhrim" #X02A2E "⨮")
    ("mathbin" "\\oslash" #X02298 "⊘")
    ("mathbin" "\\otimes" #X02297 "⊗")
    ("mathbin" "\\otimeshat" #X02A36 "⨶")
    ("mathbin" "\\otimeslhrim" #X02A34 "⨴")
    ("mathbin" "\\otimesrhrim" #X02A35 "⨵")
    ("mathbin" "\\plus" #X0002B "+")
    ("mathbin" "\\plusdot" #X02A25 "⨥")
    ("mathbin" "\\pluseqq" #X02A72 "⩲")
    ("mathbin" "\\plushat" #X02A23 "⨣")
    ("mathbin" "\\plussim" #X02A26 "⨦")
    ("mathbin" "\\plussubtwo" #X02A27 "⨧")
    ("mathbin" "\\plustrif" #X02A28 "⨨")
    ("mathbin" "\\pm" #X000B1 "±")
    ("mathbin" "\\rightthreetimes" #X022CC "⋌")
    ("mathbin" "\\ringplus" #X02A22 "⨢")
    ("mathbin" "\\rsolbar" #X029F7 "⧷")
    ("mathbin" "\\rsub" #X02A65 "⩥")
    ("mathbin" "\\rtimes" #X022CA "⋊")
    ("mathbin" "\\setminus" #X029F5 "⧵")
    ("mathbin" "\\shuffle" #X029E2 "⧢")
    ("mathbin" "\\simplus" #X02A24 "⨤")
    ("mathbin" "\\smallblacktriangleleft" #X025C2 "◂")
    ("mathbin" "\\smallblacktriangleright" #X025B8 "▸")
    ("mathbin" "\\smallsetminus" #X02216 "∖")
    ("mathbin" "\\smalltriangleleft" #X025C3 "◃")
    ("mathbin" "\\smalltriangleright" #X025B9 "▹")
    ("mathbin" "\\smashtimes" #X02A33 "⨳")
    ("mathbin" "\\smblkcircle" #X02022 "•")
    ("mathbin" "\\smwhtdiamond" #X022C4 "⋄")
    ("mathbin" "\\sqcap" #X02293 "⊓")
    ("mathbin" "\\sqcup" #X02294 "⊔")
    ("mathbin" "\\sslash" #X02AFD "⫽")
    ("mathbin" "\\star" #X022C6 "⋆")
    ("mathbin" "\\talloblong" #X02AFE "⫾")
    ("mathbin" "\\threedotcolon" #X02AF6 "⫶")
    ("mathbin" "\\tieconcat" #X02040 "⁀")
    ("mathbin" "\\times" #X000D7 "×")
    ("mathbin" "\\timesbar" #X02A31 "⨱")
    ("mathbin" "\\tminus" #X029FF "⧿")
    ("mathbin" "\\tplus" #X029FE "⧾")
    ("mathbin" "\\triangledown" #X025BF "▿")
    ("mathbin" "\\triangleleft" #X025C1 "◁")
    ("mathbin" "\\triangleminus" #X02A3A "⨺")
    ("mathbin" "\\triangleplus" #X02A39 "⨹")
    ("mathbin" "\\triangleright" #X025B7 "▷")
    ("mathbin" "\\triangleserifs" #X029CD "⧍")
    ("mathbin" "\\triangletimes" #X02A3B "⨻")
    ("mathbin" "\\tripleplus" #X029FB "⧻")
    ("mathbin" "\\trslash" #X02AFB "⫻")
    ("mathbin" "\\twocaps" #X02A4B "⩋")
    ("mathbin" "\\twocups" #X02A4A "⩊")
    ("mathbin" "\\typecolon" #X02982 "⦂")
    ("mathbin" "\\uminus" #X02A41 "⩁")
    ("mathbin" "\\upand" #X0214B "⅋")
    ("mathbin" "\\uplus" #X0228E "⊎")
    ("mathbin" "\\varbarwedge" #X02305 "⌅")
    ("mathbin" "\\vardoublebarwedge" #X02306 "⌆")
    ("mathbin" "\\vartriangle" #X025B5 "▵")
    ("mathbin" "\\varveebar" #X02A61 "⩡")
    ("mathbin" "\\vectimes" #X02A2F "⨯")
    ("mathbin" "\\vee" #X02228 "∨")
    ("mathbin" "\\veebar" #X022BB "⊻")
    ("mathbin" "\\veedot" #X027C7 "⟇")
    ("mathbin" "\\veedoublebar" #X02A63 "⩣")
    ("mathbin" "\\veemidvert" #X02A5B "⩛")
    ("mathbin" "\\veeodot" #X02A52 "⩒")
    ("mathbin" "\\veeonvee" #X02A56 "⩖")
    ("mathbin" "\\vysmblkcircle" #X02219 "∙")
    ("mathbin" "\\vysmwhtcircle" #X02218 "∘")
    ("mathbin" "\\wedge" #X02227 "∧")
    ("mathbin" "\\wedgebar" #X02A5F "⩟")
    ("mathbin" "\\wedgedot" #X027D1 "⟑")
    ("mathbin" "\\wedgedoublebar" #X02A60 "⩠")
    ("mathbin" "\\wedgemidvert" #X02A5A "⩚")
    ("mathbin" "\\wedgeodot" #X02A51 "⩑")
    ("mathbin" "\\wedgeonwedge" #X02A55 "⩕")
    ("mathbin" "\\whitesquaretickleft" #X027E4 "⟤")
    ("mathbin" "\\whitesquaretickright" #X027E5 "⟥")
    ("mathbin" "\\wr" #X02240 "≀")
    ("mathclose" "\\Rbrbrak" #X027ED "⟭")
    ("mathclose" "\\Rbrbrak" #X03019 "〙")
    ("mathclose" "\\Rparenless" #X02996 "⦖")
    ("mathclose" "\\Rvzigzag" #X029DB "⧛")
    ("mathclose" "\\lrcorner" #X0231F "⌟")
    ("mathclose" "\\rAngle" #X027EB "⟫")
    ("mathclose" "\\rBrace" #X02984 "⦄")
    ("mathclose" "\\rBrack" #X027E7 "⟧")
    ("mathclose" "\\rParen" #X02986 "⦆")
    ("mathclose" "\\rangle" #X027E9 "⟩")
    ("mathclose" "\\rangledot" #X02992 "⦒")
    ("mathclose" "\\rbag" #X027C6 "⟆")
    ("mathclose" "\\rblkbrbrak" #X02998 "⦘")
    ("mathclose" "\\rbrace" #X0007D "}")
    ("mathclose" "\\rbrack" #X0005D "]")
    ("mathclose" "\\rbracklrtick" #X0298E "⦎")
    ("mathclose" "\\rbrackubar" #X0298C "⦌")
    ("mathclose" "\\rbrackurtick" #X02990 "⦐")
    ("mathclose" "\\rbrbrak" #X02773 "❳")
    ("mathclose" "\\rbrbrak" #X03015 "〕")
    ("mathclose" "\\rceil" #X02309 "⌉")
    ("mathclose" "\\rcurvyangle" #X029FD "⧽")
    ("mathclose" "\\rfloor" #X0230B "⌋")
    ("mathclose" "\\rparen" #X00029 ")")
    ("mathclose" "\\rparengtr" #X02994 "⦔")
    ("mathclose" "\\rrangle" #X0298A "⦊")
    ("mathclose" "\\rrparenthesis" #X02988 "⦈")
    ("mathclose" "\\rvzigzag" #X029D9 "⧙")
    ("mathclose" "\\urcorner" #X0231D "⌝")
    ("mathfence" "\\Vert" #X02016 "‖")
    ("mathfence" "\\Vvert" #X02980 "⦀")
    ("mathfence" "\\vert" #X0007C "|")
    ("mathop" "\\Bbbsum" #X02140 "⅀")
    ("mathop" "\\Join" #X02A1D "⨝")
    ("mathop" "\\awint" #X02A11 "⨑")
    ("mathop" "\\bigbot" #X027D8 "⟘")
    ("mathop" "\\bigcap" #X022C2 "⋂")
    ("mathop" "\\bigcup" #X022C3 "⋃")
    ("mathop" "\\bigcupdot" #X02A03 "⨃")
    ("mathop" "\\biginterleave" #X02AFC "⫼")
    ("mathop" "\\bigodot" #X02A00 "⨀")
    ("mathop" "\\bigoplus" #X02A01 "⨁")
    ("mathop" "\\bigotimes" #X02A02 "⨂")
    ("mathop" "\\bigsqcap" #X02A05 "⨅")
    ("mathop" "\\bigsqcup" #X02A06 "⨆")
    ("mathop" "\\bigtalloblong" #X02AFF "⫿")
    ("mathop" "\\bigtimes" #X02A09 "⨉")
    ("mathop" "\\bigtop" #X027D9 "⟙")
    ("mathop" "\\bigtriangleleft" #X02A1E "⨞")
    ("mathop" "\\biguplus" #X02A04 "⨄")
    ("mathop" "\\bigvee" #X022C1 "⋁")
    ("mathop" "\\bigwedge" #X022C0 "⋀")
    ("mathop" "\\cirfnint" #X02A10 "⨐")
    ("mathop" "\\conjquant" #X02A07 "⨇")
    ("mathop" "\\coprod" #X02210 "∐")
    ("mathop" "\\disjquant" #X02A08 "⨈")
    ("mathop" "\\fint" #X02A0F "⨏")
    ("mathop" "\\fullouterjoin" #X027D7 "⟗")
    ("mathop" "\\iiiint" #X02A0C "⨌")
    ("mathop" "\\iiint" #X0222D "∭")
    ("mathop" "\\iint" #X0222C "∬")
    ("mathop" "\\int" #X0222B "∫")
    ("mathop" "\\intBar" #X02A0E "⨎")
    ("mathop" "\\intbar" #X02A0D "⨍")
    ("mathop" "\\intcap" #X02A19 "⨙")
    ("mathop" "\\intclockwise" #X02231 "∱")
    ("mathop" "\\intcup" #X02A1A "⨚")
    ("mathop" "\\intlarhk" #X02A17 "⨗")
    ("mathop" "\\intx" #X02A18 "⨘")
    ("mathop" "\\leftouterjoin" #X027D5 "⟕")
    ("mathop" "\\lowint" #X02A1C "⨜")
    ("mathop" "\\npolint" #X02A14 "⨔")
    ("mathop" "\\oiiint" #X02230 "∰")
    ("mathop" "\\oiint" #X0222F "∯")
    ("mathop" "\\oint" #X0222E "∮")
    ("mathop" "\\ointctrclockwise" #X02233 "∳")
    ("mathop" "\\pointint" #X02A15 "⨕")
    ("mathop" "\\prod" #X0220F "∏")
    ("mathop" "\\rightouterjoin" #X027D6 "⟖")
    ("mathop" "\\rppolint" #X02A12 "⨒")
    ("mathop" "\\scpolint" #X02A13 "⨓")
    ("mathop" "\\sqint" #X02A16 "⨖")
    ("mathop" "\\sum" #X02211 "∑")
    ("mathop" "\\sumint" #X02A0B "⨋")
    ("mathop" "\\upint" #X02A1B "⨛")
    ("mathop" "\\varointclockwise" #X02232 "∲")
    ("mathop" "\\xbsol" #X029F9 "⧹")
    ("mathop" "\\xsol" #X029F8 "⧸")
    ("mathop" "\\zcmp" #X02A1F "⨟")
    ("mathop" "\\zpipe" #X02A20 "⨠")
    ("mathop" "\\zproject" #X02A21 "⨡")
    ("mathopen" "\\Lbrbrak" #X027EC "⟬")
    ("mathopen" "\\Lbrbrak" #X03018 "〘")
    ("mathopen" "\\Lparengtr" #X02995 "⦕")
    ("mathopen" "\\Lvzigzag" #X029DA "⧚")
    ("mathopen" "\\lAngle" #X027EA "⟪")
    ("mathopen" "\\lBrace" #X02983 "⦃")
    ("mathopen" "\\lBrack" #X027E6 "⟦")
    ("mathopen" "\\lParen" #X02985 "⦅")
    ("mathopen" "\\langle" #X027E8 "⟨")
    ("mathopen" "\\langledot" #X02991 "⦑")
    ("mathopen" "\\lbag" #X027C5 "⟅")
    ("mathopen" "\\lblkbrbrak" #X02997 "⦗")
    ("mathopen" "\\lbrace" #X0007B "{")
    ("mathopen" "\\lbrack" #X0005B "[")
    ("mathopen" "\\lbracklltick" #X0298F "⦏")
    ("mathopen" "\\lbrackubar" #X0298B "⦋")
    ("mathopen" "\\lbrackultick" #X0298D "⦍")
    ("mathopen" "\\lbrbrak" #X02772 "❲")
    ("mathopen" "\\lbrbrak" #X03014 "〔")
    ("mathopen" "\\lceil" #X02308 "⌈")
    ("mathopen" "\\lcurvyangle" #X029FC "⧼")
    ("mathopen" "\\lfloor" #X0230A "⌊")
    ("mathopen" "\\llangle" #X02989 "⦉")
    ("mathopen" "\\llcorner" #X0231E "⌞")
    ("mathopen" "\\llparenthesis" #X02987 "⦇")
    ("mathopen" "\\longdivision" #X027CC "⟌")
    ("mathopen" "\\lparen" #X00028 "(")
    ("mathopen" "\\lparenless" #X02993 "⦓")
    ("mathopen" "\\lvzigzag" #X029D8 "⧘")
    ("mathopen" "\\ulcorner" #X0231C "⌜")
    ("mathord" "\\APLboxquestion" #X02370 "⍰")
    ("mathord" "\\APLboxupcaret" #X02353 "⍓")
    ("mathord" "\\APLnotbackslash" #X02340 "⍀")
    ("mathord" "\\Bbbeight" #X1D7E0 "𝟠")
    ("mathord" "\\Bbbfive" #X1D7DD "𝟝")
    ("mathord" "\\Bbbfour" #X1D7DC "𝟜")
    ("mathord" "\\Bbbnine" #X1D7E1 "𝟡")
    ("mathord" "\\Bbbone" #X1D7D9 "𝟙")
    ("mathord" "\\Bbbpi" #X0213C "ℼ")
    ("mathord" "\\Bbbseven" #X1D7DF "𝟟")
    ("mathord" "\\Bbbsix" #X1D7DE "𝟞")
    ("mathord" "\\Bbbthree" #X1D7DB "𝟛")
    ("mathord" "\\Bbbtwo" #X1D7DA "𝟚")
    ("mathord" "\\Bbbzero" #X1D7D8 "𝟘")
    ("mathord" "\\Eulerconst" #X02107 "ℇ")
    ("mathord" "\\Exclam" #X0203C "‼")
    ("mathord" "\\Finv" #X02132 "Ⅎ")
    ("mathord" "\\Game" #X02141 "⅁")
    ("mathord" "\\Hermaphrodite" #X026A5 "⚥")
    ("mathord" "\\Planckconst" #X0210E "ℎ")
    ("mathord" "\\PropertyLine" #X0214A "⅊")
    ("mathord" "\\QED" #X0220E "∎")
    ("mathord" "\\Question" #X02047 "⁇")
    ("mathord" "\\Yup" #X02144 "⅄")
    ("mathord" "\\Zbar" #X001B5 "Ƶ")
    ("mathord" "\\accurrent" #X023E6 "⏦")
    ("mathord" "\\acidfree" #X0267E "♾")
    ("mathord" "\\acwopencirclearrow" #X021BA "↺")
    ("mathord" "\\ampersand" #X00026 "&")
    ("mathord" "\\angdnr" #X0299F "⦟")
    ("mathord" "\\angle" #X02220 "∠")
    ("mathord" "\\angles" #X0299E "⦞")
    ("mathord" "\\angleubar" #X029A4 "⦤")
    ("mathord" "\\astrosun" #X02609 "☉")
    ("mathord" "\\atsign" #X00040 "@")
    ("mathord" "\\backdprime" #X02036 "‶")
    ("mathord" "\\backprime" #X02035 "‵")
    ("mathord" "\\backslash" #X0005C "\\")
    ("mathord" "\\backtrprime" #X02037 "‷")
    ("mathord" "\\barleftarrowrightarrowba" #X021B9 "↹")
    ("mathord" "\\barovernorthwestarrow" #X021B8 "↸")
    ("mathord" "\\bbrktbrk" #X023B6 "⎶")
    ("mathord" "\\bdtriplevdash" #X02506 "┆")
    ("mathord" "\\because" #X02235 "∵")
    ("mathord" "\\benzenr" #X023E3 "⏣")
    ("mathord" "\\bigblacktriangledown" #X025BC "▼")
    ("mathord" "\\bigblacktriangleup" #X025B2 "▲")
    ("mathord" "\\bigstar" #X02605 "★")
    ("mathord" "\\bigwhitestar" #X02606 "☆")
    ("mathord" "\\blackcircledownarrow" #X029ED "⧭")
    ("mathord" "\\blackcircledrightdot" #X02688 "⚈")
    ("mathord" "\\blackcircledtwodots" #X02689 "⚉")
    ("mathord" "\\blackcircleulquadwhite" #X025D5 "◕")
    ("mathord" "\\blackdiamonddownarrow" #X029EA "⧪")
    ("mathord" "\\blackinwhitediamond" #X025C8 "◈")
    ("mathord" "\\blackinwhitesquare" #X025A3 "▣")
    ("mathord" "\\blacklefthalfcircle" #X025D6 "◖")
    ("mathord" "\\blackpointerleft" #X025C4 "◄")
    ("mathord" "\\blackpointerright" #X025BA "►")
    ("mathord" "\\blackrighthalfcircle" #X025D7 "◗")
    ("mathord" "\\blacksmiley" #X0263B "☻")
    ("mathord" "\\blkhorzoval" #X02B2C "⬬")
    ("mathord" "\\blkvertoval" #X02B2E "⬮")
    ("mathord" "\\blockfull" #X02588 "█")
    ("mathord" "\\blockhalfshaded" #X02592 "▒")
    ("mathord" "\\blocklefthalf" #X0258C "▌")
    ("mathord" "\\blocklowhalf" #X02584 "▄")
    ("mathord" "\\blockqtrshaded" #X02591 "░")
    ("mathord" "\\blockrighthalf" #X02590 "▐")
    ("mathord" "\\blockthreeqtrshaded" #X02593 "▓")
    ("mathord" "\\blockuphalf" #X02580 "▀")
    ("mathord" "\\bot" #X022A5 "⊥")
    ("mathord" "\\botsemicircle" #X025E1 "◡")
    ("mathord" "\\boxonbox" #X029C9 "⧉")
    ("mathord" "\\bullseye" #X025CE "◎")
    ("mathord" "\\caretinsert" #X02038 "‸")
    ("mathord" "\\carriagereturn" #X021B5 "↵")
    ("mathord" "\\checkmark" #X02713 "✓")
    ("mathord" "\\cirE" #X029C3 "⧃")
    ("mathord" "\\circlebottomhalfblack" #X025D2 "◒")
    ("mathord" "\\circledbullet" #X029BF "⦿")
    ("mathord" "\\circledownarrow" #X029EC "⧬")
    ("mathord" "\\circledrightdot" #X02686 "⚆")
    ("mathord" "\\circledstar" #X0272A "✪")
    ("mathord" "\\circledtwodots" #X02687 "⚇")
    ("mathord" "\\circledwhitebullet" #X029BE "⦾")
    ("mathord" "\\circlelefthalfblack" #X025D0 "◐")
    ("mathord" "\\circlellquad" #X025F5 "◵")
    ("mathord" "\\circlelrquad" #X025F6 "◶")
    ("mathord" "\\circlerighthalfblack" #X025D1 "◑")
    ("mathord" "\\circletophalfblack" #X025D3 "◓")
    ("mathord" "\\circleulquad" #X025F4 "◴")
    ("mathord" "\\circleurquad" #X025F7 "◷")
    ("mathord" "\\circleurquadblack" #X025D4 "◔")
    ("mathord" "\\circlevertfill" #X025CD "◍")
    ("mathord" "\\cirscir" #X029C2 "⧂")
    ("mathord" "\\clubsuit" #X02663 "♣")
    ("mathord" "\\complement" #X02201 "∁")
    ("mathord" "\\conictaper" #X02332 "⌲")
    ("mathord" "\\cwopencirclearrow" #X021BB "↻")
    ("mathord" "\\danger" #X02621 "☡")
    ("mathord" "\\diameter" #X02300 "⌀")
    ("mathord" "\\diamondbotblack" #X02B19 "⬙")
    ("mathord" "\\diamondcdot" #X027D0 "⟐")
    ("mathord" "\\diamondleftblack" #X02B16 "⬖")
    ("mathord" "\\diamondrightblack" #X02B17 "⬗")
    ("mathord" "\\diamondsuit" #X02662 "♢")
    ("mathord" "\\diamondtopblack" #X02B18 "⬘")
    ("mathord" "\\dicei" #X02680 "⚀")
    ("mathord" "\\diceii" #X02681 "⚁")
    ("mathord" "\\diceiii" #X02682 "⚂")
    ("mathord" "\\diceiv" #X02683 "⚃")
    ("mathord" "\\dicev" #X02684 "⚄")
    ("mathord" "\\dicevi" #X02685 "⚅")
    ("mathord" "\\dingasterisk" #X0273D "✽")
    ("mathord" "\\dottedcircle" #X025CC "◌")
    ("mathord" "\\dottedsquare" #X02B1A "⬚")
    ("mathord" "\\downdasharrow" #X021E3 "⇣")
    ("mathord" "\\downrightcurvedarrow" #X02935 "⤵")
    ("mathord" "\\downtriangleleftblack" #X029E8 "⧨")
    ("mathord" "\\downtrianglerightblack" #X029E9 "⧩")
    ("mathord" "\\downwhitearrow" #X021E9 "⇩")
    ("mathord" "\\dprime" #X02033 "″")
    ("mathord" "\\draftingarrow" #X0279B "➛")
    ("mathord" "\\eighthnote" #X0266A "♪")
    ("mathord" "\\elinters" #X023E7 "⏧")
    ("mathord" "\\emptysetoarr" #X029B3 "⦳")
    ("mathord" "\\emptysetoarrl" #X029B4 "⦴")
    ("mathord" "\\emptysetobar" #X029B1 "⦱")
    ("mathord" "\\emptysetocirc" #X029B2 "⦲")
    ("mathord" "\\enleadertwodots" #X02025 "‥")
    ("mathord" "\\errbarblackcircle" #X029F3 "⧳")
    ("mathord" "\\errbarblackdiamond" #X029F1 "⧱")
    ("mathord" "\\errbarblacksquare" #X029EF "⧯")
    ("mathord" "\\errbarcircle" #X029F2 "⧲")
    ("mathord" "\\errbardiamond" #X029F0 "⧰")
    ("mathord" "\\errbarsquare" #X029EE "⧮")
    ("mathord" "\\euro" #X020AC "€")
    ("mathord" "\\exists" #X02203 "∃")
    ("mathord" "\\fdiagovnearrow" #X0292F "⤯")
    ("mathord" "\\fdiagovrdiag" #X0292C "⤬")
    ("mathord" "\\female" #X02640 "♀")
    ("mathord" "\\fisheye" #X025C9 "◉")
    ("mathord" "\\flat" #X0266D "♭")
    ("mathord" "\\fltns" #X023E5 "⏥")
    ("mathord" "\\forall" #X02200 "∀")
    ("mathord" "\\fourvdots" #X02999 "⦙")
    ("mathord" "\\gtlpar" #X029A0 "⦠")
    ("mathord" "\\harrowextender" #X023AF "⎯")
    ("mathord" "\\heartsuit" #X02661 "♡")
    ("mathord" "\\hermitmatrix" #X022B9 "⊹")
    ("mathord" "\\hexagon" #X02394 "⎔")
    ("mathord" "\\hexagonblack" #X02B23 "⬣")
    ("mathord" "\\horizbar" #X02015 "―")
    ("mathord" "\\house" #X02302 "⌂")
    ("mathord" "\\hrectangle" #X025AD "▭")
    ("mathord" "\\hrectangleblack" #X025AC "▬")
    ("mathord" "\\hyphenbullet" #X02043 "⁃")
    ("mathord" "\\hzigzag" #X03030 "〰")
    ("mathord" "\\iinfin" #X029DC "⧜")
    ("mathord" "\\increment" #X02206 "∆")
    ("mathord" "\\infty" #X0221E "∞")
    ("mathord" "\\intbottom" #X02321 "⌡")
    ("mathord" "\\intextender" #X023AE "⎮")
    ("mathord" "\\inttop" #X02320 "⌠")
    ("mathord" "\\inversebullet" #X025D8 "◘")
    ("mathord" "\\inversewhitecircle" #X025D9 "◙")
    ("mathord" "\\invnot" #X02310 "⌐")
    ("mathord" "\\invwhitelowerhalfcircle" #X025DB "◛")
    ("mathord" "\\invwhiteupperhalfcircle" #X025DA "◚")
    ("mathord" "\\laplac" #X029E0 "⧠")
    ("mathord" "\\lbracelend" #X023A9 "⎩")
    ("mathord" "\\lbracemid" #X023A8 "⎨")
    ("mathord" "\\lbraceuend" #X023A7 "⎧")
    ("mathord" "\\lbrackextender" #X023A2 "⎢")
    ("mathord" "\\lbracklend" #X023A3 "⎣")
    ("mathord" "\\lbrackuend" #X023A1 "⎡")
    ("mathord" "\\leftdasharrow" #X021E0 "⇠")
    ("mathord" "\\leftmoon" #X0263E "☾")
    ("mathord" "\\leftwhitearrow" #X021E6 "⇦")
    ("mathord" "\\lgblkcircle" #X02B24 "⬤")
    ("mathord" "\\lgblksquare" #X02B1B "⬛")
    ("mathord" "\\lgwhtcircle" #X025EF "◯")
    ("mathord" "\\lgwhtsquare" #X02B1C "⬜")
    ("mathord" "\\linefeed" #X021B4 "↴")
    ("mathord" "\\llarc" #X025DF "◟")
    ("mathord" "\\llblacktriangle" #X025E3 "◣")
    ("mathord" "\\lltriangle" #X025FA "◺")
    ("mathord" "\\lmoustache" #X023B0 "⎰")
    ("mathord" "\\lparenextender" #X0239C "⎜")
    ("mathord" "\\lparenlend" #X0239D "⎝")
    ("mathord" "\\lparenuend" #X0239B "⎛")
    ("mathord" "\\lrarc" #X025DE "◞")
    ("mathord" "\\lrblacktriangle" #X025E2 "◢")
    ("mathord" "\\lrtriangle" #X025FF "◿")
    ("mathord" "\\lvboxline" #X023B8 "⎸")
    ("mathord" "\\male" #X02642 "♂")
    ("mathord" "\\maltese" #X02720 "✠")
    ("mathord" "\\mathdollar" #X00024 "$")
    ("mathord" "\\mathslash" #X0002F "/")
    ("mathord" "\\mbfitnabla" #X1D735 "𝜵")
    ("mathord" "\\mbfitpartial" #X1D74F "𝝏")
    ("mathord" "\\mbfitsansnabla" #X1D7A9 "𝞩")
    ("mathord" "\\mbfitsanspartial" #X1D7C3 "𝟃")
    ("mathord" "\\mbfnabla" #X1D6C1 "𝛁")
    ("mathord" "\\mbfpartial" #X1D6DB "𝛛")
    ("mathord" "\\mbfsanseight" #X1D7F4 "𝟴")
    ("mathord" "\\mbfsansfive" #X1D7F1 "𝟱")
    ("mathord" "\\mbfsansfour" #X1D7F0 "𝟰")
    ("mathord" "\\mbfsansnabla" #X1D76F "𝝯")
    ("mathord" "\\mbfsansnine" #X1D7F5 "𝟵")
    ("mathord" "\\mbfsansone" #X1D7ED "𝟭")
    ("mathord" "\\mbfsanspartial" #X1D789 "𝞉")
    ("mathord" "\\mbfsansseven" #X1D7F3 "𝟳")
    ("mathord" "\\mbfsanssix" #X1D7F2 "𝟲")
    ("mathord" "\\mbfsansthree" #X1D7EF "𝟯")
    ("mathord" "\\mbfsanstwo" #X1D7EE "𝟮")
    ("mathord" "\\mbfsanszero" #X1D7EC "𝟬")
    ("mathord" "\\mdblkcircle" #X026AB "⚫")
    ("mathord" "\\mdblkdiamond" #X02B25 "⬥")
    ("mathord" "\\mdblklozenge" #X02B27 "⬧")
    ("mathord" "\\mdblksquare" #X025FC "◼")
    ("mathord" "\\mdlgblkcircle" #X025CF "●")
    ("mathord" "\\mdlgblkdiamond" #X025C6 "◆")
    ("mathord" "\\mdlgblksquare" #X025A0 "■")
    ("mathord" "\\mdlgwhtdiamond" #X025C7 "◇")
    ("mathord" "\\mdlgwhtlozenge" #X025CA "◊")
    ("mathord" "\\mdlgwhtsquare" #X025A1 "□")
    ("mathord" "\\mdsmblkcircle" #X02981 "⦁")
    ("mathord" "\\mdsmblksquare" #X025FE "◾")
    ("mathord" "\\mdsmwhtcircle" #X026AC "⚬")
    ("mathord" "\\mdsmwhtsquare" #X025FD "◽")
    ("mathord" "\\mdwhtcircle" #X026AA "⚪")
    ("mathord" "\\mdwhtdiamond" #X02B26 "⬦")
    ("mathord" "\\mdwhtlozenge" #X02B28 "⬨")
    ("mathord" "\\mdwhtsquare" #X025FB "◻")
    ("mathord" "\\measangledltosw" #X029AF "⦯")
    ("mathord" "\\measangledrtose" #X029AE "⦮")
    ("mathord" "\\measangleldtosw" #X029AB "⦫")
    ("mathord" "\\measanglelutonw" #X029A9 "⦩")
    ("mathord" "\\measanglerdtose" #X029AA "⦪")
    ("mathord" "\\measanglerutone" #X029A8 "⦨")
    ("mathord" "\\measangleultonw" #X029AD "⦭")
    ("mathord" "\\measangleurtone" #X029AC "⦬")
    ("mathord" "\\measuredangle" #X02221 "∡")
    ("mathord" "\\measuredangleleft" #X0299B "⦛")
    ("mathord" "\\measuredrightangle" #X022BE "⊾")
    ("mathord" "\\medblackstar" #X02B51 "⭑")
    ("mathord" "\\medwhitestar" #X02B50 "⭐")
    ("mathord" "\\mho" #X02127 "℧")
    ("mathord" "\\mitBbbD" #X02145 "ⅅ")
    ("mathord" "\\mitBbbd" #X02146 "ⅆ")
    ("mathord" "\\mitBbbe" #X02147 "ⅇ")
    ("mathord" "\\mitBbbi" #X02148 "ⅈ")
    ("mathord" "\\mitBbbj" #X02149 "ⅉ")
    ("mathord" "\\mitnabla" #X1D6FB "𝛻")
    ("mathord" "\\mitpartial" #X1D715 "𝜕")
    ("mathord" "\\modtwosum" #X02A0A "⨊")
    ("mathord" "\\msanseight" #X1D7EA "𝟪")
    ("mathord" "\\msansfive" #X1D7E7 "𝟧")
    ("mathord" "\\msansfour" #X1D7E6 "𝟦")
    ("mathord" "\\msansnine" #X1D7EB "𝟫")
    ("mathord" "\\msansone" #X1D7E3 "𝟣")
    ("mathord" "\\msansseven" #X1D7E9 "𝟩")
    ("mathord" "\\msanssix" #X1D7E8 "𝟨")
    ("mathord" "\\msansthree" #X1D7E5 "𝟥")
    ("mathord" "\\msanstwo" #X1D7E4 "𝟤")
    ("mathord" "\\msanszero" #X1D7E2 "𝟢")
    ("mathord" "\\mtteight" #X1D7FE "𝟾")
    ("mathord" "\\mttfive" #X1D7FB "𝟻")
    ("mathord" "\\mttfour" #X1D7FA "𝟺")
    ("mathord" "\\mttnine" #X1D7FF "𝟿")
    ("mathord" "\\mttone" #X1D7F7 "𝟷")
    ("mathord" "\\mttseven" #X1D7FD "𝟽")
    ("mathord" "\\mttsix" #X1D7FC "𝟼")
    ("mathord" "\\mttthree" #X1D7F9 "𝟹")
    ("mathord" "\\mtttwo" #X1D7F8 "𝟸")
    ("mathord" "\\mttzero" #X1D7F6 "𝟶")
    ("mathord" "\\nHdownarrow" #X021DF "⇟")
    ("mathord" "\\nHuparrow" #X021DE "⇞")
    ("mathord" "\\nabla" #X02207 "∇")
    ("mathord" "\\natural" #X0266E "♮")
    ("mathord" "\\neg" #X000AC "¬")
    ("mathord" "\\neovnwarrow" #X02931 "⤱")
    ("mathord" "\\neovsearrow" #X0292E "⤮")
    ("mathord" "\\neuter" #X026B2 "⚲")
    ("mathord" "\\nexists" #X02204 "∄")
    ("mathord" "\\nvinfty" #X029DE "⧞")
    ("mathord" "\\nwovnearrow" #X02932 "⤲")
    ("mathord" "\\obot" #X029BA "⦺")
    ("mathord" "\\obrbrak" #X023E0 "⏠")
    ("mathord" "\\octothorpe" #X00023 "#")
    ("mathord" "\\odotslashdot" #X029BC "⦼")
    ("mathord" "\\olcross" #X029BB "⦻")
    ("mathord" "\\parallelogram" #X025B1 "▱")
    ("mathord" "\\parallelogramblack" #X025B0 "▰")
    ("mathord" "\\partial" #X02202 "∂")
    ("mathord" "\\pentagon" #X02B20 "⬠")
    ("mathord" "\\pentagonblack" #X02B1F "⬟")
    ("mathord" "\\percent" #X00025 "%")
    ("mathord" "\\perps" #X02AE1 "⫡")
    ("mathord" "\\postalmark" #X03012 "〒")
    ("mathord" "\\prime" #X02032 "′")
    ("mathord" "\\profline" #X02312 "⌒")
    ("mathord" "\\profsurf" #X02313 "⌓")
    ("mathord" "\\qprime" #X02057 "⁗")
    ("mathord" "\\quarternote" #X02669 "♩")
    ("mathord" "\\question" #X0003F "?")
    ("mathord" "\\rangledownzigzagarrow" #X0237C "⍼")
    ("mathord" "\\rbracelend" #X023AD "⎭")
    ("mathord" "\\rbracemid" #X023AC "⎬")
    ("mathord" "\\rbraceuend" #X023AB "⎫")
    ("mathord" "\\rbrackextender" #X023A5 "⎥")
    ("mathord" "\\rbracklend" #X023A6 "⎦")
    ("mathord" "\\rbrackuend" #X023A4 "⎤")
    ("mathord" "\\rdiagovfdiag" #X0292B "⤫")
    ("mathord" "\\rdiagovsearrow" #X02930 "⤰")
    ("mathord" "\\revangle" #X029A3 "⦣")
    ("mathord" "\\revangleubar" #X029A5 "⦥")
    ("mathord" "\\revemptyset" #X029B0 "⦰")
    ("mathord" "\\rightangle" #X0221F "∟")
    ("mathord" "\\rightanglemdot" #X0299D "⦝")
    ("mathord" "\\rightanglesqr" #X0299C "⦜")
    ("mathord" "\\rightdasharrow" #X021E2 "⇢")
    ("mathord" "\\rightmoon" #X0263D "☽")
    ("mathord" "\\rightpentagon" #X02B54 "⭔")
    ("mathord" "\\rightpentagonblack" #X02B53 "⭓")
    ("mathord" "\\rightwhitearrow" #X021E8 "⇨")
    ("mathord" "\\rmoustache" #X023B1 "⎱")
    ("mathord" "\\rparenextender" #X0239F "⎟")
    ("mathord" "\\rparenlend" #X023A0 "⎠")
    ("mathord" "\\rparenuend" #X0239E "⎞")
    ("mathord" "\\rvboxline" #X023B9 "⎹")
    ("mathord" "\\sansLmirrored" #X02143 "⅃")
    ("mathord" "\\sansLturned" #X02142 "⅂")
    ("mathord" "\\seovnearrow" #X0292D "⤭")
    ("mathord" "\\sharp" #X0266F "♯")
    ("mathord" "\\sinewave" #X0223F "∿")
    ("mathord" "\\smblkdiamond" #X02B29 "⬩")
    ("mathord" "\\smblklozenge" #X02B2A "⬪")
    ("mathord" "\\smblksquare" #X025AA "▪")
    ("mathord" "\\smwhitestar" #X02B52 "⭒")
    ("mathord" "\\smwhtcircle" #X025E6 "◦")
    ("mathord" "\\smwhtlozenge" #X02B2B "⬫")
    ("mathord" "\\smwhtsquare" #X025AB "▫")
    ("mathord" "\\spadesuit" #X02660 "♠")
    ("mathord" "\\sphericalangle" #X02222 "∢")
    ("mathord" "\\sphericalangleup" #X029A1 "⦡")
    ("mathord" "\\sqlozenge" #X02311 "⌑")
    ("mathord" "\\sqrtbottom" #X023B7 "⎷")
    ("mathord" "\\squarebotblack" #X02B13 "⬓")
    ("mathord" "\\squarecrossfill" #X025A9 "▩")
    ("mathord" "\\squarehfill" #X025A4 "▤")
    ("mathord" "\\squarehvfill" #X025A6 "▦")
    ("mathord" "\\squareleftblack" #X025E7 "◧")
    ("mathord" "\\squarellblack" #X02B15 "⬕")
    ("mathord" "\\squarellquad" #X025F1 "◱")
    ("mathord" "\\squarelrblack" #X025EA "◪")
    ("mathord" "\\squarelrquad" #X025F2 "◲")
    ("mathord" "\\squareneswfill" #X025A8 "▨")
    ("mathord" "\\squarenwsefill" #X025A7 "▧")
    ("mathord" "\\squarerightblack" #X025E8 "◨")
    ("mathord" "\\squaretopblack" #X02B12 "⬒")
    ("mathord" "\\squareulblack" #X025E9 "◩")
    ("mathord" "\\squareulquad" #X025F0 "◰")
    ("mathord" "\\squareurblack" #X02B14 "⬔")
    ("mathord" "\\squareurquad" #X025F3 "◳")
    ("mathord" "\\squarevfill" #X025A5 "▥")
    ("mathord" "\\squoval" #X025A2 "▢")
    ("mathord" "\\sterling" #X000A3 "£")
    ("mathord" "\\strns" #X023E4 "⏤")
    ("mathord" "\\subsetcirc" #X027C3 "⟃")
    ("mathord" "\\sumbottom" #X023B3 "⎳")
    ("mathord" "\\sumtop" #X023B2 "⎲")
    ("mathord" "\\sun" #X0263C "☼")
    ("mathord" "\\supsetcirc" #X027C4 "⟄")
    ("mathord" "\\therefore" #X02234 "∴")
    ("mathord" "\\thermod" #X029E7 "⧧")
    ("mathord" "\\threedangle" #X027C0 "⟀")
    ("mathord" "\\tieinfty" #X029DD "⧝")
    ("mathord" "\\top" #X022A4 "⊤")
    ("mathord" "\\topbot" #X02336 "⌶")
    ("mathord" "\\topcir" #X02AF1 "⫱")
    ("mathord" "\\topsemicircle" #X025E0 "◠")
    ("mathord" "\\trapezium" #X023E2 "⏢")
    ("mathord" "\\trianglecdot" #X025EC "◬")
    ("mathord" "\\triangleleftblack" #X025ED "◭")
    ("mathord" "\\triangleodot" #X029CA "⧊")
    ("mathord" "\\trianglerightblack" #X025EE "◮")
    ("mathord" "\\triangles" #X029CC "⧌")
    ("mathord" "\\triangleubar" #X029CB "⧋")
    ("mathord" "\\trprime" #X02034 "‴")
    ("mathord" "\\turnangle" #X029A2 "⦢")
    ("mathord" "\\turnednot" #X02319 "⌙")
    ("mathord" "\\twolowline" #X02017 "‗")
    ("mathord" "\\twonotes" #X0266B "♫")
    ("mathord" "\\ubrbrak" #X023E1 "⏡")
    ("mathord" "\\ularc" #X025DC "◜")
    ("mathord" "\\ulblacktriangle" #X025E4 "◤")
    ("mathord" "\\ultriangle" #X025F8 "◸")
    ("mathord" "\\unicodecdots" #X022EF "⋯")
    ("mathord" "\\unicodeellipsis" #X02026 "…")
    ("mathord" "\\uparrowoncircle" #X029BD "⦽")
    ("mathord" "\\upbackepsilon" #X003F6 "϶")
    ("mathord" "\\updasharrow" #X021E1 "⇡")
    ("mathord" "\\updownarrowbar" #X021A8 "↨")
    ("mathord" "\\upoldKoppa" #X003D8 "Ϙ")
    ("mathord" "\\upoldkoppa" #X003D9 "ϙ")
    ("mathord" "\\uprightcurvearrow" #X02934 "⤴")
    ("mathord" "\\upwhitearrow" #X021E7 "⇧")
    ("mathord" "\\urarc" #X025DD "◝")
    ("mathord" "\\urblacktriangle" #X025E5 "◥")
    ("mathord" "\\urtriangle" #X025F9 "◹")
    ("mathord" "\\varcarriagereturn" #X023CE "⏎")
    ("mathord" "\\varclubsuit" #X02667 "♧")
    ("mathord" "\\vardiamondsuit" #X02666 "♦")
    ("mathord" "\\varheartsuit" #X02665 "♥")
    ("mathord" "\\varhexagon" #X02B21 "⬡")
    ("mathord" "\\varhexagonblack" #X02B22 "⬢")
    ("mathord" "\\varhexagonlrbonds" #X0232C "⌬")
    ("mathord" "\\varlrtriangle" #X022BF "⊿")
    ("mathord" "\\varnothing" #X02205 "∅")
    ("mathord" "\\varspadesuit" #X02664 "♤")
    ("mathord" "\\varstar" #X02736 "✶")
    ("mathord" "\\vbraceextender" #X023AA "⎪")
    ("mathord" "\\viewdata" #X02317 "⌗")
    ("mathord" "\\vrectangle" #X025AF "▯")
    ("mathord" "\\vrectangleblack" #X025AE "▮")
    ("mathord" "\\vysmblksquare" #X02B1D "⬝")
    ("mathord" "\\vysmwhtsquare" #X02B1E "⬞")
    ("mathord" "\\vzigzag" #X0299A "⦚")
    ("mathord" "\\whitearrowupfrombar" #X021EA "⇪")
    ("mathord" "\\whiteinwhitetriangle" #X027C1 "⟁")
    ("mathord" "\\whitepointerleft" #X025C5 "◅")
    ("mathord" "\\whitepointerright" #X025BB "▻")
    ("mathord" "\\whthorzoval" #X02B2D "⬭")
    ("mathord" "\\whtvertoval" #X02B2F "⬯")
    ("mathord" "\\wideangledown" #X029A6 "⦦")
    ("mathord" "\\wideangleup" #X029A7 "⦧")
    ("mathord" "\\yen" #X000A5 "¥")
    ("mathover" "\\overbrace" #X023DE "⏞")
    ("mathover" "\\overbracket" #X023B4 "⎴")
    ("mathover" "\\overparen" #X023DC "⏜")
    ("mathpunct" "\\comma" #X0002C ",")
    ("mathpunct" "\\exclam" #X00021 "!")
    ("mathpunct" "\\mathcolon" #X0003A ":")
    ("mathpunct" "\\semicolon" #X0003B ";")
    ("mathradical" "\\cuberoot" #X0221B "∛")
    ("mathradical" "\\fourthroot" #X0221C "∜")
    ("mathradical" "\\sqrt" #X0221A "√")
    ("mathrel" "\\APLnotslash" #X0233F "⌿")
    ("mathrel" "\\Barv" #X02AE7 "⫧")
    ("mathrel" "\\Bumpeq" #X0224E "≎")
    ("mathrel" "\\Colon" #X02237 "∷")
    ("mathrel" "\\Coloneq" #X02A74 "⩴")
    ("mathrel" "\\DDownarrow" #X027F1 "⟱")
    ("mathrel" "\\DashV" #X02AE5 "⫥")
    ("mathrel" "\\DashVDash" #X027DA "⟚")
    ("mathrel" "\\Dashv" #X02AE4 "⫤")
    ("mathrel" "\\Ddownarrow" #X0290B "⤋")
    ("mathrel" "\\Doteq" #X02251 "≑")
    ("mathrel" "\\Downarrow" #X021D3 "⇓")
    ("mathrel" "\\Equiv" #X02263 "≣")
    ("mathrel" "\\Gt" #X02AA2 "⪢")
    ("mathrel" "\\LLeftarrow" #X02B45 "⭅")
    ("mathrel" "\\Ldsh" #X021B2 "↲")
    ("mathrel" "\\Leftarrow" #X021D0 "⇐")
    ("mathrel" "\\Leftrightarrow" #X021D4 "⇔")
    ("mathrel" "\\Lleftarrow" #X021DA "⇚")
    ("mathrel" "\\Longleftarrow" #X027F8 "⟸")
    ("mathrel" "\\Longleftrightarrow" #X027FA "⟺")
    ("mathrel" "\\Longmapsfrom" #X027FD "⟽")
    ("mathrel" "\\Longmapsto" #X027FE "⟾")
    ("mathrel" "\\Longrightarrow" #X027F9 "⟹")
    ("mathrel" "\\Lsh" #X021B0 "↰")
    ("mathrel" "\\Lt" #X02AA1 "⪡")
    ("mathrel" "\\Mapsfrom" #X02906 "⤆")
    ("mathrel" "\\Mapsto" #X02907 "⤇")
    ("mathrel" "\\Nearrow" #X021D7 "⇗")
    ("mathrel" "\\Not" #X02AEC "⫬")
    ("mathrel" "\\Nwarrow" #X021D6 "⇖")
    ("mathrel" "\\Prec" #X02ABB "⪻")
    ("mathrel" "\\RRightarrow" #X02B46 "⭆")
    ("mathrel" "\\Rdsh" #X021B3 "↳")
    ("mathrel" "\\Rightarrow" #X021D2 "⇒")
    ("mathrel" "\\Rrightarrow" #X021DB "⇛")
    ("mathrel" "\\Rsh" #X021B1 "↱")
    ("mathrel" "\\Searrow" #X021D8 "⇘")
    ("mathrel" "\\Subset" #X022D0 "⋐")
    ("mathrel" "\\Succ" #X02ABC "⪼")
    ("mathrel" "\\Supset" #X022D1 "⋑")
    ("mathrel" "\\Swarrow" #X021D9 "⇙")
    ("mathrel" "\\UUparrow" #X027F0 "⟰")
    ("mathrel" "\\Uparrow" #X021D1 "⇑")
    ("mathrel" "\\Updownarrow" #X021D5 "⇕")
    ("mathrel" "\\Uuparrow" #X0290A "⤊")
    ("mathrel" "\\VDash" #X022AB "⊫")
    ("mathrel" "\\Vbar" #X02AEB "⫫")
    ("mathrel" "\\Vdash" #X022A9 "⊩")
    ("mathrel" "\\Vvdash" #X022AA "⊪")
    ("mathrel" "\\acwcirclearrow" #X02940 "⥀")
    ("mathrel" "\\acwgapcirclearrow" #X027F2 "⟲")
    ("mathrel" "\\acwleftarcarrow" #X02939 "⤹")
    ("mathrel" "\\acwoverarcarrow" #X0293A "⤺")
    ("mathrel" "\\acwunderarcarrow" #X0293B "⤻")
    ("mathrel" "\\adots" #X022F0 "⋰")
    ("mathrel" "\\approx" #X02248 "≈")
    ("mathrel" "\\approxeq" #X0224A "≊")
    ("mathrel" "\\approxeqq" #X02A70 "⩰")
    ("mathrel" "\\approxident" #X0224B "≋")
    ("mathrel" "\\arceq" #X02258 "≘")
    ("mathrel" "\\assert" #X022A6 "⊦")
    ("mathrel" "\\asteq" #X02A6E "⩮")
    ("mathrel" "\\asymp" #X0224D "≍")
    ("mathrel" "\\bNot" #X02AED "⫭")
    ("mathrel" "\\backcong" #X0224C "≌")
    ("mathrel" "\\backsim" #X0223D "∽")
    ("mathrel" "\\backsimeq" #X022CD "⋍")
    ("mathrel" "\\bagmember" #X022FF "⋿")
    ("mathrel" "\\barV" #X02AEA "⫪")
    ("mathrel" "\\bardownharpoonleft" #X02961 "⥡")
    ("mathrel" "\\bardownharpoonright" #X0295D "⥝")
    ("mathrel" "\\barleftarrow" #X021E4 "⇤")
    ("mathrel" "\\barleftharpoondown" #X02956 "⥖")
    ("mathrel" "\\barleftharpoonup" #X02952 "⥒")
    ("mathrel" "\\barrightarrowdiamond" #X02920 "⤠")
    ("mathrel" "\\barrightharpoondown" #X0295F "⥟")
    ("mathrel" "\\barrightharpoonup" #X0295B "⥛")
    ("mathrel" "\\baruparrow" #X02912 "⤒")
    ("mathrel" "\\barupharpoonleft" #X02958 "⥘")
    ("mathrel" "\\barupharpoonright" #X02954 "⥔")
    ("mathrel" "\\between" #X0226C "≬")
    ("mathrel" "\\bowtie" #X022C8 "⋈")
    ("mathrel" "\\bsimilarleftarrow" #X02B41 "⭁")
    ("mathrel" "\\bsimilarrightarrow" #X02B47 "⭇")
    ("mathrel" "\\bsolhsub" #X027C8 "⟈")
    ("mathrel" "\\bumpeq" #X0224F "≏")
    ("mathrel" "\\bumpeqq" #X02AAE "⪮")
    ("mathrel" "\\ccwundercurvearrow" #X0293F "⤿")
    ("mathrel" "\\cirbot" #X027DF "⟟")
    ("mathrel" "\\circeq" #X02257 "≗")
    ("mathrel" "\\circleonleftarrow" #X02B30 "⬰")
    ("mathrel" "\\circleonrightarrow" #X021F4 "⇴")
    ("mathrel" "\\cirmid" #X02AEF "⫯")
    ("mathrel" "\\closure" #X02050 "⁐")
    ("mathrel" "\\coloneq" #X02254 "≔")
    ("mathrel" "\\cong" #X02245 "≅")
    ("mathrel" "\\congdot" #X02A6D "⩭")
    ("mathrel" "\\csub" #X02ACF "⫏")
    ("mathrel" "\\csube" #X02AD1 "⫑")
    ("mathrel" "\\csup" #X02AD0 "⫐")
    ("mathrel" "\\csupe" #X02AD2 "⫒")
    ("mathrel" "\\curlyeqprec" #X022DE "⋞")
    ("mathrel" "\\curlyeqsucc" #X022DF "⋟")
    ("mathrel" "\\curvearrowleft" #X021B6 "↶")
    ("mathrel" "\\curvearrowleftplus" #X0293D "⤽")
    ("mathrel" "\\curvearrowright" #X021B7 "↷")
    ("mathrel" "\\curvearrowrightminus" #X0293C "⤼")
    ("mathrel" "\\cwcirclearrow" #X02941 "⥁")
    ("mathrel" "\\cwgapcirclearrow" #X027F3 "⟳")
    ("mathrel" "\\cwrightarcarrow" #X02938 "⤸")
    ("mathrel" "\\cwundercurvearrow" #X0293E "⤾")
    ("mathrel" "\\dashV" #X02AE3 "⫣")
    ("mathrel" "\\dashVdash" #X027DB "⟛")
    ("mathrel" "\\dashcolon" #X02239 "∹")
    ("mathrel" "\\dashleftharpoondown" #X0296B "⥫")
    ("mathrel" "\\dashrightharpoondown" #X0296D "⥭")
    ("mathrel" "\\dashv" #X022A3 "⊣")
    ("mathrel" "\\dbkarow" #X0290F "⤏")
    ("mathrel" "\\ddots" #X022F1 "⋱")
    ("mathrel" "\\ddotseq" #X02A77 "⩷")
    ("mathrel" "\\diamondleftarrow" #X0291D "⤝")
    ("mathrel" "\\diamondleftarrowbar" #X0291F "⤟")
    ("mathrel" "\\disin" #X022F2 "⋲")
    ("mathrel" "\\doteq" #X02250 "≐")
    ("mathrel" "\\dotequiv" #X02A67 "⩧")
    ("mathrel" "\\dotsim" #X02A6A "⩪")
    ("mathrel" "\\dotsminusdots" #X0223A "∺")
    ("mathrel" "\\downarrow" #X02193 "↓")
    ("mathrel" "\\downarrowbar" #X02913 "⤓")
    ("mathrel" "\\downarrowbarred" #X02908 "⤈")
    ("mathrel" "\\downdownarrows" #X021CA "⇊")
    ("mathrel" "\\downfishtail" #X0297F "⥿")
    ("mathrel" "\\downharpoonleft" #X021C3 "⇃")
    ("mathrel" "\\downharpoonleftbar" #X02959 "⥙")
    ("mathrel" "\\downharpoonright" #X021C2 "⇂")
    ("mathrel" "\\downharpoonrightbar" #X02955 "⥕")
    ("mathrel" "\\downharpoonsleftright" #X02965 "⥥")
    ("mathrel" "\\downuparrows" #X021F5 "⇵")
    ("mathrel" "\\downupharpoonsleftright" #X0296F "⥯")
    ("mathrel" "\\downzigzagarrow" #X021AF "↯")
    ("mathrel" "\\drbkarow" #X02910 "⤐")
    ("mathrel" "\\dualmap" #X029DF "⧟")
    ("mathrel" "\\egsdot" #X02A98 "⪘")
    ("mathrel" "\\elsdot" #X02A97 "⪗")
    ("mathrel" "\\eparsl" #X029E3 "⧣")
    ("mathrel" "\\eqcirc" #X02256 "≖")
    ("mathrel" "\\eqcolon" #X02255 "≕")
    ("mathrel" "\\eqdef" #X0225D "≝")
    ("mathrel" "\\eqdot" #X02A66 "⩦")
    ("mathrel" "\\eqeq" #X02A75 "⩵")
    ("mathrel" "\\eqeqeq" #X02A76 "⩶")
    ("mathrel" "\\eqgtr" #X022DD "⋝")
    ("mathrel" "\\eqless" #X022DC "⋜")
    ("mathrel" "\\eqqgtr" #X02A9A "⪚")
    ("mathrel" "\\eqqless" #X02A99 "⪙")
    ("mathrel" "\\eqqsim" #X02A73 "⩳")
    ("mathrel" "\\eqqslantgtr" #X02A9C "⪜")
    ("mathrel" "\\eqqslantless" #X02A9B "⪛")
    ("mathrel" "\\eqsim" #X02242 "≂")
    ("mathrel" "\\eqslantgtr" #X02A96 "⪖")
    ("mathrel" "\\eqslantless" #X02A95 "⪕")
    ("mathrel" "\\equal" #X0003D "=")
    ("mathrel" "\\equalleftarrow" #X02B40 "⭀")
    ("mathrel" "\\equalparallel" #X022D5 "⋕")
    ("mathrel" "\\equalrightarrow" #X02971 "⥱")
    ("mathrel" "\\equiv" #X02261 "≡")
    ("mathrel" "\\equivDD" #X02A78 "⩸")
    ("mathrel" "\\equivVert" #X02A68 "⩨")
    ("mathrel" "\\equivVvert" #X02A69 "⩩")
    ("mathrel" "\\eqvparsl" #X029E5 "⧥")
    ("mathrel" "\\fallingdotseq" #X02252 "≒")
    ("mathrel" "\\fbowtie" #X029D3 "⧓")
    ("mathrel" "\\forks" #X02ADC "⫝̸")
    ("mathrel" "\\forksnot" #X02ADD "⫝")
    ("mathrel" "\\forkv" #X02AD9 "⫙")
    ("mathrel" "\\frown" #X02322 "⌢")
    ("mathrel" "\\geq" #X02265 "≥")
    ("mathrel" "\\geqq" #X02267 "≧")
    ("mathrel" "\\geqqslant" #X02AFA "⫺")
    ("mathrel" "\\geqslant" #X02A7E "⩾")
    ("mathrel" "\\gescc" #X02AA9 "⪩")
    ("mathrel" "\\gesdot" #X02A80 "⪀")
    ("mathrel" "\\gesdoto" #X02A82 "⪂")
    ("mathrel" "\\gesdotol" #X02A84 "⪄")
    ("mathrel" "\\gesles" #X02A94 "⪔")
    ("mathrel" "\\gg" #X0226B "≫")
    ("mathrel" "\\ggg" #X022D9 "⋙")
    ("mathrel" "\\gggnest" #X02AF8 "⫸")
    ("mathrel" "\\glE" #X02A92 "⪒")
    ("mathrel" "\\gla" #X02AA5 "⪥")
    ("mathrel" "\\gleichstark" #X029E6 "⧦")
    ("mathrel" "\\glj" #X02AA4 "⪤")
    ("mathrel" "\\gnapprox" #X02A8A "⪊")
    ("mathrel" "\\gneq" #X02A88 "⪈")
    ("mathrel" "\\gneqq" #X02269 "≩")
    ("mathrel" "\\gnsim" #X022E7 "⋧")
    ("mathrel" "\\greater" #X0003E ">")
    ("mathrel" "\\gsime" #X02A8E "⪎")
    ("mathrel" "\\gsiml" #X02A90 "⪐")
    ("mathrel" "\\gtcc" #X02AA7 "⪧")
    ("mathrel" "\\gtcir" #X02A7A "⩺")
    ("mathrel" "\\gtquest" #X02A7C "⩼")
    ("mathrel" "\\gtrapprox" #X02A86 "⪆")
    ("mathrel" "\\gtrarr" #X02978 "⥸")
    ("mathrel" "\\gtrdot" #X022D7 "⋗")
    ("mathrel" "\\gtreqless" #X022DB "⋛")
    ("mathrel" "\\gtreqqless" #X02A8C "⪌")
    ("mathrel" "\\gtrless" #X02277 "≷")
    ("mathrel" "\\gtrsim" #X02273 "≳")
    ("mathrel" "\\hatapprox" #X02A6F "⩯")
    ("mathrel" "\\hknearrow" #X02924 "⤤")
    ("mathrel" "\\hknwarrow" #X02923 "⤣")
    ("mathrel" "\\hksearow" #X02925 "⤥")
    ("mathrel" "\\hkswarow" #X02926 "⤦")
    ("mathrel" "\\hookleftarrow" #X021A9 "↩")
    ("mathrel" "\\hookrightarrow" #X021AA "↪")
    ("mathrel" "\\imageof" #X022B7 "⊷")
    ("mathrel" "\\in" #X02208 "∈")
    ("mathrel" "\\isinE" #X022F9 "⋹")
    ("mathrel" "\\isindot" #X022F5 "⋵")
    ("mathrel" "\\isinobar" #X022F7 "⋷")
    ("mathrel" "\\isins" #X022F4 "⋴")
    ("mathrel" "\\isinvb" #X022F8 "⋸")
    ("mathrel" "\\kernelcontraction" #X0223B "∻")
    ("mathrel" "\\lat" #X02AAB "⪫")
    ("mathrel" "\\late" #X02AAD "⪭")
    ("mathrel" "\\leftarrow" #X02190 "←")
    ("mathrel" "\\leftarrowapprox" #X02B4A "⭊")
    ("mathrel" "\\leftarrowbackapprox" #X02B42 "⭂")
    ("mathrel" "\\leftarrowbsimilar" #X02B4B "⭋")
    ("mathrel" "\\leftarrowless" #X02977 "⥷")
    ("mathrel" "\\leftarrowonoplus" #X02B32 "⬲")
    ("mathrel" "\\leftarrowplus" #X02946 "⥆")
    ("mathrel" "\\leftarrowshortrightarrow" #X02943 "⥃")
    ("mathrel" "\\leftarrowsimilar" #X02973 "⥳")
    ("mathrel" "\\leftarrowsubset" #X0297A "⥺")
    ("mathrel" "\\leftarrowtail" #X021A2 "↢")
    ("mathrel" "\\leftarrowtriangle" #X021FD "⇽")
    ("mathrel" "\\leftarrowx" #X02B3E "⬾")
    ("mathrel" "\\leftbkarrow" #X0290C "⤌")
    ("mathrel" "\\leftcurvedarrow" #X02B3F "⬿")
    ("mathrel" "\\leftdbkarrow" #X0290E "⤎")
    ("mathrel" "\\leftdbltail" #X0291B "⤛")
    ("mathrel" "\\leftdotarrow" #X02B38 "⬸")
    ("mathrel" "\\leftdowncurvedarrow" #X02936 "⤶")
    ("mathrel" "\\leftfishtail" #X0297C "⥼")
    ("mathrel" "\\leftharpoondown" #X021BD "↽")
    ("mathrel" "\\leftharpoondownbar" #X0295E "⥞")
    ("mathrel" "\\leftharpoonsupdown" #X02962 "⥢")
    ("mathrel" "\\leftharpoonup" #X021BC "↼")
    ("mathrel" "\\leftharpoonupbar" #X0295A "⥚")
    ("mathrel" "\\leftharpoonupdash" #X0296A "⥪")
    ("mathrel" "\\leftleftarrows" #X021C7 "⇇")
    ("mathrel" "\\leftrightarrow" #X02194 "↔")
    ("mathrel" "\\leftrightarrowcircle" #X02948 "⥈")
    ("mathrel" "\\leftrightarrows" #X021C6 "⇆")
    ("mathrel" "\\leftrightarrowtriangle" #X021FF "⇿")
    ("mathrel" "\\leftrightharpoondowndown" #X02950 "⥐")
    ("mathrel" "\\leftrightharpoondownup" #X0294B "⥋")
    ("mathrel" "\\leftrightharpoons" #X021CB "⇋")
    ("mathrel" "\\leftrightharpoonsdown" #X02967 "⥧")
    ("mathrel" "\\leftrightharpoonsup" #X02966 "⥦")
    ("mathrel" "\\leftrightharpoonupdown" #X0294A "⥊")
    ("mathrel" "\\leftrightharpoonupup" #X0294E "⥎")
    ("mathrel" "\\leftrightsquigarrow" #X021AD "↭")
    ("mathrel" "\\leftsquigarrow" #X021DC "⇜")
    ("mathrel" "\\lefttail" #X02919 "⤙")
    ("mathrel" "\\leftthreearrows" #X02B31 "⬱")
    ("mathrel" "\\leftwavearrow" #X0219C "↜")
    ("mathrel" "\\leq" #X02264 "≤")
    ("mathrel" "\\leqq" #X02266 "≦")
    ("mathrel" "\\leqqslant" #X02AF9 "⫹")
    ("mathrel" "\\leqslant" #X02A7D "⩽")
    ("mathrel" "\\lescc" #X02AA8 "⪨")
    ("mathrel" "\\lesdot" #X02A7F "⩿")
    ("mathrel" "\\lesdoto" #X02A81 "⪁")
    ("mathrel" "\\lesdotor" #X02A83 "⪃")
    ("mathrel" "\\lesges" #X02A93 "⪓")
    ("mathrel" "\\less" #X0003C "<")
    ("mathrel" "\\lessapprox" #X02A85 "⪅")
    ("mathrel" "\\lessdot" #X022D6 "⋖")
    ("mathrel" "\\lesseqgtr" #X022DA "⋚")
    ("mathrel" "\\lesseqqgtr" #X02A8B "⪋")
    ("mathrel" "\\lessgtr" #X02276 "≶")
    ("mathrel" "\\lesssim" #X02272 "≲")
    ("mathrel" "\\lfbowtie" #X029D1 "⧑")
    ("mathrel" "\\lftimes" #X029D4 "⧔")
    ("mathrel" "\\lgE" #X02A91 "⪑")
    ("mathrel" "\\ll" #X0226A "≪")
    ("mathrel" "\\lll" #X022D8 "⋘")
    ("mathrel" "\\lllnest" #X02AF7 "⫷")
    ("mathrel" "\\lnapprox" #X02A89 "⪉")
    ("mathrel" "\\lneq" #X02A87 "⪇")
    ("mathrel" "\\lneqq" #X02268 "≨")
    ("mathrel" "\\lnsim" #X022E6 "⋦")
    ("mathrel" "\\longdashv" #X027DE "⟞")
    ("mathrel" "\\longleftarrow" #X027F5 "⟵")
    ("mathrel" "\\longleftrightarrow" #X027F7 "⟷")
    ("mathrel" "\\longleftsquigarrow" #X02B33 "⬳")
    ("mathrel" "\\longmapsfrom" #X027FB "⟻")
    ("mathrel" "\\longmapsto" #X027FC "⟼")
    ("mathrel" "\\longrightarrow" #X027F6 "⟶")
    ("mathrel" "\\longrightsquigarrow" #X027FF "⟿")
    ("mathrel" "\\looparrowleft" #X021AB "↫")
    ("mathrel" "\\looparrowright" #X021AC "↬")
    ("mathrel" "\\lrtriangleeq" #X029E1 "⧡")
    ("mathrel" "\\lsime" #X02A8D "⪍")
    ("mathrel" "\\lsimg" #X02A8F "⪏")
    ("mathrel" "\\lsqhook" #X02ACD "⫍")
    ("mathrel" "\\ltcc" #X02AA6 "⪦")
    ("mathrel" "\\ltcir" #X02A79 "⩹")
    ("mathrel" "\\ltlarr" #X02976 "⥶")
    ("mathrel" "\\ltquest" #X02A7B "⩻")
    ("mathrel" "\\ltrivb" #X029CF "⧏")
    ("mathrel" "\\mapsdown" #X021A7 "↧")
    ("mathrel" "\\mapsfrom" #X021A4 "↤")
    ("mathrel" "\\mapsto" #X021A6 "↦")
    ("mathrel" "\\mapsup" #X021A5 "↥")
    ("mathrel" "\\mathratio" #X02236 "∶")
    ("mathrel" "\\measeq" #X0225E "≞")
    ("mathrel" "\\mid" #X02223 "∣")
    ("mathrel" "\\midcir" #X02AF0 "⫰")
    ("mathrel" "\\mlcp" #X02ADB "⫛")
    ("mathrel" "\\models" #X022A7 "⊧")
    ("mathrel" "\\multimap" #X022B8 "⊸")
    ("mathrel" "\\multimapinv" #X027DC "⟜")
    ("mathrel" "\\nLeftarrow" #X021CD "⇍")
    ("mathrel" "\\nLeftrightarrow" #X021CE "⇎")
    ("mathrel" "\\nRightarrow" #X021CF "⇏")
    ("mathrel" "\\nVDash" #X022AF "⊯")
    ("mathrel" "\\nVdash" #X022AE "⊮")
    ("mathrel" "\\nVleftarrow" #X021FA "⇺")
    ("mathrel" "\\nVleftarrowtail" #X02B3A "⬺")
    ("mathrel" "\\nVleftrightarrow" #X021FC "⇼")
    ("mathrel" "\\nVrightarrow" #X021FB "⇻")
    ("mathrel" "\\nVrightarrowtail" #X02915 "⤕")
    ("mathrel" "\\nVtwoheadleftarrow" #X02B35 "⬵")
    ("mathrel" "\\nVtwoheadleftarrowtail" #X02B3D "⬽")
    ("mathrel" "\\nVtwoheadrightarrow" #X02901 "⤁")
    ("mathrel" "\\nVtwoheadrightarrowtail" #X02918 "⤘")
    ("mathrel" "\\napprox" #X02249 "≉")
    ("mathrel" "\\nasymp" #X0226D "≭")
    ("mathrel" "\\ncong" #X02247 "≇")
    ("mathrel" "\\ne" #X02260 "≠")
    ("mathrel" "\\nearrow" #X02197 "↗")
    ("mathrel" "\\nequiv" #X02262 "≢")
    ("mathrel" "\\neswarrow" #X02922 "⤢")
    ("mathrel" "\\ngeq" #X02271 "≱")
    ("mathrel" "\\ngtr" #X0226F "≯")
    ("mathrel" "\\ngtrless" #X02279 "≹")
    ("mathrel" "\\ngtrsim" #X02275 "≵")
    ("mathrel" "\\nhpar" #X02AF2 "⫲")
    ("mathrel" "\\ni" #X0220B "∋")
    ("mathrel" "\\niobar" #X022FE "⋾")
    ("mathrel" "\\nis" #X022FC "⋼")
    ("mathrel" "\\nisd" #X022FA "⋺")
    ("mathrel" "\\nleftarrow" #X0219A "↚")
    ("mathrel" "\\nleftrightarrow" #X021AE "↮")
    ("mathrel" "\\nleq" #X02270 "≰")
    ("mathrel" "\\nless" #X0226E "≮")
    ("mathrel" "\\nlessgtr" #X02278 "≸")
    ("mathrel" "\\nlesssim" #X02274 "≴")
    ("mathrel" "\\nmid" #X02224 "∤")
    ("mathrel" "\\nni" #X0220C "∌")
    ("mathrel" "\\notin" #X02209 "∉")
    ("mathrel" "\\nparallel" #X02226 "∦")
    ("mathrel" "\\nprec" #X02280 "⊀")
    ("mathrel" "\\npreccurlyeq" #X022E0 "⋠")
    ("mathrel" "\\nrightarrow" #X0219B "↛")
    ("mathrel" "\\nsim" #X02241 "≁")
    ("mathrel" "\\nsime" #X02244 "≄")
    ("mathrel" "\\nsqsubseteq" #X022E2 "⋢")
    ("mathrel" "\\nsqsupseteq" #X022E3 "⋣")
    ("mathrel" "\\nsubset" #X02284 "⊄")
    ("mathrel" "\\nsubseteq" #X02288 "⊈")
    ("mathrel" "\\nsucc" #X02281 "⊁")
    ("mathrel" "\\nsucccurlyeq" #X022E1 "⋡")
    ("mathrel" "\\nsupset" #X02285 "⊅")
    ("mathrel" "\\nsupseteq" #X02289 "⊉")
    ("mathrel" "\\ntriangleleft" #X022EA "⋪")
    ("mathrel" "\\ntrianglelefteq" #X022EC "⋬")
    ("mathrel" "\\ntriangleright" #X022EB "⋫")
    ("mathrel" "\\ntrianglerighteq" #X022ED "⋭")
    ("mathrel" "\\nvDash" #X022AD "⊭")
    ("mathrel" "\\nvLeftarrow" #X02902 "⤂")
    ("mathrel" "\\nvLeftrightarrow" #X02904 "⤄")
    ("mathrel" "\\nvRightarrow" #X02903 "⤃")
    ("mathrel" "\\nvdash" #X022AC "⊬")
    ("mathrel" "\\nvleftarrow" #X021F7 "⇷")
    ("mathrel" "\\nvleftarrowtail" #X02B39 "⬹")
    ("mathrel" "\\nvleftrightarrow" #X021F9 "⇹")
    ("mathrel" "\\nvrightarrow" #X021F8 "⇸")
    ("mathrel" "\\nvrightarrowtail" #X02914 "⤔")
    ("mathrel" "\\nvtwoheadleftarrow" #X02B34 "⬴")
    ("mathrel" "\\nvtwoheadleftarrowtail" #X02B3C "⬼")
    ("mathrel" "\\nvtwoheadrightarrow" #X02900 "⤀")
    ("mathrel" "\\nvtwoheadrightarrowtail" #X02917 "⤗")
    ("mathrel" "\\nwarrow" #X02196 "↖")
    ("mathrel" "\\nwsearrow" #X02921 "⤡")
    ("mathrel" "\\origof" #X022B6 "⊶")
    ("mathrel" "\\parallel" #X02225 "∥")
    ("mathrel" "\\parsim" #X02AF3 "⫳")
    ("mathrel" "\\partialmeetcontraction" #X02AA3 "⪣")
    ("mathrel" "\\perp" #X027C2 "⟂")
    ("mathrel" "\\pitchfork" #X022D4 "⋔")
    ("mathrel" "\\prec" #X0227A "≺")
    ("mathrel" "\\precapprox" #X02AB7 "⪷")
    ("mathrel" "\\preccurlyeq" #X0227C "≼")
    ("mathrel" "\\preceq" #X02AAF "⪯")
    ("mathrel" "\\preceqq" #X02AB3 "⪳")
    ("mathrel" "\\precnapprox" #X02AB9 "⪹")
    ("mathrel" "\\precneq" #X02AB1 "⪱")
    ("mathrel" "\\precneqq" #X02AB5 "⪵")
    ("mathrel" "\\precnsim" #X022E8 "⋨")
    ("mathrel" "\\precsim" #X0227E "≾")
    ("mathrel" "\\propto" #X0221D "∝")
    ("mathrel" "\\prurel" #X022B0 "⊰")
    ("mathrel" "\\pullback" #X027D3 "⟓")
    ("mathrel" "\\pushout" #X027D4 "⟔")
    ("mathrel" "\\questeq" #X0225F "≟")
    ("mathrel" "\\revnmid" #X02AEE "⫮")
    ("mathrel" "\\rfbowtie" #X029D2 "⧒")
    ("mathrel" "\\rftimes" #X029D5 "⧕")
    ("mathrel" "\\rightarrow" #X02192 "→")
    ("mathrel" "\\rightarrowapprox" #X02975 "⥵")
    ("mathrel" "\\rightarrowbackapprox" #X02B48 "⭈")
    ("mathrel" "\\rightarrowbar" #X021E5 "⇥")
    ("mathrel" "\\rightarrowbsimilar" #X02B4C "⭌")
    ("mathrel" "\\rightarrowdiamond" #X0291E "⤞")
    ("mathrel" "\\rightarrowgtr" #X02B43 "⭃")
    ("mathrel" "\\rightarrowonoplus" #X027F4 "⟴")
    ("mathrel" "\\rightarrowplus" #X02945 "⥅")
    ("mathrel" "\\rightarrowshortleftarrow" #X02942 "⥂")
    ("mathrel" "\\rightarrowsimilar" #X02974 "⥴")
    ("mathrel" "\\rightarrowsupset" #X02B44 "⭄")
    ("mathrel" "\\rightarrowtail" #X021A3 "↣")
    ("mathrel" "\\rightarrowtriangle" #X021FE "⇾")
    ("mathrel" "\\rightarrowx" #X02947 "⥇")
    ("mathrel" "\\rightbkarrow" #X0290D "⤍")
    ("mathrel" "\\rightcurvedarrow" #X02933 "⤳")
    ("mathrel" "\\rightdbltail" #X0291C "⤜")
    ("mathrel" "\\rightdotarrow" #X02911 "⤑")
    ("mathrel" "\\rightdowncurvedarrow" #X02937 "⤷")
    ("mathrel" "\\rightfishtail" #X0297D "⥽")
    ("mathrel" "\\rightharpoondown" #X021C1 "⇁")
    ("mathrel" "\\rightharpoondownbar" #X02957 "⥗")
    ("mathrel" "\\rightharpoonsupdown" #X02964 "⥤")
    ("mathrel" "\\rightharpoonup" #X021C0 "⇀")
    ("mathrel" "\\rightharpoonupbar" #X02953 "⥓")
    ("mathrel" "\\rightharpoonupdash" #X0296C "⥬")
    ("mathrel" "\\rightimply" #X02970 "⥰")
    ("mathrel" "\\rightleftarrows" #X021C4 "⇄")
    ("mathrel" "\\rightleftharpoons" #X021CC "⇌")
    ("mathrel" "\\rightleftharpoonsdown" #X02969 "⥩")
    ("mathrel" "\\rightleftharpoonsup" #X02968 "⥨")
    ("mathrel" "\\rightrightarrows" #X021C9 "⇉")
    ("mathrel" "\\rightsquigarrow" #X021DD "⇝")
    ("mathrel" "\\righttail" #X0291A "⤚")
    ("mathrel" "\\rightthreearrows" #X021F6 "⇶")
    ("mathrel" "\\rightwavearrow" #X0219D "↝")
    ("mathrel" "\\risingdotseq" #X02253 "≓")
    ("mathrel" "\\rsqhook" #X02ACE "⫎")
    ("mathrel" "\\rtriltri" #X029CE "⧎")
    ("mathrel" "\\ruledelayed" #X029F4 "⧴")
    ("mathrel" "\\scurel" #X022B1 "⊱")
    ("mathrel" "\\searrow" #X02198 "↘")
    ("mathrel" "\\shortdowntack" #X02ADF "⫟")
    ("mathrel" "\\shortlefttack" #X02ADE "⫞")
    ("mathrel" "\\shortrightarrowleftarrow" #X02944 "⥄")
    ("mathrel" "\\shortuptack" #X02AE0 "⫠")
    ("mathrel" "\\sim" #X0223C "∼")
    ("mathrel" "\\simeq" #X02243 "≃")
    ("mathrel" "\\simgE" #X02AA0 "⪠")
    ("mathrel" "\\simgtr" #X02A9E "⪞")
    ("mathrel" "\\similarleftarrow" #X02B49 "⭉")
    ("mathrel" "\\similarrightarrow" #X02972 "⥲")
    ("mathrel" "\\simlE" #X02A9F "⪟")
    ("mathrel" "\\simless" #X02A9D "⪝")
    ("mathrel" "\\simminussim" #X02A6C "⩬")
    ("mathrel" "\\simneqq" #X02246 "≆")
    ("mathrel" "\\simrdots" #X02A6B "⩫")
    ("mathrel" "\\smallin" #X0220A "∊")
    ("mathrel" "\\smallni" #X0220D "∍")
    ("mathrel" "\\smeparsl" #X029E4 "⧤")
    ("mathrel" "\\smile" #X02323 "⌣")
    ("mathrel" "\\smt" #X02AAA "⪪")
    ("mathrel" "\\smte" #X02AAC "⪬")
    ("mathrel" "\\sqsubset" #X0228F "⊏")
    ("mathrel" "\\sqsubseteq" #X02291 "⊑")
    ("mathrel" "\\sqsubsetneq" #X022E4 "⋤")
    ("mathrel" "\\sqsupset" #X02290 "⊐")
    ("mathrel" "\\sqsupseteq" #X02292 "⊒")
    ("mathrel" "\\sqsupsetneq" #X022E5 "⋥")
    ("mathrel" "\\stareq" #X0225B "≛")
    ("mathrel" "\\subedot" #X02AC3 "⫃")
    ("mathrel" "\\submult" #X02AC1 "⫁")
    ("mathrel" "\\subrarr" #X02979 "⥹")
    ("mathrel" "\\subset" #X02282 "⊂")
    ("mathrel" "\\subsetapprox" #X02AC9 "⫉")
    ("mathrel" "\\subsetdot" #X02ABD "⪽")
    ("mathrel" "\\subseteq" #X02286 "⊆")
    ("mathrel" "\\subseteqq" #X02AC5 "⫅")
    ("mathrel" "\\subsetneq" #X0228A "⊊")
    ("mathrel" "\\subsetneqq" #X02ACB "⫋")
    ("mathrel" "\\subsetplus" #X02ABF "⪿")
    ("mathrel" "\\subsim" #X02AC7 "⫇")
    ("mathrel" "\\subsub" #X02AD5 "⫕")
    ("mathrel" "\\subsup" #X02AD3 "⫓")
    ("mathrel" "\\succ" #X0227B "≻")
    ("mathrel" "\\succapprox" #X02AB8 "⪸")
    ("mathrel" "\\succcurlyeq" #X0227D "≽")
    ("mathrel" "\\succeq" #X02AB0 "⪰")
    ("mathrel" "\\succeqq" #X02AB4 "⪴")
    ("mathrel" "\\succnapprox" #X02ABA "⪺")
    ("mathrel" "\\succneq" #X02AB2 "⪲")
    ("mathrel" "\\succneqq" #X02AB6 "⪶")
    ("mathrel" "\\succnsim" #X022E9 "⋩")
    ("mathrel" "\\succsim" #X0227F "≿")
    ("mathrel" "\\supdsub" #X02AD8 "⫘")
    ("mathrel" "\\supedot" #X02AC4 "⫄")
    ("mathrel" "\\suphsol" #X027C9 "⟉")
    ("mathrel" "\\suphsub" #X02AD7 "⫗")
    ("mathrel" "\\suplarr" #X0297B "⥻")
    ("mathrel" "\\supmult" #X02AC2 "⫂")
    ("mathrel" "\\supset" #X02283 "⊃")
    ("mathrel" "\\supsetapprox" #X02ACA "⫊")
    ("mathrel" "\\supsetdot" #X02ABE "⪾")
    ("mathrel" "\\supseteq" #X02287 "⊇")
    ("mathrel" "\\supseteqq" #X02AC6 "⫆")
    ("mathrel" "\\supsetneq" #X0228B "⊋")
    ("mathrel" "\\supsetneqq" #X02ACC "⫌")
    ("mathrel" "\\supsetplus" #X02AC0 "⫀")
    ("mathrel" "\\supsim" #X02AC8 "⫈")
    ("mathrel" "\\supsub" #X02AD4 "⫔")
    ("mathrel" "\\supsup" #X02AD6 "⫖")
    ("mathrel" "\\swarrow" #X02199 "↙")
    ("mathrel" "\\toea" #X02928 "⤨")
    ("mathrel" "\\tona" #X02927 "⤧")
    ("mathrel" "\\topfork" #X02ADA "⫚")
    ("mathrel" "\\tosa" #X02929 "⤩")
    ("mathrel" "\\towa" #X0292A "⤪")
    ("mathrel" "\\trianglelefteq" #X022B4 "⊴")
    ("mathrel" "\\triangleq" #X0225C "≜")
    ("mathrel" "\\trianglerighteq" #X022B5 "⊵")
    ("mathrel" "\\twoheaddownarrow" #X021A1 "↡")
    ("mathrel" "\\twoheadleftarrow" #X0219E "↞")
    ("mathrel" "\\twoheadleftarrowtail" #X02B3B "⬻")
    ("mathrel" "\\twoheadleftdbkarrow" #X02B37 "⬷")
    ("mathrel" "\\twoheadmapsfrom" #X02B36 "⬶")
    ("mathrel" "\\twoheadmapsto" #X02905 "⤅")
    ("mathrel" "\\twoheadrightarrow" #X021A0 "↠")
    ("mathrel" "\\twoheadrightarrowtail" #X02916 "⤖")
    ("mathrel" "\\twoheaduparrow" #X0219F "↟")
    ("mathrel" "\\twoheaduparrowcircle" #X02949 "⥉")
    ("mathrel" "\\uparrow" #X02191 "↑")
    ("mathrel" "\\uparrowbarred" #X02909 "⤉")
    ("mathrel" "\\updownarrow" #X02195 "↕")
    ("mathrel" "\\updownarrows" #X021C5 "⇅")
    ("mathrel" "\\updownharpoonleftleft" #X02951 "⥑")
    ("mathrel" "\\updownharpoonleftright" #X0294D "⥍")
    ("mathrel" "\\updownharpoonrightleft" #X0294C "⥌")
    ("mathrel" "\\updownharpoonrightright" #X0294F "⥏")
    ("mathrel" "\\updownharpoonsleftright" #X0296E "⥮")
    ("mathrel" "\\upfishtail" #X0297E "⥾")
    ("mathrel" "\\upharpoonleft" #X021BF "↿")
    ("mathrel" "\\upharpoonleftbar" #X02960 "⥠")
    ("mathrel" "\\upharpoonright" #X021BE "↾")
    ("mathrel" "\\upharpoonrightbar" #X0295C "⥜")
    ("mathrel" "\\upharpoonsleftright" #X02963 "⥣")
    ("mathrel" "\\upin" #X027D2 "⟒")
    ("mathrel" "\\upuparrows" #X021C8 "⇈")
    ("mathrel" "\\vBar" #X02AE8 "⫨")
    ("mathrel" "\\vBarv" #X02AE9 "⫩")
    ("mathrel" "\\vDash" #X022A8 "⊨")
    ("mathrel" "\\vDdash" #X02AE2 "⫢")
    ("mathrel" "\\varVdash" #X02AE6 "⫦")
    ("mathrel" "\\varisinobar" #X022F6 "⋶")
    ("mathrel" "\\varisins" #X022F3 "⋳")
    ("mathrel" "\\varniobar" #X022FD "⋽")
    ("mathrel" "\\varnis" #X022FB "⋻")
    ("mathrel" "\\vartriangleleft" #X022B2 "⊲")
    ("mathrel" "\\vartriangleright" #X022B3 "⊳")
    ("mathrel" "\\vbrtri" #X029D0 "⧐")
    ("mathrel" "\\vdash" #X022A2 "⊢")
    ("mathrel" "\\vdots" #X022EE "⋮")
    ("mathrel" "\\veeeq" #X0225A "≚")
    ("mathrel" "\\veeonwedge" #X02A59 "⩙")
    ("mathrel" "\\vlongdash" #X027DD "⟝")
    ("mathrel" "\\wedgeq" #X02259 "≙")
    ("mathunder" "\\underbrace" #X023DF "⏟")
    ("mathunder" "\\underbracket" #X023B5 "⎵")
    ("mathunder" "\\underparen" #X023DD "⏝"))
  "Extended list of mathematical symbols.
Taken from http://milde.users.sourceforge.net/LUCR/Math/ and
prepared with `msl--read-LUCR-list' function. This list does not
contain some (about 190) of the standard LaTeX math commands in
`math-symbol-list-basic' because they are named differently in
unicode-math standard.")

(defconst math-symbol-list-latex-commands
  '("address" "addtocounter" "addtolength" "addvspace" "Alph" "alph" "Alph
    example" "alsoname" "and for author" "appendix" "arabic" "arraycolsep"
    "arrayrulewidth" "arraystretch" "baselineskip"
    "baselinestretch" "begin" "bf" "bfseries" "bibitem" "bibliography"
    "bibliographystyle" "bigskip" "bigskipamount" "bmod" "boldmath"
    "bottomfraction" "cal" "caption" "cc" "centering"
    "chapter" "circle" "cite" "cleardoublepage" "clearpage" "cline" "closing"
    "columnsep" "columnseprule" "columnwidth" "contentsline" "copyright"
    "dag" "dashbox" "day" "dblfloatpagefraction"
    "dblfloatsep" "dbltextfloatsep" "dbltopfraction" "ddag" "depth"
    "displaystyle" "documentclass" "dotfill" "doublerulesep" "emph" "encl"
    "enlargethispage" "enumi" "enumii" "enumiii" "enumiv" "evensidemargin"
    "fbox" "fboxrule" "fboxsep" "fill" "floatpagefraction" "floatsep"
    "flushbottom" "fnsymbol" "fontencoding" "fontfamily" "fontseries"
    "fontshape" "fontsize" "footnote" "footnotemark" "footnoterule"
    "footnotesep" "footnotesize" "footnotetext" "footskip" "frame" "framebox"
    "fussy" "gets" "glossary" "glossaryentry"
    "headheight" "headsep" "height" "hfill" "hline" "hrulefill" "hspace"
    "Huge" "huge" "hyphenation" "iff" "include" "includeonly"
    "indent" "index" "indexentry" "input" "intextsep"
    "item" "itemindent" "itemsep" "itshape" "kill"
    "label" "labelenumi" "labelenumii" "labelenumiii" "labelenumiv"
    "labelitemi" "labelitemii" "labelitemiii" "labelitemiv" "labelsep"
    "labelwidth" "land" "LARGE" "Large" "large" "LaTeX" "le" "left" "leadsto"
    "lefteqn" "leftmargin" "leftmargini" "leftmarginii" "leftmarginiii"
    "leftmarginiv" "leftmarginv" "leftmarginvi" "line" "linebreak"
    "linethickness" "linewidth" "listoffigures" "listoftables" "listparindent"
    "lnot" "location" "lor" "lq" "makebox" "makebox " "makeglossary"
    "makeindex" "makelabels" "maketitle" "marginpar" "marginparpush"
    "marginparsep" "marginparwidth" "mathbf" "mathcal" "mathnormal" "mathrm"
    "mathsf" "mathtt" "mathversion" "mbox" "mdseries" "medskip"
    "medskipamount" "month" "multicolumn" "multiput" "name" "newcommand"
    "newcounter" "newenvironment" "newfont" "newlength" "NEWLINE" "newline"
    "newpage" "newsavebox" "newtheorem" "nocite" "nofiles" "noindent"
    "nolinebreak" "nonumber" "nopagebreak" "normalfont" "normalmarginpar"
    "normalsize" "oe" "onecolumn" "opening" "oval" "owns" "P" "pagebreak" "pagenumbering"
    "pageref" "pagestyle" "paragraph" "parbox" "parindent"
    "parsep" "parskip" "parskip example" "part" "partopsep" "pmod" "poptabs"
    "pounds" "protect" "ps" "pushtabs" "put" "raggedbottom" "raggedleft"
    "raggedright" "raisebox" "ref" "refstepcounter" "renewenvironment"
    "restorecr" "reversemarginpar" "right" "rightmargin" "rm" "rmfamily"
    "roman" "rq" "rule" "savebox" "sbox" "sc" "scriptsize" "scshape"
    "section" "seename" "selectfont" "setcounter" "setlength" "settodepth"
    "settoheight" "settowidth" "sf" "sffamily" "shortstack" "signature" "sl"
    "slshape" "small" "smallint" "smallskip" "smallskipamount" "SPACE" "ss"
    "startbreaks" "stepcounter" "stop" "stopbreaks" "subparagraph"
    "subsection" "subsubsection" "symbol" "TAB"
    "tabbingsep" "tabcolsep" "tableofcontents" "telephone" "TeX" "textbf"
    "textfloatsep" "textfraction" "textheight" "textit" "textmd" "textnormal"
    "textrm" "textsc" "textsf" "textsl" "texttt" "textup" "textwidth"
    "thicklines" "thinlines" "thinspace" "thispagestyle" "tiny" "to" "today"
    "topfraction" "topmargin" "topsep" "topskip" "totalheight" "tt" "ttfamily"
    "twocolumn" "typein" "typeout" "u " "unboldmath"
    "unitlength" "upshape" "usebox" "usecounter" "usefont" "usepackage"
    "value" "vector" "verb" "vert" "vfill" "vline" "vspace"
    "width" "year")
  "List of the latex commands.")


;; IMPORT UTILITIES

(defun msl--read-LUCR-list (file &optional print)
  "Read in LUCR list from [1] and optionally PRINT.
LUCR list is a super-set of unicode-math list [2]. FILE is a
local file from [3].

 [1] http://milde.users.sourceforge.net/LUCR/Math/
 [2] https://github.com/wspr/unicode-math/blob/master/unicode-math-table.tex
 [3] http://milde.users.sourceforge.net/LUCR/Math/data/unimathsymbols.txt
"
  (let* ((lines (with-temp-buffer
                  (insert-file-contents file)
                  (split-string (buffer-string) "\n" t)))
         (symb (cl-loop for l in lines
                        unless (string-match-p "^#" l)
                        for words = (split-string l "\\^")
                        if (> (length (nth 3 words)) 0)
                        collect (list (nth 5 words) (nth 3 words) (nth 0 words) (substring (nth 1 words) -1))
                        ;; if (and (> (length (nth 3 words)) 0)
                        ;;         (not (string= (nth 2 words) (nth 3 words))))
                        ;; collect (list (nth 5 words) (nth 2 words) (nth 0 words) (substring (nth 1 words) -1))
                        ))
         (symb (cl-sort symb (lambda (a b) (string-lessp (concat (car a) (cadr a)) (concat (car b) (cadr b)))))))
    (if print
        (let ((out-buff (get-buffer-create "*symbol-list*")))
          (with-current-buffer out-buff
            (erase-buffer)
            (insert "(")
            (dolist (w symb)
              (insert (apply 'format "(\"%s\" \"\\%s\" #X%s \"%s\")\n" w )))
            (insert ")")
            (goto-char (point-min)))
          (switch-to-buffer out-buff))
      symb)))

(provide 'math-symbol-lists)
;;; math-symbol-lists.el ends here
