;;; eev.el --- Support for e-scripts (eepitch blocks, elisp hyperlinks, etc)  -*- lexical-binding: t; -*-

;; Copyright (C) 2019-2022 Free Software Foundation, Inc.

;; Author: Eduardo Ochs <eduardoochs@gmail.com>
;; Package-Requires: ((emacs "24.4"))
;; Keywords: lisp e-scripts
;; URL: http://anggtwu.net/#eev
;; Version: 20231226

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

;;; Commentary:

;; I used to call eev a "tool for automating almost everything" and
;; "my project to save the world with Free Software". In more concrete
;; terms, eev is a library for Emacs that lets us create "executable
;; logs" of what we do in a format that is reasonably easy to read and
;; to modify, and that lets us "play back" those logs step by step in
;; any order.
;;
;; See the file README.org - or <http://anggtwu.net/#eev>, or
;; <https://github.com/edrx/eev#introduction> - for more information
;; and lots of links.
;;
;; See eev-beginner.el for how to load and start eev:
;; <http://anggtwu.net/eev-current/eev-beginner.el.html>

;;; Code:

(provide 'eev)
;;; eev.el ends here
