;;; simpleicons.el --- AUCTeX style for `simpleicons.sty' (v13.18.0)  -*- lexical-binding: t; -*-

;; Copyright (C) 2023--2024 Free Software Foundation, Inc.

;; Author: Arash Esbati <arash@gnu.org>
;; Maintainer: auctex-devel@gnu.org
;; Created: 2023-12-28
;; Keywords: tex

;; This file is part of AUCTeX.

;; AUCTeX is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by the
;; Free Software Foundation; either version 3, or (at your option) any
;; later version.

;; AUCTeX is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

;;; Commentary:

;; This file adds support for `simpleicons.sty' (v13.18.0) from
;; 2024/11/29.  `simpleicons.sty' is part of TeXLive.

;;; Code:

(require 'tex)
(require 'latex)

;; Silence the compiler:
(declare-function font-latex-add-keywords
                  "font-latex"
                  (keywords class))

(defvar LaTeX-simpleicons-icons
  '("1001tracklists"
    "1dot1dot1dot1"
    "1panel"
    "1password"
    "2fas"
    "2k"
    "30secondsofcode"
    "365datascience"
    "3m"
    "42"
    "4chan"
    "4d"
    "500px"
    "7zip"
    "99designs"
    "9gag"
    "abbott"
    "abbrobotstudio"
    "abbvie"
    "aboutdotme"
    "abstract"
    "abusedotch"
    "academia"
    "accenture"
    "accusoft"
    "acer"
    "acm"
    "actigraph"
    "activision"
    "activitypub"
    "actix"
    "actualbudget"
    "acura"
    "adafruit"
    "adblock"
    "adblockplus"
    "adguard"
    "adidas"
    "adminer"
    "adobe"
    "adobeacrobatreader"
    "adobeaftereffects"
    "adobeaudition"
    "adobecreativecloud"
    "adobedreamweaver"
    "adobefonts"
    "adobeillustrator"
    "adobeindesign"
    "adobelightroom"
    "adobelightroomclassic"
    "adobephotoshop"
    "adobepremierepro"
    "adobexd"
    "adonisjs"
    "adp"
    "adroll"
    "adventofcode"
    "adyen"
    "aegisauthenticator"
    "aerlingus"
    "aeroflot"
    "aeromexico"
    "aerospike"
    "aew"
    "affine"
    "affinity"
    "affinitydesigner"
    "affinityphoto"
    "affinitypublisher"
    "aframe"
    "afterpay"
    "agora"
    "aib"
    "aidungeon"
    "aiohttp"
    "aiqfome"
    "airasia"
    "airbnb"
    "airbrake"
    "airbus"
    "airbyte"
    "aircall"
    "aircanada"
    "airchina"
    "airfrance"
    "airindia"
    "airplayaudio"
    "airplayvideo"
    "airtable"
    "airtel"
    "airtransat"
    "ajv"
    "akamai"
    "akaunting"
    "akiflow"
    "alacritty"
    "alamy"
    "albertheijn"
    "alby"
    "alchemy"
    "aldinord"
    "aldisud"
    "alfaromeo"
    "alfred"
    "algolia"
    "algorand"
    "alibabacloud"
    "alibabadotcom"
    "alienware"
    "aliexpress"
    "alipay"
    "allegro"
    "alliedmodders"
    "allocine"
    "alltrails"
    "almalinux"
    "alpinedotjs"
    "alpinelinux"
    "alternativeto"
    "alteryx"
    "altiumdesigner"
    "alwaysdata"
    "alx"
    "amazon"
    "amazonalexa"
    "amazonapigateway"
    "amazoncloudwatch"
    "amazoncognito"
    "amazondocumentdb"
    "amazondynamodb"
    "amazonec2"
    "amazonecs"
    "amazoneks"
    "amazonelasticache"
    "amazonfiretv"
    "amazongames"
    "amazoniam"
    "amazonlumberyard"
    "amazonluna"
    "amazonmusic"
    "amazonpay"
    "amazonprime"
    "amazonrds"
    "amazonredshift"
    "amazonroute53"
    "amazons3"
    "amazonsimpleemailservice"
    "amazonsqs"
    "amazonwebservices"
    "amd"
    "ameba"
    "americanairlines"
    "americanexpress"
    "amg"
    "amp"
    "amul"
    "ana"
    "anaconda"
    "analogue"
    "andela"
    "android"
    "androidauto"
    "androidstudio"
    "angular"
    "anilist"
    "animalplanet"
    "ankermake"
    "anki"
    "ansible"
    "answer"
    "ansys"
    "anta"
    "antdesign"
    "antena3"
    "anthropic"
    "anycubic"
    "anydesk"
    "anytype"
    "aol"
    "apache"
    "apacheairflow"
    "apacheant"
    "apachecassandra"
    "apachecloudstack"
    "apachecordova"
    "apachecouchdb"
    "apachedolphinscheduler"
    "apachedruid"
    "apacheecharts"
    "apacheflink"
    "apachefreemarker"
    "apachegroovy"
    "apacheguacamole"
    "apachehadoop"
    "apachehbase"
    "apachehive"
    "apachejmeter"
    "apachekafka"
    "apachekylin"
    "apachelucene"
    "apachemaven"
    "apachenetbeanside"
    "apachenifi"
    "apacheopenoffice"
    "apacheparquet"
    "apachepulsar"
    "apacherocketmq"
    "apachesolr"
    "apachespark"
    "apachestorm"
    "apachesuperset"
    "apachetomcat"
    "aparat"
    "apifox"
    "apmterminals"
    "apollographql"
    "apostrophe"
    "appian"
    "appium"
    "apple"
    "applearcade"
    "applemusic"
    "applenews"
    "applepay"
    "applepodcasts"
    "appletv"
    "appsignal"
    "appsmith"
    "appstore"
    "appveyor"
    "appwrite"
    "aqua"
    "aral"
    "arangodb"
    "arc"
    "arcgis"
    "archicad"
    "archiveofourown"
    "archlinux"
    "ardour"
    "arduino"
    "argo"
    "argos"
    "ariakit"
    "arkecosystem"
    "arlo"
    "arm"
    "armkeil"
    "arstechnica"
    "artifacthub"
    "artixlinux"
    "artstation"
    "arxiv"
    "asahilinux"
    "asana"
    "asciidoctor"
    "asciinema"
    "asda"
    "aseprite"
    "askfm"
    "assemblyscript"
    "asterisk"
    "astonmartin"
    "astra"
    "astral"
    "astro"
    "asus"
    "atandt"
    "atari"
    "atlasos"
    "atlassian"
    "auchan"
    "audacity"
    "audi"
    "audible"
    "audiobookshelf"
    "audioboom"
    "audiomack"
    "audiotechnica"
    "aurelia"
    "auth0"
    "authelia"
    "authentik"
    "authy"
    "autocad"
    "autocannon"
    "autodesk"
    "autodeskmaya"
    "autodeskrevit"
    "autohotkey"
    "autoit"
    "automattic"
    "autoprefixer"
    "autozone"
    "avajs"
    "avast"
    "avianca"
    "avira"
    "awesomelists"
    "awesomewm"
    "awsamplify"
    "awselasticloadbalancing"
    "awsfargate"
    "awslambda"
    "awsorganizations"
    "awssecretsmanager"
    "awwwards"
    "axios"
    "babel"
    "babelio"
    "babylondotjs"
    "backblaze"
    "backbonedotjs"
    "backendless"
    "backstage"
    "badoo"
    "baidu"
    "bakalari"
    "bamboo"
    "bambulab"
    "bandcamp"
    "bandlab"
    "bandrautomation"
    "bandsintown"
    "bankofamerica"
    "barclays"
    "baremetrics"
    "barmenia"
    "basecamp"
    "baserow"
    "basicattentiontoken"
    "bastyon"
    "bat"
    "bata"
    "battledotnet"
    "bazel"
    "beatport"
    "beats"
    "beatsbydre"
    "beatstars"
    "beekeeperstudio"
    "behance"
    "beijingsubway"
    "bem"
    "bentley"
    "bento"
    "bentobox"
    "bentoml"
    "bereal"
    "betfair"
    "betterstack"
    "bevy"
    "bigbasket"
    "bigbluebutton"
    "bigcartel"
    "bigcommerce"
    "bilibili"
    "billboard"
    "bim"
    "binance"
    "biolink"
    "biome"
    "bisecthosting"
    "bit"
    "bitbucket"
    "bitcoin"
    "bitcoincash"
    "bitcoinsv"
    "bitcomet"
    "bitdefender"
    "bitly"
    "bitrise"
    "bittorrent"
    "bitwarden"
    "bitwig"
    "blackberry"
    "blackmagicdesign"
    "blazemeter"
    "blazor"
    "blender"
    "blockbench"
    "blockchaindotcom"
    "blogger"
    "bloglovin"
    "blueprint"
    "bluesky"
    "bluesound"
    "bluetooth"
    "bmcsoftware"
    "bmw"
    "bnbchain"
    "boardgamegeek"
    "boat"
    "boehringeringelheim"
    "boeing"
    "bombardier"
    "bookalope"
    "bookbub"
    "bookmeter"
    "bookmyshow"
    "bookstack"
    "boost"
    "boosty"
    "boots"
    "bootstrap"
    "borgbackup"
    "bosch"
    "bose"
    "botblecms"
    "boulanger"
    "bower"
    "box"
    "boxysvg"
    "braintree"
    "brandfolder"
    "brave"
    "breaker"
    "brenntag"
    "brevo"
    "brex"
    "bricks"
    "britishairways"
    "broadcom"
    "bruno"
    "bsd"
    "bspwm"
    "bt"
    "buddy"
    "budibase"
    "buefy"
    "buffer"
    "bugatti"
    "bugcrowd"
    "bugsnag"
    "buhl"
    "buildkite"
    "builtbybit"
    "bukalapak"
    "bulma"
    "bun"
    "bungie"
    "bunq"
    "burgerking"
    "burpsuite"
    "burton"
    "buymeacoffee"
    "buysellads"
    "buzzfeed"
    "bvg"
    "byjus"
    "bytedance"
    "c"
    "cachet"
    "caddy"
    "cadillac"
    "cafepress"
    "caffeine"
    "cairographics"
    "cairometro"
    "cakephp"
    "caldotcom"
    "calendly"
    "calibreweb"
    "campaignmonitor"
    "camunda"
    "canonical"
    "canva"
    "canvas"
    "capacitor"
    "caprover"
    "cardano"
    "carlsberggroup"
    "carrd"
    "carrefour"
    "carthrottle"
    "carto"
    "cashapp"
    "castbox"
    "castorama"
    "castro"
    "caterpillar"
    "cbc"
    "cbs"
    "ccleaner"
    "cdprojekt"
    "ce"
    "celery"
    "celestron"
    "centos"
    "ceph"
    "cesium"
    "chai"
    "chainguard"
    "chainlink"
    "chakraui"
    "channel4"
    "charles"
    "chartdotjs"
    "chartmogul"
    "chase"
    "chatbot"
    "chatwoot"
    "checkio"
    "checkmarx"
    "checkmk"
    "chedraui"
    "cheerio"
    "chef"
    "chemex"
    "chessdotcom"
    "chevrolet"
    "chianetwork"
    "chinaeasternairlines"
    "chinasouthernairlines"
    "chocolatey"
    "chromatic"
    "chromecast"
    "chromewebstore"
    "chrysler"
    "chupachups"
    "cilium"
    "cinema4d"
    "cinnamon"
    "circle"
    "circleci"
    "circuitverse"
    "cirrusci"
    "cisco"
    "citrix"
    "citroen"
    "civicrm"
    "civo"
    "ckeditor4"
    "clarifai"
    "claris"
    "clarivate"
    "clerk"
    "clevercloud"
    "clickhouse"
    "clickup"
    "clion"
    "cliqz"
    "clockify"
    "clojure"
    "cloud66"
    "cloudbees"
    "cloudcannon"
    "cloudera"
    "cloudflare"
    "cloudflarepages"
    "cloudflareworkers"
    "cloudfoundry"
    "cloudinary"
    "cloudron"
    "cloudsmith"
    "cloudways"
    "clubforce"
    "clubhouse"
    "clyp"
    "cmake"
    "cncf"
    "cnet"
    "cnn"
    "cocacola"
    "cockpit"
    "cockroachlabs"
    "cocoapods"
    "cocos"
    "coda"
    "codacy"
    "codeberg"
    "codeblocks"
    "codecademy"
    "codeceptjs"
    "codechef"
    "codeclimate"
    "codecov"
    "codecrafters"
    "codefactor"
    "codeforces"
    "codefresh"
    "codeigniter"
    "codeium"
    "codemagic"
    "codementor"
    "codemirror"
    "codenewbie"
    "codepen"
    "codeproject"
    "coder"
    "codersrank"
    "coderwall"
    "codesandbox"
    "codeship"
    "codesignal"
    "codestream"
    "codewars"
    "codingame"
    "codingninjas"
    "codio"
    "coffeescript"
    "coggle"
    "cognizant"
    "coil"
    "coinbase"
    "coinmarketcap"
    "comicfury"
    "comma"
    "commerzbank"
    "commitlint"
    "commodore"
    "commonworkflowlanguage"
    "compilerexplorer"
    "composer"
    "comptia"
    "comsol"
    "conan"
    "concourse"
    "condaforge"
    "conekta"
    "confluence"
    "construct3"
    "consul"
    "contabo"
    "contactlesspayment"
    "containerd"
    "contao"
    "contentful"
    "contentstack"
    "contributorcovenant"
    "conventionalcommits"
    "convertio"
    "cookiecutter"
    "coolermaster"
    "coop"
    "copaairlines"
    "coppel"
    "cora"
    "coreldraw"
    "coronaengine"
    "coronarenderer"
    "corsair"
    "couchbase"
    "counterstrike"
    "countingworkspro"
    "coursera"
    "coveralls"
    "coze"
    "cpanel"
    "cplusplus"
    "cplusplusbuilder"
    "craftcms"
    "craftsman"
    "cratedb"
    "crayon"
    "creality"
    "createreactapp"
    "creativecommons"
    "creativetechnology"
    "credly"
    "crehana"
    "crewunited"
    "criticalrole"
    "crowdin"
    "crowdsource"
    "crunchbase"
    "crunchyroll"
    "cryengine"
    "cryptpad"
    "crystal"
    "csdn"
    "css3"
    "cssdesignawards"
    "cssmodules"
    "csswizardry"
    "cts"
    "cucumber"
    "cultura"
    "curl"
    "curseforge"
    "customink"
    "cyberdefenders"
    "cycling74"
    "cypress"
    "cytoscapedotjs"
    "d"
    "d3dotjs"
    "dacia"
    "daf"
    "dailydotdev"
    "dailymotion"
    "daisyui"
    "dapr"
    "darkreader"
    "dart"
    "darty"
    "daserste"
    "dash"
    "dashlane"
    "dask"
    "dassaultsystemes"
    "databricks"
    "datacamp"
    "datadog"
    "datadotai"
    "datagrip"
    "dataiku"
    "datastax"
    "datefns"
    "datev"
    "datocms"
    "datto"
    "davinciresolve"
    "dazhongdianping"
    "dazn"
    "dbeaver"
    "dblp"
    "dbt"
    "dcentertainment"
    "debian"
    "debridlink"
    "decapcms"
    "decentraland"
    "dedge"
    "deepcool"
    "deepgram"
    "deepin"
    "deepl"
    "deepnote"
    "delicious"
    "deliveroo"
    "dell"
    "delonghi"
    "delphi"
    "delta"
    "deluge"
    "deno"
    "denon"
    "dependabot"
    "dependencycheck"
    "depositphotos"
    "derspiegel"
    "deutschebahn"
    "deutschebank"
    "deutschepost"
    "deutschewelle"
    "devdotto"
    "devexpress"
    "deviantart"
    "devpost"
    "devrant"
    "dgraph"
    "dhl"
    "diagramsdotnet"
    "dialogflow"
    "diaspora"
    "dictionarydotcom"
    "digg"
    "digikeyelectronics"
    "digitalocean"
    "dinersclub"
    "dior"
    "directus"
    "discogs"
    "discord"
    "discourse"
    "discover"
    "disqus"
    "disroot"
    "distrokid"
    "django"
    "dji"
    "dlib"
    "dlna"
    "dm"
    "docker"
    "docsdotrs"
    "docsify"
    "doctrine"
    "docusaurus"
    "dogecoin"
    "doi"
    "dolby"
    "doordash"
    "dota2"
    "dotenv"
    "dotnet"
    "douban"
    "doubanread"
    "dovecot"
    "dovetail"
    "downdetector"
    "doxygen"
    "dpd"
    "dragonframe"
    "draugiemdotlv"
    "dreamstime"
    "dribbble"
    "drizzle"
    "drone"
    "drooble"
    "dropbox"
    "drupal"
    "dsautomobiles"
    "dts"
    "dtube"
    "ducati"
    "duckdb"
    "duckduckgo"
    "dungeonsanddragons"
    "dunked"
    "dunzo"
    "duolingo"
    "duplicati"
    "dvc"
    "dwavesystems"
    "dwm"
    "dynatrace"
    "e"
    "e3"
    "ea"
    "eagle"
    "easyeda"
    "easyjet"
    "ebay"
    "ebox"
    "eclipseadoptium"
    "eclipseche"
    "eclipseide"
    "eclipsejetty"
    "eclipsemosquitto"
    "eclipsevertdotx"
    "ecosia"
    "ecovacs"
    "edeka"
    "edgeimpulse"
    "editorconfig"
    "edotleclerc"
    "educative"
    "edx"
    "egghead"
    "egnyte"
    "eight"
    "eightsleep"
    "ejs"
    "elastic"
    "elasticcloud"
    "elasticsearch"
    "elasticstack"
    "elavon"
    "electron"
    "electronbuilder"
    "electronfiddle"
    "elegoo"
    "element"
    "elementary"
    "elementor"
    "elevenlabs"
    "eleventy"
    "elgato"
    "elixir"
    "eljueves"
    "ello"
    "elm"
    "elsevier"
    "embarcadero"
    "embark"
    "emberdotjs"
    "emby"
    "emirates"
    "emlakjet"
    "empirekred"
    "endeavouros"
    "engadget"
    "enpass"
    "enterprisedb"
    "envato"
    "envoyproxy"
    "epel"
    "epicgames"
    "epson"
    "equinixmetal"
    "eraser"
    "ericsson"
    "erlang"
    "erpnext"
    "esbuild"
    "esea"
    "eslgaming"
    "eslint"
    "esotericsoftware"
    "esphome"
    "espressif"
    "esri"
    "etcd"
    "ethereum"
    "ethers"
    "ethiopianairlines"
    "etihadairways"
    "etsy"
    "eventbrite"
    "eventstore"
    "evernote"
    "excalidraw"
    "exercism"
    "exordo"
    "exoscale"
    "expedia"
    "expensify"
    "expertsexchange"
    "expo"
    "express"
    "expressvpn"
    "eyeem"
    "f1"
    "f5"
    "facebook"
    "facebookgaming"
    "facebooklive"
    "faceit"
    "facepunch"
    "fairphone"
    "falco"
    "falcon"
    "fampay"
    "fandango"
    "fandom"
    "fanfou"
    "fantom"
    "farcaster"
    "fareharbor"
    "farfetch"
    "fastapi"
    "fastify"
    "fastlane"
    "fastly"
    "fathom"
    "fauna"
    "favro"
    "fcc"
    "fdroid"
    "feathub"
    "fedex"
    "fedora"
    "feedly"
    "ferrari"
    "ferrarinv"
    "ferretdb"
    "ffmpeg"
    "fi"
    "fiat"
    "fidoalliance"
    "fifa"
    "fig"
    "figma"
    "figshare"
    "fila"
    "filedotio"
    "files"
    "filezilla"
    "fineco"
    "fing"
    "firebase"
    "firefish"
    "fireflyiii"
    "firefox"
    "firefoxbrowser"
    "fireship"
    "firewalla"
    "first"
    "fishshell"
    "fitbit"
    "fivem"
    "fiverr"
    "fizz"
    "flashforge"
    "flask"
    "flat"
    "flathub"
    "flatpak"
    "flickr"
    "flightaware"
    "flipboard"
    "flipkart"
    "floatplane"
    "flood"
    "fluentbit"
    "fluentd"
    "fluke"
    "flutter"
    "flux"
    "fluxus"
    "flydotio"
    "flyway"
    "fmod"
    "fnac"
    "folium"
    "fonoma"
    "fontawesome"
    "fontbase"
    "fontforge"
    "foobar2000"
    "foodpanda"
    "ford"
    "forgejo"
    "formik"
    "formspree"
    "formstack"
    "fortinet"
    "fortran"
    "fossa"
    "fossilscm"
    "foundryvirtualtabletop"
    "foursquare"
    "foursquarecityguide"
    "fox"
    "foxtel"
    "fozzy"
    "framer"
    "framework"
    "framework7"
    "franprix"
    "frappe"
    "fraunhofergesellschaft"
    "freebsd"
    "freecad"
    "freecodecamp"
    "freedesktopdotorg"
    "freelancer"
    "freelancermap"
    "freenas"
    "freepik"
    "fresh"
    "frontendmentor"
    "frontify"
    "fsecure"
    "fsharp"
    "fubo"
    "fueler"
    "fugacloud"
    "fujifilm"
    "fujitsu"
    "funimation"
    "furaffinity"
    "furrynetwork"
    "fusionauth"
    "futurelearn"
    "g2"
    "g2a"
    "g2g"
    "galaxus"
    "gameandwatch"
    "gamebanana"
    "gamedeveloper"
    "gamejolt"
    "gameloft"
    "gamemaker"
    "garmin"
    "gatling"
    "gatsby"
    "gcore"
    "gdal"
    "geant"
    "geeksforgeeks"
    "generalelectric"
    "generalmotors"
    "genius"
    "gentoo"
    "geocaching"
    "geode"
    "geopandas"
    "gerrit"
    "getx"
    "ghost"
    "ghostery"
    "gimp"
    "gin"
    "giphy"
    "git"
    "gitbook"
    "gitconnected"
    "gitea"
    "gitee"
    "gitextensions"
    "gitforwindows"
    "github"
    "githubactions"
    "githubcopilot"
    "githubpages"
    "githubsponsors"
    "gitignoredotio"
    "gitkraken"
    "gitlab"
    "gitlfs"
    "gitpod"
    "gitter"
    "glassdoor"
    "glide"
    "glitch"
    "globus"
    "glovo"
    "gltf"
    "gmail"
    "gnome"
    "gnometerminal"
    "gnu"
    "gnubash"
    "gnuemacs"
    "gnuicecat"
    "gnuprivacyguard"
    "gnusocial"
    "go"
    "gocd"
    "godaddy"
    "godotengine"
    "gofundme"
    "gogdotcom"
    "gojek"
    "goland"
    "goldenline"
    "goldmansachs"
    "goodreads"
    "google"
    "googleadmob"
    "googleads"
    "googleadsense"
    "googleanalytics"
    "googleappsscript"
    "googleassistant"
    "googleauthenticator"
    "googlebigquery"
    "googlebigtable"
    "googlecalendar"
    "googlecampaignmanager360"
    "googlecardboard"
    "googlechat"
    "googlechrome"
    "googlechronicle"
    "googleclassroom"
    "googlecloud"
    "googlecloudcomposer"
    "googlecloudspanner"
    "googlecloudstorage"
    "googlecolab"
    "googlecontaineroptimizedos"
    "googledataflow"
    "googledataproc"
    "googledatastudio"
    "googledisplayandvideo360"
    "googledocs"
    "googledrive"
    "googleearth"
    "googleearthengine"
    "googlefit"
    "googlefonts"
    "googleforms"
    "googlegemini"
    "googlehome"
    "googlekeep"
    "googlelens"
    "googlemaps"
    "googlemarketingplatform"
    "googlemeet"
    "googlemessages"
    "googlenearby"
    "googlenews"
    "googlepay"
    "googlephotos"
    "googleplay"
    "googlepubsub"
    "googlescholar"
    "googlesearchconsole"
    "googlesheets"
    "googleslides"
    "googlestreetview"
    "googletagmanager"
    "googletasks"
    "googletranslate"
    "gotomeeting"
    "grab"
    "gradle"
    "gradleplaypublisher"
    "grafana"
    "grammarly"
    "grandfrais"
    "grapheneos"
    "graphite"
    "graphql"
    "grav"
    "gravatar"
    "graylog"
    "greasyfork"
    "greatlearning"
    "greenhouse"
    "greensock"
    "griddotai"
    "gridsome"
    "groupme"
    "groupon"
    "grubhub"
    "grunt"
    "gsk"
    "gsmarenadotcom"
    "gstreamer"
    "gtk"
    "guangzhoumetro"
    "guilded"
    "guitarpro"
    "gulp"
    "gumroad"
    "gumtree"
    "gunicorn"
    "gurobi"
    "gusto"
    "gutenberg"
    "h3"
    "habr"
    "hackaday"
    "hackclub"
    "hackerearth"
    "hackernoon"
    "hackerone"
    "hackerrank"
    "hackster"
    "hackthebox"
    "hal"
    "handlebarsdotjs"
    "handm"
    "handshake"
    "handshakeprotocol"
    "happycow"
    "harbor"
    "harmonyos"
    "hashicorp"
    "hashnode"
    "haskell"
    "hasura"
    "hatenabookmark"
    "haveibeenpwned"
    "haxe"
    "hbo"
    "hcl"
    "hdfcbank"
    "headlessui"
    "headphonezone"
    "headspace"
    "hearth"
    "hearthisdotat"
    "hedera"
    "helium"
    "helix"
    "hellofresh"
    "hellyhansen"
    "helm"
    "helpdesk"
    "helpscout"
    "hepsiemlak"
    "here"
    "hermes"
    "heroku"
    "hetzner"
    "hevy"
    "hexlet"
    "hexo"
    "hey"
    "hibernate"
    "hibob"
    "hilton"
    "hiltonhotelsandresorts"
    "hitachi"
    "hive"
    "hiveblockchain"
    "hivemq"
    "homarr"
    "homeadvisor"
    "homeassistant"
    "homeassistantcommunitystore"
    "homebrew"
    "homebridge"
    "homepage"
    "homify"
    "honda"
    "honey"
    "hono"
    "honor"
    "hootsuite"
    "hoppscotch"
    "hostinger"
    "hotelsdotcom"
    "hotjar"
    "hotwire"
    "houdini"
    "houzz"
    "hp"
    "hsbc"
    "html5"
    "htmlacademy"
    "htmx"
    "htop"
    "httpie"
    "huawei"
    "hubspot"
    "huggingface"
    "hugo"
    "humblebundle"
    "humhub"
    "hungryjacks"
    "husqvarna"
    "hyper"
    "hyperskill"
    "hyperx"
    "hypothesis"
    "hyprland"
    "hyundai"
    "i18next"
    "i3"
    "iata"
    "ibeacon"
    "iberia"
    "iced"
    "iceland"
    "icicibank"
    "icinga"
    "icloud"
    "icomoon"
    "icon"
    "iconfinder"
    "iconify"
    "iconjar"
    "icons8"
    "icq"
    "ieee"
    "ifixit"
    "ifood"
    "ifttt"
    "igdb"
    "ign"
    "iheartradio"
    "ikea"
    "iledefrancemobilites"
    "imagedotsc"
    "imagej"
    "imdb"
    "imessage"
    "imgur"
    "immer"
    "immich"
    "imou"
    "improvmx"
    "indeed"
    "indiansuperleague"
    "indiehackers"
    "indigo"
    "inductiveautomation"
    "inertia"
    "infiniti"
    "influxdb"
    "infomaniak"
    "infoq"
    "informatica"
    "infosys"
    "infracost"
    "ingress"
    "inkdrop"
    "inkscape"
    "inoreader"
    "insomnia"
    "inspire"
    "insta360"
    "instacart"
    "instagram"
    "instapaper"
    "instatus"
    "instructables"
    "instructure"
    "intel"
    "intellijidea"
    "interactiondesignfoundation"
    "interactjs"
    "interbase"
    "intercom"
    "intermarche"
    "internetarchive"
    "internetcomputer"
    "intigriti"
    "intuit"
    "invision"
    "invoiceninja"
    "iobroker"
    "ionic"
    "ionos"
    "ios"
    "iota"
    "ipfs"
    "iris"
    "irobot"
    "isc2"
    "issuu"
    "istio"
    "itchdotio"
    "iterm2"
    "itunes"
    "itvx"
    "iveco"
    "jabber"
    "jaeger"
    "jaguar"
    "jamboard"
    "jameson"
    "jamstack"
    "japanairlines"
    "jasmine"
    "javascript"
    "jbl"
    "jcb"
    "jeep"
    "jekyll"
    "jellyfin"
    "jenkins"
    "jest"
    "jet"
    "jetblue"
    "jetbrains"
    "jetpackcompose"
    "jfrog"
    "jfrogpipelines"
    "jhipster"
    "jinja"
    "jira"
    "jirasoftware"
    "jitpack"
    "jitsi"
    "johndeere"
    "joomla"
    "joplin"
    "jordan"
    "jouav"
    "jovian"
    "jpeg"
    "jquery"
    "jrgroup"
    "jsdelivr"
    "jsfiddle"
    "json"
    "jsonwebtokens"
    "jsr"
    "jss"
    "juce"
    "juejin"
    "juke"
    "julia"
    "junipernetworks"
    "junit5"
    "jupyter"
    "justeat"
    "justgiving"
    "k3s"
    "k6"
    "kaggle"
    "kagi"
    "kahoot"
    "kaios"
    "kakao"
    "kakaotalk"
    "kalilinux"
    "kamailio"
    "kaniko"
    "karlsruherverkehrsverbund"
    "kasasmart"
    "kashflow"
    "kaspersky"
    "katacoda"
    "katana"
    "kaufland"
    "kde"
    "kdenlive"
    "kdeplasma"
    "kedro"
    "keenetic"
    "keepachangelog"
    "keepassxc"
    "keeweb"
    "kentico"
    "keras"
    "keybase"
    "keycdn"
    "keycloak"
    "keystone"
    "kfc"
    "khanacademy"
    "khronosgroup"
    "kia"
    "kibana"
    "kicad"
    "kick"
    "kickstarter"
    "kik"
    "kingstontechnology"
    "kinopoisk"
    "kinsta"
    "kirby"
    "kit"
    "kitsu"
    "klarna"
    "klm"
    "klook"
    "knative"
    "knexdotjs"
    "knime"
    "knip"
    "knowledgebase"
    "known"
    "koa"
    "koc"
    "kodak"
    "kodi"
    "koenigsegg"
    "kofax"
    "kofi"
    "komoot"
    "konami"
    "kong"
    "kongregate"
    "konva"
    "kotlin"
    "koyeb"
    "krita"
    "ktm"
    "ktor"
    "kuaishou"
    "kubernetes"
    "kubuntu"
    "kucoin"
    "kuma"
    "kununu"
    "kuula"
    "kx"
    "kyocera"
    "labview"
    "lada"
    "lamborghini"
    "landrover"
    "langchain"
    "languagetool"
    "lapce"
    "laragon"
    "laravel"
    "laravelhorizon"
    "laravelnova"
    "lastdotfm"
    "lastpass"
    "latex"
    "launchpad"
    "lazarus"
    "lazyvim"
    "lbry"
    "leaderprice"
    "leaflet"
    "leagueoflegends"
    "leanpub"
    "leetcode"
    "lefthook"
    "legacygames"
    "leica"
    "lemmy"
    "lemonsqueezy"
    "lenovo"
    "lens"
    "leptos"
    "lequipe"
    "lerna"
    "leroymerlin"
    "leslibraires"
    "less"
    "letsencrypt"
    "letterboxd"
    "levelsdotfyi"
    "lg"
    "liberadotchat"
    "liberapay"
    "librariesdotio"
    "librarything"
    "libreoffice"
    "libreofficebase"
    "libreofficecalc"
    "libreofficedraw"
    "libreofficeimpress"
    "libreofficemath"
    "libreofficewriter"
    "libretranslate"
    "libretube"
    "librewolf"
    "libuv"
    "lichess"
    "lidl"
    "lifx"
    "lightburn"
    "lighthouse"
    "lightning"
    "limesurvey"
    "line"
    "lineageos"
    "linear"
    "lining"
    "linkedin"
    "linkerd"
    "linkfire"
    "linksys"
    "linktree"
    "lintcode"
    "linux"
    "linuxcontainers"
    "linuxfoundation"
    "linuxmint"
    "linuxprofessionalinstitute"
    "linuxserver"
    "lionair"
    "liquibase"
    "listmonk"
    "lit"
    "litecoin"
    "literal"
    "litiengine"
    "livechat"
    "livejournal"
    "livewire"
    "llvm"
    "lmms"
    "lobsters"
    "local"
    "lodash"
    "logitech"
    "logitechg"
    "logmein"
    "logseq"
    "logstash"
    "looker"
    "loom"
    "loop"
    "loopback"
    "lootcrate"
    "lospec"
    "lotpolishairlines"
    "ltspice"
    "lua"
    "lubuntu"
    "lucia"
    "lucid"
    "lucide"
    "ludwig"
    "lufthansa"
    "lumen"
    "lunacy"
    "lutris"
    "lydia"
    "lyft"
    "maas"
    "macos"
    "macpaw"
    "macys"
    "magasinsu"
    "magento"
    "magic"
    "magisk"
    "mahindra"
    "mailboxdotorg"
    "mailchimp"
    "maildotcom"
    "maildotru"
    "mailgun"
    "mailtrap"
    "mainwp"
    "majorleaguehacking"
    "make"
    "makerbot"
    "malt"
    "malwarebytes"
    "mambaui"
    "mamp"
    "man"
    "manageiq"
    "manjaro"
    "mantine"
    "mapbox"
    "maplibre"
    "mariadb"
    "mariadbfoundation"
    "markdown"
    "marketo"
    "marko"
    "marriott"
    "marvelapp"
    "maserati"
    "mastercard"
    "mastercomfig"
    "mastodon"
    "materialdesign"
    "materialdesignicons"
    "materialformkdocs"
    "matillion"
    "matomo"
    "matrix"
    "matterdotjs"
    "mattermost"
    "matternet"
    "mautic"
    "max"
    "maxplanckgesellschaft"
    "maytag"
    "mazda"
    "mcafee"
    "mcdonalds"
    "mclaren"
    "mdbook"
    "mdnwebdocs"
    "mdx"
    "mediafire"
    "mediamarkt"
    "mediapipe"
    "mediatek"
    "medibangpaint"
    "medium"
    "medusa"
    "meetup"
    "mega"
    "meilisearch"
    "meituan"
    "meizu"
    "mendeley"
    "mentorcruise"
    "mercadopago"
    "mercedes"
    "merck"
    "mercurial"
    "mermaid"
    "messenger"
    "meta"
    "metabase"
    "metacritic"
    "metafilter"
    "metasploit"
    "meteor"
    "metro"
    "metrodelaciudaddemexico"
    "metrodemadrid"
    "metrodeparis"
    "mewe"
    "mg"
    "microbit"
    "microdotblog"
    "microeditor"
    "microgenetics"
    "micropython"
    "microstation"
    "microstrategy"
    "midi"
    "migadu"
    "mihoyo"
    "mikrotik"
    "milanote"
    "milvus"
    "minds"
    "minetest"
    "mingww64"
    "mini"
    "minio"
    "mintlify"
    "minutemailer"
    "miraheze"
    "miro"
    "misskey"
    "mitsubishi"
    "mix"
    "mixcloud"
    "mixpanel"
    "mlb"
    "mlflow"
    "mobx"
    "mobxstatetree"
    "mocha"
    "mockserviceworker"
    "modal"
    "modin"
    "modrinth"
    "modx"
    "moleculer"
    "momenteo"
    "monero"
    "moneygram"
    "mongodb"
    "mongoose"
    "mongoosedotws"
    "monica"
    "monkeytie"
    "monkeytype"
    "monogame"
    "monoprix"
    "monster"
    "monzo"
    "moo"
    "moodle"
    "moonrepo"
    "moq"
    "moqups"
    "morrisons"
    "moscowmetro"
    "motorola"
    "mozilla"
    "mpv"
    "mqtt"
    "msi"
    "msibusiness"
    "mta"
    "mtr"
    "mubi"
    "mui"
    "mulesoft"
    "muller"
    "multisim"
    "mumble"
    "muo"
    "mural"
    "musescore"
    "musicbrainz"
    "mxlinux"
    "myanimelist"
    "myget"
    "myob"
    "myspace"
    "mysql"
    "n26"
    "n8n"
    "namebase"
    "namecheap"
    "namemc"
    "namesilo"
    "namuwiki"
    "nano"
    "nanostores"
    "nasa"
    "nationalgrid"
    "nationalrail"
    "nativescript"
    "natsdotio"
    "naver"
    "nba"
    "nbb"
    "nbc"
    "ndr"
    "near"
    "nebula"
    "nec"
    "neo4j"
    "neovim"
    "neptune"
    "nestjs"
    "netapp"
    "netbsd"
    "netcup"
    "netdata"
    "neteasecloudmusic"
    "netflix"
    "netgear"
    "netlify"
    "nette"
    "netto"
    "neutralinojs"
    "newbalance"
    "newegg"
    "newjapanprowrestling"
    "newrelic"
    "newyorktimes"
    "nexon"
    "nextbilliondotai"
    "nextcloud"
    "nextdns"
    "nextdoor"
    "nextdotjs"
    "nextra"
    "nextui"
    "nexusmods"
    "nfc"
    "nginx"
    "nginxproxymanager"
    "ngrok"
    "ngrx"
    "nhl"
    "nicehash"
    "niconico"
    "nike"
    "nikon"
    "nim"
    "nintendo"
    "nintendo3ds"
    "nintendogamecube"
    "nintendoswitch"
    "nissan"
    "nixos"
    "nodedotjs"
    "nodemon"
    "nodered"
    "nokia"
    "nomad"
    "norco"
    "nordicsemiconductor"
    "nordvpn"
    "normalizedotcss"
    "norton"
    "norwegian"
    "notepadplusplus"
    "notion"
    "notist"
    "nounproject"
    "novu"
    "now"
    "npm"
    "nrwl"
    "nsis"
    "ntfy"
    "nubank"
    "nucleo"
    "nuget"
    "nuke"
    "numba"
    "numpy"
    "nunjucks"
    "nushell"
    "nutanix"
    "nuxtdotjs"
    "nvidia"
    "nvm"
    "nx"
    "nxp"
    "nzxt"
    "o2"
    "observable"
    "obsidian"
    "obsstudio"
    "ocaml"
    "oclif"
    "octanerender"
    "octave"
    "octobercms"
    "octoprint"
    "octopusdeploy"
    "oculus"
    "odin"
    "odnoklassniki"
    "odoo"
    "odysee"
    "ohdear"
    "okcupid"
    "okta"
    "okx"
    "ollama"
    "oneplus"
    "onlyfans"
    "onlyoffice"
    "onnx"
    "onstar"
    "opel"
    "openaccess"
    "openai"
    "openaigym"
    "openapiinitiative"
    "openbadges"
    "openbsd"
    "openbugbounty"
    "opencollective"
    "opencontainersinitiative"
    "opencv"
    "openfaas"
    "opengl"
    "openhab"
    "openid"
    "openjdk"
    "openjsfoundation"
    "openlayers"
    "openmediavault"
    "openmined"
    "opennebula"
    "openproject"
    "openscad"
    "opensea"
    "opensearch"
    "opensourcehardware"
    "opensourceinitiative"
    "openssl"
    "openstack"
    "openstreetmap"
    "opensuse"
    "opentelemetry"
    "opentext"
    "opentofu"
    "openverse"
    "openvpn"
    "openwrt"
    "openzeppelin"
    "openzfs"
    "opera"
    "operagx"
    "opnsense"
    "oppo"
    "opsgenie"
    "opslevel"
    "optimism"
    "oracle"
    "orange"
    "orcid"
    "oreilly"
    "org"
    "organicmaps"
    "origin"
    "osano"
    "osf"
    "osgeo"
    "oshkosh"
    "osmc"
    "osu"
    "otto"
    "outline"
    "overcast"
    "overleaf"
    "ovh"
    "owasp"
    "owncloud"
    "oxygen"
    "oyo"
    "p5dotjs"
    "packagist"
    "packer"
    "packt"
    "paddle"
    "paddlepaddle"
    "paddypower"
    "pagekit"
    "pagerduty"
    "pagespeedinsights"
    "pagseguro"
    "palantir"
    "paloaltonetworks"
    "paloaltosoftware"
    "panasonic"
    "pandas"
    "pandora"
    "pantheon"
    "paperlessngx"
    "paperspace"
    "paperswithcode"
    "paramountplus"
    "paritysubstrate"
    "parrotsecurity"
    "parsedotly"
    "passport"
    "pastebin"
    "patreon"
    "paychex"
    "payhip"
    "payloadcms"
    "payoneer"
    "paypal"
    "paytm"
    "pcgamingwiki"
    "pdm"
    "pdq"
    "peakdesign"
    "pearson"
    "peerlist"
    "peertube"
    "pegasusairlines"
    "pelican"
    "peloton"
    "penny"
    "penpot"
    "percy"
    "perforce"
    "perl"
    "perplexity"
    "persistent"
    "personio"
    "petsathome"
    "peugeot"
    "pexels"
    "pfsense"
    "phabricator"
    "philipshue"
    "phoenixframework"
    "phonepe"
    "phosphoricons"
    "photobucket"
    "photocrowd"
    "photon"
    "photopea"
    "php"
    "phpmyadmin"
    "phpstorm"
    "piaggiogroup"
    "piapro"
    "picardsurgeles"
    "picartodottv"
    "picnic"
    "picpay"
    "picrew"
    "picxy"
    "pihole"
    "pimcore"
    "pinboard"
    "pinescript"
    "pinetwork"
    "pingdom"
    "pino"
    "pinterest"
    "pioneerdj"
    "piped"
    "pipx"
    "pivotaltracker"
    "piwigo"
    "pix"
    "pixabay"
    "pixelfed"
    "pixiv"
    "pixlr"
    "pkgsrc"
    "planet"
    "planetscale"
    "plangrid"
    "platformdotsh"
    "platformio"
    "platzi"
    "plausibleanalytics"
    "playcanvas"
    "playerdotme"
    "playerfm"
    "playstation"
    "playstation2"
    "playstation3"
    "playstation4"
    "playstation5"
    "playstationportable"
    "playstationvita"
    "pleroma"
    "plesk"
    "plex"
    "plotly"
    "plume"
    "pluralsight"
    "plurk"
    "pluscodes"
    "pm2"
    "pnpm"
    "pocket"
    "pocketbase"
    "pocketcasts"
    "podcastaddict"
    "podcastindex"
    "podman"
    "poe"
    "poetry"
    "pointy"
    "pokemon"
    "polars"
    "polestar"
    "polkadot"
    "poly"
    "polygon"
    "polymerproject"
    "polywork"
    "pond5"
    "popos"
    "porkbun"
    "porsche"
    "portainer"
    "portswigger"
    "posit"
    "postcss"
    "postgresql"
    "posthog"
    "postman"
    "postmates"
    "powers"
    "prdotco"
    "preact"
    "precommit"
    "prefect"
    "premierleague"
    "prepbytes"
    "prestashop"
    "presto"
    "prettier"
    "pretzel"
    "prevention"
    "prezi"
    "prime"
    "primefaces"
    "primeng"
    "primereact"
    "primevideo"
    "primevue"
    "printables"
    "prisma"
    "prismic"
    "privatedivision"
    "privateinternetaccess"
    "probot"
    "processingfoundation"
    "processwire"
    "producthunt"
    "progate"
    "progress"
    "prometheus"
    "pronounsdotpage"
    "prosieben"
    "proteus"
    "protocolsdotio"
    "protodotio"
    "proton"
    "protoncalendar"
    "protondb"
    "protondrive"
    "protonmail"
    "protonvpn"
    "protools"
    "protractor"
    "proxmox"
    "pterodactyl"
    "pubg"
    "publons"
    "pubmed"
    "pug"
    "pulumi"
    "puma"
    "puppet"
    "puppeteer"
    "purescript"
    "purgecss"
    "purism"
    "pushbullet"
    "pusher"
    "pwa"
    "pycharm"
    "pycqa"
    "pydantic"
    "pyg"
    "pypi"
    "pypy"
    "pyscaffold"
    "pysyft"
    "pytest"
    "python"
    "pythonanywhere"
    "pytorch"
    "pyup"
    "qantas"
    "qase"
    "qatarairways"
    "qbittorrent"
    "qemu"
    "qgis"
    "qi"
    "qiita"
    "qiskit"
    "qiwi"
    "qlik"
    "qmk"
    "qnap"
    "qt"
    "qualcomm"
    "qualtrics"
    "qualys"
    "quantcast"
    "quantconnect"
    "quarkus"
    "quarto"
    "quasar"
    "qubesos"
    "quest"
    "quickbooks"
    "quicklook"
    "quicktime"
    "quicktype"
    "quip"
    "quizlet"
    "quora"
    "qwant"
    "qwik"
    "qwiklabs"
    "qzone"
    "r"
    "r3"
    "rabbitmq"
    "racket"
    "radar"
    "radarr"
    "radiopublic"
    "radixui"
    "radstudio"
    "railway"
    "rainmeter"
    "rakuten"
    "ram"
    "rancher"
    "rapid"
    "rarible"
    "rasa"
    "raspberrypi"
    "ravelry"
    "ray"
    "raycast"
    "raylib"
    "razer"
    "razorpay"
    "rclone"
    "react"
    "reactbootstrap"
    "reacthookform"
    "reactiveresume"
    "reactivex"
    "reactos"
    "reactquery"
    "reactrouter"
    "reacttable"
    "readdotcv"
    "readme"
    "readthedocs"
    "realm"
    "reason"
    "reasonstudios"
    "recoil"
    "red"
    "redash"
    "redbubble"
    "redbull"
    "redcandlegames"
    "reddit"
    "redhat"
    "redhatopenshift"
    "redis"
    "redmine"
    "redox"
    "redragon"
    "redsys"
    "redux"
    "reduxsaga"
    "redwoodjs"
    "reebok"
    "refine"
    "relay"
    "relianceindustrieslimited"
    "remark"
    "remedyentertainment"
    "remix"
    "removedotbg"
    "renault"
    "render"
    "renovate"
    "renpy"
    "renren"
    "replit"
    "republicofgamers"
    "rescript"
    "rescuetime"
    "researchgate"
    "resend"
    "resharper"
    "resurrectionremixos"
    "retool"
    "retroarch"
    "retropie"
    "revanced"
    "revealdotjs"
    "reverbnation"
    "revoltdotchat"
    "revolut"
    "revue"
    "rewe"
    "rezgo"
    "rhinoceros"
    "rich"
    "rider"
    "rimacautomobili"
    "rime"
    "ring"
    "riotgames"
    "ripple"
    "riscv"
    "riseup"
    "ritzcarlton"
    "rive"
    "roadmapdotsh"
    "roamresearch"
    "robinhood"
    "roblox"
    "robloxstudio"
    "roboflow"
    "robotframework"
    "rocket"
    "rocketdotchat"
    "rocksdb"
    "rockstargames"
    "rockwellautomation"
    "rockylinux"
    "roku"
    "roll20"
    "rollsroyce"
    "rollupdotjs"
    "roon"
    "rootme"
    "roots"
    "rootsbedrock"
    "rootssage"
    "ros"
    "rossmann"
    "rotaryinternational"
    "rottentomatoes"
    "roundcube"
    "rsocket"
    "rss"
    "rstudioide"
    "rte"
    "rtl"
    "rtlzwei"
    "rtm"
    "rubocop"
    "ruby"
    "rubygems"
    "rubymine"
    "rubyonrails"
    "rubysinatra"
    "ruff"
    "rumahweb"
    "rumble"
    "rundeck"
    "runkeeper"
    "runkit"
    "runrundotit"
    "rust"
    "rustdesk"
    "rxdb"
    "ryanair"
    "rye"
    "s7airlines"
    "sabanci"
    "safari"
    "sage"
    "sahibinden"
    "sailfishos"
    "sailsdotjs"
    "salesforce"
    "salla"
    "saltproject"
    "samsclub"
    "samsung"
    "samsungpay"
    "sandisk"
    "sanfranciscomunicipalrailway"
    "sanic"
    "sanity"
    "saopaulometro"
    "sap"
    "sartorius"
    "sass"
    "sat1"
    "satellite"
    "saturn"
    "saucelabs"
    "saudia"
    "scala"
    "scaleway"
    "scania"
    "schneiderelectric"
    "scikitlearn"
    "scilab"
    "scipy"
    "scopus"
    "scpfoundation"
    "scrapbox"
    "scrapy"
    "scratch"
    "screencastify"
    "scribd"
    "scrimba"
    "scrollreveal"
    "scrumalliance"
    "scrutinizerci"
    "scylladb"
    "seagate"
    "searxng"
    "seat"
    "seatgeek"
    "securityscorecard"
    "sefaria"
    "sega"
    "selenium"
    "sellfy"
    "semanticrelease"
    "semanticscholar"
    "semanticui"
    "semanticuireact"
    "semanticweb"
    "semaphoreci"
    "semrush"
    "semver"
    "sencha"
    "sendgrid"
    "sennheiser"
    "sensu"
    "sentry"
    "sepa"
    "sequelize"
    "serverfault"
    "serverless"
    "session"
    "sessionize"
    "setapp"
    "sfml"
    "shadcnui"
    "shadow"
    "shanghaimetro"
    "sharex"
    "sharp"
    "shazam"
    "shell"
    "shelly"
    "shenzhenmetro"
    "shieldsdotio"
    "shikimori"
    "shopee"
    "shopify"
    "shopware"
    "shortcut"
    "showpad"
    "showtime"
    "showwcase"
    "shutterstock"
    "sidekiq"
    "sidequest"
    "siemens"
    "sifive"
    "signal"
    "similarweb"
    "simkl"
    "simpleanalytics"
    "simpleicons"
    "simplelogin"
    "simplenote"
    "sinaweibo"
    "singaporeairlines"
    "singlestore"
    "sitecore"
    "sitepoint"
    "siyuan"
    "skaffold"
    "sketch"
    "sketchfab"
    "sketchup"
    "skillshare"
    "skoda"
    "sky"
    "skypack"
    "skyrock"
    "slack"
    "slackware"
    "slashdot"
    "slickpic"
    "slides"
    "slideshare"
    "slint"
    "smart"
    "smartthings"
    "smashdotgg"
    "smashingmagazine"
    "smrt"
    "smugmug"
    "snapchat"
    "snapcraft"
    "snapdragon"
    "sncf"
    "snort"
    "snowflake"
    "snowpack"
    "snyk"
    "socialblade"
    "society6"
    "socketdotio"
    "softpedia"
    "sogou"
    "solana"
    "solid"
    "solidity"
    "sololearn"
    "solus"
    "sonar"
    "sonarcloud"
    "sonarlint"
    "sonarqube"
    "sonarr"
    "sonatype"
    "songkick"
    "songoda"
    "sonicwall"
    "sonos"
    "sony"
    "soriana"
    "soundcharts"
    "soundcloud"
    "sourceengine"
    "sourceforge"
    "sourcehut"
    "sourcetree"
    "southwestairlines"
    "spacemacs"
    "spaceship"
    "spacex"
    "spacy"
    "sparkar"
    "sparkasse"
    "sparkfun"
    "sparkpost"
    "spdx"
    "speakerdeck"
    "spectrum"
    "speedtest"
    "speedypage"
    "sphinx"
    "spigotmc"
    "spine"
    "spinnaker"
    "spinrilla"
    "splunk"
    "spoj"
    "spond"
    "spotify"
    "spotlight"
    "spreadshirt"
    "spreaker"
    "spring"
    "springcreators"
    "springboot"
    "springsecurity"
    "spyderide"
    "sqlalchemy"
    "sqlite"
    "square"
    "squareenix"
    "squarespace"
    "srgssr"
    "ssrn"
    "sst"
    "stackbit"
    "stackblitz"
    "stackedit"
    "stackexchange"
    "stackhawk"
    "stackoverflow"
    "stackpath"
    "stackshare"
    "stadia"
    "staffbase"
    "stagetimer"
    "standardjs"
    "standardresume"
    "starbucks"
    "stardock"
    "starlingbank"
    "starship"
    "startrek"
    "starz"
    "statamic"
    "statista"
    "statuspage"
    "statuspal"
    "steam"
    "steamdb"
    "steamdeck"
    "steamworks"
    "steelseries"
    "steem"
    "steemit"
    "steinberg"
    "stellar"
    "stencil"
    "stencyl"
    "stimulus"
    "stitcher"
    "stmicroelectronics"
    "stockx"
    "stopstalk"
    "storyblok"
    "storybook"
    "strapi"
    "strava"
    "streamlabs"
    "streamlit"
    "streamrunners"
    "stripe"
    "strongswan"
    "stryker"
    "stubhub"
    "studio3t"
    "studyverse"
    "styledcomponents"
    "stylelint"
    "styleshare"
    "stylus"
    "subaru"
    "sublimetext"
    "substack"
    "subtitleedit"
    "subversion"
    "suckless"
    "sui"
    "sumologic"
    "suno"
    "sunrise"
    "supabase"
    "supercrease"
    "supermicro"
    "superuser"
    "surrealdb"
    "surveymonkey"
    "suse"
    "suzuki"
    "svelte"
    "svg"
    "svgdotjs"
    "svgo"
    "svgtrace"
    "swagger"
    "swarm"
    "sway"
    "swc"
    "swift"
    "swiggy"
    "swiper"
    "swr"
    "symantec"
    "symbolab"
    "symfony"
    "symphony"
    "sympy"
    "syncthing"
    "synology"
    "system76"
    "tabelog"
    "tableau"
    "tablecheck"
    "tacobell"
    "tado"
    "taichigraphics"
    "taichilang"
    "tails"
    "tailscale"
    "tailwindcss"
    "taipy"
    "taketwointeractivesoftware"
    "talend"
    "talenthouse"
    "talos"
    "tamiya"
    "tampermonkey"
    "taobao"
    "tapas"
    "target"
    "tarom"
    "task"
    "tasmota"
    "tata"
    "tauri"
    "taxbuzz"
    "tcs"
    "teal"
    "teamcity"
    "teamspeak"
    "teamviewer"
    "techcrunch"
    "ted"
    "teepublic"
    "teespring"
    "tekton"
    "tele5"
    "telegram"
    "telegraph"
    "telequebec"
    "temporal"
    "tencentqq"
    "tensorflow"
    "teradata"
    "teratail"
    "termius"
    "terraform"
    "tesco"
    "tesla"
    "testcafe"
    "testin"
    "testinglibrary"
    "testrail"
    "tether"
    "textpattern"
    "tga"
    "thangs"
    "thanos"
    "thealgorithms"
    "theboringcompany"
    "theconversation"
    "thefinals"
    "theguardian"
    "theirishtimes"
    "themighty"
    "themodelsresource"
    "themoviedatabase"
    "thenorthface"
    "theodinproject"
    "theregister"
    "thesoundsresource"
    "thespritersresource"
    "thewashingtonpost"
    "theweatherchannel"
    "thingiverse"
    "thinkpad"
    "thirdweb"
    "threadless"
    "threads"
    "threedotjs"
    "threema"
    "thumbtack"
    "thunderbird"
    "thunderstore"
    "thurgauerkantonalbank"
    "thymeleaf"
    "ticketmaster"
    "ticktick"
    "tidal"
    "tiddlywiki"
    "tide"
    "tidyverse"
    "tietoevry"
    "tiktok"
    "tildapublishing"
    "tile"
    "timescale"
    "tina"
    "tinder"
    "tindie"
    "tinkercad"
    "tinygrad"
    "tinyletter"
    "tistory"
    "tldraw"
    "tmobile"
    "tmux"
    "todoist"
    "toggl"
    "toggltrack"
    "tokyometro"
    "toll"
    "toml"
    "tomorrowland"
    "ton"
    "topcoder"
    "topdotgg"
    "toptal"
    "torbrowser"
    "torproject"
    "toshiba"
    "totvs"
    "tourbox"
    "tower"
    "toyota"
    "tplink"
    "tqdm"
    "traccar"
    "tradingview"
    "traefikmesh"
    "traefikproxy"
    "trailforks"
    "trainerroad"
    "trakt"
    "transifex"
    "transmission"
    "transportforireland"
    "transportforlondon"
    "travisci"
    "treehouse"
    "trello"
    "trendmicro"
    "treyarch"
    "tricentis"
    "trilium"
    "triller"
    "trillertv"
    "trino"
    "tripadvisor"
    "tripdotcom"
    "trivago"
    "trivy"
    "trove"
    "trpc"
    "truenas"
    "trueup"
    "trulia"
    "trustedshops"
    "trustpilot"
    "tryhackme"
    "tryitonline"
    "tsnode"
    "tubi"
    "tui"
    "tumblr"
    "tunein"
    "turbo"
    "turborepo"
    "turbosquid"
    "turkishairlines"
    "turso"
    "tutanota"
    "tv4play"
    "tvtime"
    "twilio"
    "twinkly"
    "twinmotion"
    "twitch"
    "typeform"
    "typeorm"
    "typer"
    "typescript"
    "typo3"
    "typst"
    "uber"
    "ubereats"
    "ubiquiti"
    "ubisoft"
    "ublockorigin"
    "ubuntu"
    "ubuntumate"
    "udacity"
    "udemy"
    "ufc"
    "uikit"
    "uipath"
    "ulule"
    "umami"
    "umbraco"
    "uml"
    "unacademy"
    "underarmour"
    "underscoredotjs"
    "undertale"
    "unicode"
    "unilever"
    "uniqlo"
    "uniqloja"
    "unitedairlines"
    "unitednations"
    "unity"
    "unjs"
    "unlicense"
    "unocss"
    "unpkg"
    "unraid"
    "unrealengine"
    "unsplash"
    "untappd"
    "upcloud"
    "uphold"
    "uplabs"
    "upptime"
    "ups"
    "upstash"
    "uptimekuma"
    "uptobox"
    "upwork"
    "usps"
    "utorrent"
    "uv"
    "v"
    "v2ex"
    "v8"
    "vaadin"
    "vagrant"
    "vala"
    "valorant"
    "valve"
    "vapor"
    "vault"
    "vaultwarden"
    "vauxhall"
    "vbulletin"
    "vectary"
    "vectorlogozone"
    "vectorworks"
    "veeam"
    "veed"
    "veepee"
    "vega"
    "vegas"
    "velog"
    "venmo"
    "vercel"
    "verdaccio"
    "veritas"
    "verizon"
    "vespa"
    "vestel"
    "vexxhost"
    "vfairs"
    "viadeo"
    "viaplay"
    "viber"
    "viblo"
    "victoriametrics"
    "victronenergy"
    "vim"
    "vimeo"
    "vimeolivestream"
    "virgin"
    "virginatlantic"
    "virginmedia"
    "virtualbox"
    "virustotal"
    "visa"
    "visx"
    "vite"
    "vitepress"
    "vitess"
    "vitest"
    "vivaldi"
    "vivawallet"
    "vivino"
    "vivint"
    "vivo"
    "vk"
    "vlcmediaplayer"
    "vmware"
    "vodafone"
    "voidlinux"
    "voipdotms"
    "volkswagen"
    "volvo"
    "vonage"
    "vorondesign"
    "vowpalwabbit"
    "vox"
    "vrchat"
    "vsco"
    "vscodium"
    "vtex"
    "vuedotjs"
    "vuetify"
    "vulkan"
    "vultr"
    "vyond"
    "w3schools"
    "wacom"
    "wagmi"
    "wagtail"
    "wails"
    "wakatime"
    "walkman"
    "wallabag"
    "walletconnect"
    "walmart"
    "wantedly"
    "wappalyzer"
    "warnerbros"
    "warp"
    "wasabi"
    "wasmcloud"
    "wasmer"
    "watchtower"
    "wattpad"
    "wayland"
    "waze"
    "wazirx"
    "wearos"
    "weasyl"
    "web3dotjs"
    "webassembly"
    "webauthn"
    "webcomponentsdotorg"
    "webdriverio"
    "webex"
    "webflow"
    "webgl"
    "webgpu"
    "weblate"
    "webmin"
    "webmoney"
    "webpack"
    "webrtc"
    "webstorm"
    "webtoon"
    "webtrees"
    "wechat"
    "wegame"
    "weightsandbiases"
    "welcometothejungle"
    "wellfound"
    "wellsfargo"
    "wemo"
    "westerndigital"
    "westernunion"
    "wetransfer"
    "wezterm"
    "wgpu"
    "whatsapp"
    "wheniwork"
    "wii"
    "wiiu"
    "wikidata"
    "wikidotgg"
    "wikidotjs"
    "wikimediacommons"
    "wikimediafoundation"
    "wikipedia"
    "wikiquote"
    "wikivoyage"
    "winamp"
    "wipro"
    "wire"
    "wireguard"
    "wireshark"
    "wise"
    "wish"
    "wistia"
    "wix"
    "wizzair"
    "wolfram"
    "wolframlanguage"
    "wolframmathematica"
    "wondershare"
    "wondersharefilmora"
    "woo"
    "woocommerce"
    "wordpress"
    "workplace"
    "worldhealthorganization"
    "wpengine"
    "wpexplorer"
    "wprocket"
    "writedotas"
    "wwe"
    "wwise"
    "wykop"
    "wyze"
    "x"
    "xampp"
    "xcode"
    "xdadevelopers"
    "xdotorg"
    "xendit"
    "xero"
    "xfce"
    "xiaohongshu"
    "xiaomi"
    "xing"
    "xml"
    "xmpp"
    "xo"
    "xrp"
    "xsplit"
    "xstate"
    "xubuntu"
    "yabai"
    "yale"
    "yamahacorporation"
    "yamahamotorcorporation"
    "yaml"
    "yandexcloud"
    "yarn"
    "ycombinator"
    "yelp"
    "yeti"
    "yii"
    "yoast"
    "youtube"
    "youtubegaming"
    "youtubekids"
    "youtubemusic"
    "youtubeshorts"
    "youtubestudio"
    "youtubetv"
    "yr"
    "yubico"
    "yunohost"
    "zabka"
    "zaim"
    "zalando"
    "zalo"
    "zap"
    "zapier"
    "zara"
    "zazzle"
    "zcash"
    "zcool"
    "zdf"
    "zebpay"
    "zebratechnologies"
    "zedindustries"
    "zelle"
    "zend"
    "zendesk"
    "zenn"
    "zenodo"
    "zensar"
    "zerodha"
    "zerotier"
    "zerply"
    "zettlr"
    "zhihu"
    "zig"
    "zigbee"
    "zigbee2mqtt"
    "ziggo"
    "zilch"
    "zillow"
    "zincsearch"
    "zingat"
    "zod"
    "zoho"
    "zoiper"
    "zomato"
    "zoom"
    "zorin"
    "zotero"
    "zsh"
    "zulip"
    "zyte")
  "List containing name of icons provided by simpleicons package.")

(TeX-add-style-hook
 "simpleicons"
 (lambda ()
   (TeX-add-symbols
    '("simpleicon" (TeX-arg-completing-read LaTeX-simpleicons-icons
                                            "Icon name")))

   ;; Fontification
   (when (and (featurep 'font-latex)
              (eq TeX-install-font-lock 'font-latex-setup))
     (font-latex-add-keywords '(("simpleicon" "{"))
                              'function)))
 TeX-dialect)

(defvar LaTeX-simpleicons-package-options nil
  "Package options for the simpleicons package.")

;;; simpleicons.el ends here
