--  generated parser support file. -*- buffer-read-only:t  -*-
--  command line: wisitoken-bnf-generate.exe  --generate LALR Ada_Emacs re2c PROCESS ada_annex_p.wy
--

--  Copyright (C) 2013 - 2022 Free Software Foundation, Inc.

--  This program is free software; you can redistribute it and/or
--  modify it under the terms of the GNU General Public License as
--  published by the Free Software Foundation; either version 3, or (at
--  your option) any later version.
--
--  This software is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
--  General Public License for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with GNU Emacs.  If not, see <https://www.gnu.org/licenses/>.

with SAL;
with WisiToken.Lexer.re2c;
with ada_annex_p_re2c_c;
with Ada_Annex_P_Process_Actions; use Ada_Annex_P_Process_Actions;
package body Ada_Annex_P_Process_LALR_Main is

   function Is_Block_Delimited (ID : in WisiToken.Token_ID) return Boolean
   is begin
      case To_Token_Enum (ID) is
      when
         COMMENT_ID |
         GNAT_PREP_IF_ID |
         GNAT_PREP_ELSIF_ID |
         GNAT_PREP_ELSE_ID |
         GNAT_PREP_END_IF_ID |
         CONFLICT_MARK_A_ID |
         CONFLICT_MARK_B_ID |
         CONFLICT_MARK_END_ID |
         PLACEHOLDER_ID |
         STRING_LITERAL_ID |
         CHARACTER_LITERAL_ID => return True;
      when others => return False;
      end case;
   end Is_Block_Delimited;

   function Same_Block_Delimiters (ID : in WisiToken.Token_ID) return Boolean
   is begin
      case To_Token_Enum (ID) is
      when COMMENT_ID => return False;
      when GNAT_PREP_IF_ID => return False;
      when GNAT_PREP_ELSIF_ID => return False;
      when GNAT_PREP_ELSE_ID => return False;
      when GNAT_PREP_END_IF_ID => return False;
      when CONFLICT_MARK_A_ID => return False;
      when CONFLICT_MARK_B_ID => return False;
      when CONFLICT_MARK_END_ID => return False;
      when PLACEHOLDER_ID => return False;
      when STRING_LITERAL_ID => return True;
      when CHARACTER_LITERAL_ID => return True;
      when others => return False;
      end case;
   end Same_Block_Delimiters;

   function Escape_Delimiter_Doubled (ID : in WisiToken.Token_ID) return Boolean
   is begin
      case To_Token_Enum (ID) is
      when STRING_LITERAL_ID => return True;
      when others => return False;
      end case;
   end Escape_Delimiter_Doubled;

   function Start_Delimiter_Length (ID : in WisiToken.Token_ID) return Integer
   is begin
      case To_Token_Enum (ID) is
      when COMMENT_ID => return 2;
      when GNAT_PREP_IF_ID => return 3;
      when GNAT_PREP_ELSIF_ID => return 6;
      when GNAT_PREP_ELSE_ID => return 5;
      when GNAT_PREP_END_IF_ID => return 7;
      when CONFLICT_MARK_A_ID => return 7;
      when CONFLICT_MARK_B_ID => return 7;
      when CONFLICT_MARK_END_ID => return 7;
      when PLACEHOLDER_ID => return 1;
      when STRING_LITERAL_ID => return 1;
      when CHARACTER_LITERAL_ID => return 1;
      when others => raise SAL.Programmer_Error; return 0;
      end case;
   end Start_Delimiter_Length;

   function End_Delimiter_Length (ID : in WisiToken.Token_ID) return Integer
   is begin
      case To_Token_Enum (ID) is
      when
         COMMENT_ID |
         GNAT_PREP_IF_ID |
         GNAT_PREP_ELSIF_ID |
         GNAT_PREP_ELSE_ID |
         GNAT_PREP_END_IF_ID |
         CONFLICT_MARK_A_ID |
         CONFLICT_MARK_B_ID |
         CONFLICT_MARK_END_ID |
         STRING_LITERAL_ID |
         CHARACTER_LITERAL_ID => return 1;
      when PLACEHOLDER_ID => return 1;
      when others => raise SAL.Programmer_Error; return 0;
      end case;
   end End_Delimiter_Length;

   function New_Line_Is_End_Delimiter (ID : in WisiToken.Token_ID) return Boolean
   is begin
      return
        (case To_Token_Enum (ID) is
         when COMMENT_ID => True,
         when GNAT_PREP_IF_ID => True,
         when GNAT_PREP_ELSIF_ID => True,
         when GNAT_PREP_ELSE_ID => True,
         when GNAT_PREP_END_IF_ID => True,
         when CONFLICT_MARK_A_ID => True,
         when CONFLICT_MARK_B_ID => True,
         when CONFLICT_MARK_END_ID => True,
         when PLACEHOLDER_ID => True,
         when STRING_LITERAL_ID => True,
         when CHARACTER_LITERAL_ID => True,
         when others => raise SAL.Programmer_Error);
   end New_Line_Is_End_Delimiter;

   function Find_End_Delimiter
     (Source      : in WisiToken.Lexer.Source;
      ID          : in WisiToken.Token_ID;
      Token_Start : in WisiToken.Buffer_Pos)
     return WisiToken.Buffer_Pos
   is begin
      return
        (case To_Token_Enum (ID) is
         when COMMENT_ID => WisiToken.Lexer.Find_New_Line (Source, Token_Start),
         when GNAT_PREP_IF_ID => WisiToken.Lexer.Find_New_Line (Source, Token_Start),
         when GNAT_PREP_ELSIF_ID => WisiToken.Lexer.Find_New_Line (Source, Token_Start),
         when GNAT_PREP_ELSE_ID => WisiToken.Lexer.Find_New_Line (Source, Token_Start),
         when GNAT_PREP_END_IF_ID => WisiToken.Lexer.Find_New_Line (Source, Token_Start),
         when CONFLICT_MARK_A_ID => WisiToken.Lexer.Find_New_Line (Source, Token_Start),
         when CONFLICT_MARK_B_ID => WisiToken.Lexer.Find_New_Line (Source, Token_Start),
         when CONFLICT_MARK_END_ID => WisiToken.Lexer.Find_New_Line (Source, Token_Start),
         when PLACEHOLDER_ID => WisiToken.Lexer.Find_String (Source, Token_Start, "}"),
         when STRING_LITERAL_ID => WisiToken.Lexer.Find_String_Or_New_Line (Source, Token_Start, """"),
         when CHARACTER_LITERAL_ID => WisiToken.Lexer.Find_String_Or_New_Line (Source, Token_Start, """"),
         when others => raise SAL.Programmer_Error);
   end Find_End_Delimiter;

   function Find_Scan_End
     (Source   : in WisiToken.Lexer.Source;
      ID       : in WisiToken.Token_ID;
      Region   : in WisiToken.Buffer_Region;
      Inserted : in Boolean;
      Start    : in Boolean)
     return WisiToken.Buffer_Pos
   is
      use WisiToken;
   begin
      return
        (case To_Token_Enum (ID) is
         when COMMENT_ID =>
         (if Inserted then Region.Last
          elsif Start then Region.Last
          else Lexer.Find_New_Line (Source, Region.Last)),
         when GNAT_PREP_IF_ID =>
         (if Inserted then Region.Last
          elsif Start then Region.Last
          else Lexer.Find_New_Line (Source, Region.Last)),
         when GNAT_PREP_ELSIF_ID =>
         (if Inserted then Region.Last
          elsif Start then Region.Last
          else Lexer.Find_New_Line (Source, Region.Last)),
         when GNAT_PREP_ELSE_ID =>
         (if Inserted then Region.Last
          elsif Start then Region.Last
          else Lexer.Find_New_Line (Source, Region.Last)),
         when GNAT_PREP_END_IF_ID =>
         (if Inserted then Region.Last
          elsif Start then Region.Last
          else Lexer.Find_New_Line (Source, Region.Last)),
         when CONFLICT_MARK_A_ID =>
         (if Inserted then Region.Last
          elsif Start then Region.Last
          else Lexer.Find_New_Line (Source, Region.Last)),
         when CONFLICT_MARK_B_ID =>
         (if Inserted then Region.Last
          elsif Start then Region.Last
          else Lexer.Find_New_Line (Source, Region.Last)),
         when CONFLICT_MARK_END_ID =>
         (if Inserted then Region.Last
          elsif Start then Region.Last
          else Lexer.Find_New_Line (Source, Region.Last)),
         when PLACEHOLDER_ID =>
         (if Inserted then Region.Last
          elsif Start then Region.Last
          else Lexer.Find_String_Or_New_Line (Source, Region.Last, "{")),
         when STRING_LITERAL_ID => Lexer.Find_New_Line (Source, Region.Last),
         when CHARACTER_LITERAL_ID => Lexer.Find_New_Line (Source, Region.Last),
         when others => raise SAL.Programmer_Error);
   end Find_Scan_End;

   function Contains_End_Delimiter
     (Source : in WisiToken.Lexer.Source;
      ID     : in WisiToken.Token_ID;
      Region : in WisiToken.Buffer_Region)
     return WisiToken.Base_Buffer_Pos
   is
      use WisiToken;
   begin
      return
        (case To_Token_Enum (ID) is
         when COMMENT_ID => Lexer.Find_New_Line (Source, Region),
         when GNAT_PREP_IF_ID => Lexer.Find_New_Line (Source, Region),
         when GNAT_PREP_ELSIF_ID => Lexer.Find_New_Line (Source, Region),
         when GNAT_PREP_ELSE_ID => Lexer.Find_New_Line (Source, Region),
         when GNAT_PREP_END_IF_ID => Lexer.Find_New_Line (Source, Region),
         when CONFLICT_MARK_A_ID => Lexer.Find_New_Line (Source, Region),
         when CONFLICT_MARK_B_ID => Lexer.Find_New_Line (Source, Region),
         when CONFLICT_MARK_END_ID => Lexer.Find_New_Line (Source, Region),
         when PLACEHOLDER_ID => Lexer.Find_String_Or_New_Line (Source, Region, "}"),
         when STRING_LITERAL_ID => Lexer.Find_String_Or_New_Line (Source, Region, """"),
         when CHARACTER_LITERAL_ID => Lexer.Find_String_Or_New_Line (Source, Region, "'"),
         when others => raise SAL.Programmer_Error);
   end Contains_End_Delimiter;

   function Line_Begin_Char_Pos
    (Source : in WisiToken.Lexer.Source;
     Token  : in WisiToken.Lexer.Token;
     Line   : in WisiToken.Line_Number_Type)
   return WisiToken.Buffer_Pos
   is
      pragma Unreferenced (Source, Line);
      use all type WisiToken.Base_Buffer_Pos;
   begin
      case To_Token_Enum (Token.ID) is
      when NEW_LINE_ID => return Token.Char_Region.Last + 1;
      when COMMENT_ID => return Token.Char_Region.Last + 1;
      when GNAT_PREP_IF_ID => return Token.Char_Region.Last + 1;
      when GNAT_PREP_ELSIF_ID => return Token.Char_Region.Last + 1;
      when GNAT_PREP_ELSE_ID => return Token.Char_Region.Last + 1;
      when GNAT_PREP_END_IF_ID => return Token.Char_Region.Last + 1;
      when CONFLICT_MARK_A_ID => return Token.Char_Region.Last + 1;
      when CONFLICT_MARK_B_ID => return Token.Char_Region.Last + 1;
      when CONFLICT_MARK_END_ID => return Token.Char_Region.Last + 1;
      when others => raise SAL.Programmer_Error;
      end case;
   end Line_Begin_Char_Pos;

   function Can_Contain_New_Line (ID : in WisiToken.Token_ID) return Boolean
   is begin
      case To_Token_Enum (ID) is
      when NEW_LINE_ID => return True;
      when COMMENT_ID => return True;
      when GNAT_PREP_IF_ID => return True;
      when GNAT_PREP_ELSIF_ID => return True;
      when GNAT_PREP_ELSE_ID => return True;
      when GNAT_PREP_END_IF_ID => return True;
      when CONFLICT_MARK_A_ID => return True;
      when CONFLICT_MARK_B_ID => return True;
      when CONFLICT_MARK_END_ID => return True;
      when others => return False;
      end case;
   end Can_Contain_New_Line;

   function Terminated_By_New_Line (ID : in WisiToken.Token_ID) return Boolean
   is begin
      case To_Token_Enum (ID) is
      when NEW_LINE_ID => return True;
      when COMMENT_ID => return True;
      when GNAT_PREP_IF_ID => return True;
      when GNAT_PREP_ELSIF_ID => return True;
      when GNAT_PREP_ELSE_ID => return True;
      when GNAT_PREP_END_IF_ID => return True;
      when CONFLICT_MARK_A_ID => return True;
      when CONFLICT_MARK_B_ID => return True;
      when CONFLICT_MARK_END_ID => return True;
      when STRING_LITERAL_ID => return True;
      when CHARACTER_LITERAL_ID => return True;
      when others => return False;
      end case;
   end Terminated_By_New_Line;

   package Lexer is new WisiToken.Lexer.re2c
     (ada_annex_p_re2c_c.New_Lexer,
      ada_annex_p_re2c_c.Free_Lexer,
      ada_annex_p_re2c_c.Reset_Lexer,
      ada_annex_p_re2c_c.Set_Verbosity,
      ada_annex_p_re2c_c.Set_Position,
      ada_annex_p_re2c_c.Next_Token,
      Is_Block_Delimited,
      Same_Block_Delimiters,
      Escape_Delimiter_Doubled,
      Start_Delimiter_Length,
      End_Delimiter_Length,
      New_Line_Is_End_Delimiter,
      Find_End_Delimiter,
      Contains_End_Delimiter,
      Find_Scan_End,
      Line_Begin_Char_Pos,
      Can_Contain_New_Line,
      Terminated_By_New_Line);

   function Create_Parse_Table
     return WisiToken.Parse.LR.Parse_Table_Ptr
   is
      use WisiToken.Parse.LR;
      McKenzie_Param : constant McKenzie_Param_Type :=
        (First_Terminal    => 11,
         Last_Terminal     => 119,
         First_Nonterminal => 120,
         Last_Nonterminal  => 466,
         Insert =>
           (4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 4, 4, 4, 4, 4,
            4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 4, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
            4, 4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 4, 3, 4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 4, 2, 4, 4,
            4),
         Delete =>
           (3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
            3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
            3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
            3),
         Push_Back =>
           (2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2),
         Undo_Reduce =>
           (2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2),
         Minimal_Complete_Cost_Delta => -3,
         Fast_Forward =>  2,
         Matching_Begin =>  1,
         Ignore_Check_Fail  => 2,
         Check_Limit => 4,
         Zombie_Limit => 4,
         Check_Delta_Limit => 100,
         Enqueue_Limit => 58000);

      Table : constant Parse_Table_Ptr := new Parse_Table
        (State_First       => 0,
         State_Last        => 2402,
         First_Terminal    => 11,
         Last_Terminal     => 119,
         First_Nonterminal => 120,
         Last_Nonterminal  => 466);
   begin
      declare
         procedure Subr_1
         is begin
            Table.States (0).Action_List.Set_Capacity (41);
            Add_Action (Table.States (0), 12, (401, 0), 1);
            Add_Action (Table.States (0), 13, (393, 0), 2);
            Add_Action (Table.States (0), 15, (370, 0), 3);
            Add_Action (Table.States (0), 17, (365, 0), 4);
            Add_Action (Table.States (0), 18, (382, 0), 5);
            Add_Action (Table.States (0), 19, (363, 0), 6);
            Add_Action (Table.States (0), 20, (357, 0), 7);
            Add_Action (Table.States (0), 21, (356, 4), 8);
            Add_Action (Table.States (0), 22, (339, 0), 9);
            Add_Action (Table.States (0), 25, (329, 1), 10);
            Add_Action (Table.States (0), 27, (384, 1), 11);
            Add_Action (Table.States (0), 28, (325, 0), 12);
            Add_Action (Table.States (0), 30, (316, 0), 13);
            Add_Action (Table.States (0), 31, (290, 0), 14);
            Add_Action (Table.States (0), 32, (289, 0), 15);
            Add_Action (Table.States (0), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (0), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (0), 37, (288, 0), 17);
            Add_Conflict (Table.States (0), 37, (285, 1),  0);
            Add_Action (Table.States (0), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (0), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (0), 41, (271, 0), 18);
            Add_Action (Table.States (0), 50, (332, 0), 19);
            Add_Action (Table.States (0), 51, (437, 0), 20);
            Add_Conflict (Table.States (0), 51, (285, 1),  0);
            Add_Action (Table.States (0), 52, (329, 0), 21);
            Add_Action (Table.States (0), 53, (294, 0), 22);
            Add_Action (Table.States (0), 54, (293, 0), 23);
            Add_Action (Table.States (0), 59, (346, 0), 24);
            Add_Action (Table.States (0), 60, (340, 0), 25);
            Add_Action (Table.States (0), 61, (387, 1), 26);
            Add_Action (Table.States (0), 64, (273, 0), 27);
            Add_Action (Table.States (0), 65, (264, 0), 28);
            Add_Action (Table.States (0), 77, (386, 0), 29);
            Add_Action (Table.States (0), 81, (130, 0), 30);
            Add_Action (Table.States (0), 83, (128, 0), 31);
            Add_Action (Table.States (0), 84, (124, 0), 32);
            Add_Action (Table.States (0), 86, (252, 0), 33);
            Add_Action (Table.States (0), 90, (268, 0), 34);
            Add_Action (Table.States (0), 105, (265, 0), 35);
            Add_Action (Table.States (0), 116, (136, 0), 36);
            Add_Action (Table.States (0), 117, (196, 1), 37);
            Add_Action (Table.States (0), 118, (195, 6), 38);
            Table.States (0).Goto_List.Set_Capacity (106);
            Add_Goto (Table.States (0), 124, 39);
            Add_Goto (Table.States (0), 126, 40);
            Add_Goto (Table.States (0), 127, 41);
            Add_Goto (Table.States (0), 128, 42);
            Add_Goto (Table.States (0), 130, 43);
            Add_Goto (Table.States (0), 135, 44);
            Add_Goto (Table.States (0), 136, 45);
            Add_Goto (Table.States (0), 137, 46);
            Add_Goto (Table.States (0), 180, 47);
            Add_Goto (Table.States (0), 189, 48);
            Add_Goto (Table.States (0), 190, 49);
            Add_Goto (Table.States (0), 193, 50);
            Add_Goto (Table.States (0), 194, 51);
            Add_Goto (Table.States (0), 195, 52);
            Add_Goto (Table.States (0), 196, 53);
            Add_Goto (Table.States (0), 197, 54);
            Add_Goto (Table.States (0), 198, 55);
            Add_Goto (Table.States (0), 199, 56);
            Add_Goto (Table.States (0), 201, 57);
            Add_Goto (Table.States (0), 251, 58);
            Add_Goto (Table.States (0), 252, 59);
            Add_Goto (Table.States (0), 255, 60);
            Add_Goto (Table.States (0), 261, 61);
            Add_Goto (Table.States (0), 262, 62);
            Add_Goto (Table.States (0), 263, 63);
            Add_Goto (Table.States (0), 264, 64);
            Add_Goto (Table.States (0), 265, 65);
            Add_Goto (Table.States (0), 266, 66);
            Add_Goto (Table.States (0), 267, 67);
            Add_Goto (Table.States (0), 268, 68);
            Add_Goto (Table.States (0), 271, 69);
            Add_Goto (Table.States (0), 273, 70);
            Add_Goto (Table.States (0), 275, 71);
            Add_Goto (Table.States (0), 285, 72);
            Add_Goto (Table.States (0), 286, 73);
            Add_Goto (Table.States (0), 288, 74);
            Add_Goto (Table.States (0), 289, 75);
            Add_Goto (Table.States (0), 290, 76);
            Add_Goto (Table.States (0), 291, 77);
            Add_Goto (Table.States (0), 292, 78);
            Add_Goto (Table.States (0), 293, 79);
            Add_Goto (Table.States (0), 294, 80);
            Add_Goto (Table.States (0), 309, 81);
            Add_Goto (Table.States (0), 310, 82);
            Add_Goto (Table.States (0), 311, 83);
            Add_Goto (Table.States (0), 316, 84);
            Add_Goto (Table.States (0), 318, 85);
            Add_Goto (Table.States (0), 320, 86);
            Add_Goto (Table.States (0), 321, 87);
            Add_Goto (Table.States (0), 322, 88);
            Add_Goto (Table.States (0), 325, 89);
            Add_Goto (Table.States (0), 326, 90);
            Add_Goto (Table.States (0), 327, 91);
            Add_Goto (Table.States (0), 328, 92);
            Add_Goto (Table.States (0), 329, 93);
            Add_Goto (Table.States (0), 330, 94);
            Add_Goto (Table.States (0), 332, 95);
            Add_Goto (Table.States (0), 333, 96);
            Add_Goto (Table.States (0), 334, 97);
            Add_Goto (Table.States (0), 335, 98);
            Add_Goto (Table.States (0), 336, 99);
            Add_Goto (Table.States (0), 337, 100);
            Add_Goto (Table.States (0), 338, 101);
            Add_Goto (Table.States (0), 339, 102);
            Add_Goto (Table.States (0), 340, 103);
            Add_Goto (Table.States (0), 341, 104);
            Add_Goto (Table.States (0), 345, 105);
            Add_Goto (Table.States (0), 346, 106);
            Add_Goto (Table.States (0), 347, 107);
            Add_Goto (Table.States (0), 354, 108);
            Add_Goto (Table.States (0), 356, 109);
            Add_Goto (Table.States (0), 357, 110);
            Add_Goto (Table.States (0), 363, 111);
            Add_Goto (Table.States (0), 364, 112);
            Add_Goto (Table.States (0), 365, 113);
            Add_Goto (Table.States (0), 366, 114);
            Add_Goto (Table.States (0), 367, 115);
            Add_Goto (Table.States (0), 370, 116);
            Add_Goto (Table.States (0), 376, 117);
            Add_Goto (Table.States (0), 378, 118);
            Add_Goto (Table.States (0), 379, 119);
            Add_Goto (Table.States (0), 382, 120);
            Add_Goto (Table.States (0), 383, 121);
            Add_Goto (Table.States (0), 384, 122);
            Add_Goto (Table.States (0), 385, 123);
            Add_Goto (Table.States (0), 386, 124);
            Add_Goto (Table.States (0), 387, 125);
            Add_Goto (Table.States (0), 388, 126);
            Add_Goto (Table.States (0), 389, 127);
            Add_Goto (Table.States (0), 390, 128);
            Add_Goto (Table.States (0), 391, 129);
            Add_Goto (Table.States (0), 392, 130);
            Add_Goto (Table.States (0), 393, 131);
            Add_Goto (Table.States (0), 394, 132);
            Add_Goto (Table.States (0), 401, 133);
            Add_Goto (Table.States (0), 403, 134);
            Add_Goto (Table.States (0), 404, 135);
            Add_Goto (Table.States (0), 405, 136);
            Add_Goto (Table.States (0), 406, 137);
            Add_Goto (Table.States (0), 408, 138);
            Add_Goto (Table.States (0), 431, 139);
            Add_Goto (Table.States (0), 437, 140);
            Add_Goto (Table.States (0), 438, 141);
            Add_Goto (Table.States (0), 440, 142);
            Add_Goto (Table.States (0), 454, 143);
            Add_Goto (Table.States (0), 462, 144);
            Table.States (1).Action_List.Set_Capacity (6);
            Add_Action (Table.States (1), 86, (252, 0), 33);
            Add_Action (Table.States (1), 90, (268, 0), 34);
            Add_Action (Table.States (1), 108, (401, 0), 145);
            Add_Action (Table.States (1), 116, (196, 0), 146);
            Add_Action (Table.States (1), 117, (196, 1), 37);
            Add_Action (Table.States (1), 118, (195, 6), 38);
            Table.States (1).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (1), 195, 147);
            Add_Goto (Table.States (1), 196, 148);
            Add_Goto (Table.States (1), 197, 54);
            Add_Goto (Table.States (1), 198, 55);
            Add_Goto (Table.States (1), 199, 56);
            Add_Goto (Table.States (1), 201, 57);
            Add_Goto (Table.States (1), 251, 58);
            Add_Goto (Table.States (1), 252, 59);
            Add_Goto (Table.States (1), 255, 60);
            Add_Goto (Table.States (1), 268, 68);
            Add_Goto (Table.States (1), 311, 83);
            Table.States (1).Kernel := To_Vector ((((401, 0),  12,  1, (32767, 0),  0), ((401, 1),  12,  4, (32767, 0),
             0), ((401, 2),  12,  2, (32767, 0),  0)));
            Table.States (1).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (401, 0),  108, 145)));
            Table.States (2).Action_List.Set_Capacity (1);
            Add_Action (Table.States (2), 85, (393, 0), 149);
            Table.States (2).Kernel := To_Vector ((0 => ((393, 0),  13,  9, (32767, 0),  0)));
            Table.States (2).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (393, 0),  85, 149)));
            Table.States (3).Action_List.Set_Capacity (9);
            Add_Action (Table.States (3), 14, (375, 0), 150);
            Add_Action (Table.States (3), 17, (365, 0), 4);
            Add_Action (Table.States (3), 20, (357, 0), 7);
            Add_Action (Table.States (3), 63, (371, 0), 151);
            Add_Action (Table.States (3), 86, (252, 0), 33);
            Add_Action (Table.States (3), 90, (268, 0), 34);
            Add_Action (Table.States (3), 116, (196, 0), 146);
            Add_Action (Table.States (3), 117, (196, 1), 37);
            Add_Action (Table.States (3), 118, (195, 6), 38);
            Table.States (3).Goto_List.Set_Capacity (25);
            Add_Goto (Table.States (3), 195, 152);
            Add_Goto (Table.States (3), 196, 148);
            Add_Goto (Table.States (3), 197, 54);
            Add_Goto (Table.States (3), 198, 55);
            Add_Goto (Table.States (3), 199, 56);
            Add_Goto (Table.States (3), 201, 57);
            Add_Goto (Table.States (3), 251, 58);
            Add_Goto (Table.States (3), 252, 59);
            Add_Goto (Table.States (3), 255, 60);
            Add_Goto (Table.States (3), 268, 68);
            Add_Goto (Table.States (3), 310, 153);
            Add_Goto (Table.States (3), 311, 83);
            Add_Goto (Table.States (3), 357, 154);
            Add_Goto (Table.States (3), 364, 155);
            Add_Goto (Table.States (3), 365, 113);
            Add_Goto (Table.States (3), 366, 114);
            Add_Goto (Table.States (3), 368, 156);
            Add_Goto (Table.States (3), 369, 157);
            Add_Goto (Table.States (3), 371, 158);
            Add_Goto (Table.States (3), 372, 159);
            Add_Goto (Table.States (3), 373, 160);
            Add_Goto (Table.States (3), 374, 161);
            Add_Goto (Table.States (3), 375, 162);
            Add_Goto (Table.States (3), 377, 163);
            Add_Goto (Table.States (3), 380, 164);
            Table.States (3).Kernel := To_Vector ((((370, 0),  15,  8, (32767, 0),  0), ((370, 1),  15,  5, (32767, 0),
             0), ((376, 0),  15,  9, (32767, 0),  0), ((378, 0),  15,  8, (32767, 0),  0), ((379, 0),  15,  9, (32767,
            0),  0)));
            Table.States (3).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (375, 0),  14, 150)));
            Table.States (4).Action_List.Set_Capacity (15);
            Add_Action (Table.States (4), 12, (402, 0), 165);
            Add_Action (Table.States (4), 16, (365, 0), 166);
            Add_Action (Table.States (4), 44, (233, 2), 167);
            Add_Action (Table.States (4), 52, (233, 3), 168);
            Add_Action (Table.States (4), 65, (234, 1), 169);
            Add_Action (Table.States (4), 76, (256, 0), 170);
            Add_Action (Table.States (4), 85, (205, 4), 171);
            Add_Action (Table.States (4), 86, (213, 2), 172);
            Add_Action (Table.States (4), 90, (268, 0), 34);
            Add_Action (Table.States (4), 106, (237, 1), 173);
            Add_Action (Table.States (4), 107, (237, 0), 174);
            Add_Action (Table.States (4), 115, (234, 0), 175);
            Add_Action (Table.States (4), 116, (196, 0), 146);
            Add_Action (Table.States (4), 117, (196, 1), 37);
            Add_Action (Table.States (4), 118, (195, 6), 38);
            Table.States (4).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (4), 195, 176);
            Add_Goto (Table.States (4), 196, 148);
            Add_Goto (Table.States (4), 197, 54);
            Add_Goto (Table.States (4), 198, 55);
            Add_Goto (Table.States (4), 199, 56);
            Add_Goto (Table.States (4), 201, 57);
            Add_Goto (Table.States (4), 205, 177);
            Add_Goto (Table.States (4), 206, 178);
            Add_Goto (Table.States (4), 210, 179);
            Add_Goto (Table.States (4), 211, 180);
            Add_Goto (Table.States (4), 213, 181);
            Add_Goto (Table.States (4), 214, 182);
            Add_Goto (Table.States (4), 215, 183);
            Add_Goto (Table.States (4), 218, 184);
            Add_Goto (Table.States (4), 219, 185);
            Add_Goto (Table.States (4), 220, 186);
            Add_Goto (Table.States (4), 227, 187);
            Add_Goto (Table.States (4), 228, 188);
            Add_Goto (Table.States (4), 231, 189);
            Add_Goto (Table.States (4), 232, 190);
            Add_Goto (Table.States (4), 233, 191);
            Add_Goto (Table.States (4), 234, 192);
            Add_Goto (Table.States (4), 237, 193);
            Add_Goto (Table.States (4), 251, 58);
            Add_Goto (Table.States (4), 252, 59);
            Add_Goto (Table.States (4), 255, 60);
            Add_Goto (Table.States (4), 256, 194);
            Add_Goto (Table.States (4), 268, 68);
            Add_Goto (Table.States (4), 311, 83);
            Add_Goto (Table.States (4), 402, 195);
            Add_Goto (Table.States (4), 465, 196);
            Table.States (4).Kernel := To_Vector ((((365, 0),  17,  3, (32767, 0),  0), ((366, 0),  17,  2, (32767, 0),
             0)));
            Table.States (4).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (5).Action_List.Set_Capacity (5);
            Add_Action (Table.States (5), 86, (252, 0), 33);
            Add_Action (Table.States (5), 90, (268, 0), 34);
            Add_Action (Table.States (5), 116, (196, 0), 146);
            Add_Action (Table.States (5), 117, (196, 1), 37);
            Add_Action (Table.States (5), 118, (195, 6), 38);
            Table.States (5).Goto_List.Set_Capacity (12);
            Add_Goto (Table.States (5), 195, 197);
            Add_Goto (Table.States (5), 196, 148);
            Add_Goto (Table.States (5), 197, 54);
            Add_Goto (Table.States (5), 198, 55);
            Add_Goto (Table.States (5), 199, 56);
            Add_Goto (Table.States (5), 201, 57);
            Add_Goto (Table.States (5), 251, 58);
            Add_Goto (Table.States (5), 252, 59);
            Add_Goto (Table.States (5), 255, 60);
            Add_Goto (Table.States (5), 268, 68);
            Add_Goto (Table.States (5), 306, 198);
            Add_Goto (Table.States (5), 311, 83);
            Table.States (5).Kernel := To_Vector ((0 => ((382, 0),  18,  2, (32767, 0),  0)));
            Table.States (5).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (6).Action_List.Set_Capacity (5);
            Add_Action (Table.States (6), 86, (252, 0), 33);
            Add_Action (Table.States (6), 90, (268, 0), 34);
            Add_Action (Table.States (6), 116, (196, 0), 146);
            Add_Action (Table.States (6), 117, (196, 1), 37);
            Add_Action (Table.States (6), 118, (195, 6), 38);
            Table.States (6).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (6), 195, 199);
            Add_Goto (Table.States (6), 196, 148);
            Add_Goto (Table.States (6), 197, 54);
            Add_Goto (Table.States (6), 198, 55);
            Add_Goto (Table.States (6), 199, 56);
            Add_Goto (Table.States (6), 201, 57);
            Add_Goto (Table.States (6), 251, 58);
            Add_Goto (Table.States (6), 252, 59);
            Add_Goto (Table.States (6), 255, 60);
            Add_Goto (Table.States (6), 268, 68);
            Add_Goto (Table.States (6), 311, 83);
            Table.States (6).Kernel := To_Vector ((((363, 0),  19,  4, (32767, 0),  0), ((363, 1),  19,  2, (32767, 0),
             0)));
            Table.States (6).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (7).Action_List.Set_Capacity (2);
            Add_Action (Table.States (7), 116, (196, 0), 146);
            Add_Action (Table.States (7), 117, (196, 1), 37);
            Table.States (7).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (7), 196, 200);
            Table.States (7).Kernel := To_Vector ((((357, 0),  20,  9, (32767, 0),  0), ((357, 1),  20,  5, (32767, 0),
             0), ((357, 2),  20,  6, (32767, 0),  0), ((357, 3),  20,  2, (32767, 0),  0)));
            Table.States (7).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (8).Action_List.Set_Capacity (1);
            Add_Action (Table.States (8), 116, (356, 4), 201);
            Table.States (8).Kernel := To_Vector ((((356, 4),  21,  7, (32767, 0),  0), ((356, 5),  21,  5, (32767, 0),
             0), ((356, 6),  21,  4, (32767, 0),  0), ((356, 7),  21,  2, (32767, 0),  0)));
            Table.States (8).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (356, 4),  116, 201)));
            Table.States (9).Action_List.Set_Capacity (8);
            Add_Action (Table.States (9), 28, (339, 0), 202);
            Add_Conflict (Table.States (9), 28, (406, 1),  1);
            Add_Action (Table.States (9), 50, (332, 0), 19);
            Add_Action (Table.States (9), 53, (339, 4), 203);
            Add_Conflict (Table.States (9), 53, (406, 1),  1);
            Add_Action (Table.States (9), 54, (339, 2), 204);
            Add_Conflict (Table.States (9), 54, (406, 1),  1);
            Add_Action (Table.States (9), 61, (426, 0), 205);
            Add_Action (Table.States (9), 83, (411, 0), 206);
            Add_Action (Table.States (9), 84, (124, 0), 32);
            Add_Action (Table.States (9), 116, (136, 0), 207);
            Table.States (9).Goto_List.Set_Capacity (15);
            Add_Goto (Table.States (9), 124, 208);
            Add_Goto (Table.States (9), 136, 209);
            Add_Goto (Table.States (9), 330, 210);
            Add_Goto (Table.States (9), 332, 95);
            Add_Goto (Table.States (9), 333, 96);
            Add_Goto (Table.States (9), 407, 211);
            Add_Goto (Table.States (9), 409, 212);
            Add_Goto (Table.States (9), 410, 213);
            Add_Goto (Table.States (9), 411, 214);
            Add_Goto (Table.States (9), 412, 215);
            Add_Goto (Table.States (9), 425, 216);
            Add_Goto (Table.States (9), 426, 217);
            Add_Goto (Table.States (9), 427, 218);
            Add_Goto (Table.States (9), 430, 219);
            Add_Goto (Table.States (9), 464, 220);
            Table.States (9).Kernel := To_Vector ((((339, 0),  22,  7, (32767, 0),  0), ((339, 1),  22,  5, (32767, 0),
             0), ((339, 2),  22,  7, (32767, 0),  0), ((339, 3),  22,  5, (32767, 0),  0), ((339, 4),  22,  7, (32767,
            0),  0), ((339, 5),  22,  5, (32767, 0),  0), ((406, 0),  22,  3, (32767, 0),  0), ((406, 1),  22,  0,
            (406, 1),  1)));
            Table.States (9).Minimal_Complete_Actions := To_Vector (((Shift, (411, 0),  83, 206), (Reduce, (406, 1),
            1)));
            Table.States (10).Action_List.Set_Capacity (3);
            Add_Action (Table.States (10), (21, 53, 54), (329, 1),  1);
            Table.States (10).Kernel := To_Vector ((0 => ((329, 1),  25,  0, (329, 1),  1)));
            Table.States (10).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (329, 1),  1)));
            Table.States (11).Action_List.Set_Capacity (14);
            Add_Action (Table.States (11), 22, (339, 0), 9);
            Add_Action (Table.States (11), 25, (329, 1), 10);
            Add_Action (Table.States (11), 28, (325, 0), 12);
            Add_Action (Table.States (11), 50, (332, 0), 19);
            Add_Action (Table.States (11), 51, (437, 0), 221);
            Add_Action (Table.States (11), 52, (329, 0), 21);
            Add_Action (Table.States (11), 53, (294, 0), 22);
            Add_Action (Table.States (11), 54, (293, 0), 23);
            Add_Action (Table.States (11), 59, (346, 0), 24);
            Add_Action (Table.States (11), 60, (340, 0), 25);
            Add_Action (Table.States (11), 61, (387, 0), 222);
            Add_Action (Table.States (11), 81, (130, 0), 30);
            Add_Action (Table.States (11), 83, (128, 0), 31);
            Add_Action (Table.States (11), 116, (136, 0), 223);
            Table.States (11).Goto_List.Set_Capacity (56);
            Add_Goto (Table.States (11), 126, 40);
            Add_Goto (Table.States (11), 127, 41);
            Add_Goto (Table.States (11), 128, 42);
            Add_Goto (Table.States (11), 130, 43);
            Add_Goto (Table.States (11), 135, 44);
            Add_Goto (Table.States (11), 136, 45);
            Add_Goto (Table.States (11), 137, 46);
            Add_Goto (Table.States (11), 180, 47);
            Add_Goto (Table.States (11), 189, 48);
            Add_Goto (Table.States (11), 190, 224);
            Add_Goto (Table.States (11), 193, 50);
            Add_Goto (Table.States (11), 194, 51);
            Add_Goto (Table.States (11), 291, 77);
            Add_Goto (Table.States (11), 292, 78);
            Add_Goto (Table.States (11), 293, 79);
            Add_Goto (Table.States (11), 294, 80);
            Add_Goto (Table.States (11), 309, 81);
            Add_Goto (Table.States (11), 320, 86);
            Add_Goto (Table.States (11), 321, 87);
            Add_Goto (Table.States (11), 322, 88);
            Add_Goto (Table.States (11), 325, 89);
            Add_Goto (Table.States (11), 326, 90);
            Add_Goto (Table.States (11), 327, 91);
            Add_Goto (Table.States (11), 328, 92);
            Add_Goto (Table.States (11), 329, 225);
            Add_Goto (Table.States (11), 330, 94);
            Add_Goto (Table.States (11), 332, 95);
            Add_Goto (Table.States (11), 333, 96);
            Add_Goto (Table.States (11), 334, 97);
            Add_Goto (Table.States (11), 335, 98);
            Add_Goto (Table.States (11), 336, 99);
            Add_Goto (Table.States (11), 337, 100);
            Add_Goto (Table.States (11), 338, 101);
            Add_Goto (Table.States (11), 339, 102);
            Add_Goto (Table.States (11), 340, 103);
            Add_Goto (Table.States (11), 341, 104);
            Add_Goto (Table.States (11), 345, 105);
            Add_Goto (Table.States (11), 346, 106);
            Add_Goto (Table.States (11), 347, 107);
            Add_Goto (Table.States (11), 354, 108);
            Add_Goto (Table.States (11), 388, 126);
            Add_Goto (Table.States (11), 389, 127);
            Add_Goto (Table.States (11), 390, 128);
            Add_Goto (Table.States (11), 391, 129);
            Add_Goto (Table.States (11), 392, 130);
            Add_Goto (Table.States (11), 394, 132);
            Add_Goto (Table.States (11), 403, 134);
            Add_Goto (Table.States (11), 404, 135);
            Add_Goto (Table.States (11), 405, 136);
            Add_Goto (Table.States (11), 406, 137);
            Add_Goto (Table.States (11), 408, 138);
            Add_Goto (Table.States (11), 431, 139);
            Add_Goto (Table.States (11), 437, 140);
            Add_Goto (Table.States (11), 438, 141);
            Add_Goto (Table.States (11), 440, 142);
            Add_Goto (Table.States (11), 454, 143);
            Table.States (11).Kernel := To_Vector ((((384, 1),  27,  3, (32767, 0),  0), ((387, 0),  27,  3, (32767,
            0),  0)));
            Table.States (11).Minimal_Complete_Actions := To_Vector (((Shift, (128, 0),  83, 31), (Shift, (387, 0),
            61, 222)));
         end Subr_1;
         procedure Subr_2
         is begin
            Table.States (12).Action_List.Set_Capacity (6);
            Add_Action (Table.States (12), 26, (326, 0), 226);
            Add_Action (Table.States (12), 86, (252, 0), 33);
            Add_Action (Table.States (12), 90, (268, 0), 34);
            Add_Action (Table.States (12), 116, (196, 0), 146);
            Add_Action (Table.States (12), 117, (196, 1), 37);
            Add_Action (Table.States (12), 118, (195, 6), 38);
            Table.States (12).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (12), 195, 227);
            Add_Goto (Table.States (12), 196, 148);
            Add_Goto (Table.States (12), 197, 54);
            Add_Goto (Table.States (12), 198, 55);
            Add_Goto (Table.States (12), 199, 56);
            Add_Goto (Table.States (12), 201, 57);
            Add_Goto (Table.States (12), 251, 58);
            Add_Goto (Table.States (12), 252, 59);
            Add_Goto (Table.States (12), 255, 60);
            Add_Goto (Table.States (12), 268, 68);
            Add_Goto (Table.States (12), 311, 83);
            Table.States (12).Kernel := To_Vector ((((325, 0),  28,  12, (32767, 0),  0), ((325, 1),  28,  9, (32767,
            0),  0), ((325, 2),  28,  8, (32767, 0),  0), ((325, 3),  28,  9, (32767, 0),  0), ((325, 4),  28,  6,
            (32767, 0),  0), ((325, 5),  28,  5, (32767, 0),  0), ((325, 6),  28,  10, (32767, 0),  0), ((325, 7),  28,
             7, (32767, 0),  0), ((325, 8),  28,  6, (32767, 0),  0), ((325, 9),  28,  7, (32767, 0),  0), ((325, 10),
            28,  4, (32767, 0),  0), ((325, 11),  28,  3, (32767, 0),  0), ((326, 0),  28,  10, (32767, 0),  0), ((326,
            1),  28,  7, (32767, 0),  0), ((326, 2),  28,  8, (32767, 0),  0), ((326, 3),  28,  5, (32767, 0),  0),
            ((337, 0),  28,  6, (32767, 0),  0), ((337, 1),  28,  4, (32767, 0),  0), ((390, 0),  28,  7, (32767, 0),
            0), ((390, 1),  28,  5, (32767, 0),  0), ((408, 0),  28,  7, (32767, 0),  0), ((408, 1),  28,  5, (32767,
            0),  0)));
            Table.States (12).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (13).Action_List.Set_Capacity (15);
            Add_Action (Table.States (13), 12, (402, 0), 165);
            Add_Action (Table.States (13), 44, (233, 2), 167);
            Add_Action (Table.States (13), 52, (233, 3), 168);
            Add_Action (Table.States (13), 65, (234, 1), 169);
            Add_Action (Table.States (13), 76, (256, 0), 170);
            Add_Action (Table.States (13), 85, (205, 4), 171);
            Add_Action (Table.States (13), 86, (213, 2), 172);
            Add_Action (Table.States (13), 90, (268, 0), 34);
            Add_Action (Table.States (13), 106, (237, 1), 173);
            Add_Action (Table.States (13), 107, (237, 0), 174);
            Add_Action (Table.States (13), 108, (316, 1), 228);
            Add_Action (Table.States (13), 115, (234, 0), 175);
            Add_Action (Table.States (13), 116, (196, 0), 229);
            Add_Action (Table.States (13), 117, (196, 1), 37);
            Add_Action (Table.States (13), 118, (195, 6), 38);
            Table.States (13).Goto_List.Set_Capacity (32);
            Add_Goto (Table.States (13), 195, 176);
            Add_Goto (Table.States (13), 196, 148);
            Add_Goto (Table.States (13), 197, 54);
            Add_Goto (Table.States (13), 198, 55);
            Add_Goto (Table.States (13), 199, 56);
            Add_Goto (Table.States (13), 201, 57);
            Add_Goto (Table.States (13), 205, 177);
            Add_Goto (Table.States (13), 206, 178);
            Add_Goto (Table.States (13), 210, 179);
            Add_Goto (Table.States (13), 211, 180);
            Add_Goto (Table.States (13), 213, 181);
            Add_Goto (Table.States (13), 214, 182);
            Add_Goto (Table.States (13), 215, 183);
            Add_Goto (Table.States (13), 218, 184);
            Add_Goto (Table.States (13), 219, 185);
            Add_Goto (Table.States (13), 220, 186);
            Add_Goto (Table.States (13), 227, 230);
            Add_Goto (Table.States (13), 228, 188);
            Add_Goto (Table.States (13), 231, 189);
            Add_Goto (Table.States (13), 232, 190);
            Add_Goto (Table.States (13), 233, 191);
            Add_Goto (Table.States (13), 234, 192);
            Add_Goto (Table.States (13), 237, 193);
            Add_Goto (Table.States (13), 251, 58);
            Add_Goto (Table.States (13), 252, 59);
            Add_Goto (Table.States (13), 255, 60);
            Add_Goto (Table.States (13), 256, 194);
            Add_Goto (Table.States (13), 268, 68);
            Add_Goto (Table.States (13), 311, 83);
            Add_Goto (Table.States (13), 317, 231);
            Add_Goto (Table.States (13), 402, 195);
            Add_Goto (Table.States (13), 465, 196);
            Table.States (13).Kernel := To_Vector ((((316, 0),  30,  2, (32767, 0),  0), ((316, 1),  30,  1, (32767,
            0),  0), ((318, 0),  30,  9, (32767, 0),  0), ((318, 1),  30,  4, (32767, 0),  0)));
            Table.States (13).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (316, 1),  108, 228)));
            Table.States (14).Action_List.Set_Capacity (5);
            Add_Action (Table.States (14), 86, (252, 0), 33);
            Add_Action (Table.States (14), 90, (268, 0), 34);
            Add_Action (Table.States (14), 116, (196, 0), 146);
            Add_Action (Table.States (14), 117, (196, 1), 37);
            Add_Action (Table.States (14), 118, (195, 6), 38);
            Table.States (14).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (14), 195, 232);
            Add_Goto (Table.States (14), 196, 148);
            Add_Goto (Table.States (14), 197, 54);
            Add_Goto (Table.States (14), 198, 55);
            Add_Goto (Table.States (14), 199, 56);
            Add_Goto (Table.States (14), 201, 57);
            Add_Goto (Table.States (14), 251, 58);
            Add_Goto (Table.States (14), 252, 59);
            Add_Goto (Table.States (14), 255, 60);
            Add_Goto (Table.States (14), 268, 68);
            Add_Goto (Table.States (14), 311, 83);
            Table.States (14).Kernel := To_Vector ((0 => ((290, 0),  31,  2, (32767, 0),  0)));
            Table.States (14).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (15).Action_List.Set_Capacity (7);
            Add_Action (Table.States (15), 63, (289, 2), 233);
            Add_Action (Table.States (15), 86, (252, 0), 33);
            Add_Action (Table.States (15), 90, (268, 0), 34);
            Add_Action (Table.States (15), 108, (289, 3), 234);
            Add_Action (Table.States (15), 116, (196, 0), 146);
            Add_Action (Table.States (15), 117, (196, 1), 37);
            Add_Action (Table.States (15), 118, (195, 6), 38);
            Table.States (15).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (15), 195, 235);
            Add_Goto (Table.States (15), 196, 148);
            Add_Goto (Table.States (15), 197, 54);
            Add_Goto (Table.States (15), 198, 55);
            Add_Goto (Table.States (15), 199, 56);
            Add_Goto (Table.States (15), 201, 57);
            Add_Goto (Table.States (15), 251, 58);
            Add_Goto (Table.States (15), 252, 59);
            Add_Goto (Table.States (15), 255, 60);
            Add_Goto (Table.States (15), 268, 68);
            Add_Goto (Table.States (15), 311, 83);
            Table.States (15).Kernel := To_Vector ((((289, 0),  32,  4, (32767, 0),  0), ((289, 1),  32,  2, (32767,
            0),  0), ((289, 2),  32,  3, (32767, 0),  0), ((289, 3),  32,  1, (32767, 0),  0)));
            Table.States (15).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (289, 3),  108, 234)));
            Table.States (16).Action_List.Set_Capacity (14);
            Add_Action (Table.States (16), 12, (402, 0), 165);
            Add_Action (Table.States (16), 44, (233, 2), 167);
            Add_Action (Table.States (16), 52, (233, 3), 168);
            Add_Action (Table.States (16), 65, (234, 1), 169);
            Add_Action (Table.States (16), 76, (256, 0), 170);
            Add_Action (Table.States (16), 85, (205, 4), 171);
            Add_Action (Table.States (16), 86, (213, 2), 172);
            Add_Action (Table.States (16), 90, (268, 0), 34);
            Add_Action (Table.States (16), 106, (237, 1), 173);
            Add_Action (Table.States (16), 107, (237, 0), 174);
            Add_Action (Table.States (16), 115, (234, 0), 175);
            Add_Action (Table.States (16), 116, (196, 0), 146);
            Add_Action (Table.States (16), 117, (196, 1), 37);
            Add_Action (Table.States (16), 118, (195, 6), 38);
            Table.States (16).Goto_List.Set_Capacity (32);
            Add_Goto (Table.States (16), 195, 176);
            Add_Goto (Table.States (16), 196, 148);
            Add_Goto (Table.States (16), 197, 54);
            Add_Goto (Table.States (16), 198, 55);
            Add_Goto (Table.States (16), 199, 56);
            Add_Goto (Table.States (16), 201, 57);
            Add_Goto (Table.States (16), 205, 177);
            Add_Goto (Table.States (16), 206, 178);
            Add_Goto (Table.States (16), 210, 179);
            Add_Goto (Table.States (16), 211, 180);
            Add_Goto (Table.States (16), 213, 181);
            Add_Goto (Table.States (16), 214, 182);
            Add_Goto (Table.States (16), 215, 183);
            Add_Goto (Table.States (16), 218, 184);
            Add_Goto (Table.States (16), 219, 185);
            Add_Goto (Table.States (16), 220, 186);
            Add_Goto (Table.States (16), 227, 236);
            Add_Goto (Table.States (16), 228, 188);
            Add_Goto (Table.States (16), 231, 189);
            Add_Goto (Table.States (16), 232, 190);
            Add_Goto (Table.States (16), 233, 191);
            Add_Goto (Table.States (16), 234, 192);
            Add_Goto (Table.States (16), 237, 193);
            Add_Goto (Table.States (16), 243, 237);
            Add_Goto (Table.States (16), 251, 58);
            Add_Goto (Table.States (16), 252, 59);
            Add_Goto (Table.States (16), 255, 60);
            Add_Goto (Table.States (16), 256, 194);
            Add_Goto (Table.States (16), 268, 68);
            Add_Goto (Table.States (16), 311, 83);
            Add_Goto (Table.States (16), 402, 195);
            Add_Goto (Table.States (16), 465, 196);
            Table.States (16).Kernel := To_Vector ((0 => ((276, 0),  35,  1, (32767, 0),  0)));
            Table.States (16).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (17).Action_List.Set_Capacity (3);
            Add_Action (Table.States (17), 33, (288, 0), 238);
            Add_Action (Table.States (17), 51, (276, 3), 239);
            Add_Action (Table.States (17), 85, (276, 5), 240);
            Table.States (17).Kernel := To_Vector ((((276, 3),  37,  9, (32767, 0),  0), ((276, 5),  37,  7, (32767,
            0),  0), ((276, 6),  37,  4, (32767, 0),  0), ((276, 7),  37,  7, (32767, 0),  0), ((276, 8),  37,  4,
            (32767, 0),  0), ((288, 0),  37,  9, (32767, 0),  0)));
            Table.States (17).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (276, 3),  51, 239)));
            Table.States (18).Action_List.Set_Capacity (14);
            Add_Action (Table.States (18), 12, (402, 0), 165);
            Add_Action (Table.States (18), 44, (233, 2), 167);
            Add_Action (Table.States (18), 52, (233, 3), 168);
            Add_Action (Table.States (18), 65, (234, 1), 169);
            Add_Action (Table.States (18), 76, (256, 0), 170);
            Add_Action (Table.States (18), 85, (205, 4), 171);
            Add_Action (Table.States (18), 86, (213, 2), 172);
            Add_Action (Table.States (18), 90, (268, 0), 34);
            Add_Action (Table.States (18), 106, (237, 1), 173);
            Add_Action (Table.States (18), 107, (237, 0), 174);
            Add_Action (Table.States (18), 115, (234, 0), 175);
            Add_Action (Table.States (18), 116, (196, 0), 146);
            Add_Action (Table.States (18), 117, (196, 1), 37);
            Add_Action (Table.States (18), 118, (195, 6), 38);
            Table.States (18).Goto_List.Set_Capacity (32);
            Add_Goto (Table.States (18), 195, 176);
            Add_Goto (Table.States (18), 196, 148);
            Add_Goto (Table.States (18), 197, 54);
            Add_Goto (Table.States (18), 198, 55);
            Add_Goto (Table.States (18), 199, 56);
            Add_Goto (Table.States (18), 201, 57);
            Add_Goto (Table.States (18), 205, 177);
            Add_Goto (Table.States (18), 206, 178);
            Add_Goto (Table.States (18), 210, 179);
            Add_Goto (Table.States (18), 211, 180);
            Add_Goto (Table.States (18), 213, 181);
            Add_Goto (Table.States (18), 214, 182);
            Add_Goto (Table.States (18), 215, 183);
            Add_Goto (Table.States (18), 218, 184);
            Add_Goto (Table.States (18), 219, 185);
            Add_Goto (Table.States (18), 220, 186);
            Add_Goto (Table.States (18), 227, 236);
            Add_Goto (Table.States (18), 228, 188);
            Add_Goto (Table.States (18), 231, 189);
            Add_Goto (Table.States (18), 232, 190);
            Add_Goto (Table.States (18), 233, 191);
            Add_Goto (Table.States (18), 234, 192);
            Add_Goto (Table.States (18), 237, 193);
            Add_Goto (Table.States (18), 243, 241);
            Add_Goto (Table.States (18), 251, 58);
            Add_Goto (Table.States (18), 252, 59);
            Add_Goto (Table.States (18), 255, 60);
            Add_Goto (Table.States (18), 256, 194);
            Add_Goto (Table.States (18), 268, 68);
            Add_Goto (Table.States (18), 311, 83);
            Add_Goto (Table.States (18), 402, 195);
            Add_Goto (Table.States (18), 465, 196);
            Table.States (18).Kernel := To_Vector ((((271, 0),  41,  15, (32767, 0),  0), ((271, 1),  41,  12, (32767,
            0),  0), ((271, 2),  41,  10, (32767, 0),  0), ((271, 3),  41,  7, (32767, 0),  0)));
            Table.States (18).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (19).Action_List.Set_Capacity (7);
            Add_Action (Table.States (19), 55, (333, 0), 242);
            Add_Action (Table.States (19), 83, (333, 1), 243);
            Add_Action (Table.States (19), 86, (252, 0), 33);
            Add_Action (Table.States (19), 90, (268, 0), 34);
            Add_Action (Table.States (19), 116, (196, 0), 146);
            Add_Action (Table.States (19), 117, (196, 1), 37);
            Add_Action (Table.States (19), 118, (195, 6), 38);
            Table.States (19).Goto_List.Set_Capacity (12);
            Add_Goto (Table.States (19), 195, 244);
            Add_Goto (Table.States (19), 196, 148);
            Add_Goto (Table.States (19), 197, 54);
            Add_Goto (Table.States (19), 198, 55);
            Add_Goto (Table.States (19), 199, 56);
            Add_Goto (Table.States (19), 201, 57);
            Add_Goto (Table.States (19), 251, 58);
            Add_Goto (Table.States (19), 252, 59);
            Add_Goto (Table.States (19), 255, 60);
            Add_Goto (Table.States (19), 268, 68);
            Add_Goto (Table.States (19), 311, 83);
            Add_Goto (Table.States (19), 331, 245);
            Table.States (19).Kernel := To_Vector ((((332, 0),  50,  2, (32767, 0),  0), ((333, 0),  50,  4, (32767,
            0),  0), ((333, 1),  50,  3, (32767, 0),  0)));
            Table.States (19).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (20).Action_List.Set_Capacity (6);
            Add_Action (Table.States (20), 85, (283, 1), 246);
            Add_Action (Table.States (20), 86, (252, 0), 33);
            Add_Action (Table.States (20), 90, (268, 0), 34);
            Add_Action (Table.States (20), 116, (196, 0), 247);
            Add_Action (Table.States (20), 117, (196, 1), 37);
            Add_Action (Table.States (20), 118, (195, 6), 38);
            Table.States (20).Goto_List.Set_Capacity (16);
            Add_Goto (Table.States (20), 195, 248);
            Add_Goto (Table.States (20), 196, 249);
            Add_Goto (Table.States (20), 197, 54);
            Add_Goto (Table.States (20), 198, 55);
            Add_Goto (Table.States (20), 199, 56);
            Add_Goto (Table.States (20), 201, 57);
            Add_Goto (Table.States (20), 251, 58);
            Add_Goto (Table.States (20), 252, 59);
            Add_Goto (Table.States (20), 255, 60);
            Add_Goto (Table.States (20), 268, 68);
            Add_Goto (Table.States (20), 278, 250);
            Add_Goto (Table.States (20), 280, 251);
            Add_Goto (Table.States (20), 282, 252);
            Add_Goto (Table.States (20), 283, 253);
            Add_Goto (Table.States (20), 299, 254);
            Add_Goto (Table.States (20), 311, 83);
            Table.States (20).Kernel := To_Vector ((((276, 1),  51,  3, (32767, 0),  0), ((276, 2),  51,  3, (32767,
            0),  0), ((276, 4),  51,  8, (32767, 0),  0), ((437, 0),  51,  6, (32767, 0),  0), ((438, 0),  51,  5,
            (32767, 0),  0), ((440, 0),  51,  19, (32767, 0),  0), ((440, 1),  51,  18, (32767, 0),  0), ((440, 2),
            51,  11, (32767, 0),  0), ((440, 3),  51,  10, (32767, 0),  0), ((440, 4),  51,  15, (32767, 0),  0),
            ((440, 5),  51,  14, (32767, 0),  0), ((440, 6),  51,  7, (32767, 0),  0), ((440, 7),  51,  6, (32767, 0),
            0), ((454, 0),  51,  5, (32767, 0),  0)));
            Table.States (20).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 247)));
            Table.States (21).Action_List.Set_Capacity (1);
            Add_Action (Table.States (21), 25, (329, 0), 255);
            Table.States (21).Kernel := To_Vector ((0 => ((329, 0),  52,  1, (32767, 0),  0)));
            Table.States (21).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (329, 0),  25, 255)));
            Table.States (22).Action_List.Set_Capacity (5);
            Add_Action (Table.States (22), 86, (252, 0), 33);
            Add_Action (Table.States (22), 90, (268, 0), 34);
            Add_Action (Table.States (22), 116, (196, 0), 146);
            Add_Action (Table.States (22), 117, (196, 1), 37);
            Add_Action (Table.States (22), 118, (195, 6), 38);
            Table.States (22).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (22), 195, 256);
            Add_Goto (Table.States (22), 196, 148);
            Add_Goto (Table.States (22), 197, 54);
            Add_Goto (Table.States (22), 198, 55);
            Add_Goto (Table.States (22), 199, 56);
            Add_Goto (Table.States (22), 201, 57);
            Add_Goto (Table.States (22), 251, 58);
            Add_Goto (Table.States (22), 252, 59);
            Add_Goto (Table.States (22), 255, 60);
            Add_Goto (Table.States (22), 268, 68);
            Add_Goto (Table.States (22), 311, 83);
            Table.States (22).Kernel := To_Vector ((((294, 0),  53,  3, (32767, 0),  0), ((408, 8),  53,  7, (32767,
            0),  0), ((408, 9),  53,  5, (32767, 0),  0)));
            Table.States (22).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (23).Action_List.Set_Capacity (5);
            Add_Action (Table.States (23), 86, (252, 0), 33);
            Add_Action (Table.States (23), 90, (268, 0), 34);
            Add_Action (Table.States (23), 116, (196, 0), 146);
            Add_Action (Table.States (23), 117, (196, 1), 37);
            Add_Action (Table.States (23), 118, (195, 6), 38);
            Table.States (23).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (23), 195, 257);
            Add_Goto (Table.States (23), 196, 148);
            Add_Goto (Table.States (23), 197, 54);
            Add_Goto (Table.States (23), 198, 55);
            Add_Goto (Table.States (23), 199, 56);
            Add_Goto (Table.States (23), 201, 57);
            Add_Goto (Table.States (23), 251, 58);
            Add_Goto (Table.States (23), 252, 59);
            Add_Goto (Table.States (23), 255, 60);
            Add_Goto (Table.States (23), 268, 68);
            Add_Goto (Table.States (23), 311, 83);
            Table.States (23).Kernel := To_Vector ((((293, 0),  54,  1, (32767, 0),  0), ((408, 4),  54,  7, (32767,
            0),  0), ((408, 5),  54,  5, (32767, 0),  0)));
            Table.States (23).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (24).Action_List.Set_Capacity (3);
            Add_Action (Table.States (24), 26, (354, 0), 258);
            Add_Action (Table.States (24), 83, (346, 0), 259);
            Add_Action (Table.States (24), 116, (347, 0), 260);
            Table.States (24).Kernel := To_Vector ((((346, 0),  59,  15, (32767, 0),  0), ((346, 1),  59,  12, (32767,
            0),  0), ((346, 2),  59,  13, (32767, 0),  0), ((346, 3),  59,  10, (32767, 0),  0), ((346, 4),  59,  10,
            (32767, 0),  0), ((346, 5),  59,  7, (32767, 0),  0), ((346, 6),  59,  8, (32767, 0),  0), ((346, 7),  59,
            5, (32767, 0),  0), ((347, 0),  59,  9, (32767, 0),  0), ((347, 1),  59,  6, (32767, 0),  0), ((347, 2),
            59,  7, (32767, 0),  0), ((347, 3),  59,  4, (32767, 0),  0), ((354, 0),  59,  10, (32767, 0),  0), ((354,
            1),  59,  7, (32767, 0),  0), ((354, 2),  59,  8, (32767, 0),  0), ((354, 3),  59,  5, (32767, 0),  0),
            ((392, 0),  59,  7, (32767, 0),  0), ((392, 1),  59,  5, (32767, 0),  0)));
            Table.States (24).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (347, 0),  116, 260)));
            Table.States (25).Action_List.Set_Capacity (3);
            Add_Action (Table.States (25), 26, (345, 0), 261);
            Add_Action (Table.States (25), 83, (340, 0), 262);
            Add_Action (Table.States (25), 116, (341, 0), 263);
            Table.States (25).Kernel := To_Vector ((((340, 0),  60,  18, (32767, 0),  0), ((340, 1),  60,  15, (32767,
            0),  0), ((340, 2),  60,  10, (32767, 0),  0), ((340, 3),  60,  16, (32767, 0),  0), ((340, 4),  60,  13,
            (32767, 0),  0), ((340, 5),  60,  8, (32767, 0),  0), ((340, 6),  60,  13, (32767, 0),  0), ((340, 7),  60,
             10, (32767, 0),  0), ((340, 8),  60,  5, (32767, 0),  0), ((340, 9),  60,  11, (32767, 0),  0), ((340,
            10),  60,  8, (32767, 0),  0), ((340, 11),  60,  3, (32767, 0),  0), ((341, 0),  60,  12, (32767, 0),  0),
            ((341, 1),  60,  9, (32767, 0),  0), ((341, 2),  60,  4, (32767, 0),  0), ((341, 3),  60,  10, (32767, 0),
            0), ((341, 4),  60,  7, (32767, 0),  0), ((341, 5),  60,  2, (32767, 0),  0), ((345, 0),  60,  10, (32767,
            0),  0), ((345, 1),  60,  8, (32767, 0),  0), ((391, 0),  60,  7, (32767, 0),  0), ((391, 1),  60,  5,
            (32767, 0),  0)));
            Table.States (25).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (341, 0),  116, 263)));
            Table.States (26).Action_List.Set_Capacity (5);
            Add_Action (Table.States (26), 86, (252, 0), 33);
            Add_Action (Table.States (26), 90, (268, 0), 34);
            Add_Action (Table.States (26), 116, (196, 0), 146);
            Add_Action (Table.States (26), 117, (196, 1), 37);
            Add_Action (Table.States (26), 118, (195, 6), 38);
            Table.States (26).Goto_List.Set_Capacity (12);
            Add_Goto (Table.States (26), 195, 244);
            Add_Goto (Table.States (26), 196, 148);
            Add_Goto (Table.States (26), 197, 54);
            Add_Goto (Table.States (26), 198, 55);
            Add_Goto (Table.States (26), 199, 56);
            Add_Goto (Table.States (26), 201, 57);
            Add_Goto (Table.States (26), 251, 58);
            Add_Goto (Table.States (26), 252, 59);
            Add_Goto (Table.States (26), 255, 60);
            Add_Goto (Table.States (26), 268, 68);
            Add_Goto (Table.States (26), 311, 83);
            Add_Goto (Table.States (26), 331, 264);
            Table.States (26).Kernel := To_Vector ((0 => ((387, 1),  61,  2, (32767, 0),  0)));
            Table.States (26).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (27).Action_List.Set_Capacity (14);
            Add_Action (Table.States (27), 12, (402, 0), 165);
            Add_Action (Table.States (27), 44, (233, 2), 167);
            Add_Action (Table.States (27), 52, (233, 3), 168);
            Add_Action (Table.States (27), 65, (234, 1), 169);
            Add_Action (Table.States (27), 76, (256, 0), 170);
            Add_Action (Table.States (27), 85, (205, 4), 171);
            Add_Action (Table.States (27), 86, (213, 2), 172);
            Add_Action (Table.States (27), 90, (268, 0), 34);
            Add_Action (Table.States (27), 106, (237, 1), 173);
            Add_Action (Table.States (27), 107, (237, 0), 174);
            Add_Action (Table.States (27), 115, (234, 0), 175);
            Add_Action (Table.States (27), 116, (196, 0), 146);
            Add_Action (Table.States (27), 117, (196, 1), 37);
            Add_Action (Table.States (27), 118, (195, 6), 38);
            Table.States (27).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (27), 195, 176);
            Add_Goto (Table.States (27), 196, 148);
            Add_Goto (Table.States (27), 197, 54);
            Add_Goto (Table.States (27), 198, 55);
            Add_Goto (Table.States (27), 199, 56);
            Add_Goto (Table.States (27), 201, 57);
            Add_Goto (Table.States (27), 205, 177);
            Add_Goto (Table.States (27), 206, 178);
            Add_Goto (Table.States (27), 210, 179);
            Add_Goto (Table.States (27), 211, 180);
            Add_Goto (Table.States (27), 213, 181);
            Add_Goto (Table.States (27), 214, 182);
            Add_Goto (Table.States (27), 215, 183);
            Add_Goto (Table.States (27), 218, 184);
            Add_Goto (Table.States (27), 219, 185);
            Add_Goto (Table.States (27), 220, 186);
            Add_Goto (Table.States (27), 227, 265);
            Add_Goto (Table.States (27), 228, 188);
            Add_Goto (Table.States (27), 231, 189);
            Add_Goto (Table.States (27), 232, 190);
            Add_Goto (Table.States (27), 233, 191);
            Add_Goto (Table.States (27), 234, 192);
            Add_Goto (Table.States (27), 237, 193);
            Add_Goto (Table.States (27), 251, 58);
            Add_Goto (Table.States (27), 252, 59);
            Add_Goto (Table.States (27), 255, 60);
            Add_Goto (Table.States (27), 256, 194);
            Add_Goto (Table.States (27), 268, 68);
            Add_Goto (Table.States (27), 311, 83);
            Add_Goto (Table.States (27), 402, 195);
            Add_Goto (Table.States (27), 465, 196);
            Table.States (27).Kernel := To_Vector ((0 => ((273, 0),  64,  10, (32767, 0),  0)));
            Table.States (27).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
         end Subr_2;
         procedure Subr_3
         is begin
            Table.States (28).Action_List.Set_Capacity (1);
            Add_Action (Table.States (28), 108, (264, 0), 266);
            Table.States (28).Kernel := To_Vector ((0 => ((264, 0),  65,  1, (32767, 0),  0)));
            Table.States (28).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (264, 0),  108, 266)));
            Table.States (29).Action_List.Set_Capacity (2);
            Add_Action (Table.States (29), 27, (386, 0), 267);
            Add_Action (Table.States (29), 61, (386, 1), 268);
            Table.States (29).Kernel := To_Vector ((((386, 0),  77,  4, (32767, 0),  0), ((386, 1),  77,  3, (32767,
            0),  0)));
            Table.States (29).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (386, 1),  61, 268)));
            Table.States (30).Action_List.Set_Capacity (1);
            Add_Action (Table.States (30), 116, (130, 0), 269);
            Table.States (30).Kernel := To_Vector ((((130, 0),  81,  6, (32767, 0),  0), ((130, 1),  81,  4, (32767,
            0),  0)));
            Table.States (30).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (130, 0),  116, 269)));
            Table.States (31).Action_List.Set_Capacity (1);
            Add_Action (Table.States (31), 116, (128, 0), 270);
            Table.States (31).Kernel := To_Vector ((((128, 0),  83,  11, (32767, 0),  0), ((128, 1),  83,  9, (32767,
            0),  0), ((128, 2),  83,  6, (32767, 0),  0), ((128, 3),  83,  4, (32767, 0),  0), ((189, 0),  83,  7,
            (32767, 0),  0), ((189, 1),  83,  5, (32767, 0),  0), ((189, 2),  83,  4, (32767, 0),  0), ((189, 3),  83,
            2, (32767, 0),  0), ((327, 0),  83,  12, (32767, 0),  0), ((327, 1),  83,  10, (32767, 0),  0), ((327, 2),
            83,  11, (32767, 0),  0), ((327, 3),  83,  9, (32767, 0),  0), ((327, 4),  83,  11, (32767, 0),  0), ((327,
            5),  83,  9, (32767, 0),  0), ((327, 6),  83,  10, (32767, 0),  0), ((327, 7),  83,  8, (32767, 0),  0),
            ((327, 8),  83,  10, (32767, 0),  0), ((327, 9),  83,  8, (32767, 0),  0), ((327, 10),  83,  9, (32767, 0),
             0), ((327, 11),  83,  7, (32767, 0),  0), ((327, 12),  83,  9, (32767, 0),  0), ((327, 13),  83,  7,
            (32767, 0),  0), ((327, 14),  83,  8, (32767, 0),  0), ((327, 15),  83,  6, (32767, 0),  0), ((327, 16),
            83,  8, (32767, 0),  0), ((327, 17),  83,  6, (32767, 0),  0), ((327, 18),  83,  7, (32767, 0),  0), ((327,
            19),  83,  5, (32767, 0),  0), ((327, 20),  83,  7, (32767, 0),  0), ((327, 21),  83,  5, (32767, 0),  0),
            ((327, 22),  83,  6, (32767, 0),  0), ((327, 23),  83,  4, (32767, 0),  0), ((328, 0),  83,  16, (32767,
            0),  0), ((328, 1),  83,  14, (32767, 0),  0), ((328, 2),  83,  14, (32767, 0),  0), ((328, 3),  83,  12,
            (32767, 0),  0), ((328, 4),  83,  16, (32767, 0),  0), ((328, 5),  83,  14, (32767, 0),  0), ((328, 6),
            83,  14, (32767, 0),  0), ((328, 7),  83,  12, (32767, 0),  0), ((328, 8),  83,  15, (32767, 0),  0),
            ((328, 9),  83,  13, (32767, 0),  0), ((328, 10),  83,  13, (32767, 0),  0), ((328, 11),  83,  11, (32767,
            0),  0), ((328, 12),  83,  15, (32767, 0),  0), ((328, 13),  83,  13, (32767, 0),  0), ((328, 14),  83,
            13, (32767, 0),  0), ((328, 15),  83,  11, (32767, 0),  0), ((328, 16),  83,  15, (32767, 0),  0), ((328,
            17),  83,  13, (32767, 0),  0), ((328, 18),  83,  13, (32767, 0),  0), ((328, 19),  83,  11, (32767, 0),
            0), ((328, 20),  83,  14, (32767, 0),  0), ((328, 21),  83,  12, (32767, 0),  0), ((328, 22),  83,  12,
            (32767, 0),  0), ((328, 23),  83,  10, (32767, 0),  0), ((328, 24),  83,  13, (32767, 0),  0), ((328, 25),
            83,  11, (32767, 0),  0), ((328, 26),  83,  11, (32767, 0),  0), ((328, 27),  83,  9, (32767, 0),  0),
            ((328, 28),  83,  13, (32767, 0),  0), ((328, 29),  83,  11, (32767, 0),  0), ((328, 30),  83,  11, (32767,
            0),  0), ((328, 31),  83,  9, (32767, 0),  0), ((328, 32),  83,  12, (32767, 0),  0), ((328, 33),  83,  10,
            (32767, 0),  0), ((328, 34),  83,  10, (32767, 0),  0), ((328, 35),  83,  8, (32767, 0),  0), ((328, 36),
            83,  12, (32767, 0),  0), ((328, 37),  83,  10, (32767, 0),  0), ((328, 38),  83,  10, (32767, 0),  0),
            ((328, 39),  83,  8, (32767, 0),  0), ((328, 40),  83,  12, (32767, 0),  0), ((328, 41),  83,  10, (32767,
            0),  0), ((328, 42),  83,  10, (32767, 0),  0), ((328, 43),  83,  8, (32767, 0),  0), ((328, 44),  83,  11,
            (32767, 0),  0), ((328, 45),  83,  9, (32767, 0),  0), ((328, 46),  83,  9, (32767, 0),  0), ((328, 47),
            83,  7, (32767, 0),  0)));
            Table.States (31).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (128, 0),  116, 270)));
            Table.States (32).Action_List.Set_Capacity (1);
            Add_Action (Table.States (32), 116, (124, 0), 271);
            Table.States (32).Kernel := To_Vector ((((124, 0),  84,  5, (32767, 0),  0), ((124, 1),  84,  2, (32767,
            0),  0), ((124, 2),  84,  8, (32767, 0),  0), ((124, 3),  84,  2, (32767, 0),  0)));
            Table.States (32).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (124, 0),  116, 271)));
            Table.States (33).Action_List.Set_Capacity (2);
            Add_Action (Table.States (33), 37, (252, 0), 272);
            Add_Action (Table.States (33), 51, (221, 0), 273);
            Table.States (33).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (33), 221, 274);
            Table.States (33).Kernel := To_Vector ((((252, 0),  86,  11, (32767, 0),  0), ((252, 1),  86,  8, (32767,
            0),  0), ((252, 2),  86,  7, (32767, 0),  0)));
            Table.States (33).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (221, 0),  51, 273)));
            Table.States (34).Action_List.Set_Capacity (47);
            Add_Action (Table.States (34), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71, 72,
            73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110,
            111, 112, 113, 114), (268, 0),  1);
            Table.States (34).Kernel := To_Vector ((0 => ((268, 0),  90,  0, (268, 0),  1)));
            Table.States (34).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (268, 0),  1)));
            Table.States (35).Action_List.Set_Capacity (2);
            Add_Action (Table.States (35), 116, (196, 0), 146);
            Add_Action (Table.States (35), 117, (196, 1), 37);
            Table.States (35).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (35), 196, 275);
            Add_Goto (Table.States (35), 266, 276);
            Table.States (35).Kernel := To_Vector ((0 => ((265, 0),  105,  2, (32767, 0),  0)));
            Table.States (35).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (36).Action_List.Set_Capacity (9);
            Add_Action (Table.States (36), 24, (335, 4), 277);
            Add_Action (Table.States (36), 85, Reduce, (196, 0),  1);
            Add_Action (Table.States (36), 93, (335, 0), 278);
            Add_Conflict (Table.States (36), 93, (136, 0),  1);
            Add_Conflict (Table.States (36), 93, (196, 0),  1);
            Add_Action (Table.States (36), 94, Reduce, (196, 0),  1);
            Add_Action (Table.States (36), 95, Reduce, (136, 0),  1);
            Add_Action (Table.States (36), 96, Reduce, (196, 0),  1);
            Add_Action (Table.States (36), 108, Reduce, (196, 0),  1);
            Add_Action (Table.States (36), 113, Reduce, (196, 0),  1);
            Add_Action (Table.States (36), 114, Reduce, (196, 0),  1);
            Table.States (36).Kernel := To_Vector ((((136, 0),  116,  0, (136, 0),  1), ((196, 0),  116,  0, (196, 0),
            1), ((335, 0),  116,  9, (32767, 0),  0), ((335, 1),  116,  7, (32767, 0),  0), ((335, 2),  116,  7,
            (32767, 0),  0), ((335, 3),  116,  5, (32767, 0),  0), ((335, 4),  116,  5, (32767, 0),  0), ((335, 5),
            116,  3, (32767, 0),  0), ((335, 6),  116,  8, (32767, 0),  0), ((335, 7),  116,  6, (32767, 0),  0),
            ((336, 0),  116,  7, (32767, 0),  0), ((336, 1),  116,  5, (32767, 0),  0)));
            Table.States (36).Minimal_Complete_Actions := To_Vector (((Reduce, (136, 0),  1), (Reduce, (196, 0),  1),
            (Shift, (335, 4),  24, 277)));
            Table.States (37).Action_List.Set_Capacity (49);
            Add_Action (Table.States (37), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71, 72,
            73, 74, 75, 82, 85, 87, 88, 89, 91, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 106, 107, 108,
            109, 110, 111, 112, 113, 114), (196, 1),  1);
            Table.States (37).Kernel := To_Vector ((0 => ((196, 1),  117,  0, (196, 1),  1)));
            Table.States (37).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (196, 1),  1)));
            Table.States (38).Action_List.Set_Capacity (47);
            Add_Action (Table.States (38), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71, 72,
            73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110,
            111, 112, 113, 114), (195, 6),  1);
            Table.States (38).Kernel := To_Vector ((0 => ((195, 6),  118,  0, (195, 6),  1)));
            Table.States (38).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (195, 6),  1)));
            Table.States (39).Action_List.Set_Capacity (50);
            Add_Action (Table.States (39), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (262, 10),  1);
            Table.States (39).Kernel := To_Vector ((0 => ((262, 10),  124,  0, (262, 10),  1)));
            Table.States (39).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (262, 10),  1)));
            Table.States (40).Action_List.Set_Capacity (43);
            Add_Action (Table.States (40), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (193,
            0),  1);
            Table.States (40).Kernel := To_Vector ((0 => ((193, 0),  126,  0, (193, 0),  1)));
            Table.States (40).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (193, 0),  1)));
            Table.States (41).Action_List.Set_Capacity (43);
            Add_Action (Table.States (41), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (126,
            0),  1);
            Table.States (41).Kernel := To_Vector ((0 => ((126, 0),  127,  0, (126, 0),  1)));
            Table.States (41).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (126, 0),  1)));
            Table.States (42).Action_List.Set_Capacity (43);
            Add_Action (Table.States (42), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (127,
            0),  1);
            Table.States (42).Kernel := To_Vector ((0 => ((127, 0),  128,  0, (127, 0),  1)));
            Table.States (42).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (127, 0),  1)));
            Table.States (43).Action_List.Set_Capacity (43);
            Add_Action (Table.States (43), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (126,
            1),  1);
            Table.States (43).Kernel := To_Vector ((0 => ((126, 1),  130,  0, (126, 1),  1)));
            Table.States (43).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (126, 1),  1)));
            Table.States (44).Action_List.Set_Capacity (43);
            Add_Action (Table.States (44), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (126,
            2),  1);
            Table.States (44).Kernel := To_Vector ((0 => ((126, 2),  135,  0, (126, 2),  1)));
            Table.States (44).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (126, 2),  1)));
            Table.States (45).Action_List.Set_Capacity (2);
            Add_Action (Table.States (45), 93, (135, 0), 279);
            Add_Action (Table.States (45), 95, (136, 1), 280);
            Table.States (45).Kernel := To_Vector ((((135, 0),  136,  9, (32767, 0),  0), ((135, 1),  136,  7, (32767,
            0),  0), ((135, 2),  136,  7, (32767, 0),  0), ((135, 3),  136,  5, (32767, 0),  0), ((135, 4),  136,  8,
            (32767, 0),  0), ((135, 5),  136,  6, (32767, 0),  0), ((135, 6),  136,  6, (32767, 0),  0), ((135, 7),
            136,  4, (32767, 0),  0), ((135, 8),  136,  8, (32767, 0),  0), ((135, 9),  136,  6, (32767, 0),  0),
            ((135, 10),  136,  6, (32767, 0),  0), ((135, 11),  136,  4, (32767, 0),  0), ((135, 12),  136,  7, (32767,
            0),  0), ((135, 13),  136,  5, (32767, 0),  0), ((135, 14),  136,  5, (32767, 0),  0), ((135, 15),  136,
            3, (32767, 0),  0), ((135, 16),  136,  10, (32767, 0),  0), ((135, 17),  136,  8, (32767, 0),  0), ((135,
            18),  136,  8, (32767, 0),  0), ((135, 19),  136,  6, (32767, 0),  0), ((135, 20),  136,  9, (32767, 0),
            0), ((135, 21),  136,  7, (32767, 0),  0), ((135, 22),  136,  7, (32767, 0),  0), ((135, 23),  136,  5,
            (32767, 0),  0), ((135, 24),  136,  9, (32767, 0),  0), ((135, 25),  136,  7, (32767, 0),  0), ((135, 26),
            136,  7, (32767, 0),  0), ((135, 27),  136,  5, (32767, 0),  0), ((135, 28),  136,  8, (32767, 0),  0),
            ((135, 29),  136,  6, (32767, 0),  0), ((135, 30),  136,  6, (32767, 0),  0), ((135, 31),  136,  4, (32767,
            0),  0), ((135, 32),  136,  15, (32767, 0),  0), ((135, 33),  136,  13, (32767, 0),  0), ((135, 34),  136,
            13, (32767, 0),  0), ((135, 35),  136,  11, (32767, 0),  0), ((135, 36),  136,  14, (32767, 0),  0), ((135,
            37),  136,  12, (32767, 0),  0), ((135, 38),  136,  12, (32767, 0),  0), ((135, 39),  136,  10, (32767, 0),
             0), ((135, 40),  136,  14, (32767, 0),  0), ((135, 41),  136,  12, (32767, 0),  0), ((135, 42),  136,  12,
            (32767, 0),  0), ((135, 43),  136,  10, (32767, 0),  0), ((135, 44),  136,  13, (32767, 0),  0), ((135,
            45),  136,  11, (32767, 0),  0), ((135, 46),  136,  11, (32767, 0),  0), ((135, 47),  136,  9, (32767, 0),
            0), ((136, 1),  136,  2, (32767, 0),  0), ((137, 0),  136,  5, (32767, 0),  0), ((394, 0),  136,  5,
            (32767, 0),  0), ((394, 1),  136,  3, (32767, 0),  0)));
            Table.States (45).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 0),  93, 279)));
            Table.States (46).Action_List.Set_Capacity (43);
            Add_Action (Table.States (46), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (126,
            3),  1);
            Table.States (46).Kernel := To_Vector ((0 => ((126, 3),  137,  0, (126, 3),  1)));
            Table.States (46).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (126, 3),  1)));
            Table.States (47).Action_List.Set_Capacity (43);
            Add_Action (Table.States (47), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (126,
            5),  1);
            Table.States (47).Kernel := To_Vector ((0 => ((126, 5),  180,  0, (126, 5),  1)));
            Table.States (47).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (126, 5),  1)));
            Table.States (48).Action_List.Set_Capacity (43);
            Add_Action (Table.States (48), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (127,
            1),  1);
            Table.States (48).Kernel := To_Vector ((0 => ((127, 1),  189,  0, (127, 1),  1)));
            Table.States (48).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (127, 1),  1)));
            Table.States (49).Action_List.Set_Capacity (42);
            Add_Action (Table.States (49), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (384, 2),
             1);
            Table.States (49).Kernel := To_Vector ((0 => ((384, 2),  190,  0, (384, 2),  1)));
            Table.States (49).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (384, 2),  1)));
            Table.States (50).Action_List.Set_Capacity (43);
            Add_Action (Table.States (50), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (190,
            0),  1);
            Table.States (50).Kernel := To_Vector ((0 => ((190, 0),  193,  0, (190, 0),  1)));
            Table.States (50).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (190, 0),  1)));
            Table.States (51).Action_List.Set_Capacity (43);
            Add_Action (Table.States (51), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (190,
            1),  1);
            Table.States (51).Kernel := To_Vector ((0 => ((190, 1),  194,  0, (190, 1),  1)));
            Table.States (51).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (190, 1),  1)));
            Table.States (52).Action_List.Set_Capacity (6);
            Add_Action (Table.States (52), 85, (198, 0), 281);
            Add_Action (Table.States (52), 94, (134, 0), 282);
            Add_Action (Table.States (52), 96, (197, 0), 283);
            Add_Action (Table.States (52), 108, (310, 0), 284);
            Add_Action (Table.States (52), 113, (121, 0), 285);
            Add_Action (Table.States (52), 114, (121, 1), 286);
            Table.States (52).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (52), 121, 287);
            Add_Goto (Table.States (52), 134, 288);
            Add_Goto (Table.States (52), 313, 289);
            Table.States (52).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((267, 0),  195,  3, (32767, 0),  0), ((310, 0),  195,  1, (32767, 0),  0), ((311, 0),
            195,  3, (32767, 0),  0)));
            Table.States (52).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (310, 0),  108, 284)));
            Table.States (53).Action_List.Set_Capacity (7);
            Add_Action (Table.States (53), 85, Reduce, (195, 0),  1);
            Add_Action (Table.States (53), 93, Reduce, (266, 0),  1);
            Add_Action (Table.States (53), 94, Reduce, (195, 0),  1);
            Add_Action (Table.States (53), 96, Reduce, (195, 0),  1);
            Add_Action (Table.States (53), 108, Reduce, (195, 0),  1);
            Add_Action (Table.States (53), 113, Reduce, (195, 0),  1);
            Add_Action (Table.States (53), 114, Reduce, (195, 0),  1);
            Table.States (53).Kernel := To_Vector ((((195, 0),  196,  0, (195, 0),  1), ((266, 0),  196,  0, (266, 0),
            1)));
            Table.States (53).Minimal_Complete_Actions := To_Vector (((Reduce, (195, 0),  1), (Reduce, (266, 0),  1)));
            Table.States (54).Action_List.Set_Capacity (47);
            Add_Action (Table.States (54), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71, 72,
            73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110,
            111, 112, 113, 114), (195, 1),  1);
            Table.States (54).Kernel := To_Vector ((0 => ((195, 1),  197,  0, (195, 1),  1)));
            Table.States (54).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (195, 1),  1)));
            Table.States (55).Action_List.Set_Capacity (47);
            Add_Action (Table.States (55), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71, 72,
            73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110,
            111, 112, 113, 114), (195, 2),  1);
            Table.States (55).Kernel := To_Vector ((0 => ((195, 2),  198,  0, (195, 2),  1)));
            Table.States (55).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (195, 2),  1)));
            Table.States (56).Action_List.Set_Capacity (47);
            Add_Action (Table.States (56), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71, 72,
            73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110,
            111, 112, 113, 114), (195, 3),  1);
            Table.States (56).Kernel := To_Vector ((0 => ((195, 3),  199,  0, (195, 3),  1)));
            Table.States (56).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (195, 3),  1)));
            Table.States (57).Action_List.Set_Capacity (47);
            Add_Action (Table.States (57), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71, 72,
            73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110,
            111, 112, 113, 114), (195, 4),  1);
            Table.States (57).Kernel := To_Vector ((0 => ((195, 4),  201,  0, (195, 4),  1)));
            Table.States (57).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (195, 4),  1)));
            Table.States (58).Action_List.Set_Capacity (47);
            Add_Action (Table.States (58), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71, 72,
            73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110,
            111, 112, 113, 114), (201, 1),  1);
            Table.States (58).Kernel := To_Vector ((0 => ((201, 1),  251,  0, (201, 1),  1)));
            Table.States (58).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (201, 1),  1)));
            Table.States (59).Action_List.Set_Capacity (2);
            Add_Action (Table.States (59), 113, (121, 0), 285);
            Add_Action (Table.States (59), 114, (121, 1), 286);
            Table.States (59).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (59), 121, 290);
            Table.States (59).Kernel := To_Vector ((0 => ((251, 0),  252,  7, (32767, 0),  0)));
            Table.States (59).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (121, 0),  113, 285)));
            Table.States (60).Action_List.Set_Capacity (47);
            Add_Action (Table.States (60), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71, 72,
            73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110,
            111, 112, 113, 114), (195, 7),  1);
            Table.States (60).Kernel := To_Vector ((0 => ((195, 7),  255,  0, (195, 7),  1)));
            Table.States (60).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (195, 7),  1)));
            Table.States (61).Action_List.Set_Capacity (42);
            Add_Action (Table.States (61), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (384, 3),
             1);
            Table.States (61).Kernel := To_Vector ((0 => ((384, 3),  261,  0, (384, 3),  1)));
            Table.States (61).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (384, 3),  1)));
            Table.States (62).Action_List.Set_Capacity (50);
            Add_Action (Table.States (62), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (261, 1),  1);
            Table.States (62).Kernel := To_Vector ((0 => ((261, 1),  262,  0, (261, 1),  1)));
            Table.States (62).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (261, 1),  1)));
            Table.States (63).Action_List.Set_Capacity (50);
            Add_Action (Table.States (63), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (261, 3),  1);
            Table.States (63).Kernel := To_Vector ((0 => ((261, 3),  263,  0, (261, 3),  1)));
            Table.States (63).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (261, 3),  1)));
            Table.States (64).Action_List.Set_Capacity (50);
            Add_Action (Table.States (64), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (262, 0),  1);
            Table.States (64).Kernel := To_Vector ((0 => ((262, 0),  264,  0, (262, 0),  1)));
            Table.States (64).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (262, 0),  1)));
            Table.States (65).Action_List.Set_Capacity (50);
            Add_Action (Table.States (65), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (462, 0),  1);
            Table.States (65).Kernel := To_Vector ((0 => ((462, 0),  265,  0, (462, 0),  1)));
            Table.States (65).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (462, 0),  1)));
            Table.States (66).Action_List.Set_Capacity (1);
            Add_Action (Table.States (66), 93, (285, 0), 291);
            Table.States (66).Kernel := To_Vector ((0 => ((285, 0),  266,  1, (32767, 0),  0)));
            Table.States (66).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (285, 0),  93, 291)));
            Table.States (67).Action_List.Set_Capacity (50);
            Add_Action (Table.States (67), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (262, 1),  1);
            Table.States (67).Kernel := To_Vector ((0 => ((262, 1),  267,  0, (262, 1),  1)));
            Table.States (67).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (262, 1),  1)));
            Table.States (68).Action_List.Set_Capacity (47);
            Add_Action (Table.States (68), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71, 72,
            73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110,
            111, 112, 113, 114), (195, 8),  1);
            Table.States (68).Kernel := To_Vector ((0 => ((195, 8),  268,  0, (195, 8),  1)));
            Table.States (68).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (195, 8),  1)));
            Table.States (69).Action_List.Set_Capacity (50);
            Add_Action (Table.States (69), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (263, 0),  1);
            Table.States (69).Kernel := To_Vector ((0 => ((263, 0),  271,  0, (263, 0),  1)));
            Table.States (69).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (263, 0),  1)));
            Table.States (70).Action_List.Set_Capacity (50);
            Add_Action (Table.States (70), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (263, 1),  1);
            Table.States (70).Kernel := To_Vector ((0 => ((263, 1),  273,  0, (263, 1),  1)));
            Table.States (70).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (263, 1),  1)));
            Table.States (71).Action_List.Set_Capacity (50);
            Add_Action (Table.States (71), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (263, 2),  1);
            Table.States (71).Kernel := To_Vector ((0 => ((263, 2),  275,  0, (263, 2),  1)));
            Table.States (71).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (263, 2),  1)));
            Table.States (72).Action_List.Set_Capacity (6);
            Add_Action (Table.States (72), 35, (276, 0), 16);
            Add_Action (Table.States (72), 36, (275, 1), 292);
            Add_Action (Table.States (72), 37, (276, 3), 293);
            Add_Action (Table.States (72), 38, (286, 1), 294);
            Add_Action (Table.States (72), 39, (286, 0), 295);
            Add_Action (Table.States (72), 51, (276, 1), 296);
            Table.States (72).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (72), 276, 297);
            Table.States (72).Kernel := To_Vector ((((275, 0),  285,  8, (32767, 0),  0), ((275, 1),  285,  6, (32767,
            0),  0), ((286, 0),  285,  6, (32767, 0),  0), ((286, 1),  285,  5, (32767, 0),  0)));
            Table.States (72).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (286, 1),  38, 294)));
            Table.States (73).Action_List.Set_Capacity (50);
            Add_Action (Table.States (73), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (263, 3),  1);
            Table.States (73).Kernel := To_Vector ((0 => ((263, 3),  286,  0, (263, 3),  1)));
            Table.States (73).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (263, 3),  1)));
            Table.States (74).Action_List.Set_Capacity (50);
            Add_Action (Table.States (74), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (263, 5),  1);
            Table.States (74).Kernel := To_Vector ((0 => ((263, 5),  288,  0, (263, 5),  1)));
            Table.States (74).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (263, 5),  1)));
            Table.States (75).Action_List.Set_Capacity (50);
            Add_Action (Table.States (75), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (262, 2),  1);
            Table.States (75).Kernel := To_Vector ((0 => ((262, 2),  289,  0, (262, 2),  1)));
            Table.States (75).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (262, 2),  1)));
            Table.States (76).Action_List.Set_Capacity (50);
            Add_Action (Table.States (76), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (262, 3),  1);
            Table.States (76).Kernel := To_Vector ((0 => ((262, 3),  290,  0, (262, 3),  1)));
            Table.States (76).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (262, 3),  1)));
            Table.States (77).Action_List.Set_Capacity (43);
            Add_Action (Table.States (77), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (126,
            4),  1);
            Table.States (77).Kernel := To_Vector ((0 => ((126, 4),  291,  0, (126, 4),  1)));
            Table.States (77).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (126, 4),  1)));
            Table.States (78).Action_List.Set_Capacity (4);
            Add_Action (Table.States (78), 24, (338, 2), 298);
            Add_Action (Table.States (78), 61, (434, 0), 299);
            Add_Action (Table.States (78), 82, (180, 2), 300);
            Add_Action (Table.States (78), 108, (291, 3), 301);
            Table.States (78).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (78), 434, 302);
            Table.States (78).Kernel := To_Vector ((((180, 2),  292,  5, (32767, 0),  0), ((180, 3),  292,  3, (32767,
            0),  0), ((291, 2),  292,  3, (32767, 0),  0), ((291, 3),  292,  1, (32767, 0),  0), ((309, 2),  292,  8,
            (32767, 0),  0), ((309, 3),  292,  6, (32767, 0),  0), ((338, 2),  292,  5, (32767, 0),  0), ((338, 3),
            292,  3, (32767, 0),  0), ((389, 2),  292,  5, (32767, 0),  0), ((389, 3),  292,  3, (32767, 0),  0)));
            Table.States (78).Minimal_Complete_Actions := To_Vector (((Shift, (180, 2),  82, 300), (Shift, (338, 2),
            24, 298)));
            Table.States (79).Action_List.Set_Capacity (4);
            Add_Action (Table.States (79), 24, Reduce, (292, 0),  1);
            Add_Action (Table.States (79), 61, Reduce, (292, 0),  1);
            Add_Action (Table.States (79), 82, (320, 2), 303);
            Add_Conflict (Table.States (79), 82, (292, 0),  1);
            Add_Action (Table.States (79), 108, Reduce, (292, 0),  1);
            Table.States (79).Kernel := To_Vector ((((292, 0),  293,  0, (292, 0),  1), ((320, 2),  293,  5, (32767,
            0),  0), ((320, 3),  293,  3, (32767, 0),  0)));
            Table.States (79).Minimal_Complete_Actions := To_Vector (((Reduce, (292, 0),  1), (Shift, (320, 2),  82,
            303)));
            Table.States (80).Action_List.Set_Capacity (4);
            Add_Action (Table.States (80), 24, Reduce, (292, 1),  1);
            Add_Action (Table.States (80), 61, Reduce, (292, 1),  1);
            Add_Action (Table.States (80), 82, (321, 2), 304);
            Add_Conflict (Table.States (80), 82, (292, 1),  1);
            Add_Action (Table.States (80), 108, Reduce, (292, 1),  1);
            Table.States (80).Kernel := To_Vector ((((292, 1),  294,  0, (292, 1),  1), ((321, 2),  294,  6, (32767,
            0),  0), ((321, 3),  294,  4, (32767, 0),  0)));
            Table.States (80).Minimal_Complete_Actions := To_Vector (((Reduce, (292, 1),  1), (Shift, (321, 2),  82,
            304)));
         end Subr_3;
         procedure Subr_4
         is begin
            Table.States (81).Action_List.Set_Capacity (43);
            Add_Action (Table.States (81), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (194,
            0),  1);
            Table.States (81).Kernel := To_Vector ((0 => ((194, 0),  309,  0, (194, 0),  1)));
            Table.States (81).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (194, 0),  1)));
            Table.States (82).Action_List.Set_Capacity (50);
            Add_Action (Table.States (82), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (262, 4),  1);
            Table.States (82).Kernel := To_Vector ((0 => ((262, 4),  310,  0, (262, 4),  1)));
            Table.States (82).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (262, 4),  1)));
            Table.States (83).Action_List.Set_Capacity (47);
            Add_Action (Table.States (83), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71, 72,
            73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110,
            111, 112, 113, 114), (195, 5),  1);
            Table.States (83).Kernel := To_Vector ((0 => ((195, 5),  311,  0, (195, 5),  1)));
            Table.States (83).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (195, 5),  1)));
            Table.States (84).Action_List.Set_Capacity (50);
            Add_Action (Table.States (84), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (262, 5),  1);
            Table.States (84).Kernel := To_Vector ((0 => ((262, 5),  316,  0, (262, 5),  1)));
            Table.States (84).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (262, 5),  1)));
            Table.States (85).Action_List.Set_Capacity (50);
            Add_Action (Table.States (85), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (263, 4),  1);
            Table.States (85).Kernel := To_Vector ((0 => ((263, 4),  318,  0, (263, 4),  1)));
            Table.States (85).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (263, 4),  1)));
            Table.States (86).Action_List.Set_Capacity (43);
            Add_Action (Table.States (86), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (126,
            6),  1);
            Table.States (86).Kernel := To_Vector ((0 => ((126, 6),  320,  0, (126, 6),  1)));
            Table.States (86).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (126, 6),  1)));
            Table.States (87).Action_List.Set_Capacity (43);
            Add_Action (Table.States (87), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (126,
            7),  1);
            Table.States (87).Kernel := To_Vector ((0 => ((126, 7),  321,  0, (126, 7),  1)));
            Table.States (87).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (126, 7),  1)));
            Table.States (88).Action_List.Set_Capacity (43);
            Add_Action (Table.States (88), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (126,
            8),  1);
            Table.States (88).Kernel := To_Vector ((0 => ((126, 8),  322,  0, (126, 8),  1)));
            Table.States (88).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (126, 8),  1)));
            Table.States (89).Action_List.Set_Capacity (1);
            Add_Action (Table.States (89), 108, (322, 0), 305);
            Table.States (89).Kernel := To_Vector ((0 => ((322, 0),  325,  1, (32767, 0),  0)));
            Table.States (89).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (322, 0),  108, 305)));
            Table.States (90).Action_List.Set_Capacity (43);
            Add_Action (Table.States (90), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (194,
            1),  1);
            Table.States (90).Kernel := To_Vector ((0 => ((194, 1),  326,  0, (194, 1),  1)));
            Table.States (90).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (194, 1),  1)));
            Table.States (91).Action_List.Set_Capacity (43);
            Add_Action (Table.States (91), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (127,
            2),  1);
            Table.States (91).Kernel := To_Vector ((0 => ((127, 2),  327,  0, (127, 2),  1)));
            Table.States (91).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (127, 2),  1)));
            Table.States (92).Action_List.Set_Capacity (43);
            Add_Action (Table.States (92), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (127,
            3),  1);
            Table.States (92).Kernel := To_Vector ((0 => ((127, 3),  328,  0, (127, 3),  1)));
            Table.States (92).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (127, 3),  1)));
            Table.States (93).Action_List.Set_Capacity (3);
            Add_Action (Table.States (93), 21, (356, 0), 306);
            Add_Action (Table.States (93), 53, (294, 0), 307);
            Add_Action (Table.States (93), 54, (293, 0), 308);
            Table.States (93).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (93), 292, 309);
            Add_Goto (Table.States (93), 293, 310);
            Add_Goto (Table.States (93), 294, 311);
            Table.States (93).Kernel := To_Vector ((((180, 0),  329,  7, (32767, 0),  0), ((180, 1),  329,  5, (32767,
            0),  0), ((291, 0),  329,  5, (32767, 0),  0), ((291, 1),  329,  3, (32767, 0),  0), ((309, 0),  329,  10,
            (32767, 0),  0), ((309, 1),  329,  8, (32767, 0),  0), ((320, 0),  329,  7, (32767, 0),  0), ((320, 1),
            329,  5, (32767, 0),  0), ((321, 0),  329,  10, (32767, 0),  0), ((321, 1),  329,  8, (32767, 0),  0),
            ((338, 0),  329,  7, (32767, 0),  0), ((338, 1),  329,  5, (32767, 0),  0), ((356, 0),  329,  8, (32767,
            0),  0), ((356, 1),  329,  6, (32767, 0),  0), ((356, 2),  329,  5, (32767, 0),  0), ((356, 3),  329,  3,
            (32767, 0),  0), ((389, 0),  329,  7, (32767, 0),  0), ((389, 1),  329,  5, (32767, 0),  0), ((408, 2),
            329,  8, (32767, 0),  0), ((408, 3),  329,  6, (32767, 0),  0), ((408, 6),  329,  8, (32767, 0),  0),
            ((408, 7),  329,  6, (32767, 0),  0)));
            Table.States (93).Minimal_Complete_Actions := To_Vector (((Shift, (293, 0),  54, 308), (Shift, (356, 0),
            21, 306)));
            Table.States (94).Action_List.Set_Capacity (43);
            Add_Action (Table.States (94), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (193,
            2),  1);
            Table.States (94).Kernel := To_Vector ((0 => ((193, 2),  330,  0, (193, 2),  1)));
            Table.States (94).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (193, 2),  1)));
            Table.States (95).Action_List.Set_Capacity (43);
            Add_Action (Table.States (95), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (330,
            0),  1);
            Table.States (95).Kernel := To_Vector ((0 => ((330, 0),  332,  0, (330, 0),  1)));
            Table.States (95).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (330, 0),  1)));
            Table.States (96).Action_List.Set_Capacity (43);
            Add_Action (Table.States (96), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (330,
            1),  1);
            Table.States (96).Kernel := To_Vector ((0 => ((330, 1),  333,  0, (330, 1),  1)));
            Table.States (96).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (330, 1),  1)));
            Table.States (97).Action_List.Set_Capacity (43);
            Add_Action (Table.States (97), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (126,
            9),  1);
            Table.States (97).Kernel := To_Vector ((0 => ((126, 9),  334,  0, (126, 9),  1)));
            Table.States (97).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (126, 9),  1)));
            Table.States (98).Action_List.Set_Capacity (43);
            Add_Action (Table.States (98), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (334,
            0),  1);
            Table.States (98).Kernel := To_Vector ((0 => ((334, 0),  335,  0, (334, 0),  1)));
            Table.States (98).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (334, 0),  1)));
            Table.States (99).Action_List.Set_Capacity (43);
            Add_Action (Table.States (99), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37, 38,
            39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (334,
            1),  1);
            Table.States (99).Kernel := To_Vector ((0 => ((334, 1),  336,  0, (334, 1),  1)));
            Table.States (99).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (334, 1),  1)));
            Table.States (100).Action_List.Set_Capacity (43);
            Add_Action (Table.States (100), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (334, 2),  1);
            Table.States (100).Kernel := To_Vector ((0 => ((334, 2),  337,  0, (334, 2),  1)));
            Table.States (100).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (334, 2),  1)));
            Table.States (101).Action_List.Set_Capacity (43);
            Add_Action (Table.States (101), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (334, 3),  1);
            Table.States (101).Kernel := To_Vector ((0 => ((334, 3),  338,  0, (334, 3),  1)));
            Table.States (101).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (334, 3),  1)));
            Table.States (102).Action_List.Set_Capacity (43);
            Add_Action (Table.States (102), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (334, 4),  1);
            Table.States (102).Kernel := To_Vector ((0 => ((334, 4),  339,  0, (334, 4),  1)));
            Table.States (102).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (334, 4),  1)));
            Table.States (103).Action_List.Set_Capacity (43);
            Add_Action (Table.States (103), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (128, 4),  1);
            Table.States (103).Kernel := To_Vector ((0 => ((128, 4),  340,  0, (128, 4),  1)));
            Table.States (103).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (128, 4),  1)));
            Table.States (104).Action_List.Set_Capacity (43);
            Add_Action (Table.States (104), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (135, 48),  1);
            Table.States (104).Kernel := To_Vector ((0 => ((135, 48),  341,  0, (135, 48),  1)));
            Table.States (104).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (135, 48),  1)));
            Table.States (105).Action_List.Set_Capacity (43);
            Add_Action (Table.States (105), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (194, 2),  1);
            Table.States (105).Kernel := To_Vector ((0 => ((194, 2),  345,  0, (194, 2),  1)));
            Table.States (105).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (194, 2),  1)));
            Table.States (106).Action_List.Set_Capacity (43);
            Add_Action (Table.States (106), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (128, 5),  1);
            Table.States (106).Kernel := To_Vector ((0 => ((128, 5),  346,  0, (128, 5),  1)));
            Table.States (106).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (128, 5),  1)));
            Table.States (107).Action_List.Set_Capacity (43);
            Add_Action (Table.States (107), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (135, 49),  1);
            Table.States (107).Kernel := To_Vector ((0 => ((135, 49),  347,  0, (135, 49),  1)));
            Table.States (107).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (135, 49),  1)));
            Table.States (108).Action_List.Set_Capacity (43);
            Add_Action (Table.States (108), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (194, 3),  1);
            Table.States (108).Kernel := To_Vector ((0 => ((194, 3),  354,  0, (194, 3),  1)));
            Table.States (108).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (194, 3),  1)));
            Table.States (109).Action_List.Set_Capacity (42);
            Add_Action (Table.States (109), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (384,
            5),  1);
            Table.States (109).Kernel := To_Vector ((0 => ((384, 5),  356,  0, (384, 5),  1)));
            Table.States (109).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (384, 5),  1)));
            Table.States (110).Action_List.Set_Capacity (50);
            Add_Action (Table.States (110), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (263, 6),  1);
            Table.States (110).Kernel := To_Vector ((0 => ((263, 6),  357,  0, (263, 6),  1)));
            Table.States (110).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (263, 6),  1)));
            Table.States (111).Action_List.Set_Capacity (50);
            Add_Action (Table.States (111), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (262, 6),  1);
            Table.States (111).Kernel := To_Vector ((0 => ((262, 6),  363,  0, (262, 6),  1)));
            Table.States (111).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (262, 6),  1)));
            Table.States (112).Action_List.Set_Capacity (50);
            Add_Action (Table.States (112), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (262, 7),  1);
            Table.States (112).Kernel := To_Vector ((0 => ((262, 7),  364,  0, (262, 7),  1)));
            Table.States (112).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (262, 7),  1)));
            Table.States (113).Action_List.Set_Capacity (50);
            Add_Action (Table.States (113), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (364, 0),  1);
            Table.States (113).Kernel := To_Vector ((0 => ((364, 0),  365,  0, (364, 0),  1)));
            Table.States (113).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (364, 0),  1)));
            Table.States (114).Action_List.Set_Capacity (50);
            Add_Action (Table.States (114), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (364, 1),  1);
            Table.States (114).Kernel := To_Vector ((0 => ((364, 1),  366,  0, (364, 1),  1)));
            Table.States (114).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (364, 1),  1)));
            Table.States (115).Action_List.Set_Capacity (50);
            Add_Action (Table.States (115), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (263, 7),  1);
            Table.States (115).Kernel := To_Vector ((0 => ((263, 7),  367,  0, (263, 7),  1)));
            Table.States (115).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (263, 7),  1)));
            Table.States (116).Action_List.Set_Capacity (50);
            Add_Action (Table.States (116), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (367, 0),  1);
            Table.States (116).Kernel := To_Vector ((0 => ((367, 0),  370,  0, (367, 0),  1)));
            Table.States (116).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (367, 0),  1)));
            Table.States (117).Action_List.Set_Capacity (50);
            Add_Action (Table.States (117), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (367, 1),  1);
            Table.States (117).Kernel := To_Vector ((0 => ((367, 1),  376,  0, (367, 1),  1)));
            Table.States (117).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (367, 1),  1)));
            Table.States (118).Action_List.Set_Capacity (50);
            Add_Action (Table.States (118), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (367, 2),  1);
            Table.States (118).Kernel := To_Vector ((0 => ((367, 2),  378,  0, (367, 2),  1)));
            Table.States (118).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (367, 2),  1)));
            Table.States (119).Action_List.Set_Capacity (50);
            Add_Action (Table.States (119), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (367, 3),  1);
            Table.States (119).Kernel := To_Vector ((0 => ((367, 3),  379,  0, (367, 3),  1)));
            Table.States (119).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (367, 3),  1)));
            Table.States (120).Action_List.Set_Capacity (50);
            Add_Action (Table.States (120), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (262, 8),  1);
            Table.States (120).Kernel := To_Vector ((0 => ((262, 8),  382,  0, (262, 8),  1)));
            Table.States (120).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (262, 8),  1)));
            Table.States (121).Action_List.Set_Capacity (42);
            Add_Action (Table.States (121), 12, (401, 0), 1);
            Add_Action (Table.States (121), 13, (393, 0), 2);
            Add_Action (Table.States (121), 15, (370, 0), 3);
            Add_Action (Table.States (121), 17, (365, 0), 4);
            Add_Action (Table.States (121), 18, (382, 0), 5);
            Add_Action (Table.States (121), 19, (363, 0), 6);
            Add_Action (Table.States (121), 20, (357, 0), 7);
            Add_Action (Table.States (121), 21, (356, 4), 8);
            Add_Action (Table.States (121), 22, (339, 0), 9);
            Add_Action (Table.States (121), 25, (329, 1), 10);
            Add_Action (Table.States (121), 27, (384, 1), 11);
            Add_Action (Table.States (121), 28, (325, 0), 12);
            Add_Action (Table.States (121), 30, (316, 0), 13);
            Add_Action (Table.States (121), 31, (290, 0), 14);
            Add_Action (Table.States (121), 32, (289, 0), 15);
            Add_Action (Table.States (121), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (121), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (121), 37, (288, 0), 17);
            Add_Conflict (Table.States (121), 37, (285, 1),  0);
            Add_Action (Table.States (121), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (121), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (121), 41, (271, 0), 18);
            Add_Action (Table.States (121), 50, (332, 0), 19);
            Add_Action (Table.States (121), 51, (437, 0), 20);
            Add_Conflict (Table.States (121), 51, (285, 1),  0);
            Add_Action (Table.States (121), 52, (329, 0), 21);
            Add_Action (Table.States (121), 53, (294, 0), 22);
            Add_Action (Table.States (121), 54, (293, 0), 23);
            Add_Action (Table.States (121), 59, (346, 0), 24);
            Add_Action (Table.States (121), 60, (340, 0), 25);
            Add_Action (Table.States (121), 61, (387, 1), 26);
            Add_Action (Table.States (121), 64, (273, 0), 27);
            Add_Action (Table.States (121), 65, (264, 0), 28);
            Add_Action (Table.States (121), 77, (386, 0), 29);
            Add_Action (Table.States (121), 81, (130, 0), 30);
            Add_Action (Table.States (121), 83, (128, 0), 31);
            Add_Action (Table.States (121), 84, (124, 0), 32);
            Add_Action (Table.States (121), 86, (252, 0), 33);
            Add_Action (Table.States (121), 90, (268, 0), 34);
            Add_Action (Table.States (121), 105, (265, 0), 35);
            Add_Action (Table.States (121), 116, (136, 0), 36);
            Add_Action (Table.States (121), 117, (196, 1), 37);
            Add_Action (Table.States (121), 118, (195, 6), 38);
            Add_Action (Table.States (121), 119, Accept_It, (120, 0),  1);
            Table.States (121).Goto_List.Set_Capacity (105);
            Add_Goto (Table.States (121), 124, 39);
            Add_Goto (Table.States (121), 126, 40);
            Add_Goto (Table.States (121), 127, 41);
            Add_Goto (Table.States (121), 128, 42);
            Add_Goto (Table.States (121), 130, 43);
            Add_Goto (Table.States (121), 135, 44);
            Add_Goto (Table.States (121), 136, 45);
            Add_Goto (Table.States (121), 137, 46);
            Add_Goto (Table.States (121), 180, 47);
            Add_Goto (Table.States (121), 189, 48);
            Add_Goto (Table.States (121), 190, 49);
            Add_Goto (Table.States (121), 193, 50);
            Add_Goto (Table.States (121), 194, 51);
            Add_Goto (Table.States (121), 195, 52);
            Add_Goto (Table.States (121), 196, 53);
            Add_Goto (Table.States (121), 197, 54);
            Add_Goto (Table.States (121), 198, 55);
            Add_Goto (Table.States (121), 199, 56);
            Add_Goto (Table.States (121), 201, 57);
            Add_Goto (Table.States (121), 251, 58);
            Add_Goto (Table.States (121), 252, 59);
            Add_Goto (Table.States (121), 255, 60);
            Add_Goto (Table.States (121), 261, 61);
            Add_Goto (Table.States (121), 262, 62);
            Add_Goto (Table.States (121), 263, 63);
            Add_Goto (Table.States (121), 264, 64);
            Add_Goto (Table.States (121), 265, 65);
            Add_Goto (Table.States (121), 266, 66);
            Add_Goto (Table.States (121), 267, 67);
            Add_Goto (Table.States (121), 268, 68);
            Add_Goto (Table.States (121), 271, 69);
            Add_Goto (Table.States (121), 273, 70);
            Add_Goto (Table.States (121), 275, 71);
            Add_Goto (Table.States (121), 285, 72);
            Add_Goto (Table.States (121), 286, 73);
            Add_Goto (Table.States (121), 288, 74);
            Add_Goto (Table.States (121), 289, 75);
            Add_Goto (Table.States (121), 290, 76);
            Add_Goto (Table.States (121), 291, 77);
            Add_Goto (Table.States (121), 292, 78);
            Add_Goto (Table.States (121), 293, 79);
            Add_Goto (Table.States (121), 294, 80);
            Add_Goto (Table.States (121), 309, 81);
            Add_Goto (Table.States (121), 310, 82);
            Add_Goto (Table.States (121), 311, 83);
            Add_Goto (Table.States (121), 316, 84);
            Add_Goto (Table.States (121), 318, 85);
            Add_Goto (Table.States (121), 320, 86);
            Add_Goto (Table.States (121), 321, 87);
            Add_Goto (Table.States (121), 322, 88);
            Add_Goto (Table.States (121), 325, 89);
            Add_Goto (Table.States (121), 326, 90);
            Add_Goto (Table.States (121), 327, 91);
            Add_Goto (Table.States (121), 328, 92);
            Add_Goto (Table.States (121), 329, 93);
            Add_Goto (Table.States (121), 330, 94);
            Add_Goto (Table.States (121), 332, 95);
            Add_Goto (Table.States (121), 333, 96);
            Add_Goto (Table.States (121), 334, 97);
            Add_Goto (Table.States (121), 335, 98);
            Add_Goto (Table.States (121), 336, 99);
            Add_Goto (Table.States (121), 337, 100);
            Add_Goto (Table.States (121), 338, 101);
            Add_Goto (Table.States (121), 339, 102);
            Add_Goto (Table.States (121), 340, 103);
            Add_Goto (Table.States (121), 341, 104);
            Add_Goto (Table.States (121), 345, 105);
            Add_Goto (Table.States (121), 346, 106);
            Add_Goto (Table.States (121), 347, 107);
            Add_Goto (Table.States (121), 354, 108);
            Add_Goto (Table.States (121), 356, 109);
            Add_Goto (Table.States (121), 357, 110);
            Add_Goto (Table.States (121), 363, 111);
            Add_Goto (Table.States (121), 364, 112);
            Add_Goto (Table.States (121), 365, 113);
            Add_Goto (Table.States (121), 366, 114);
            Add_Goto (Table.States (121), 367, 115);
            Add_Goto (Table.States (121), 370, 116);
            Add_Goto (Table.States (121), 376, 117);
            Add_Goto (Table.States (121), 378, 118);
            Add_Goto (Table.States (121), 379, 119);
            Add_Goto (Table.States (121), 382, 120);
            Add_Goto (Table.States (121), 384, 312);
            Add_Goto (Table.States (121), 385, 123);
            Add_Goto (Table.States (121), 386, 124);
            Add_Goto (Table.States (121), 387, 125);
            Add_Goto (Table.States (121), 388, 126);
            Add_Goto (Table.States (121), 389, 127);
            Add_Goto (Table.States (121), 390, 128);
            Add_Goto (Table.States (121), 391, 129);
            Add_Goto (Table.States (121), 392, 130);
            Add_Goto (Table.States (121), 393, 131);
            Add_Goto (Table.States (121), 394, 132);
            Add_Goto (Table.States (121), 401, 133);
            Add_Goto (Table.States (121), 403, 134);
            Add_Goto (Table.States (121), 404, 135);
            Add_Goto (Table.States (121), 405, 136);
            Add_Goto (Table.States (121), 406, 137);
            Add_Goto (Table.States (121), 408, 138);
            Add_Goto (Table.States (121), 431, 139);
            Add_Goto (Table.States (121), 437, 140);
            Add_Goto (Table.States (121), 438, 141);
            Add_Goto (Table.States (121), 440, 142);
            Add_Goto (Table.States (121), 454, 143);
            Add_Goto (Table.States (121), 462, 144);
            Table.States (122).Action_List.Set_Capacity (42);
            Add_Action (Table.States (122), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (383,
            0),  1);
            Table.States (122).Kernel := To_Vector ((0 => ((383, 0),  384,  0, (383, 0),  1)));
            Table.States (122).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (383, 0),  1)));
            Table.States (123).Action_List.Set_Capacity (42);
            Add_Action (Table.States (123), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (384,
            0),  1);
            Table.States (123).Kernel := To_Vector ((0 => ((384, 0),  385,  0, (384, 0),  1)));
            Table.States (123).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (384, 0),  1)));
         end Subr_4;
         procedure Subr_5
         is begin
            Table.States (124).Action_List.Set_Capacity (42);
            Add_Action (Table.States (124), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (385,
            0),  1);
            Table.States (124).Kernel := To_Vector ((0 => ((385, 0),  386,  0, (385, 0),  1)));
            Table.States (124).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (385, 0),  1)));
            Table.States (125).Action_List.Set_Capacity (42);
            Add_Action (Table.States (125), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (385,
            1),  1);
            Table.States (125).Kernel := To_Vector ((0 => ((385, 1),  387,  0, (385, 1),  1)));
            Table.States (125).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (385, 1),  1)));
            Table.States (126).Action_List.Set_Capacity (43);
            Add_Action (Table.States (126), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (190, 2),  1);
            Table.States (126).Kernel := To_Vector ((0 => ((190, 2),  388,  0, (190, 2),  1)));
            Table.States (126).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (190, 2),  1)));
            Table.States (127).Action_List.Set_Capacity (43);
            Add_Action (Table.States (127), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (388, 0),  1);
            Table.States (127).Kernel := To_Vector ((0 => ((388, 0),  389,  0, (388, 0),  1)));
            Table.States (127).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (388, 0),  1)));
            Table.States (128).Action_List.Set_Capacity (43);
            Add_Action (Table.States (128), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (388, 1),  1);
            Table.States (128).Kernel := To_Vector ((0 => ((388, 1),  390,  0, (388, 1),  1)));
            Table.States (128).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (388, 1),  1)));
            Table.States (129).Action_List.Set_Capacity (43);
            Add_Action (Table.States (129), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (388, 2),  1);
            Table.States (129).Kernel := To_Vector ((0 => ((388, 2),  391,  0, (388, 2),  1)));
            Table.States (129).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (388, 2),  1)));
            Table.States (130).Action_List.Set_Capacity (43);
            Add_Action (Table.States (130), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (388, 3),  1);
            Table.States (130).Kernel := To_Vector ((0 => ((388, 3),  392,  0, (388, 3),  1)));
            Table.States (130).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (388, 3),  1)));
            Table.States (131).Action_List.Set_Capacity (42);
            Add_Action (Table.States (131), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (384,
            4),  1);
            Table.States (131).Kernel := To_Vector ((0 => ((384, 4),  393,  0, (384, 4),  1)));
            Table.States (131).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (384, 4),  1)));
            Table.States (132).Action_List.Set_Capacity (43);
            Add_Action (Table.States (132), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (126, 10),  1);
            Table.States (132).Kernel := To_Vector ((0 => ((126, 10),  394,  0, (126, 10),  1)));
            Table.States (132).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (126, 10),  1)));
            Table.States (133).Action_List.Set_Capacity (50);
            Add_Action (Table.States (133), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (262, 9),  1);
            Table.States (133).Kernel := To_Vector ((0 => ((262, 9),  401,  0, (262, 9),  1)));
            Table.States (133).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (262, 9),  1)));
            Table.States (134).Action_List.Set_Capacity (43);
            Add_Action (Table.States (134), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (126, 11),  1);
            Table.States (134).Kernel := To_Vector ((0 => ((126, 11),  403,  0, (126, 11),  1)));
            Table.States (134).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (126, 11),  1)));
            Table.States (135).Action_List.Set_Capacity (43);
            Add_Action (Table.States (135), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (403, 0),  1);
            Table.States (135).Kernel := To_Vector ((0 => ((403, 0),  404,  0, (403, 0),  1)));
            Table.States (135).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (403, 0),  1)));
            Table.States (136).Action_List.Set_Capacity (43);
            Add_Action (Table.States (136), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (403, 1),  1);
            Table.States (136).Kernel := To_Vector ((0 => ((403, 1),  405,  0, (403, 1),  1)));
            Table.States (136).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (403, 1),  1)));
            Table.States (137).Action_List.Set_Capacity (3);
            Add_Action (Table.States (137), 28, (325, 0), 313);
            Add_Action (Table.States (137), 53, (294, 0), 314);
            Add_Action (Table.States (137), 54, (293, 0), 315);
            Table.States (137).Goto_List.Set_Capacity (4);
            Add_Goto (Table.States (137), 292, 316);
            Add_Goto (Table.States (137), 293, 317);
            Add_Goto (Table.States (137), 294, 318);
            Add_Goto (Table.States (137), 325, 319);
            Table.States (137).Kernel := To_Vector ((((404, 0),  406,  5, (32767, 0),  0), ((404, 1),  406,  3, (32767,
            0),  0), ((405, 0),  406,  5, (32767, 0),  0)));
            Table.States (137).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (293, 0),  54, 315)));
            Table.States (138).Action_List.Set_Capacity (43);
            Add_Action (Table.States (138), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (126, 12),  1);
            Table.States (138).Kernel := To_Vector ((0 => ((126, 12),  408,  0, (126, 12),  1)));
            Table.States (138).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (126, 12),  1)));
            Table.States (139).Action_List.Set_Capacity (43);
            Add_Action (Table.States (139), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (193, 1),  1);
            Table.States (139).Kernel := To_Vector ((0 => ((193, 1),  431,  0, (193, 1),  1)));
            Table.States (139).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (193, 1),  1)));
            Table.States (140).Action_List.Set_Capacity (44);
            Add_Action (Table.States (140), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118,
            119), (431, 0),  1);
            Table.States (140).Kernel := To_Vector ((0 => ((431, 0),  437,  0, (431, 0),  1)));
            Table.States (140).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (431, 0),  1)));
            Table.States (141).Action_List.Set_Capacity (44);
            Add_Action (Table.States (141), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118,
            119), (431, 1),  1);
            Table.States (141).Kernel := To_Vector ((0 => ((431, 1),  438,  0, (431, 1),  1)));
            Table.States (141).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (431, 1),  1)));
            Table.States (142).Action_List.Set_Capacity (44);
            Add_Action (Table.States (142), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118,
            119), (431, 2),  1);
            Table.States (142).Kernel := To_Vector ((0 => ((431, 2),  440,  0, (431, 2),  1)));
            Table.States (142).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (431, 2),  1)));
            Table.States (143).Action_List.Set_Capacity (44);
            Add_Action (Table.States (143), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118,
            119), (431, 3),  1);
            Table.States (143).Kernel := To_Vector ((0 => ((431, 3),  454,  0, (431, 3),  1)));
            Table.States (143).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (431, 3),  1)));
            Table.States (144).Action_List.Set_Capacity (25);
            Add_Action (Table.States (144), 12, (401, 0), 1);
            Add_Action (Table.States (144), 15, (370, 0), 3);
            Add_Action (Table.States (144), 17, (365, 0), 4);
            Add_Action (Table.States (144), 18, (382, 0), 5);
            Add_Action (Table.States (144), 19, (363, 0), 6);
            Add_Action (Table.States (144), 20, (357, 0), 7);
            Add_Action (Table.States (144), 30, (316, 0), 13);
            Add_Action (Table.States (144), 31, (290, 0), 14);
            Add_Action (Table.States (144), 32, (289, 0), 15);
            Add_Action (Table.States (144), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (144), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (144), 37, (288, 0), 17);
            Add_Conflict (Table.States (144), 37, (285, 1),  0);
            Add_Action (Table.States (144), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (144), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (144), 41, (271, 0), 18);
            Add_Action (Table.States (144), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (144), 64, (273, 0), 27);
            Add_Action (Table.States (144), 65, (264, 0), 28);
            Add_Action (Table.States (144), 84, (124, 0), 32);
            Add_Action (Table.States (144), 86, (252, 0), 33);
            Add_Action (Table.States (144), 90, (268, 0), 34);
            Add_Action (Table.States (144), 105, (265, 0), 35);
            Add_Action (Table.States (144), 116, (196, 0), 146);
            Add_Action (Table.States (144), 117, (196, 1), 37);
            Add_Action (Table.States (144), 118, (195, 6), 38);
            Table.States (144).Goto_List.Set_Capacity (42);
            Add_Goto (Table.States (144), 124, 39);
            Add_Goto (Table.States (144), 195, 52);
            Add_Goto (Table.States (144), 196, 53);
            Add_Goto (Table.States (144), 197, 54);
            Add_Goto (Table.States (144), 198, 55);
            Add_Goto (Table.States (144), 199, 56);
            Add_Goto (Table.States (144), 201, 57);
            Add_Goto (Table.States (144), 251, 58);
            Add_Goto (Table.States (144), 252, 59);
            Add_Goto (Table.States (144), 255, 60);
            Add_Goto (Table.States (144), 262, 320);
            Add_Goto (Table.States (144), 263, 321);
            Add_Goto (Table.States (144), 264, 64);
            Add_Goto (Table.States (144), 265, 322);
            Add_Goto (Table.States (144), 266, 66);
            Add_Goto (Table.States (144), 267, 67);
            Add_Goto (Table.States (144), 268, 68);
            Add_Goto (Table.States (144), 271, 69);
            Add_Goto (Table.States (144), 273, 70);
            Add_Goto (Table.States (144), 275, 71);
            Add_Goto (Table.States (144), 285, 72);
            Add_Goto (Table.States (144), 286, 73);
            Add_Goto (Table.States (144), 288, 74);
            Add_Goto (Table.States (144), 289, 75);
            Add_Goto (Table.States (144), 290, 76);
            Add_Goto (Table.States (144), 310, 82);
            Add_Goto (Table.States (144), 311, 83);
            Add_Goto (Table.States (144), 316, 84);
            Add_Goto (Table.States (144), 318, 85);
            Add_Goto (Table.States (144), 357, 110);
            Add_Goto (Table.States (144), 363, 111);
            Add_Goto (Table.States (144), 364, 112);
            Add_Goto (Table.States (144), 365, 113);
            Add_Goto (Table.States (144), 366, 114);
            Add_Goto (Table.States (144), 367, 115);
            Add_Goto (Table.States (144), 370, 116);
            Add_Goto (Table.States (144), 376, 117);
            Add_Goto (Table.States (144), 378, 118);
            Add_Goto (Table.States (144), 379, 119);
            Add_Goto (Table.States (144), 382, 120);
            Add_Goto (Table.States (144), 401, 133);
            Add_Goto (Table.States (144), 462, 323);
            Table.States (144).Kernel := To_Vector ((((261, 0),  462,  2, (32767, 0),  0), ((261, 2),  462,  3, (32767,
            0),  0), ((462, 1),  462,  3, (32767, 0),  0), ((462, 2),  462,  3, (32767, 0),  0)));
            Table.States (144).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (264, 0),  65, 28)));
            Table.States (145).Action_List.Set_Capacity (50);
            Add_Action (Table.States (145), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (401, 0),  2);
            Table.States (145).Kernel := To_Vector ((0 => ((401, 0),  108,  0, (401, 0),  2)));
            Table.States (145).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (401, 0),  2)));
            Table.States (146).Action_List.Set_Capacity (49);
            Add_Action (Table.States (146), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 106, 107, 108,
            109, 110, 111, 112, 113, 114), (196, 0),  1);
            Table.States (146).Kernel := To_Vector ((0 => ((196, 0),  116,  0, (196, 0),  1)));
            Table.States (146).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (196, 0),  1)));
            Table.States (147).Action_List.Set_Capacity (6);
            Add_Action (Table.States (147), 61, (401, 1), 324);
            Add_Action (Table.States (147), 85, (198, 0), 281);
            Add_Action (Table.States (147), 96, (197, 0), 283);
            Add_Action (Table.States (147), 108, (401, 2), 325);
            Add_Action (Table.States (147), 113, (121, 0), 285);
            Add_Action (Table.States (147), 114, (121, 1), 286);
            Table.States (147).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (147), 121, 287);
            Add_Goto (Table.States (147), 313, 289);
            Table.States (147).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((401, 1),  195,  3, (32767, 0),  0), ((401, 2),
            195,  1, (32767, 0),  0)));
            Table.States (147).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (401, 2),  108, 325)));
            Table.States (148).Action_List.Set_Capacity (47);
            Add_Action (Table.States (148), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (195, 0),  1);
            Table.States (148).Kernel := To_Vector ((0 => ((195, 0),  196,  0, (195, 0),  1)));
            Table.States (148).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (195, 0),  1)));
            Table.States (149).Action_List.Set_Capacity (5);
            Add_Action (Table.States (149), 86, (252, 0), 33);
            Add_Action (Table.States (149), 90, (268, 0), 34);
            Add_Action (Table.States (149), 116, (196, 0), 146);
            Add_Action (Table.States (149), 117, (196, 1), 37);
            Add_Action (Table.States (149), 118, (195, 6), 38);
            Table.States (149).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (149), 195, 326);
            Add_Goto (Table.States (149), 196, 148);
            Add_Goto (Table.States (149), 197, 54);
            Add_Goto (Table.States (149), 198, 55);
            Add_Goto (Table.States (149), 199, 56);
            Add_Goto (Table.States (149), 201, 57);
            Add_Goto (Table.States (149), 251, 58);
            Add_Goto (Table.States (149), 252, 59);
            Add_Goto (Table.States (149), 255, 60);
            Add_Goto (Table.States (149), 268, 68);
            Add_Goto (Table.States (149), 311, 83);
            Table.States (149).Kernel := To_Vector ((0 => ((393, 0),  85,  8, (32767, 0),  0)));
            Table.States (149).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (150).Action_List.Set_Capacity (1);
            Add_Action (Table.States (150), 108, (375, 0), 327);
            Table.States (150).Kernel := To_Vector ((0 => ((375, 0),  14,  1, (32767, 0),  0)));
            Table.States (150).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (375, 0),  108, 327)));
            Table.States (151).Action_List.Set_Capacity (14);
            Add_Action (Table.States (151), 12, (402, 0), 165);
            Add_Action (Table.States (151), 44, (233, 2), 167);
            Add_Action (Table.States (151), 52, (233, 3), 168);
            Add_Action (Table.States (151), 65, (234, 1), 169);
            Add_Action (Table.States (151), 76, (256, 0), 170);
            Add_Action (Table.States (151), 85, (205, 4), 171);
            Add_Action (Table.States (151), 86, (213, 2), 172);
            Add_Action (Table.States (151), 90, (268, 0), 34);
            Add_Action (Table.States (151), 106, (237, 1), 173);
            Add_Action (Table.States (151), 107, (237, 0), 174);
            Add_Action (Table.States (151), 115, (234, 0), 175);
            Add_Action (Table.States (151), 116, (196, 0), 146);
            Add_Action (Table.States (151), 117, (196, 1), 37);
            Add_Action (Table.States (151), 118, (195, 6), 38);
            Table.States (151).Goto_List.Set_Capacity (32);
            Add_Goto (Table.States (151), 195, 176);
            Add_Goto (Table.States (151), 196, 148);
            Add_Goto (Table.States (151), 197, 54);
            Add_Goto (Table.States (151), 198, 55);
            Add_Goto (Table.States (151), 199, 56);
            Add_Goto (Table.States (151), 201, 57);
            Add_Goto (Table.States (151), 205, 177);
            Add_Goto (Table.States (151), 206, 178);
            Add_Goto (Table.States (151), 210, 179);
            Add_Goto (Table.States (151), 211, 180);
            Add_Goto (Table.States (151), 213, 181);
            Add_Goto (Table.States (151), 214, 182);
            Add_Goto (Table.States (151), 215, 183);
            Add_Goto (Table.States (151), 218, 184);
            Add_Goto (Table.States (151), 219, 185);
            Add_Goto (Table.States (151), 220, 186);
            Add_Goto (Table.States (151), 227, 236);
            Add_Goto (Table.States (151), 228, 188);
            Add_Goto (Table.States (151), 231, 189);
            Add_Goto (Table.States (151), 232, 190);
            Add_Goto (Table.States (151), 233, 191);
            Add_Goto (Table.States (151), 234, 192);
            Add_Goto (Table.States (151), 237, 193);
            Add_Goto (Table.States (151), 243, 328);
            Add_Goto (Table.States (151), 251, 58);
            Add_Goto (Table.States (151), 252, 59);
            Add_Goto (Table.States (151), 255, 60);
            Add_Goto (Table.States (151), 256, 194);
            Add_Goto (Table.States (151), 268, 68);
            Add_Goto (Table.States (151), 311, 83);
            Add_Goto (Table.States (151), 402, 195);
            Add_Goto (Table.States (151), 465, 196);
            Table.States (151).Kernel := To_Vector ((0 => ((371, 0),  63,  2, (32767, 0),  0)));
            Table.States (151).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (152).Action_List.Set_Capacity (5);
            Add_Action (Table.States (152), 85, (198, 0), 281);
            Add_Action (Table.States (152), 96, (197, 0), 283);
            Add_Action (Table.States (152), 108, (310, 0), 284);
            Add_Action (Table.States (152), 113, (121, 0), 285);
            Add_Action (Table.States (152), 114, (121, 1), 286);
            Table.States (152).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (152), 121, 287);
            Add_Goto (Table.States (152), 313, 289);
            Table.States (152).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((310, 0),  195,  1, (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0)));
            Table.States (152).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (310, 0),  108, 284)));
            Table.States (153).Action_List.Set_Capacity (28);
            Add_Action (Table.States (153), 12, (401, 0), 1);
            Add_Action (Table.States (153), 15, (370, 0), 3);
            Add_Action (Table.States (153), 17, (365, 0), 4);
            Add_Action (Table.States (153), 18, (382, 0), 5);
            Add_Action (Table.States (153), 19, (363, 0), 6);
            Add_Action (Table.States (153), 20, (357, 0), 7);
            Add_Action (Table.States (153), 30, (316, 0), 13);
            Add_Action (Table.States (153), 31, (290, 0), 14);
            Add_Action (Table.States (153), 32, (289, 0), 15);
            Add_Action (Table.States (153), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (153), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (153), 37, (288, 0), 17);
            Add_Conflict (Table.States (153), 37, (285, 1),  0);
            Add_Action (Table.States (153), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (153), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (153), 41, (271, 0), 18);
            Add_Action (Table.States (153), 47, Reduce, (260, 1),  0);
            Add_Action (Table.States (153), 48, Reduce, (260, 1),  0);
            Add_Action (Table.States (153), 49, Reduce, (260, 1),  0);
            Add_Action (Table.States (153), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (153), 64, (273, 0), 27);
            Add_Action (Table.States (153), 65, (264, 0), 28);
            Add_Action (Table.States (153), 84, (124, 0), 32);
            Add_Action (Table.States (153), 86, (252, 0), 33);
            Add_Action (Table.States (153), 90, (268, 0), 34);
            Add_Action (Table.States (153), 105, (265, 0), 35);
            Add_Action (Table.States (153), 116, (196, 0), 146);
            Add_Action (Table.States (153), 117, (196, 1), 37);
            Add_Action (Table.States (153), 118, (195, 6), 38);
            Table.States (153).Goto_List.Set_Capacity (46);
            Add_Goto (Table.States (153), 124, 39);
            Add_Goto (Table.States (153), 195, 52);
            Add_Goto (Table.States (153), 196, 53);
            Add_Goto (Table.States (153), 197, 54);
            Add_Goto (Table.States (153), 198, 55);
            Add_Goto (Table.States (153), 199, 56);
            Add_Goto (Table.States (153), 201, 57);
            Add_Goto (Table.States (153), 251, 58);
            Add_Goto (Table.States (153), 252, 59);
            Add_Goto (Table.States (153), 255, 60);
            Add_Goto (Table.States (153), 259, 329);
            Add_Goto (Table.States (153), 260, 330);
            Add_Goto (Table.States (153), 261, 331);
            Add_Goto (Table.States (153), 262, 62);
            Add_Goto (Table.States (153), 263, 63);
            Add_Goto (Table.States (153), 264, 64);
            Add_Goto (Table.States (153), 265, 65);
            Add_Goto (Table.States (153), 266, 66);
            Add_Goto (Table.States (153), 267, 67);
            Add_Goto (Table.States (153), 268, 68);
            Add_Goto (Table.States (153), 271, 69);
            Add_Goto (Table.States (153), 273, 70);
            Add_Goto (Table.States (153), 275, 71);
            Add_Goto (Table.States (153), 285, 72);
            Add_Goto (Table.States (153), 286, 73);
            Add_Goto (Table.States (153), 288, 74);
            Add_Goto (Table.States (153), 289, 75);
            Add_Goto (Table.States (153), 290, 76);
            Add_Goto (Table.States (153), 310, 82);
            Add_Goto (Table.States (153), 311, 83);
            Add_Goto (Table.States (153), 316, 84);
            Add_Goto (Table.States (153), 318, 85);
            Add_Goto (Table.States (153), 357, 110);
            Add_Goto (Table.States (153), 363, 111);
            Add_Goto (Table.States (153), 364, 112);
            Add_Goto (Table.States (153), 365, 113);
            Add_Goto (Table.States (153), 366, 114);
            Add_Goto (Table.States (153), 367, 115);
            Add_Goto (Table.States (153), 370, 116);
            Add_Goto (Table.States (153), 376, 117);
            Add_Goto (Table.States (153), 378, 118);
            Add_Goto (Table.States (153), 379, 119);
            Add_Goto (Table.States (153), 382, 120);
            Add_Goto (Table.States (153), 401, 133);
            Add_Goto (Table.States (153), 461, 332);
            Add_Goto (Table.States (153), 462, 144);
            Table.States (153).Kernel := To_Vector ((((377, 0),  310,  0, (260, 1),  0), ((380, 0),  310,  0, (260, 1),
             0)));
            Table.States (153).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (260, 1),  0)));
         end Subr_5;
         procedure Subr_6
         is begin
            Table.States (154).Action_List.Set_Capacity (28);
            Add_Action (Table.States (154), 12, (401, 0), 1);
            Add_Action (Table.States (154), 15, (370, 0), 3);
            Add_Action (Table.States (154), 17, (365, 0), 4);
            Add_Action (Table.States (154), 18, (382, 0), 5);
            Add_Action (Table.States (154), 19, (363, 0), 6);
            Add_Action (Table.States (154), 20, (357, 0), 7);
            Add_Action (Table.States (154), 30, (316, 0), 13);
            Add_Action (Table.States (154), 31, (290, 0), 14);
            Add_Action (Table.States (154), 32, (289, 0), 15);
            Add_Action (Table.States (154), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (154), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (154), 37, (288, 0), 17);
            Add_Conflict (Table.States (154), 37, (285, 1),  0);
            Add_Action (Table.States (154), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (154), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (154), 41, (271, 0), 18);
            Add_Action (Table.States (154), 47, Reduce, (260, 1),  0);
            Add_Action (Table.States (154), 48, Reduce, (260, 1),  0);
            Add_Action (Table.States (154), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (154), 64, (273, 0), 27);
            Add_Action (Table.States (154), 65, (264, 0), 28);
            Add_Action (Table.States (154), 66, Reduce, (260, 1),  0);
            Add_Action (Table.States (154), 84, (124, 0), 32);
            Add_Action (Table.States (154), 86, (252, 0), 33);
            Add_Action (Table.States (154), 90, (268, 0), 34);
            Add_Action (Table.States (154), 105, (265, 0), 35);
            Add_Action (Table.States (154), 116, (196, 0), 146);
            Add_Action (Table.States (154), 117, (196, 1), 37);
            Add_Action (Table.States (154), 118, (195, 6), 38);
            Table.States (154).Goto_List.Set_Capacity (46);
            Add_Goto (Table.States (154), 124, 39);
            Add_Goto (Table.States (154), 195, 52);
            Add_Goto (Table.States (154), 196, 53);
            Add_Goto (Table.States (154), 197, 54);
            Add_Goto (Table.States (154), 198, 55);
            Add_Goto (Table.States (154), 199, 56);
            Add_Goto (Table.States (154), 201, 57);
            Add_Goto (Table.States (154), 251, 58);
            Add_Goto (Table.States (154), 252, 59);
            Add_Goto (Table.States (154), 255, 60);
            Add_Goto (Table.States (154), 259, 329);
            Add_Goto (Table.States (154), 260, 333);
            Add_Goto (Table.States (154), 261, 331);
            Add_Goto (Table.States (154), 262, 62);
            Add_Goto (Table.States (154), 263, 63);
            Add_Goto (Table.States (154), 264, 64);
            Add_Goto (Table.States (154), 265, 65);
            Add_Goto (Table.States (154), 266, 66);
            Add_Goto (Table.States (154), 267, 67);
            Add_Goto (Table.States (154), 268, 68);
            Add_Goto (Table.States (154), 271, 69);
            Add_Goto (Table.States (154), 273, 70);
            Add_Goto (Table.States (154), 275, 71);
            Add_Goto (Table.States (154), 285, 72);
            Add_Goto (Table.States (154), 286, 73);
            Add_Goto (Table.States (154), 288, 74);
            Add_Goto (Table.States (154), 289, 75);
            Add_Goto (Table.States (154), 290, 76);
            Add_Goto (Table.States (154), 310, 82);
            Add_Goto (Table.States (154), 311, 83);
            Add_Goto (Table.States (154), 316, 84);
            Add_Goto (Table.States (154), 318, 85);
            Add_Goto (Table.States (154), 357, 110);
            Add_Goto (Table.States (154), 363, 111);
            Add_Goto (Table.States (154), 364, 112);
            Add_Goto (Table.States (154), 365, 113);
            Add_Goto (Table.States (154), 366, 114);
            Add_Goto (Table.States (154), 367, 115);
            Add_Goto (Table.States (154), 370, 116);
            Add_Goto (Table.States (154), 376, 117);
            Add_Goto (Table.States (154), 378, 118);
            Add_Goto (Table.States (154), 379, 119);
            Add_Goto (Table.States (154), 382, 120);
            Add_Goto (Table.States (154), 401, 133);
            Add_Goto (Table.States (154), 461, 332);
            Add_Goto (Table.States (154), 462, 144);
            Table.States (154).Kernel := To_Vector ((0 => ((373, 0),  357,  0, (260, 1),  0)));
            Table.States (154).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (260, 1),  0)));
            Table.States (155).Action_List.Set_Capacity (29);
            Add_Action (Table.States (155), 12, (401, 0), 1);
            Add_Action (Table.States (155), 15, (370, 0), 3);
            Add_Action (Table.States (155), 17, (365, 0), 4);
            Add_Action (Table.States (155), 18, (382, 0), 5);
            Add_Action (Table.States (155), 19, (363, 0), 6);
            Add_Action (Table.States (155), 20, (357, 0), 7);
            Add_Action (Table.States (155), 30, (316, 0), 13);
            Add_Action (Table.States (155), 31, (290, 0), 14);
            Add_Action (Table.States (155), 32, (289, 0), 15);
            Add_Action (Table.States (155), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (155), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (155), 37, (288, 0), 17);
            Add_Conflict (Table.States (155), 37, (285, 1),  0);
            Add_Action (Table.States (155), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (155), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (155), 41, (271, 0), 18);
            Add_Action (Table.States (155), 47, Reduce, (260, 1),  0);
            Add_Action (Table.States (155), 48, Reduce, (260, 1),  0);
            Add_Action (Table.States (155), 49, Reduce, (260, 1),  0);
            Add_Action (Table.States (155), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (155), 64, (273, 0), 27);
            Add_Action (Table.States (155), 65, (264, 0), 28);
            Add_Action (Table.States (155), 66, Reduce, (260, 1),  0);
            Add_Action (Table.States (155), 84, (124, 0), 32);
            Add_Action (Table.States (155), 86, (252, 0), 33);
            Add_Action (Table.States (155), 90, (268, 0), 34);
            Add_Action (Table.States (155), 105, (265, 0), 35);
            Add_Action (Table.States (155), 116, (196, 0), 146);
            Add_Action (Table.States (155), 117, (196, 1), 37);
            Add_Action (Table.States (155), 118, (195, 6), 38);
            Table.States (155).Goto_List.Set_Capacity (46);
            Add_Goto (Table.States (155), 124, 39);
            Add_Goto (Table.States (155), 195, 52);
            Add_Goto (Table.States (155), 196, 53);
            Add_Goto (Table.States (155), 197, 54);
            Add_Goto (Table.States (155), 198, 55);
            Add_Goto (Table.States (155), 199, 56);
            Add_Goto (Table.States (155), 201, 57);
            Add_Goto (Table.States (155), 251, 58);
            Add_Goto (Table.States (155), 252, 59);
            Add_Goto (Table.States (155), 255, 60);
            Add_Goto (Table.States (155), 259, 329);
            Add_Goto (Table.States (155), 260, 334);
            Add_Goto (Table.States (155), 261, 331);
            Add_Goto (Table.States (155), 262, 62);
            Add_Goto (Table.States (155), 263, 63);
            Add_Goto (Table.States (155), 264, 64);
            Add_Goto (Table.States (155), 265, 65);
            Add_Goto (Table.States (155), 266, 66);
            Add_Goto (Table.States (155), 267, 67);
            Add_Goto (Table.States (155), 268, 68);
            Add_Goto (Table.States (155), 271, 69);
            Add_Goto (Table.States (155), 273, 70);
            Add_Goto (Table.States (155), 275, 71);
            Add_Goto (Table.States (155), 285, 72);
            Add_Goto (Table.States (155), 286, 73);
            Add_Goto (Table.States (155), 288, 74);
            Add_Goto (Table.States (155), 289, 75);
            Add_Goto (Table.States (155), 290, 76);
            Add_Goto (Table.States (155), 310, 82);
            Add_Goto (Table.States (155), 311, 83);
            Add_Goto (Table.States (155), 316, 84);
            Add_Goto (Table.States (155), 318, 85);
            Add_Goto (Table.States (155), 357, 110);
            Add_Goto (Table.States (155), 363, 111);
            Add_Goto (Table.States (155), 364, 112);
            Add_Goto (Table.States (155), 365, 113);
            Add_Goto (Table.States (155), 366, 114);
            Add_Goto (Table.States (155), 367, 115);
            Add_Goto (Table.States (155), 370, 116);
            Add_Goto (Table.States (155), 376, 117);
            Add_Goto (Table.States (155), 378, 118);
            Add_Goto (Table.States (155), 379, 119);
            Add_Goto (Table.States (155), 382, 120);
            Add_Goto (Table.States (155), 401, 133);
            Add_Goto (Table.States (155), 461, 332);
            Add_Goto (Table.States (155), 462, 144);
            Table.States (155).Kernel := To_Vector ((((374, 0),  364,  0, (260, 1),  0), ((380, 1),  364,  0, (260, 1),
             0)));
            Table.States (155).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (260, 1),  0)));
            Table.States (156).Action_List.Set_Capacity (3);
            Add_Action (Table.States (156), (47, 48, 66), (369, 0),  1);
            Table.States (156).Kernel := To_Vector ((0 => ((369, 0),  368,  0, (369, 0),  1)));
            Table.States (156).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (369, 0),  1)));
            Table.States (157).Action_List.Set_Capacity (3);
            Add_Action (Table.States (157), 47, (370, 0), 335);
            Add_Action (Table.States (157), 48, (369, 1), 336);
            Add_Action (Table.States (157), 66, (370, 1), 337);
            Table.States (157).Kernel := To_Vector ((((369, 1),  369,  3, (32767, 0),  0), ((370, 0),  369,  6, (32767,
            0),  0), ((370, 1),  369,  3, (32767, 0),  0)));
            Table.States (157).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (370, 1),  66, 337)));
            Table.States (158).Action_List.Set_Capacity (3);
            Add_Action (Table.States (158), 14, (375, 0), 150);
            Add_Action (Table.States (158), 17, (365, 0), 4);
            Add_Action (Table.States (158), 20, (357, 0), 7);
            Table.States (158).Goto_List.Set_Capacity (8);
            Add_Goto (Table.States (158), 357, 154);
            Add_Goto (Table.States (158), 364, 338);
            Add_Goto (Table.States (158), 365, 113);
            Add_Goto (Table.States (158), 366, 114);
            Add_Goto (Table.States (158), 372, 339);
            Add_Goto (Table.States (158), 373, 160);
            Add_Goto (Table.States (158), 374, 161);
            Add_Goto (Table.States (158), 375, 162);
            Table.States (158).Kernel := To_Vector ((0 => ((368, 0),  371,  2, (32767, 0),  0)));
            Table.States (158).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (375, 0),  14, 150)));
            Table.States (159).Action_List.Set_Capacity (3);
            Add_Action (Table.States (159), (47, 48, 66), (368, 1),  1);
            Table.States (159).Kernel := To_Vector ((0 => ((368, 1),  372,  0, (368, 1),  1)));
            Table.States (159).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (368, 1),  1)));
            Table.States (160).Action_List.Set_Capacity (3);
            Add_Action (Table.States (160), (47, 48, 66), (372, 0),  1);
            Table.States (160).Kernel := To_Vector ((0 => ((372, 0),  373,  0, (372, 0),  1)));
            Table.States (160).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (372, 0),  1)));
            Table.States (161).Action_List.Set_Capacity (3);
            Add_Action (Table.States (161), (47, 48, 66), (372, 1),  1);
            Table.States (161).Kernel := To_Vector ((0 => ((372, 1),  374,  0, (372, 1),  1)));
            Table.States (161).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (372, 1),  1)));
            Table.States (162).Action_List.Set_Capacity (3);
            Add_Action (Table.States (162), (47, 48, 66), (372, 2),  1);
            Table.States (162).Kernel := To_Vector ((0 => ((372, 2),  375,  0, (372, 2),  1)));
            Table.States (162).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (372, 2),  1)));
            Table.States (163).Action_List.Set_Capacity (2);
            Add_Action (Table.States (163), 47, (378, 0), 340);
            Add_Action (Table.States (163), 48, (376, 0), 341);
            Table.States (163).Kernel := To_Vector ((((376, 0),  377,  7, (32767, 0),  0), ((378, 0),  377,  6, (32767,
            0),  0)));
            Table.States (163).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (378, 0),  47, 340)));
            Table.States (164).Action_List.Set_Capacity (1);
            Add_Action (Table.States (164), 49, (379, 0), 342);
            Table.States (164).Kernel := To_Vector ((0 => ((379, 0),  380,  7, (32767, 0),  0)));
            Table.States (164).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (379, 0),  49, 342)));
            Table.States (165).Action_List.Set_Capacity (5);
            Add_Action (Table.States (165), 86, (252, 0), 33);
            Add_Action (Table.States (165), 90, (268, 0), 34);
            Add_Action (Table.States (165), 116, (196, 0), 146);
            Add_Action (Table.States (165), 117, (196, 1), 37);
            Add_Action (Table.States (165), 118, (195, 6), 38);
            Table.States (165).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (165), 195, 343);
            Add_Goto (Table.States (165), 196, 148);
            Add_Goto (Table.States (165), 197, 54);
            Add_Goto (Table.States (165), 198, 55);
            Add_Goto (Table.States (165), 199, 56);
            Add_Goto (Table.States (165), 201, 57);
            Add_Goto (Table.States (165), 251, 58);
            Add_Goto (Table.States (165), 252, 59);
            Add_Goto (Table.States (165), 255, 60);
            Add_Goto (Table.States (165), 268, 68);
            Add_Goto (Table.States (165), 311, 83);
            Table.States (165).Kernel := To_Vector ((((402, 0),  12,  3, (32767, 0),  0), ((402, 1),  12,  1, (32767,
            0),  0)));
            Table.States (165).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (166).Action_List.Set_Capacity (14);
            Add_Action (Table.States (166), 12, (402, 0), 165);
            Add_Action (Table.States (166), 44, (233, 2), 167);
            Add_Action (Table.States (166), 52, (233, 3), 168);
            Add_Action (Table.States (166), 65, (234, 1), 169);
            Add_Action (Table.States (166), 76, (256, 0), 170);
            Add_Action (Table.States (166), 85, (205, 4), 171);
            Add_Action (Table.States (166), 86, (213, 2), 172);
            Add_Action (Table.States (166), 90, (268, 0), 34);
            Add_Action (Table.States (166), 106, (237, 1), 173);
            Add_Action (Table.States (166), 107, (237, 0), 174);
            Add_Action (Table.States (166), 115, (234, 0), 175);
            Add_Action (Table.States (166), 116, (196, 0), 146);
            Add_Action (Table.States (166), 117, (196, 1), 37);
            Add_Action (Table.States (166), 118, (195, 6), 38);
            Table.States (166).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (166), 195, 176);
            Add_Goto (Table.States (166), 196, 148);
            Add_Goto (Table.States (166), 197, 54);
            Add_Goto (Table.States (166), 198, 55);
            Add_Goto (Table.States (166), 199, 56);
            Add_Goto (Table.States (166), 201, 57);
            Add_Goto (Table.States (166), 205, 177);
            Add_Goto (Table.States (166), 206, 178);
            Add_Goto (Table.States (166), 210, 179);
            Add_Goto (Table.States (166), 211, 180);
            Add_Goto (Table.States (166), 213, 181);
            Add_Goto (Table.States (166), 214, 182);
            Add_Goto (Table.States (166), 215, 183);
            Add_Goto (Table.States (166), 218, 184);
            Add_Goto (Table.States (166), 219, 185);
            Add_Goto (Table.States (166), 220, 186);
            Add_Goto (Table.States (166), 227, 344);
            Add_Goto (Table.States (166), 228, 188);
            Add_Goto (Table.States (166), 231, 189);
            Add_Goto (Table.States (166), 232, 190);
            Add_Goto (Table.States (166), 233, 191);
            Add_Goto (Table.States (166), 234, 192);
            Add_Goto (Table.States (166), 237, 193);
            Add_Goto (Table.States (166), 251, 58);
            Add_Goto (Table.States (166), 252, 59);
            Add_Goto (Table.States (166), 255, 60);
            Add_Goto (Table.States (166), 256, 194);
            Add_Goto (Table.States (166), 268, 68);
            Add_Goto (Table.States (166), 311, 83);
            Add_Goto (Table.States (166), 402, 195);
            Add_Goto (Table.States (166), 465, 196);
            Table.States (166).Kernel := To_Vector ((0 => ((365, 0),  16,  2, (32767, 0),  0)));
            Table.States (166).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (167).Action_List.Set_Capacity (9);
            Add_Action (Table.States (167), 65, (234, 1), 169);
            Add_Action (Table.States (167), 76, (256, 0), 170);
            Add_Action (Table.States (167), 85, (205, 4), 171);
            Add_Action (Table.States (167), 86, (213, 2), 172);
            Add_Action (Table.States (167), 90, (268, 0), 34);
            Add_Action (Table.States (167), 115, (234, 0), 175);
            Add_Action (Table.States (167), 116, (196, 0), 146);
            Add_Action (Table.States (167), 117, (196, 1), 37);
            Add_Action (Table.States (167), 118, (195, 6), 38);
            Table.States (167).Goto_List.Set_Capacity (23);
            Add_Goto (Table.States (167), 195, 176);
            Add_Goto (Table.States (167), 196, 148);
            Add_Goto (Table.States (167), 197, 54);
            Add_Goto (Table.States (167), 198, 55);
            Add_Goto (Table.States (167), 199, 56);
            Add_Goto (Table.States (167), 201, 57);
            Add_Goto (Table.States (167), 205, 177);
            Add_Goto (Table.States (167), 206, 178);
            Add_Goto (Table.States (167), 210, 179);
            Add_Goto (Table.States (167), 211, 180);
            Add_Goto (Table.States (167), 213, 181);
            Add_Goto (Table.States (167), 214, 182);
            Add_Goto (Table.States (167), 215, 183);
            Add_Goto (Table.States (167), 218, 184);
            Add_Goto (Table.States (167), 219, 185);
            Add_Goto (Table.States (167), 220, 186);
            Add_Goto (Table.States (167), 234, 345);
            Add_Goto (Table.States (167), 251, 58);
            Add_Goto (Table.States (167), 252, 59);
            Add_Goto (Table.States (167), 255, 60);
            Add_Goto (Table.States (167), 256, 194);
            Add_Goto (Table.States (167), 268, 68);
            Add_Goto (Table.States (167), 311, 83);
            Table.States (167).Kernel := To_Vector ((0 => ((233, 2),  44,  1, (32767, 0),  0)));
            Table.States (167).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (168).Action_List.Set_Capacity (9);
            Add_Action (Table.States (168), 65, (234, 1), 169);
            Add_Action (Table.States (168), 76, (256, 0), 170);
            Add_Action (Table.States (168), 85, (205, 4), 171);
            Add_Action (Table.States (168), 86, (213, 2), 172);
            Add_Action (Table.States (168), 90, (268, 0), 34);
            Add_Action (Table.States (168), 115, (234, 0), 175);
            Add_Action (Table.States (168), 116, (196, 0), 146);
            Add_Action (Table.States (168), 117, (196, 1), 37);
            Add_Action (Table.States (168), 118, (195, 6), 38);
            Table.States (168).Goto_List.Set_Capacity (23);
            Add_Goto (Table.States (168), 195, 176);
            Add_Goto (Table.States (168), 196, 148);
            Add_Goto (Table.States (168), 197, 54);
            Add_Goto (Table.States (168), 198, 55);
            Add_Goto (Table.States (168), 199, 56);
            Add_Goto (Table.States (168), 201, 57);
            Add_Goto (Table.States (168), 205, 177);
            Add_Goto (Table.States (168), 206, 178);
            Add_Goto (Table.States (168), 210, 179);
            Add_Goto (Table.States (168), 211, 180);
            Add_Goto (Table.States (168), 213, 181);
            Add_Goto (Table.States (168), 214, 182);
            Add_Goto (Table.States (168), 215, 183);
            Add_Goto (Table.States (168), 218, 184);
            Add_Goto (Table.States (168), 219, 185);
            Add_Goto (Table.States (168), 220, 186);
            Add_Goto (Table.States (168), 234, 346);
            Add_Goto (Table.States (168), 251, 58);
            Add_Goto (Table.States (168), 252, 59);
            Add_Goto (Table.States (168), 255, 60);
            Add_Goto (Table.States (168), 256, 194);
            Add_Goto (Table.States (168), 268, 68);
            Add_Goto (Table.States (168), 311, 83);
            Table.States (168).Kernel := To_Vector ((0 => ((233, 3),  52,  1, (32767, 0),  0)));
            Table.States (168).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (169).Action_List.Set_Capacity (39);
            Add_Action (Table.States (169), (33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 72, 73, 74, 75,
            82, 87, 88, 89, 91, 94, 95, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110, 111, 112), (234, 1),
            1);
            Table.States (169).Kernel := To_Vector ((0 => ((234, 1),  65,  0, (234, 1),  1)));
            Table.States (169).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (234, 1),  1)));
            Table.States (170).Action_List.Set_Capacity (7);
            Add_Action (Table.States (170), 52, (187, 0), 347);
            Add_Action (Table.States (170), 85, (258, 0), 348);
            Add_Action (Table.States (170), 86, (252, 0), 33);
            Add_Action (Table.States (170), 90, (268, 0), 34);
            Add_Action (Table.States (170), 116, (196, 0), 146);
            Add_Action (Table.States (170), 117, (196, 1), 37);
            Add_Action (Table.States (170), 118, (195, 6), 38);
            Table.States (170).Goto_List.Set_Capacity (14);
            Add_Goto (Table.States (170), 187, 349);
            Add_Goto (Table.States (170), 195, 350);
            Add_Goto (Table.States (170), 196, 148);
            Add_Goto (Table.States (170), 197, 54);
            Add_Goto (Table.States (170), 198, 55);
            Add_Goto (Table.States (170), 199, 56);
            Add_Goto (Table.States (170), 201, 57);
            Add_Goto (Table.States (170), 251, 58);
            Add_Goto (Table.States (170), 252, 59);
            Add_Goto (Table.States (170), 255, 60);
            Add_Goto (Table.States (170), 257, 351);
            Add_Goto (Table.States (170), 258, 352);
            Add_Goto (Table.States (170), 268, 68);
            Add_Goto (Table.States (170), 311, 83);
            Table.States (170).Kernel := To_Vector ((((256, 0),  76,  4, (32767, 0),  0), ((256, 1),  76,  1, (32767,
            0),  0)));
            Table.States (170).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
         end Subr_6;
         procedure Subr_7
         is begin
            Table.States (171).Action_List.Set_Capacity (19);
            Add_Action (Table.States (171), 12, (402, 0), 165);
            Add_Action (Table.States (171), 39, (249, 0), 353);
            Add_Action (Table.States (171), 41, (242, 0), 354);
            Add_Action (Table.States (171), 44, (233, 2), 167);
            Add_Action (Table.States (171), 51, (221, 0), 355);
            Add_Action (Table.States (171), 52, (187, 0), 356);
            Add_Action (Table.States (171), 62, (178, 3), 357);
            Add_Action (Table.States (171), 64, (245, 0), 358);
            Add_Action (Table.States (171), 65, (207, 1), 359);
            Add_Action (Table.States (171), 76, (256, 0), 170);
            Add_Action (Table.States (171), 85, (205, 4), 171);
            Add_Action (Table.States (171), 86, (213, 2), 172);
            Add_Action (Table.States (171), 90, (268, 0), 34);
            Add_Action (Table.States (171), 106, (237, 1), 173);
            Add_Action (Table.States (171), 107, (237, 0), 174);
            Add_Action (Table.States (171), 115, (234, 0), 175);
            Add_Action (Table.States (171), 116, (196, 0), 146);
            Add_Action (Table.States (171), 117, (196, 1), 37);
            Add_Action (Table.States (171), 118, (195, 6), 360);
            Table.States (171).Goto_List.Set_Capacity (51);
            Add_Goto (Table.States (171), 131, 361);
            Add_Goto (Table.States (171), 140, 362);
            Add_Goto (Table.States (171), 177, 363);
            Add_Goto (Table.States (171), 178, 364);
            Add_Goto (Table.States (171), 187, 365);
            Add_Goto (Table.States (171), 195, 366);
            Add_Goto (Table.States (171), 196, 367);
            Add_Goto (Table.States (171), 197, 54);
            Add_Goto (Table.States (171), 198, 55);
            Add_Goto (Table.States (171), 199, 56);
            Add_Goto (Table.States (171), 200, 368);
            Add_Goto (Table.States (171), 201, 57);
            Add_Goto (Table.States (171), 203, 369);
            Add_Goto (Table.States (171), 205, 177);
            Add_Goto (Table.States (171), 206, 178);
            Add_Goto (Table.States (171), 207, 370);
            Add_Goto (Table.States (171), 208, 371);
            Add_Goto (Table.States (171), 209, 372);
            Add_Goto (Table.States (171), 210, 179);
            Add_Goto (Table.States (171), 211, 180);
            Add_Goto (Table.States (171), 212, 373);
            Add_Goto (Table.States (171), 213, 181);
            Add_Goto (Table.States (171), 214, 182);
            Add_Goto (Table.States (171), 215, 183);
            Add_Goto (Table.States (171), 216, 374);
            Add_Goto (Table.States (171), 217, 375);
            Add_Goto (Table.States (171), 218, 184);
            Add_Goto (Table.States (171), 219, 185);
            Add_Goto (Table.States (171), 220, 186);
            Add_Goto (Table.States (171), 221, 376);
            Add_Goto (Table.States (171), 227, 377);
            Add_Goto (Table.States (171), 228, 188);
            Add_Goto (Table.States (171), 231, 378);
            Add_Goto (Table.States (171), 232, 190);
            Add_Goto (Table.States (171), 233, 191);
            Add_Goto (Table.States (171), 234, 192);
            Add_Goto (Table.States (171), 237, 193);
            Add_Goto (Table.States (171), 239, 379);
            Add_Goto (Table.States (171), 242, 380);
            Add_Goto (Table.States (171), 245, 381);
            Add_Goto (Table.States (171), 247, 382);
            Add_Goto (Table.States (171), 249, 383);
            Add_Goto (Table.States (171), 251, 58);
            Add_Goto (Table.States (171), 252, 59);
            Add_Goto (Table.States (171), 255, 60);
            Add_Goto (Table.States (171), 256, 194);
            Add_Goto (Table.States (171), 268, 68);
            Add_Goto (Table.States (171), 311, 83);
            Add_Goto (Table.States (171), 402, 195);
            Add_Goto (Table.States (171), 459, 384);
            Add_Goto (Table.States (171), 465, 196);
            Table.States (171).Kernel := To_Vector ((((205, 4),  85,  5, (32767, 0),  0), ((205, 5),  85,  8, (32767,
            0),  0), ((205, 6),  85,  4, (32767, 0),  0), ((206, 0),  85,  3, (32767, 0),  0), ((210, 0),  85,  5,
            (32767, 0),  0), ((213, 0),  85,  2, (32767, 0),  0), ((213, 1),  85,  6, (32767, 0),  0), ((215, 0),  85,
            4, (32767, 0),  0), ((219, 0),  85,  6, (32767, 0),  0), ((220, 0),  85,  7, (32767, 0),  0)));
            Table.States (171).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (172).Action_List.Set_Capacity (18);
            Add_Action (Table.States (172), 12, (402, 0), 165);
            Add_Action (Table.States (172), 37, (252, 0), 272);
            Add_Action (Table.States (172), 44, (233, 2), 167);
            Add_Action (Table.States (172), 51, (221, 0), 273);
            Add_Action (Table.States (172), 52, (187, 0), 356);
            Add_Action (Table.States (172), 62, (178, 3), 385);
            Add_Action (Table.States (172), 65, (234, 1), 169);
            Add_Action (Table.States (172), 76, (256, 0), 170);
            Add_Action (Table.States (172), 85, (205, 4), 171);
            Add_Action (Table.States (172), 86, (213, 2), 172);
            Add_Action (Table.States (172), 88, (214, 0), 386);
            Add_Action (Table.States (172), 90, (268, 0), 34);
            Add_Action (Table.States (172), 106, (237, 1), 173);
            Add_Action (Table.States (172), 107, (237, 0), 174);
            Add_Action (Table.States (172), 115, (234, 0), 175);
            Add_Action (Table.States (172), 116, (196, 0), 146);
            Add_Action (Table.States (172), 117, (196, 1), 37);
            Add_Action (Table.States (172), 118, (195, 6), 38);
            Table.States (172).Goto_List.Set_Capacity (41);
            Add_Goto (Table.States (172), 131, 361);
            Add_Goto (Table.States (172), 140, 362);
            Add_Goto (Table.States (172), 177, 363);
            Add_Goto (Table.States (172), 178, 364);
            Add_Goto (Table.States (172), 187, 365);
            Add_Goto (Table.States (172), 195, 366);
            Add_Goto (Table.States (172), 196, 148);
            Add_Goto (Table.States (172), 197, 54);
            Add_Goto (Table.States (172), 198, 55);
            Add_Goto (Table.States (172), 199, 56);
            Add_Goto (Table.States (172), 201, 57);
            Add_Goto (Table.States (172), 203, 369);
            Add_Goto (Table.States (172), 205, 177);
            Add_Goto (Table.States (172), 206, 178);
            Add_Goto (Table.States (172), 210, 179);
            Add_Goto (Table.States (172), 211, 180);
            Add_Goto (Table.States (172), 212, 387);
            Add_Goto (Table.States (172), 213, 181);
            Add_Goto (Table.States (172), 214, 182);
            Add_Goto (Table.States (172), 215, 183);
            Add_Goto (Table.States (172), 216, 388);
            Add_Goto (Table.States (172), 217, 375);
            Add_Goto (Table.States (172), 218, 184);
            Add_Goto (Table.States (172), 219, 185);
            Add_Goto (Table.States (172), 220, 186);
            Add_Goto (Table.States (172), 221, 389);
            Add_Goto (Table.States (172), 227, 390);
            Add_Goto (Table.States (172), 228, 188);
            Add_Goto (Table.States (172), 231, 378);
            Add_Goto (Table.States (172), 232, 190);
            Add_Goto (Table.States (172), 233, 191);
            Add_Goto (Table.States (172), 234, 192);
            Add_Goto (Table.States (172), 237, 193);
            Add_Goto (Table.States (172), 251, 58);
            Add_Goto (Table.States (172), 252, 59);
            Add_Goto (Table.States (172), 255, 60);
            Add_Goto (Table.States (172), 256, 194);
            Add_Goto (Table.States (172), 268, 68);
            Add_Goto (Table.States (172), 311, 83);
            Add_Goto (Table.States (172), 402, 195);
            Add_Goto (Table.States (172), 465, 196);
            Table.States (172).Kernel := To_Vector ((((213, 2),  86,  6, (32767, 0),  0), ((213, 3),  86,  2, (32767,
            0),  0), ((214, 0),  86,  1, (32767, 0),  0), ((215, 1),  86,  4, (32767, 0),  0), ((220, 1),  86,  7,
            (32767, 0),  0), ((252, 0),  86,  11, (32767, 0),  0), ((252, 1),  86,  8, (32767, 0),  0), ((252, 2),  86,
             7, (32767, 0),  0)));
            Table.States (172).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (214, 0),  88, 386)));
            Table.States (173).Action_List.Set_Capacity (11);
            Add_Action (Table.States (173), (44, 52, 65, 76, 85, 86, 90, 115, 116, 117, 118), (237, 1),  1);
            Table.States (173).Kernel := To_Vector ((0 => ((237, 1),  106,  0, (237, 1),  1)));
            Table.States (173).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (237, 1),  1)));
            Table.States (174).Action_List.Set_Capacity (11);
            Add_Action (Table.States (174), (44, 52, 65, 76, 85, 86, 90, 115, 116, 117, 118), (237, 0),  1);
            Table.States (174).Kernel := To_Vector ((0 => ((237, 0),  107,  0, (237, 0),  1)));
            Table.States (174).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (237, 0),  1)));
            Table.States (175).Action_List.Set_Capacity (39);
            Add_Action (Table.States (175), (33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 72, 73, 74, 75,
            82, 87, 88, 89, 91, 94, 95, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110, 111, 112), (234, 0),
            1);
            Table.States (175).Kernel := To_Vector ((0 => ((234, 0),  115,  0, (234, 0),  1)));
            Table.States (175).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (234, 0),  1)));
            Table.States (176).Action_List.Set_Capacity (43);
            Add_Action (Table.States (176), 33, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 36, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 42, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 43, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 45, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 46, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 47, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 48, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 49, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 50, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 52, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 61, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 63, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 69, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 72, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 73, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 74, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 75, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 82, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 85, (198, 0), 281);
            Add_Action (Table.States (176), 87, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 88, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 89, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 91, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 94, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 95, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 96, (197, 0), 283);
            Add_Action (Table.States (176), 97, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 98, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 99, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 100, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 101, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 103, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 104, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 106, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 107, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 108, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 109, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 110, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 111, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 112, Reduce, (234, 3),  1);
            Add_Action (Table.States (176), 113, (121, 0), 285);
            Add_Action (Table.States (176), 114, (121, 1), 286);
            Table.States (176).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (176), 121, 287);
            Add_Goto (Table.States (176), 313, 289);
            Table.States (176).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((234, 3),  195,  0,
            (234, 3),  1), ((255, 0),  195,  3, (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0)));
            Table.States (176).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (234, 3),  1)));
            Table.States (177).Action_List.Set_Capacity (39);
            Add_Action (Table.States (177), (33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 72, 73, 74, 75,
            82, 87, 88, 89, 91, 94, 95, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110, 111, 112), (234, 2),
            1);
            Table.States (177).Kernel := To_Vector ((0 => ((234, 2),  205,  0, (234, 2),  1)));
            Table.States (177).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (234, 2),  1)));
            Table.States (178).Action_List.Set_Capacity (47);
            Add_Action (Table.States (178), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (205, 0),  1);
            Table.States (178).Kernel := To_Vector ((0 => ((205, 0),  206,  0, (205, 0),  1)));
            Table.States (178).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (205, 0),  1)));
            Table.States (179).Action_List.Set_Capacity (47);
            Add_Action (Table.States (179), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (205, 1),  1);
            Table.States (179).Kernel := To_Vector ((0 => ((205, 1),  210,  0, (205, 1),  1)));
            Table.States (179).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (205, 1),  1)));
            Table.States (180).Action_List.Set_Capacity (47);
            Add_Action (Table.States (180), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (205, 2),  1);
            Table.States (180).Kernel := To_Vector ((0 => ((205, 2),  211,  0, (205, 2),  1)));
            Table.States (180).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (205, 2),  1)));
            Table.States (181).Action_List.Set_Capacity (47);
            Add_Action (Table.States (181), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (211, 0),  1);
            Table.States (181).Kernel := To_Vector ((0 => ((211, 0),  213,  0, (211, 0),  1)));
            Table.States (181).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (211, 0),  1)));
            Table.States (182).Action_List.Set_Capacity (47);
            Add_Action (Table.States (182), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (211, 1),  1);
            Table.States (182).Kernel := To_Vector ((0 => ((211, 1),  214,  0, (211, 1),  1)));
            Table.States (182).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (211, 1),  1)));
            Table.States (183).Action_List.Set_Capacity (47);
            Add_Action (Table.States (183), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (211, 2),  1);
            Table.States (183).Kernel := To_Vector ((0 => ((211, 2),  215,  0, (211, 2),  1)));
            Table.States (183).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (211, 2),  1)));
            Table.States (184).Action_List.Set_Capacity (47);
            Add_Action (Table.States (184), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (205, 3),  1);
            Table.States (184).Kernel := To_Vector ((0 => ((205, 3),  218,  0, (205, 3),  1)));
            Table.States (184).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (205, 3),  1)));
            Table.States (185).Action_List.Set_Capacity (47);
            Add_Action (Table.States (185), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (218, 0),  1);
            Table.States (185).Kernel := To_Vector ((0 => ((218, 0),  219,  0, (218, 0),  1)));
            Table.States (185).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (218, 0),  1)));
            Table.States (186).Action_List.Set_Capacity (47);
            Add_Action (Table.States (186), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (218, 1),  1);
            Table.States (186).Kernel := To_Vector ((0 => ((218, 1),  220,  0, (218, 1),  1)));
            Table.States (186).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (218, 1),  1)));
            Table.States (187).Action_List.Set_Capacity (1);
            Add_Action (Table.States (187), 108, (366, 0), 391);
            Table.States (187).Kernel := To_Vector ((0 => ((366, 0),  227,  1, (32767, 0),  0)));
            Table.States (187).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (366, 0),  108, 391)));
            Table.States (188).Action_List.Set_Capacity (20);
            Add_Action (Table.States (188), 33, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 36, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 42, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 46, (226, 0), 392);
            Add_Action (Table.States (188), 47, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 48, (224, 0), 393);
            Add_Action (Table.States (188), 49, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 50, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 61, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 63, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 72, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 74, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 75, (222, 0), 394);
            Add_Action (Table.States (188), 82, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 87, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 88, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 91, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 95, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 99, Reduce, (227, 0),  1);
            Add_Action (Table.States (188), 108, Reduce, (227, 0),  1);
            Table.States (188).Goto_List.Set_Capacity (5);
            Add_Goto (Table.States (188), 222, 395);
            Add_Goto (Table.States (188), 223, 396);
            Add_Goto (Table.States (188), 224, 397);
            Add_Goto (Table.States (188), 225, 398);
            Add_Goto (Table.States (188), 226, 399);
            Table.States (188).Kernel := To_Vector ((((227, 0),  228,  0, (227, 0),  1), ((227, 1),  228,  2, (32767,
            0),  0), ((227, 2),  228,  3, (32767, 0),  0), ((227, 3),  228,  2, (32767, 0),  0), ((227, 4),  228,  3,
            (32767, 0),  0), ((227, 5),  228,  2, (32767, 0),  0)));
            Table.States (188).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (227, 0),  1)));
            Table.States (189).Action_List.Set_Capacity (28);
            Add_Action (Table.States (189), 33, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 36, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 42, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 45, (228, 3), 400);
            Add_Action (Table.States (189), 46, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 47, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 48, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 49, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 50, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 52, (228, 2), 401);
            Add_Action (Table.States (189), 61, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 63, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 72, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 74, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 75, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 82, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 87, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 88, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 91, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 95, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 98, (235, 0), 402);
            Add_Action (Table.States (189), 99, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 100, (235, 4), 403);
            Add_Action (Table.States (189), 101, (235, 5), 404);
            Add_Action (Table.States (189), 103, (235, 2), 405);
            Add_Action (Table.States (189), 104, (235, 3), 406);
            Add_Action (Table.States (189), 108, Reduce, (228, 1),  1);
            Add_Action (Table.States (189), 110, (235, 1), 407);
            Table.States (189).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (189), 235, 408);
            Table.States (189).Kernel := To_Vector ((((228, 0),  231,  2, (32767, 0),  0), ((228, 1),  231,  0, (228,
            1),  1), ((228, 2),  231,  3, (32767, 0),  0), ((228, 3),  231,  2, (32767, 0),  0)));
            Table.States (189).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (228, 1),  1)));
            Table.States (190).Action_List.Set_Capacity (38);
            Add_Action (Table.States (190), 33, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 36, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 42, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 43, (238, 3), 409);
            Add_Action (Table.States (190), 45, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 46, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 47, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 48, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 49, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 50, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 52, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 61, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 63, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 69, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 72, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 73, (238, 2), 410);
            Add_Action (Table.States (190), 74, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 75, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 82, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 87, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 88, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 89, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 91, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 94, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 95, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 97, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 98, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 99, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 100, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 101, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 103, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 104, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 106, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 107, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 108, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 109, (238, 1), 411);
            Add_Action (Table.States (190), 110, Reduce, (465, 0),  1);
            Add_Action (Table.States (190), 111, (238, 0), 412);
            Table.States (190).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (190), 238, 413);
            Table.States (190).Kernel := To_Vector ((((232, 1),  232,  2, (32767, 0),  0), ((232, 2),  232,  2, (32767,
            0),  0), ((465, 0),  232,  0, (465, 0),  1)));
            Table.States (190).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (465, 0),  1)));
         end Subr_7;
         procedure Subr_8
         is begin
            Table.States (191).Action_List.Set_Capacity (38);
            Add_Action (Table.States (191), (33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 72, 73, 74, 75,
            82, 87, 88, 89, 91, 94, 95, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110, 111), (232, 0),  1);
            Table.States (191).Kernel := To_Vector ((0 => ((232, 0),  233,  0, (232, 0),  1)));
            Table.States (191).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (232, 0),  1)));
            Table.States (192).Action_List.Set_Capacity (39);
            Add_Action (Table.States (192), 33, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 36, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 42, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 43, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 45, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 46, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 47, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 48, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 49, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 50, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 52, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 61, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 63, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 69, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 72, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 73, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 74, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 75, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 82, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 87, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 88, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 89, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 91, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 94, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 95, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 97, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 98, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 99, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 100, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 101, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 103, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 104, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 106, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 107, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 108, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 109, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 110, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 111, Reduce, (233, 1),  1);
            Add_Action (Table.States (192), 112, (233, 0), 414);
            Table.States (192).Kernel := To_Vector ((((233, 0),  234,  2, (32767, 0),  0), ((233, 1),  234,  0, (233,
            1),  1)));
            Table.States (192).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (233, 1),  1)));
            Table.States (193).Action_List.Set_Capacity (11);
            Add_Action (Table.States (193), 44, (233, 2), 167);
            Add_Action (Table.States (193), 52, (233, 3), 168);
            Add_Action (Table.States (193), 65, (234, 1), 169);
            Add_Action (Table.States (193), 76, (256, 0), 170);
            Add_Action (Table.States (193), 85, (205, 4), 171);
            Add_Action (Table.States (193), 86, (213, 2), 172);
            Add_Action (Table.States (193), 90, (268, 0), 34);
            Add_Action (Table.States (193), 115, (234, 0), 175);
            Add_Action (Table.States (193), 116, (196, 0), 146);
            Add_Action (Table.States (193), 117, (196, 1), 37);
            Add_Action (Table.States (193), 118, (195, 6), 38);
            Table.States (193).Goto_List.Set_Capacity (26);
            Add_Goto (Table.States (193), 195, 176);
            Add_Goto (Table.States (193), 196, 148);
            Add_Goto (Table.States (193), 197, 54);
            Add_Goto (Table.States (193), 198, 55);
            Add_Goto (Table.States (193), 199, 56);
            Add_Goto (Table.States (193), 201, 57);
            Add_Goto (Table.States (193), 205, 177);
            Add_Goto (Table.States (193), 206, 178);
            Add_Goto (Table.States (193), 210, 179);
            Add_Goto (Table.States (193), 211, 180);
            Add_Goto (Table.States (193), 213, 181);
            Add_Goto (Table.States (193), 214, 182);
            Add_Goto (Table.States (193), 215, 183);
            Add_Goto (Table.States (193), 218, 184);
            Add_Goto (Table.States (193), 219, 185);
            Add_Goto (Table.States (193), 220, 186);
            Add_Goto (Table.States (193), 232, 190);
            Add_Goto (Table.States (193), 233, 191);
            Add_Goto (Table.States (193), 234, 192);
            Add_Goto (Table.States (193), 251, 58);
            Add_Goto (Table.States (193), 252, 59);
            Add_Goto (Table.States (193), 255, 60);
            Add_Goto (Table.States (193), 256, 194);
            Add_Goto (Table.States (193), 268, 68);
            Add_Goto (Table.States (193), 311, 83);
            Add_Goto (Table.States (193), 465, 415);
            Table.States (193).Kernel := To_Vector ((0 => ((231, 0),  237,  1, (32767, 0),  0)));
            Table.States (193).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (194).Action_List.Set_Capacity (39);
            Add_Action (Table.States (194), (33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 72, 73, 74, 75,
            82, 87, 88, 89, 91, 94, 95, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110, 111, 112), (234, 4),
            1);
            Table.States (194).Kernel := To_Vector ((0 => ((234, 4),  256,  0, (234, 4),  1)));
            Table.States (194).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (234, 4),  1)));
            Table.States (195).Action_List.Set_Capacity (20);
            Add_Action (Table.States (195), (33, 36, 42, 46, 47, 48, 49, 50, 61, 63, 72, 74, 75, 82, 87, 88, 91, 95,
            99, 108), (228, 4),  1);
            Table.States (195).Kernel := To_Vector ((0 => ((228, 4),  402,  0, (228, 4),  1)));
            Table.States (195).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (228, 4),  1)));
            Table.States (196).Action_List.Set_Capacity (34);
            Add_Action (Table.States (196), 33, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 36, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 42, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 45, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 46, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 47, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 48, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 49, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 50, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 52, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 61, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 63, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 69, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 72, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 74, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 75, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 82, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 87, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 88, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 89, (236, 2), 416);
            Add_Action (Table.States (196), 91, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 94, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 95, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 97, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 98, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 99, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 100, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 101, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 103, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 104, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 106, (236, 1), 417);
            Add_Action (Table.States (196), 107, (236, 0), 418);
            Add_Action (Table.States (196), 108, Reduce, (231, 1),  1);
            Add_Action (Table.States (196), 110, Reduce, (231, 1),  1);
            Table.States (196).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (196), 236, 419);
            Table.States (196).Kernel := To_Vector ((((231, 1),  465,  0, (231, 1),  1), ((465, 1),  465,  2, (32767,
            0),  0), ((465, 2),  465,  2, (32767, 0),  0)));
            Table.States (196).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (231, 1),  1)));
            Table.States (197).Action_List.Set_Capacity (7);
            Add_Action (Table.States (197), 85, (198, 0), 281);
            Add_Action (Table.States (197), 87, Reduce, (306, 0),  1);
            Add_Action (Table.States (197), 95, Reduce, (306, 0),  1);
            Add_Action (Table.States (197), 96, (197, 0), 283);
            Add_Action (Table.States (197), 108, Reduce, (306, 0),  1);
            Add_Action (Table.States (197), 113, (121, 0), 285);
            Add_Action (Table.States (197), 114, (121, 1), 286);
            Table.States (197).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (197), 121, 287);
            Add_Goto (Table.States (197), 313, 289);
            Table.States (197).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((306, 0),  195,  0, (306, 0),  1), ((311, 0),  195,  3, (32767, 0),  0)));
            Table.States (197).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (306, 0),  1)));
            Table.States (198).Action_List.Set_Capacity (2);
            Add_Action (Table.States (198), 95, (306, 1), 420);
            Add_Action (Table.States (198), 108, (382, 0), 421);
            Table.States (198).Kernel := To_Vector ((((306, 1),  306,  2, (32767, 0),  0), ((306, 2),  306,  2, (32767,
            0),  0), ((382, 0),  306,  1, (32767, 0),  0)));
            Table.States (198).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (382, 0),  108, 421)));
            Table.States (199).Action_List.Set_Capacity (6);
            Add_Action (Table.States (199), 61, (363, 0), 422);
            Add_Action (Table.States (199), 85, (198, 0), 281);
            Add_Action (Table.States (199), 96, (197, 0), 283);
            Add_Action (Table.States (199), 108, (363, 1), 423);
            Add_Action (Table.States (199), 113, (121, 0), 285);
            Add_Action (Table.States (199), 114, (121, 1), 286);
            Table.States (199).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (199), 121, 287);
            Add_Goto (Table.States (199), 313, 289);
            Table.States (199).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((363, 0),  195,  3, (32767, 0),  0), ((363, 1),
            195,  1, (32767, 0),  0)));
            Table.States (199).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (363, 1),  108, 423)));
            Table.States (200).Action_List.Set_Capacity (3);
            Add_Action (Table.States (200), 33, Reduce, (295, 1),  0);
            Add_Action (Table.States (200), 85, (299, 0), 424);
            Add_Action (Table.States (200), 108, Reduce, (295, 1),  0);
            Table.States (200).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (200), 295, 425);
            Add_Goto (Table.States (200), 299, 426);
            Table.States (200).Kernel := To_Vector ((((357, 0),  196,  8, (32767, 0),  0), ((357, 1),  196,  4, (32767,
            0),  0), ((357, 2),  196,  5, (32767, 0),  0), ((357, 3),  196,  1, (32767, 0),  0)));
            Table.States (200).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (295, 1),  0)));
            Table.States (201).Action_List.Set_Capacity (3);
            Add_Action (Table.States (201), 61, Reduce, (295, 1),  0);
            Add_Action (Table.States (201), 85, (299, 0), 427);
            Add_Action (Table.States (201), 108, Reduce, (295, 1),  0);
            Table.States (201).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (201), 295, 428);
            Add_Goto (Table.States (201), 299, 426);
            Table.States (201).Kernel := To_Vector ((((356, 4),  116,  6, (32767, 0),  0), ((356, 5),  116,  4, (32767,
            0),  0), ((356, 6),  116,  3, (32767, 0),  0), ((356, 7),  116,  1, (32767, 0),  0)));
            Table.States (201).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (295, 1),  0)));
            Table.States (202).Action_List.Set_Capacity (5);
            Add_Action (Table.States (202), 86, (252, 0), 33);
            Add_Action (Table.States (202), 90, (268, 0), 34);
            Add_Action (Table.States (202), 116, (196, 0), 146);
            Add_Action (Table.States (202), 117, (196, 1), 37);
            Add_Action (Table.States (202), 118, (195, 6), 38);
            Table.States (202).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (202), 195, 429);
            Add_Goto (Table.States (202), 196, 148);
            Add_Goto (Table.States (202), 197, 54);
            Add_Goto (Table.States (202), 198, 55);
            Add_Goto (Table.States (202), 199, 56);
            Add_Goto (Table.States (202), 201, 57);
            Add_Goto (Table.States (202), 251, 58);
            Add_Goto (Table.States (202), 252, 59);
            Add_Goto (Table.States (202), 255, 60);
            Add_Goto (Table.States (202), 268, 68);
            Add_Goto (Table.States (202), 311, 83);
            Table.States (202).Kernel := To_Vector ((((339, 0),  28,  6, (32767, 0),  0), ((339, 1),  28,  4, (32767,
            0),  0)));
            Table.States (202).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (203).Action_List.Set_Capacity (5);
            Add_Action (Table.States (203), 86, (252, 0), 33);
            Add_Action (Table.States (203), 90, (268, 0), 34);
            Add_Action (Table.States (203), 116, (196, 0), 146);
            Add_Action (Table.States (203), 117, (196, 1), 37);
            Add_Action (Table.States (203), 118, (195, 6), 38);
            Table.States (203).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (203), 195, 430);
            Add_Goto (Table.States (203), 196, 148);
            Add_Goto (Table.States (203), 197, 54);
            Add_Goto (Table.States (203), 198, 55);
            Add_Goto (Table.States (203), 199, 56);
            Add_Goto (Table.States (203), 201, 57);
            Add_Goto (Table.States (203), 251, 58);
            Add_Goto (Table.States (203), 252, 59);
            Add_Goto (Table.States (203), 255, 60);
            Add_Goto (Table.States (203), 268, 68);
            Add_Goto (Table.States (203), 311, 83);
            Table.States (203).Kernel := To_Vector ((((339, 4),  53,  6, (32767, 0),  0), ((339, 5),  53,  4, (32767,
            0),  0)));
            Table.States (203).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (204).Action_List.Set_Capacity (5);
            Add_Action (Table.States (204), 86, (252, 0), 33);
            Add_Action (Table.States (204), 90, (268, 0), 34);
            Add_Action (Table.States (204), 116, (196, 0), 146);
            Add_Action (Table.States (204), 117, (196, 1), 37);
            Add_Action (Table.States (204), 118, (195, 6), 38);
            Table.States (204).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (204), 195, 431);
            Add_Goto (Table.States (204), 196, 148);
            Add_Goto (Table.States (204), 197, 54);
            Add_Goto (Table.States (204), 198, 55);
            Add_Goto (Table.States (204), 199, 56);
            Add_Goto (Table.States (204), 201, 57);
            Add_Goto (Table.States (204), 251, 58);
            Add_Goto (Table.States (204), 252, 59);
            Add_Goto (Table.States (204), 255, 60);
            Add_Goto (Table.States (204), 268, 68);
            Add_Goto (Table.States (204), 311, 83);
            Table.States (204).Kernel := To_Vector ((((339, 2),  54,  6, (32767, 0),  0), ((339, 3),  54,  4, (32767,
            0),  0)));
            Table.States (204).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (205).Action_List.Set_Capacity (3);
            Add_Action (Table.States (205), 28, (430, 0), 432);
            Add_Action (Table.States (205), 53, (294, 0), 314);
            Add_Action (Table.States (205), 54, (293, 0), 315);
            Table.States (205).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (205), 292, 433);
            Add_Goto (Table.States (205), 293, 317);
            Add_Goto (Table.States (205), 294, 318);
            Table.States (205).Kernel := To_Vector ((((426, 0),  61,  7, (32767, 0),  0), ((426, 1),  61,  5, (32767,
            0),  0), ((426, 2),  61,  5, (32767, 0),  0), ((426, 3),  61,  3, (32767, 0),  0), ((427, 0),  61,  8,
            (32767, 0),  0), ((427, 1),  61,  6, (32767, 0),  0), ((427, 2),  61,  7, (32767, 0),  0), ((427, 3),  61,
            5, (32767, 0),  0), ((430, 0),  61,  8, (32767, 0),  0), ((430, 1),  61,  6, (32767, 0),  0)));
            Table.States (205).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (293, 0),  54, 315)));
            Table.States (206).Action_List.Set_Capacity (1);
            Add_Action (Table.States (206), 116, (411, 0), 434);
            Table.States (206).Kernel := To_Vector ((((411, 0),  83,  12, (32767, 0),  0), ((411, 1),  83,  10, (32767,
            0),  0), ((411, 2),  83,  9, (32767, 0),  0), ((411, 3),  83,  7, (32767, 0),  0), ((411, 4),  83,  9,
            (32767, 0),  0), ((411, 5),  83,  7, (32767, 0),  0), ((411, 6),  83,  6, (32767, 0),  0), ((411, 7),  83,
            4, (32767, 0),  0), ((412, 0),  83,  10, (32767, 0),  0), ((412, 1),  83,  7, (32767, 0),  0), ((412, 2),
            83,  8, (32767, 0),  0), ((412, 3),  83,  5, (32767, 0),  0), ((412, 4),  83,  7, (32767, 0),  0), ((412,
            5),  83,  4, (32767, 0),  0), ((412, 6),  83,  5, (32767, 0),  0), ((412, 7),  83,  2, (32767, 0),  0)));
            Table.States (206).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (411, 0),  116, 434)));
            Table.States (207).Action_List.Set_Capacity (3);
            Add_Action (Table.States (207), (87, 93, 95), (136, 0),  1);
            Table.States (207).Kernel := To_Vector ((0 => ((136, 0),  116,  0, (136, 0),  1)));
            Table.States (207).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (136, 0),  1)));
            Table.States (208).Action_List.Set_Capacity (8);
            Add_Action (Table.States (208), (28, 50, 53, 54, 61, 83, 84, 116), (407, 5),  1);
            Table.States (208).Kernel := To_Vector ((0 => ((407, 5),  124,  0, (407, 5),  1)));
            Table.States (208).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (407, 5),  1)));
            Table.States (209).Action_List.Set_Capacity (2);
            Add_Action (Table.States (209), 93, (409, 0), 435);
            Add_Action (Table.States (209), 95, (136, 1), 280);
            Table.States (209).Kernel := To_Vector ((((136, 1),  136,  2, (32767, 0),  0), ((409, 0),  136,  9, (32767,
            0),  0), ((409, 1),  136,  7, (32767, 0),  0), ((409, 2),  136,  7, (32767, 0),  0), ((409, 3),  136,  5,
            (32767, 0),  0), ((409, 4),  136,  7, (32767, 0),  0), ((409, 5),  136,  5, (32767, 0),  0), ((409, 6),
            136,  5, (32767, 0),  0), ((409, 7),  136,  3, (32767, 0),  0), ((409, 8),  136,  8, (32767, 0),  0),
            ((409, 9),  136,  6, (32767, 0),  0), ((409, 10),  136,  6, (32767, 0),  0), ((409, 11),  136,  4, (32767,
            0),  0)));
            Table.States (209).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (409, 0),  93, 435)));
            Table.States (210).Action_List.Set_Capacity (8);
            Add_Action (Table.States (210), (28, 50, 53, 54, 61, 83, 84, 116), (407, 4),  1);
            Table.States (210).Kernel := To_Vector ((0 => ((407, 4),  330,  0, (407, 4),  1)));
            Table.States (210).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (407, 4),  1)));
            Table.States (211).Action_List.Set_Capacity (8);
            Add_Action (Table.States (211), (28, 50, 53, 54, 61, 83, 84, 116), (464, 0),  1);
            Table.States (211).Kernel := To_Vector ((0 => ((464, 0),  407,  0, (464, 0),  1)));
            Table.States (211).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (464, 0),  1)));
            Table.States (212).Action_List.Set_Capacity (8);
            Add_Action (Table.States (212), (28, 50, 53, 54, 61, 83, 84, 116), (407, 0),  1);
            Table.States (212).Kernel := To_Vector ((0 => ((407, 0),  409,  0, (407, 0),  1)));
            Table.States (212).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (407, 0),  1)));
            Table.States (213).Action_List.Set_Capacity (8);
            Add_Action (Table.States (213), (28, 50, 53, 54, 61, 83, 84, 116), (407, 1),  1);
            Table.States (213).Kernel := To_Vector ((0 => ((407, 1),  410,  0, (407, 1),  1)));
            Table.States (213).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (407, 1),  1)));
            Table.States (214).Action_List.Set_Capacity (8);
            Add_Action (Table.States (214), (28, 50, 53, 54, 61, 83, 84, 116), (410, 0),  1);
            Table.States (214).Kernel := To_Vector ((0 => ((410, 0),  411,  0, (410, 0),  1)));
            Table.States (214).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (410, 0),  1)));
            Table.States (215).Action_List.Set_Capacity (8);
            Add_Action (Table.States (215), (28, 50, 53, 54, 61, 83, 84, 116), (410, 1),  1);
            Table.States (215).Kernel := To_Vector ((0 => ((410, 1),  412,  0, (410, 1),  1)));
            Table.States (215).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (410, 1),  1)));
            Table.States (216).Action_List.Set_Capacity (8);
            Add_Action (Table.States (216), (28, 50, 53, 54, 61, 83, 84, 116), (407, 2),  1);
            Table.States (216).Kernel := To_Vector ((0 => ((407, 2),  425,  0, (407, 2),  1)));
            Table.States (216).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (407, 2),  1)));
            Table.States (217).Action_List.Set_Capacity (8);
            Add_Action (Table.States (217), (28, 50, 53, 54, 61, 83, 84, 116), (425, 0),  1);
            Table.States (217).Kernel := To_Vector ((0 => ((425, 0),  426,  0, (425, 0),  1)));
            Table.States (217).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (425, 0),  1)));
            Table.States (218).Action_List.Set_Capacity (8);
            Add_Action (Table.States (218), (28, 50, 53, 54, 61, 83, 84, 116), (425, 1),  1);
            Table.States (218).Kernel := To_Vector ((0 => ((425, 1),  427,  0, (425, 1),  1)));
            Table.States (218).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (425, 1),  1)));
            Table.States (219).Action_List.Set_Capacity (8);
            Add_Action (Table.States (219), (28, 50, 53, 54, 61, 83, 84, 116), (407, 3),  1);
            Table.States (219).Kernel := To_Vector ((0 => ((407, 3),  430,  0, (407, 3),  1)));
            Table.States (219).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (407, 3),  1)));
            Table.States (220).Action_List.Set_Capacity (8);
            Add_Action (Table.States (220), 28, Reduce, (406, 0),  2);
            Add_Action (Table.States (220), 50, (332, 0), 19);
            Add_Action (Table.States (220), 53, Reduce, (406, 0),  2);
            Add_Action (Table.States (220), 54, Reduce, (406, 0),  2);
            Add_Action (Table.States (220), 61, (426, 0), 205);
            Add_Action (Table.States (220), 83, (411, 0), 206);
            Add_Action (Table.States (220), 84, (124, 0), 32);
            Add_Action (Table.States (220), 116, (136, 0), 207);
            Table.States (220).Goto_List.Set_Capacity (15);
            Add_Goto (Table.States (220), 124, 208);
            Add_Goto (Table.States (220), 136, 209);
            Add_Goto (Table.States (220), 330, 210);
            Add_Goto (Table.States (220), 332, 95);
            Add_Goto (Table.States (220), 333, 96);
            Add_Goto (Table.States (220), 407, 436);
            Add_Goto (Table.States (220), 409, 212);
            Add_Goto (Table.States (220), 410, 213);
            Add_Goto (Table.States (220), 411, 214);
            Add_Goto (Table.States (220), 412, 215);
            Add_Goto (Table.States (220), 425, 216);
            Add_Goto (Table.States (220), 426, 217);
            Add_Goto (Table.States (220), 427, 218);
            Add_Goto (Table.States (220), 430, 219);
            Add_Goto (Table.States (220), 464, 437);
            Table.States (220).Kernel := To_Vector ((((406, 0),  464,  0, (406, 0),  2), ((464, 1),  464,  3, (32767,
            0),  0), ((464, 2),  464,  3, (32767, 0),  0)));
            Table.States (220).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (406, 0),  2)));
         end Subr_8;
         procedure Subr_9
         is begin
            Table.States (221).Action_List.Set_Capacity (5);
            Add_Action (Table.States (221), 86, (252, 0), 33);
            Add_Action (Table.States (221), 90, (268, 0), 34);
            Add_Action (Table.States (221), 116, (196, 0), 146);
            Add_Action (Table.States (221), 117, (196, 1), 37);
            Add_Action (Table.States (221), 118, (195, 6), 38);
            Table.States (221).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (221), 195, 248);
            Add_Goto (Table.States (221), 196, 249);
            Add_Goto (Table.States (221), 197, 54);
            Add_Goto (Table.States (221), 198, 55);
            Add_Goto (Table.States (221), 199, 56);
            Add_Goto (Table.States (221), 201, 57);
            Add_Goto (Table.States (221), 251, 58);
            Add_Goto (Table.States (221), 252, 59);
            Add_Goto (Table.States (221), 255, 60);
            Add_Goto (Table.States (221), 268, 68);
            Add_Goto (Table.States (221), 311, 83);
            Table.States (221).Kernel := To_Vector ((((437, 0),  51,  6, (32767, 0),  0), ((438, 0),  51,  5, (32767,
            0),  0), ((440, 0),  51,  19, (32767, 0),  0), ((440, 1),  51,  18, (32767, 0),  0), ((440, 2),  51,  11,
            (32767, 0),  0), ((440, 3),  51,  10, (32767, 0),  0), ((440, 4),  51,  15, (32767, 0),  0), ((440, 5),
            51,  14, (32767, 0),  0), ((440, 6),  51,  7, (32767, 0),  0), ((440, 7),  51,  6, (32767, 0),  0), ((454,
            0),  51,  5, (32767, 0),  0)));
            Table.States (221).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (222).Action_List.Set_Capacity (5);
            Add_Action (Table.States (222), 86, (252, 0), 33);
            Add_Action (Table.States (222), 90, (268, 0), 34);
            Add_Action (Table.States (222), 116, (196, 0), 146);
            Add_Action (Table.States (222), 117, (196, 1), 37);
            Add_Action (Table.States (222), 118, (195, 6), 38);
            Table.States (222).Goto_List.Set_Capacity (12);
            Add_Goto (Table.States (222), 195, 244);
            Add_Goto (Table.States (222), 196, 148);
            Add_Goto (Table.States (222), 197, 54);
            Add_Goto (Table.States (222), 198, 55);
            Add_Goto (Table.States (222), 199, 56);
            Add_Goto (Table.States (222), 201, 57);
            Add_Goto (Table.States (222), 251, 58);
            Add_Goto (Table.States (222), 252, 59);
            Add_Goto (Table.States (222), 255, 60);
            Add_Goto (Table.States (222), 268, 68);
            Add_Goto (Table.States (222), 311, 83);
            Add_Goto (Table.States (222), 331, 438);
            Table.States (222).Kernel := To_Vector ((0 => ((387, 0),  61,  2, (32767, 0),  0)));
            Table.States (222).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (223).Action_List.Set_Capacity (3);
            Add_Action (Table.States (223), 24, (335, 4), 277);
            Add_Action (Table.States (223), 93, (335, 0), 278);
            Add_Conflict (Table.States (223), 93, (136, 0),  1);
            Add_Action (Table.States (223), 95, Reduce, (136, 0),  1);
            Table.States (223).Kernel := To_Vector ((((136, 0),  116,  0, (136, 0),  1), ((335, 0),  116,  9, (32767,
            0),  0), ((335, 1),  116,  7, (32767, 0),  0), ((335, 2),  116,  7, (32767, 0),  0), ((335, 3),  116,  5,
            (32767, 0),  0), ((335, 4),  116,  5, (32767, 0),  0), ((335, 5),  116,  3, (32767, 0),  0), ((335, 6),
            116,  8, (32767, 0),  0), ((335, 7),  116,  6, (32767, 0),  0), ((336, 0),  116,  7, (32767, 0),  0),
            ((336, 1),  116,  5, (32767, 0),  0)));
            Table.States (223).Minimal_Complete_Actions := To_Vector (((Reduce, (136, 0),  1), (Shift, (335, 4),  24,
            277)));
            Table.States (224).Action_List.Set_Capacity (42);
            Add_Action (Table.States (224), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (384,
            1),  2);
            Table.States (224).Kernel := To_Vector ((0 => ((384, 1),  190,  0, (384, 1),  2)));
            Table.States (224).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (384, 1),  2)));
            Table.States (225).Action_List.Set_Capacity (2);
            Add_Action (Table.States (225), 53, (294, 0), 307);
            Add_Action (Table.States (225), 54, (293, 0), 308);
            Table.States (225).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (225), 292, 309);
            Add_Goto (Table.States (225), 293, 310);
            Add_Goto (Table.States (225), 294, 311);
            Table.States (225).Kernel := To_Vector ((((180, 0),  329,  7, (32767, 0),  0), ((180, 1),  329,  5, (32767,
            0),  0), ((291, 0),  329,  5, (32767, 0),  0), ((291, 1),  329,  3, (32767, 0),  0), ((309, 0),  329,  10,
            (32767, 0),  0), ((309, 1),  329,  8, (32767, 0),  0), ((320, 0),  329,  7, (32767, 0),  0), ((320, 1),
            329,  5, (32767, 0),  0), ((321, 0),  329,  10, (32767, 0),  0), ((321, 1),  329,  8, (32767, 0),  0),
            ((338, 0),  329,  7, (32767, 0),  0), ((338, 1),  329,  5, (32767, 0),  0), ((389, 0),  329,  7, (32767,
            0),  0), ((389, 1),  329,  5, (32767, 0),  0), ((408, 2),  329,  8, (32767, 0),  0), ((408, 3),  329,  6,
            (32767, 0),  0), ((408, 6),  329,  8, (32767, 0),  0), ((408, 7),  329,  6, (32767, 0),  0)));
            Table.States (225).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (293, 0),  54, 308)));
            Table.States (226).Action_List.Set_Capacity (5);
            Add_Action (Table.States (226), 86, (252, 0), 33);
            Add_Action (Table.States (226), 90, (268, 0), 34);
            Add_Action (Table.States (226), 116, (196, 0), 439);
            Add_Action (Table.States (226), 117, (196, 1), 37);
            Add_Action (Table.States (226), 118, (195, 6), 38);
            Table.States (226).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (226), 195, 440);
            Add_Goto (Table.States (226), 196, 148);
            Add_Goto (Table.States (226), 197, 54);
            Add_Goto (Table.States (226), 198, 55);
            Add_Goto (Table.States (226), 199, 56);
            Add_Goto (Table.States (226), 201, 57);
            Add_Goto (Table.States (226), 251, 58);
            Add_Goto (Table.States (226), 252, 59);
            Add_Goto (Table.States (226), 255, 60);
            Add_Goto (Table.States (226), 268, 68);
            Add_Goto (Table.States (226), 311, 83);
            Table.States (226).Kernel := To_Vector ((((326, 0),  26,  9, (32767, 0),  0), ((326, 1),  26,  6, (32767,
            0),  0), ((326, 2),  26,  7, (32767, 0),  0), ((326, 3),  26,  4, (32767, 0),  0), ((390, 0),  26,  6,
            (32767, 0),  0), ((390, 1),  26,  4, (32767, 0),  0)));
            Table.States (226).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 439)));
            Table.States (227).Action_List.Set_Capacity (7);
            Add_Action (Table.States (227), 24, (337, 0), 441);
            Add_Action (Table.States (227), 61, (434, 0), 299);
            Add_Action (Table.States (227), 82, (325, 6), 442);
            Add_Action (Table.States (227), 85, (198, 0), 281);
            Add_Action (Table.States (227), 96, (197, 0), 283);
            Add_Action (Table.States (227), 113, (121, 0), 285);
            Add_Action (Table.States (227), 114, (121, 1), 286);
            Table.States (227).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (227), 121, 287);
            Add_Goto (Table.States (227), 313, 289);
            Add_Goto (Table.States (227), 434, 443);
            Table.States (227).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((325, 0),  195,  11, (32767, 0),  0), ((325, 1),
            195,  8, (32767, 0),  0), ((325, 2),  195,  7, (32767, 0),  0), ((325, 3),  195,  8, (32767, 0),  0),
            ((325, 4),  195,  5, (32767, 0),  0), ((325, 5),  195,  4, (32767, 0),  0), ((325, 6),  195,  9, (32767,
            0),  0), ((325, 7),  195,  6, (32767, 0),  0), ((325, 8),  195,  5, (32767, 0),  0), ((325, 9),  195,  6,
            (32767, 0),  0), ((325, 10),  195,  3, (32767, 0),  0), ((325, 11),  195,  2, (32767, 0),  0), ((337, 0),
            195,  5, (32767, 0),  0), ((337, 1),  195,  3, (32767, 0),  0), ((408, 0),  195,  6, (32767, 0),  0),
            ((408, 1),  195,  4, (32767, 0),  0)));
            Table.States (227).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (325, 6),  82, 442)));
            Table.States (228).Action_List.Set_Capacity (50);
            Add_Action (Table.States (228), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (316, 1),  2);
            Table.States (228).Kernel := To_Vector ((0 => ((316, 1),  108,  0, (316, 1),  2)));
            Table.States (228).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (316, 1),  2)));
            Table.States (229).Action_List.Set_Capacity (25);
            Add_Action (Table.States (229), 43, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 45, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 46, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 48, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 52, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 73, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 75, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 85, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 89, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 93, (317, 0), 444);
            Add_Action (Table.States (229), 96, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 98, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 100, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 101, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 103, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 104, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 106, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 107, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 108, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 109, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 110, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 111, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 112, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 113, Reduce, (196, 0),  1);
            Add_Action (Table.States (229), 114, Reduce, (196, 0),  1);
            Table.States (229).Kernel := To_Vector ((((196, 0),  116,  0, (196, 0),  1), ((317, 0),  116,  6, (32767,
            0),  0), ((317, 1),  116,  4, (32767, 0),  0), ((317, 2),  116,  5, (32767, 0),  0), ((317, 3),  116,  3,
            (32767, 0),  0), ((317, 4),  116,  5, (32767, 0),  0), ((317, 5),  116,  3, (32767, 0),  0), ((317, 6),
            116,  4, (32767, 0),  0), ((317, 7),  116,  2, (32767, 0),  0)));
            Table.States (229).Minimal_Complete_Actions := To_Vector (((Reduce, (196, 0),  1), (Shift, (317, 0),  93,
            444)));
            Table.States (230).Action_List.Set_Capacity (1);
            Add_Action (Table.States (230), 108, (316, 0), 445);
            Table.States (230).Kernel := To_Vector ((0 => ((316, 0),  227,  1, (32767, 0),  0)));
            Table.States (230).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (316, 0),  108, 445)));
            Table.States (231).Action_List.Set_Capacity (2);
            Add_Action (Table.States (231), 33, (318, 0), 446);
            Add_Action (Table.States (231), 108, (318, 1), 447);
            Table.States (231).Kernel := To_Vector ((((318, 0),  317,  6, (32767, 0),  0), ((318, 1),  317,  1, (32767,
            0),  0)));
            Table.States (231).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (318, 1),  108, 447)));
            Table.States (232).Action_List.Set_Capacity (5);
            Add_Action (Table.States (232), 85, (198, 0), 281);
            Add_Action (Table.States (232), 96, (197, 0), 283);
            Add_Action (Table.States (232), 108, (290, 0), 448);
            Add_Action (Table.States (232), 113, (121, 0), 285);
            Add_Action (Table.States (232), 114, (121, 1), 286);
            Table.States (232).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (232), 121, 287);
            Add_Goto (Table.States (232), 313, 289);
            Table.States (232).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((290, 0),  195,  1, (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0)));
            Table.States (232).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (290, 0),  108, 448)));
            Table.States (233).Action_List.Set_Capacity (14);
            Add_Action (Table.States (233), 12, (402, 0), 165);
            Add_Action (Table.States (233), 44, (233, 2), 167);
            Add_Action (Table.States (233), 52, (233, 3), 168);
            Add_Action (Table.States (233), 65, (234, 1), 169);
            Add_Action (Table.States (233), 76, (256, 0), 170);
            Add_Action (Table.States (233), 85, (205, 4), 171);
            Add_Action (Table.States (233), 86, (213, 2), 172);
            Add_Action (Table.States (233), 90, (268, 0), 34);
            Add_Action (Table.States (233), 106, (237, 1), 173);
            Add_Action (Table.States (233), 107, (237, 0), 174);
            Add_Action (Table.States (233), 115, (234, 0), 175);
            Add_Action (Table.States (233), 116, (196, 0), 146);
            Add_Action (Table.States (233), 117, (196, 1), 37);
            Add_Action (Table.States (233), 118, (195, 6), 38);
            Table.States (233).Goto_List.Set_Capacity (32);
            Add_Goto (Table.States (233), 195, 176);
            Add_Goto (Table.States (233), 196, 148);
            Add_Goto (Table.States (233), 197, 54);
            Add_Goto (Table.States (233), 198, 55);
            Add_Goto (Table.States (233), 199, 56);
            Add_Goto (Table.States (233), 201, 57);
            Add_Goto (Table.States (233), 205, 177);
            Add_Goto (Table.States (233), 206, 178);
            Add_Goto (Table.States (233), 210, 179);
            Add_Goto (Table.States (233), 211, 180);
            Add_Goto (Table.States (233), 213, 181);
            Add_Goto (Table.States (233), 214, 182);
            Add_Goto (Table.States (233), 215, 183);
            Add_Goto (Table.States (233), 218, 184);
            Add_Goto (Table.States (233), 219, 185);
            Add_Goto (Table.States (233), 220, 186);
            Add_Goto (Table.States (233), 227, 236);
            Add_Goto (Table.States (233), 228, 188);
            Add_Goto (Table.States (233), 231, 189);
            Add_Goto (Table.States (233), 232, 190);
            Add_Goto (Table.States (233), 233, 191);
            Add_Goto (Table.States (233), 234, 192);
            Add_Goto (Table.States (233), 237, 193);
            Add_Goto (Table.States (233), 243, 449);
            Add_Goto (Table.States (233), 251, 58);
            Add_Goto (Table.States (233), 252, 59);
            Add_Goto (Table.States (233), 255, 60);
            Add_Goto (Table.States (233), 256, 194);
            Add_Goto (Table.States (233), 268, 68);
            Add_Goto (Table.States (233), 311, 83);
            Add_Goto (Table.States (233), 402, 195);
            Add_Goto (Table.States (233), 465, 196);
            Table.States (233).Kernel := To_Vector ((0 => ((289, 2),  63,  2, (32767, 0),  0)));
            Table.States (233).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (234).Action_List.Set_Capacity (50);
            Add_Action (Table.States (234), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (289, 3),  2);
            Table.States (234).Kernel := To_Vector ((0 => ((289, 3),  108,  0, (289, 3),  2)));
            Table.States (234).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (289, 3),  2)));
            Table.States (235).Action_List.Set_Capacity (6);
            Add_Action (Table.States (235), 63, (289, 0), 450);
            Add_Action (Table.States (235), 85, (198, 0), 281);
            Add_Action (Table.States (235), 96, (197, 0), 283);
            Add_Action (Table.States (235), 108, (289, 1), 451);
            Add_Action (Table.States (235), 113, (121, 0), 285);
            Add_Action (Table.States (235), 114, (121, 1), 286);
            Table.States (235).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (235), 121, 287);
            Add_Goto (Table.States (235), 313, 289);
            Table.States (235).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((289, 0),  195,  3, (32767, 0),  0), ((289, 1),  195,  1, (32767, 0),  0), ((311, 0),
            195,  3, (32767, 0),  0)));
            Table.States (235).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (289, 1),  108, 451)));
            Table.States (236).Action_List.Set_Capacity (6);
            Add_Action (Table.States (236), (36, 49, 50, 82, 99, 108), (243, 0),  1);
            Table.States (236).Kernel := To_Vector ((0 => ((243, 0),  227,  0, (243, 0),  1)));
            Table.States (236).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (243, 0),  1)));
            Table.States (237).Action_List.Set_Capacity (1);
            Add_Action (Table.States (237), (1 =>  36), (276, 0),  2);
            Table.States (237).Kernel := To_Vector ((0 => ((276, 0),  243,  0, (276, 0),  2)));
            Table.States (237).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (276, 0),  2)));
            Table.States (238).Action_List.Set_Capacity (25);
            Add_Action (Table.States (238), 12, (401, 0), 1);
            Add_Action (Table.States (238), 15, (370, 0), 3);
            Add_Action (Table.States (238), 17, (365, 0), 4);
            Add_Action (Table.States (238), 18, (382, 0), 5);
            Add_Action (Table.States (238), 19, (363, 0), 6);
            Add_Action (Table.States (238), 20, (357, 0), 7);
            Add_Action (Table.States (238), 30, (316, 0), 13);
            Add_Action (Table.States (238), 31, (290, 0), 14);
            Add_Action (Table.States (238), 32, (289, 0), 15);
            Add_Action (Table.States (238), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (238), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (238), 37, (288, 0), 17);
            Add_Conflict (Table.States (238), 37, (285, 1),  0);
            Add_Action (Table.States (238), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (238), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (238), 41, (271, 0), 18);
            Add_Action (Table.States (238), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (238), 64, (273, 0), 27);
            Add_Action (Table.States (238), 65, (264, 0), 28);
            Add_Action (Table.States (238), 84, (124, 0), 32);
            Add_Action (Table.States (238), 86, (252, 0), 33);
            Add_Action (Table.States (238), 90, (268, 0), 34);
            Add_Action (Table.States (238), 105, (265, 0), 35);
            Add_Action (Table.States (238), 116, (196, 0), 146);
            Add_Action (Table.States (238), 117, (196, 1), 37);
            Add_Action (Table.States (238), 118, (195, 6), 38);
            Table.States (238).Goto_List.Set_Capacity (46);
            Add_Goto (Table.States (238), 124, 39);
            Add_Goto (Table.States (238), 195, 52);
            Add_Goto (Table.States (238), 196, 53);
            Add_Goto (Table.States (238), 197, 54);
            Add_Goto (Table.States (238), 198, 55);
            Add_Goto (Table.States (238), 199, 56);
            Add_Goto (Table.States (238), 201, 57);
            Add_Goto (Table.States (238), 251, 58);
            Add_Goto (Table.States (238), 252, 59);
            Add_Goto (Table.States (238), 255, 60);
            Add_Goto (Table.States (238), 259, 452);
            Add_Goto (Table.States (238), 261, 331);
            Add_Goto (Table.States (238), 262, 62);
            Add_Goto (Table.States (238), 263, 63);
            Add_Goto (Table.States (238), 264, 64);
            Add_Goto (Table.States (238), 265, 65);
            Add_Goto (Table.States (238), 266, 66);
            Add_Goto (Table.States (238), 267, 67);
            Add_Goto (Table.States (238), 268, 68);
            Add_Goto (Table.States (238), 271, 69);
            Add_Goto (Table.States (238), 273, 70);
            Add_Goto (Table.States (238), 275, 71);
            Add_Goto (Table.States (238), 285, 72);
            Add_Goto (Table.States (238), 286, 73);
            Add_Goto (Table.States (238), 288, 74);
            Add_Goto (Table.States (238), 289, 75);
            Add_Goto (Table.States (238), 290, 76);
            Add_Goto (Table.States (238), 310, 82);
            Add_Goto (Table.States (238), 311, 83);
            Add_Goto (Table.States (238), 316, 84);
            Add_Goto (Table.States (238), 318, 85);
            Add_Goto (Table.States (238), 357, 110);
            Add_Goto (Table.States (238), 363, 111);
            Add_Goto (Table.States (238), 364, 112);
            Add_Goto (Table.States (238), 365, 113);
            Add_Goto (Table.States (238), 366, 114);
            Add_Goto (Table.States (238), 367, 115);
            Add_Goto (Table.States (238), 370, 116);
            Add_Goto (Table.States (238), 376, 117);
            Add_Goto (Table.States (238), 378, 118);
            Add_Goto (Table.States (238), 379, 119);
            Add_Goto (Table.States (238), 382, 120);
            Add_Goto (Table.States (238), 396, 453);
            Add_Goto (Table.States (238), 401, 133);
            Add_Goto (Table.States (238), 461, 332);
            Add_Goto (Table.States (238), 462, 144);
            Table.States (238).Kernel := To_Vector ((0 => ((288, 0),  33,  8, (32767, 0),  0)));
            Table.States (238).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (264, 0),  65, 28)));
            Table.States (239).Action_List.Set_Capacity (2);
            Add_Action (Table.States (239), 85, (283, 1), 246);
            Add_Action (Table.States (239), 116, (278, 0), 454);
            Table.States (239).Goto_List.Set_Capacity (5);
            Add_Goto (Table.States (239), 278, 455);
            Add_Goto (Table.States (239), 280, 456);
            Add_Goto (Table.States (239), 282, 457);
            Add_Goto (Table.States (239), 283, 253);
            Add_Goto (Table.States (239), 299, 254);
            Table.States (239).Kernel := To_Vector ((((276, 3),  51,  8, (32767, 0),  0), ((276, 6),  51,  3, (32767,
            0),  0), ((276, 8),  51,  3, (32767, 0),  0)));
            Table.States (239).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (278, 0),  116, 454)));
            Table.States (240).Action_List.Set_Capacity (13);
            Add_Action (Table.States (240), 44, (233, 2), 167);
            Add_Action (Table.States (240), 52, (233, 3), 168);
            Add_Action (Table.States (240), 65, (234, 1), 169);
            Add_Action (Table.States (240), 76, (256, 0), 170);
            Add_Action (Table.States (240), 85, (205, 4), 171);
            Add_Action (Table.States (240), 86, (213, 2), 172);
            Add_Action (Table.States (240), 90, (268, 0), 34);
            Add_Action (Table.States (240), 106, (237, 1), 173);
            Add_Action (Table.States (240), 107, (237, 0), 174);
            Add_Action (Table.States (240), 115, (234, 0), 175);
            Add_Action (Table.States (240), 116, (196, 0), 458);
            Add_Action (Table.States (240), 117, (196, 1), 37);
            Add_Action (Table.States (240), 118, (195, 6), 38);
            Table.States (240).Goto_List.Set_Capacity (29);
            Add_Goto (Table.States (240), 195, 176);
            Add_Goto (Table.States (240), 196, 148);
            Add_Goto (Table.States (240), 197, 54);
            Add_Goto (Table.States (240), 198, 55);
            Add_Goto (Table.States (240), 199, 56);
            Add_Goto (Table.States (240), 201, 57);
            Add_Goto (Table.States (240), 205, 177);
            Add_Goto (Table.States (240), 206, 178);
            Add_Goto (Table.States (240), 210, 179);
            Add_Goto (Table.States (240), 211, 180);
            Add_Goto (Table.States (240), 213, 181);
            Add_Goto (Table.States (240), 214, 182);
            Add_Goto (Table.States (240), 215, 183);
            Add_Goto (Table.States (240), 218, 184);
            Add_Goto (Table.States (240), 219, 185);
            Add_Goto (Table.States (240), 220, 186);
            Add_Goto (Table.States (240), 231, 459);
            Add_Goto (Table.States (240), 232, 190);
            Add_Goto (Table.States (240), 233, 191);
            Add_Goto (Table.States (240), 234, 192);
            Add_Goto (Table.States (240), 237, 193);
            Add_Goto (Table.States (240), 251, 58);
            Add_Goto (Table.States (240), 252, 59);
            Add_Goto (Table.States (240), 255, 60);
            Add_Goto (Table.States (240), 256, 194);
            Add_Goto (Table.States (240), 268, 68);
            Add_Goto (Table.States (240), 277, 460);
            Add_Goto (Table.States (240), 311, 83);
            Add_Goto (Table.States (240), 465, 196);
            Table.States (240).Kernel := To_Vector ((((276, 5),  85,  6, (32767, 0),  0), ((276, 7),  85,  6, (32767,
            0),  0)));
            Table.States (240).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
         end Subr_9;
         procedure Subr_10
         is begin
            Table.States (241).Action_List.Set_Capacity (1);
            Add_Action (Table.States (241), 49, (271, 0), 461);
            Table.States (241).Kernel := To_Vector ((((271, 0),  243,  14, (32767, 0),  0), ((271, 1),  243,  11,
            (32767, 0),  0), ((271, 2),  243,  9, (32767, 0),  0), ((271, 3),  243,  6, (32767, 0),  0)));
            Table.States (241).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (271, 0),  49, 461)));
            Table.States (242).Action_List.Set_Capacity (1);
            Add_Action (Table.States (242), 83, (333, 0), 462);
            Table.States (242).Kernel := To_Vector ((0 => ((333, 0),  55,  3, (32767, 0),  0)));
            Table.States (242).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (333, 0),  83, 462)));
            Table.States (243).Action_List.Set_Capacity (5);
            Add_Action (Table.States (243), 86, (252, 0), 33);
            Add_Action (Table.States (243), 90, (268, 0), 34);
            Add_Action (Table.States (243), 116, (196, 0), 146);
            Add_Action (Table.States (243), 117, (196, 1), 37);
            Add_Action (Table.States (243), 118, (195, 6), 38);
            Table.States (243).Goto_List.Set_Capacity (12);
            Add_Goto (Table.States (243), 195, 244);
            Add_Goto (Table.States (243), 196, 148);
            Add_Goto (Table.States (243), 197, 54);
            Add_Goto (Table.States (243), 198, 55);
            Add_Goto (Table.States (243), 199, 56);
            Add_Goto (Table.States (243), 201, 57);
            Add_Goto (Table.States (243), 251, 58);
            Add_Goto (Table.States (243), 252, 59);
            Add_Goto (Table.States (243), 255, 60);
            Add_Goto (Table.States (243), 268, 68);
            Add_Goto (Table.States (243), 311, 83);
            Add_Goto (Table.States (243), 331, 463);
            Table.States (243).Kernel := To_Vector ((0 => ((333, 1),  83,  2, (32767, 0),  0)));
            Table.States (243).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (244).Action_List.Set_Capacity (6);
            Add_Action (Table.States (244), 85, (198, 0), 281);
            Add_Action (Table.States (244), 95, Reduce, (331, 0),  1);
            Add_Action (Table.States (244), 96, (197, 0), 283);
            Add_Action (Table.States (244), 108, Reduce, (331, 0),  1);
            Add_Action (Table.States (244), 113, (121, 0), 285);
            Add_Action (Table.States (244), 114, (121, 1), 286);
            Table.States (244).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (244), 121, 287);
            Add_Goto (Table.States (244), 313, 289);
            Table.States (244).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((331, 0),  195,  0, (331, 0),  1)));
            Table.States (244).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (331, 0),  1)));
            Table.States (245).Action_List.Set_Capacity (2);
            Add_Action (Table.States (245), 95, (331, 1), 464);
            Add_Action (Table.States (245), 108, (332, 0), 465);
            Table.States (245).Kernel := To_Vector ((((331, 1),  331,  2, (32767, 0),  0), ((332, 0),  331,  1, (32767,
            0),  0)));
            Table.States (245).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (332, 0),  108, 465)));
            Table.States (246).Action_List.Set_Capacity (1);
            Add_Action (Table.States (246), 116, (136, 0), 207);
            Table.States (246).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (246), 136, 466);
            Add_Goto (Table.States (246), 298, 467);
            Add_Goto (Table.States (246), 300, 468);
            Table.States (246).Kernel := To_Vector ((((283, 1),  85,  2, (32767, 0),  0), ((299, 0),  85,  4, (32767,
            0),  0)));
            Table.States (246).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (136, 0),  116, 207)));
            Table.States (247).Action_List.Set_Capacity (8);
            Add_Action (Table.States (247), 45, (278, 0), 469);
            Add_Action (Table.States (247), 50, Reduce, (196, 0),  1);
            Add_Action (Table.States (247), 69, (280, 12), 470);
            Add_Action (Table.States (247), 85, Reduce, (196, 0),  1);
            Add_Action (Table.States (247), 93, (280, 0), 471);
            Add_Action (Table.States (247), 96, Reduce, (196, 0),  1);
            Add_Action (Table.States (247), 113, Reduce, (196, 0),  1);
            Add_Action (Table.States (247), 114, Reduce, (196, 0),  1);
            Table.States (247).Kernel := To_Vector ((((196, 0),  116,  0, (196, 0),  1), ((278, 0),  116,  5, (32767,
            0),  0), ((278, 1),  116,  3, (32767, 0),  0), ((278, 2),  116,  4, (32767, 0),  0), ((278, 3),  116,  2,
            (32767, 0),  0), ((280, 0),  116,  7, (32767, 0),  0), ((280, 1),  116,  5, (32767, 0),  0), ((280, 2),
            116,  6, (32767, 0),  0), ((280, 3),  116,  4, (32767, 0),  0), ((280, 4),  116,  5, (32767, 0),  0),
            ((280, 5),  116,  3, (32767, 0),  0), ((280, 6),  116,  4, (32767, 0),  0), ((280, 7),  116,  2, (32767,
            0),  0), ((280, 8),  116,  7, (32767, 0),  0), ((280, 9),  116,  5, (32767, 0),  0), ((280, 10),  116,  6,
            (32767, 0),  0), ((280, 11),  116,  4, (32767, 0),  0), ((280, 12),  116,  5, (32767, 0),  0), ((280, 13),
            116,  3, (32767, 0),  0), ((280, 14),  116,  4, (32767, 0),  0), ((280, 15),  116,  2, (32767, 0),  0)));
            Table.States (247).Minimal_Complete_Actions := To_Vector (((Reduce, (196, 0),  1), (Shift, (278, 0),  45,
            469), (Shift, (280, 12),  69, 470)));
            Table.States (248).Action_List.Set_Capacity (5);
            Add_Action (Table.States (248), 50, (438, 0), 472);
            Add_Action (Table.States (248), 85, (198, 0), 281);
            Add_Action (Table.States (248), 96, (197, 0), 283);
            Add_Action (Table.States (248), 113, (121, 0), 285);
            Add_Action (Table.States (248), 114, (121, 1), 286);
            Table.States (248).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (248), 121, 473);
            Add_Goto (Table.States (248), 313, 289);
            Table.States (248).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((437, 0),  195,  5, (32767, 0),  0), ((438, 0),
            195,  4, (32767, 0),  0), ((440, 0),  195,  18, (32767, 0),  0), ((440, 1),  195,  17, (32767, 0),  0),
            ((440, 2),  195,  10, (32767, 0),  0), ((440, 3),  195,  9, (32767, 0),  0), ((440, 4),  195,  14, (32767,
            0),  0), ((440, 5),  195,  13, (32767, 0),  0), ((440, 6),  195,  6, (32767, 0),  0), ((440, 7),  195,  5,
            (32767, 0),  0)));
            Table.States (248).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (438, 0),  50, 472)));
            Table.States (249).Action_List.Set_Capacity (5);
            Add_Action (Table.States (249), 50, (454, 0), 474);
            Add_Conflict (Table.States (249), 50, (195, 0),  1);
            Add_Action (Table.States (249), 85, Reduce, (195, 0),  1);
            Add_Action (Table.States (249), 96, Reduce, (195, 0),  1);
            Add_Action (Table.States (249), 113, Reduce, (195, 0),  1);
            Add_Action (Table.States (249), 114, Reduce, (195, 0),  1);
            Table.States (249).Kernel := To_Vector ((((195, 0),  196,  0, (195, 0),  1), ((454, 0),  196,  4, (32767,
            0),  0)));
            Table.States (249).Minimal_Complete_Actions := To_Vector (((Reduce, (195, 0),  1), (Shift, (454, 0),  50,
            474)));
            Table.States (250).Action_List.Set_Capacity (1);
            Add_Action (Table.States (250), (1 =>  36), (276, 1),  2);
            Table.States (250).Kernel := To_Vector ((0 => ((276, 1),  278,  0, (276, 1),  2)));
            Table.States (250).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (276, 1),  2)));
            Table.States (251).Action_List.Set_Capacity (1);
            Add_Action (Table.States (251), (1 =>  36), (276, 2),  2);
            Table.States (251).Kernel := To_Vector ((0 => ((276, 2),  280,  0, (276, 2),  2)));
            Table.States (251).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (276, 2),  2)));
            Table.States (252).Action_List.Set_Capacity (1);
            Add_Action (Table.States (252), (1 =>  36), (276, 4),  2);
            Table.States (252).Kernel := To_Vector ((0 => ((276, 4),  282,  0, (276, 4),  2)));
            Table.States (252).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (276, 4),  2)));
            Table.States (253).Action_List.Set_Capacity (1);
            Add_Action (Table.States (253), 69, (282, 0), 475);
            Table.States (253).Kernel := To_Vector ((((282, 0),  283,  7, (32767, 0),  0), ((282, 1),  283,  5, (32767,
            0),  0)));
            Table.States (253).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (282, 0),  69, 475)));
            Table.States (254).Action_List.Set_Capacity (1);
            Add_Action (Table.States (254), (1 =>  69), (283, 0),  1);
            Table.States (254).Kernel := To_Vector ((0 => ((283, 0),  299,  0, (283, 0),  1)));
            Table.States (254).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (283, 0),  1)));
            Table.States (255).Action_List.Set_Capacity (3);
            Add_Action (Table.States (255), (21, 53, 54), (329, 0),  2);
            Table.States (255).Kernel := To_Vector ((0 => ((329, 0),  25,  0, (329, 0),  2)));
            Table.States (255).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (329, 0),  2)));
            Table.States (256).Action_List.Set_Capacity (6);
            Add_Action (Table.States (256), 30, (296, 0), 476);
            Add_Action (Table.States (256), 82, (408, 8), 477);
            Add_Action (Table.States (256), 85, (198, 0), 478);
            Add_Action (Table.States (256), 96, (197, 0), 283);
            Add_Action (Table.States (256), 113, (121, 0), 285);
            Add_Action (Table.States (256), 114, (121, 1), 286);
            Table.States (256).Goto_List.Set_Capacity (5);
            Add_Goto (Table.States (256), 121, 287);
            Add_Goto (Table.States (256), 296, 479);
            Add_Goto (Table.States (256), 297, 480);
            Add_Goto (Table.States (256), 299, 481);
            Add_Goto (Table.States (256), 313, 289);
            Table.States (256).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((294, 0),  195,  2, (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((408, 8),
            195,  6, (32767, 0),  0), ((408, 9),  195,  4, (32767, 0),  0)));
            Table.States (256).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (296, 0),  30, 476)));
            Table.States (257).Action_List.Set_Capacity (8);
            Add_Action (Table.States (257), 24, Reduce, (295, 1),  0);
            Add_Action (Table.States (257), 61, Reduce, (295, 1),  0);
            Add_Action (Table.States (257), 82, (408, 4), 482);
            Add_Conflict (Table.States (257), 82, (295, 1),  0);
            Add_Action (Table.States (257), 85, (198, 0), 478);
            Add_Action (Table.States (257), 96, (197, 0), 283);
            Add_Action (Table.States (257), 108, Reduce, (295, 1),  0);
            Add_Action (Table.States (257), 113, (121, 0), 285);
            Add_Action (Table.States (257), 114, (121, 1), 286);
            Table.States (257).Goto_List.Set_Capacity (4);
            Add_Goto (Table.States (257), 121, 287);
            Add_Goto (Table.States (257), 295, 483);
            Add_Goto (Table.States (257), 299, 426);
            Add_Goto (Table.States (257), 313, 289);
            Table.States (257).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((293, 0),  195,  0, (295, 1),  0), ((311, 0),  195,  3, (32767, 0),  0), ((408, 4),  195,
             6, (32767, 0),  0), ((408, 5),  195,  4, (32767, 0),  0)));
            Table.States (257).Minimal_Complete_Actions := To_Vector (((Reduce, (295, 1),  0), (Shift, (408, 4),  82,
            482)));
            Table.States (258).Action_List.Set_Capacity (1);
            Add_Action (Table.States (258), 116, (354, 0), 484);
            Table.States (258).Kernel := To_Vector ((((354, 0),  26,  9, (32767, 0),  0), ((354, 1),  26,  6, (32767,
            0),  0), ((354, 2),  26,  7, (32767, 0),  0), ((354, 3),  26,  4, (32767, 0),  0), ((392, 0),  26,  6,
            (32767, 0),  0), ((392, 1),  26,  4, (32767, 0),  0)));
            Table.States (258).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (354, 0),  116, 484)));
            Table.States (259).Action_List.Set_Capacity (1);
            Add_Action (Table.States (259), 116, (346, 0), 485);
            Table.States (259).Kernel := To_Vector ((((346, 0),  83,  14, (32767, 0),  0), ((346, 1),  83,  11, (32767,
            0),  0), ((346, 2),  83,  12, (32767, 0),  0), ((346, 3),  83,  9, (32767, 0),  0), ((346, 4),  83,  9,
            (32767, 0),  0), ((346, 5),  83,  6, (32767, 0),  0), ((346, 6),  83,  7, (32767, 0),  0), ((346, 7),  83,
            4, (32767, 0),  0)));
            Table.States (259).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (346, 0),  116, 485)));
            Table.States (260).Action_List.Set_Capacity (2);
            Add_Action (Table.States (260), 61, (434, 0), 299);
            Add_Action (Table.States (260), 82, (347, 2), 486);
            Table.States (260).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (260), 434, 487);
            Table.States (260).Kernel := To_Vector ((((347, 0),  116,  8, (32767, 0),  0), ((347, 1),  116,  5, (32767,
            0),  0), ((347, 2),  116,  6, (32767, 0),  0), ((347, 3),  116,  3, (32767, 0),  0)));
            Table.States (260).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (347, 2),  82, 486)));
            Table.States (261).Action_List.Set_Capacity (1);
            Add_Action (Table.States (261), 116, (345, 0), 488);
            Table.States (261).Kernel := To_Vector ((((345, 0),  26,  9, (32767, 0),  0), ((345, 1),  26,  7, (32767,
            0),  0), ((391, 0),  26,  6, (32767, 0),  0), ((391, 1),  26,  4, (32767, 0),  0)));
            Table.States (261).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (345, 0),  116, 488)));
            Table.States (262).Action_List.Set_Capacity (1);
            Add_Action (Table.States (262), 116, (340, 0), 489);
            Table.States (262).Kernel := To_Vector ((((340, 0),  83,  17, (32767, 0),  0), ((340, 1),  83,  14, (32767,
            0),  0), ((340, 2),  83,  9, (32767, 0),  0), ((340, 3),  83,  15, (32767, 0),  0), ((340, 4),  83,  12,
            (32767, 0),  0), ((340, 5),  83,  7, (32767, 0),  0), ((340, 6),  83,  12, (32767, 0),  0), ((340, 7),  83,
             9, (32767, 0),  0), ((340, 8),  83,  4, (32767, 0),  0), ((340, 9),  83,  10, (32767, 0),  0), ((340, 10),
             83,  7, (32767, 0),  0), ((340, 11),  83,  2, (32767, 0),  0)));
            Table.States (262).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (340, 0),  116, 489)));
            Table.States (263).Action_List.Set_Capacity (3);
            Add_Action (Table.States (263), 61, (434, 0), 299);
            Add_Action (Table.States (263), 82, (341, 3), 490);
            Add_Action (Table.States (263), 108, (341, 5), 491);
            Table.States (263).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (263), 434, 492);
            Table.States (263).Kernel := To_Vector ((((341, 0),  116,  11, (32767, 0),  0), ((341, 1),  116,  8,
            (32767, 0),  0), ((341, 2),  116,  3, (32767, 0),  0), ((341, 3),  116,  9, (32767, 0),  0), ((341, 4),
            116,  6, (32767, 0),  0), ((341, 5),  116,  1, (32767, 0),  0)));
            Table.States (263).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (341, 5),  108, 491)));
            Table.States (264).Action_List.Set_Capacity (2);
            Add_Action (Table.States (264), 95, (331, 1), 464);
            Add_Action (Table.States (264), 108, (387, 1), 493);
            Table.States (264).Kernel := To_Vector ((((331, 1),  331,  2, (32767, 0),  0), ((387, 1),  331,  1, (32767,
            0),  0)));
            Table.States (264).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (387, 1),  108, 493)));
            Table.States (265).Action_List.Set_Capacity (1);
            Add_Action (Table.States (265), 82, (273, 0), 494);
            Table.States (265).Kernel := To_Vector ((0 => ((273, 0),  227,  9, (32767, 0),  0)));
            Table.States (265).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (273, 0),  82, 494)));
            Table.States (266).Action_List.Set_Capacity (50);
            Add_Action (Table.States (266), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (264, 0),  2);
            Table.States (266).Kernel := To_Vector ((0 => ((264, 0),  108,  0, (264, 0),  2)));
            Table.States (266).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (264, 0),  2)));
            Table.States (267).Action_List.Set_Capacity (1);
            Add_Action (Table.States (267), 61, (386, 0), 495);
            Table.States (267).Kernel := To_Vector ((0 => ((386, 0),  27,  3, (32767, 0),  0)));
            Table.States (267).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (386, 0),  61, 495)));
            Table.States (268).Action_List.Set_Capacity (5);
            Add_Action (Table.States (268), 86, (252, 0), 33);
            Add_Action (Table.States (268), 90, (268, 0), 34);
            Add_Action (Table.States (268), 116, (196, 0), 146);
            Add_Action (Table.States (268), 117, (196, 1), 37);
            Add_Action (Table.States (268), 118, (195, 6), 38);
            Table.States (268).Goto_List.Set_Capacity (12);
            Add_Goto (Table.States (268), 195, 244);
            Add_Goto (Table.States (268), 196, 148);
            Add_Goto (Table.States (268), 197, 54);
            Add_Goto (Table.States (268), 198, 55);
            Add_Goto (Table.States (268), 199, 56);
            Add_Goto (Table.States (268), 201, 57);
            Add_Goto (Table.States (268), 251, 58);
            Add_Goto (Table.States (268), 252, 59);
            Add_Goto (Table.States (268), 255, 60);
            Add_Goto (Table.States (268), 268, 68);
            Add_Goto (Table.States (268), 311, 83);
            Add_Goto (Table.States (268), 331, 496);
            Table.States (268).Kernel := To_Vector ((0 => ((386, 1),  61,  2, (32767, 0),  0)));
            Table.States (268).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (269).Action_List.Set_Capacity (1);
            Add_Action (Table.States (269), 82, (130, 0), 497);
            Table.States (269).Kernel := To_Vector ((((130, 0),  116,  5, (32767, 0),  0), ((130, 1),  116,  3, (32767,
            0),  0)));
            Table.States (269).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (130, 0),  82, 497)));
            Table.States (270).Action_List.Set_Capacity (3);
            Add_Action (Table.States (270), 82, (128, 2), 498);
            Add_Action (Table.States (270), 85, (165, 0), 499);
            Add_Action (Table.States (270), 108, (189, 3), 500);
            Table.States (270).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (270), 164, 501);
            Add_Goto (Table.States (270), 165, 502);
            Add_Goto (Table.States (270), 167, 503);
            Table.States (270).Kernel := To_Vector ((((128, 0),  116,  10, (32767, 0),  0), ((128, 1),  116,  8,
            (32767, 0),  0), ((128, 2),  116,  5, (32767, 0),  0), ((128, 3),  116,  3, (32767, 0),  0), ((189, 0),
            116,  6, (32767, 0),  0), ((189, 1),  116,  4, (32767, 0),  0), ((189, 2),  116,  3, (32767, 0),  0),
            ((189, 3),  116,  1, (32767, 0),  0), ((327, 0),  116,  11, (32767, 0),  0), ((327, 1),  116,  9, (32767,
            0),  0), ((327, 2),  116,  10, (32767, 0),  0), ((327, 3),  116,  8, (32767, 0),  0), ((327, 4),  116,  10,
            (32767, 0),  0), ((327, 5),  116,  8, (32767, 0),  0), ((327, 6),  116,  9, (32767, 0),  0), ((327, 7),
            116,  7, (32767, 0),  0), ((327, 8),  116,  9, (32767, 0),  0), ((327, 9),  116,  7, (32767, 0),  0),
            ((327, 10),  116,  8, (32767, 0),  0), ((327, 11),  116,  6, (32767, 0),  0), ((327, 12),  116,  8, (32767,
            0),  0), ((327, 13),  116,  6, (32767, 0),  0), ((327, 14),  116,  7, (32767, 0),  0), ((327, 15),  116,
            5, (32767, 0),  0), ((327, 16),  116,  7, (32767, 0),  0), ((327, 17),  116,  5, (32767, 0),  0), ((327,
            18),  116,  6, (32767, 0),  0), ((327, 19),  116,  4, (32767, 0),  0), ((327, 20),  116,  6, (32767, 0),
            0), ((327, 21),  116,  4, (32767, 0),  0), ((327, 22),  116,  5, (32767, 0),  0), ((327, 23),  116,  3,
            (32767, 0),  0), ((328, 0),  116,  15, (32767, 0),  0), ((328, 1),  116,  13, (32767, 0),  0), ((328, 2),
            116,  13, (32767, 0),  0), ((328, 3),  116,  11, (32767, 0),  0), ((328, 4),  116,  15, (32767, 0),  0),
            ((328, 5),  116,  13, (32767, 0),  0), ((328, 6),  116,  13, (32767, 0),  0), ((328, 7),  116,  11, (32767,
            0),  0), ((328, 8),  116,  14, (32767, 0),  0), ((328, 9),  116,  12, (32767, 0),  0), ((328, 10),  116,
            12, (32767, 0),  0), ((328, 11),  116,  10, (32767, 0),  0), ((328, 12),  116,  14, (32767, 0),  0), ((328,
            13),  116,  12, (32767, 0),  0), ((328, 14),  116,  12, (32767, 0),  0), ((328, 15),  116,  10, (32767, 0),
             0), ((328, 16),  116,  14, (32767, 0),  0), ((328, 17),  116,  12, (32767, 0),  0), ((328, 18),  116,  12,
            (32767, 0),  0), ((328, 19),  116,  10, (32767, 0),  0), ((328, 20),  116,  13, (32767, 0),  0), ((328,
            21),  116,  11, (32767, 0),  0), ((328, 22),  116,  11, (32767, 0),  0), ((328, 23),  116,  9, (32767, 0),
            0), ((328, 24),  116,  12, (32767, 0),  0), ((328, 25),  116,  10, (32767, 0),  0), ((328, 26),  116,  10,
            (32767, 0),  0), ((328, 27),  116,  8, (32767, 0),  0), ((328, 28),  116,  12, (32767, 0),  0), ((328, 29),
             116,  10, (32767, 0),  0), ((328, 30),  116,  10, (32767, 0),  0), ((328, 31),  116,  8, (32767, 0),  0),
            ((328, 32),  116,  11, (32767, 0),  0), ((328, 33),  116,  9, (32767, 0),  0), ((328, 34),  116,  9,
            (32767, 0),  0), ((328, 35),  116,  7, (32767, 0),  0), ((328, 36),  116,  11, (32767, 0),  0), ((328, 37),
             116,  9, (32767, 0),  0), ((328, 38),  116,  9, (32767, 0),  0), ((328, 39),  116,  7, (32767, 0),  0),
            ((328, 40),  116,  11, (32767, 0),  0), ((328, 41),  116,  9, (32767, 0),  0), ((328, 42),  116,  9,
            (32767, 0),  0), ((328, 43),  116,  7, (32767, 0),  0), ((328, 44),  116,  10, (32767, 0),  0), ((328, 45),
             116,  8, (32767, 0),  0), ((328, 46),  116,  8, (32767, 0),  0), ((328, 47),  116,  6, (32767, 0),  0)));
            Table.States (270).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (189, 3),  108, 500)));
            Table.States (271).Action_List.Set_Capacity (2);
            Add_Action (Table.States (271), 85, (124, 0), 504);
            Add_Action (Table.States (271), 108, (124, 1), 505);
            Table.States (271).Kernel := To_Vector ((((124, 0),  116,  4, (32767, 0),  0), ((124, 1),  116,  1, (32767,
            0),  0), ((124, 2),  116,  7, (32767, 0),  0), ((124, 3),  116,  1, (32767, 0),  0)));
            Table.States (271).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (124, 1),  108, 505)));
            Table.States (272).Action_List.Set_Capacity (2);
            Add_Action (Table.States (272), 51, (221, 0), 273);
            Add_Action (Table.States (272), 85, (252, 0), 506);
            Table.States (272).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (272), 221, 507);
            Table.States (272).Kernel := To_Vector ((((252, 0),  37,  10, (32767, 0),  0), ((252, 1),  37,  7, (32767,
            0),  0)));
            Table.States (272).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (221, 0),  51, 273)));
            Table.States (273).Action_List.Set_Capacity (1);
            Add_Action (Table.States (273), 116, (278, 0), 454);
            Table.States (273).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (273), 278, 508);
            Add_Goto (Table.States (273), 280, 509);
            Table.States (273).Kernel := To_Vector ((((221, 0),  51,  7, (32767, 0),  0), ((221, 1),  51,  5, (32767,
            0),  0), ((221, 2),  51,  7, (32767, 0),  0), ((221, 3),  51,  5, (32767, 0),  0)));
            Table.States (273).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (278, 0),  116, 454)));
            Table.States (274).Action_List.Set_Capacity (1);
            Add_Action (Table.States (274), 88, (252, 2), 510);
            Table.States (274).Kernel := To_Vector ((0 => ((252, 2),  221,  1, (32767, 0),  0)));
            Table.States (274).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (252, 2),  88, 510)));
            Table.States (275).Action_List.Set_Capacity (1);
            Add_Action (Table.States (275), (1 =>  102), (266, 0),  1);
            Table.States (275).Kernel := To_Vector ((0 => ((266, 0),  196,  0, (266, 0),  1)));
            Table.States (275).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (266, 0),  1)));
            Table.States (276).Action_List.Set_Capacity (1);
            Add_Action (Table.States (276), 102, (265, 0), 511);
            Table.States (276).Kernel := To_Vector ((0 => ((265, 0),  266,  1, (32767, 0),  0)));
            Table.States (276).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (265, 0),  102, 511)));
            Table.States (277).Action_List.Set_Capacity (5);
            Add_Action (Table.States (277), 86, (252, 0), 33);
            Add_Action (Table.States (277), 90, (268, 0), 34);
            Add_Action (Table.States (277), 116, (196, 0), 146);
            Add_Action (Table.States (277), 117, (196, 1), 37);
            Add_Action (Table.States (277), 118, (195, 6), 38);
            Table.States (277).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (277), 195, 512);
            Add_Goto (Table.States (277), 196, 148);
            Add_Goto (Table.States (277), 197, 54);
            Add_Goto (Table.States (277), 198, 55);
            Add_Goto (Table.States (277), 199, 56);
            Add_Goto (Table.States (277), 201, 57);
            Add_Goto (Table.States (277), 251, 58);
            Add_Goto (Table.States (277), 252, 59);
            Add_Goto (Table.States (277), 255, 60);
            Add_Goto (Table.States (277), 268, 68);
            Add_Goto (Table.States (277), 311, 83);
            Table.States (277).Kernel := To_Vector ((((335, 4),  24,  4, (32767, 0),  0), ((335, 5),  24,  2, (32767,
            0),  0)));
            Table.States (277).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (278).Action_List.Set_Capacity (8);
            Add_Action (Table.States (278), 23, (336, 0), 513);
            Add_Action (Table.States (278), 52, (187, 0), 347);
            Add_Action (Table.States (278), 56, (188, 2), 514);
            Add_Action (Table.States (278), 86, (252, 0), 33);
            Add_Action (Table.States (278), 90, (268, 0), 34);
            Add_Action (Table.States (278), 116, (196, 0), 146);
            Add_Action (Table.States (278), 117, (196, 1), 37);
            Add_Action (Table.States (278), 118, (195, 6), 38);
            Table.States (278).Goto_List.Set_Capacity (13);
            Add_Goto (Table.States (278), 187, 515);
            Add_Goto (Table.States (278), 188, 516);
            Add_Goto (Table.States (278), 195, 517);
            Add_Goto (Table.States (278), 196, 148);
            Add_Goto (Table.States (278), 197, 54);
            Add_Goto (Table.States (278), 198, 55);
            Add_Goto (Table.States (278), 199, 56);
            Add_Goto (Table.States (278), 201, 57);
            Add_Goto (Table.States (278), 251, 58);
            Add_Goto (Table.States (278), 252, 59);
            Add_Goto (Table.States (278), 255, 60);
            Add_Goto (Table.States (278), 268, 68);
            Add_Goto (Table.States (278), 311, 83);
            Table.States (278).Kernel := To_Vector ((((335, 0),  93,  8, (32767, 0),  0), ((335, 1),  93,  6, (32767,
            0),  0), ((335, 2),  93,  6, (32767, 0),  0), ((335, 3),  93,  4, (32767, 0),  0), ((335, 6),  93,  7,
            (32767, 0),  0), ((335, 7),  93,  5, (32767, 0),  0), ((336, 0),  93,  6, (32767, 0),  0), ((336, 1),  93,
            4, (32767, 0),  0)));
            Table.States (278).Minimal_Complete_Actions := To_Vector (((Shift, (196, 0),  116, 146), (Shift, (336, 0),
            23, 513)));
            Table.States (279).Action_List.Set_Capacity (11);
            Add_Action (Table.States (279), 23, (394, 0), 518);
            Add_Action (Table.States (279), 52, (187, 0), 347);
            Add_Action (Table.States (279), 56, (188, 2), 514);
            Add_Action (Table.States (279), 70, (156, 0), 519);
            Add_Action (Table.States (279), 79, (135, 8), 520);
            Add_Action (Table.States (279), 80, (135, 0), 521);
            Add_Action (Table.States (279), 86, (252, 0), 33);
            Add_Action (Table.States (279), 90, (268, 0), 34);
            Add_Action (Table.States (279), 116, (196, 0), 146);
            Add_Action (Table.States (279), 117, (196, 1), 37);
            Add_Action (Table.States (279), 118, (195, 6), 38);
            Table.States (279).Goto_List.Set_Capacity (17);
            Add_Goto (Table.States (279), 131, 522);
            Add_Goto (Table.States (279), 154, 523);
            Add_Goto (Table.States (279), 156, 524);
            Add_Goto (Table.States (279), 159, 525);
            Add_Goto (Table.States (279), 187, 526);
            Add_Goto (Table.States (279), 188, 527);
            Add_Goto (Table.States (279), 195, 528);
            Add_Goto (Table.States (279), 196, 148);
            Add_Goto (Table.States (279), 197, 54);
            Add_Goto (Table.States (279), 198, 55);
            Add_Goto (Table.States (279), 199, 56);
            Add_Goto (Table.States (279), 201, 57);
            Add_Goto (Table.States (279), 251, 58);
            Add_Goto (Table.States (279), 252, 59);
            Add_Goto (Table.States (279), 255, 60);
            Add_Goto (Table.States (279), 268, 68);
            Add_Goto (Table.States (279), 311, 83);
            Table.States (279).Kernel := To_Vector ((((135, 0),  93,  8, (32767, 0),  0), ((135, 1),  93,  6, (32767,
            0),  0), ((135, 2),  93,  6, (32767, 0),  0), ((135, 3),  93,  4, (32767, 0),  0), ((135, 4),  93,  7,
            (32767, 0),  0), ((135, 5),  93,  5, (32767, 0),  0), ((135, 6),  93,  5, (32767, 0),  0), ((135, 7),  93,
            3, (32767, 0),  0), ((135, 8),  93,  7, (32767, 0),  0), ((135, 9),  93,  5, (32767, 0),  0), ((135, 10),
            93,  5, (32767, 0),  0), ((135, 11),  93,  3, (32767, 0),  0), ((135, 12),  93,  6, (32767, 0),  0), ((135,
            13),  93,  4, (32767, 0),  0), ((135, 14),  93,  4, (32767, 0),  0), ((135, 15),  93,  2, (32767, 0),  0),
            ((135, 16),  93,  9, (32767, 0),  0), ((135, 17),  93,  7, (32767, 0),  0), ((135, 18),  93,  7, (32767,
            0),  0), ((135, 19),  93,  5, (32767, 0),  0), ((135, 20),  93,  8, (32767, 0),  0), ((135, 21),  93,  6,
            (32767, 0),  0), ((135, 22),  93,  6, (32767, 0),  0), ((135, 23),  93,  4, (32767, 0),  0), ((135, 24),
            93,  8, (32767, 0),  0), ((135, 25),  93,  6, (32767, 0),  0), ((135, 26),  93,  6, (32767, 0),  0), ((135,
            27),  93,  4, (32767, 0),  0), ((135, 28),  93,  7, (32767, 0),  0), ((135, 29),  93,  5, (32767, 0),  0),
            ((135, 30),  93,  5, (32767, 0),  0), ((135, 31),  93,  3, (32767, 0),  0), ((135, 32),  93,  14, (32767,
            0),  0), ((135, 33),  93,  12, (32767, 0),  0), ((135, 34),  93,  12, (32767, 0),  0), ((135, 35),  93,
            10, (32767, 0),  0), ((135, 36),  93,  13, (32767, 0),  0), ((135, 37),  93,  11, (32767, 0),  0), ((135,
            38),  93,  11, (32767, 0),  0), ((135, 39),  93,  9, (32767, 0),  0), ((135, 40),  93,  13, (32767, 0),
            0), ((135, 41),  93,  11, (32767, 0),  0), ((135, 42),  93,  11, (32767, 0),  0), ((135, 43),  93,  9,
            (32767, 0),  0), ((135, 44),  93,  12, (32767, 0),  0), ((135, 45),  93,  10, (32767, 0),  0), ((135, 46),
            93,  10, (32767, 0),  0), ((135, 47),  93,  8, (32767, 0),  0), ((137, 0),  93,  4, (32767, 0),  0), ((394,
            0),  93,  4, (32767, 0),  0), ((394, 1),  93,  2, (32767, 0),  0)));
            Table.States (279).Minimal_Complete_Actions := To_Vector (((Shift, (196, 0),  116, 146), (Shift, (394, 0),
            23, 518)));
         end Subr_10;
         procedure Subr_11
         is begin
            Table.States (280).Action_List.Set_Capacity (1);
            Add_Action (Table.States (280), 116, (136, 1), 529);
            Table.States (280).Kernel := To_Vector ((0 => ((136, 1),  95,  1, (32767, 0),  0)));
            Table.States (280).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (136, 1),  116, 529)));
            Table.States (281).Action_List.Set_Capacity (20);
            Add_Action (Table.States (281), 12, (402, 0), 165);
            Add_Action (Table.States (281), 39, (249, 0), 353);
            Add_Action (Table.States (281), 41, (242, 0), 354);
            Add_Action (Table.States (281), 44, (233, 2), 167);
            Add_Action (Table.States (281), 51, (247, 0), 530);
            Add_Action (Table.States (281), 52, (187, 0), 356);
            Add_Action (Table.States (281), 62, (200, 2), 531);
            Add_Action (Table.States (281), 64, (245, 0), 358);
            Add_Action (Table.States (281), 65, (234, 1), 169);
            Add_Action (Table.States (281), 76, (256, 0), 170);
            Add_Action (Table.States (281), 85, (205, 4), 171);
            Add_Action (Table.States (281), 86, (213, 2), 172);
            Add_Action (Table.States (281), 90, (268, 0), 34);
            Add_Action (Table.States (281), 92, (315, 2), 532);
            Add_Action (Table.States (281), 106, (237, 1), 173);
            Add_Action (Table.States (281), 107, (237, 0), 174);
            Add_Action (Table.States (281), 115, (234, 0), 175);
            Add_Action (Table.States (281), 116, (196, 0), 146);
            Add_Action (Table.States (281), 117, (196, 1), 37);
            Add_Action (Table.States (281), 118, (195, 6), 360);
            Table.States (281).Goto_List.Set_Capacity (45);
            Add_Goto (Table.States (281), 131, 533);
            Add_Goto (Table.States (281), 140, 534);
            Add_Goto (Table.States (281), 163, 535);
            Add_Goto (Table.States (281), 187, 365);
            Add_Goto (Table.States (281), 195, 366);
            Add_Goto (Table.States (281), 196, 367);
            Add_Goto (Table.States (281), 197, 54);
            Add_Goto (Table.States (281), 198, 55);
            Add_Goto (Table.States (281), 199, 56);
            Add_Goto (Table.States (281), 200, 368);
            Add_Goto (Table.States (281), 201, 57);
            Add_Goto (Table.States (281), 203, 369);
            Add_Goto (Table.States (281), 205, 177);
            Add_Goto (Table.States (281), 206, 178);
            Add_Goto (Table.States (281), 209, 536);
            Add_Goto (Table.States (281), 210, 179);
            Add_Goto (Table.States (281), 211, 180);
            Add_Goto (Table.States (281), 213, 181);
            Add_Goto (Table.States (281), 214, 182);
            Add_Goto (Table.States (281), 215, 183);
            Add_Goto (Table.States (281), 218, 184);
            Add_Goto (Table.States (281), 219, 185);
            Add_Goto (Table.States (281), 220, 186);
            Add_Goto (Table.States (281), 227, 537);
            Add_Goto (Table.States (281), 228, 188);
            Add_Goto (Table.States (281), 231, 378);
            Add_Goto (Table.States (281), 232, 190);
            Add_Goto (Table.States (281), 233, 191);
            Add_Goto (Table.States (281), 234, 192);
            Add_Goto (Table.States (281), 237, 193);
            Add_Goto (Table.States (281), 239, 538);
            Add_Goto (Table.States (281), 242, 380);
            Add_Goto (Table.States (281), 245, 381);
            Add_Goto (Table.States (281), 247, 539);
            Add_Goto (Table.States (281), 249, 540);
            Add_Goto (Table.States (281), 251, 58);
            Add_Goto (Table.States (281), 252, 59);
            Add_Goto (Table.States (281), 255, 60);
            Add_Goto (Table.States (281), 256, 194);
            Add_Goto (Table.States (281), 268, 68);
            Add_Goto (Table.States (281), 311, 83);
            Add_Goto (Table.States (281), 312, 541);
            Add_Goto (Table.States (281), 315, 542);
            Add_Goto (Table.States (281), 402, 195);
            Add_Goto (Table.States (281), 465, 196);
            Table.States (281).Kernel := To_Vector ((((198, 0),  85,  2, (32767, 0),  0), ((313, 0),  85,  2, (32767,
            0),  0), ((313, 1),  85,  5, (32767, 0),  0), ((313, 2),  85,  8, (32767, 0),  0), ((313, 3),  85,  4,
            (32767, 0),  0)));
            Table.States (281).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (282).Action_List.Set_Capacity (14);
            Add_Action (Table.States (282), 12, (402, 0), 165);
            Add_Action (Table.States (282), 44, (233, 2), 167);
            Add_Action (Table.States (282), 52, (233, 3), 168);
            Add_Action (Table.States (282), 65, (234, 1), 169);
            Add_Action (Table.States (282), 76, (256, 0), 170);
            Add_Action (Table.States (282), 85, (205, 4), 171);
            Add_Action (Table.States (282), 86, (213, 2), 172);
            Add_Action (Table.States (282), 90, (268, 0), 34);
            Add_Action (Table.States (282), 106, (237, 1), 173);
            Add_Action (Table.States (282), 107, (237, 0), 174);
            Add_Action (Table.States (282), 115, (234, 0), 175);
            Add_Action (Table.States (282), 116, (196, 0), 146);
            Add_Action (Table.States (282), 117, (196, 1), 37);
            Add_Action (Table.States (282), 118, (195, 6), 38);
            Table.States (282).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (282), 195, 176);
            Add_Goto (Table.States (282), 196, 148);
            Add_Goto (Table.States (282), 197, 54);
            Add_Goto (Table.States (282), 198, 55);
            Add_Goto (Table.States (282), 199, 56);
            Add_Goto (Table.States (282), 201, 57);
            Add_Goto (Table.States (282), 205, 177);
            Add_Goto (Table.States (282), 206, 178);
            Add_Goto (Table.States (282), 210, 179);
            Add_Goto (Table.States (282), 211, 180);
            Add_Goto (Table.States (282), 213, 181);
            Add_Goto (Table.States (282), 214, 182);
            Add_Goto (Table.States (282), 215, 183);
            Add_Goto (Table.States (282), 218, 184);
            Add_Goto (Table.States (282), 219, 185);
            Add_Goto (Table.States (282), 220, 186);
            Add_Goto (Table.States (282), 227, 543);
            Add_Goto (Table.States (282), 228, 188);
            Add_Goto (Table.States (282), 231, 189);
            Add_Goto (Table.States (282), 232, 190);
            Add_Goto (Table.States (282), 233, 191);
            Add_Goto (Table.States (282), 234, 192);
            Add_Goto (Table.States (282), 237, 193);
            Add_Goto (Table.States (282), 251, 58);
            Add_Goto (Table.States (282), 252, 59);
            Add_Goto (Table.States (282), 255, 60);
            Add_Goto (Table.States (282), 256, 194);
            Add_Goto (Table.States (282), 268, 68);
            Add_Goto (Table.States (282), 311, 83);
            Add_Goto (Table.States (282), 402, 195);
            Add_Goto (Table.States (282), 465, 196);
            Table.States (282).Kernel := To_Vector ((0 => ((134, 0),  94,  1, (32767, 0),  0)));
            Table.States (282).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (283).Action_List.Set_Capacity (5);
            Add_Action (Table.States (283), 55, (197, 0), 544);
            Add_Action (Table.States (283), 62, (200, 2), 531);
            Add_Action (Table.States (283), 116, (196, 0), 146);
            Add_Action (Table.States (283), 117, (196, 1), 37);
            Add_Action (Table.States (283), 118, (200, 1), 545);
            Table.States (283).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (283), 196, 546);
            Add_Goto (Table.States (283), 200, 547);
            Table.States (283).Kernel := To_Vector ((((197, 0),  96,  1, (32767, 0),  0), ((199, 0),  96,  1, (32767,
            0),  0)));
            Table.States (284).Action_List.Set_Capacity (50);
            Add_Action (Table.States (284), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (310, 0),  2);
            Table.States (284).Kernel := To_Vector ((0 => ((310, 0),  108,  0, (310, 0),  2)));
            Table.States (284).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (310, 0),  2)));
            Table.States (285).Action_List.Set_Capacity (8);
            Add_Action (Table.States (285), (56, 71, 72, 73, 74, 85, 86, 116), (121, 0),  1);
            Table.States (285).Kernel := To_Vector ((0 => ((121, 0),  113,  0, (121, 0),  1)));
            Table.States (285).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (121, 0),  1)));
            Table.States (286).Action_List.Set_Capacity (8);
            Add_Action (Table.States (286), (56, 71, 72, 73, 74, 85, 86, 116), (121, 1),  1);
            Table.States (286).Kernel := To_Vector ((0 => ((121, 1),  114,  0, (121, 1),  1)));
            Table.States (286).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (121, 1),  1)));
            Table.States (287).Action_List.Set_Capacity (7);
            Add_Action (Table.States (287), 56, (202, 1), 548);
            Add_Action (Table.States (287), 71, (202, 2), 549);
            Add_Action (Table.States (287), 72, (202, 3), 550);
            Add_Action (Table.States (287), 73, (202, 4), 551);
            Add_Action (Table.States (287), 85, (205, 4), 171);
            Add_Action (Table.States (287), 86, (213, 2), 552);
            Add_Action (Table.States (287), 116, (202, 0), 553);
            Table.States (287).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (287), 202, 554);
            Add_Goto (Table.States (287), 205, 555);
            Add_Goto (Table.States (287), 206, 178);
            Add_Goto (Table.States (287), 210, 179);
            Add_Goto (Table.States (287), 211, 180);
            Add_Goto (Table.States (287), 213, 181);
            Add_Goto (Table.States (287), 214, 182);
            Add_Goto (Table.States (287), 215, 183);
            Add_Goto (Table.States (287), 218, 184);
            Add_Goto (Table.States (287), 219, 185);
            Add_Goto (Table.States (287), 220, 186);
            Table.States (287).Kernel := To_Vector ((((201, 0),  121,  1, (32767, 0),  0), ((255, 0),  121,  2, (32767,
            0),  0)));
            Table.States (288).Action_List.Set_Capacity (1);
            Add_Action (Table.States (288), 108, (267, 0), 556);
            Table.States (288).Kernel := To_Vector ((0 => ((267, 0),  134,  1, (32767, 0),  0)));
            Table.States (288).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (267, 0),  108, 556)));
            Table.States (289).Action_List.Set_Capacity (47);
            Add_Action (Table.States (289), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (311, 0),  2);
            Table.States (289).Kernel := To_Vector ((0 => ((311, 0),  313,  0, (311, 0),  2)));
            Table.States (289).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (311, 0),  2)));
            Table.States (290).Action_List.Set_Capacity (1);
            Add_Action (Table.States (290), 116, (253, 0), 557);
            Table.States (290).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (290), 253, 558);
            Table.States (290).Kernel := To_Vector ((0 => ((251, 0),  121,  6, (32767, 0),  0)));
            Table.States (290).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (253, 0),  116, 557)));
            Table.States (291).Action_List.Set_Capacity (6);
            Add_Action (Table.States (291), (35, 36, 37, 38, 39, 51), (285, 0),  2);
            Table.States (291).Kernel := To_Vector ((0 => ((285, 0),  93,  0, (285, 0),  2)));
            Table.States (291).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (285, 0),  2)));
            Table.States (292).Action_List.Set_Capacity (25);
            Add_Action (Table.States (292), 12, (401, 0), 1);
            Add_Action (Table.States (292), 15, (370, 0), 3);
            Add_Action (Table.States (292), 17, (365, 0), 4);
            Add_Action (Table.States (292), 18, (382, 0), 5);
            Add_Action (Table.States (292), 19, (363, 0), 6);
            Add_Action (Table.States (292), 20, (357, 0), 7);
            Add_Action (Table.States (292), 30, (316, 0), 13);
            Add_Action (Table.States (292), 31, (290, 0), 14);
            Add_Action (Table.States (292), 32, (289, 0), 15);
            Add_Action (Table.States (292), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (292), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (292), 37, (288, 0), 17);
            Add_Conflict (Table.States (292), 37, (285, 1),  0);
            Add_Action (Table.States (292), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (292), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (292), 41, (271, 0), 18);
            Add_Action (Table.States (292), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (292), 64, (273, 0), 27);
            Add_Action (Table.States (292), 65, (264, 0), 28);
            Add_Action (Table.States (292), 84, (124, 0), 32);
            Add_Action (Table.States (292), 86, (252, 0), 33);
            Add_Action (Table.States (292), 90, (268, 0), 34);
            Add_Action (Table.States (292), 105, (265, 0), 35);
            Add_Action (Table.States (292), 116, (196, 0), 146);
            Add_Action (Table.States (292), 117, (196, 1), 37);
            Add_Action (Table.States (292), 118, (195, 6), 38);
            Table.States (292).Goto_List.Set_Capacity (45);
            Add_Goto (Table.States (292), 124, 39);
            Add_Goto (Table.States (292), 195, 52);
            Add_Goto (Table.States (292), 196, 53);
            Add_Goto (Table.States (292), 197, 54);
            Add_Goto (Table.States (292), 198, 55);
            Add_Goto (Table.States (292), 199, 56);
            Add_Goto (Table.States (292), 201, 57);
            Add_Goto (Table.States (292), 251, 58);
            Add_Goto (Table.States (292), 252, 59);
            Add_Goto (Table.States (292), 255, 60);
            Add_Goto (Table.States (292), 259, 559);
            Add_Goto (Table.States (292), 261, 331);
            Add_Goto (Table.States (292), 262, 62);
            Add_Goto (Table.States (292), 263, 63);
            Add_Goto (Table.States (292), 264, 64);
            Add_Goto (Table.States (292), 265, 65);
            Add_Goto (Table.States (292), 266, 66);
            Add_Goto (Table.States (292), 267, 67);
            Add_Goto (Table.States (292), 268, 68);
            Add_Goto (Table.States (292), 271, 69);
            Add_Goto (Table.States (292), 273, 70);
            Add_Goto (Table.States (292), 275, 71);
            Add_Goto (Table.States (292), 285, 72);
            Add_Goto (Table.States (292), 286, 73);
            Add_Goto (Table.States (292), 288, 74);
            Add_Goto (Table.States (292), 289, 75);
            Add_Goto (Table.States (292), 290, 76);
            Add_Goto (Table.States (292), 310, 82);
            Add_Goto (Table.States (292), 311, 83);
            Add_Goto (Table.States (292), 316, 84);
            Add_Goto (Table.States (292), 318, 85);
            Add_Goto (Table.States (292), 357, 110);
            Add_Goto (Table.States (292), 363, 111);
            Add_Goto (Table.States (292), 364, 112);
            Add_Goto (Table.States (292), 365, 113);
            Add_Goto (Table.States (292), 366, 114);
            Add_Goto (Table.States (292), 367, 115);
            Add_Goto (Table.States (292), 370, 116);
            Add_Goto (Table.States (292), 376, 117);
            Add_Goto (Table.States (292), 378, 118);
            Add_Goto (Table.States (292), 379, 119);
            Add_Goto (Table.States (292), 382, 120);
            Add_Goto (Table.States (292), 401, 133);
            Add_Goto (Table.States (292), 461, 332);
            Add_Goto (Table.States (292), 462, 144);
            Table.States (292).Kernel := To_Vector ((0 => ((275, 1),  36,  5, (32767, 0),  0)));
            Table.States (292).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (264, 0),  65, 28)));
            Table.States (293).Action_List.Set_Capacity (2);
            Add_Action (Table.States (293), 51, (276, 3), 239);
            Add_Action (Table.States (293), 85, (276, 5), 240);
            Table.States (293).Kernel := To_Vector ((((276, 3),  37,  9, (32767, 0),  0), ((276, 5),  37,  7, (32767,
            0),  0), ((276, 6),  37,  4, (32767, 0),  0), ((276, 7),  37,  7, (32767, 0),  0), ((276, 8),  37,  4,
            (32767, 0),  0)));
            Table.States (293).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (276, 3),  51, 239)));
            Table.States (294).Action_List.Set_Capacity (25);
            Add_Action (Table.States (294), 12, (401, 0), 1);
            Add_Action (Table.States (294), 15, (370, 0), 3);
            Add_Action (Table.States (294), 17, (365, 0), 4);
            Add_Action (Table.States (294), 18, (382, 0), 5);
            Add_Action (Table.States (294), 19, (363, 0), 6);
            Add_Action (Table.States (294), 20, (357, 0), 7);
            Add_Action (Table.States (294), 30, (316, 0), 13);
            Add_Action (Table.States (294), 31, (290, 0), 14);
            Add_Action (Table.States (294), 32, (289, 0), 15);
            Add_Action (Table.States (294), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (294), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (294), 37, (288, 0), 17);
            Add_Conflict (Table.States (294), 37, (285, 1),  0);
            Add_Action (Table.States (294), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (294), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (294), 41, (271, 0), 18);
            Add_Action (Table.States (294), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (294), 64, (273, 0), 27);
            Add_Action (Table.States (294), 65, (264, 0), 28);
            Add_Action (Table.States (294), 84, (124, 0), 32);
            Add_Action (Table.States (294), 86, (252, 0), 33);
            Add_Action (Table.States (294), 90, (268, 0), 34);
            Add_Action (Table.States (294), 105, (265, 0), 35);
            Add_Action (Table.States (294), 116, (196, 0), 146);
            Add_Action (Table.States (294), 117, (196, 1), 37);
            Add_Action (Table.States (294), 118, (195, 6), 38);
            Table.States (294).Goto_List.Set_Capacity (46);
            Add_Goto (Table.States (294), 124, 39);
            Add_Goto (Table.States (294), 195, 52);
            Add_Goto (Table.States (294), 196, 53);
            Add_Goto (Table.States (294), 197, 54);
            Add_Goto (Table.States (294), 198, 55);
            Add_Goto (Table.States (294), 199, 56);
            Add_Goto (Table.States (294), 201, 57);
            Add_Goto (Table.States (294), 251, 58);
            Add_Goto (Table.States (294), 252, 59);
            Add_Goto (Table.States (294), 255, 60);
            Add_Goto (Table.States (294), 259, 452);
            Add_Goto (Table.States (294), 261, 331);
            Add_Goto (Table.States (294), 262, 62);
            Add_Goto (Table.States (294), 263, 63);
            Add_Goto (Table.States (294), 264, 64);
            Add_Goto (Table.States (294), 265, 65);
            Add_Goto (Table.States (294), 266, 66);
            Add_Goto (Table.States (294), 267, 67);
            Add_Goto (Table.States (294), 268, 68);
            Add_Goto (Table.States (294), 271, 69);
            Add_Goto (Table.States (294), 273, 70);
            Add_Goto (Table.States (294), 275, 71);
            Add_Goto (Table.States (294), 285, 72);
            Add_Goto (Table.States (294), 286, 73);
            Add_Goto (Table.States (294), 288, 74);
            Add_Goto (Table.States (294), 289, 75);
            Add_Goto (Table.States (294), 290, 76);
            Add_Goto (Table.States (294), 310, 82);
            Add_Goto (Table.States (294), 311, 83);
            Add_Goto (Table.States (294), 316, 84);
            Add_Goto (Table.States (294), 318, 85);
            Add_Goto (Table.States (294), 357, 110);
            Add_Goto (Table.States (294), 363, 111);
            Add_Goto (Table.States (294), 364, 112);
            Add_Goto (Table.States (294), 365, 113);
            Add_Goto (Table.States (294), 366, 114);
            Add_Goto (Table.States (294), 367, 115);
            Add_Goto (Table.States (294), 370, 116);
            Add_Goto (Table.States (294), 376, 117);
            Add_Goto (Table.States (294), 378, 118);
            Add_Goto (Table.States (294), 379, 119);
            Add_Goto (Table.States (294), 382, 120);
            Add_Goto (Table.States (294), 396, 560);
            Add_Goto (Table.States (294), 401, 133);
            Add_Goto (Table.States (294), 461, 332);
            Add_Goto (Table.States (294), 462, 144);
            Table.States (294).Kernel := To_Vector ((0 => ((286, 1),  38,  4, (32767, 0),  0)));
            Table.States (294).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (264, 0),  65, 28)));
            Table.States (295).Action_List.Set_Capacity (15);
            Add_Action (Table.States (295), 22, (339, 0), 9);
            Add_Action (Table.States (295), 25, (329, 1), 10);
            Add_Action (Table.States (295), 28, (325, 0), 12);
            Add_Action (Table.States (295), 38, Reduce, (192, 1),  0);
            Add_Action (Table.States (295), 50, (332, 0), 19);
            Add_Action (Table.States (295), 51, (437, 0), 221);
            Add_Action (Table.States (295), 52, (329, 0), 21);
            Add_Action (Table.States (295), 53, (294, 0), 22);
            Add_Action (Table.States (295), 54, (293, 0), 23);
            Add_Action (Table.States (295), 59, (346, 0), 24);
            Add_Action (Table.States (295), 60, (340, 0), 25);
            Add_Action (Table.States (295), 81, (130, 0), 30);
            Add_Action (Table.States (295), 83, (128, 0), 31);
            Add_Action (Table.States (295), 84, (124, 0), 32);
            Add_Action (Table.States (295), 116, (136, 0), 223);
            Table.States (295).Goto_List.Set_Capacity (60);
            Add_Goto (Table.States (295), 124, 561);
            Add_Goto (Table.States (295), 126, 40);
            Add_Goto (Table.States (295), 127, 41);
            Add_Goto (Table.States (295), 128, 42);
            Add_Goto (Table.States (295), 130, 43);
            Add_Goto (Table.States (295), 135, 44);
            Add_Goto (Table.States (295), 136, 45);
            Add_Goto (Table.States (295), 137, 46);
            Add_Goto (Table.States (295), 180, 47);
            Add_Goto (Table.States (295), 189, 48);
            Add_Goto (Table.States (295), 190, 562);
            Add_Goto (Table.States (295), 191, 563);
            Add_Goto (Table.States (295), 192, 564);
            Add_Goto (Table.States (295), 193, 50);
            Add_Goto (Table.States (295), 194, 51);
            Add_Goto (Table.States (295), 291, 77);
            Add_Goto (Table.States (295), 292, 78);
            Add_Goto (Table.States (295), 293, 79);
            Add_Goto (Table.States (295), 294, 80);
            Add_Goto (Table.States (295), 309, 81);
            Add_Goto (Table.States (295), 320, 86);
            Add_Goto (Table.States (295), 321, 87);
            Add_Goto (Table.States (295), 322, 88);
            Add_Goto (Table.States (295), 325, 89);
            Add_Goto (Table.States (295), 326, 90);
            Add_Goto (Table.States (295), 327, 91);
            Add_Goto (Table.States (295), 328, 92);
            Add_Goto (Table.States (295), 329, 225);
            Add_Goto (Table.States (295), 330, 94);
            Add_Goto (Table.States (295), 332, 95);
            Add_Goto (Table.States (295), 333, 96);
            Add_Goto (Table.States (295), 334, 97);
            Add_Goto (Table.States (295), 335, 98);
            Add_Goto (Table.States (295), 336, 99);
            Add_Goto (Table.States (295), 337, 100);
            Add_Goto (Table.States (295), 338, 101);
            Add_Goto (Table.States (295), 339, 102);
            Add_Goto (Table.States (295), 340, 103);
            Add_Goto (Table.States (295), 341, 104);
            Add_Goto (Table.States (295), 345, 105);
            Add_Goto (Table.States (295), 346, 106);
            Add_Goto (Table.States (295), 347, 107);
            Add_Goto (Table.States (295), 354, 108);
            Add_Goto (Table.States (295), 388, 126);
            Add_Goto (Table.States (295), 389, 127);
            Add_Goto (Table.States (295), 390, 128);
            Add_Goto (Table.States (295), 391, 129);
            Add_Goto (Table.States (295), 392, 130);
            Add_Goto (Table.States (295), 394, 132);
            Add_Goto (Table.States (295), 403, 134);
            Add_Goto (Table.States (295), 404, 135);
            Add_Goto (Table.States (295), 405, 136);
            Add_Goto (Table.States (295), 406, 137);
            Add_Goto (Table.States (295), 408, 138);
            Add_Goto (Table.States (295), 431, 139);
            Add_Goto (Table.States (295), 437, 140);
            Add_Goto (Table.States (295), 438, 141);
            Add_Goto (Table.States (295), 440, 142);
            Add_Goto (Table.States (295), 454, 143);
            Add_Goto (Table.States (295), 458, 565);
            Table.States (295).Kernel := To_Vector ((0 => ((286, 0),  39,  5, (32767, 0),  0)));
            Table.States (295).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (192, 1),  0)));
         end Subr_11;
         procedure Subr_12
         is begin
            Table.States (296).Action_List.Set_Capacity (2);
            Add_Action (Table.States (296), 85, (283, 1), 246);
            Add_Action (Table.States (296), 116, (278, 0), 454);
            Table.States (296).Goto_List.Set_Capacity (5);
            Add_Goto (Table.States (296), 278, 250);
            Add_Goto (Table.States (296), 280, 251);
            Add_Goto (Table.States (296), 282, 252);
            Add_Goto (Table.States (296), 283, 253);
            Add_Goto (Table.States (296), 299, 254);
            Table.States (296).Kernel := To_Vector ((((276, 1),  51,  3, (32767, 0),  0), ((276, 2),  51,  3, (32767,
            0),  0), ((276, 4),  51,  8, (32767, 0),  0)));
            Table.States (296).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (278, 0),  116, 454)));
            Table.States (297).Action_List.Set_Capacity (1);
            Add_Action (Table.States (297), 36, (275, 0), 566);
            Table.States (297).Kernel := To_Vector ((0 => ((275, 0),  276,  6, (32767, 0),  0)));
            Table.States (297).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (275, 0),  36, 566)));
            Table.States (298).Action_List.Set_Capacity (5);
            Add_Action (Table.States (298), 86, (252, 0), 33);
            Add_Action (Table.States (298), 90, (268, 0), 34);
            Add_Action (Table.States (298), 116, (196, 0), 146);
            Add_Action (Table.States (298), 117, (196, 1), 37);
            Add_Action (Table.States (298), 118, (195, 6), 38);
            Table.States (298).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (298), 195, 567);
            Add_Goto (Table.States (298), 196, 148);
            Add_Goto (Table.States (298), 197, 54);
            Add_Goto (Table.States (298), 198, 55);
            Add_Goto (Table.States (298), 199, 56);
            Add_Goto (Table.States (298), 201, 57);
            Add_Goto (Table.States (298), 251, 58);
            Add_Goto (Table.States (298), 252, 59);
            Add_Goto (Table.States (298), 255, 60);
            Add_Goto (Table.States (298), 268, 68);
            Add_Goto (Table.States (298), 311, 83);
            Table.States (298).Kernel := To_Vector ((((338, 2),  24,  4, (32767, 0),  0), ((338, 3),  24,  2, (32767,
            0),  0)));
            Table.States (298).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (299).Action_List.Set_Capacity (1);
            Add_Action (Table.States (299), 116, (435, 0), 568);
            Table.States (299).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (299), 432, 569);
            Add_Goto (Table.States (299), 433, 570);
            Add_Goto (Table.States (299), 435, 571);
            Table.States (299).Kernel := To_Vector ((0 => ((434, 0),  61,  1, (32767, 0),  0)));
            Table.States (299).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (435, 0),  116, 568)));
            Table.States (300).Action_List.Set_Capacity (17);
            Add_Action (Table.States (300), 13, (389, 2), 572);
            Add_Action (Table.States (300), 22, (339, 0), 9);
            Add_Action (Table.States (300), 25, (329, 1), 10);
            Add_Action (Table.States (300), 28, (325, 0), 12);
            Add_Action (Table.States (300), 38, Reduce, (192, 1),  0);
            Add_Action (Table.States (300), 50, (332, 0), 19);
            Add_Action (Table.States (300), 51, (437, 0), 221);
            Add_Action (Table.States (300), 52, (329, 0), 21);
            Add_Action (Table.States (300), 53, (294, 0), 22);
            Add_Action (Table.States (300), 54, (293, 0), 23);
            Add_Action (Table.States (300), 59, (346, 0), 24);
            Add_Action (Table.States (300), 60, (340, 0), 25);
            Add_Action (Table.States (300), 78, (180, 2), 573);
            Add_Action (Table.States (300), 81, (130, 0), 30);
            Add_Action (Table.States (300), 83, (128, 0), 31);
            Add_Action (Table.States (300), 84, (124, 0), 32);
            Add_Action (Table.States (300), 116, (136, 0), 223);
            Table.States (300).Goto_List.Set_Capacity (60);
            Add_Goto (Table.States (300), 124, 561);
            Add_Goto (Table.States (300), 126, 40);
            Add_Goto (Table.States (300), 127, 41);
            Add_Goto (Table.States (300), 128, 42);
            Add_Goto (Table.States (300), 130, 43);
            Add_Goto (Table.States (300), 135, 44);
            Add_Goto (Table.States (300), 136, 45);
            Add_Goto (Table.States (300), 137, 46);
            Add_Goto (Table.States (300), 180, 47);
            Add_Goto (Table.States (300), 189, 48);
            Add_Goto (Table.States (300), 190, 562);
            Add_Goto (Table.States (300), 191, 563);
            Add_Goto (Table.States (300), 192, 574);
            Add_Goto (Table.States (300), 193, 50);
            Add_Goto (Table.States (300), 194, 51);
            Add_Goto (Table.States (300), 291, 77);
            Add_Goto (Table.States (300), 292, 78);
            Add_Goto (Table.States (300), 293, 79);
            Add_Goto (Table.States (300), 294, 80);
            Add_Goto (Table.States (300), 309, 81);
            Add_Goto (Table.States (300), 320, 86);
            Add_Goto (Table.States (300), 321, 87);
            Add_Goto (Table.States (300), 322, 88);
            Add_Goto (Table.States (300), 325, 89);
            Add_Goto (Table.States (300), 326, 90);
            Add_Goto (Table.States (300), 327, 91);
            Add_Goto (Table.States (300), 328, 92);
            Add_Goto (Table.States (300), 329, 225);
            Add_Goto (Table.States (300), 330, 94);
            Add_Goto (Table.States (300), 332, 95);
            Add_Goto (Table.States (300), 333, 96);
            Add_Goto (Table.States (300), 334, 97);
            Add_Goto (Table.States (300), 335, 98);
            Add_Goto (Table.States (300), 336, 99);
            Add_Goto (Table.States (300), 337, 100);
            Add_Goto (Table.States (300), 338, 101);
            Add_Goto (Table.States (300), 339, 102);
            Add_Goto (Table.States (300), 340, 103);
            Add_Goto (Table.States (300), 341, 104);
            Add_Goto (Table.States (300), 345, 105);
            Add_Goto (Table.States (300), 346, 106);
            Add_Goto (Table.States (300), 347, 107);
            Add_Goto (Table.States (300), 354, 108);
            Add_Goto (Table.States (300), 388, 126);
            Add_Goto (Table.States (300), 389, 127);
            Add_Goto (Table.States (300), 390, 128);
            Add_Goto (Table.States (300), 391, 129);
            Add_Goto (Table.States (300), 392, 130);
            Add_Goto (Table.States (300), 394, 132);
            Add_Goto (Table.States (300), 403, 134);
            Add_Goto (Table.States (300), 404, 135);
            Add_Goto (Table.States (300), 405, 136);
            Add_Goto (Table.States (300), 406, 137);
            Add_Goto (Table.States (300), 408, 138);
            Add_Goto (Table.States (300), 431, 139);
            Add_Goto (Table.States (300), 437, 140);
            Add_Goto (Table.States (300), 438, 141);
            Add_Goto (Table.States (300), 440, 142);
            Add_Goto (Table.States (300), 454, 143);
            Add_Goto (Table.States (300), 458, 565);
            Table.States (300).Kernel := To_Vector ((((180, 2),  82,  4, (32767, 0),  0), ((180, 3),  82,  2, (32767,
            0),  0), ((309, 3),  82,  5, (32767, 0),  0), ((389, 2),  82,  4, (32767, 0),  0), ((389, 3),  82,  2,
            (32767, 0),  0)));
            Table.States (300).Minimal_Complete_Actions := To_Vector (((Shift, (180, 2),  78, 573), (Shift, (389, 2),
            13, 572)));
            Table.States (301).Action_List.Set_Capacity (43);
            Add_Action (Table.States (301), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (291, 3),  2);
            Table.States (301).Kernel := To_Vector ((0 => ((291, 3),  108,  0, (291, 3),  2)));
            Table.States (301).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (291, 3),  2)));
            Table.States (302).Action_List.Set_Capacity (2);
            Add_Action (Table.States (302), 82, (309, 2), 575);
            Add_Action (Table.States (302), 108, (291, 2), 576);
            Table.States (302).Kernel := To_Vector ((((291, 2),  434,  1, (32767, 0),  0), ((309, 2),  434,  6, (32767,
            0),  0)));
            Table.States (302).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (309, 2),  82, 575)));
            Table.States (303).Action_List.Set_Capacity (1);
            Add_Action (Table.States (303), 65, (320, 2), 577);
            Table.States (303).Kernel := To_Vector ((((320, 2),  82,  4, (32767, 0),  0), ((320, 3),  82,  2, (32767,
            0),  0)));
            Table.States (303).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (320, 2),  65, 577)));
            Table.States (304).Action_List.Set_Capacity (2);
            Add_Action (Table.States (304), 85, (205, 4), 171);
            Add_Action (Table.States (304), 86, (213, 2), 552);
            Table.States (304).Goto_List.Set_Capacity (10);
            Add_Goto (Table.States (304), 205, 578);
            Add_Goto (Table.States (304), 206, 178);
            Add_Goto (Table.States (304), 210, 179);
            Add_Goto (Table.States (304), 211, 180);
            Add_Goto (Table.States (304), 213, 181);
            Add_Goto (Table.States (304), 214, 182);
            Add_Goto (Table.States (304), 215, 183);
            Add_Goto (Table.States (304), 218, 184);
            Add_Goto (Table.States (304), 219, 185);
            Add_Goto (Table.States (304), 220, 186);
            Table.States (304).Kernel := To_Vector ((((321, 2),  82,  5, (32767, 0),  0), ((321, 3),  82,  3, (32767,
            0),  0)));
            Table.States (304).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (213, 2),  86, 552)));
            Table.States (305).Action_List.Set_Capacity (43);
            Add_Action (Table.States (305), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (322, 0),  2);
            Table.States (305).Kernel := To_Vector ((0 => ((322, 0),  108,  0, (322, 0),  2)));
            Table.States (305).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (322, 0),  2)));
            Table.States (306).Action_List.Set_Capacity (1);
            Add_Action (Table.States (306), 116, (356, 0), 579);
            Table.States (306).Kernel := To_Vector ((((356, 0),  21,  7, (32767, 0),  0), ((356, 1),  21,  5, (32767,
            0),  0), ((356, 2),  21,  4, (32767, 0),  0), ((356, 3),  21,  2, (32767, 0),  0)));
            Table.States (306).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (356, 0),  116, 579)));
            Table.States (307).Action_List.Set_Capacity (5);
            Add_Action (Table.States (307), 86, (252, 0), 33);
            Add_Action (Table.States (307), 90, (268, 0), 34);
            Add_Action (Table.States (307), 116, (196, 0), 146);
            Add_Action (Table.States (307), 117, (196, 1), 37);
            Add_Action (Table.States (307), 118, (195, 6), 38);
            Table.States (307).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (307), 195, 580);
            Add_Goto (Table.States (307), 196, 148);
            Add_Goto (Table.States (307), 197, 54);
            Add_Goto (Table.States (307), 198, 55);
            Add_Goto (Table.States (307), 199, 56);
            Add_Goto (Table.States (307), 201, 57);
            Add_Goto (Table.States (307), 251, 58);
            Add_Goto (Table.States (307), 252, 59);
            Add_Goto (Table.States (307), 255, 60);
            Add_Goto (Table.States (307), 268, 68);
            Add_Goto (Table.States (307), 311, 83);
            Table.States (307).Kernel := To_Vector ((((294, 0),  53,  3, (32767, 0),  0), ((408, 6),  53,  7, (32767,
            0),  0), ((408, 7),  53,  5, (32767, 0),  0)));
            Table.States (307).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (308).Action_List.Set_Capacity (5);
            Add_Action (Table.States (308), 86, (252, 0), 33);
            Add_Action (Table.States (308), 90, (268, 0), 34);
            Add_Action (Table.States (308), 116, (196, 0), 146);
            Add_Action (Table.States (308), 117, (196, 1), 37);
            Add_Action (Table.States (308), 118, (195, 6), 38);
            Table.States (308).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (308), 195, 581);
            Add_Goto (Table.States (308), 196, 148);
            Add_Goto (Table.States (308), 197, 54);
            Add_Goto (Table.States (308), 198, 55);
            Add_Goto (Table.States (308), 199, 56);
            Add_Goto (Table.States (308), 201, 57);
            Add_Goto (Table.States (308), 251, 58);
            Add_Goto (Table.States (308), 252, 59);
            Add_Goto (Table.States (308), 255, 60);
            Add_Goto (Table.States (308), 268, 68);
            Add_Goto (Table.States (308), 311, 83);
            Table.States (308).Kernel := To_Vector ((((293, 0),  54,  1, (32767, 0),  0), ((408, 2),  54,  7, (32767,
            0),  0), ((408, 3),  54,  5, (32767, 0),  0)));
            Table.States (308).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (309).Action_List.Set_Capacity (4);
            Add_Action (Table.States (309), 24, (338, 0), 582);
            Add_Action (Table.States (309), 61, (434, 0), 299);
            Add_Action (Table.States (309), 82, (180, 0), 583);
            Add_Action (Table.States (309), 108, (291, 1), 584);
            Table.States (309).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (309), 434, 585);
            Table.States (309).Kernel := To_Vector ((((180, 0),  292,  5, (32767, 0),  0), ((180, 1),  292,  3, (32767,
            0),  0), ((291, 0),  292,  3, (32767, 0),  0), ((291, 1),  292,  1, (32767, 0),  0), ((309, 0),  292,  8,
            (32767, 0),  0), ((309, 1),  292,  6, (32767, 0),  0), ((338, 0),  292,  5, (32767, 0),  0), ((338, 1),
            292,  3, (32767, 0),  0), ((389, 0),  292,  5, (32767, 0),  0), ((389, 1),  292,  3, (32767, 0),  0)));
            Table.States (309).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (291, 1),  108, 584)));
            Table.States (310).Action_List.Set_Capacity (4);
            Add_Action (Table.States (310), 24, Reduce, (292, 0),  1);
            Add_Action (Table.States (310), 61, Reduce, (292, 0),  1);
            Add_Action (Table.States (310), 82, (320, 0), 586);
            Add_Conflict (Table.States (310), 82, (292, 0),  1);
            Add_Action (Table.States (310), 108, Reduce, (292, 0),  1);
            Table.States (310).Kernel := To_Vector ((((292, 0),  293,  0, (292, 0),  1), ((320, 0),  293,  5, (32767,
            0),  0), ((320, 1),  293,  3, (32767, 0),  0)));
            Table.States (310).Minimal_Complete_Actions := To_Vector (((Reduce, (292, 0),  1), (Shift, (320, 0),  82,
            586)));
            Table.States (311).Action_List.Set_Capacity (4);
            Add_Action (Table.States (311), 24, Reduce, (292, 1),  1);
            Add_Action (Table.States (311), 61, Reduce, (292, 1),  1);
            Add_Action (Table.States (311), 82, (321, 0), 587);
            Add_Conflict (Table.States (311), 82, (292, 1),  1);
            Add_Action (Table.States (311), 108, Reduce, (292, 1),  1);
            Table.States (311).Kernel := To_Vector ((((292, 1),  294,  0, (292, 1),  1), ((321, 0),  294,  6, (32767,
            0),  0), ((321, 1),  294,  4, (32767, 0),  0)));
            Table.States (311).Minimal_Complete_Actions := To_Vector (((Reduce, (292, 1),  1), (Shift, (321, 0),  82,
            587)));
            Table.States (312).Action_List.Set_Capacity (42);
            Add_Action (Table.States (312), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (383,
            1),  2);
            Table.States (312).Kernel := To_Vector ((0 => ((383, 1),  384,  0, (383, 1),  2)));
            Table.States (312).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (383, 1),  2)));
            Table.States (313).Action_List.Set_Capacity (5);
            Add_Action (Table.States (313), 86, (252, 0), 33);
            Add_Action (Table.States (313), 90, (268, 0), 34);
            Add_Action (Table.States (313), 116, (196, 0), 146);
            Add_Action (Table.States (313), 117, (196, 1), 37);
            Add_Action (Table.States (313), 118, (195, 6), 38);
            Table.States (313).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (313), 195, 588);
            Add_Goto (Table.States (313), 196, 148);
            Add_Goto (Table.States (313), 197, 54);
            Add_Goto (Table.States (313), 198, 55);
            Add_Goto (Table.States (313), 199, 56);
            Add_Goto (Table.States (313), 201, 57);
            Add_Goto (Table.States (313), 251, 58);
            Add_Goto (Table.States (313), 252, 59);
            Add_Goto (Table.States (313), 255, 60);
            Add_Goto (Table.States (313), 268, 68);
            Add_Goto (Table.States (313), 311, 83);
            Table.States (313).Kernel := To_Vector ((((325, 0),  28,  12, (32767, 0),  0), ((325, 1),  28,  9, (32767,
            0),  0), ((325, 2),  28,  8, (32767, 0),  0), ((325, 3),  28,  9, (32767, 0),  0), ((325, 4),  28,  6,
            (32767, 0),  0), ((325, 5),  28,  5, (32767, 0),  0), ((325, 6),  28,  10, (32767, 0),  0), ((325, 7),  28,
             7, (32767, 0),  0), ((325, 8),  28,  6, (32767, 0),  0), ((325, 9),  28,  7, (32767, 0),  0), ((325, 10),
            28,  4, (32767, 0),  0), ((325, 11),  28,  3, (32767, 0),  0)));
            Table.States (313).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (314).Action_List.Set_Capacity (5);
            Add_Action (Table.States (314), 86, (252, 0), 33);
            Add_Action (Table.States (314), 90, (268, 0), 34);
            Add_Action (Table.States (314), 116, (196, 0), 146);
            Add_Action (Table.States (314), 117, (196, 1), 37);
            Add_Action (Table.States (314), 118, (195, 6), 38);
            Table.States (314).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (314), 195, 589);
            Add_Goto (Table.States (314), 196, 148);
            Add_Goto (Table.States (314), 197, 54);
            Add_Goto (Table.States (314), 198, 55);
            Add_Goto (Table.States (314), 199, 56);
            Add_Goto (Table.States (314), 201, 57);
            Add_Goto (Table.States (314), 251, 58);
            Add_Goto (Table.States (314), 252, 59);
            Add_Goto (Table.States (314), 255, 60);
            Add_Goto (Table.States (314), 268, 68);
            Add_Goto (Table.States (314), 311, 83);
            Table.States (314).Kernel := To_Vector ((0 => ((294, 0),  53,  3, (32767, 0),  0)));
            Table.States (314).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (315).Action_List.Set_Capacity (5);
            Add_Action (Table.States (315), 86, (252, 0), 33);
            Add_Action (Table.States (315), 90, (268, 0), 34);
            Add_Action (Table.States (315), 116, (196, 0), 146);
            Add_Action (Table.States (315), 117, (196, 1), 37);
            Add_Action (Table.States (315), 118, (195, 6), 38);
            Table.States (315).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (315), 195, 590);
            Add_Goto (Table.States (315), 196, 148);
            Add_Goto (Table.States (315), 197, 54);
            Add_Goto (Table.States (315), 198, 55);
            Add_Goto (Table.States (315), 199, 56);
            Add_Goto (Table.States (315), 201, 57);
            Add_Goto (Table.States (315), 251, 58);
            Add_Goto (Table.States (315), 252, 59);
            Add_Goto (Table.States (315), 255, 60);
            Add_Goto (Table.States (315), 268, 68);
            Add_Goto (Table.States (315), 311, 83);
            Table.States (315).Kernel := To_Vector ((0 => ((293, 0),  54,  1, (32767, 0),  0)));
            Table.States (315).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (316).Action_List.Set_Capacity (2);
            Add_Action (Table.States (316), 61, (434, 0), 299);
            Add_Action (Table.States (316), 108, (404, 1), 591);
            Table.States (316).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (316), 434, 592);
            Table.States (316).Kernel := To_Vector ((((404, 0),  292,  3, (32767, 0),  0), ((404, 1),  292,  1, (32767,
            0),  0)));
            Table.States (316).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (404, 1),  108, 591)));
            Table.States (317).Action_List.Set_Capacity (3);
            Add_Action (Table.States (317), (61, 82, 108), (292, 0),  1);
            Table.States (317).Kernel := To_Vector ((0 => ((292, 0),  293,  0, (292, 0),  1)));
            Table.States (317).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (292, 0),  1)));
            Table.States (318).Action_List.Set_Capacity (3);
            Add_Action (Table.States (318), (61, 82, 108), (292, 1),  1);
            Table.States (318).Kernel := To_Vector ((0 => ((292, 1),  294,  0, (292, 1),  1)));
            Table.States (318).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (292, 1),  1)));
            Table.States (319).Action_List.Set_Capacity (1);
            Add_Action (Table.States (319), 108, (405, 0), 593);
            Table.States (319).Kernel := To_Vector ((0 => ((405, 0),  325,  1, (32767, 0),  0)));
            Table.States (319).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (405, 0),  108, 593)));
            Table.States (320).Action_List.Set_Capacity (50);
            Add_Action (Table.States (320), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (261, 0),  2);
            Table.States (320).Kernel := To_Vector ((0 => ((261, 0),  262,  0, (261, 0),  2)));
            Table.States (320).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (261, 0),  2)));
            Table.States (321).Action_List.Set_Capacity (50);
            Add_Action (Table.States (321), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (261, 2),  2);
            Table.States (321).Kernel := To_Vector ((0 => ((261, 2),  263,  0, (261, 2),  2)));
            Table.States (321).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (261, 2),  2)));
            Table.States (322).Action_List.Set_Capacity (50);
            Add_Action (Table.States (322), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (462, 1),  2);
            Table.States (322).Kernel := To_Vector ((((462, 0),  265,  0, (462, 0),  1), ((462, 1),  265,  0, (462, 1),
             2)));
            Table.States (322).Minimal_Complete_Actions := To_Vector (((Reduce, (462, 0),  1), (Reduce, (462, 1),
            2)));
            Table.States (323).Action_List.Set_Capacity (50);
            Add_Action (Table.States (323), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (462, 2),  2);
            Table.States (323).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (323), 265, 322);
            Add_Goto (Table.States (323), 462, 323);
            Table.States (323).Kernel := To_Vector ((((462, 1),  462,  3, (32767, 0),  0), ((462, 2),  462,  0, (462,
            2),  2), ((462, 2),  462,  3, (32767, 0),  0)));
            Table.States (323).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (462, 2),  2)));
            Table.States (324).Action_List.Set_Capacity (14);
            Add_Action (Table.States (324), 12, (402, 0), 165);
            Add_Action (Table.States (324), 44, (233, 2), 167);
            Add_Action (Table.States (324), 52, (233, 3), 168);
            Add_Action (Table.States (324), 65, (234, 1), 169);
            Add_Action (Table.States (324), 76, (256, 0), 170);
            Add_Action (Table.States (324), 85, (205, 4), 171);
            Add_Action (Table.States (324), 86, (213, 2), 172);
            Add_Action (Table.States (324), 90, (268, 0), 34);
            Add_Action (Table.States (324), 106, (237, 1), 173);
            Add_Action (Table.States (324), 107, (237, 0), 174);
            Add_Action (Table.States (324), 115, (234, 0), 175);
            Add_Action (Table.States (324), 116, (196, 0), 146);
            Add_Action (Table.States (324), 117, (196, 1), 37);
            Add_Action (Table.States (324), 118, (195, 6), 38);
            Table.States (324).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (324), 195, 176);
            Add_Goto (Table.States (324), 196, 148);
            Add_Goto (Table.States (324), 197, 54);
            Add_Goto (Table.States (324), 198, 55);
            Add_Goto (Table.States (324), 199, 56);
            Add_Goto (Table.States (324), 201, 57);
            Add_Goto (Table.States (324), 205, 177);
            Add_Goto (Table.States (324), 206, 178);
            Add_Goto (Table.States (324), 210, 179);
            Add_Goto (Table.States (324), 211, 180);
            Add_Goto (Table.States (324), 213, 181);
            Add_Goto (Table.States (324), 214, 182);
            Add_Goto (Table.States (324), 215, 183);
            Add_Goto (Table.States (324), 218, 184);
            Add_Goto (Table.States (324), 219, 185);
            Add_Goto (Table.States (324), 220, 186);
            Add_Goto (Table.States (324), 227, 594);
            Add_Goto (Table.States (324), 228, 188);
            Add_Goto (Table.States (324), 231, 189);
            Add_Goto (Table.States (324), 232, 190);
            Add_Goto (Table.States (324), 233, 191);
            Add_Goto (Table.States (324), 234, 192);
            Add_Goto (Table.States (324), 237, 193);
            Add_Goto (Table.States (324), 251, 58);
            Add_Goto (Table.States (324), 252, 59);
            Add_Goto (Table.States (324), 255, 60);
            Add_Goto (Table.States (324), 256, 194);
            Add_Goto (Table.States (324), 268, 68);
            Add_Goto (Table.States (324), 311, 83);
            Add_Goto (Table.States (324), 402, 195);
            Add_Goto (Table.States (324), 465, 196);
            Table.States (324).Kernel := To_Vector ((0 => ((401, 1),  61,  2, (32767, 0),  0)));
            Table.States (324).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
         end Subr_12;
         procedure Subr_13
         is begin
            Table.States (325).Action_List.Set_Capacity (50);
            Add_Action (Table.States (325), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (401, 2),  3);
            Table.States (325).Kernel := To_Vector ((0 => ((401, 2),  108,  0, (401, 2),  3)));
            Table.States (325).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (401, 2),  3)));
            Table.States (326).Action_List.Set_Capacity (5);
            Add_Action (Table.States (326), 85, (198, 0), 281);
            Add_Action (Table.States (326), 87, (393, 0), 595);
            Add_Action (Table.States (326), 96, (197, 0), 283);
            Add_Action (Table.States (326), 113, (121, 0), 285);
            Add_Action (Table.States (326), 114, (121, 1), 286);
            Table.States (326).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (326), 121, 287);
            Add_Goto (Table.States (326), 313, 289);
            Table.States (326).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((393, 0),  195,  7, (32767, 0),  0)));
            Table.States (326).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (393, 0),  87, 595)));
            Table.States (327).Action_List.Set_Capacity (3);
            Add_Action (Table.States (327), (47, 48, 66), (375, 0),  2);
            Table.States (327).Kernel := To_Vector ((0 => ((375, 0),  108,  0, (375, 0),  2)));
            Table.States (327).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (375, 0),  2)));
            Table.States (328).Action_List.Set_Capacity (1);
            Add_Action (Table.States (328), 99, (371, 0), 596);
            Table.States (328).Kernel := To_Vector ((0 => ((371, 0),  243,  1, (32767, 0),  0)));
            Table.States (328).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (371, 0),  99, 596)));
            Table.States (329).Action_List.Set_Capacity (4);
            Add_Action (Table.States (329), (47, 48, 49, 66), (260, 0),  1);
            Table.States (329).Kernel := To_Vector ((0 => ((260, 0),  259,  0, (260, 0),  1)));
            Table.States (329).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (260, 0),  1)));
            Table.States (330).Action_List.Set_Capacity (3);
            Add_Action (Table.States (330), 47, Reduce, (377, 0),  2);
            Add_Action (Table.States (330), 48, Reduce, (377, 0),  2);
            Add_Action (Table.States (330), 49, Reduce, (380, 0),  2);
            Table.States (330).Kernel := To_Vector ((((377, 0),  260,  0, (377, 0),  2), ((380, 0),  260,  0, (380, 0),
             2)));
            Table.States (330).Minimal_Complete_Actions := To_Vector (((Reduce, (377, 0),  2), (Reduce, (380, 0),
            2)));
            Table.States (331).Action_List.Set_Capacity (33);
            Add_Action (Table.States (331), (12, 15, 17, 18, 19, 20, 23, 30, 31, 32, 35, 36, 37, 38, 39, 41, 42, 47,
            48, 49, 51, 63, 64, 65, 66, 75, 84, 86, 90, 105, 116, 117, 118), (461, 0),  1);
            Table.States (331).Kernel := To_Vector ((0 => ((461, 0),  261,  0, (461, 0),  1)));
            Table.States (331).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (461, 0),  1)));
            Table.States (332).Action_List.Set_Capacity (33);
            Add_Action (Table.States (332), 12, (401, 0), 1);
            Add_Action (Table.States (332), 15, (370, 0), 3);
            Add_Action (Table.States (332), 17, (365, 0), 4);
            Add_Action (Table.States (332), 18, (382, 0), 5);
            Add_Action (Table.States (332), 19, (363, 0), 6);
            Add_Action (Table.States (332), 20, (357, 0), 7);
            Add_Action (Table.States (332), 23, Reduce, (259, 1),  1);
            Add_Action (Table.States (332), 30, (316, 0), 13);
            Add_Action (Table.States (332), 31, (290, 0), 14);
            Add_Action (Table.States (332), 32, (289, 0), 15);
            Add_Action (Table.States (332), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (332), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (332), 37, (288, 0), 17);
            Add_Conflict (Table.States (332), 37, (285, 1),  0);
            Add_Action (Table.States (332), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (332), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (332), 41, (271, 0), 18);
            Add_Action (Table.States (332), 42, Reduce, (259, 1),  1);
            Add_Action (Table.States (332), 47, Reduce, (259, 1),  1);
            Add_Action (Table.States (332), 48, Reduce, (259, 1),  1);
            Add_Action (Table.States (332), 49, Reduce, (259, 1),  1);
            Add_Action (Table.States (332), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (332), 63, Reduce, (259, 1),  1);
            Add_Action (Table.States (332), 64, (273, 0), 27);
            Add_Action (Table.States (332), 65, (264, 0), 28);
            Add_Action (Table.States (332), 66, Reduce, (259, 1),  1);
            Add_Action (Table.States (332), 75, Reduce, (259, 1),  1);
            Add_Action (Table.States (332), 84, (124, 0), 32);
            Add_Action (Table.States (332), 86, (252, 0), 33);
            Add_Action (Table.States (332), 90, (268, 0), 34);
            Add_Action (Table.States (332), 105, (265, 0), 35);
            Add_Action (Table.States (332), 116, (196, 0), 146);
            Add_Action (Table.States (332), 117, (196, 1), 37);
            Add_Action (Table.States (332), 118, (195, 6), 38);
            Table.States (332).Goto_List.Set_Capacity (44);
            Add_Goto (Table.States (332), 124, 39);
            Add_Goto (Table.States (332), 195, 52);
            Add_Goto (Table.States (332), 196, 53);
            Add_Goto (Table.States (332), 197, 54);
            Add_Goto (Table.States (332), 198, 55);
            Add_Goto (Table.States (332), 199, 56);
            Add_Goto (Table.States (332), 201, 57);
            Add_Goto (Table.States (332), 251, 58);
            Add_Goto (Table.States (332), 252, 59);
            Add_Goto (Table.States (332), 255, 60);
            Add_Goto (Table.States (332), 261, 597);
            Add_Goto (Table.States (332), 262, 62);
            Add_Goto (Table.States (332), 263, 63);
            Add_Goto (Table.States (332), 264, 64);
            Add_Goto (Table.States (332), 265, 65);
            Add_Goto (Table.States (332), 266, 66);
            Add_Goto (Table.States (332), 267, 67);
            Add_Goto (Table.States (332), 268, 68);
            Add_Goto (Table.States (332), 271, 69);
            Add_Goto (Table.States (332), 273, 70);
            Add_Goto (Table.States (332), 275, 71);
            Add_Goto (Table.States (332), 285, 72);
            Add_Goto (Table.States (332), 286, 73);
            Add_Goto (Table.States (332), 288, 74);
            Add_Goto (Table.States (332), 289, 75);
            Add_Goto (Table.States (332), 290, 76);
            Add_Goto (Table.States (332), 310, 82);
            Add_Goto (Table.States (332), 311, 83);
            Add_Goto (Table.States (332), 316, 84);
            Add_Goto (Table.States (332), 318, 85);
            Add_Goto (Table.States (332), 357, 110);
            Add_Goto (Table.States (332), 363, 111);
            Add_Goto (Table.States (332), 364, 112);
            Add_Goto (Table.States (332), 365, 113);
            Add_Goto (Table.States (332), 366, 114);
            Add_Goto (Table.States (332), 367, 115);
            Add_Goto (Table.States (332), 370, 116);
            Add_Goto (Table.States (332), 376, 117);
            Add_Goto (Table.States (332), 378, 118);
            Add_Goto (Table.States (332), 379, 119);
            Add_Goto (Table.States (332), 382, 120);
            Add_Goto (Table.States (332), 401, 133);
            Add_Goto (Table.States (332), 461, 598);
            Add_Goto (Table.States (332), 462, 599);
            Table.States (332).Kernel := To_Vector ((((259, 0),  461,  3, (32767, 0),  0), ((259, 1),  461,  0, (259,
            1),  1), ((461, 1),  461,  2, (32767, 0),  0), ((461, 2),  461,  2, (32767, 0),  0)));
            Table.States (332).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (259, 1),  1)));
            Table.States (333).Action_List.Set_Capacity (3);
            Add_Action (Table.States (333), (47, 48, 66), (373, 0),  2);
            Table.States (333).Kernel := To_Vector ((0 => ((373, 0),  260,  0, (373, 0),  2)));
            Table.States (333).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (373, 0),  2)));
            Table.States (334).Action_List.Set_Capacity (4);
            Add_Action (Table.States (334), 47, Reduce, (374, 0),  2);
            Add_Action (Table.States (334), 48, Reduce, (374, 0),  2);
            Add_Action (Table.States (334), 49, Reduce, (380, 1),  2);
            Add_Action (Table.States (334), 66, Reduce, (374, 0),  2);
            Table.States (334).Kernel := To_Vector ((((374, 0),  260,  0, (374, 0),  2), ((380, 1),  260,  0, (380, 1),
             2)));
            Table.States (334).Minimal_Complete_Actions := To_Vector (((Reduce, (374, 0),  2), (Reduce, (380, 1),
            2)));
            Table.States (335).Action_List.Set_Capacity (25);
            Add_Action (Table.States (335), 12, (401, 0), 1);
            Add_Action (Table.States (335), 15, (370, 0), 3);
            Add_Action (Table.States (335), 17, (365, 0), 4);
            Add_Action (Table.States (335), 18, (382, 0), 5);
            Add_Action (Table.States (335), 19, (363, 0), 6);
            Add_Action (Table.States (335), 20, (357, 0), 7);
            Add_Action (Table.States (335), 30, (316, 0), 13);
            Add_Action (Table.States (335), 31, (290, 0), 14);
            Add_Action (Table.States (335), 32, (289, 0), 15);
            Add_Action (Table.States (335), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (335), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (335), 37, (288, 0), 17);
            Add_Conflict (Table.States (335), 37, (285, 1),  0);
            Add_Action (Table.States (335), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (335), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (335), 41, (271, 0), 18);
            Add_Action (Table.States (335), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (335), 64, (273, 0), 27);
            Add_Action (Table.States (335), 65, (264, 0), 28);
            Add_Action (Table.States (335), 84, (124, 0), 32);
            Add_Action (Table.States (335), 86, (252, 0), 33);
            Add_Action (Table.States (335), 90, (268, 0), 34);
            Add_Action (Table.States (335), 105, (265, 0), 35);
            Add_Action (Table.States (335), 116, (196, 0), 146);
            Add_Action (Table.States (335), 117, (196, 1), 37);
            Add_Action (Table.States (335), 118, (195, 6), 38);
            Table.States (335).Goto_List.Set_Capacity (45);
            Add_Goto (Table.States (335), 124, 39);
            Add_Goto (Table.States (335), 195, 52);
            Add_Goto (Table.States (335), 196, 53);
            Add_Goto (Table.States (335), 197, 54);
            Add_Goto (Table.States (335), 198, 55);
            Add_Goto (Table.States (335), 199, 56);
            Add_Goto (Table.States (335), 201, 57);
            Add_Goto (Table.States (335), 251, 58);
            Add_Goto (Table.States (335), 252, 59);
            Add_Goto (Table.States (335), 255, 60);
            Add_Goto (Table.States (335), 259, 600);
            Add_Goto (Table.States (335), 261, 331);
            Add_Goto (Table.States (335), 262, 62);
            Add_Goto (Table.States (335), 263, 63);
            Add_Goto (Table.States (335), 264, 64);
            Add_Goto (Table.States (335), 265, 65);
            Add_Goto (Table.States (335), 266, 66);
            Add_Goto (Table.States (335), 267, 67);
            Add_Goto (Table.States (335), 268, 68);
            Add_Goto (Table.States (335), 271, 69);
            Add_Goto (Table.States (335), 273, 70);
            Add_Goto (Table.States (335), 275, 71);
            Add_Goto (Table.States (335), 285, 72);
            Add_Goto (Table.States (335), 286, 73);
            Add_Goto (Table.States (335), 288, 74);
            Add_Goto (Table.States (335), 289, 75);
            Add_Goto (Table.States (335), 290, 76);
            Add_Goto (Table.States (335), 310, 82);
            Add_Goto (Table.States (335), 311, 83);
            Add_Goto (Table.States (335), 316, 84);
            Add_Goto (Table.States (335), 318, 85);
            Add_Goto (Table.States (335), 357, 110);
            Add_Goto (Table.States (335), 363, 111);
            Add_Goto (Table.States (335), 364, 112);
            Add_Goto (Table.States (335), 365, 113);
            Add_Goto (Table.States (335), 366, 114);
            Add_Goto (Table.States (335), 367, 115);
            Add_Goto (Table.States (335), 370, 116);
            Add_Goto (Table.States (335), 376, 117);
            Add_Goto (Table.States (335), 378, 118);
            Add_Goto (Table.States (335), 379, 119);
            Add_Goto (Table.States (335), 382, 120);
            Add_Goto (Table.States (335), 401, 133);
            Add_Goto (Table.States (335), 461, 332);
            Add_Goto (Table.States (335), 462, 144);
            Table.States (335).Kernel := To_Vector ((0 => ((370, 0),  47,  5, (32767, 0),  0)));
            Table.States (335).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (264, 0),  65, 28)));
            Table.States (336).Action_List.Set_Capacity (4);
            Add_Action (Table.States (336), 14, (375, 0), 150);
            Add_Action (Table.States (336), 17, (365, 0), 4);
            Add_Action (Table.States (336), 20, (357, 0), 7);
            Add_Action (Table.States (336), 63, (371, 0), 151);
            Table.States (336).Goto_List.Set_Capacity (10);
            Add_Goto (Table.States (336), 357, 154);
            Add_Goto (Table.States (336), 364, 338);
            Add_Goto (Table.States (336), 365, 113);
            Add_Goto (Table.States (336), 366, 114);
            Add_Goto (Table.States (336), 368, 601);
            Add_Goto (Table.States (336), 371, 158);
            Add_Goto (Table.States (336), 372, 159);
            Add_Goto (Table.States (336), 373, 160);
            Add_Goto (Table.States (336), 374, 161);
            Add_Goto (Table.States (336), 375, 162);
            Table.States (336).Kernel := To_Vector ((0 => ((369, 1),  48,  2, (32767, 0),  0)));
            Table.States (336).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (375, 0),  14, 150)));
            Table.States (337).Action_List.Set_Capacity (1);
            Add_Action (Table.States (337), 15, (370, 1), 602);
            Table.States (337).Kernel := To_Vector ((0 => ((370, 1),  66,  2, (32767, 0),  0)));
            Table.States (337).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (370, 1),  15, 602)));
            Table.States (338).Action_List.Set_Capacity (28);
            Add_Action (Table.States (338), 12, (401, 0), 1);
            Add_Action (Table.States (338), 15, (370, 0), 3);
            Add_Action (Table.States (338), 17, (365, 0), 4);
            Add_Action (Table.States (338), 18, (382, 0), 5);
            Add_Action (Table.States (338), 19, (363, 0), 6);
            Add_Action (Table.States (338), 20, (357, 0), 7);
            Add_Action (Table.States (338), 30, (316, 0), 13);
            Add_Action (Table.States (338), 31, (290, 0), 14);
            Add_Action (Table.States (338), 32, (289, 0), 15);
            Add_Action (Table.States (338), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (338), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (338), 37, (288, 0), 17);
            Add_Conflict (Table.States (338), 37, (285, 1),  0);
            Add_Action (Table.States (338), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (338), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (338), 41, (271, 0), 18);
            Add_Action (Table.States (338), 47, Reduce, (260, 1),  0);
            Add_Action (Table.States (338), 48, Reduce, (260, 1),  0);
            Add_Action (Table.States (338), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (338), 64, (273, 0), 27);
            Add_Action (Table.States (338), 65, (264, 0), 28);
            Add_Action (Table.States (338), 66, Reduce, (260, 1),  0);
            Add_Action (Table.States (338), 84, (124, 0), 32);
            Add_Action (Table.States (338), 86, (252, 0), 33);
            Add_Action (Table.States (338), 90, (268, 0), 34);
            Add_Action (Table.States (338), 105, (265, 0), 35);
            Add_Action (Table.States (338), 116, (196, 0), 146);
            Add_Action (Table.States (338), 117, (196, 1), 37);
            Add_Action (Table.States (338), 118, (195, 6), 38);
            Table.States (338).Goto_List.Set_Capacity (46);
            Add_Goto (Table.States (338), 124, 39);
            Add_Goto (Table.States (338), 195, 52);
            Add_Goto (Table.States (338), 196, 53);
            Add_Goto (Table.States (338), 197, 54);
            Add_Goto (Table.States (338), 198, 55);
            Add_Goto (Table.States (338), 199, 56);
            Add_Goto (Table.States (338), 201, 57);
            Add_Goto (Table.States (338), 251, 58);
            Add_Goto (Table.States (338), 252, 59);
            Add_Goto (Table.States (338), 255, 60);
            Add_Goto (Table.States (338), 259, 329);
            Add_Goto (Table.States (338), 260, 603);
            Add_Goto (Table.States (338), 261, 331);
            Add_Goto (Table.States (338), 262, 62);
            Add_Goto (Table.States (338), 263, 63);
            Add_Goto (Table.States (338), 264, 64);
            Add_Goto (Table.States (338), 265, 65);
            Add_Goto (Table.States (338), 266, 66);
            Add_Goto (Table.States (338), 267, 67);
            Add_Goto (Table.States (338), 268, 68);
            Add_Goto (Table.States (338), 271, 69);
            Add_Goto (Table.States (338), 273, 70);
            Add_Goto (Table.States (338), 275, 71);
            Add_Goto (Table.States (338), 285, 72);
            Add_Goto (Table.States (338), 286, 73);
            Add_Goto (Table.States (338), 288, 74);
            Add_Goto (Table.States (338), 289, 75);
            Add_Goto (Table.States (338), 290, 76);
            Add_Goto (Table.States (338), 310, 82);
            Add_Goto (Table.States (338), 311, 83);
            Add_Goto (Table.States (338), 316, 84);
            Add_Goto (Table.States (338), 318, 85);
            Add_Goto (Table.States (338), 357, 110);
            Add_Goto (Table.States (338), 363, 111);
            Add_Goto (Table.States (338), 364, 112);
            Add_Goto (Table.States (338), 365, 113);
            Add_Goto (Table.States (338), 366, 114);
            Add_Goto (Table.States (338), 367, 115);
            Add_Goto (Table.States (338), 370, 116);
            Add_Goto (Table.States (338), 376, 117);
            Add_Goto (Table.States (338), 378, 118);
            Add_Goto (Table.States (338), 379, 119);
            Add_Goto (Table.States (338), 382, 120);
            Add_Goto (Table.States (338), 401, 133);
            Add_Goto (Table.States (338), 461, 332);
            Add_Goto (Table.States (338), 462, 144);
            Table.States (338).Kernel := To_Vector ((0 => ((374, 0),  364,  0, (260, 1),  0)));
            Table.States (338).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (260, 1),  0)));
            Table.States (339).Action_List.Set_Capacity (3);
            Add_Action (Table.States (339), (47, 48, 66), (368, 0),  2);
            Table.States (339).Kernel := To_Vector ((0 => ((368, 0),  372,  0, (368, 0),  2)));
            Table.States (339).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (368, 0),  2)));
            Table.States (340).Action_List.Set_Capacity (25);
            Add_Action (Table.States (340), 12, (401, 0), 1);
            Add_Action (Table.States (340), 15, (370, 0), 3);
            Add_Action (Table.States (340), 17, (365, 0), 4);
            Add_Action (Table.States (340), 18, (382, 0), 5);
            Add_Action (Table.States (340), 19, (363, 0), 6);
            Add_Action (Table.States (340), 20, (357, 0), 7);
            Add_Action (Table.States (340), 30, (316, 0), 13);
            Add_Action (Table.States (340), 31, (290, 0), 14);
            Add_Action (Table.States (340), 32, (289, 0), 15);
            Add_Action (Table.States (340), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (340), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (340), 37, (288, 0), 17);
            Add_Conflict (Table.States (340), 37, (285, 1),  0);
            Add_Action (Table.States (340), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (340), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (340), 41, (271, 0), 18);
            Add_Action (Table.States (340), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (340), 64, (273, 0), 27);
            Add_Action (Table.States (340), 65, (264, 0), 28);
            Add_Action (Table.States (340), 84, (124, 0), 32);
            Add_Action (Table.States (340), 86, (252, 0), 33);
            Add_Action (Table.States (340), 90, (268, 0), 34);
            Add_Action (Table.States (340), 105, (265, 0), 35);
            Add_Action (Table.States (340), 116, (196, 0), 146);
            Add_Action (Table.States (340), 117, (196, 1), 37);
            Add_Action (Table.States (340), 118, (195, 6), 38);
            Table.States (340).Goto_List.Set_Capacity (45);
            Add_Goto (Table.States (340), 124, 39);
            Add_Goto (Table.States (340), 195, 52);
            Add_Goto (Table.States (340), 196, 53);
            Add_Goto (Table.States (340), 197, 54);
            Add_Goto (Table.States (340), 198, 55);
            Add_Goto (Table.States (340), 199, 56);
            Add_Goto (Table.States (340), 201, 57);
            Add_Goto (Table.States (340), 251, 58);
            Add_Goto (Table.States (340), 252, 59);
            Add_Goto (Table.States (340), 255, 60);
            Add_Goto (Table.States (340), 259, 604);
            Add_Goto (Table.States (340), 261, 331);
            Add_Goto (Table.States (340), 262, 62);
            Add_Goto (Table.States (340), 263, 63);
            Add_Goto (Table.States (340), 264, 64);
            Add_Goto (Table.States (340), 265, 65);
            Add_Goto (Table.States (340), 266, 66);
            Add_Goto (Table.States (340), 267, 67);
            Add_Goto (Table.States (340), 268, 68);
            Add_Goto (Table.States (340), 271, 69);
            Add_Goto (Table.States (340), 273, 70);
            Add_Goto (Table.States (340), 275, 71);
            Add_Goto (Table.States (340), 285, 72);
            Add_Goto (Table.States (340), 286, 73);
            Add_Goto (Table.States (340), 288, 74);
            Add_Goto (Table.States (340), 289, 75);
            Add_Goto (Table.States (340), 290, 76);
            Add_Goto (Table.States (340), 310, 82);
            Add_Goto (Table.States (340), 311, 83);
            Add_Goto (Table.States (340), 316, 84);
            Add_Goto (Table.States (340), 318, 85);
            Add_Goto (Table.States (340), 357, 110);
            Add_Goto (Table.States (340), 363, 111);
            Add_Goto (Table.States (340), 364, 112);
            Add_Goto (Table.States (340), 365, 113);
            Add_Goto (Table.States (340), 366, 114);
            Add_Goto (Table.States (340), 367, 115);
            Add_Goto (Table.States (340), 370, 116);
            Add_Goto (Table.States (340), 376, 117);
            Add_Goto (Table.States (340), 378, 118);
            Add_Goto (Table.States (340), 379, 119);
            Add_Goto (Table.States (340), 382, 120);
            Add_Goto (Table.States (340), 401, 133);
            Add_Goto (Table.States (340), 461, 332);
            Add_Goto (Table.States (340), 462, 144);
            Table.States (340).Kernel := To_Vector ((0 => ((378, 0),  47,  5, (32767, 0),  0)));
            Table.States (340).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (264, 0),  65, 28)));
         end Subr_13;
         procedure Subr_14
         is begin
            Table.States (341).Action_List.Set_Capacity (1);
            Add_Action (Table.States (341), 17, (365, 0), 4);
            Table.States (341).Goto_List.Set_Capacity (4);
            Add_Goto (Table.States (341), 364, 338);
            Add_Goto (Table.States (341), 365, 113);
            Add_Goto (Table.States (341), 366, 114);
            Add_Goto (Table.States (341), 374, 605);
            Table.States (341).Kernel := To_Vector ((0 => ((376, 0),  48,  6, (32767, 0),  0)));
            Table.States (341).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (365, 0),  17, 4)));
            Table.States (342).Action_List.Set_Capacity (1);
            Add_Action (Table.States (342), 18, (379, 0), 606);
            Table.States (342).Kernel := To_Vector ((0 => ((379, 0),  49,  6, (32767, 0),  0)));
            Table.States (342).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (379, 0),  18, 606)));
            Table.States (343).Action_List.Set_Capacity (24);
            Add_Action (Table.States (343), 33, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 36, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 42, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 46, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 47, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 48, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 49, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 50, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 61, (402, 0), 607);
            Add_Conflict (Table.States (343), 61, (402, 1),  2);
            Add_Action (Table.States (343), 63, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 72, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 74, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 75, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 82, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 85, (198, 0), 281);
            Add_Action (Table.States (343), 87, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 88, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 91, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 95, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 96, (197, 0), 283);
            Add_Action (Table.States (343), 99, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 108, Reduce, (402, 1),  2);
            Add_Action (Table.States (343), 113, (121, 0), 285);
            Add_Action (Table.States (343), 114, (121, 1), 286);
            Table.States (343).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (343), 121, 287);
            Add_Goto (Table.States (343), 313, 289);
            Table.States (343).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((402, 0),  195,  2, (32767, 0),  0), ((402, 1),
            195,  0, (402, 1),  2)));
            Table.States (343).Minimal_Complete_Actions := To_Vector (((Shift, (402, 0),  61, 607), (Reduce, (402, 1),
            2)));
            Table.States (344).Action_List.Set_Capacity (1);
            Add_Action (Table.States (344), 108, (365, 0), 608);
            Table.States (344).Kernel := To_Vector ((0 => ((365, 0),  227,  1, (32767, 0),  0)));
            Table.States (344).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (365, 0),  108, 608)));
            Table.States (345).Action_List.Set_Capacity (38);
            Add_Action (Table.States (345), (33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 72, 73, 74, 75,
            82, 87, 88, 89, 91, 94, 95, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110, 111), (233, 2),  2);
            Table.States (345).Kernel := To_Vector ((0 => ((233, 2),  234,  0, (233, 2),  2)));
            Table.States (345).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (233, 2),  2)));
            Table.States (346).Action_List.Set_Capacity (38);
            Add_Action (Table.States (346), (33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 72, 73, 74, 75,
            82, 87, 88, 89, 91, 94, 95, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110, 111), (233, 3),  2);
            Table.States (346).Kernel := To_Vector ((0 => ((233, 3),  234,  0, (233, 3),  2)));
            Table.States (346).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (233, 3),  2)));
            Table.States (347).Action_List.Set_Capacity (1);
            Add_Action (Table.States (347), 65, (187, 0), 609);
            Table.States (347).Kernel := To_Vector ((0 => ((187, 0),  52,  1, (32767, 0),  0)));
            Table.States (347).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (187, 0),  65, 609)));
            Table.States (348).Action_List.Set_Capacity (5);
            Add_Action (Table.States (348), 86, (252, 0), 33);
            Add_Action (Table.States (348), 90, (268, 0), 34);
            Add_Action (Table.States (348), 116, (196, 0), 146);
            Add_Action (Table.States (348), 117, (196, 1), 37);
            Add_Action (Table.States (348), 118, (195, 6), 38);
            Table.States (348).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (348), 195, 610);
            Add_Goto (Table.States (348), 196, 148);
            Add_Goto (Table.States (348), 197, 54);
            Add_Goto (Table.States (348), 198, 55);
            Add_Goto (Table.States (348), 199, 56);
            Add_Goto (Table.States (348), 201, 57);
            Add_Goto (Table.States (348), 251, 58);
            Add_Goto (Table.States (348), 252, 59);
            Add_Goto (Table.States (348), 255, 60);
            Add_Goto (Table.States (348), 268, 68);
            Add_Goto (Table.States (348), 311, 83);
            Table.States (348).Kernel := To_Vector ((0 => ((258, 0),  85,  2, (32767, 0),  0)));
            Table.States (348).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (349).Action_List.Set_Capacity (5);
            Add_Action (Table.States (349), 86, (252, 0), 33);
            Add_Action (Table.States (349), 90, (268, 0), 34);
            Add_Action (Table.States (349), 116, (196, 0), 146);
            Add_Action (Table.States (349), 117, (196, 1), 37);
            Add_Action (Table.States (349), 118, (195, 6), 38);
            Table.States (349).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (349), 195, 611);
            Add_Goto (Table.States (349), 196, 148);
            Add_Goto (Table.States (349), 197, 54);
            Add_Goto (Table.States (349), 198, 55);
            Add_Goto (Table.States (349), 199, 56);
            Add_Goto (Table.States (349), 201, 57);
            Add_Goto (Table.States (349), 251, 58);
            Add_Goto (Table.States (349), 252, 59);
            Add_Goto (Table.States (349), 255, 60);
            Add_Goto (Table.States (349), 268, 68);
            Add_Goto (Table.States (349), 311, 83);
            Table.States (349).Kernel := To_Vector ((((257, 0),  187,  1, (32767, 0),  0), ((257, 2),  187,  6, (32767,
            0),  0)));
            Table.States (349).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (350).Action_List.Set_Capacity (43);
            Add_Action (Table.States (350), 33, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 36, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 42, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 43, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 45, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 46, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 47, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 48, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 49, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 50, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 52, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 61, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 63, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 69, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 72, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 73, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 74, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 75, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 82, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 85, (162, 0), 612);
            Add_Action (Table.States (350), 87, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 88, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 89, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 91, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 94, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 95, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 96, (197, 0), 283);
            Add_Action (Table.States (350), 97, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 98, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 99, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 100, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 101, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 103, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 104, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 106, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 107, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 108, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 109, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 110, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 111, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 112, Reduce, (257, 1),  1);
            Add_Action (Table.States (350), 113, (121, 0), 285);
            Add_Action (Table.States (350), 114, (121, 1), 286);
            Table.States (350).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (350), 121, 287);
            Add_Goto (Table.States (350), 162, 613);
            Add_Goto (Table.States (350), 313, 289);
            Table.States (350).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((257, 1),  195,  0, (257, 1),  1), ((257, 3),  195,  5, (32767, 0),  0), ((311, 0),  195,
             3, (32767, 0),  0)));
            Table.States (350).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (257, 1),  1)));
            Table.States (351).Action_List.Set_Capacity (39);
            Add_Action (Table.States (351), (33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 72, 73, 74, 75,
            82, 87, 88, 89, 91, 94, 95, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110, 111, 112), (256, 1),
            2);
            Table.States (351).Kernel := To_Vector ((0 => ((256, 1),  257,  0, (256, 1),  2)));
            Table.States (351).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (256, 1),  2)));
            Table.States (352).Action_List.Set_Capacity (6);
            Add_Action (Table.States (352), 52, (187, 0), 347);
            Add_Action (Table.States (352), 86, (252, 0), 33);
            Add_Action (Table.States (352), 90, (268, 0), 34);
            Add_Action (Table.States (352), 116, (196, 0), 146);
            Add_Action (Table.States (352), 117, (196, 1), 37);
            Add_Action (Table.States (352), 118, (195, 6), 38);
            Table.States (352).Goto_List.Set_Capacity (13);
            Add_Goto (Table.States (352), 187, 349);
            Add_Goto (Table.States (352), 195, 350);
            Add_Goto (Table.States (352), 196, 148);
            Add_Goto (Table.States (352), 197, 54);
            Add_Goto (Table.States (352), 198, 55);
            Add_Goto (Table.States (352), 199, 56);
            Add_Goto (Table.States (352), 201, 57);
            Add_Goto (Table.States (352), 251, 58);
            Add_Goto (Table.States (352), 252, 59);
            Add_Goto (Table.States (352), 255, 60);
            Add_Goto (Table.States (352), 257, 614);
            Add_Goto (Table.States (352), 268, 68);
            Add_Goto (Table.States (352), 311, 83);
            Table.States (352).Kernel := To_Vector ((0 => ((256, 0),  258,  1, (32767, 0),  0)));
            Table.States (352).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (353).Action_List.Set_Capacity (4);
            Add_Action (Table.States (353), 38, (249, 1), 615);
            Add_Action (Table.States (353), 59, (347, 0), 616);
            Add_Action (Table.States (353), 60, (341, 0), 617);
            Add_Action (Table.States (353), 116, (136, 0), 618);
            Table.States (353).Goto_List.Set_Capacity (7);
            Add_Goto (Table.States (353), 135, 619);
            Add_Goto (Table.States (353), 136, 620);
            Add_Goto (Table.States (353), 250, 621);
            Add_Goto (Table.States (353), 335, 622);
            Add_Goto (Table.States (353), 341, 104);
            Add_Goto (Table.States (353), 347, 107);
            Add_Goto (Table.States (353), 460, 623);
            Table.States (353).Kernel := To_Vector ((((249, 0),  39,  5, (32767, 0),  0), ((249, 1),  39,  2, (32767,
            0),  0)));
            Table.States (353).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (249, 1),  38, 615)));
            Table.States (354).Action_List.Set_Capacity (14);
            Add_Action (Table.States (354), 12, (402, 0), 165);
            Add_Action (Table.States (354), 44, (233, 2), 167);
            Add_Action (Table.States (354), 52, (233, 3), 168);
            Add_Action (Table.States (354), 65, (234, 1), 169);
            Add_Action (Table.States (354), 76, (256, 0), 170);
            Add_Action (Table.States (354), 85, (205, 4), 171);
            Add_Action (Table.States (354), 86, (213, 2), 172);
            Add_Action (Table.States (354), 90, (268, 0), 34);
            Add_Action (Table.States (354), 106, (237, 1), 173);
            Add_Action (Table.States (354), 107, (237, 0), 174);
            Add_Action (Table.States (354), 115, (234, 0), 175);
            Add_Action (Table.States (354), 116, (196, 0), 146);
            Add_Action (Table.States (354), 117, (196, 1), 37);
            Add_Action (Table.States (354), 118, (195, 6), 38);
            Table.States (354).Goto_List.Set_Capacity (32);
            Add_Goto (Table.States (354), 195, 176);
            Add_Goto (Table.States (354), 196, 148);
            Add_Goto (Table.States (354), 197, 54);
            Add_Goto (Table.States (354), 198, 55);
            Add_Goto (Table.States (354), 199, 56);
            Add_Goto (Table.States (354), 201, 57);
            Add_Goto (Table.States (354), 205, 177);
            Add_Goto (Table.States (354), 206, 178);
            Add_Goto (Table.States (354), 210, 179);
            Add_Goto (Table.States (354), 211, 180);
            Add_Goto (Table.States (354), 213, 181);
            Add_Goto (Table.States (354), 214, 182);
            Add_Goto (Table.States (354), 215, 183);
            Add_Goto (Table.States (354), 218, 184);
            Add_Goto (Table.States (354), 219, 185);
            Add_Goto (Table.States (354), 220, 186);
            Add_Goto (Table.States (354), 227, 236);
            Add_Goto (Table.States (354), 228, 188);
            Add_Goto (Table.States (354), 231, 189);
            Add_Goto (Table.States (354), 232, 190);
            Add_Goto (Table.States (354), 233, 191);
            Add_Goto (Table.States (354), 234, 192);
            Add_Goto (Table.States (354), 237, 193);
            Add_Goto (Table.States (354), 243, 624);
            Add_Goto (Table.States (354), 251, 58);
            Add_Goto (Table.States (354), 252, 59);
            Add_Goto (Table.States (354), 255, 60);
            Add_Goto (Table.States (354), 256, 194);
            Add_Goto (Table.States (354), 268, 68);
            Add_Goto (Table.States (354), 311, 83);
            Add_Goto (Table.States (354), 402, 195);
            Add_Goto (Table.States (354), 465, 196);
            Table.States (354).Kernel := To_Vector ((((242, 0),  41,  9, (32767, 0),  0), ((242, 1),  41,  7, (32767,
            0),  0), ((242, 2),  41,  5, (32767, 0),  0), ((242, 3),  41,  3, (32767, 0),  0)));
            Table.States (354).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (355).Action_List.Set_Capacity (3);
            Add_Action (Table.States (355), 40, (248, 1), 625);
            Add_Action (Table.States (355), 55, (248, 0), 626);
            Add_Action (Table.States (355), 116, (278, 0), 454);
            Table.States (355).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (355), 248, 627);
            Add_Goto (Table.States (355), 278, 508);
            Add_Goto (Table.States (355), 280, 509);
            Table.States (355).Kernel := To_Vector ((((221, 0),  51,  7, (32767, 0),  0), ((221, 1),  51,  5, (32767,
            0),  0), ((221, 2),  51,  7, (32767, 0),  0), ((221, 3),  51,  5, (32767, 0),  0), ((247, 0),  51,  6,
            (32767, 0),  0), ((247, 1),  51,  6, (32767, 0),  0)));
            Table.States (355).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (278, 0),  116, 454)));
            Table.States (356).Action_List.Set_Capacity (9);
            Add_Action (Table.States (356), 65, (187, 0), 628);
            Add_Action (Table.States (356), 76, (256, 0), 170);
            Add_Action (Table.States (356), 85, (205, 4), 171);
            Add_Action (Table.States (356), 86, (213, 2), 172);
            Add_Action (Table.States (356), 90, (268, 0), 34);
            Add_Action (Table.States (356), 115, (234, 0), 175);
            Add_Action (Table.States (356), 116, (196, 0), 146);
            Add_Action (Table.States (356), 117, (196, 1), 37);
            Add_Action (Table.States (356), 118, (195, 6), 38);
            Table.States (356).Goto_List.Set_Capacity (23);
            Add_Goto (Table.States (356), 195, 176);
            Add_Goto (Table.States (356), 196, 148);
            Add_Goto (Table.States (356), 197, 54);
            Add_Goto (Table.States (356), 198, 55);
            Add_Goto (Table.States (356), 199, 56);
            Add_Goto (Table.States (356), 201, 57);
            Add_Goto (Table.States (356), 205, 177);
            Add_Goto (Table.States (356), 206, 178);
            Add_Goto (Table.States (356), 210, 179);
            Add_Goto (Table.States (356), 211, 180);
            Add_Goto (Table.States (356), 213, 181);
            Add_Goto (Table.States (356), 214, 182);
            Add_Goto (Table.States (356), 215, 183);
            Add_Goto (Table.States (356), 218, 184);
            Add_Goto (Table.States (356), 219, 185);
            Add_Goto (Table.States (356), 220, 186);
            Add_Goto (Table.States (356), 234, 346);
            Add_Goto (Table.States (356), 251, 58);
            Add_Goto (Table.States (356), 252, 59);
            Add_Goto (Table.States (356), 255, 60);
            Add_Goto (Table.States (356), 256, 194);
            Add_Goto (Table.States (356), 268, 68);
            Add_Goto (Table.States (356), 311, 83);
            Table.States (356).Kernel := To_Vector ((((187, 0),  52,  1, (32767, 0),  0), ((233, 3),  52,  1, (32767,
            0),  0)));
            Table.States (356).Minimal_Complete_Actions := To_Vector (((Shift, (187, 0),  65, 628), (Shift, (234, 0),
            115, 175)));
            Table.States (357).Action_List.Set_Capacity (2);
            Add_Action (Table.States (357), 91, Reduce, (178, 3),  1);
            Add_Conflict (Table.States (357), 91, (200, 2),  1);
            Add_Action (Table.States (357), 99, Reduce, (178, 3),  1);
            Add_Conflict (Table.States (357), 99, (200, 2),  1);
            Table.States (357).Kernel := To_Vector ((((178, 3),  62,  0, (178, 3),  1), ((200, 2),  62,  0, (200, 2),
            1)));
            Table.States (357).Minimal_Complete_Actions := To_Vector (((Reduce, (178, 3),  1), (Reduce, (200, 2),
            1)));
            Table.States (358).Action_List.Set_Capacity (14);
            Add_Action (Table.States (358), 12, (402, 0), 165);
            Add_Action (Table.States (358), 44, (233, 2), 167);
            Add_Action (Table.States (358), 52, (233, 3), 168);
            Add_Action (Table.States (358), 65, (234, 1), 169);
            Add_Action (Table.States (358), 76, (256, 0), 170);
            Add_Action (Table.States (358), 85, (205, 4), 171);
            Add_Action (Table.States (358), 86, (213, 2), 172);
            Add_Action (Table.States (358), 90, (268, 0), 34);
            Add_Action (Table.States (358), 106, (237, 1), 173);
            Add_Action (Table.States (358), 107, (237, 0), 174);
            Add_Action (Table.States (358), 115, (234, 0), 175);
            Add_Action (Table.States (358), 116, (196, 0), 146);
            Add_Action (Table.States (358), 117, (196, 1), 37);
            Add_Action (Table.States (358), 118, (195, 6), 38);
            Table.States (358).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (358), 195, 176);
            Add_Goto (Table.States (358), 196, 148);
            Add_Goto (Table.States (358), 197, 54);
            Add_Goto (Table.States (358), 198, 55);
            Add_Goto (Table.States (358), 199, 56);
            Add_Goto (Table.States (358), 201, 57);
            Add_Goto (Table.States (358), 205, 177);
            Add_Goto (Table.States (358), 206, 178);
            Add_Goto (Table.States (358), 210, 179);
            Add_Goto (Table.States (358), 211, 180);
            Add_Goto (Table.States (358), 213, 181);
            Add_Goto (Table.States (358), 214, 182);
            Add_Goto (Table.States (358), 215, 183);
            Add_Goto (Table.States (358), 218, 184);
            Add_Goto (Table.States (358), 219, 185);
            Add_Goto (Table.States (358), 220, 186);
            Add_Goto (Table.States (358), 227, 629);
            Add_Goto (Table.States (358), 228, 188);
            Add_Goto (Table.States (358), 231, 189);
            Add_Goto (Table.States (358), 232, 190);
            Add_Goto (Table.States (358), 233, 191);
            Add_Goto (Table.States (358), 234, 192);
            Add_Goto (Table.States (358), 237, 193);
            Add_Goto (Table.States (358), 251, 58);
            Add_Goto (Table.States (358), 252, 59);
            Add_Goto (Table.States (358), 255, 60);
            Add_Goto (Table.States (358), 256, 194);
            Add_Goto (Table.States (358), 268, 68);
            Add_Goto (Table.States (358), 311, 83);
            Add_Goto (Table.States (358), 402, 195);
            Add_Goto (Table.States (358), 465, 196);
            Table.States (358).Kernel := To_Vector ((0 => ((245, 0),  64,  6, (32767, 0),  0)));
            Table.States (358).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
         end Subr_14;
         procedure Subr_15
         is begin
            Table.States (359).Action_List.Set_Capacity (26);
            Add_Action (Table.States (359), 43, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 45, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 46, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 48, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 52, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 61, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 67, (207, 1), 630);
            Add_Action (Table.States (359), 73, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 75, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 87, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 89, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 91, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 95, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 97, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 98, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 99, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 100, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 101, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 103, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 104, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 106, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 107, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 109, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 110, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 111, Reduce, (234, 1),  1);
            Add_Action (Table.States (359), 112, Reduce, (234, 1),  1);
            Table.States (359).Kernel := To_Vector ((((207, 1),  65,  1, (32767, 0),  0), ((234, 1),  65,  0, (234, 1),
             1)));
            Table.States (359).Minimal_Complete_Actions := To_Vector (((Shift, (207, 1),  67, 630), (Reduce, (234, 1),
            1)));
            Table.States (360).Action_List.Set_Capacity (32);
            Add_Action (Table.States (360), 43, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 45, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 46, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 48, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 52, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 61, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 71, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 72, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 73, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 74, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 75, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 85, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 87, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 89, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 91, Reduce, (195, 6),  1);
            Add_Conflict (Table.States (360), 91, (200, 1),  1);
            Add_Action (Table.States (360), 95, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 96, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 97, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 98, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 99, Reduce, (195, 6),  1);
            Add_Conflict (Table.States (360), 99, (200, 1),  1);
            Add_Action (Table.States (360), 100, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 101, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 103, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 104, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 106, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 107, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 109, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 110, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 111, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 112, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 113, Reduce, (195, 6),  1);
            Add_Action (Table.States (360), 114, Reduce, (195, 6),  1);
            Table.States (360).Kernel := To_Vector ((((195, 6),  118,  0, (195, 6),  1), ((200, 1),  118,  0, (200, 1),
             1)));
            Table.States (360).Minimal_Complete_Actions := To_Vector (((Reduce, (195, 6),  1), (Reduce, (200, 1),
            1)));
            Table.States (361).Action_List.Set_Capacity (2);
            Add_Action (Table.States (361), (91, 99), (178, 1),  1);
            Table.States (361).Kernel := To_Vector ((0 => ((178, 1),  131,  0, (178, 1),  1)));
            Table.States (361).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (178, 1),  1)));
            Table.States (362).Action_List.Set_Capacity (2);
            Add_Action (Table.States (362), (91, 99), (178, 2),  1);
            Table.States (362).Kernel := To_Vector ((0 => ((178, 2),  140,  0, (178, 2),  1)));
            Table.States (362).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (178, 2),  1)));
            Table.States (363).Action_List.Set_Capacity (2);
            Add_Action (Table.States (363), 91, (177, 1), 631);
            Add_Action (Table.States (363), 99, (314, 0), 632);
            Table.States (363).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (363), 314, 633);
            Table.States (363).Kernel := To_Vector ((((177, 1),  177,  2, (32767, 0),  0), ((217, 0),  177,  2, (32767,
            0),  0)));
            Table.States (364).Action_List.Set_Capacity (2);
            Add_Action (Table.States (364), (91, 99), (177, 0),  1);
            Table.States (364).Kernel := To_Vector ((0 => ((177, 0),  178,  0, (177, 0),  1)));
            Table.States (364).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (177, 0),  1)));
            Table.States (365).Action_List.Set_Capacity (5);
            Add_Action (Table.States (365), 86, (252, 0), 33);
            Add_Action (Table.States (365), 90, (268, 0), 34);
            Add_Action (Table.States (365), 116, (196, 0), 146);
            Add_Action (Table.States (365), 117, (196, 1), 37);
            Add_Action (Table.States (365), 118, (195, 6), 38);
            Table.States (365).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (365), 195, 634);
            Add_Goto (Table.States (365), 196, 148);
            Add_Goto (Table.States (365), 197, 54);
            Add_Goto (Table.States (365), 198, 55);
            Add_Goto (Table.States (365), 199, 56);
            Add_Goto (Table.States (365), 201, 57);
            Add_Goto (Table.States (365), 251, 58);
            Add_Goto (Table.States (365), 252, 59);
            Add_Goto (Table.States (365), 255, 60);
            Add_Goto (Table.States (365), 268, 68);
            Add_Goto (Table.States (365), 311, 83);
            Table.States (365).Kernel := To_Vector ((((131, 0),  187,  3, (32767, 0),  0), ((131, 1),  187,  1, (32767,
            0),  0)));
            Table.States (365).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (366).Action_List.Set_Capacity (33);
            Add_Action (Table.States (366), 43, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 45, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 46, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 48, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 52, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 61, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 71, (453, 0), 635);
            Add_Action (Table.States (366), 72, (153, 0), 636);
            Add_Action (Table.States (366), 73, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 74, (139, 0), 637);
            Add_Action (Table.States (366), 75, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 85, (162, 0), 612);
            Add_Action (Table.States (366), 87, Reduce, (131, 3),  1);
            Add_Conflict (Table.States (366), 87, (234, 3),  1);
            Add_Action (Table.States (366), 88, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 89, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 91, Reduce, (131, 3),  1);
            Add_Conflict (Table.States (366), 91, (234, 3),  1);
            Add_Action (Table.States (366), 95, Reduce, (131, 3),  1);
            Add_Conflict (Table.States (366), 95, (234, 3),  1);
            Add_Action (Table.States (366), 96, (197, 0), 283);
            Add_Action (Table.States (366), 97, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 98, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 99, Reduce, (131, 3),  1);
            Add_Conflict (Table.States (366), 99, (234, 3),  1);
            Add_Action (Table.States (366), 100, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 101, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 103, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 104, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 106, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 107, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 109, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 110, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 111, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 112, Reduce, (234, 3),  1);
            Add_Action (Table.States (366), 113, (121, 0), 285);
            Add_Action (Table.States (366), 114, (121, 1), 286);
            Table.States (366).Goto_List.Set_Capacity (8);
            Add_Goto (Table.States (366), 121, 638);
            Add_Goto (Table.States (366), 132, 639);
            Add_Goto (Table.States (366), 133, 640);
            Add_Goto (Table.States (366), 139, 641);
            Add_Goto (Table.States (366), 153, 642);
            Add_Goto (Table.States (366), 162, 643);
            Add_Goto (Table.States (366), 313, 289);
            Add_Goto (Table.States (366), 453, 644);
            Table.States (366).Kernel := To_Vector ((((131, 2),  195,  2, (32767, 0),  0), ((131, 3),  195,  0, (131,
            3),  1), ((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767, 0),  0), ((199, 0),  195,  2,
            (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((203, 0),  195,  2, (32767, 0),  0), ((234, 3),
            195,  0, (234, 3),  1), ((255, 0),  195,  3, (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0)));
            Table.States (366).Minimal_Complete_Actions := To_Vector (((Reduce, (131, 3),  1), (Reduce, (234, 3),
            1)));
            Table.States (367).Action_List.Set_Capacity (32);
            Add_Action (Table.States (367), 43, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 45, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 46, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 48, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 52, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 61, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 71, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 72, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 73, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 74, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 75, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 85, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 87, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 89, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 91, Reduce, (195, 0),  1);
            Add_Conflict (Table.States (367), 91, (200, 0),  1);
            Add_Action (Table.States (367), 95, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 96, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 97, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 98, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 99, Reduce, (195, 0),  1);
            Add_Conflict (Table.States (367), 99, (200, 0),  1);
            Add_Action (Table.States (367), 100, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 101, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 103, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 104, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 106, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 107, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 109, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 110, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 111, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 112, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 113, Reduce, (195, 0),  1);
            Add_Action (Table.States (367), 114, Reduce, (195, 0),  1);
            Table.States (367).Kernel := To_Vector ((((195, 0),  196,  0, (195, 0),  1), ((200, 0),  196,  0, (200, 0),
             1)));
            Table.States (367).Minimal_Complete_Actions := To_Vector (((Reduce, (195, 0),  1), (Reduce, (200, 0),
            1)));
            Table.States (368).Action_List.Set_Capacity (2);
            Add_Action (Table.States (368), (91, 99), (209, 0),  1);
            Table.States (368).Kernel := To_Vector ((0 => ((209, 0),  200,  0, (209, 0),  1)));
            Table.States (368).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (209, 0),  1)));
            Table.States (369).Action_List.Set_Capacity (23);
            Add_Action (Table.States (369), (33, 36, 42, 45, 46, 47, 48, 49, 50, 61, 63, 69, 72, 74, 75, 82, 87, 88,
            91, 94, 95, 99, 108), (140, 0),  1);
            Table.States (369).Kernel := To_Vector ((0 => ((140, 0),  203,  0, (140, 0),  1)));
            Table.States (369).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (140, 0),  1)));
            Table.States (370).Action_List.Set_Capacity (1);
            Add_Action (Table.States (370), 87, (206, 0), 645);
            Table.States (370).Kernel := To_Vector ((0 => ((206, 0),  207,  1, (32767, 0),  0)));
            Table.States (370).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (206, 0),  87, 645)));
            Table.States (371).Action_List.Set_Capacity (2);
            Add_Action (Table.States (371), (87, 95), (459, 0),  1);
            Table.States (371).Kernel := To_Vector ((0 => ((459, 0),  208,  0, (459, 0),  1)));
            Table.States (371).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (459, 0),  1)));
            Table.States (372).Action_List.Set_Capacity (2);
            Add_Action (Table.States (372), 91, (209, 1), 646);
            Add_Action (Table.States (372), 99, (314, 0), 632);
            Table.States (372).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (372), 314, 647);
            Table.States (372).Kernel := To_Vector ((((208, 0),  209,  2, (32767, 0),  0), ((209, 1),  209,  2, (32767,
            0),  0)));
            Table.States (372).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (314, 0),  99, 632)));
            Table.States (373).Action_List.Set_Capacity (2);
            Add_Action (Table.States (373), 87, (213, 0), 648);
            Add_Action (Table.States (373), 95, (212, 1), 649);
            Table.States (373).Kernel := To_Vector ((((212, 1),  212,  2, (32767, 0),  0), ((213, 0),  212,  1, (32767,
            0),  0), ((213, 1),  212,  5, (32767, 0),  0)));
            Table.States (373).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (213, 0),  87, 648)));
            Table.States (374).Action_List.Set_Capacity (2);
            Add_Action (Table.States (374), 87, (215, 0), 650);
            Add_Action (Table.States (374), 95, (216, 1), 651);
            Table.States (374).Kernel := To_Vector ((((215, 0),  216,  1, (32767, 0),  0), ((216, 1),  216,  4, (32767,
            0),  0), ((216, 2),  216,  4, (32767, 0),  0)));
            Table.States (374).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (215, 0),  87, 650)));
            Table.States (375).Action_List.Set_Capacity (3);
            Add_Action (Table.States (375), (87, 88, 95), (216, 0),  1);
            Table.States (375).Kernel := To_Vector ((0 => ((216, 0),  217,  0, (216, 0),  1)));
            Table.States (375).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (216, 0),  1)));
            Table.States (376).Action_List.Set_Capacity (3);
            Add_Action (Table.States (376), (87, 88, 95), (217, 1),  1);
            Table.States (376).Kernel := To_Vector ((0 => ((217, 1),  221,  0, (217, 1),  1)));
            Table.States (376).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (217, 1),  1)));
            Table.States (377).Action_List.Set_Capacity (5);
            Add_Action (Table.States (377), 61, (210, 0), 652);
            Add_Action (Table.States (377), 87, Reduce, (208, 1),  1);
            Add_Conflict (Table.States (377), 87, (212, 0),  1);
            Add_Action (Table.States (377), 91, Reduce, (178, 0),  1);
            Add_Action (Table.States (377), 95, Reduce, (208, 1),  1);
            Add_Conflict (Table.States (377), 95, (212, 0),  1);
            Add_Action (Table.States (377), 99, Reduce, (178, 0),  1);
            Table.States (377).Kernel := To_Vector ((((178, 0),  227,  0, (178, 0),  1), ((208, 1),  227,  0, (208, 1),
             1), ((210, 0),  227,  4, (32767, 0),  0), ((212, 0),  227,  0, (212, 0),  1), ((219, 0),  227,  5, (32767,
            0),  0), ((220, 0),  227,  6, (32767, 0),  0)));
            Table.States (377).Minimal_Complete_Actions := To_Vector (((Reduce, (178, 0),  1), (Reduce, (208, 1),  1),
            (Shift, (210, 0),  61, 652), (Reduce, (212, 0),  1)));
            Table.States (378).Action_List.Set_Capacity (18);
            Add_Action (Table.States (378), 45, (228, 3), 400);
            Add_Action (Table.States (378), 46, Reduce, (228, 1),  1);
            Add_Action (Table.States (378), 48, Reduce, (228, 1),  1);
            Add_Action (Table.States (378), 52, (228, 2), 401);
            Add_Action (Table.States (378), 61, Reduce, (228, 1),  1);
            Add_Action (Table.States (378), 75, Reduce, (228, 1),  1);
            Add_Action (Table.States (378), 87, Reduce, (228, 1),  1);
            Add_Action (Table.States (378), 88, Reduce, (228, 1),  1);
            Add_Action (Table.States (378), 91, Reduce, (228, 1),  1);
            Add_Action (Table.States (378), 95, Reduce, (228, 1),  1);
            Add_Action (Table.States (378), 97, (140, 1), 653);
            Add_Action (Table.States (378), 98, (235, 0), 402);
            Add_Action (Table.States (378), 99, Reduce, (228, 1),  1);
            Add_Action (Table.States (378), 100, (235, 4), 403);
            Add_Action (Table.States (378), 101, (235, 5), 404);
            Add_Action (Table.States (378), 103, (235, 2), 405);
            Add_Action (Table.States (378), 104, (235, 3), 406);
            Add_Action (Table.States (378), 110, (235, 1), 407);
            Table.States (378).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (378), 235, 408);
            Table.States (378).Kernel := To_Vector ((((140, 1),  231,  2, (32767, 0),  0), ((228, 0),  231,  2, (32767,
            0),  0), ((228, 1),  231,  0, (228, 1),  1), ((228, 2),  231,  3, (32767, 0),  0), ((228, 3),  231,  2,
            (32767, 0),  0)));
            Table.States (378).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (228, 1),  1)));
            Table.States (379).Action_List.Set_Capacity (1);
            Add_Action (Table.States (379), 87, (205, 4), 654);
            Table.States (379).Kernel := To_Vector ((0 => ((205, 4),  239,  1, (32767, 0),  0)));
            Table.States (379).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (205, 4),  87, 654)));
            Table.States (380).Action_List.Set_Capacity (1);
            Add_Action (Table.States (380), (1 =>  87), (239, 0),  1);
            Table.States (380).Kernel := To_Vector ((0 => ((239, 0),  242,  0, (239, 0),  1)));
            Table.States (380).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (239, 0),  1)));
            Table.States (381).Action_List.Set_Capacity (1);
            Add_Action (Table.States (381), (1 =>  87), (239, 1),  1);
            Table.States (381).Kernel := To_Vector ((0 => ((239, 1),  245,  0, (239, 1),  1)));
            Table.States (381).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (239, 1),  1)));
            Table.States (382).Action_List.Set_Capacity (1);
            Add_Action (Table.States (382), 87, (205, 5), 655);
            Table.States (382).Kernel := To_Vector ((0 => ((205, 5),  247,  1, (32767, 0),  0)));
            Table.States (382).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (205, 5),  87, 655)));
            Table.States (383).Action_List.Set_Capacity (1);
            Add_Action (Table.States (383), 87, (205, 6), 656);
            Table.States (383).Kernel := To_Vector ((0 => ((205, 6),  249,  1, (32767, 0),  0)));
            Table.States (383).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (205, 6),  87, 656)));
            Table.States (384).Action_List.Set_Capacity (2);
            Add_Action (Table.States (384), 87, Reduce, (207, 0),  1);
            Add_Action (Table.States (384), 95, (459, 1), 657);
            Table.States (384).Kernel := To_Vector ((((207, 0),  459,  0, (207, 0),  1), ((459, 1),  459,  2, (32767,
            0),  0), ((459, 2),  459,  4, (32767, 0),  0)));
            Table.States (384).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (207, 0),  1)));
            Table.States (385).Action_List.Set_Capacity (2);
            Add_Action (Table.States (385), (91, 99), (178, 3),  1);
            Table.States (385).Kernel := To_Vector ((0 => ((178, 3),  62,  0, (178, 3),  1)));
            Table.States (385).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (178, 3),  1)));
         end Subr_15;
         procedure Subr_16
         is begin
            Table.States (386).Action_List.Set_Capacity (47);
            Add_Action (Table.States (386), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (214, 0),  2);
            Table.States (386).Kernel := To_Vector ((0 => ((214, 0),  88,  0, (214, 0),  2)));
            Table.States (386).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (214, 0),  2)));
            Table.States (387).Action_List.Set_Capacity (2);
            Add_Action (Table.States (387), 88, (213, 3), 658);
            Add_Action (Table.States (387), 95, (212, 1), 659);
            Table.States (387).Kernel := To_Vector ((((212, 1),  212,  2, (32767, 0),  0), ((213, 2),  212,  5, (32767,
            0),  0), ((213, 3),  212,  1, (32767, 0),  0)));
            Table.States (387).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (213, 3),  88, 658)));
            Table.States (388).Action_List.Set_Capacity (2);
            Add_Action (Table.States (388), 88, (215, 1), 660);
            Add_Action (Table.States (388), 95, (216, 1), 651);
            Table.States (388).Kernel := To_Vector ((((215, 1),  216,  1, (32767, 0),  0), ((216, 1),  216,  4, (32767,
            0),  0), ((216, 2),  216,  4, (32767, 0),  0)));
            Table.States (388).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (215, 1),  88, 660)));
            Table.States (389).Action_List.Set_Capacity (2);
            Add_Action (Table.States (389), 88, (252, 2), 510);
            Add_Conflict (Table.States (389), 88, (217, 1),  1);
            Add_Action (Table.States (389), 95, Reduce, (217, 1),  1);
            Table.States (389).Kernel := To_Vector ((((217, 1),  221,  0, (217, 1),  1), ((252, 2),  221,  1, (32767,
            0),  0)));
            Table.States (389).Minimal_Complete_Actions := To_Vector (((Reduce, (217, 1),  1), (Shift, (252, 2),  88,
            510)));
            Table.States (390).Action_List.Set_Capacity (5);
            Add_Action (Table.States (390), 61, (220, 1), 661);
            Add_Action (Table.States (390), 88, Reduce, (212, 0),  1);
            Add_Action (Table.States (390), 91, Reduce, (178, 0),  1);
            Add_Action (Table.States (390), 95, Reduce, (212, 0),  1);
            Add_Action (Table.States (390), 99, Reduce, (178, 0),  1);
            Table.States (390).Kernel := To_Vector ((((178, 0),  227,  0, (178, 0),  1), ((212, 0),  227,  0, (212, 0),
             1), ((220, 1),  227,  6, (32767, 0),  0)));
            Table.States (390).Minimal_Complete_Actions := To_Vector (((Reduce, (178, 0),  1), (Reduce, (212, 0),  1),
            (Shift, (220, 1),  61, 661)));
            Table.States (391).Action_List.Set_Capacity (50);
            Add_Action (Table.States (391), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (366, 0),  3);
            Table.States (391).Kernel := To_Vector ((0 => ((366, 0),  108,  0, (366, 0),  3)));
            Table.States (391).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (366, 0),  3)));
            Table.States (392).Action_List.Set_Capacity (14);
            Add_Action (Table.States (392), 12, (402, 0), 165);
            Add_Action (Table.States (392), 44, (233, 2), 167);
            Add_Action (Table.States (392), 52, (233, 3), 168);
            Add_Action (Table.States (392), 65, (234, 1), 169);
            Add_Action (Table.States (392), 76, (256, 0), 170);
            Add_Action (Table.States (392), 85, (205, 4), 171);
            Add_Action (Table.States (392), 86, (213, 2), 172);
            Add_Action (Table.States (392), 90, (268, 0), 34);
            Add_Action (Table.States (392), 106, (237, 1), 173);
            Add_Action (Table.States (392), 107, (237, 0), 174);
            Add_Action (Table.States (392), 115, (234, 0), 175);
            Add_Action (Table.States (392), 116, (196, 0), 146);
            Add_Action (Table.States (392), 117, (196, 1), 37);
            Add_Action (Table.States (392), 118, (195, 6), 38);
            Table.States (392).Goto_List.Set_Capacity (30);
            Add_Goto (Table.States (392), 195, 176);
            Add_Goto (Table.States (392), 196, 148);
            Add_Goto (Table.States (392), 197, 54);
            Add_Goto (Table.States (392), 198, 55);
            Add_Goto (Table.States (392), 199, 56);
            Add_Goto (Table.States (392), 201, 57);
            Add_Goto (Table.States (392), 205, 177);
            Add_Goto (Table.States (392), 206, 178);
            Add_Goto (Table.States (392), 210, 179);
            Add_Goto (Table.States (392), 211, 180);
            Add_Goto (Table.States (392), 213, 181);
            Add_Goto (Table.States (392), 214, 182);
            Add_Goto (Table.States (392), 215, 183);
            Add_Goto (Table.States (392), 218, 184);
            Add_Goto (Table.States (392), 219, 185);
            Add_Goto (Table.States (392), 220, 186);
            Add_Goto (Table.States (392), 228, 662);
            Add_Goto (Table.States (392), 231, 189);
            Add_Goto (Table.States (392), 232, 190);
            Add_Goto (Table.States (392), 233, 191);
            Add_Goto (Table.States (392), 234, 192);
            Add_Goto (Table.States (392), 237, 193);
            Add_Goto (Table.States (392), 251, 58);
            Add_Goto (Table.States (392), 252, 59);
            Add_Goto (Table.States (392), 255, 60);
            Add_Goto (Table.States (392), 256, 194);
            Add_Goto (Table.States (392), 268, 68);
            Add_Goto (Table.States (392), 311, 83);
            Add_Goto (Table.States (392), 402, 195);
            Add_Goto (Table.States (392), 465, 196);
            Table.States (392).Kernel := To_Vector ((0 => ((226, 0),  46,  1, (32767, 0),  0)));
            Table.States (392).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (393).Action_List.Set_Capacity (15);
            Add_Action (Table.States (393), 12, (402, 0), 165);
            Add_Action (Table.States (393), 44, (233, 2), 167);
            Add_Action (Table.States (393), 47, (225, 0), 663);
            Add_Action (Table.States (393), 52, (233, 3), 168);
            Add_Action (Table.States (393), 65, (234, 1), 169);
            Add_Action (Table.States (393), 76, (256, 0), 170);
            Add_Action (Table.States (393), 85, (205, 4), 171);
            Add_Action (Table.States (393), 86, (213, 2), 172);
            Add_Action (Table.States (393), 90, (268, 0), 34);
            Add_Action (Table.States (393), 106, (237, 1), 173);
            Add_Action (Table.States (393), 107, (237, 0), 174);
            Add_Action (Table.States (393), 115, (234, 0), 175);
            Add_Action (Table.States (393), 116, (196, 0), 146);
            Add_Action (Table.States (393), 117, (196, 1), 37);
            Add_Action (Table.States (393), 118, (195, 6), 38);
            Table.States (393).Goto_List.Set_Capacity (30);
            Add_Goto (Table.States (393), 195, 176);
            Add_Goto (Table.States (393), 196, 148);
            Add_Goto (Table.States (393), 197, 54);
            Add_Goto (Table.States (393), 198, 55);
            Add_Goto (Table.States (393), 199, 56);
            Add_Goto (Table.States (393), 201, 57);
            Add_Goto (Table.States (393), 205, 177);
            Add_Goto (Table.States (393), 206, 178);
            Add_Goto (Table.States (393), 210, 179);
            Add_Goto (Table.States (393), 211, 180);
            Add_Goto (Table.States (393), 213, 181);
            Add_Goto (Table.States (393), 214, 182);
            Add_Goto (Table.States (393), 215, 183);
            Add_Goto (Table.States (393), 218, 184);
            Add_Goto (Table.States (393), 219, 185);
            Add_Goto (Table.States (393), 220, 186);
            Add_Goto (Table.States (393), 228, 664);
            Add_Goto (Table.States (393), 231, 189);
            Add_Goto (Table.States (393), 232, 190);
            Add_Goto (Table.States (393), 233, 191);
            Add_Goto (Table.States (393), 234, 192);
            Add_Goto (Table.States (393), 237, 193);
            Add_Goto (Table.States (393), 251, 58);
            Add_Goto (Table.States (393), 252, 59);
            Add_Goto (Table.States (393), 255, 60);
            Add_Goto (Table.States (393), 256, 194);
            Add_Goto (Table.States (393), 268, 68);
            Add_Goto (Table.States (393), 311, 83);
            Add_Goto (Table.States (393), 402, 195);
            Add_Goto (Table.States (393), 465, 196);
            Table.States (393).Kernel := To_Vector ((((224, 0),  48,  1, (32767, 0),  0), ((225, 0),  48,  2, (32767,
            0),  0)));
            Table.States (393).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (394).Action_List.Set_Capacity (15);
            Add_Action (Table.States (394), 12, (402, 0), 165);
            Add_Action (Table.States (394), 44, (233, 2), 167);
            Add_Action (Table.States (394), 49, (223, 0), 665);
            Add_Action (Table.States (394), 52, (233, 3), 168);
            Add_Action (Table.States (394), 65, (234, 1), 169);
            Add_Action (Table.States (394), 76, (256, 0), 170);
            Add_Action (Table.States (394), 85, (205, 4), 171);
            Add_Action (Table.States (394), 86, (213, 2), 172);
            Add_Action (Table.States (394), 90, (268, 0), 34);
            Add_Action (Table.States (394), 106, (237, 1), 173);
            Add_Action (Table.States (394), 107, (237, 0), 174);
            Add_Action (Table.States (394), 115, (234, 0), 175);
            Add_Action (Table.States (394), 116, (196, 0), 146);
            Add_Action (Table.States (394), 117, (196, 1), 37);
            Add_Action (Table.States (394), 118, (195, 6), 38);
            Table.States (394).Goto_List.Set_Capacity (30);
            Add_Goto (Table.States (394), 195, 176);
            Add_Goto (Table.States (394), 196, 148);
            Add_Goto (Table.States (394), 197, 54);
            Add_Goto (Table.States (394), 198, 55);
            Add_Goto (Table.States (394), 199, 56);
            Add_Goto (Table.States (394), 201, 57);
            Add_Goto (Table.States (394), 205, 177);
            Add_Goto (Table.States (394), 206, 178);
            Add_Goto (Table.States (394), 210, 179);
            Add_Goto (Table.States (394), 211, 180);
            Add_Goto (Table.States (394), 213, 181);
            Add_Goto (Table.States (394), 214, 182);
            Add_Goto (Table.States (394), 215, 183);
            Add_Goto (Table.States (394), 218, 184);
            Add_Goto (Table.States (394), 219, 185);
            Add_Goto (Table.States (394), 220, 186);
            Add_Goto (Table.States (394), 228, 666);
            Add_Goto (Table.States (394), 231, 189);
            Add_Goto (Table.States (394), 232, 190);
            Add_Goto (Table.States (394), 233, 191);
            Add_Goto (Table.States (394), 234, 192);
            Add_Goto (Table.States (394), 237, 193);
            Add_Goto (Table.States (394), 251, 58);
            Add_Goto (Table.States (394), 252, 59);
            Add_Goto (Table.States (394), 255, 60);
            Add_Goto (Table.States (394), 256, 194);
            Add_Goto (Table.States (394), 268, 68);
            Add_Goto (Table.States (394), 311, 83);
            Add_Goto (Table.States (394), 402, 195);
            Add_Goto (Table.States (394), 465, 196);
            Table.States (394).Kernel := To_Vector ((((222, 0),  75,  1, (32767, 0),  0), ((223, 0),  75,  2, (32767,
            0),  0)));
            Table.States (394).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (395).Action_List.Set_Capacity (18);
            Add_Action (Table.States (395), 33, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 36, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 42, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 47, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 49, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 50, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 61, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 63, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 72, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 74, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 75, (222, 1), 667);
            Add_Action (Table.States (395), 82, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 87, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 88, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 91, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 95, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 99, Reduce, (227, 1),  2);
            Add_Action (Table.States (395), 108, Reduce, (227, 1),  2);
            Table.States (395).Kernel := To_Vector ((((222, 1),  222,  2, (32767, 0),  0), ((227, 1),  222,  0, (227,
            1),  2)));
            Table.States (395).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (227, 1),  2)));
            Table.States (396).Action_List.Set_Capacity (18);
            Add_Action (Table.States (396), 33, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 36, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 42, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 47, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 49, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 50, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 61, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 63, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 72, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 74, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 75, (223, 1), 668);
            Add_Action (Table.States (396), 82, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 87, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 88, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 91, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 95, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 99, Reduce, (227, 2),  2);
            Add_Action (Table.States (396), 108, Reduce, (227, 2),  2);
            Table.States (396).Kernel := To_Vector ((((223, 1),  223,  3, (32767, 0),  0), ((227, 2),  223,  0, (227,
            2),  2)));
            Table.States (396).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (227, 2),  2)));
            Table.States (397).Action_List.Set_Capacity (18);
            Add_Action (Table.States (397), 33, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 36, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 42, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 47, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 48, (224, 1), 669);
            Add_Action (Table.States (397), 49, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 50, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 61, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 63, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 72, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 74, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 82, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 87, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 88, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 91, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 95, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 99, Reduce, (227, 3),  2);
            Add_Action (Table.States (397), 108, Reduce, (227, 3),  2);
            Table.States (397).Kernel := To_Vector ((((224, 1),  224,  2, (32767, 0),  0), ((227, 3),  224,  0, (227,
            3),  2)));
            Table.States (397).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (227, 3),  2)));
            Table.States (398).Action_List.Set_Capacity (18);
            Add_Action (Table.States (398), 33, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 36, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 42, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 47, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 48, (225, 1), 670);
            Add_Action (Table.States (398), 49, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 50, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 61, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 63, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 72, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 74, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 82, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 87, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 88, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 91, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 95, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 99, Reduce, (227, 4),  2);
            Add_Action (Table.States (398), 108, Reduce, (227, 4),  2);
            Table.States (398).Kernel := To_Vector ((((225, 1),  225,  3, (32767, 0),  0), ((227, 4),  225,  0, (227,
            4),  2)));
            Table.States (398).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (227, 4),  2)));
            Table.States (399).Action_List.Set_Capacity (18);
            Add_Action (Table.States (399), 33, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 36, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 42, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 46, (226, 1), 671);
            Add_Action (Table.States (399), 47, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 49, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 50, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 61, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 63, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 72, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 74, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 82, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 87, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 88, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 91, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 95, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 99, Reduce, (227, 5),  2);
            Add_Action (Table.States (399), 108, Reduce, (227, 5),  2);
            Table.States (399).Kernel := To_Vector ((((226, 1),  226,  2, (32767, 0),  0), ((227, 5),  226,  0, (227,
            5),  2)));
            Table.States (399).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (227, 5),  2)));
            Table.States (400).Action_List.Set_Capacity (13);
            Add_Action (Table.States (400), 44, (233, 2), 167);
            Add_Action (Table.States (400), 52, (233, 3), 168);
            Add_Action (Table.States (400), 65, (234, 1), 169);
            Add_Action (Table.States (400), 76, (256, 0), 170);
            Add_Action (Table.States (400), 85, (205, 4), 171);
            Add_Action (Table.States (400), 86, (213, 2), 172);
            Add_Action (Table.States (400), 90, (268, 0), 34);
            Add_Action (Table.States (400), 106, (237, 1), 173);
            Add_Action (Table.States (400), 107, (237, 0), 174);
            Add_Action (Table.States (400), 115, (234, 0), 175);
            Add_Action (Table.States (400), 116, (196, 0), 146);
            Add_Action (Table.States (400), 117, (196, 1), 37);
            Add_Action (Table.States (400), 118, (195, 6), 38);
            Table.States (400).Goto_List.Set_Capacity (32);
            Add_Goto (Table.States (400), 140, 672);
            Add_Goto (Table.States (400), 195, 673);
            Add_Goto (Table.States (400), 196, 148);
            Add_Goto (Table.States (400), 197, 54);
            Add_Goto (Table.States (400), 198, 55);
            Add_Goto (Table.States (400), 199, 56);
            Add_Goto (Table.States (400), 201, 57);
            Add_Goto (Table.States (400), 203, 369);
            Add_Goto (Table.States (400), 205, 177);
            Add_Goto (Table.States (400), 206, 178);
            Add_Goto (Table.States (400), 210, 179);
            Add_Goto (Table.States (400), 211, 180);
            Add_Goto (Table.States (400), 213, 181);
            Add_Goto (Table.States (400), 214, 182);
            Add_Goto (Table.States (400), 215, 183);
            Add_Goto (Table.States (400), 218, 184);
            Add_Goto (Table.States (400), 219, 185);
            Add_Goto (Table.States (400), 220, 186);
            Add_Goto (Table.States (400), 229, 674);
            Add_Goto (Table.States (400), 230, 675);
            Add_Goto (Table.States (400), 231, 676);
            Add_Goto (Table.States (400), 232, 190);
            Add_Goto (Table.States (400), 233, 191);
            Add_Goto (Table.States (400), 234, 192);
            Add_Goto (Table.States (400), 237, 193);
            Add_Goto (Table.States (400), 251, 58);
            Add_Goto (Table.States (400), 252, 59);
            Add_Goto (Table.States (400), 255, 60);
            Add_Goto (Table.States (400), 256, 194);
            Add_Goto (Table.States (400), 268, 68);
            Add_Goto (Table.States (400), 311, 83);
            Add_Goto (Table.States (400), 465, 196);
            Table.States (400).Kernel := To_Vector ((0 => ((228, 3),  45,  1, (32767, 0),  0)));
            Table.States (400).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
         end Subr_16;
         procedure Subr_17
         is begin
            Table.States (401).Action_List.Set_Capacity (1);
            Add_Action (Table.States (401), 45, (228, 2), 677);
            Table.States (401).Kernel := To_Vector ((0 => ((228, 2),  52,  2, (32767, 0),  0)));
            Table.States (401).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (228, 2),  45, 677)));
            Table.States (402).Action_List.Set_Capacity (13);
            Add_Action (Table.States (402), (44, 52, 65, 76, 85, 86, 90, 106, 107, 115, 116, 117, 118), (235, 0),  1);
            Table.States (402).Kernel := To_Vector ((0 => ((235, 0),  98,  0, (235, 0),  1)));
            Table.States (402).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (235, 0),  1)));
            Table.States (403).Action_List.Set_Capacity (13);
            Add_Action (Table.States (403), (44, 52, 65, 76, 85, 86, 90, 106, 107, 115, 116, 117, 118), (235, 4),  1);
            Table.States (403).Kernel := To_Vector ((0 => ((235, 4),  100,  0, (235, 4),  1)));
            Table.States (403).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (235, 4),  1)));
            Table.States (404).Action_List.Set_Capacity (13);
            Add_Action (Table.States (404), (44, 52, 65, 76, 85, 86, 90, 106, 107, 115, 116, 117, 118), (235, 5),  1);
            Table.States (404).Kernel := To_Vector ((0 => ((235, 5),  101,  0, (235, 5),  1)));
            Table.States (404).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (235, 5),  1)));
            Table.States (405).Action_List.Set_Capacity (13);
            Add_Action (Table.States (405), (44, 52, 65, 76, 85, 86, 90, 106, 107, 115, 116, 117, 118), (235, 2),  1);
            Table.States (405).Kernel := To_Vector ((0 => ((235, 2),  103,  0, (235, 2),  1)));
            Table.States (405).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (235, 2),  1)));
            Table.States (406).Action_List.Set_Capacity (13);
            Add_Action (Table.States (406), (44, 52, 65, 76, 85, 86, 90, 106, 107, 115, 116, 117, 118), (235, 3),  1);
            Table.States (406).Kernel := To_Vector ((0 => ((235, 3),  104,  0, (235, 3),  1)));
            Table.States (406).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (235, 3),  1)));
            Table.States (407).Action_List.Set_Capacity (13);
            Add_Action (Table.States (407), (44, 52, 65, 76, 85, 86, 90, 106, 107, 115, 116, 117, 118), (235, 1),  1);
            Table.States (407).Kernel := To_Vector ((0 => ((235, 1),  110,  0, (235, 1),  1)));
            Table.States (407).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (235, 1),  1)));
            Table.States (408).Action_List.Set_Capacity (13);
            Add_Action (Table.States (408), 44, (233, 2), 167);
            Add_Action (Table.States (408), 52, (233, 3), 168);
            Add_Action (Table.States (408), 65, (234, 1), 169);
            Add_Action (Table.States (408), 76, (256, 0), 170);
            Add_Action (Table.States (408), 85, (205, 4), 171);
            Add_Action (Table.States (408), 86, (213, 2), 172);
            Add_Action (Table.States (408), 90, (268, 0), 34);
            Add_Action (Table.States (408), 106, (237, 1), 173);
            Add_Action (Table.States (408), 107, (237, 0), 174);
            Add_Action (Table.States (408), 115, (234, 0), 175);
            Add_Action (Table.States (408), 116, (196, 0), 146);
            Add_Action (Table.States (408), 117, (196, 1), 37);
            Add_Action (Table.States (408), 118, (195, 6), 38);
            Table.States (408).Goto_List.Set_Capacity (28);
            Add_Goto (Table.States (408), 195, 176);
            Add_Goto (Table.States (408), 196, 148);
            Add_Goto (Table.States (408), 197, 54);
            Add_Goto (Table.States (408), 198, 55);
            Add_Goto (Table.States (408), 199, 56);
            Add_Goto (Table.States (408), 201, 57);
            Add_Goto (Table.States (408), 205, 177);
            Add_Goto (Table.States (408), 206, 178);
            Add_Goto (Table.States (408), 210, 179);
            Add_Goto (Table.States (408), 211, 180);
            Add_Goto (Table.States (408), 213, 181);
            Add_Goto (Table.States (408), 214, 182);
            Add_Goto (Table.States (408), 215, 183);
            Add_Goto (Table.States (408), 218, 184);
            Add_Goto (Table.States (408), 219, 185);
            Add_Goto (Table.States (408), 220, 186);
            Add_Goto (Table.States (408), 231, 678);
            Add_Goto (Table.States (408), 232, 190);
            Add_Goto (Table.States (408), 233, 191);
            Add_Goto (Table.States (408), 234, 192);
            Add_Goto (Table.States (408), 237, 193);
            Add_Goto (Table.States (408), 251, 58);
            Add_Goto (Table.States (408), 252, 59);
            Add_Goto (Table.States (408), 255, 60);
            Add_Goto (Table.States (408), 256, 194);
            Add_Goto (Table.States (408), 268, 68);
            Add_Goto (Table.States (408), 311, 83);
            Add_Goto (Table.States (408), 465, 196);
            Table.States (408).Kernel := To_Vector ((0 => ((228, 0),  235,  1, (32767, 0),  0)));
            Table.States (408).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (409).Action_List.Set_Capacity (11);
            Add_Action (Table.States (409), (44, 52, 65, 76, 85, 86, 90, 115, 116, 117, 118), (238, 3),  1);
            Table.States (409).Kernel := To_Vector ((0 => ((238, 3),  43,  0, (238, 3),  1)));
            Table.States (409).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (238, 3),  1)));
            Table.States (410).Action_List.Set_Capacity (11);
            Add_Action (Table.States (410), (44, 52, 65, 76, 85, 86, 90, 115, 116, 117, 118), (238, 2),  1);
            Table.States (410).Kernel := To_Vector ((0 => ((238, 2),  73,  0, (238, 2),  1)));
            Table.States (410).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (238, 2),  1)));
            Table.States (411).Action_List.Set_Capacity (11);
            Add_Action (Table.States (411), (44, 52, 65, 76, 85, 86, 90, 115, 116, 117, 118), (238, 1),  1);
            Table.States (411).Kernel := To_Vector ((0 => ((238, 1),  109,  0, (238, 1),  1)));
            Table.States (411).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (238, 1),  1)));
            Table.States (412).Action_List.Set_Capacity (11);
            Add_Action (Table.States (412), (44, 52, 65, 76, 85, 86, 90, 115, 116, 117, 118), (238, 0),  1);
            Table.States (412).Kernel := To_Vector ((0 => ((238, 0),  111,  0, (238, 0),  1)));
            Table.States (412).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (238, 0),  1)));
            Table.States (413).Action_List.Set_Capacity (11);
            Add_Action (Table.States (413), 44, (233, 2), 167);
            Add_Action (Table.States (413), 52, (233, 3), 168);
            Add_Action (Table.States (413), 65, (234, 1), 169);
            Add_Action (Table.States (413), 76, (256, 0), 170);
            Add_Action (Table.States (413), 85, (205, 4), 171);
            Add_Action (Table.States (413), 86, (213, 2), 172);
            Add_Action (Table.States (413), 90, (268, 0), 34);
            Add_Action (Table.States (413), 115, (234, 0), 175);
            Add_Action (Table.States (413), 116, (196, 0), 146);
            Add_Action (Table.States (413), 117, (196, 1), 37);
            Add_Action (Table.States (413), 118, (195, 6), 38);
            Table.States (413).Goto_List.Set_Capacity (25);
            Add_Goto (Table.States (413), 195, 176);
            Add_Goto (Table.States (413), 196, 148);
            Add_Goto (Table.States (413), 197, 54);
            Add_Goto (Table.States (413), 198, 55);
            Add_Goto (Table.States (413), 199, 56);
            Add_Goto (Table.States (413), 201, 57);
            Add_Goto (Table.States (413), 205, 177);
            Add_Goto (Table.States (413), 206, 178);
            Add_Goto (Table.States (413), 210, 179);
            Add_Goto (Table.States (413), 211, 180);
            Add_Goto (Table.States (413), 213, 181);
            Add_Goto (Table.States (413), 214, 182);
            Add_Goto (Table.States (413), 215, 183);
            Add_Goto (Table.States (413), 218, 184);
            Add_Goto (Table.States (413), 219, 185);
            Add_Goto (Table.States (413), 220, 186);
            Add_Goto (Table.States (413), 232, 679);
            Add_Goto (Table.States (413), 233, 680);
            Add_Goto (Table.States (413), 234, 192);
            Add_Goto (Table.States (413), 251, 58);
            Add_Goto (Table.States (413), 252, 59);
            Add_Goto (Table.States (413), 255, 60);
            Add_Goto (Table.States (413), 256, 194);
            Add_Goto (Table.States (413), 268, 68);
            Add_Goto (Table.States (413), 311, 83);
            Table.States (413).Kernel := To_Vector ((((232, 1),  238,  1, (32767, 0),  0), ((232, 2),  238,  1, (32767,
            0),  0)));
            Table.States (414).Action_List.Set_Capacity (9);
            Add_Action (Table.States (414), 65, (234, 1), 169);
            Add_Action (Table.States (414), 76, (256, 0), 170);
            Add_Action (Table.States (414), 85, (205, 4), 171);
            Add_Action (Table.States (414), 86, (213, 2), 172);
            Add_Action (Table.States (414), 90, (268, 0), 34);
            Add_Action (Table.States (414), 115, (234, 0), 175);
            Add_Action (Table.States (414), 116, (196, 0), 146);
            Add_Action (Table.States (414), 117, (196, 1), 37);
            Add_Action (Table.States (414), 118, (195, 6), 38);
            Table.States (414).Goto_List.Set_Capacity (23);
            Add_Goto (Table.States (414), 195, 176);
            Add_Goto (Table.States (414), 196, 148);
            Add_Goto (Table.States (414), 197, 54);
            Add_Goto (Table.States (414), 198, 55);
            Add_Goto (Table.States (414), 199, 56);
            Add_Goto (Table.States (414), 201, 57);
            Add_Goto (Table.States (414), 205, 177);
            Add_Goto (Table.States (414), 206, 178);
            Add_Goto (Table.States (414), 210, 179);
            Add_Goto (Table.States (414), 211, 180);
            Add_Goto (Table.States (414), 213, 181);
            Add_Goto (Table.States (414), 214, 182);
            Add_Goto (Table.States (414), 215, 183);
            Add_Goto (Table.States (414), 218, 184);
            Add_Goto (Table.States (414), 219, 185);
            Add_Goto (Table.States (414), 220, 186);
            Add_Goto (Table.States (414), 234, 681);
            Add_Goto (Table.States (414), 251, 58);
            Add_Goto (Table.States (414), 252, 59);
            Add_Goto (Table.States (414), 255, 60);
            Add_Goto (Table.States (414), 256, 194);
            Add_Goto (Table.States (414), 268, 68);
            Add_Goto (Table.States (414), 311, 83);
            Table.States (414).Kernel := To_Vector ((0 => ((233, 0),  112,  1, (32767, 0),  0)));
            Table.States (414).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (415).Action_List.Set_Capacity (34);
            Add_Action (Table.States (415), 33, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 36, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 42, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 45, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 46, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 47, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 48, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 49, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 50, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 52, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 61, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 63, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 69, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 72, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 74, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 75, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 82, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 87, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 88, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 89, (236, 2), 416);
            Add_Action (Table.States (415), 91, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 94, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 95, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 97, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 98, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 99, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 100, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 101, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 103, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 104, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 106, (236, 1), 417);
            Add_Action (Table.States (415), 107, (236, 0), 418);
            Add_Action (Table.States (415), 108, Reduce, (231, 0),  2);
            Add_Action (Table.States (415), 110, Reduce, (231, 0),  2);
            Table.States (415).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (415), 236, 419);
            Table.States (415).Kernel := To_Vector ((((231, 0),  465,  0, (231, 0),  2), ((465, 1),  465,  2, (32767,
            0),  0), ((465, 2),  465,  2, (32767, 0),  0)));
            Table.States (415).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (231, 0),  2)));
            Table.States (416).Action_List.Set_Capacity (11);
            Add_Action (Table.States (416), (44, 52, 65, 76, 85, 86, 90, 115, 116, 117, 118), (236, 2),  1);
            Table.States (416).Kernel := To_Vector ((0 => ((236, 2),  89,  0, (236, 2),  1)));
            Table.States (416).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (236, 2),  1)));
            Table.States (417).Action_List.Set_Capacity (11);
            Add_Action (Table.States (417), (44, 52, 65, 76, 85, 86, 90, 115, 116, 117, 118), (236, 1),  1);
            Table.States (417).Kernel := To_Vector ((0 => ((236, 1),  106,  0, (236, 1),  1)));
            Table.States (417).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (236, 1),  1)));
            Table.States (418).Action_List.Set_Capacity (11);
            Add_Action (Table.States (418), (44, 52, 65, 76, 85, 86, 90, 115, 116, 117, 118), (236, 0),  1);
            Table.States (418).Kernel := To_Vector ((0 => ((236, 0),  107,  0, (236, 0),  1)));
            Table.States (418).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (236, 0),  1)));
            Table.States (419).Action_List.Set_Capacity (11);
            Add_Action (Table.States (419), 44, (233, 2), 167);
            Add_Action (Table.States (419), 52, (233, 3), 168);
            Add_Action (Table.States (419), 65, (234, 1), 169);
            Add_Action (Table.States (419), 76, (256, 0), 170);
            Add_Action (Table.States (419), 85, (205, 4), 171);
            Add_Action (Table.States (419), 86, (213, 2), 172);
            Add_Action (Table.States (419), 90, (268, 0), 34);
            Add_Action (Table.States (419), 115, (234, 0), 175);
            Add_Action (Table.States (419), 116, (196, 0), 146);
            Add_Action (Table.States (419), 117, (196, 1), 37);
            Add_Action (Table.States (419), 118, (195, 6), 38);
            Table.States (419).Goto_List.Set_Capacity (26);
            Add_Goto (Table.States (419), 195, 176);
            Add_Goto (Table.States (419), 196, 148);
            Add_Goto (Table.States (419), 197, 54);
            Add_Goto (Table.States (419), 198, 55);
            Add_Goto (Table.States (419), 199, 56);
            Add_Goto (Table.States (419), 201, 57);
            Add_Goto (Table.States (419), 205, 177);
            Add_Goto (Table.States (419), 206, 178);
            Add_Goto (Table.States (419), 210, 179);
            Add_Goto (Table.States (419), 211, 180);
            Add_Goto (Table.States (419), 213, 181);
            Add_Goto (Table.States (419), 214, 182);
            Add_Goto (Table.States (419), 215, 183);
            Add_Goto (Table.States (419), 218, 184);
            Add_Goto (Table.States (419), 219, 185);
            Add_Goto (Table.States (419), 220, 186);
            Add_Goto (Table.States (419), 232, 682);
            Add_Goto (Table.States (419), 233, 191);
            Add_Goto (Table.States (419), 234, 192);
            Add_Goto (Table.States (419), 251, 58);
            Add_Goto (Table.States (419), 252, 59);
            Add_Goto (Table.States (419), 255, 60);
            Add_Goto (Table.States (419), 256, 194);
            Add_Goto (Table.States (419), 268, 68);
            Add_Goto (Table.States (419), 311, 83);
            Add_Goto (Table.States (419), 465, 683);
            Table.States (419).Kernel := To_Vector ((((465, 1),  236,  1, (32767, 0),  0), ((465, 2),  236,  1, (32767,
            0),  0)));
            Table.States (420).Action_List.Set_Capacity (5);
            Add_Action (Table.States (420), 86, (252, 0), 33);
            Add_Action (Table.States (420), 90, (268, 0), 34);
            Add_Action (Table.States (420), 116, (196, 0), 146);
            Add_Action (Table.States (420), 117, (196, 1), 37);
            Add_Action (Table.States (420), 118, (195, 6), 38);
            Table.States (420).Goto_List.Set_Capacity (12);
            Add_Goto (Table.States (420), 195, 684);
            Add_Goto (Table.States (420), 196, 148);
            Add_Goto (Table.States (420), 197, 54);
            Add_Goto (Table.States (420), 198, 55);
            Add_Goto (Table.States (420), 199, 56);
            Add_Goto (Table.States (420), 201, 57);
            Add_Goto (Table.States (420), 251, 58);
            Add_Goto (Table.States (420), 252, 59);
            Add_Goto (Table.States (420), 255, 60);
            Add_Goto (Table.States (420), 268, 68);
            Add_Goto (Table.States (420), 306, 685);
            Add_Goto (Table.States (420), 311, 83);
            Table.States (420).Kernel := To_Vector ((((306, 1),  95,  1, (32767, 0),  0), ((306, 2),  95,  1, (32767,
            0),  0)));
            Table.States (421).Action_List.Set_Capacity (50);
            Add_Action (Table.States (421), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (382, 0),  3);
            Table.States (421).Kernel := To_Vector ((0 => ((382, 0),  108,  0, (382, 0),  3)));
            Table.States (421).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (382, 0),  3)));
            Table.States (422).Action_List.Set_Capacity (1);
            Add_Action (Table.States (422), 18, (363, 0), 686);
            Table.States (422).Kernel := To_Vector ((0 => ((363, 0),  61,  2, (32767, 0),  0)));
            Table.States (422).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (363, 0),  18, 686)));
            Table.States (423).Action_List.Set_Capacity (50);
            Add_Action (Table.States (423), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (363, 1),  3);
            Table.States (423).Kernel := To_Vector ((0 => ((363, 1),  108,  0, (363, 1),  3)));
            Table.States (423).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (363, 1),  3)));
            Table.States (424).Action_List.Set_Capacity (14);
            Add_Action (Table.States (424), 12, (402, 0), 165);
            Add_Action (Table.States (424), 44, (233, 2), 167);
            Add_Action (Table.States (424), 52, (233, 3), 168);
            Add_Action (Table.States (424), 65, (234, 1), 169);
            Add_Action (Table.States (424), 76, (256, 0), 170);
            Add_Action (Table.States (424), 85, (205, 4), 171);
            Add_Action (Table.States (424), 86, (213, 2), 172);
            Add_Action (Table.States (424), 90, (268, 0), 34);
            Add_Action (Table.States (424), 106, (237, 1), 173);
            Add_Action (Table.States (424), 107, (237, 0), 174);
            Add_Action (Table.States (424), 115, (234, 0), 175);
            Add_Action (Table.States (424), 116, (136, 0), 687);
            Add_Action (Table.States (424), 117, (196, 1), 37);
            Add_Action (Table.States (424), 118, (195, 6), 38);
            Table.States (424).Goto_List.Set_Capacity (35);
            Add_Goto (Table.States (424), 136, 688);
            Add_Goto (Table.States (424), 195, 176);
            Add_Goto (Table.States (424), 196, 148);
            Add_Goto (Table.States (424), 197, 54);
            Add_Goto (Table.States (424), 198, 55);
            Add_Goto (Table.States (424), 199, 56);
            Add_Goto (Table.States (424), 201, 57);
            Add_Goto (Table.States (424), 205, 177);
            Add_Goto (Table.States (424), 206, 178);
            Add_Goto (Table.States (424), 210, 179);
            Add_Goto (Table.States (424), 211, 180);
            Add_Goto (Table.States (424), 213, 181);
            Add_Goto (Table.States (424), 214, 182);
            Add_Goto (Table.States (424), 215, 183);
            Add_Goto (Table.States (424), 218, 184);
            Add_Goto (Table.States (424), 219, 185);
            Add_Goto (Table.States (424), 220, 186);
            Add_Goto (Table.States (424), 227, 689);
            Add_Goto (Table.States (424), 228, 188);
            Add_Goto (Table.States (424), 231, 189);
            Add_Goto (Table.States (424), 232, 190);
            Add_Goto (Table.States (424), 233, 191);
            Add_Goto (Table.States (424), 234, 192);
            Add_Goto (Table.States (424), 237, 193);
            Add_Goto (Table.States (424), 251, 58);
            Add_Goto (Table.States (424), 252, 59);
            Add_Goto (Table.States (424), 255, 60);
            Add_Goto (Table.States (424), 256, 194);
            Add_Goto (Table.States (424), 268, 68);
            Add_Goto (Table.States (424), 298, 467);
            Add_Goto (Table.States (424), 300, 468);
            Add_Goto (Table.States (424), 311, 83);
            Add_Goto (Table.States (424), 358, 690);
            Add_Goto (Table.States (424), 402, 195);
            Add_Goto (Table.States (424), 465, 196);
            Table.States (424).Kernel := To_Vector ((((299, 0),  85,  4, (32767, 0),  0), ((357, 0),  85,  7, (32767,
            0),  0), ((357, 1),  85,  3, (32767, 0),  0)));
            Table.States (424).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (425).Action_List.Set_Capacity (2);
            Add_Action (Table.States (425), 33, (357, 2), 691);
            Add_Action (Table.States (425), 108, (357, 3), 692);
            Table.States (425).Kernel := To_Vector ((((357, 2),  295,  5, (32767, 0),  0), ((357, 3),  295,  1, (32767,
            0),  0)));
            Table.States (425).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (357, 3),  108, 692)));
            Table.States (426).Action_List.Set_Capacity (11);
            Add_Action (Table.States (426), (24, 33, 45, 48, 61, 63, 69, 82, 87, 94, 108), (295, 0),  1);
            Table.States (426).Kernel := To_Vector ((0 => ((295, 0),  299,  0, (295, 0),  1)));
            Table.States (426).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (295, 0),  1)));
            Table.States (427).Action_List.Set_Capacity (13);
            Add_Action (Table.States (427), 44, (233, 2), 167);
            Add_Action (Table.States (427), 52, (187, 0), 356);
            Add_Action (Table.States (427), 65, (234, 1), 169);
            Add_Action (Table.States (427), 76, (256, 0), 170);
            Add_Action (Table.States (427), 85, (205, 4), 171);
            Add_Action (Table.States (427), 86, (213, 2), 172);
            Add_Action (Table.States (427), 90, (268, 0), 34);
            Add_Action (Table.States (427), 106, (237, 1), 173);
            Add_Action (Table.States (427), 107, (237, 0), 174);
            Add_Action (Table.States (427), 115, (234, 0), 175);
            Add_Action (Table.States (427), 116, (136, 0), 687);
            Add_Action (Table.States (427), 117, (196, 1), 37);
            Add_Action (Table.States (427), 118, (195, 6), 38);
            Table.States (427).Goto_List.Set_Capacity (36);
            Add_Goto (Table.States (427), 131, 693);
            Add_Goto (Table.States (427), 136, 688);
            Add_Goto (Table.States (427), 140, 694);
            Add_Goto (Table.States (427), 160, 695);
            Add_Goto (Table.States (427), 187, 365);
            Add_Goto (Table.States (427), 195, 366);
            Add_Goto (Table.States (427), 196, 148);
            Add_Goto (Table.States (427), 197, 54);
            Add_Goto (Table.States (427), 198, 55);
            Add_Goto (Table.States (427), 199, 56);
            Add_Goto (Table.States (427), 201, 57);
            Add_Goto (Table.States (427), 203, 369);
            Add_Goto (Table.States (427), 205, 177);
            Add_Goto (Table.States (427), 206, 178);
            Add_Goto (Table.States (427), 210, 179);
            Add_Goto (Table.States (427), 211, 180);
            Add_Goto (Table.States (427), 213, 181);
            Add_Goto (Table.States (427), 214, 182);
            Add_Goto (Table.States (427), 215, 183);
            Add_Goto (Table.States (427), 218, 184);
            Add_Goto (Table.States (427), 219, 185);
            Add_Goto (Table.States (427), 220, 186);
            Add_Goto (Table.States (427), 231, 696);
            Add_Goto (Table.States (427), 232, 190);
            Add_Goto (Table.States (427), 233, 191);
            Add_Goto (Table.States (427), 234, 192);
            Add_Goto (Table.States (427), 237, 193);
            Add_Goto (Table.States (427), 251, 58);
            Add_Goto (Table.States (427), 252, 59);
            Add_Goto (Table.States (427), 255, 60);
            Add_Goto (Table.States (427), 256, 194);
            Add_Goto (Table.States (427), 268, 68);
            Add_Goto (Table.States (427), 298, 467);
            Add_Goto (Table.States (427), 300, 468);
            Add_Goto (Table.States (427), 311, 83);
            Add_Goto (Table.States (427), 465, 196);
            Table.States (427).Kernel := To_Vector ((((299, 0),  85,  4, (32767, 0),  0), ((356, 4),  85,  5, (32767,
            0),  0), ((356, 5),  85,  3, (32767, 0),  0)));
            Table.States (427).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (136, 0),  116, 687)));
         end Subr_17;
         procedure Subr_18
         is begin
            Table.States (428).Action_List.Set_Capacity (2);
            Add_Action (Table.States (428), 61, (434, 0), 299);
            Add_Action (Table.States (428), 108, (356, 7), 697);
            Table.States (428).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (428), 434, 698);
            Table.States (428).Kernel := To_Vector ((((356, 6),  295,  3, (32767, 0),  0), ((356, 7),  295,  1, (32767,
            0),  0)));
            Table.States (428).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (356, 7),  108, 697)));
            Table.States (429).Action_List.Set_Capacity (5);
            Add_Action (Table.States (429), 24, (339, 0), 699);
            Add_Action (Table.States (429), 85, (198, 0), 281);
            Add_Action (Table.States (429), 96, (197, 0), 283);
            Add_Action (Table.States (429), 113, (121, 0), 285);
            Add_Action (Table.States (429), 114, (121, 1), 286);
            Table.States (429).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (429), 121, 287);
            Add_Goto (Table.States (429), 313, 289);
            Table.States (429).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((339, 0),  195,  5, (32767, 0),  0), ((339, 1),
            195,  3, (32767, 0),  0)));
            Table.States (429).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (339, 0),  24, 699)));
            Table.States (430).Action_List.Set_Capacity (5);
            Add_Action (Table.States (430), 24, (339, 4), 700);
            Add_Action (Table.States (430), 85, (198, 0), 281);
            Add_Action (Table.States (430), 96, (197, 0), 283);
            Add_Action (Table.States (430), 113, (121, 0), 285);
            Add_Action (Table.States (430), 114, (121, 1), 286);
            Table.States (430).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (430), 121, 287);
            Add_Goto (Table.States (430), 313, 289);
            Table.States (430).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((339, 4),  195,  5, (32767, 0),  0), ((339, 5),
            195,  3, (32767, 0),  0)));
            Table.States (430).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (339, 4),  24, 700)));
            Table.States (431).Action_List.Set_Capacity (5);
            Add_Action (Table.States (431), 24, (339, 2), 701);
            Add_Action (Table.States (431), 85, (198, 0), 281);
            Add_Action (Table.States (431), 96, (197, 0), 283);
            Add_Action (Table.States (431), 113, (121, 0), 285);
            Add_Action (Table.States (431), 114, (121, 1), 286);
            Table.States (431).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (431), 121, 287);
            Add_Goto (Table.States (431), 313, 289);
            Table.States (431).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((339, 2),  195,  5, (32767, 0),  0), ((339, 3),
            195,  3, (32767, 0),  0)));
            Table.States (431).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (339, 2),  24, 701)));
            Table.States (432).Action_List.Set_Capacity (1);
            Add_Action (Table.States (432), 116, (430, 0), 702);
            Table.States (432).Kernel := To_Vector ((((430, 0),  28,  7, (32767, 0),  0), ((430, 1),  28,  5, (32767,
            0),  0)));
            Table.States (432).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (430, 0),  116, 702)));
            Table.States (433).Action_List.Set_Capacity (3);
            Add_Action (Table.States (433), 61, (434, 0), 299);
            Add_Action (Table.States (433), 82, (426, 0), 703);
            Add_Action (Table.States (433), 108, (426, 3), 704);
            Table.States (433).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (433), 434, 705);
            Table.States (433).Kernel := To_Vector ((((426, 0),  292,  5, (32767, 0),  0), ((426, 1),  292,  3, (32767,
            0),  0), ((426, 2),  292,  3, (32767, 0),  0), ((426, 3),  292,  1, (32767, 0),  0), ((427, 0),  292,  6,
            (32767, 0),  0), ((427, 1),  292,  4, (32767, 0),  0), ((427, 2),  292,  5, (32767, 0),  0), ((427, 3),
            292,  3, (32767, 0),  0)));
            Table.States (433).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (426, 3),  108, 704)));
            Table.States (434).Action_List.Set_Capacity (4);
            Add_Action (Table.States (434), 48, (412, 6), 706);
            Add_Action (Table.States (434), 82, (411, 4), 707);
            Add_Action (Table.States (434), 85, (165, 0), 499);
            Add_Action (Table.States (434), 108, (412, 7), 708);
            Table.States (434).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (434), 164, 709);
            Add_Goto (Table.States (434), 165, 502);
            Add_Goto (Table.States (434), 167, 710);
            Table.States (434).Kernel := To_Vector ((((411, 0),  116,  11, (32767, 0),  0), ((411, 1),  116,  9,
            (32767, 0),  0), ((411, 2),  116,  8, (32767, 0),  0), ((411, 3),  116,  6, (32767, 0),  0), ((411, 4),
            116,  8, (32767, 0),  0), ((411, 5),  116,  6, (32767, 0),  0), ((411, 6),  116,  5, (32767, 0),  0),
            ((411, 7),  116,  3, (32767, 0),  0), ((412, 0),  116,  9, (32767, 0),  0), ((412, 1),  116,  6, (32767,
            0),  0), ((412, 2),  116,  7, (32767, 0),  0), ((412, 3),  116,  4, (32767, 0),  0), ((412, 4),  116,  6,
            (32767, 0),  0), ((412, 5),  116,  3, (32767, 0),  0), ((412, 6),  116,  4, (32767, 0),  0), ((412, 7),
            116,  1, (32767, 0),  0)));
            Table.States (434).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (412, 7),  108, 708)));
            Table.States (435).Action_List.Set_Capacity (9);
            Add_Action (Table.States (435), 29, (301, 3), 711);
            Add_Action (Table.States (435), 45, (301, 0), 712);
            Add_Action (Table.States (435), 52, Reduce, (301, 1),  0);
            Add_Action (Table.States (435), 56, Reduce, (301, 1),  0);
            Add_Action (Table.States (435), 86, Reduce, (301, 1),  0);
            Add_Action (Table.States (435), 90, Reduce, (301, 1),  0);
            Add_Action (Table.States (435), 116, Reduce, (301, 1),  0);
            Add_Action (Table.States (435), 117, Reduce, (301, 1),  0);
            Add_Action (Table.States (435), 118, Reduce, (301, 1),  0);
            Table.States (435).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (435), 301, 713);
            Table.States (435).Kernel := To_Vector ((((409, 0),  93,  8, (32767, 0),  0), ((409, 1),  93,  6, (32767,
            0),  0), ((409, 2),  93,  6, (32767, 0),  0), ((409, 3),  93,  4, (32767, 0),  0), ((409, 4),  93,  6,
            (32767, 0),  0), ((409, 5),  93,  4, (32767, 0),  0), ((409, 6),  93,  4, (32767, 0),  0), ((409, 7),  93,
            2, (32767, 0),  0), ((409, 8),  93,  7, (32767, 0),  0), ((409, 9),  93,  5, (32767, 0),  0), ((409, 10),
            93,  5, (32767, 0),  0), ((409, 11),  93,  3, (32767, 0),  0)));
            Table.States (435).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (301, 1),  0)));
            Table.States (436).Action_List.Set_Capacity (8);
            Add_Action (Table.States (436), (28, 50, 53, 54, 61, 83, 84, 116), (464, 1),  2);
            Table.States (436).Kernel := To_Vector ((((464, 0),  407,  0, (464, 0),  1), ((464, 1),  407,  0, (464, 1),
             2)));
            Table.States (436).Minimal_Complete_Actions := To_Vector (((Reduce, (464, 0),  1), (Reduce, (464, 1),
            2)));
            Table.States (437).Action_List.Set_Capacity (8);
            Add_Action (Table.States (437), (28, 50, 53, 54, 61, 83, 84, 116), (464, 2),  2);
            Table.States (437).Goto_List.Set_Capacity (15);
            Add_Goto (Table.States (437), 124, 208);
            Add_Goto (Table.States (437), 136, 209);
            Add_Goto (Table.States (437), 330, 210);
            Add_Goto (Table.States (437), 332, 95);
            Add_Goto (Table.States (437), 333, 96);
            Add_Goto (Table.States (437), 407, 436);
            Add_Goto (Table.States (437), 409, 212);
            Add_Goto (Table.States (437), 410, 213);
            Add_Goto (Table.States (437), 411, 214);
            Add_Goto (Table.States (437), 412, 215);
            Add_Goto (Table.States (437), 425, 216);
            Add_Goto (Table.States (437), 426, 217);
            Add_Goto (Table.States (437), 427, 218);
            Add_Goto (Table.States (437), 430, 219);
            Add_Goto (Table.States (437), 464, 437);
            Table.States (437).Kernel := To_Vector ((((464, 1),  464,  3, (32767, 0),  0), ((464, 2),  464,  0, (464,
            2),  2), ((464, 2),  464,  3, (32767, 0),  0)));
            Table.States (437).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (464, 2),  2)));
            Table.States (438).Action_List.Set_Capacity (2);
            Add_Action (Table.States (438), 95, (331, 1), 464);
            Add_Action (Table.States (438), 108, (387, 0), 714);
            Table.States (438).Kernel := To_Vector ((((331, 1),  331,  2, (32767, 0),  0), ((387, 0),  331,  1, (32767,
            0),  0)));
            Table.States (438).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (387, 0),  108, 714)));
            Table.States (439).Action_List.Set_Capacity (6);
            Add_Action (Table.States (439), 61, Reduce, (196, 0),  1);
            Add_Action (Table.States (439), 82, (390, 0), 715);
            Add_Conflict (Table.States (439), 82, (196, 0),  1);
            Add_Action (Table.States (439), 85, Reduce, (196, 0),  1);
            Add_Action (Table.States (439), 96, Reduce, (196, 0),  1);
            Add_Action (Table.States (439), 113, Reduce, (196, 0),  1);
            Add_Action (Table.States (439), 114, Reduce, (196, 0),  1);
            Table.States (439).Kernel := To_Vector ((((196, 0),  116,  0, (196, 0),  1), ((390, 0),  116,  5, (32767,
            0),  0), ((390, 1),  116,  3, (32767, 0),  0)));
            Table.States (439).Minimal_Complete_Actions := To_Vector (((Reduce, (196, 0),  1), (Shift, (390, 0),  82,
            715)));
            Table.States (440).Action_List.Set_Capacity (6);
            Add_Action (Table.States (440), 61, (434, 0), 299);
            Add_Action (Table.States (440), 82, (326, 2), 716);
            Add_Action (Table.States (440), 85, (198, 0), 281);
            Add_Action (Table.States (440), 96, (197, 0), 283);
            Add_Action (Table.States (440), 113, (121, 0), 285);
            Add_Action (Table.States (440), 114, (121, 1), 286);
            Table.States (440).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (440), 121, 287);
            Add_Goto (Table.States (440), 313, 289);
            Add_Goto (Table.States (440), 434, 717);
            Table.States (440).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((326, 0),  195,  8, (32767, 0),  0), ((326, 1),
            195,  5, (32767, 0),  0), ((326, 2),  195,  6, (32767, 0),  0), ((326, 3),  195,  3, (32767, 0),  0)));
            Table.States (440).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (326, 2),  82, 716)));
            Table.States (441).Action_List.Set_Capacity (5);
            Add_Action (Table.States (441), 86, (252, 0), 33);
            Add_Action (Table.States (441), 90, (268, 0), 34);
            Add_Action (Table.States (441), 116, (196, 0), 146);
            Add_Action (Table.States (441), 117, (196, 1), 37);
            Add_Action (Table.States (441), 118, (195, 6), 38);
            Table.States (441).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (441), 195, 718);
            Add_Goto (Table.States (441), 196, 148);
            Add_Goto (Table.States (441), 197, 54);
            Add_Goto (Table.States (441), 198, 55);
            Add_Goto (Table.States (441), 199, 56);
            Add_Goto (Table.States (441), 201, 57);
            Add_Goto (Table.States (441), 251, 58);
            Add_Goto (Table.States (441), 252, 59);
            Add_Goto (Table.States (441), 255, 60);
            Add_Goto (Table.States (441), 268, 68);
            Add_Goto (Table.States (441), 311, 83);
            Table.States (441).Kernel := To_Vector ((((337, 0),  24,  4, (32767, 0),  0), ((337, 1),  24,  2, (32767,
            0),  0)));
            Table.States (441).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (442).Action_List.Set_Capacity (17);
            Add_Action (Table.States (442), 22, (339, 0), 9);
            Add_Action (Table.States (442), 25, (329, 1), 10);
            Add_Action (Table.States (442), 27, (325, 9), 719);
            Add_Action (Table.States (442), 28, (325, 0), 720);
            Add_Action (Table.States (442), 50, (332, 0), 19);
            Add_Action (Table.States (442), 51, (437, 0), 221);
            Add_Action (Table.States (442), 52, (329, 0), 21);
            Add_Action (Table.States (442), 53, (294, 0), 22);
            Add_Action (Table.States (442), 54, (293, 0), 23);
            Add_Action (Table.States (442), 59, (346, 0), 721);
            Add_Action (Table.States (442), 60, (340, 0), 722);
            Add_Action (Table.States (442), 66, (325, 11), 723);
            Add_Action (Table.States (442), 76, (408, 0), 724);
            Add_Action (Table.States (442), 81, (130, 0), 30);
            Add_Action (Table.States (442), 83, (128, 0), 31);
            Add_Action (Table.States (442), 84, (124, 0), 32);
            Add_Action (Table.States (442), 116, (136, 0), 223);
            Table.States (442).Goto_List.Set_Capacity (48);
            Add_Goto (Table.States (442), 124, 725);
            Add_Goto (Table.States (442), 126, 40);
            Add_Goto (Table.States (442), 127, 41);
            Add_Goto (Table.States (442), 128, 42);
            Add_Goto (Table.States (442), 130, 43);
            Add_Goto (Table.States (442), 135, 44);
            Add_Goto (Table.States (442), 136, 45);
            Add_Goto (Table.States (442), 137, 46);
            Add_Goto (Table.States (442), 180, 47);
            Add_Goto (Table.States (442), 189, 48);
            Add_Goto (Table.States (442), 193, 726);
            Add_Goto (Table.States (442), 291, 77);
            Add_Goto (Table.States (442), 292, 727);
            Add_Goto (Table.States (442), 293, 79);
            Add_Goto (Table.States (442), 294, 80);
            Add_Goto (Table.States (442), 320, 86);
            Add_Goto (Table.States (442), 321, 87);
            Add_Goto (Table.States (442), 322, 88);
            Add_Goto (Table.States (442), 323, 728);
            Add_Goto (Table.States (442), 324, 729);
            Add_Goto (Table.States (442), 325, 89);
            Add_Goto (Table.States (442), 327, 91);
            Add_Goto (Table.States (442), 328, 92);
            Add_Goto (Table.States (442), 329, 730);
            Add_Goto (Table.States (442), 330, 94);
            Add_Goto (Table.States (442), 332, 95);
            Add_Goto (Table.States (442), 333, 96);
            Add_Goto (Table.States (442), 334, 97);
            Add_Goto (Table.States (442), 335, 98);
            Add_Goto (Table.States (442), 336, 99);
            Add_Goto (Table.States (442), 337, 100);
            Add_Goto (Table.States (442), 338, 101);
            Add_Goto (Table.States (442), 339, 102);
            Add_Goto (Table.States (442), 340, 103);
            Add_Goto (Table.States (442), 341, 104);
            Add_Goto (Table.States (442), 346, 106);
            Add_Goto (Table.States (442), 347, 107);
            Add_Goto (Table.States (442), 394, 132);
            Add_Goto (Table.States (442), 403, 134);
            Add_Goto (Table.States (442), 404, 135);
            Add_Goto (Table.States (442), 405, 136);
            Add_Goto (Table.States (442), 406, 137);
            Add_Goto (Table.States (442), 408, 138);
            Add_Goto (Table.States (442), 431, 139);
            Add_Goto (Table.States (442), 437, 140);
            Add_Goto (Table.States (442), 438, 141);
            Add_Goto (Table.States (442), 440, 142);
            Add_Goto (Table.States (442), 454, 143);
            Table.States (442).Kernel := To_Vector ((((325, 6),  82,  8, (32767, 0),  0), ((325, 7),  82,  5, (32767,
            0),  0), ((325, 8),  82,  4, (32767, 0),  0), ((325, 9),  82,  5, (32767, 0),  0), ((325, 10),  82,  2,
            (32767, 0),  0), ((325, 11),  82,  1, (32767, 0),  0), ((408, 0),  82,  5, (32767, 0),  0), ((408, 1),  82,
             3, (32767, 0),  0)));
            Table.States (442).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (325, 11),  66, 723)));
            Table.States (443).Action_List.Set_Capacity (1);
            Add_Action (Table.States (443), 82, (325, 0), 731);
            Table.States (443).Kernel := To_Vector ((((325, 0),  434,  9, (32767, 0),  0), ((325, 1),  434,  6, (32767,
            0),  0), ((325, 2),  434,  5, (32767, 0),  0), ((325, 3),  434,  6, (32767, 0),  0), ((325, 4),  434,  3,
            (32767, 0),  0), ((325, 5),  434,  2, (32767, 0),  0)));
            Table.States (443).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (325, 0),  82, 731)));
            Table.States (444).Action_List.Set_Capacity (9);
            Add_Action (Table.States (444), 52, (187, 0), 347);
            Add_Action (Table.States (444), 56, (188, 2), 514);
            Add_Action (Table.States (444), 79, (317, 4), 732);
            Add_Action (Table.States (444), 80, (317, 0), 733);
            Add_Action (Table.States (444), 86, (252, 0), 33);
            Add_Action (Table.States (444), 90, (268, 0), 34);
            Add_Action (Table.States (444), 116, (196, 0), 146);
            Add_Action (Table.States (444), 117, (196, 1), 37);
            Add_Action (Table.States (444), 118, (195, 6), 38);
            Table.States (444).Goto_List.Set_Capacity (15);
            Add_Goto (Table.States (444), 131, 734);
            Add_Goto (Table.States (444), 187, 526);
            Add_Goto (Table.States (444), 188, 735);
            Add_Goto (Table.States (444), 195, 528);
            Add_Goto (Table.States (444), 196, 148);
            Add_Goto (Table.States (444), 197, 54);
            Add_Goto (Table.States (444), 198, 55);
            Add_Goto (Table.States (444), 199, 56);
            Add_Goto (Table.States (444), 201, 57);
            Add_Goto (Table.States (444), 251, 58);
            Add_Goto (Table.States (444), 252, 59);
            Add_Goto (Table.States (444), 255, 60);
            Add_Goto (Table.States (444), 268, 68);
            Add_Goto (Table.States (444), 311, 83);
            Add_Goto (Table.States (444), 319, 736);
            Table.States (444).Kernel := To_Vector ((((317, 0),  93,  5, (32767, 0),  0), ((317, 1),  93,  3, (32767,
            0),  0), ((317, 2),  93,  4, (32767, 0),  0), ((317, 3),  93,  2, (32767, 0),  0), ((317, 4),  93,  4,
            (32767, 0),  0), ((317, 5),  93,  2, (32767, 0),  0), ((317, 6),  93,  3, (32767, 0),  0), ((317, 7),  93,
            1, (32767, 0),  0)));
            Table.States (444).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (445).Action_List.Set_Capacity (50);
            Add_Action (Table.States (445), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (316, 0),  3);
            Table.States (445).Kernel := To_Vector ((0 => ((316, 0),  108,  0, (316, 0),  3)));
            Table.States (445).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (316, 0),  3)));
            Table.States (446).Action_List.Set_Capacity (25);
            Add_Action (Table.States (446), 12, (401, 0), 1);
            Add_Action (Table.States (446), 15, (370, 0), 3);
            Add_Action (Table.States (446), 17, (365, 0), 4);
            Add_Action (Table.States (446), 18, (382, 0), 5);
            Add_Action (Table.States (446), 19, (363, 0), 6);
            Add_Action (Table.States (446), 20, (357, 0), 7);
            Add_Action (Table.States (446), 30, (316, 0), 13);
            Add_Action (Table.States (446), 31, (290, 0), 14);
            Add_Action (Table.States (446), 32, (289, 0), 15);
            Add_Action (Table.States (446), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (446), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (446), 37, (288, 0), 17);
            Add_Conflict (Table.States (446), 37, (285, 1),  0);
            Add_Action (Table.States (446), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (446), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (446), 41, (271, 0), 18);
            Add_Action (Table.States (446), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (446), 64, (273, 0), 27);
            Add_Action (Table.States (446), 65, (264, 0), 28);
            Add_Action (Table.States (446), 84, (124, 0), 32);
            Add_Action (Table.States (446), 86, (252, 0), 33);
            Add_Action (Table.States (446), 90, (268, 0), 34);
            Add_Action (Table.States (446), 105, (265, 0), 35);
            Add_Action (Table.States (446), 116, (196, 0), 146);
            Add_Action (Table.States (446), 117, (196, 1), 37);
            Add_Action (Table.States (446), 118, (195, 6), 38);
            Table.States (446).Goto_List.Set_Capacity (46);
            Add_Goto (Table.States (446), 124, 39);
            Add_Goto (Table.States (446), 195, 52);
            Add_Goto (Table.States (446), 196, 53);
            Add_Goto (Table.States (446), 197, 54);
            Add_Goto (Table.States (446), 198, 55);
            Add_Goto (Table.States (446), 199, 56);
            Add_Goto (Table.States (446), 201, 57);
            Add_Goto (Table.States (446), 251, 58);
            Add_Goto (Table.States (446), 252, 59);
            Add_Goto (Table.States (446), 255, 60);
            Add_Goto (Table.States (446), 259, 452);
            Add_Goto (Table.States (446), 261, 331);
            Add_Goto (Table.States (446), 262, 62);
            Add_Goto (Table.States (446), 263, 63);
            Add_Goto (Table.States (446), 264, 64);
            Add_Goto (Table.States (446), 265, 65);
            Add_Goto (Table.States (446), 266, 66);
            Add_Goto (Table.States (446), 267, 67);
            Add_Goto (Table.States (446), 268, 68);
            Add_Goto (Table.States (446), 271, 69);
            Add_Goto (Table.States (446), 273, 70);
            Add_Goto (Table.States (446), 275, 71);
            Add_Goto (Table.States (446), 285, 72);
            Add_Goto (Table.States (446), 286, 73);
            Add_Goto (Table.States (446), 288, 74);
            Add_Goto (Table.States (446), 289, 75);
            Add_Goto (Table.States (446), 290, 76);
            Add_Goto (Table.States (446), 310, 82);
            Add_Goto (Table.States (446), 311, 83);
            Add_Goto (Table.States (446), 316, 84);
            Add_Goto (Table.States (446), 318, 85);
            Add_Goto (Table.States (446), 357, 110);
            Add_Goto (Table.States (446), 363, 111);
            Add_Goto (Table.States (446), 364, 112);
            Add_Goto (Table.States (446), 365, 113);
            Add_Goto (Table.States (446), 366, 114);
            Add_Goto (Table.States (446), 367, 115);
            Add_Goto (Table.States (446), 370, 116);
            Add_Goto (Table.States (446), 376, 117);
            Add_Goto (Table.States (446), 378, 118);
            Add_Goto (Table.States (446), 379, 119);
            Add_Goto (Table.States (446), 382, 120);
            Add_Goto (Table.States (446), 396, 737);
            Add_Goto (Table.States (446), 401, 133);
            Add_Goto (Table.States (446), 461, 332);
            Add_Goto (Table.States (446), 462, 144);
            Table.States (446).Kernel := To_Vector ((0 => ((318, 0),  33,  5, (32767, 0),  0)));
            Table.States (446).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (264, 0),  65, 28)));
            Table.States (447).Action_List.Set_Capacity (50);
            Add_Action (Table.States (447), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (318, 1),  3);
            Table.States (447).Kernel := To_Vector ((0 => ((318, 1),  108,  0, (318, 1),  3)));
            Table.States (447).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (318, 1),  3)));
            Table.States (448).Action_List.Set_Capacity (50);
            Add_Action (Table.States (448), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (290, 0),  3);
            Table.States (448).Kernel := To_Vector ((0 => ((290, 0),  108,  0, (290, 0),  3)));
            Table.States (448).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (290, 0),  3)));
         end Subr_18;
         procedure Subr_19
         is begin
            Table.States (449).Action_List.Set_Capacity (1);
            Add_Action (Table.States (449), 108, (289, 2), 738);
            Table.States (449).Kernel := To_Vector ((0 => ((289, 2),  243,  1, (32767, 0),  0)));
            Table.States (449).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (289, 2),  108, 738)));
            Table.States (450).Action_List.Set_Capacity (14);
            Add_Action (Table.States (450), 12, (402, 0), 165);
            Add_Action (Table.States (450), 44, (233, 2), 167);
            Add_Action (Table.States (450), 52, (233, 3), 168);
            Add_Action (Table.States (450), 65, (234, 1), 169);
            Add_Action (Table.States (450), 76, (256, 0), 170);
            Add_Action (Table.States (450), 85, (205, 4), 171);
            Add_Action (Table.States (450), 86, (213, 2), 172);
            Add_Action (Table.States (450), 90, (268, 0), 34);
            Add_Action (Table.States (450), 106, (237, 1), 173);
            Add_Action (Table.States (450), 107, (237, 0), 174);
            Add_Action (Table.States (450), 115, (234, 0), 175);
            Add_Action (Table.States (450), 116, (196, 0), 146);
            Add_Action (Table.States (450), 117, (196, 1), 37);
            Add_Action (Table.States (450), 118, (195, 6), 38);
            Table.States (450).Goto_List.Set_Capacity (32);
            Add_Goto (Table.States (450), 195, 176);
            Add_Goto (Table.States (450), 196, 148);
            Add_Goto (Table.States (450), 197, 54);
            Add_Goto (Table.States (450), 198, 55);
            Add_Goto (Table.States (450), 199, 56);
            Add_Goto (Table.States (450), 201, 57);
            Add_Goto (Table.States (450), 205, 177);
            Add_Goto (Table.States (450), 206, 178);
            Add_Goto (Table.States (450), 210, 179);
            Add_Goto (Table.States (450), 211, 180);
            Add_Goto (Table.States (450), 213, 181);
            Add_Goto (Table.States (450), 214, 182);
            Add_Goto (Table.States (450), 215, 183);
            Add_Goto (Table.States (450), 218, 184);
            Add_Goto (Table.States (450), 219, 185);
            Add_Goto (Table.States (450), 220, 186);
            Add_Goto (Table.States (450), 227, 236);
            Add_Goto (Table.States (450), 228, 188);
            Add_Goto (Table.States (450), 231, 189);
            Add_Goto (Table.States (450), 232, 190);
            Add_Goto (Table.States (450), 233, 191);
            Add_Goto (Table.States (450), 234, 192);
            Add_Goto (Table.States (450), 237, 193);
            Add_Goto (Table.States (450), 243, 739);
            Add_Goto (Table.States (450), 251, 58);
            Add_Goto (Table.States (450), 252, 59);
            Add_Goto (Table.States (450), 255, 60);
            Add_Goto (Table.States (450), 256, 194);
            Add_Goto (Table.States (450), 268, 68);
            Add_Goto (Table.States (450), 311, 83);
            Add_Goto (Table.States (450), 402, 195);
            Add_Goto (Table.States (450), 465, 196);
            Table.States (450).Kernel := To_Vector ((0 => ((289, 0),  63,  2, (32767, 0),  0)));
            Table.States (450).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (451).Action_List.Set_Capacity (50);
            Add_Action (Table.States (451), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (289, 1),  3);
            Table.States (451).Kernel := To_Vector ((0 => ((289, 1),  108,  0, (289, 1),  3)));
            Table.States (451).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (289, 1),  3)));
            Table.States (452).Action_List.Set_Capacity (3);
            Add_Action (Table.States (452), 23, (396, 0), 740);
            Add_Action (Table.States (452), 66, Reduce, (396, 1),  1);
            Add_Action (Table.States (452), 75, Reduce, (396, 1),  1);
            Table.States (452).Kernel := To_Vector ((((396, 0),  259,  4, (32767, 0),  0), ((396, 1),  259,  0, (396,
            1),  1)));
            Table.States (452).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (396, 1),  1)));
            Table.States (453).Action_List.Set_Capacity (1);
            Add_Action (Table.States (453), 75, (288, 0), 741);
            Table.States (453).Kernel := To_Vector ((0 => ((288, 0),  396,  6, (32767, 0),  0)));
            Table.States (453).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (288, 0),  75, 741)));
            Table.States (454).Action_List.Set_Capacity (3);
            Add_Action (Table.States (454), 45, (278, 0), 469);
            Add_Action (Table.States (454), 69, (280, 12), 470);
            Add_Action (Table.States (454), 93, (280, 0), 471);
            Table.States (454).Kernel := To_Vector ((((278, 0),  116,  5, (32767, 0),  0), ((278, 1),  116,  3, (32767,
            0),  0), ((278, 2),  116,  4, (32767, 0),  0), ((278, 3),  116,  2, (32767, 0),  0), ((280, 0),  116,  7,
            (32767, 0),  0), ((280, 1),  116,  5, (32767, 0),  0), ((280, 2),  116,  6, (32767, 0),  0), ((280, 3),
            116,  4, (32767, 0),  0), ((280, 4),  116,  5, (32767, 0),  0), ((280, 5),  116,  3, (32767, 0),  0),
            ((280, 6),  116,  4, (32767, 0),  0), ((280, 7),  116,  2, (32767, 0),  0), ((280, 8),  116,  7, (32767,
            0),  0), ((280, 9),  116,  5, (32767, 0),  0), ((280, 10),  116,  6, (32767, 0),  0), ((280, 11),  116,  4,
            (32767, 0),  0), ((280, 12),  116,  5, (32767, 0),  0), ((280, 13),  116,  3, (32767, 0),  0), ((280, 14),
            116,  4, (32767, 0),  0), ((280, 15),  116,  2, (32767, 0),  0)));
            Table.States (454).Minimal_Complete_Actions := To_Vector (((Shift, (278, 0),  45, 469), (Shift, (280, 12),
            69, 470)));
            Table.States (455).Action_List.Set_Capacity (1);
            Add_Action (Table.States (455), (1 =>  36), (276, 6),  3);
            Table.States (455).Kernel := To_Vector ((0 => ((276, 6),  278,  0, (276, 6),  3)));
            Table.States (455).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (276, 6),  3)));
            Table.States (456).Action_List.Set_Capacity (1);
            Add_Action (Table.States (456), (1 =>  36), (276, 8),  3);
            Table.States (456).Kernel := To_Vector ((0 => ((276, 8),  280,  0, (276, 8),  3)));
            Table.States (456).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (276, 8),  3)));
            Table.States (457).Action_List.Set_Capacity (1);
            Add_Action (Table.States (457), (1 =>  36), (276, 3),  3);
            Table.States (457).Kernel := To_Vector ((0 => ((276, 3),  282,  0, (276, 3),  3)));
            Table.States (457).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (276, 3),  3)));
            Table.States (458).Action_List.Set_Capacity (14);
            Add_Action (Table.States (458), 43, Reduce, (196, 0),  1);
            Add_Action (Table.States (458), 45, (277, 1), 742);
            Add_Action (Table.States (458), 73, Reduce, (196, 0),  1);
            Add_Action (Table.States (458), 85, Reduce, (196, 0),  1);
            Add_Action (Table.States (458), 87, Reduce, (196, 0),  1);
            Add_Action (Table.States (458), 89, Reduce, (196, 0),  1);
            Add_Action (Table.States (458), 96, Reduce, (196, 0),  1);
            Add_Action (Table.States (458), 106, Reduce, (196, 0),  1);
            Add_Action (Table.States (458), 107, Reduce, (196, 0),  1);
            Add_Action (Table.States (458), 109, Reduce, (196, 0),  1);
            Add_Action (Table.States (458), 111, Reduce, (196, 0),  1);
            Add_Action (Table.States (458), 112, Reduce, (196, 0),  1);
            Add_Action (Table.States (458), 113, Reduce, (196, 0),  1);
            Add_Action (Table.States (458), 114, Reduce, (196, 0),  1);
            Table.States (458).Kernel := To_Vector ((((196, 0),  116,  0, (196, 0),  1), ((277, 1),  116,  2, (32767,
            0),  0)));
            Table.States (458).Minimal_Complete_Actions := To_Vector (((Reduce, (196, 0),  1), (Shift, (277, 1),  45,
            742)));
            Table.States (459).Action_List.Set_Capacity (1);
            Add_Action (Table.States (459), (1 =>  87), (277, 0),  1);
            Table.States (459).Kernel := To_Vector ((0 => ((277, 0),  231,  0, (277, 0),  1)));
            Table.States (459).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (277, 0),  1)));
            Table.States (460).Action_List.Set_Capacity (1);
            Add_Action (Table.States (460), 87, (276, 5), 743);
            Table.States (460).Kernel := To_Vector ((((276, 5),  277,  5, (32767, 0),  0), ((276, 7),  277,  5, (32767,
            0),  0)));
            Table.States (460).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (276, 5),  87, 743)));
            Table.States (461).Action_List.Set_Capacity (25);
            Add_Action (Table.States (461), 12, (401, 0), 1);
            Add_Action (Table.States (461), 15, (370, 0), 3);
            Add_Action (Table.States (461), 17, (365, 0), 4);
            Add_Action (Table.States (461), 18, (382, 0), 5);
            Add_Action (Table.States (461), 19, (363, 0), 6);
            Add_Action (Table.States (461), 20, (357, 0), 7);
            Add_Action (Table.States (461), 30, (316, 0), 13);
            Add_Action (Table.States (461), 31, (290, 0), 14);
            Add_Action (Table.States (461), 32, (289, 0), 15);
            Add_Action (Table.States (461), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (461), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (461), 37, (288, 0), 17);
            Add_Conflict (Table.States (461), 37, (285, 1),  0);
            Add_Action (Table.States (461), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (461), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (461), 41, (271, 0), 18);
            Add_Action (Table.States (461), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (461), 64, (273, 0), 27);
            Add_Action (Table.States (461), 65, (264, 0), 28);
            Add_Action (Table.States (461), 84, (124, 0), 32);
            Add_Action (Table.States (461), 86, (252, 0), 33);
            Add_Action (Table.States (461), 90, (268, 0), 34);
            Add_Action (Table.States (461), 105, (265, 0), 35);
            Add_Action (Table.States (461), 116, (196, 0), 146);
            Add_Action (Table.States (461), 117, (196, 1), 37);
            Add_Action (Table.States (461), 118, (195, 6), 38);
            Table.States (461).Goto_List.Set_Capacity (45);
            Add_Goto (Table.States (461), 124, 39);
            Add_Goto (Table.States (461), 195, 52);
            Add_Goto (Table.States (461), 196, 53);
            Add_Goto (Table.States (461), 197, 54);
            Add_Goto (Table.States (461), 198, 55);
            Add_Goto (Table.States (461), 199, 56);
            Add_Goto (Table.States (461), 201, 57);
            Add_Goto (Table.States (461), 251, 58);
            Add_Goto (Table.States (461), 252, 59);
            Add_Goto (Table.States (461), 255, 60);
            Add_Goto (Table.States (461), 259, 744);
            Add_Goto (Table.States (461), 261, 331);
            Add_Goto (Table.States (461), 262, 62);
            Add_Goto (Table.States (461), 263, 63);
            Add_Goto (Table.States (461), 264, 64);
            Add_Goto (Table.States (461), 265, 65);
            Add_Goto (Table.States (461), 266, 66);
            Add_Goto (Table.States (461), 267, 67);
            Add_Goto (Table.States (461), 268, 68);
            Add_Goto (Table.States (461), 271, 69);
            Add_Goto (Table.States (461), 273, 70);
            Add_Goto (Table.States (461), 275, 71);
            Add_Goto (Table.States (461), 285, 72);
            Add_Goto (Table.States (461), 286, 73);
            Add_Goto (Table.States (461), 288, 74);
            Add_Goto (Table.States (461), 289, 75);
            Add_Goto (Table.States (461), 290, 76);
            Add_Goto (Table.States (461), 310, 82);
            Add_Goto (Table.States (461), 311, 83);
            Add_Goto (Table.States (461), 316, 84);
            Add_Goto (Table.States (461), 318, 85);
            Add_Goto (Table.States (461), 357, 110);
            Add_Goto (Table.States (461), 363, 111);
            Add_Goto (Table.States (461), 364, 112);
            Add_Goto (Table.States (461), 365, 113);
            Add_Goto (Table.States (461), 366, 114);
            Add_Goto (Table.States (461), 367, 115);
            Add_Goto (Table.States (461), 370, 116);
            Add_Goto (Table.States (461), 376, 117);
            Add_Goto (Table.States (461), 378, 118);
            Add_Goto (Table.States (461), 379, 119);
            Add_Goto (Table.States (461), 382, 120);
            Add_Goto (Table.States (461), 401, 133);
            Add_Goto (Table.States (461), 461, 332);
            Add_Goto (Table.States (461), 462, 144);
            Table.States (461).Kernel := To_Vector ((((271, 0),  49,  13, (32767, 0),  0), ((271, 1),  49,  10, (32767,
            0),  0), ((271, 2),  49,  8, (32767, 0),  0), ((271, 3),  49,  5, (32767, 0),  0)));
            Table.States (461).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (264, 0),  65, 28)));
            Table.States (462).Action_List.Set_Capacity (5);
            Add_Action (Table.States (462), 86, (252, 0), 33);
            Add_Action (Table.States (462), 90, (268, 0), 34);
            Add_Action (Table.States (462), 116, (196, 0), 146);
            Add_Action (Table.States (462), 117, (196, 1), 37);
            Add_Action (Table.States (462), 118, (195, 6), 38);
            Table.States (462).Goto_List.Set_Capacity (12);
            Add_Goto (Table.States (462), 195, 244);
            Add_Goto (Table.States (462), 196, 148);
            Add_Goto (Table.States (462), 197, 54);
            Add_Goto (Table.States (462), 198, 55);
            Add_Goto (Table.States (462), 199, 56);
            Add_Goto (Table.States (462), 201, 57);
            Add_Goto (Table.States (462), 251, 58);
            Add_Goto (Table.States (462), 252, 59);
            Add_Goto (Table.States (462), 255, 60);
            Add_Goto (Table.States (462), 268, 68);
            Add_Goto (Table.States (462), 311, 83);
            Add_Goto (Table.States (462), 331, 745);
            Table.States (462).Kernel := To_Vector ((0 => ((333, 0),  83,  2, (32767, 0),  0)));
            Table.States (462).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (463).Action_List.Set_Capacity (2);
            Add_Action (Table.States (463), 95, (331, 1), 464);
            Add_Action (Table.States (463), 108, (333, 1), 746);
            Table.States (463).Kernel := To_Vector ((((331, 1),  331,  2, (32767, 0),  0), ((333, 1),  331,  1, (32767,
            0),  0)));
            Table.States (463).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (333, 1),  108, 746)));
            Table.States (464).Action_List.Set_Capacity (5);
            Add_Action (Table.States (464), 86, (252, 0), 33);
            Add_Action (Table.States (464), 90, (268, 0), 34);
            Add_Action (Table.States (464), 116, (196, 0), 146);
            Add_Action (Table.States (464), 117, (196, 1), 37);
            Add_Action (Table.States (464), 118, (195, 6), 38);
            Table.States (464).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (464), 195, 747);
            Add_Goto (Table.States (464), 196, 148);
            Add_Goto (Table.States (464), 197, 54);
            Add_Goto (Table.States (464), 198, 55);
            Add_Goto (Table.States (464), 199, 56);
            Add_Goto (Table.States (464), 201, 57);
            Add_Goto (Table.States (464), 251, 58);
            Add_Goto (Table.States (464), 252, 59);
            Add_Goto (Table.States (464), 255, 60);
            Add_Goto (Table.States (464), 268, 68);
            Add_Goto (Table.States (464), 311, 83);
            Table.States (464).Kernel := To_Vector ((0 => ((331, 1),  95,  1, (32767, 0),  0)));
            Table.States (464).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (465).Action_List.Set_Capacity (43);
            Add_Action (Table.States (465), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (332, 0),  3);
            Table.States (465).Kernel := To_Vector ((0 => ((332, 0),  108,  0, (332, 0),  3)));
            Table.States (465).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (332, 0),  3)));
            Table.States (466).Action_List.Set_Capacity (3);
            Add_Action (Table.States (466), 87, (283, 1), 748);
            Add_Action (Table.States (466), 93, (300, 0), 749);
            Add_Action (Table.States (466), 95, (136, 1), 280);
            Table.States (466).Kernel := To_Vector ((((136, 1),  136,  2, (32767, 0),  0), ((283, 1),  136,  1, (32767,
            0),  0), ((300, 0),  136,  7, (32767, 0),  0), ((300, 1),  136,  5, (32767, 0),  0), ((300, 2),  136,  5,
            (32767, 0),  0), ((300, 3),  136,  3, (32767, 0),  0), ((300, 4),  136,  6, (32767, 0),  0), ((300, 5),
            136,  4, (32767, 0),  0), ((300, 6),  136,  4, (32767, 0),  0), ((300, 7),  136,  2, (32767, 0),  0),
            ((300, 8),  136,  5, (32767, 0),  0), ((300, 9),  136,  3, (32767, 0),  0)));
            Table.States (466).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (283, 1),  87, 748)));
            Table.States (467).Action_List.Set_Capacity (2);
            Add_Action (Table.States (467), 87, (299, 0), 750);
            Add_Action (Table.States (467), 108, (298, 1), 751);
            Table.States (467).Kernel := To_Vector ((((298, 1),  298,  4, (32767, 0),  0), ((298, 2),  298,  4, (32767,
            0),  0), ((299, 0),  298,  1, (32767, 0),  0)));
            Table.States (467).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (299, 0),  87, 750)));
            Table.States (468).Action_List.Set_Capacity (2);
            Add_Action (Table.States (468), (87, 108), (298, 0),  1);
            Table.States (468).Kernel := To_Vector ((0 => ((298, 0),  300,  0, (298, 0),  1)));
            Table.States (468).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (298, 0),  1)));
            Table.States (469).Action_List.Set_Capacity (14);
            Add_Action (Table.States (469), 34, (278, 0), 752);
            Add_Action (Table.States (469), 44, (233, 2), 167);
            Add_Action (Table.States (469), 52, (187, 0), 356);
            Add_Action (Table.States (469), 65, (234, 1), 169);
            Add_Action (Table.States (469), 76, (256, 0), 170);
            Add_Action (Table.States (469), 85, (205, 4), 171);
            Add_Action (Table.States (469), 86, (213, 2), 172);
            Add_Action (Table.States (469), 90, (268, 0), 34);
            Add_Action (Table.States (469), 106, (237, 1), 173);
            Add_Action (Table.States (469), 107, (237, 0), 174);
            Add_Action (Table.States (469), 115, (234, 0), 175);
            Add_Action (Table.States (469), 116, (196, 0), 146);
            Add_Action (Table.States (469), 117, (196, 1), 37);
            Add_Action (Table.States (469), 118, (195, 6), 38);
            Table.States (469).Goto_List.Set_Capacity (33);
            Add_Goto (Table.States (469), 131, 693);
            Add_Goto (Table.States (469), 140, 694);
            Add_Goto (Table.States (469), 160, 753);
            Add_Goto (Table.States (469), 187, 365);
            Add_Goto (Table.States (469), 195, 754);
            Add_Goto (Table.States (469), 196, 148);
            Add_Goto (Table.States (469), 197, 54);
            Add_Goto (Table.States (469), 198, 55);
            Add_Goto (Table.States (469), 199, 56);
            Add_Goto (Table.States (469), 201, 57);
            Add_Goto (Table.States (469), 203, 369);
            Add_Goto (Table.States (469), 205, 177);
            Add_Goto (Table.States (469), 206, 178);
            Add_Goto (Table.States (469), 210, 179);
            Add_Goto (Table.States (469), 211, 180);
            Add_Goto (Table.States (469), 213, 181);
            Add_Goto (Table.States (469), 214, 182);
            Add_Goto (Table.States (469), 215, 183);
            Add_Goto (Table.States (469), 218, 184);
            Add_Goto (Table.States (469), 219, 185);
            Add_Goto (Table.States (469), 220, 186);
            Add_Goto (Table.States (469), 231, 696);
            Add_Goto (Table.States (469), 232, 190);
            Add_Goto (Table.States (469), 233, 191);
            Add_Goto (Table.States (469), 234, 192);
            Add_Goto (Table.States (469), 237, 193);
            Add_Goto (Table.States (469), 251, 58);
            Add_Goto (Table.States (469), 252, 59);
            Add_Goto (Table.States (469), 255, 60);
            Add_Goto (Table.States (469), 256, 194);
            Add_Goto (Table.States (469), 268, 68);
            Add_Goto (Table.States (469), 311, 83);
            Add_Goto (Table.States (469), 465, 196);
            Table.States (469).Kernel := To_Vector ((((278, 0),  45,  4, (32767, 0),  0), ((278, 1),  45,  2, (32767,
            0),  0), ((278, 2),  45,  3, (32767, 0),  0), ((278, 3),  45,  1, (32767, 0),  0), ((280, 4),  45,  4,
            (32767, 0),  0), ((280, 5),  45,  2, (32767, 0),  0), ((280, 6),  45,  3, (32767, 0),  0), ((280, 7),  45,
            1, (32767, 0),  0)));
            Table.States (469).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (470).Action_List.Set_Capacity (6);
            Add_Action (Table.States (470), 34, (280, 12), 755);
            Add_Action (Table.States (470), 86, (252, 0), 33);
            Add_Action (Table.States (470), 90, (268, 0), 34);
            Add_Action (Table.States (470), 116, (196, 0), 146);
            Add_Action (Table.States (470), 117, (196, 1), 37);
            Add_Action (Table.States (470), 118, (195, 6), 38);
            Table.States (470).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (470), 195, 756);
            Add_Goto (Table.States (470), 196, 148);
            Add_Goto (Table.States (470), 197, 54);
            Add_Goto (Table.States (470), 198, 55);
            Add_Goto (Table.States (470), 199, 56);
            Add_Goto (Table.States (470), 201, 57);
            Add_Goto (Table.States (470), 251, 58);
            Add_Goto (Table.States (470), 252, 59);
            Add_Goto (Table.States (470), 255, 60);
            Add_Goto (Table.States (470), 268, 68);
            Add_Goto (Table.States (470), 311, 83);
            Table.States (470).Kernel := To_Vector ((((280, 12),  69,  4, (32767, 0),  0), ((280, 13),  69,  2, (32767,
            0),  0), ((280, 14),  69,  3, (32767, 0),  0), ((280, 15),  69,  1, (32767, 0),  0)));
            Table.States (470).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (471).Action_List.Set_Capacity (7);
            Add_Action (Table.States (471), 52, (187, 0), 347);
            Add_Action (Table.States (471), 56, (188, 2), 514);
            Add_Action (Table.States (471), 86, (252, 0), 33);
            Add_Action (Table.States (471), 90, (268, 0), 34);
            Add_Action (Table.States (471), 116, (196, 0), 146);
            Add_Action (Table.States (471), 117, (196, 1), 37);
            Add_Action (Table.States (471), 118, (195, 6), 38);
            Table.States (471).Goto_List.Set_Capacity (15);
            Add_Goto (Table.States (471), 131, 757);
            Add_Goto (Table.States (471), 187, 526);
            Add_Goto (Table.States (471), 188, 758);
            Add_Goto (Table.States (471), 195, 528);
            Add_Goto (Table.States (471), 196, 148);
            Add_Goto (Table.States (471), 197, 54);
            Add_Goto (Table.States (471), 198, 55);
            Add_Goto (Table.States (471), 199, 56);
            Add_Goto (Table.States (471), 201, 57);
            Add_Goto (Table.States (471), 251, 58);
            Add_Goto (Table.States (471), 252, 59);
            Add_Goto (Table.States (471), 255, 60);
            Add_Goto (Table.States (471), 268, 68);
            Add_Goto (Table.States (471), 281, 759);
            Add_Goto (Table.States (471), 311, 83);
            Table.States (471).Kernel := To_Vector ((((280, 0),  93,  6, (32767, 0),  0), ((280, 1),  93,  4, (32767,
            0),  0), ((280, 2),  93,  5, (32767, 0),  0), ((280, 3),  93,  3, (32767, 0),  0), ((280, 8),  93,  6,
            (32767, 0),  0), ((280, 9),  93,  4, (32767, 0),  0), ((280, 10),  93,  5, (32767, 0),  0), ((280, 11),
            93,  3, (32767, 0),  0)));
            Table.States (471).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (472).Action_List.Set_Capacity (3);
            Add_Action (Table.States (472), 67, (440, 0), 760);
            Add_Action (Table.States (472), 85, (213, 0), 761);
            Add_Action (Table.States (472), 86, (213, 2), 762);
            Table.States (472).Goto_List.Set_Capacity (5);
            Add_Goto (Table.States (472), 211, 763);
            Add_Goto (Table.States (472), 213, 181);
            Add_Goto (Table.States (472), 214, 182);
            Add_Goto (Table.States (472), 215, 183);
            Add_Goto (Table.States (472), 439, 764);
            Table.States (472).Kernel := To_Vector ((((438, 0),  50,  3, (32767, 0),  0), ((440, 0),  50,  17, (32767,
            0),  0), ((440, 1),  50,  16, (32767, 0),  0), ((440, 2),  50,  9, (32767, 0),  0), ((440, 3),  50,  8,
            (32767, 0),  0), ((440, 4),  50,  13, (32767, 0),  0), ((440, 5),  50,  12, (32767, 0),  0), ((440, 6),
            50,  5, (32767, 0),  0), ((440, 7),  50,  4, (32767, 0),  0)));
            Table.States (472).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (213, 2),  86, 762)));
         end Subr_19;
         procedure Subr_20
         is begin
            Table.States (473).Action_List.Set_Capacity (7);
            Add_Action (Table.States (473), 56, (202, 1), 548);
            Add_Action (Table.States (473), 71, (202, 2), 549);
            Add_Action (Table.States (473), 72, (202, 3), 550);
            Add_Action (Table.States (473), 73, (202, 4), 551);
            Add_Action (Table.States (473), 85, (205, 4), 171);
            Add_Action (Table.States (473), 86, (213, 2), 552);
            Add_Action (Table.States (473), 116, (202, 0), 553);
            Table.States (473).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (473), 202, 765);
            Add_Goto (Table.States (473), 205, 555);
            Add_Goto (Table.States (473), 206, 178);
            Add_Goto (Table.States (473), 210, 179);
            Add_Goto (Table.States (473), 211, 180);
            Add_Goto (Table.States (473), 213, 181);
            Add_Goto (Table.States (473), 214, 182);
            Add_Goto (Table.States (473), 215, 183);
            Add_Goto (Table.States (473), 218, 184);
            Add_Goto (Table.States (473), 219, 185);
            Add_Goto (Table.States (473), 220, 186);
            Table.States (473).Kernel := To_Vector ((((201, 0),  121,  1, (32767, 0),  0), ((255, 0),  121,  2, (32767,
            0),  0), ((437, 0),  121,  4, (32767, 0),  0)));
            Table.States (473).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (202, 0),  116, 553)));
            Table.States (474).Action_List.Set_Capacity (1);
            Add_Action (Table.States (474), 11, (454, 0), 766);
            Table.States (474).Kernel := To_Vector ((0 => ((454, 0),  50,  3, (32767, 0),  0)));
            Table.States (474).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (454, 0),  11, 766)));
            Table.States (475).Action_List.Set_Capacity (5);
            Add_Action (Table.States (475), 86, (252, 0), 33);
            Add_Action (Table.States (475), 90, (268, 0), 34);
            Add_Action (Table.States (475), 116, (196, 0), 146);
            Add_Action (Table.States (475), 117, (196, 1), 37);
            Add_Action (Table.States (475), 118, (195, 6), 38);
            Table.States (475).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (475), 195, 767);
            Add_Goto (Table.States (475), 196, 148);
            Add_Goto (Table.States (475), 197, 54);
            Add_Goto (Table.States (475), 198, 55);
            Add_Goto (Table.States (475), 199, 56);
            Add_Goto (Table.States (475), 201, 57);
            Add_Goto (Table.States (475), 251, 58);
            Add_Goto (Table.States (475), 252, 59);
            Add_Goto (Table.States (475), 255, 60);
            Add_Goto (Table.States (475), 268, 68);
            Add_Goto (Table.States (475), 311, 768);
            Table.States (475).Kernel := To_Vector ((((282, 0),  69,  6, (32767, 0),  0), ((282, 1),  69,  4, (32767,
            0),  0)));
            Table.States (475).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (476).Action_List.Set_Capacity (7);
            Add_Action (Table.States (476), 52, (187, 0), 347);
            Add_Action (Table.States (476), 56, (188, 2), 514);
            Add_Action (Table.States (476), 86, (252, 0), 33);
            Add_Action (Table.States (476), 90, (268, 0), 34);
            Add_Action (Table.States (476), 116, (196, 0), 146);
            Add_Action (Table.States (476), 117, (196, 1), 37);
            Add_Action (Table.States (476), 118, (195, 6), 38);
            Table.States (476).Goto_List.Set_Capacity (13);
            Add_Goto (Table.States (476), 187, 769);
            Add_Goto (Table.States (476), 188, 770);
            Add_Goto (Table.States (476), 195, 771);
            Add_Goto (Table.States (476), 196, 148);
            Add_Goto (Table.States (476), 197, 54);
            Add_Goto (Table.States (476), 198, 55);
            Add_Goto (Table.States (476), 199, 56);
            Add_Goto (Table.States (476), 201, 57);
            Add_Goto (Table.States (476), 251, 58);
            Add_Goto (Table.States (476), 252, 59);
            Add_Goto (Table.States (476), 255, 60);
            Add_Goto (Table.States (476), 268, 68);
            Add_Goto (Table.States (476), 311, 83);
            Table.States (476).Kernel := To_Vector ((((296, 0),  30,  3, (32767, 0),  0), ((296, 1),  30,  1, (32767,
            0),  0), ((296, 2),  30,  2, (32767, 0),  0)));
            Table.States (476).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (477).Action_List.Set_Capacity (1);
            Add_Action (Table.States (477), 76, (408, 8), 772);
            Table.States (477).Kernel := To_Vector ((((408, 8),  82,  5, (32767, 0),  0), ((408, 9),  82,  3, (32767,
            0),  0)));
            Table.States (477).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (408, 8),  76, 772)));
            Table.States (478).Action_List.Set_Capacity (20);
            Add_Action (Table.States (478), 12, (402, 0), 165);
            Add_Action (Table.States (478), 39, (249, 0), 353);
            Add_Action (Table.States (478), 41, (242, 0), 354);
            Add_Action (Table.States (478), 44, (233, 2), 167);
            Add_Action (Table.States (478), 51, (247, 0), 530);
            Add_Action (Table.States (478), 52, (187, 0), 356);
            Add_Action (Table.States (478), 62, (200, 2), 531);
            Add_Action (Table.States (478), 64, (245, 0), 358);
            Add_Action (Table.States (478), 65, (234, 1), 169);
            Add_Action (Table.States (478), 76, (256, 0), 170);
            Add_Action (Table.States (478), 85, (205, 4), 171);
            Add_Action (Table.States (478), 86, (213, 2), 172);
            Add_Action (Table.States (478), 90, (268, 0), 34);
            Add_Action (Table.States (478), 92, (315, 2), 532);
            Add_Action (Table.States (478), 106, (237, 1), 173);
            Add_Action (Table.States (478), 107, (237, 0), 174);
            Add_Action (Table.States (478), 115, (234, 0), 175);
            Add_Action (Table.States (478), 116, (136, 0), 687);
            Add_Action (Table.States (478), 117, (196, 1), 37);
            Add_Action (Table.States (478), 118, (195, 6), 360);
            Table.States (478).Goto_List.Set_Capacity (48);
            Add_Goto (Table.States (478), 131, 533);
            Add_Goto (Table.States (478), 136, 688);
            Add_Goto (Table.States (478), 140, 534);
            Add_Goto (Table.States (478), 163, 535);
            Add_Goto (Table.States (478), 187, 365);
            Add_Goto (Table.States (478), 195, 366);
            Add_Goto (Table.States (478), 196, 367);
            Add_Goto (Table.States (478), 197, 54);
            Add_Goto (Table.States (478), 198, 55);
            Add_Goto (Table.States (478), 199, 56);
            Add_Goto (Table.States (478), 200, 368);
            Add_Goto (Table.States (478), 201, 57);
            Add_Goto (Table.States (478), 203, 369);
            Add_Goto (Table.States (478), 205, 177);
            Add_Goto (Table.States (478), 206, 178);
            Add_Goto (Table.States (478), 209, 536);
            Add_Goto (Table.States (478), 210, 179);
            Add_Goto (Table.States (478), 211, 180);
            Add_Goto (Table.States (478), 213, 181);
            Add_Goto (Table.States (478), 214, 182);
            Add_Goto (Table.States (478), 215, 183);
            Add_Goto (Table.States (478), 218, 184);
            Add_Goto (Table.States (478), 219, 185);
            Add_Goto (Table.States (478), 220, 186);
            Add_Goto (Table.States (478), 227, 537);
            Add_Goto (Table.States (478), 228, 188);
            Add_Goto (Table.States (478), 231, 378);
            Add_Goto (Table.States (478), 232, 190);
            Add_Goto (Table.States (478), 233, 191);
            Add_Goto (Table.States (478), 234, 192);
            Add_Goto (Table.States (478), 237, 193);
            Add_Goto (Table.States (478), 239, 538);
            Add_Goto (Table.States (478), 242, 380);
            Add_Goto (Table.States (478), 245, 381);
            Add_Goto (Table.States (478), 247, 539);
            Add_Goto (Table.States (478), 249, 540);
            Add_Goto (Table.States (478), 251, 58);
            Add_Goto (Table.States (478), 252, 59);
            Add_Goto (Table.States (478), 255, 60);
            Add_Goto (Table.States (478), 256, 194);
            Add_Goto (Table.States (478), 268, 68);
            Add_Goto (Table.States (478), 298, 467);
            Add_Goto (Table.States (478), 300, 468);
            Add_Goto (Table.States (478), 311, 83);
            Add_Goto (Table.States (478), 312, 541);
            Add_Goto (Table.States (478), 315, 542);
            Add_Goto (Table.States (478), 402, 195);
            Add_Goto (Table.States (478), 465, 196);
            Table.States (478).Kernel := To_Vector ((((198, 0),  85,  2, (32767, 0),  0), ((299, 0),  85,  4, (32767,
            0),  0), ((313, 0),  85,  2, (32767, 0),  0), ((313, 1),  85,  5, (32767, 0),  0), ((313, 2),  85,  8,
            (32767, 0),  0), ((313, 3),  85,  4, (32767, 0),  0)));
            Table.States (478).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (479).Action_List.Set_Capacity (10);
            Add_Action (Table.States (479), (24, 33, 45, 48, 61, 69, 82, 87, 94, 108), (297, 1),  1);
            Table.States (479).Kernel := To_Vector ((0 => ((297, 1),  296,  0, (297, 1),  1)));
            Table.States (479).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (297, 1),  1)));
            Table.States (480).Action_List.Set_Capacity (4);
            Add_Action (Table.States (480), (24, 61, 82, 108), (294, 0),  3);
            Table.States (480).Kernel := To_Vector ((0 => ((294, 0),  297,  0, (294, 0),  3)));
            Table.States (480).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (294, 0),  3)));
            Table.States (481).Action_List.Set_Capacity (1);
            Add_Action (Table.States (481), 30, (296, 0), 476);
            Table.States (481).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (481), 296, 773);
            Table.States (481).Kernel := To_Vector ((0 => ((297, 0),  299,  2, (32767, 0),  0)));
            Table.States (481).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (296, 0),  30, 476)));
            Table.States (482).Action_List.Set_Capacity (1);
            Add_Action (Table.States (482), 76, (408, 4), 774);
            Table.States (482).Kernel := To_Vector ((((408, 4),  82,  5, (32767, 0),  0), ((408, 5),  82,  3, (32767,
            0),  0)));
            Table.States (482).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (408, 4),  76, 774)));
            Table.States (483).Action_List.Set_Capacity (4);
            Add_Action (Table.States (483), (24, 61, 82, 108), (293, 0),  3);
            Table.States (483).Kernel := To_Vector ((0 => ((293, 0),  295,  0, (293, 0),  3)));
            Table.States (483).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (293, 0),  3)));
            Table.States (484).Action_List.Set_Capacity (2);
            Add_Action (Table.States (484), 61, (434, 0), 299);
            Add_Action (Table.States (484), 82, (354, 2), 775);
            Table.States (484).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (484), 434, 776);
            Table.States (484).Kernel := To_Vector ((((354, 0),  116,  8, (32767, 0),  0), ((354, 1),  116,  5, (32767,
            0),  0), ((354, 2),  116,  6, (32767, 0),  0), ((354, 3),  116,  3, (32767, 0),  0), ((392, 0),  116,  5,
            (32767, 0),  0), ((392, 1),  116,  3, (32767, 0),  0)));
            Table.States (484).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (354, 2),  82, 775)));
            Table.States (485).Action_List.Set_Capacity (3);
            Add_Action (Table.States (485), 61, (434, 0), 299);
            Add_Action (Table.States (485), 82, (346, 6), 777);
            Add_Action (Table.States (485), 85, (167, 0), 778);
            Table.States (485).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (485), 167, 779);
            Add_Goto (Table.States (485), 434, 780);
            Table.States (485).Kernel := To_Vector ((((346, 0),  116,  13, (32767, 0),  0), ((346, 1),  116,  10,
            (32767, 0),  0), ((346, 2),  116,  11, (32767, 0),  0), ((346, 3),  116,  8, (32767, 0),  0), ((346, 4),
            116,  8, (32767, 0),  0), ((346, 5),  116,  5, (32767, 0),  0), ((346, 6),  116,  6, (32767, 0),  0),
            ((346, 7),  116,  3, (32767, 0),  0)));
            Table.States (485).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (346, 6),  82, 777)));
            Table.States (486).Action_List.Set_Capacity (10);
            Add_Action (Table.States (486), 21, (356, 4), 8);
            Add_Action (Table.States (486), 25, (329, 1), 10);
            Add_Action (Table.States (486), 27, (350, 6), 781);
            Add_Action (Table.States (486), 51, (437, 0), 221);
            Add_Action (Table.States (486), 52, (329, 0), 21);
            Add_Action (Table.States (486), 53, (294, 0), 314);
            Add_Action (Table.States (486), 54, (293, 0), 315);
            Add_Action (Table.States (486), 66, (350, 10), 782);
            Add_Action (Table.States (486), 76, (347, 2), 783);
            Add_Action (Table.States (486), 84, (124, 0), 32);
            Table.States (486).Goto_List.Set_Capacity (15);
            Add_Goto (Table.States (486), 124, 784);
            Add_Goto (Table.States (486), 291, 785);
            Add_Goto (Table.States (486), 292, 786);
            Add_Goto (Table.States (486), 293, 317);
            Add_Goto (Table.States (486), 294, 318);
            Add_Goto (Table.States (486), 329, 787);
            Add_Goto (Table.States (486), 348, 788);
            Add_Goto (Table.States (486), 350, 789);
            Add_Goto (Table.States (486), 351, 790);
            Add_Goto (Table.States (486), 356, 791);
            Add_Goto (Table.States (486), 431, 792);
            Add_Goto (Table.States (486), 437, 140);
            Add_Goto (Table.States (486), 438, 141);
            Add_Goto (Table.States (486), 440, 142);
            Add_Goto (Table.States (486), 454, 143);
            Table.States (486).Kernel := To_Vector ((((347, 2),  82,  5, (32767, 0),  0), ((347, 3),  82,  2, (32767,
            0),  0)));
            Table.States (486).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (350, 10),  66, 782)));
            Table.States (487).Action_List.Set_Capacity (1);
            Add_Action (Table.States (487), 82, (347, 0), 793);
            Table.States (487).Kernel := To_Vector ((((347, 0),  434,  6, (32767, 0),  0), ((347, 1),  434,  3, (32767,
            0),  0)));
            Table.States (487).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (347, 0),  82, 793)));
            Table.States (488).Action_List.Set_Capacity (2);
            Add_Action (Table.States (488), 61, (434, 0), 299);
            Add_Action (Table.States (488), 82, (345, 1), 794);
            Table.States (488).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (488), 434, 795);
            Table.States (488).Kernel := To_Vector ((((345, 0),  116,  8, (32767, 0),  0), ((345, 1),  116,  6, (32767,
            0),  0), ((391, 0),  116,  5, (32767, 0),  0), ((391, 1),  116,  3, (32767, 0),  0)));
            Table.States (488).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (345, 1),  82, 794)));
            Table.States (489).Action_List.Set_Capacity (4);
            Add_Action (Table.States (489), 61, (434, 0), 299);
            Add_Action (Table.States (489), 82, (340, 9), 796);
            Add_Action (Table.States (489), 85, (167, 0), 778);
            Add_Action (Table.States (489), 108, (340, 11), 797);
            Table.States (489).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (489), 167, 798);
            Add_Goto (Table.States (489), 434, 799);
            Table.States (489).Kernel := To_Vector ((((340, 0),  116,  16, (32767, 0),  0), ((340, 1),  116,  13,
            (32767, 0),  0), ((340, 2),  116,  8, (32767, 0),  0), ((340, 3),  116,  14, (32767, 0),  0), ((340, 4),
            116,  11, (32767, 0),  0), ((340, 5),  116,  6, (32767, 0),  0), ((340, 6),  116,  11, (32767, 0),  0),
            ((340, 7),  116,  8, (32767, 0),  0), ((340, 8),  116,  3, (32767, 0),  0), ((340, 9),  116,  9, (32767,
            0),  0), ((340, 10),  116,  6, (32767, 0),  0), ((340, 11),  116,  1, (32767, 0),  0)));
            Table.States (489).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (340, 11),  108, 797)));
            Table.States (490).Action_List.Set_Capacity (5);
            Add_Action (Table.States (490), 21, (356, 4), 8);
            Add_Action (Table.States (490), 25, (329, 1), 10);
            Add_Action (Table.States (490), 51, (437, 0), 221);
            Add_Action (Table.States (490), 52, (329, 0), 21);
            Add_Action (Table.States (490), 76, (341, 3), 800);
            Table.States (490).Goto_List.Set_Capacity (10);
            Add_Goto (Table.States (490), 329, 801);
            Add_Goto (Table.States (490), 342, 802);
            Add_Goto (Table.States (490), 343, 803);
            Add_Goto (Table.States (490), 344, 804);
            Add_Goto (Table.States (490), 356, 805);
            Add_Goto (Table.States (490), 431, 806);
            Add_Goto (Table.States (490), 437, 140);
            Add_Goto (Table.States (490), 438, 141);
            Add_Goto (Table.States (490), 440, 142);
            Add_Goto (Table.States (490), 454, 143);
            Table.States (490).Kernel := To_Vector ((((341, 3),  82,  8, (32767, 0),  0), ((341, 4),  82,  5, (32767,
            0),  0)));
            Table.States (490).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (356, 4),  21, 8)));
            Table.States (491).Action_List.Set_Capacity (43);
            Add_Action (Table.States (491), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (341, 5),  3);
            Table.States (491).Kernel := To_Vector ((0 => ((341, 5),  108,  0, (341, 5),  3)));
            Table.States (491).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (341, 5),  3)));
            Table.States (492).Action_List.Set_Capacity (2);
            Add_Action (Table.States (492), 82, (341, 0), 807);
            Add_Action (Table.States (492), 108, (341, 2), 808);
            Table.States (492).Kernel := To_Vector ((((341, 0),  434,  9, (32767, 0),  0), ((341, 1),  434,  6, (32767,
            0),  0), ((341, 2),  434,  1, (32767, 0),  0)));
            Table.States (492).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (341, 2),  108, 808)));
            Table.States (493).Action_List.Set_Capacity (42);
            Add_Action (Table.States (493), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (387,
            1),  3);
            Table.States (493).Kernel := To_Vector ((0 => ((387, 1),  108,  0, (387, 1),  3)));
            Table.States (493).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (387, 1),  3)));
            Table.States (494).Action_List.Set_Capacity (1);
            Add_Action (Table.States (494), 63, (274, 0), 809);
            Table.States (494).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (494), 272, 810);
            Add_Goto (Table.States (494), 274, 811);
            Table.States (494).Kernel := To_Vector ((0 => ((273, 0),  82,  8, (32767, 0),  0)));
            Table.States (494).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (274, 0),  63, 809)));
            Table.States (495).Action_List.Set_Capacity (5);
            Add_Action (Table.States (495), 86, (252, 0), 33);
            Add_Action (Table.States (495), 90, (268, 0), 34);
            Add_Action (Table.States (495), 116, (196, 0), 146);
            Add_Action (Table.States (495), 117, (196, 1), 37);
            Add_Action (Table.States (495), 118, (195, 6), 38);
            Table.States (495).Goto_List.Set_Capacity (12);
            Add_Goto (Table.States (495), 195, 244);
            Add_Goto (Table.States (495), 196, 148);
            Add_Goto (Table.States (495), 197, 54);
            Add_Goto (Table.States (495), 198, 55);
            Add_Goto (Table.States (495), 199, 56);
            Add_Goto (Table.States (495), 201, 57);
            Add_Goto (Table.States (495), 251, 58);
            Add_Goto (Table.States (495), 252, 59);
            Add_Goto (Table.States (495), 255, 60);
            Add_Goto (Table.States (495), 268, 68);
            Add_Goto (Table.States (495), 311, 83);
            Add_Goto (Table.States (495), 331, 812);
            Table.States (495).Kernel := To_Vector ((0 => ((386, 0),  61,  2, (32767, 0),  0)));
            Table.States (495).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (496).Action_List.Set_Capacity (2);
            Add_Action (Table.States (496), 95, (331, 1), 464);
            Add_Action (Table.States (496), 108, (386, 1), 813);
            Table.States (496).Kernel := To_Vector ((((331, 1),  331,  2, (32767, 0),  0), ((386, 1),  331,  1, (32767,
            0),  0)));
            Table.States (496).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (386, 1),  108, 813)));
            Table.States (497).Action_List.Set_Capacity (6);
            Add_Action (Table.States (497), 52, (187, 0), 347);
            Add_Action (Table.States (497), 86, (252, 0), 33);
            Add_Action (Table.States (497), 90, (268, 0), 34);
            Add_Action (Table.States (497), 116, (196, 0), 146);
            Add_Action (Table.States (497), 117, (196, 1), 37);
            Add_Action (Table.States (497), 118, (195, 6), 38);
            Table.States (497).Goto_List.Set_Capacity (13);
            Add_Goto (Table.States (497), 131, 814);
            Add_Goto (Table.States (497), 187, 365);
            Add_Goto (Table.States (497), 195, 528);
            Add_Goto (Table.States (497), 196, 148);
            Add_Goto (Table.States (497), 197, 54);
            Add_Goto (Table.States (497), 198, 55);
            Add_Goto (Table.States (497), 199, 56);
            Add_Goto (Table.States (497), 201, 57);
            Add_Goto (Table.States (497), 251, 58);
            Add_Goto (Table.States (497), 252, 59);
            Add_Goto (Table.States (497), 255, 60);
            Add_Goto (Table.States (497), 268, 68);
            Add_Goto (Table.States (497), 311, 83);
            Table.States (497).Kernel := To_Vector ((((130, 0),  82,  4, (32767, 0),  0), ((130, 1),  82,  2, (32767,
            0),  0)));
            Table.States (497).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (498).Action_List.Set_Capacity (19);
            Add_Action (Table.States (498), 27, (327, 22), 815);
            Add_Action (Table.States (498), 52, (187, 0), 347);
            Add_Action (Table.States (498), 56, (183, 4), 816);
            Add_Action (Table.States (498), 57, (181, 8), 817);
            Add_Action (Table.States (498), 58, (181, 6), 818);
            Add_Action (Table.States (498), 59, (181, 4), 819);
            Add_Action (Table.States (498), 60, (181, 2), 820);
            Add_Action (Table.States (498), 65, (170, 2), 821);
            Add_Action (Table.States (498), 67, (170, 0), 822);
            Add_Action (Table.States (498), 68, (169, 2), 823);
            Add_Action (Table.States (498), 70, (156, 0), 519);
            Add_Action (Table.States (498), 71, (151, 0), 824);
            Add_Action (Table.States (498), 72, (148, 0), 825);
            Add_Action (Table.States (498), 73, (146, 0), 826);
            Add_Action (Table.States (498), 74, (145, 0), 827);
            Add_Action (Table.States (498), 76, (138, 9), 828);
            Add_Action (Table.States (498), 77, (138, 6), 829);
            Add_Action (Table.States (498), 78, (138, 0), 830);
            Add_Action (Table.States (498), 85, (142, 0), 831);
            Table.States (498).Goto_List.Set_Capacity (20);
            Add_Goto (Table.States (498), 129, 832);
            Add_Goto (Table.States (498), 138, 833);
            Add_Goto (Table.States (498), 142, 834);
            Add_Goto (Table.States (498), 144, 835);
            Add_Goto (Table.States (498), 145, 836);
            Add_Goto (Table.States (498), 146, 837);
            Add_Goto (Table.States (498), 147, 838);
            Add_Goto (Table.States (498), 148, 839);
            Add_Goto (Table.States (498), 150, 840);
            Add_Goto (Table.States (498), 151, 841);
            Add_Goto (Table.States (498), 152, 842);
            Add_Goto (Table.States (498), 154, 843);
            Add_Goto (Table.States (498), 156, 524);
            Add_Goto (Table.States (498), 159, 525);
            Add_Goto (Table.States (498), 169, 844);
            Add_Goto (Table.States (498), 170, 845);
            Add_Goto (Table.States (498), 181, 846);
            Add_Goto (Table.States (498), 183, 847);
            Add_Goto (Table.States (498), 184, 848);
            Add_Goto (Table.States (498), 187, 849);
            Table.States (498).Kernel := To_Vector ((((128, 2),  82,  4, (32767, 0),  0), ((128, 3),  82,  2, (32767,
            0),  0), ((189, 2),  82,  2, (32767, 0),  0), ((327, 12),  82,  7, (32767, 0),  0), ((327, 13),  82,  5,
            (32767, 0),  0), ((327, 14),  82,  6, (32767, 0),  0), ((327, 15),  82,  4, (32767, 0),  0), ((327, 16),
            82,  6, (32767, 0),  0), ((327, 17),  82,  4, (32767, 0),  0), ((327, 18),  82,  5, (32767, 0),  0), ((327,
            19),  82,  3, (32767, 0),  0), ((327, 20),  82,  5, (32767, 0),  0), ((327, 21),  82,  3, (32767, 0),  0),
            ((327, 22),  82,  4, (32767, 0),  0), ((327, 23),  82,  2, (32767, 0),  0), ((328, 24),  82,  11, (32767,
            0),  0), ((328, 25),  82,  9, (32767, 0),  0), ((328, 26),  82,  9, (32767, 0),  0), ((328, 27),  82,  7,
            (32767, 0),  0), ((328, 28),  82,  11, (32767, 0),  0), ((328, 29),  82,  9, (32767, 0),  0), ((328, 30),
            82,  9, (32767, 0),  0), ((328, 31),  82,  7, (32767, 0),  0), ((328, 32),  82,  10, (32767, 0),  0),
            ((328, 33),  82,  8, (32767, 0),  0), ((328, 34),  82,  8, (32767, 0),  0), ((328, 35),  82,  6, (32767,
            0),  0), ((328, 36),  82,  10, (32767, 0),  0), ((328, 37),  82,  8, (32767, 0),  0), ((328, 38),  82,  8,
            (32767, 0),  0), ((328, 39),  82,  6, (32767, 0),  0), ((328, 40),  82,  10, (32767, 0),  0), ((328, 41),
            82,  8, (32767, 0),  0), ((328, 42),  82,  8, (32767, 0),  0), ((328, 43),  82,  6, (32767, 0),  0), ((328,
            44),  82,  9, (32767, 0),  0), ((328, 45),  82,  7, (32767, 0),  0), ((328, 46),  82,  7, (32767, 0),  0),
            ((328, 47),  82,  5, (32767, 0),  0)));
            Table.States (498).Minimal_Complete_Actions := To_Vector (((Shift, (181, 8),  57, 817), (Shift, (169, 2),
            68, 823), (Shift, (327, 22),  27, 815)));
         end Subr_20;
         procedure Subr_21
         is begin
            Table.States (499).Action_List.Set_Capacity (2);
            Add_Action (Table.States (499), 92, (165, 0), 850);
            Add_Action (Table.States (499), 116, (136, 0), 207);
            Table.States (499).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (499), 136, 851);
            Add_Goto (Table.States (499), 166, 852);
            Add_Goto (Table.States (499), 168, 853);
            Table.States (499).Kernel := To_Vector ((((165, 0),  85,  2, (32767, 0),  0), ((167, 0),  85,  4, (32767,
            0),  0)));
            Table.States (499).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (165, 0),  92, 850)));
            Table.States (500).Action_List.Set_Capacity (43);
            Add_Action (Table.States (500), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (189, 3),  3);
            Table.States (500).Kernel := To_Vector ((0 => ((189, 3),  108,  0, (189, 3),  3)));
            Table.States (500).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (189, 3),  3)));
            Table.States (501).Action_List.Set_Capacity (2);
            Add_Action (Table.States (501), 82, (189, 0), 854);
            Add_Action (Table.States (501), 108, (189, 1), 855);
            Table.States (501).Kernel := To_Vector ((((189, 0),  164,  3, (32767, 0),  0), ((189, 1),  164,  1, (32767,
            0),  0), ((327, 0),  164,  8, (32767, 0),  0), ((327, 1),  164,  6, (32767, 0),  0), ((327, 2),  164,  7,
            (32767, 0),  0), ((327, 3),  164,  5, (32767, 0),  0), ((327, 4),  164,  7, (32767, 0),  0), ((327, 5),
            164,  5, (32767, 0),  0), ((327, 6),  164,  6, (32767, 0),  0), ((327, 7),  164,  4, (32767, 0),  0),
            ((327, 8),  164,  6, (32767, 0),  0), ((327, 9),  164,  4, (32767, 0),  0), ((327, 10),  164,  5, (32767,
            0),  0), ((327, 11),  164,  3, (32767, 0),  0), ((328, 0),  164,  12, (32767, 0),  0), ((328, 1),  164,
            10, (32767, 0),  0), ((328, 2),  164,  10, (32767, 0),  0), ((328, 3),  164,  8, (32767, 0),  0), ((328,
            4),  164,  12, (32767, 0),  0), ((328, 5),  164,  10, (32767, 0),  0), ((328, 6),  164,  10, (32767, 0),
            0), ((328, 7),  164,  8, (32767, 0),  0), ((328, 8),  164,  11, (32767, 0),  0), ((328, 9),  164,  9,
            (32767, 0),  0), ((328, 10),  164,  9, (32767, 0),  0), ((328, 11),  164,  7, (32767, 0),  0), ((328, 12),
            164,  11, (32767, 0),  0), ((328, 13),  164,  9, (32767, 0),  0), ((328, 14),  164,  9, (32767, 0),  0),
            ((328, 15),  164,  7, (32767, 0),  0), ((328, 16),  164,  11, (32767, 0),  0), ((328, 17),  164,  9,
            (32767, 0),  0), ((328, 18),  164,  9, (32767, 0),  0), ((328, 19),  164,  7, (32767, 0),  0), ((328, 20),
            164,  10, (32767, 0),  0), ((328, 21),  164,  8, (32767, 0),  0), ((328, 22),  164,  8, (32767, 0),  0),
            ((328, 23),  164,  6, (32767, 0),  0)));
            Table.States (501).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (189, 1),  108, 855)));
            Table.States (502).Action_List.Set_Capacity (3);
            Add_Action (Table.States (502), (48, 82, 108), (164, 0),  1);
            Table.States (502).Kernel := To_Vector ((0 => ((164, 0),  165,  0, (164, 0),  1)));
            Table.States (502).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (164, 0),  1)));
            Table.States (503).Action_List.Set_Capacity (2);
            Add_Action (Table.States (503), 82, (128, 0), 856);
            Add_Conflict (Table.States (503), 82, (164, 1),  1);
            Add_Action (Table.States (503), 108, Reduce, (164, 1),  1);
            Table.States (503).Kernel := To_Vector ((((128, 0),  167,  5, (32767, 0),  0), ((128, 1),  167,  3, (32767,
            0),  0), ((164, 1),  167,  0, (164, 1),  1)));
            Table.States (503).Minimal_Complete_Actions := To_Vector (((Shift, (128, 0),  82, 856), (Reduce, (164, 1),
            1)));
            Table.States (504).Action_List.Set_Capacity (17);
            Add_Action (Table.States (504), 12, (402, 0), 165);
            Add_Action (Table.States (504), 41, (242, 0), 354);
            Add_Action (Table.States (504), 44, (233, 2), 167);
            Add_Action (Table.States (504), 51, (247, 0), 530);
            Add_Action (Table.States (504), 52, (233, 3), 168);
            Add_Action (Table.States (504), 64, (245, 0), 358);
            Add_Action (Table.States (504), 65, (234, 1), 169);
            Add_Action (Table.States (504), 76, (256, 0), 170);
            Add_Action (Table.States (504), 85, (205, 4), 171);
            Add_Action (Table.States (504), 86, (213, 2), 172);
            Add_Action (Table.States (504), 90, (268, 0), 34);
            Add_Action (Table.States (504), 106, (237, 1), 173);
            Add_Action (Table.States (504), 107, (237, 0), 174);
            Add_Action (Table.States (504), 115, (234, 0), 175);
            Add_Action (Table.States (504), 116, (196, 0), 857);
            Add_Action (Table.States (504), 117, (196, 1), 37);
            Add_Action (Table.States (504), 118, (195, 6), 38);
            Table.States (504).Goto_List.Set_Capacity (38);
            Add_Goto (Table.States (504), 122, 858);
            Add_Goto (Table.States (504), 123, 859);
            Add_Goto (Table.States (504), 125, 860);
            Add_Goto (Table.States (504), 195, 176);
            Add_Goto (Table.States (504), 196, 148);
            Add_Goto (Table.States (504), 197, 54);
            Add_Goto (Table.States (504), 198, 55);
            Add_Goto (Table.States (504), 199, 56);
            Add_Goto (Table.States (504), 201, 57);
            Add_Goto (Table.States (504), 205, 177);
            Add_Goto (Table.States (504), 206, 178);
            Add_Goto (Table.States (504), 210, 179);
            Add_Goto (Table.States (504), 211, 180);
            Add_Goto (Table.States (504), 213, 181);
            Add_Goto (Table.States (504), 214, 182);
            Add_Goto (Table.States (504), 215, 183);
            Add_Goto (Table.States (504), 218, 184);
            Add_Goto (Table.States (504), 219, 185);
            Add_Goto (Table.States (504), 220, 186);
            Add_Goto (Table.States (504), 227, 861);
            Add_Goto (Table.States (504), 228, 188);
            Add_Goto (Table.States (504), 231, 189);
            Add_Goto (Table.States (504), 232, 190);
            Add_Goto (Table.States (504), 233, 191);
            Add_Goto (Table.States (504), 234, 192);
            Add_Goto (Table.States (504), 237, 193);
            Add_Goto (Table.States (504), 242, 862);
            Add_Goto (Table.States (504), 245, 863);
            Add_Goto (Table.States (504), 247, 864);
            Add_Goto (Table.States (504), 251, 58);
            Add_Goto (Table.States (504), 252, 59);
            Add_Goto (Table.States (504), 255, 60);
            Add_Goto (Table.States (504), 256, 194);
            Add_Goto (Table.States (504), 268, 68);
            Add_Goto (Table.States (504), 311, 83);
            Add_Goto (Table.States (504), 402, 195);
            Add_Goto (Table.States (504), 435, 865);
            Add_Goto (Table.States (504), 465, 196);
            Table.States (504).Kernel := To_Vector ((((124, 0),  85,  3, (32767, 0),  0), ((124, 2),  85,  6, (32767,
            0),  0)));
            Table.States (504).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (505).Action_List.Set_Capacity (50);
            Add_Action (Table.States (505), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (124, 1),  3);
            Table.States (505).Kernel := To_Vector ((((124, 1),  108,  0, (124, 1),  3), ((124, 3),  108,  0, (124, 3),
             3)));
            Table.States (505).Minimal_Complete_Actions := To_Vector (((Reduce, (124, 1),  3), (Reduce, (124, 3),
            3)));
            Table.States (506).Action_List.Set_Capacity (13);
            Add_Action (Table.States (506), 44, (233, 2), 167);
            Add_Action (Table.States (506), 52, (233, 3), 168);
            Add_Action (Table.States (506), 65, (234, 1), 169);
            Add_Action (Table.States (506), 76, (256, 0), 170);
            Add_Action (Table.States (506), 85, (205, 4), 171);
            Add_Action (Table.States (506), 86, (213, 2), 172);
            Add_Action (Table.States (506), 90, (268, 0), 34);
            Add_Action (Table.States (506), 106, (237, 1), 173);
            Add_Action (Table.States (506), 107, (237, 0), 174);
            Add_Action (Table.States (506), 115, (234, 0), 175);
            Add_Action (Table.States (506), 116, (196, 0), 458);
            Add_Action (Table.States (506), 117, (196, 1), 37);
            Add_Action (Table.States (506), 118, (195, 6), 38);
            Table.States (506).Goto_List.Set_Capacity (29);
            Add_Goto (Table.States (506), 195, 176);
            Add_Goto (Table.States (506), 196, 148);
            Add_Goto (Table.States (506), 197, 54);
            Add_Goto (Table.States (506), 198, 55);
            Add_Goto (Table.States (506), 199, 56);
            Add_Goto (Table.States (506), 201, 57);
            Add_Goto (Table.States (506), 205, 177);
            Add_Goto (Table.States (506), 206, 178);
            Add_Goto (Table.States (506), 210, 179);
            Add_Goto (Table.States (506), 211, 180);
            Add_Goto (Table.States (506), 213, 181);
            Add_Goto (Table.States (506), 214, 182);
            Add_Goto (Table.States (506), 215, 183);
            Add_Goto (Table.States (506), 218, 184);
            Add_Goto (Table.States (506), 219, 185);
            Add_Goto (Table.States (506), 220, 186);
            Add_Goto (Table.States (506), 231, 459);
            Add_Goto (Table.States (506), 232, 190);
            Add_Goto (Table.States (506), 233, 191);
            Add_Goto (Table.States (506), 234, 192);
            Add_Goto (Table.States (506), 237, 193);
            Add_Goto (Table.States (506), 251, 58);
            Add_Goto (Table.States (506), 252, 59);
            Add_Goto (Table.States (506), 255, 60);
            Add_Goto (Table.States (506), 256, 194);
            Add_Goto (Table.States (506), 268, 68);
            Add_Goto (Table.States (506), 277, 866);
            Add_Goto (Table.States (506), 311, 83);
            Add_Goto (Table.States (506), 465, 196);
            Table.States (506).Kernel := To_Vector ((0 => ((252, 0),  85,  9, (32767, 0),  0)));
            Table.States (506).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (507).Action_List.Set_Capacity (1);
            Add_Action (Table.States (507), 88, (252, 1), 867);
            Table.States (507).Kernel := To_Vector ((0 => ((252, 1),  221,  1, (32767, 0),  0)));
            Table.States (507).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (252, 1),  88, 867)));
            Table.States (508).Action_List.Set_Capacity (2);
            Add_Action (Table.States (508), 50, (221, 0), 868);
            Add_Action (Table.States (508), 99, (314, 0), 632);
            Table.States (508).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (508), 314, 869);
            Table.States (508).Kernel := To_Vector ((((221, 0),  278,  4, (32767, 0),  0), ((221, 1),  278,  2, (32767,
            0),  0)));
            Table.States (508).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (314, 0),  99, 632)));
            Table.States (509).Action_List.Set_Capacity (2);
            Add_Action (Table.States (509), 50, (221, 2), 870);
            Add_Action (Table.States (509), 99, (314, 0), 632);
            Table.States (509).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (509), 314, 871);
            Table.States (509).Kernel := To_Vector ((((221, 2),  280,  4, (32767, 0),  0), ((221, 3),  280,  2, (32767,
            0),  0)));
            Table.States (509).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (314, 0),  99, 632)));
            Table.States (510).Action_List.Set_Capacity (2);
            Add_Action (Table.States (510), (113, 114), (252, 2),  3);
            Table.States (510).Kernel := To_Vector ((0 => ((252, 2),  88,  0, (252, 2),  3)));
            Table.States (510).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (252, 2),  3)));
            Table.States (511).Action_List.Set_Capacity (50);
            Add_Action (Table.States (511), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (265, 0),  3);
            Table.States (511).Kernel := To_Vector ((0 => ((265, 0),  102,  0, (265, 0),  3)));
            Table.States (511).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (265, 0),  3)));
            Table.States (512).Action_List.Set_Capacity (6);
            Add_Action (Table.States (512), 61, (434, 0), 299);
            Add_Action (Table.States (512), 85, (198, 0), 281);
            Add_Action (Table.States (512), 96, (197, 0), 283);
            Add_Action (Table.States (512), 108, (335, 5), 872);
            Add_Action (Table.States (512), 113, (121, 0), 285);
            Add_Action (Table.States (512), 114, (121, 1), 286);
            Table.States (512).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (512), 121, 287);
            Add_Goto (Table.States (512), 313, 289);
            Add_Goto (Table.States (512), 434, 873);
            Table.States (512).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((335, 4),  195,  3, (32767, 0),  0), ((335, 5),
            195,  1, (32767, 0),  0)));
            Table.States (512).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (335, 5),  108, 872)));
            Table.States (513).Action_List.Set_Capacity (1);
            Add_Action (Table.States (513), 24, (336, 0), 874);
            Table.States (513).Kernel := To_Vector ((((336, 0),  23,  5, (32767, 0),  0), ((336, 1),  23,  3, (32767,
            0),  0)));
            Table.States (513).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (336, 0),  24, 874)));
            Table.States (514).Action_List.Set_Capacity (9);
            Add_Action (Table.States (514), 53, (188, 11), 875);
            Add_Action (Table.States (514), 54, (188, 7), 876);
            Add_Action (Table.States (514), 59, (188, 6), 877);
            Add_Action (Table.States (514), 79, (188, 2), 878);
            Add_Action (Table.States (514), 86, (252, 0), 33);
            Add_Action (Table.States (514), 90, (268, 0), 34);
            Add_Action (Table.States (514), 116, (196, 0), 146);
            Add_Action (Table.States (514), 117, (196, 1), 37);
            Add_Action (Table.States (514), 118, (195, 6), 38);
            Table.States (514).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (514), 195, 879);
            Add_Goto (Table.States (514), 196, 148);
            Add_Goto (Table.States (514), 197, 54);
            Add_Goto (Table.States (514), 198, 55);
            Add_Goto (Table.States (514), 199, 56);
            Add_Goto (Table.States (514), 201, 57);
            Add_Goto (Table.States (514), 251, 58);
            Add_Goto (Table.States (514), 252, 59);
            Add_Goto (Table.States (514), 255, 60);
            Add_Goto (Table.States (514), 268, 68);
            Add_Goto (Table.States (514), 311, 83);
            Table.States (514).Kernel := To_Vector ((((188, 2),  56,  2, (32767, 0),  0), ((188, 3),  56,  1, (32767,
            0),  0), ((188, 6),  56,  2, (32767, 0),  0), ((188, 7),  56,  1, (32767, 0),  0), ((188, 10),  56,  4,
            (32767, 0),  0), ((188, 11),  56,  3, (32767, 0),  0)));
            Table.States (514).Minimal_Complete_Actions := To_Vector (((Shift, (196, 0),  116, 146), (Shift, (188, 7),
            54, 876)));
            Table.States (515).Action_List.Set_Capacity (6);
            Add_Action (Table.States (515), 56, (188, 0), 880);
            Add_Action (Table.States (515), 86, (252, 0), 33);
            Add_Action (Table.States (515), 90, (268, 0), 34);
            Add_Action (Table.States (515), 116, (196, 0), 146);
            Add_Action (Table.States (515), 117, (196, 1), 37);
            Add_Action (Table.States (515), 118, (195, 6), 38);
            Table.States (515).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (515), 195, 881);
            Add_Goto (Table.States (515), 196, 148);
            Add_Goto (Table.States (515), 197, 54);
            Add_Goto (Table.States (515), 198, 55);
            Add_Goto (Table.States (515), 199, 56);
            Add_Goto (Table.States (515), 201, 57);
            Add_Goto (Table.States (515), 251, 58);
            Add_Goto (Table.States (515), 252, 59);
            Add_Goto (Table.States (515), 255, 60);
            Add_Goto (Table.States (515), 268, 68);
            Add_Goto (Table.States (515), 311, 83);
            Table.States (515).Kernel := To_Vector ((((188, 0),  187,  3, (32767, 0),  0), ((188, 1),  187,  2, (32767,
            0),  0), ((188, 4),  187,  3, (32767, 0),  0), ((188, 5),  187,  2, (32767, 0),  0), ((188, 8),  187,  5,
            (32767, 0),  0), ((188, 9),  187,  4, (32767, 0),  0), ((335, 0),  187,  6, (32767, 0),  0), ((335, 1),
            187,  4, (32767, 0),  0)));
            Table.States (515).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (188, 0),  56, 880)));
            Table.States (516).Action_List.Set_Capacity (1);
            Add_Action (Table.States (516), 24, (335, 6), 882);
            Table.States (516).Kernel := To_Vector ((((335, 6),  188,  5, (32767, 0),  0), ((335, 7),  188,  3, (32767,
            0),  0)));
            Table.States (516).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (335, 6),  24, 882)));
            Table.States (517).Action_List.Set_Capacity (5);
            Add_Action (Table.States (517), 24, (335, 2), 883);
            Add_Action (Table.States (517), 85, (198, 0), 281);
            Add_Action (Table.States (517), 96, (197, 0), 283);
            Add_Action (Table.States (517), 113, (121, 0), 285);
            Add_Action (Table.States (517), 114, (121, 1), 286);
            Table.States (517).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (517), 121, 287);
            Add_Goto (Table.States (517), 313, 289);
            Table.States (517).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((335, 2),  195,  5, (32767, 0),  0), ((335, 3),
            195,  3, (32767, 0),  0)));
            Table.States (517).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (335, 2),  24, 883)));
            Table.States (518).Action_List.Set_Capacity (2);
            Add_Action (Table.States (518), 61, (434, 0), 299);
            Add_Action (Table.States (518), 108, (394, 1), 884);
            Table.States (518).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (518), 434, 885);
            Table.States (518).Kernel := To_Vector ((((394, 0),  23,  3, (32767, 0),  0), ((394, 1),  23,  1, (32767,
            0),  0)));
            Table.States (518).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (394, 1),  108, 884)));
            Table.States (519).Action_List.Set_Capacity (1);
            Add_Action (Table.States (519), 85, (156, 0), 886);
            Table.States (519).Kernel := To_Vector ((((156, 0),  70,  7, (32767, 0),  0), ((159, 0),  70,  5, (32767,
            0),  0)));
            Table.States (519).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (156, 0),  85, 886)));
            Table.States (520).Action_List.Set_Capacity (9);
            Add_Action (Table.States (520), 52, (187, 0), 347);
            Add_Action (Table.States (520), 56, (188, 2), 514);
            Add_Action (Table.States (520), 70, (156, 0), 519);
            Add_Action (Table.States (520), 86, (252, 0), 33);
            Add_Action (Table.States (520), 90, (268, 0), 34);
            Add_Action (Table.States (520), 94, (134, 0), 282);
            Add_Action (Table.States (520), 116, (196, 0), 146);
            Add_Action (Table.States (520), 117, (196, 1), 37);
            Add_Action (Table.States (520), 118, (195, 6), 38);
            Table.States (520).Goto_List.Set_Capacity (18);
            Add_Goto (Table.States (520), 131, 887);
            Add_Goto (Table.States (520), 134, 888);
            Add_Goto (Table.States (520), 154, 889);
            Add_Goto (Table.States (520), 156, 524);
            Add_Goto (Table.States (520), 159, 525);
            Add_Goto (Table.States (520), 187, 526);
            Add_Goto (Table.States (520), 188, 890);
            Add_Goto (Table.States (520), 195, 528);
            Add_Goto (Table.States (520), 196, 148);
            Add_Goto (Table.States (520), 197, 54);
            Add_Goto (Table.States (520), 198, 55);
            Add_Goto (Table.States (520), 199, 56);
            Add_Goto (Table.States (520), 201, 57);
            Add_Goto (Table.States (520), 251, 58);
            Add_Goto (Table.States (520), 252, 59);
            Add_Goto (Table.States (520), 255, 60);
            Add_Goto (Table.States (520), 268, 68);
            Add_Goto (Table.States (520), 311, 83);
            Table.States (520).Kernel := To_Vector ((((135, 8),  79,  6, (32767, 0),  0), ((135, 9),  79,  4, (32767,
            0),  0), ((135, 10),  79,  4, (32767, 0),  0), ((135, 11),  79,  2, (32767, 0),  0), ((135, 24),  79,  7,
            (32767, 0),  0), ((135, 25),  79,  5, (32767, 0),  0), ((135, 26),  79,  5, (32767, 0),  0), ((135, 27),
            79,  3, (32767, 0),  0), ((135, 40),  79,  12, (32767, 0),  0), ((135, 41),  79,  10, (32767, 0),  0),
            ((135, 42),  79,  10, (32767, 0),  0), ((135, 43),  79,  8, (32767, 0),  0), ((137, 0),  79,  3, (32767,
            0),  0)));
            Table.States (520).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (521).Action_List.Set_Capacity (9);
            Add_Action (Table.States (521), 52, (187, 0), 347);
            Add_Action (Table.States (521), 56, (188, 2), 514);
            Add_Action (Table.States (521), 70, (156, 0), 519);
            Add_Action (Table.States (521), 79, (135, 0), 891);
            Add_Action (Table.States (521), 86, (252, 0), 33);
            Add_Action (Table.States (521), 90, (268, 0), 34);
            Add_Action (Table.States (521), 116, (196, 0), 146);
            Add_Action (Table.States (521), 117, (196, 1), 37);
            Add_Action (Table.States (521), 118, (195, 6), 38);
            Table.States (521).Goto_List.Set_Capacity (17);
            Add_Goto (Table.States (521), 131, 892);
            Add_Goto (Table.States (521), 154, 893);
            Add_Goto (Table.States (521), 156, 524);
            Add_Goto (Table.States (521), 159, 525);
            Add_Goto (Table.States (521), 187, 526);
            Add_Goto (Table.States (521), 188, 894);
            Add_Goto (Table.States (521), 195, 528);
            Add_Goto (Table.States (521), 196, 148);
            Add_Goto (Table.States (521), 197, 54);
            Add_Goto (Table.States (521), 198, 55);
            Add_Goto (Table.States (521), 199, 56);
            Add_Goto (Table.States (521), 201, 57);
            Add_Goto (Table.States (521), 251, 58);
            Add_Goto (Table.States (521), 252, 59);
            Add_Goto (Table.States (521), 255, 60);
            Add_Goto (Table.States (521), 268, 68);
            Add_Goto (Table.States (521), 311, 83);
            Table.States (521).Kernel := To_Vector ((((135, 0),  80,  7, (32767, 0),  0), ((135, 1),  80,  5, (32767,
            0),  0), ((135, 2),  80,  5, (32767, 0),  0), ((135, 3),  80,  3, (32767, 0),  0), ((135, 4),  80,  6,
            (32767, 0),  0), ((135, 5),  80,  4, (32767, 0),  0), ((135, 6),  80,  4, (32767, 0),  0), ((135, 7),  80,
            2, (32767, 0),  0), ((135, 16),  80,  8, (32767, 0),  0), ((135, 17),  80,  6, (32767, 0),  0), ((135, 18),
             80,  6, (32767, 0),  0), ((135, 19),  80,  4, (32767, 0),  0), ((135, 20),  80,  7, (32767, 0),  0),
            ((135, 21),  80,  5, (32767, 0),  0), ((135, 22),  80,  5, (32767, 0),  0), ((135, 23),  80,  3, (32767,
            0),  0), ((135, 32),  80,  13, (32767, 0),  0), ((135, 33),  80,  11, (32767, 0),  0), ((135, 34),  80,
            11, (32767, 0),  0), ((135, 35),  80,  9, (32767, 0),  0), ((135, 36),  80,  12, (32767, 0),  0), ((135,
            37),  80,  10, (32767, 0),  0), ((135, 38),  80,  10, (32767, 0),  0), ((135, 39),  80,  8, (32767, 0),
            0)));
            Table.States (521).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (522).Action_List.Set_Capacity (3);
            Add_Action (Table.States (522), 61, (434, 0), 299);
            Add_Action (Table.States (522), 94, (134, 0), 282);
            Add_Action (Table.States (522), 108, (135, 15), 895);
            Table.States (522).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (522), 134, 896);
            Add_Goto (Table.States (522), 434, 897);
            Table.States (522).Kernel := To_Vector ((((135, 12),  131,  5, (32767, 0),  0), ((135, 13),  131,  3,
            (32767, 0),  0), ((135, 14),  131,  3, (32767, 0),  0), ((135, 15),  131,  1, (32767, 0),  0)));
            Table.States (522).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 15),  108, 895)));
            Table.States (523).Action_List.Set_Capacity (3);
            Add_Action (Table.States (523), 61, (434, 0), 299);
            Add_Action (Table.States (523), 94, (134, 0), 282);
            Add_Action (Table.States (523), 108, (135, 47), 898);
            Table.States (523).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (523), 134, 899);
            Add_Goto (Table.States (523), 434, 900);
            Table.States (523).Kernel := To_Vector ((((135, 44),  154,  5, (32767, 0),  0), ((135, 45),  154,  3,
            (32767, 0),  0), ((135, 46),  154,  3, (32767, 0),  0), ((135, 47),  154,  1, (32767, 0),  0)));
            Table.States (523).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 47),  108, 898)));
            Table.States (524).Action_List.Set_Capacity (4);
            Add_Action (Table.States (524), (48, 61, 94, 108), (154, 0),  1);
            Table.States (524).Kernel := To_Vector ((0 => ((154, 0),  156,  0, (154, 0),  1)));
            Table.States (524).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (154, 0),  1)));
            Table.States (525).Action_List.Set_Capacity (4);
            Add_Action (Table.States (525), (48, 61, 94, 108), (154, 1),  1);
            Table.States (525).Kernel := To_Vector ((0 => ((154, 1),  159,  0, (154, 1),  1)));
            Table.States (525).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (154, 1),  1)));
         end Subr_21;
         procedure Subr_22
         is begin
            Table.States (526).Action_List.Set_Capacity (6);
            Add_Action (Table.States (526), 56, (188, 0), 880);
            Add_Action (Table.States (526), 86, (252, 0), 33);
            Add_Action (Table.States (526), 90, (268, 0), 34);
            Add_Action (Table.States (526), 116, (196, 0), 146);
            Add_Action (Table.States (526), 117, (196, 1), 37);
            Add_Action (Table.States (526), 118, (195, 6), 38);
            Table.States (526).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (526), 195, 634);
            Add_Goto (Table.States (526), 196, 148);
            Add_Goto (Table.States (526), 197, 54);
            Add_Goto (Table.States (526), 198, 55);
            Add_Goto (Table.States (526), 199, 56);
            Add_Goto (Table.States (526), 201, 57);
            Add_Goto (Table.States (526), 251, 58);
            Add_Goto (Table.States (526), 252, 59);
            Add_Goto (Table.States (526), 255, 60);
            Add_Goto (Table.States (526), 268, 68);
            Add_Goto (Table.States (526), 311, 83);
            Table.States (526).Kernel := To_Vector ((((131, 0),  187,  3, (32767, 0),  0), ((131, 1),  187,  1, (32767,
            0),  0), ((188, 0),  187,  3, (32767, 0),  0), ((188, 1),  187,  2, (32767, 0),  0), ((188, 4),  187,  3,
            (32767, 0),  0), ((188, 5),  187,  2, (32767, 0),  0), ((188, 8),  187,  5, (32767, 0),  0), ((188, 9),
            187,  4, (32767, 0),  0)));
            Table.States (526).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (527).Action_List.Set_Capacity (3);
            Add_Action (Table.States (527), 61, (434, 0), 299);
            Add_Action (Table.States (527), 94, (134, 0), 282);
            Add_Action (Table.States (527), 108, (135, 31), 901);
            Table.States (527).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (527), 134, 902);
            Add_Goto (Table.States (527), 434, 903);
            Table.States (527).Kernel := To_Vector ((((135, 28),  188,  5, (32767, 0),  0), ((135, 29),  188,  3,
            (32767, 0),  0), ((135, 30),  188,  3, (32767, 0),  0), ((135, 31),  188,  1, (32767, 0),  0)));
            Table.States (527).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 31),  108, 901)));
            Table.States (528).Action_List.Set_Capacity (15);
            Add_Action (Table.States (528), 33, Reduce, (131, 3),  1);
            Add_Action (Table.States (528), 45, Reduce, (131, 3),  1);
            Add_Action (Table.States (528), 48, Reduce, (131, 3),  1);
            Add_Action (Table.States (528), 61, Reduce, (131, 3),  1);
            Add_Action (Table.States (528), 69, Reduce, (131, 3),  1);
            Add_Action (Table.States (528), 71, (453, 0), 635);
            Add_Action (Table.States (528), 72, (153, 0), 636);
            Add_Action (Table.States (528), 74, (139, 0), 637);
            Add_Action (Table.States (528), 75, Reduce, (131, 3),  1);
            Add_Action (Table.States (528), 85, (162, 0), 612);
            Add_Action (Table.States (528), 94, Reduce, (131, 3),  1);
            Add_Action (Table.States (528), 96, (197, 0), 283);
            Add_Action (Table.States (528), 108, Reduce, (131, 3),  1);
            Add_Action (Table.States (528), 113, (121, 0), 285);
            Add_Action (Table.States (528), 114, (121, 1), 286);
            Table.States (528).Goto_List.Set_Capacity (8);
            Add_Goto (Table.States (528), 121, 287);
            Add_Goto (Table.States (528), 132, 639);
            Add_Goto (Table.States (528), 133, 640);
            Add_Goto (Table.States (528), 139, 641);
            Add_Goto (Table.States (528), 153, 642);
            Add_Goto (Table.States (528), 162, 643);
            Add_Goto (Table.States (528), 313, 289);
            Add_Goto (Table.States (528), 453, 644);
            Table.States (528).Kernel := To_Vector ((((131, 2),  195,  2, (32767, 0),  0), ((131, 3),  195,  0, (131,
            3),  1), ((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767, 0),  0), ((199, 0),  195,  2,
            (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3, (32767, 0),  0), ((311, 0),
            195,  3, (32767, 0),  0)));
            Table.States (528).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (131, 3),  1)));
            Table.States (529).Action_List.Set_Capacity (3);
            Add_Action (Table.States (529), (87, 93, 95), (136, 1),  3);
            Table.States (529).Kernel := To_Vector ((0 => ((136, 1),  116,  0, (136, 1),  3)));
            Table.States (529).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (136, 1),  3)));
            Table.States (530).Action_List.Set_Capacity (2);
            Add_Action (Table.States (530), 40, (248, 1), 625);
            Add_Action (Table.States (530), 55, (248, 0), 626);
            Table.States (530).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (530), 248, 627);
            Table.States (530).Kernel := To_Vector ((((247, 0),  51,  6, (32767, 0),  0), ((247, 1),  51,  6, (32767,
            0),  0)));
            Table.States (530).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (248, 0),  55, 626)));
            Table.States (531).Action_List.Set_Capacity (47);
            Add_Action (Table.States (531), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (200, 2),  1);
            Table.States (531).Kernel := To_Vector ((0 => ((200, 2),  62,  0, (200, 2),  1)));
            Table.States (531).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (200, 2),  1)));
            Table.States (532).Action_List.Set_Capacity (2);
            Add_Action (Table.States (532), (87, 95), (315, 2),  1);
            Table.States (532).Kernel := To_Vector ((0 => ((315, 2),  92,  0, (315, 2),  1)));
            Table.States (532).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (315, 2),  1)));
            Table.States (533).Action_List.Set_Capacity (2);
            Add_Action (Table.States (533), (87, 95), (163, 0),  1);
            Table.States (533).Kernel := To_Vector ((0 => ((163, 0),  131,  0, (163, 0),  1)));
            Table.States (533).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (163, 0),  1)));
            Table.States (534).Action_List.Set_Capacity (2);
            Add_Action (Table.States (534), (87, 95), (163, 1),  1);
            Table.States (534).Kernel := To_Vector ((0 => ((163, 1),  140,  0, (163, 1),  1)));
            Table.States (534).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (163, 1),  1)));
            Table.States (535).Action_List.Set_Capacity (1);
            Add_Action (Table.States (535), 87, (198, 0), 904);
            Table.States (535).Kernel := To_Vector ((0 => ((198, 0),  163,  1, (32767, 0),  0)));
            Table.States (535).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (198, 0),  87, 904)));
            Table.States (536).Action_List.Set_Capacity (2);
            Add_Action (Table.States (536), 91, (209, 1), 646);
            Add_Action (Table.States (536), 99, (314, 0), 632);
            Table.States (536).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (536), 314, 905);
            Table.States (536).Kernel := To_Vector ((((209, 1),  209,  2, (32767, 0),  0), ((315, 0),  209,  2, (32767,
            0),  0)));
            Table.States (536).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (314, 0),  99, 632)));
            Table.States (537).Action_List.Set_Capacity (2);
            Add_Action (Table.States (537), (87, 95), (315, 1),  1);
            Table.States (537).Kernel := To_Vector ((0 => ((315, 1),  227,  0, (315, 1),  1)));
            Table.States (537).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (315, 1),  1)));
            Table.States (538).Action_List.Set_Capacity (1);
            Add_Action (Table.States (538), 87, (313, 1), 906);
            Table.States (538).Kernel := To_Vector ((0 => ((313, 1),  239,  1, (32767, 0),  0)));
            Table.States (538).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (313, 1),  87, 906)));
            Table.States (539).Action_List.Set_Capacity (1);
            Add_Action (Table.States (539), 87, (313, 2), 907);
            Table.States (539).Kernel := To_Vector ((0 => ((313, 2),  247,  1, (32767, 0),  0)));
            Table.States (539).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (313, 2),  87, 907)));
            Table.States (540).Action_List.Set_Capacity (1);
            Add_Action (Table.States (540), 87, (313, 3), 908);
            Table.States (540).Kernel := To_Vector ((0 => ((313, 3),  249,  1, (32767, 0),  0)));
            Table.States (540).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (313, 3),  87, 908)));
            Table.States (541).Action_List.Set_Capacity (2);
            Add_Action (Table.States (541), 87, (313, 0), 909);
            Add_Action (Table.States (541), 95, (312, 1), 910);
            Table.States (541).Kernel := To_Vector ((((312, 1),  312,  2, (32767, 0),  0), ((313, 0),  312,  1, (32767,
            0),  0)));
            Table.States (541).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (313, 0),  87, 909)));
            Table.States (542).Action_List.Set_Capacity (2);
            Add_Action (Table.States (542), (87, 95), (312, 0),  1);
            Table.States (542).Kernel := To_Vector ((0 => ((312, 0),  315,  0, (312, 0),  1)));
            Table.States (542).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (312, 0),  1)));
            Table.States (543).Action_List.Set_Capacity (4);
            Add_Action (Table.States (543), (33, 61, 87, 108), (134, 0),  2);
            Table.States (543).Kernel := To_Vector ((0 => ((134, 0),  227,  0, (134, 0),  2)));
            Table.States (543).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (134, 0),  2)));
            Table.States (544).Action_List.Set_Capacity (47);
            Add_Action (Table.States (544), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (197, 0),  3);
            Table.States (544).Kernel := To_Vector ((0 => ((197, 0),  55,  0, (197, 0),  3)));
            Table.States (544).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (197, 0),  3)));
            Table.States (545).Action_List.Set_Capacity (47);
            Add_Action (Table.States (545), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (200, 1),  1);
            Table.States (545).Kernel := To_Vector ((0 => ((200, 1),  118,  0, (200, 1),  1)));
            Table.States (545).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (200, 1),  1)));
            Table.States (546).Action_List.Set_Capacity (47);
            Add_Action (Table.States (546), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (200, 0),  1);
            Table.States (546).Kernel := To_Vector ((0 => ((200, 0),  196,  0, (200, 0),  1)));
            Table.States (546).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (200, 0),  1)));
            Table.States (547).Action_List.Set_Capacity (47);
            Add_Action (Table.States (547), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (199, 0),  3);
            Table.States (547).Kernel := To_Vector ((0 => ((199, 0),  200,  0, (199, 0),  3)));
            Table.States (547).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (199, 0),  3)));
            Table.States (548).Action_List.Set_Capacity (47);
            Add_Action (Table.States (548), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (202, 1),  1);
            Table.States (548).Kernel := To_Vector ((0 => ((202, 1),  56,  0, (202, 1),  1)));
            Table.States (548).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (202, 1),  1)));
            Table.States (549).Action_List.Set_Capacity (47);
            Add_Action (Table.States (549), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (202, 2),  1);
            Table.States (549).Kernel := To_Vector ((0 => ((202, 2),  71,  0, (202, 2),  1)));
            Table.States (549).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (202, 2),  1)));
            Table.States (550).Action_List.Set_Capacity (47);
            Add_Action (Table.States (550), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (202, 3),  1);
            Table.States (550).Kernel := To_Vector ((0 => ((202, 3),  72,  0, (202, 3),  1)));
            Table.States (550).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (202, 3),  1)));
            Table.States (551).Action_List.Set_Capacity (47);
            Add_Action (Table.States (551), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (202, 4),  1);
            Table.States (551).Kernel := To_Vector ((0 => ((202, 4),  73,  0, (202, 4),  1)));
            Table.States (551).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (202, 4),  1)));
            Table.States (552).Action_List.Set_Capacity (17);
            Add_Action (Table.States (552), 12, (402, 0), 165);
            Add_Action (Table.States (552), 44, (233, 2), 167);
            Add_Action (Table.States (552), 51, (221, 0), 273);
            Add_Action (Table.States (552), 52, (187, 0), 356);
            Add_Action (Table.States (552), 62, (178, 3), 385);
            Add_Action (Table.States (552), 65, (234, 1), 169);
            Add_Action (Table.States (552), 76, (256, 0), 170);
            Add_Action (Table.States (552), 85, (205, 4), 171);
            Add_Action (Table.States (552), 86, (213, 2), 172);
            Add_Action (Table.States (552), 88, (214, 0), 386);
            Add_Action (Table.States (552), 90, (268, 0), 34);
            Add_Action (Table.States (552), 106, (237, 1), 173);
            Add_Action (Table.States (552), 107, (237, 0), 174);
            Add_Action (Table.States (552), 115, (234, 0), 175);
            Add_Action (Table.States (552), 116, (196, 0), 146);
            Add_Action (Table.States (552), 117, (196, 1), 37);
            Add_Action (Table.States (552), 118, (195, 6), 38);
            Table.States (552).Goto_List.Set_Capacity (41);
            Add_Goto (Table.States (552), 131, 361);
            Add_Goto (Table.States (552), 140, 362);
            Add_Goto (Table.States (552), 177, 363);
            Add_Goto (Table.States (552), 178, 364);
            Add_Goto (Table.States (552), 187, 365);
            Add_Goto (Table.States (552), 195, 366);
            Add_Goto (Table.States (552), 196, 148);
            Add_Goto (Table.States (552), 197, 54);
            Add_Goto (Table.States (552), 198, 55);
            Add_Goto (Table.States (552), 199, 56);
            Add_Goto (Table.States (552), 201, 57);
            Add_Goto (Table.States (552), 203, 369);
            Add_Goto (Table.States (552), 205, 177);
            Add_Goto (Table.States (552), 206, 178);
            Add_Goto (Table.States (552), 210, 179);
            Add_Goto (Table.States (552), 211, 180);
            Add_Goto (Table.States (552), 212, 387);
            Add_Goto (Table.States (552), 213, 181);
            Add_Goto (Table.States (552), 214, 182);
            Add_Goto (Table.States (552), 215, 183);
            Add_Goto (Table.States (552), 216, 388);
            Add_Goto (Table.States (552), 217, 375);
            Add_Goto (Table.States (552), 218, 184);
            Add_Goto (Table.States (552), 219, 185);
            Add_Goto (Table.States (552), 220, 186);
            Add_Goto (Table.States (552), 221, 376);
            Add_Goto (Table.States (552), 227, 390);
            Add_Goto (Table.States (552), 228, 188);
            Add_Goto (Table.States (552), 231, 378);
            Add_Goto (Table.States (552), 232, 190);
            Add_Goto (Table.States (552), 233, 191);
            Add_Goto (Table.States (552), 234, 192);
            Add_Goto (Table.States (552), 237, 193);
            Add_Goto (Table.States (552), 251, 58);
            Add_Goto (Table.States (552), 252, 59);
            Add_Goto (Table.States (552), 255, 60);
            Add_Goto (Table.States (552), 256, 194);
            Add_Goto (Table.States (552), 268, 68);
            Add_Goto (Table.States (552), 311, 83);
            Add_Goto (Table.States (552), 402, 195);
            Add_Goto (Table.States (552), 465, 196);
            Table.States (552).Kernel := To_Vector ((((213, 2),  86,  6, (32767, 0),  0), ((213, 3),  86,  2, (32767,
            0),  0), ((214, 0),  86,  1, (32767, 0),  0), ((215, 1),  86,  4, (32767, 0),  0), ((220, 1),  86,  7,
            (32767, 0),  0)));
            Table.States (552).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (214, 0),  88, 386)));
            Table.States (553).Action_List.Set_Capacity (47);
            Add_Action (Table.States (553), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (202, 0),  1);
            Table.States (553).Kernel := To_Vector ((0 => ((202, 0),  116,  0, (202, 0),  1)));
            Table.States (553).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (202, 0),  1)));
            Table.States (554).Action_List.Set_Capacity (47);
            Add_Action (Table.States (554), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (201, 0),  3);
            Table.States (554).Kernel := To_Vector ((0 => ((201, 0),  202,  0, (201, 0),  3)));
            Table.States (554).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (201, 0),  3)));
            Table.States (555).Action_List.Set_Capacity (47);
            Add_Action (Table.States (555), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (255, 0),  3);
            Table.States (555).Kernel := To_Vector ((0 => ((255, 0),  205,  0, (255, 0),  3)));
            Table.States (555).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (255, 0),  3)));
            Table.States (556).Action_List.Set_Capacity (50);
            Add_Action (Table.States (556), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (267, 0),  3);
            Table.States (556).Kernel := To_Vector ((0 => ((267, 0),  108,  0, (267, 0),  3)));
            Table.States (556).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (267, 0),  3)));
            Table.States (557).Action_List.Set_Capacity (1);
            Add_Action (Table.States (557), 85, (253, 0), 911);
            Table.States (557).Kernel := To_Vector ((0 => ((253, 0),  116,  5, (32767, 0),  0)));
            Table.States (557).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (253, 0),  85, 911)));
            Table.States (558).Action_List.Set_Capacity (47);
            Add_Action (Table.States (558), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (251, 0),  3);
            Table.States (558).Kernel := To_Vector ((0 => ((251, 0),  253,  0, (251, 0),  3)));
            Table.States (558).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (251, 0),  3)));
            Table.States (559).Action_List.Set_Capacity (1);
            Add_Action (Table.States (559), 66, (275, 1), 912);
            Table.States (559).Kernel := To_Vector ((0 => ((275, 1),  259,  3, (32767, 0),  0)));
            Table.States (559).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (275, 1),  66, 912)));
            Table.States (560).Action_List.Set_Capacity (1);
            Add_Action (Table.States (560), 66, (286, 1), 913);
            Table.States (560).Kernel := To_Vector ((0 => ((286, 1),  396,  2, (32767, 0),  0)));
            Table.States (560).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (286, 1),  66, 913)));
            Table.States (561).Action_List.Set_Capacity (16);
            Add_Action (Table.States (561), (22, 25, 28, 38, 50, 51, 52, 53, 54, 59, 60, 66, 81, 83, 84, 116), (191,
            1),  1);
            Table.States (561).Kernel := To_Vector ((0 => ((191, 1),  124,  0, (191, 1),  1)));
            Table.States (561).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (191, 1),  1)));
            Table.States (562).Action_List.Set_Capacity (16);
            Add_Action (Table.States (562), (22, 25, 28, 38, 50, 51, 52, 53, 54, 59, 60, 66, 81, 83, 84, 116), (191,
            0),  1);
            Table.States (562).Kernel := To_Vector ((0 => ((191, 0),  190,  0, (191, 0),  1)));
            Table.States (562).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (191, 0),  1)));
            Table.States (563).Action_List.Set_Capacity (16);
            Add_Action (Table.States (563), (22, 25, 28, 38, 50, 51, 52, 53, 54, 59, 60, 66, 81, 83, 84, 116), (458,
            0),  1);
            Table.States (563).Kernel := To_Vector ((0 => ((458, 0),  191,  0, (458, 0),  1)));
            Table.States (563).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (458, 0),  1)));
            Table.States (564).Action_List.Set_Capacity (1);
            Add_Action (Table.States (564), 38, (286, 0), 914);
            Table.States (564).Kernel := To_Vector ((0 => ((286, 0),  192,  5, (32767, 0),  0)));
            Table.States (564).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (286, 0),  38, 914)));
            Table.States (565).Action_List.Set_Capacity (16);
            Add_Action (Table.States (565), 22, (339, 0), 9);
            Add_Action (Table.States (565), 25, (329, 1), 10);
            Add_Action (Table.States (565), 28, (325, 0), 12);
            Add_Action (Table.States (565), 38, Reduce, (192, 0),  1);
            Add_Action (Table.States (565), 50, (332, 0), 19);
            Add_Action (Table.States (565), 51, (437, 0), 221);
            Add_Action (Table.States (565), 52, (329, 0), 21);
            Add_Action (Table.States (565), 53, (294, 0), 22);
            Add_Action (Table.States (565), 54, (293, 0), 23);
            Add_Action (Table.States (565), 59, (346, 0), 24);
            Add_Action (Table.States (565), 60, (340, 0), 25);
            Add_Action (Table.States (565), 66, Reduce, (192, 0),  1);
            Add_Action (Table.States (565), 81, (130, 0), 30);
            Add_Action (Table.States (565), 83, (128, 0), 31);
            Add_Action (Table.States (565), 84, (124, 0), 32);
            Add_Action (Table.States (565), 116, (136, 0), 223);
            Table.States (565).Goto_List.Set_Capacity (59);
            Add_Goto (Table.States (565), 124, 561);
            Add_Goto (Table.States (565), 126, 40);
            Add_Goto (Table.States (565), 127, 41);
            Add_Goto (Table.States (565), 128, 42);
            Add_Goto (Table.States (565), 130, 43);
            Add_Goto (Table.States (565), 135, 44);
            Add_Goto (Table.States (565), 136, 45);
            Add_Goto (Table.States (565), 137, 46);
            Add_Goto (Table.States (565), 180, 47);
            Add_Goto (Table.States (565), 189, 48);
            Add_Goto (Table.States (565), 190, 562);
            Add_Goto (Table.States (565), 191, 915);
            Add_Goto (Table.States (565), 193, 50);
            Add_Goto (Table.States (565), 194, 51);
            Add_Goto (Table.States (565), 291, 77);
            Add_Goto (Table.States (565), 292, 78);
            Add_Goto (Table.States (565), 293, 79);
            Add_Goto (Table.States (565), 294, 80);
            Add_Goto (Table.States (565), 309, 81);
            Add_Goto (Table.States (565), 320, 86);
            Add_Goto (Table.States (565), 321, 87);
            Add_Goto (Table.States (565), 322, 88);
            Add_Goto (Table.States (565), 325, 89);
            Add_Goto (Table.States (565), 326, 90);
            Add_Goto (Table.States (565), 327, 91);
            Add_Goto (Table.States (565), 328, 92);
            Add_Goto (Table.States (565), 329, 225);
            Add_Goto (Table.States (565), 330, 94);
            Add_Goto (Table.States (565), 332, 95);
            Add_Goto (Table.States (565), 333, 96);
            Add_Goto (Table.States (565), 334, 97);
            Add_Goto (Table.States (565), 335, 98);
            Add_Goto (Table.States (565), 336, 99);
            Add_Goto (Table.States (565), 337, 100);
            Add_Goto (Table.States (565), 338, 101);
            Add_Goto (Table.States (565), 339, 102);
            Add_Goto (Table.States (565), 340, 103);
            Add_Goto (Table.States (565), 341, 104);
            Add_Goto (Table.States (565), 345, 105);
            Add_Goto (Table.States (565), 346, 106);
            Add_Goto (Table.States (565), 347, 107);
            Add_Goto (Table.States (565), 354, 108);
            Add_Goto (Table.States (565), 388, 126);
            Add_Goto (Table.States (565), 389, 127);
            Add_Goto (Table.States (565), 390, 128);
            Add_Goto (Table.States (565), 391, 129);
            Add_Goto (Table.States (565), 392, 130);
            Add_Goto (Table.States (565), 394, 132);
            Add_Goto (Table.States (565), 403, 134);
            Add_Goto (Table.States (565), 404, 135);
            Add_Goto (Table.States (565), 405, 136);
            Add_Goto (Table.States (565), 406, 137);
            Add_Goto (Table.States (565), 408, 138);
            Add_Goto (Table.States (565), 431, 139);
            Add_Goto (Table.States (565), 437, 140);
            Add_Goto (Table.States (565), 438, 141);
            Add_Goto (Table.States (565), 440, 142);
            Add_Goto (Table.States (565), 454, 143);
            Add_Goto (Table.States (565), 458, 916);
            Table.States (565).Kernel := To_Vector ((((192, 0),  458,  0, (192, 0),  1), ((458, 1),  458,  3, (32767,
            0),  0), ((458, 2),  458,  3, (32767, 0),  0)));
            Table.States (565).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (192, 0),  1)));
            Table.States (566).Action_List.Set_Capacity (25);
            Add_Action (Table.States (566), 12, (401, 0), 1);
            Add_Action (Table.States (566), 15, (370, 0), 3);
            Add_Action (Table.States (566), 17, (365, 0), 4);
            Add_Action (Table.States (566), 18, (382, 0), 5);
            Add_Action (Table.States (566), 19, (363, 0), 6);
            Add_Action (Table.States (566), 20, (357, 0), 7);
            Add_Action (Table.States (566), 30, (316, 0), 13);
            Add_Action (Table.States (566), 31, (290, 0), 14);
            Add_Action (Table.States (566), 32, (289, 0), 15);
            Add_Action (Table.States (566), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (566), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (566), 37, (288, 0), 17);
            Add_Conflict (Table.States (566), 37, (285, 1),  0);
            Add_Action (Table.States (566), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (566), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (566), 41, (271, 0), 18);
            Add_Action (Table.States (566), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (566), 64, (273, 0), 27);
            Add_Action (Table.States (566), 65, (264, 0), 28);
            Add_Action (Table.States (566), 84, (124, 0), 32);
            Add_Action (Table.States (566), 86, (252, 0), 33);
            Add_Action (Table.States (566), 90, (268, 0), 34);
            Add_Action (Table.States (566), 105, (265, 0), 35);
            Add_Action (Table.States (566), 116, (196, 0), 146);
            Add_Action (Table.States (566), 117, (196, 1), 37);
            Add_Action (Table.States (566), 118, (195, 6), 38);
            Table.States (566).Goto_List.Set_Capacity (45);
            Add_Goto (Table.States (566), 124, 39);
            Add_Goto (Table.States (566), 195, 52);
            Add_Goto (Table.States (566), 196, 53);
            Add_Goto (Table.States (566), 197, 54);
            Add_Goto (Table.States (566), 198, 55);
            Add_Goto (Table.States (566), 199, 56);
            Add_Goto (Table.States (566), 201, 57);
            Add_Goto (Table.States (566), 251, 58);
            Add_Goto (Table.States (566), 252, 59);
            Add_Goto (Table.States (566), 255, 60);
            Add_Goto (Table.States (566), 259, 917);
            Add_Goto (Table.States (566), 261, 331);
            Add_Goto (Table.States (566), 262, 62);
            Add_Goto (Table.States (566), 263, 63);
            Add_Goto (Table.States (566), 264, 64);
            Add_Goto (Table.States (566), 265, 65);
            Add_Goto (Table.States (566), 266, 66);
            Add_Goto (Table.States (566), 267, 67);
            Add_Goto (Table.States (566), 268, 68);
            Add_Goto (Table.States (566), 271, 69);
            Add_Goto (Table.States (566), 273, 70);
            Add_Goto (Table.States (566), 275, 71);
            Add_Goto (Table.States (566), 285, 72);
            Add_Goto (Table.States (566), 286, 73);
            Add_Goto (Table.States (566), 288, 74);
            Add_Goto (Table.States (566), 289, 75);
            Add_Goto (Table.States (566), 290, 76);
            Add_Goto (Table.States (566), 310, 82);
            Add_Goto (Table.States (566), 311, 83);
            Add_Goto (Table.States (566), 316, 84);
            Add_Goto (Table.States (566), 318, 85);
            Add_Goto (Table.States (566), 357, 110);
            Add_Goto (Table.States (566), 363, 111);
            Add_Goto (Table.States (566), 364, 112);
            Add_Goto (Table.States (566), 365, 113);
            Add_Goto (Table.States (566), 366, 114);
            Add_Goto (Table.States (566), 367, 115);
            Add_Goto (Table.States (566), 370, 116);
            Add_Goto (Table.States (566), 376, 117);
            Add_Goto (Table.States (566), 378, 118);
            Add_Goto (Table.States (566), 379, 119);
            Add_Goto (Table.States (566), 382, 120);
            Add_Goto (Table.States (566), 401, 133);
            Add_Goto (Table.States (566), 461, 332);
            Add_Goto (Table.States (566), 462, 144);
            Table.States (566).Kernel := To_Vector ((0 => ((275, 0),  36,  5, (32767, 0),  0)));
            Table.States (566).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (264, 0),  65, 28)));
         end Subr_22;
         procedure Subr_23
         is begin
            Table.States (567).Action_List.Set_Capacity (6);
            Add_Action (Table.States (567), 61, (434, 0), 299);
            Add_Action (Table.States (567), 85, (198, 0), 281);
            Add_Action (Table.States (567), 96, (197, 0), 283);
            Add_Action (Table.States (567), 108, (338, 3), 918);
            Add_Action (Table.States (567), 113, (121, 0), 285);
            Add_Action (Table.States (567), 114, (121, 1), 286);
            Table.States (567).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (567), 121, 287);
            Add_Goto (Table.States (567), 313, 289);
            Add_Goto (Table.States (567), 434, 919);
            Table.States (567).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((338, 2),  195,  3, (32767, 0),  0), ((338, 3),
            195,  1, (32767, 0),  0)));
            Table.States (567).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (338, 3),  108, 918)));
            Table.States (568).Action_List.Set_Capacity (7);
            Add_Action (Table.States (568), 63, Reduce, (435, 1),  1);
            Add_Action (Table.States (568), 82, Reduce, (435, 1),  1);
            Add_Action (Table.States (568), 95, Reduce, (435, 1),  1);
            Add_Action (Table.States (568), 99, Reduce, (435, 1),  1);
            Add_Action (Table.States (568), 108, Reduce, (435, 1),  1);
            Add_Action (Table.States (568), 113, (121, 0), 285);
            Add_Action (Table.States (568), 114, (121, 1), 286);
            Table.States (568).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (568), 121, 920);
            Table.States (568).Kernel := To_Vector ((((435, 0),  116,  2, (32767, 0),  0), ((435, 1),  116,  0, (435,
            1),  1)));
            Table.States (568).Minimal_Complete_Actions := To_Vector (((Shift, (121, 0),  113, 285), (Reduce, (435, 1),
             1)));
            Table.States (569).Action_List.Set_Capacity (4);
            Add_Action (Table.States (569), (63, 82, 95, 108), (433, 0),  1);
            Table.States (569).Kernel := To_Vector ((0 => ((433, 0),  432,  0, (433, 0),  1)));
            Table.States (569).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (433, 0),  1)));
            Table.States (570).Action_List.Set_Capacity (4);
            Add_Action (Table.States (570), 63, Reduce, (434, 0),  2);
            Add_Action (Table.States (570), 82, Reduce, (434, 0),  2);
            Add_Action (Table.States (570), 95, (433, 1), 921);
            Add_Action (Table.States (570), 108, Reduce, (434, 0),  2);
            Table.States (570).Kernel := To_Vector ((((433, 1),  433,  2, (32767, 0),  0), ((434, 0),  433,  0, (434,
            0),  2)));
            Table.States (570).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (434, 0),  2)));
            Table.States (571).Action_List.Set_Capacity (5);
            Add_Action (Table.States (571), 63, Reduce, (432, 1),  1);
            Add_Action (Table.States (571), 82, Reduce, (432, 1),  1);
            Add_Action (Table.States (571), 95, Reduce, (432, 1),  1);
            Add_Action (Table.States (571), 99, (432, 0), 922);
            Add_Action (Table.States (571), 108, Reduce, (432, 1),  1);
            Table.States (571).Kernel := To_Vector ((((432, 0),  435,  2, (32767, 0),  0), ((432, 1),  435,  0, (432,
            1),  1)));
            Table.States (571).Minimal_Complete_Actions := To_Vector (((Shift, (432, 0),  99, 922), (Reduce, (432, 1),
            1)));
            Table.States (572).Action_List.Set_Capacity (2);
            Add_Action (Table.States (572), 61, (434, 0), 299);
            Add_Action (Table.States (572), 108, (389, 3), 923);
            Table.States (572).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (572), 434, 924);
            Table.States (572).Kernel := To_Vector ((((389, 2),  13,  3, (32767, 0),  0), ((389, 3),  13,  1, (32767,
            0),  0)));
            Table.States (572).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (389, 3),  108, 923)));
            Table.States (573).Action_List.Set_Capacity (2);
            Add_Action (Table.States (573), 61, (434, 0), 299);
            Add_Action (Table.States (573), 108, (180, 3), 925);
            Table.States (573).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (573), 434, 926);
            Table.States (573).Kernel := To_Vector ((((180, 2),  78,  3, (32767, 0),  0), ((180, 3),  78,  1, (32767,
            0),  0)));
            Table.States (573).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (180, 3),  108, 925)));
            Table.States (574).Action_List.Set_Capacity (1);
            Add_Action (Table.States (574), 38, (309, 3), 927);
            Table.States (574).Kernel := To_Vector ((0 => ((309, 3),  192,  5, (32767, 0),  0)));
            Table.States (574).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (309, 3),  38, 927)));
            Table.States (575).Action_List.Set_Capacity (15);
            Add_Action (Table.States (575), 22, (339, 0), 9);
            Add_Action (Table.States (575), 25, (329, 1), 10);
            Add_Action (Table.States (575), 28, (325, 0), 12);
            Add_Action (Table.States (575), 38, Reduce, (192, 1),  0);
            Add_Action (Table.States (575), 50, (332, 0), 19);
            Add_Action (Table.States (575), 51, (437, 0), 221);
            Add_Action (Table.States (575), 52, (329, 0), 21);
            Add_Action (Table.States (575), 53, (294, 0), 22);
            Add_Action (Table.States (575), 54, (293, 0), 23);
            Add_Action (Table.States (575), 59, (346, 0), 24);
            Add_Action (Table.States (575), 60, (340, 0), 25);
            Add_Action (Table.States (575), 81, (130, 0), 30);
            Add_Action (Table.States (575), 83, (128, 0), 31);
            Add_Action (Table.States (575), 84, (124, 0), 32);
            Add_Action (Table.States (575), 116, (136, 0), 223);
            Table.States (575).Goto_List.Set_Capacity (60);
            Add_Goto (Table.States (575), 124, 561);
            Add_Goto (Table.States (575), 126, 40);
            Add_Goto (Table.States (575), 127, 41);
            Add_Goto (Table.States (575), 128, 42);
            Add_Goto (Table.States (575), 130, 43);
            Add_Goto (Table.States (575), 135, 44);
            Add_Goto (Table.States (575), 136, 45);
            Add_Goto (Table.States (575), 137, 46);
            Add_Goto (Table.States (575), 180, 47);
            Add_Goto (Table.States (575), 189, 48);
            Add_Goto (Table.States (575), 190, 562);
            Add_Goto (Table.States (575), 191, 563);
            Add_Goto (Table.States (575), 192, 928);
            Add_Goto (Table.States (575), 193, 50);
            Add_Goto (Table.States (575), 194, 51);
            Add_Goto (Table.States (575), 291, 77);
            Add_Goto (Table.States (575), 292, 78);
            Add_Goto (Table.States (575), 293, 79);
            Add_Goto (Table.States (575), 294, 80);
            Add_Goto (Table.States (575), 309, 81);
            Add_Goto (Table.States (575), 320, 86);
            Add_Goto (Table.States (575), 321, 87);
            Add_Goto (Table.States (575), 322, 88);
            Add_Goto (Table.States (575), 325, 89);
            Add_Goto (Table.States (575), 326, 90);
            Add_Goto (Table.States (575), 327, 91);
            Add_Goto (Table.States (575), 328, 92);
            Add_Goto (Table.States (575), 329, 225);
            Add_Goto (Table.States (575), 330, 94);
            Add_Goto (Table.States (575), 332, 95);
            Add_Goto (Table.States (575), 333, 96);
            Add_Goto (Table.States (575), 334, 97);
            Add_Goto (Table.States (575), 335, 98);
            Add_Goto (Table.States (575), 336, 99);
            Add_Goto (Table.States (575), 337, 100);
            Add_Goto (Table.States (575), 338, 101);
            Add_Goto (Table.States (575), 339, 102);
            Add_Goto (Table.States (575), 340, 103);
            Add_Goto (Table.States (575), 341, 104);
            Add_Goto (Table.States (575), 345, 105);
            Add_Goto (Table.States (575), 346, 106);
            Add_Goto (Table.States (575), 347, 107);
            Add_Goto (Table.States (575), 354, 108);
            Add_Goto (Table.States (575), 388, 126);
            Add_Goto (Table.States (575), 389, 127);
            Add_Goto (Table.States (575), 390, 128);
            Add_Goto (Table.States (575), 391, 129);
            Add_Goto (Table.States (575), 392, 130);
            Add_Goto (Table.States (575), 394, 132);
            Add_Goto (Table.States (575), 403, 134);
            Add_Goto (Table.States (575), 404, 135);
            Add_Goto (Table.States (575), 405, 136);
            Add_Goto (Table.States (575), 406, 137);
            Add_Goto (Table.States (575), 408, 138);
            Add_Goto (Table.States (575), 431, 139);
            Add_Goto (Table.States (575), 437, 140);
            Add_Goto (Table.States (575), 438, 141);
            Add_Goto (Table.States (575), 440, 142);
            Add_Goto (Table.States (575), 454, 143);
            Add_Goto (Table.States (575), 458, 565);
            Table.States (575).Kernel := To_Vector ((0 => ((309, 2),  82,  5, (32767, 0),  0)));
            Table.States (575).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (192, 1),  0)));
            Table.States (576).Action_List.Set_Capacity (43);
            Add_Action (Table.States (576), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (291, 2),  3);
            Table.States (576).Kernel := To_Vector ((0 => ((291, 2),  108,  0, (291, 2),  3)));
            Table.States (576).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (291, 2),  3)));
            Table.States (577).Action_List.Set_Capacity (2);
            Add_Action (Table.States (577), 61, (434, 0), 299);
            Add_Action (Table.States (577), 108, (320, 3), 929);
            Table.States (577).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (577), 434, 930);
            Table.States (577).Kernel := To_Vector ((((320, 2),  65,  3, (32767, 0),  0), ((320, 3),  65,  1, (32767,
            0),  0)));
            Table.States (577).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (320, 3),  108, 929)));
            Table.States (578).Action_List.Set_Capacity (2);
            Add_Action (Table.States (578), 61, (434, 0), 299);
            Add_Action (Table.States (578), 108, (321, 3), 931);
            Table.States (578).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (578), 434, 932);
            Table.States (578).Kernel := To_Vector ((((321, 2),  205,  3, (32767, 0),  0), ((321, 3),  205,  1, (32767,
            0),  0)));
            Table.States (578).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (321, 3),  108, 931)));
            Table.States (579).Action_List.Set_Capacity (3);
            Add_Action (Table.States (579), 61, Reduce, (295, 1),  0);
            Add_Action (Table.States (579), 85, (299, 0), 933);
            Add_Action (Table.States (579), 108, Reduce, (295, 1),  0);
            Table.States (579).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (579), 295, 934);
            Add_Goto (Table.States (579), 299, 426);
            Table.States (579).Kernel := To_Vector ((((356, 0),  116,  6, (32767, 0),  0), ((356, 1),  116,  4, (32767,
            0),  0), ((356, 2),  116,  3, (32767, 0),  0), ((356, 3),  116,  1, (32767, 0),  0)));
            Table.States (579).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (295, 1),  0)));
            Table.States (580).Action_List.Set_Capacity (6);
            Add_Action (Table.States (580), 30, (296, 0), 476);
            Add_Action (Table.States (580), 82, (408, 6), 935);
            Add_Action (Table.States (580), 85, (198, 0), 478);
            Add_Action (Table.States (580), 96, (197, 0), 283);
            Add_Action (Table.States (580), 113, (121, 0), 285);
            Add_Action (Table.States (580), 114, (121, 1), 286);
            Table.States (580).Goto_List.Set_Capacity (5);
            Add_Goto (Table.States (580), 121, 287);
            Add_Goto (Table.States (580), 296, 479);
            Add_Goto (Table.States (580), 297, 480);
            Add_Goto (Table.States (580), 299, 481);
            Add_Goto (Table.States (580), 313, 289);
            Table.States (580).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((294, 0),  195,  2, (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((408, 6),
            195,  6, (32767, 0),  0), ((408, 7),  195,  4, (32767, 0),  0)));
            Table.States (580).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (296, 0),  30, 476)));
            Table.States (581).Action_List.Set_Capacity (8);
            Add_Action (Table.States (581), 24, Reduce, (295, 1),  0);
            Add_Action (Table.States (581), 61, Reduce, (295, 1),  0);
            Add_Action (Table.States (581), 82, (408, 2), 936);
            Add_Conflict (Table.States (581), 82, (295, 1),  0);
            Add_Action (Table.States (581), 85, (198, 0), 478);
            Add_Action (Table.States (581), 96, (197, 0), 283);
            Add_Action (Table.States (581), 108, Reduce, (295, 1),  0);
            Add_Action (Table.States (581), 113, (121, 0), 285);
            Add_Action (Table.States (581), 114, (121, 1), 286);
            Table.States (581).Goto_List.Set_Capacity (4);
            Add_Goto (Table.States (581), 121, 287);
            Add_Goto (Table.States (581), 295, 483);
            Add_Goto (Table.States (581), 299, 426);
            Add_Goto (Table.States (581), 313, 289);
            Table.States (581).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((293, 0),  195,  0, (295, 1),  0), ((311, 0),  195,  3, (32767, 0),  0), ((408, 2),  195,
             6, (32767, 0),  0), ((408, 3),  195,  4, (32767, 0),  0)));
            Table.States (581).Minimal_Complete_Actions := To_Vector (((Reduce, (295, 1),  0), (Shift, (408, 2),  82,
            936)));
            Table.States (582).Action_List.Set_Capacity (5);
            Add_Action (Table.States (582), 86, (252, 0), 33);
            Add_Action (Table.States (582), 90, (268, 0), 34);
            Add_Action (Table.States (582), 116, (196, 0), 146);
            Add_Action (Table.States (582), 117, (196, 1), 37);
            Add_Action (Table.States (582), 118, (195, 6), 38);
            Table.States (582).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (582), 195, 937);
            Add_Goto (Table.States (582), 196, 148);
            Add_Goto (Table.States (582), 197, 54);
            Add_Goto (Table.States (582), 198, 55);
            Add_Goto (Table.States (582), 199, 56);
            Add_Goto (Table.States (582), 201, 57);
            Add_Goto (Table.States (582), 251, 58);
            Add_Goto (Table.States (582), 252, 59);
            Add_Goto (Table.States (582), 255, 60);
            Add_Goto (Table.States (582), 268, 68);
            Add_Goto (Table.States (582), 311, 83);
            Table.States (582).Kernel := To_Vector ((((338, 0),  24,  4, (32767, 0),  0), ((338, 1),  24,  2, (32767,
            0),  0)));
            Table.States (582).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (583).Action_List.Set_Capacity (17);
            Add_Action (Table.States (583), 13, (389, 0), 938);
            Add_Action (Table.States (583), 22, (339, 0), 9);
            Add_Action (Table.States (583), 25, (329, 1), 10);
            Add_Action (Table.States (583), 28, (325, 0), 12);
            Add_Action (Table.States (583), 38, Reduce, (192, 1),  0);
            Add_Action (Table.States (583), 50, (332, 0), 19);
            Add_Action (Table.States (583), 51, (437, 0), 221);
            Add_Action (Table.States (583), 52, (329, 0), 21);
            Add_Action (Table.States (583), 53, (294, 0), 22);
            Add_Action (Table.States (583), 54, (293, 0), 23);
            Add_Action (Table.States (583), 59, (346, 0), 24);
            Add_Action (Table.States (583), 60, (340, 0), 25);
            Add_Action (Table.States (583), 78, (180, 0), 939);
            Add_Action (Table.States (583), 81, (130, 0), 30);
            Add_Action (Table.States (583), 83, (128, 0), 31);
            Add_Action (Table.States (583), 84, (124, 0), 32);
            Add_Action (Table.States (583), 116, (136, 0), 223);
            Table.States (583).Goto_List.Set_Capacity (60);
            Add_Goto (Table.States (583), 124, 561);
            Add_Goto (Table.States (583), 126, 40);
            Add_Goto (Table.States (583), 127, 41);
            Add_Goto (Table.States (583), 128, 42);
            Add_Goto (Table.States (583), 130, 43);
            Add_Goto (Table.States (583), 135, 44);
            Add_Goto (Table.States (583), 136, 45);
            Add_Goto (Table.States (583), 137, 46);
            Add_Goto (Table.States (583), 180, 47);
            Add_Goto (Table.States (583), 189, 48);
            Add_Goto (Table.States (583), 190, 562);
            Add_Goto (Table.States (583), 191, 563);
            Add_Goto (Table.States (583), 192, 940);
            Add_Goto (Table.States (583), 193, 50);
            Add_Goto (Table.States (583), 194, 51);
            Add_Goto (Table.States (583), 291, 77);
            Add_Goto (Table.States (583), 292, 78);
            Add_Goto (Table.States (583), 293, 79);
            Add_Goto (Table.States (583), 294, 80);
            Add_Goto (Table.States (583), 309, 81);
            Add_Goto (Table.States (583), 320, 86);
            Add_Goto (Table.States (583), 321, 87);
            Add_Goto (Table.States (583), 322, 88);
            Add_Goto (Table.States (583), 325, 89);
            Add_Goto (Table.States (583), 326, 90);
            Add_Goto (Table.States (583), 327, 91);
            Add_Goto (Table.States (583), 328, 92);
            Add_Goto (Table.States (583), 329, 225);
            Add_Goto (Table.States (583), 330, 94);
            Add_Goto (Table.States (583), 332, 95);
            Add_Goto (Table.States (583), 333, 96);
            Add_Goto (Table.States (583), 334, 97);
            Add_Goto (Table.States (583), 335, 98);
            Add_Goto (Table.States (583), 336, 99);
            Add_Goto (Table.States (583), 337, 100);
            Add_Goto (Table.States (583), 338, 101);
            Add_Goto (Table.States (583), 339, 102);
            Add_Goto (Table.States (583), 340, 103);
            Add_Goto (Table.States (583), 341, 104);
            Add_Goto (Table.States (583), 345, 105);
            Add_Goto (Table.States (583), 346, 106);
            Add_Goto (Table.States (583), 347, 107);
            Add_Goto (Table.States (583), 354, 108);
            Add_Goto (Table.States (583), 388, 126);
            Add_Goto (Table.States (583), 389, 127);
            Add_Goto (Table.States (583), 390, 128);
            Add_Goto (Table.States (583), 391, 129);
            Add_Goto (Table.States (583), 392, 130);
            Add_Goto (Table.States (583), 394, 132);
            Add_Goto (Table.States (583), 403, 134);
            Add_Goto (Table.States (583), 404, 135);
            Add_Goto (Table.States (583), 405, 136);
            Add_Goto (Table.States (583), 406, 137);
            Add_Goto (Table.States (583), 408, 138);
            Add_Goto (Table.States (583), 431, 139);
            Add_Goto (Table.States (583), 437, 140);
            Add_Goto (Table.States (583), 438, 141);
            Add_Goto (Table.States (583), 440, 142);
            Add_Goto (Table.States (583), 454, 143);
            Add_Goto (Table.States (583), 458, 565);
            Table.States (583).Kernel := To_Vector ((((180, 0),  82,  4, (32767, 0),  0), ((180, 1),  82,  2, (32767,
            0),  0), ((309, 1),  82,  5, (32767, 0),  0), ((389, 0),  82,  4, (32767, 0),  0), ((389, 1),  82,  2,
            (32767, 0),  0)));
            Table.States (583).Minimal_Complete_Actions := To_Vector (((Shift, (180, 0),  78, 939), (Shift, (389, 0),
            13, 938)));
            Table.States (584).Action_List.Set_Capacity (43);
            Add_Action (Table.States (584), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (291, 1),  3);
            Table.States (584).Kernel := To_Vector ((0 => ((291, 1),  108,  0, (291, 1),  3)));
            Table.States (584).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (291, 1),  3)));
            Table.States (585).Action_List.Set_Capacity (2);
            Add_Action (Table.States (585), 82, (309, 0), 941);
            Add_Action (Table.States (585), 108, (291, 0), 942);
            Table.States (585).Kernel := To_Vector ((((291, 0),  434,  1, (32767, 0),  0), ((309, 0),  434,  6, (32767,
            0),  0)));
            Table.States (585).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (291, 0),  108, 942)));
            Table.States (586).Action_List.Set_Capacity (1);
            Add_Action (Table.States (586), 65, (320, 0), 943);
            Table.States (586).Kernel := To_Vector ((((320, 0),  82,  4, (32767, 0),  0), ((320, 1),  82,  2, (32767,
            0),  0)));
            Table.States (586).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (320, 0),  65, 943)));
            Table.States (587).Action_List.Set_Capacity (2);
            Add_Action (Table.States (587), 85, (205, 4), 171);
            Add_Action (Table.States (587), 86, (213, 2), 552);
            Table.States (587).Goto_List.Set_Capacity (10);
            Add_Goto (Table.States (587), 205, 944);
            Add_Goto (Table.States (587), 206, 178);
            Add_Goto (Table.States (587), 210, 179);
            Add_Goto (Table.States (587), 211, 180);
            Add_Goto (Table.States (587), 213, 181);
            Add_Goto (Table.States (587), 214, 182);
            Add_Goto (Table.States (587), 215, 183);
            Add_Goto (Table.States (587), 218, 184);
            Add_Goto (Table.States (587), 219, 185);
            Add_Goto (Table.States (587), 220, 186);
            Table.States (587).Kernel := To_Vector ((((321, 0),  82,  5, (32767, 0),  0), ((321, 1),  82,  3, (32767,
            0),  0)));
            Table.States (587).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (213, 2),  86, 552)));
            Table.States (588).Action_List.Set_Capacity (6);
            Add_Action (Table.States (588), 61, (434, 0), 299);
            Add_Action (Table.States (588), 82, (325, 6), 945);
            Add_Action (Table.States (588), 85, (198, 0), 281);
            Add_Action (Table.States (588), 96, (197, 0), 283);
            Add_Action (Table.States (588), 113, (121, 0), 285);
            Add_Action (Table.States (588), 114, (121, 1), 286);
            Table.States (588).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (588), 121, 287);
            Add_Goto (Table.States (588), 313, 289);
            Add_Goto (Table.States (588), 434, 443);
            Table.States (588).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((325, 0),  195,  11, (32767, 0),  0), ((325, 1),
            195,  8, (32767, 0),  0), ((325, 2),  195,  7, (32767, 0),  0), ((325, 3),  195,  8, (32767, 0),  0),
            ((325, 4),  195,  5, (32767, 0),  0), ((325, 5),  195,  4, (32767, 0),  0), ((325, 6),  195,  9, (32767,
            0),  0), ((325, 7),  195,  6, (32767, 0),  0), ((325, 8),  195,  5, (32767, 0),  0), ((325, 9),  195,  6,
            (32767, 0),  0), ((325, 10),  195,  3, (32767, 0),  0), ((325, 11),  195,  2, (32767, 0),  0)));
            Table.States (588).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (325, 6),  82, 945)));
            Table.States (589).Action_List.Set_Capacity (5);
            Add_Action (Table.States (589), 30, (296, 0), 476);
            Add_Action (Table.States (589), 85, (198, 0), 478);
            Add_Action (Table.States (589), 96, (197, 0), 283);
            Add_Action (Table.States (589), 113, (121, 0), 285);
            Add_Action (Table.States (589), 114, (121, 1), 286);
            Table.States (589).Goto_List.Set_Capacity (5);
            Add_Goto (Table.States (589), 121, 287);
            Add_Goto (Table.States (589), 296, 479);
            Add_Goto (Table.States (589), 297, 480);
            Add_Goto (Table.States (589), 299, 481);
            Add_Goto (Table.States (589), 313, 289);
            Table.States (589).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((294, 0),  195,  2, (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0)));
            Table.States (589).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (296, 0),  30, 476)));
         end Subr_23;
         procedure Subr_24
         is begin
            Table.States (590).Action_List.Set_Capacity (7);
            Add_Action (Table.States (590), 61, Reduce, (295, 1),  0);
            Add_Action (Table.States (590), 82, Reduce, (295, 1),  0);
            Add_Action (Table.States (590), 85, (198, 0), 478);
            Add_Action (Table.States (590), 96, (197, 0), 283);
            Add_Action (Table.States (590), 108, Reduce, (295, 1),  0);
            Add_Action (Table.States (590), 113, (121, 0), 285);
            Add_Action (Table.States (590), 114, (121, 1), 286);
            Table.States (590).Goto_List.Set_Capacity (4);
            Add_Goto (Table.States (590), 121, 287);
            Add_Goto (Table.States (590), 295, 483);
            Add_Goto (Table.States (590), 299, 426);
            Add_Goto (Table.States (590), 313, 289);
            Table.States (590).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((293, 0),  195,  0, (295, 1),  0), ((311, 0),  195,  3, (32767, 0),  0)));
            Table.States (590).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (295, 1),  0)));
            Table.States (591).Action_List.Set_Capacity (43);
            Add_Action (Table.States (591), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (404, 1),  3);
            Table.States (591).Kernel := To_Vector ((0 => ((404, 1),  108,  0, (404, 1),  3)));
            Table.States (591).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (404, 1),  3)));
            Table.States (592).Action_List.Set_Capacity (1);
            Add_Action (Table.States (592), 108, (404, 0), 946);
            Table.States (592).Kernel := To_Vector ((0 => ((404, 0),  434,  1, (32767, 0),  0)));
            Table.States (592).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (404, 0),  108, 946)));
            Table.States (593).Action_List.Set_Capacity (43);
            Add_Action (Table.States (593), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (405, 0),  3);
            Table.States (593).Kernel := To_Vector ((0 => ((405, 0),  108,  0, (405, 0),  3)));
            Table.States (593).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (405, 0),  3)));
            Table.States (594).Action_List.Set_Capacity (1);
            Add_Action (Table.States (594), 108, (401, 1), 947);
            Table.States (594).Kernel := To_Vector ((0 => ((401, 1),  227,  1, (32767, 0),  0)));
            Table.States (594).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (401, 1),  108, 947)));
            Table.States (595).Action_List.Set_Capacity (7);
            Add_Action (Table.States (595), 25, (329, 1), 10);
            Add_Action (Table.States (595), 28, (326, 0), 948);
            Add_Action (Table.States (595), 52, (329, 0), 21);
            Add_Action (Table.States (595), 53, (294, 0), 314);
            Add_Action (Table.States (595), 54, (293, 0), 315);
            Add_Action (Table.States (595), 59, (354, 0), 949);
            Add_Action (Table.States (595), 60, (345, 0), 950);
            Table.States (595).Goto_List.Set_Capacity (9);
            Add_Goto (Table.States (595), 194, 951);
            Add_Goto (Table.States (595), 292, 952);
            Add_Goto (Table.States (595), 293, 317);
            Add_Goto (Table.States (595), 294, 318);
            Add_Goto (Table.States (595), 309, 81);
            Add_Goto (Table.States (595), 326, 90);
            Add_Goto (Table.States (595), 329, 953);
            Add_Goto (Table.States (595), 345, 105);
            Add_Goto (Table.States (595), 354, 108);
            Table.States (595).Kernel := To_Vector ((0 => ((393, 0),  87,  6, (32767, 0),  0)));
            Table.States (595).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (326, 0),  28, 948)));
            Table.States (596).Action_List.Set_Capacity (3);
            Add_Action (Table.States (596), (14, 17, 20), (371, 0),  3);
            Table.States (596).Kernel := To_Vector ((0 => ((371, 0),  99,  0, (371, 0),  3)));
            Table.States (596).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (371, 0),  3)));
            Table.States (597).Action_List.Set_Capacity (33);
            Add_Action (Table.States (597), (12, 15, 17, 18, 19, 20, 23, 30, 31, 32, 35, 36, 37, 38, 39, 41, 42, 47,
            48, 49, 51, 63, 64, 65, 66, 75, 84, 86, 90, 105, 116, 117, 118), (461, 1),  2);
            Table.States (597).Kernel := To_Vector ((((461, 0),  261,  0, (461, 0),  1), ((461, 1),  261,  0, (461, 1),
             2)));
            Table.States (597).Minimal_Complete_Actions := To_Vector (((Reduce, (461, 0),  1), (Reduce, (461, 1),
            2)));
            Table.States (598).Action_List.Set_Capacity (33);
            Add_Action (Table.States (598), (12, 15, 17, 18, 19, 20, 23, 30, 31, 32, 35, 36, 37, 38, 39, 41, 42, 47,
            48, 49, 51, 63, 64, 65, 66, 75, 84, 86, 90, 105, 116, 117, 118), (461, 2),  2);
            Table.States (598).Goto_List.Set_Capacity (44);
            Add_Goto (Table.States (598), 124, 39);
            Add_Goto (Table.States (598), 195, 52);
            Add_Goto (Table.States (598), 196, 53);
            Add_Goto (Table.States (598), 197, 54);
            Add_Goto (Table.States (598), 198, 55);
            Add_Goto (Table.States (598), 199, 56);
            Add_Goto (Table.States (598), 201, 57);
            Add_Goto (Table.States (598), 251, 58);
            Add_Goto (Table.States (598), 252, 59);
            Add_Goto (Table.States (598), 255, 60);
            Add_Goto (Table.States (598), 261, 597);
            Add_Goto (Table.States (598), 262, 62);
            Add_Goto (Table.States (598), 263, 63);
            Add_Goto (Table.States (598), 264, 64);
            Add_Goto (Table.States (598), 265, 65);
            Add_Goto (Table.States (598), 266, 66);
            Add_Goto (Table.States (598), 267, 67);
            Add_Goto (Table.States (598), 268, 68);
            Add_Goto (Table.States (598), 271, 69);
            Add_Goto (Table.States (598), 273, 70);
            Add_Goto (Table.States (598), 275, 71);
            Add_Goto (Table.States (598), 285, 72);
            Add_Goto (Table.States (598), 286, 73);
            Add_Goto (Table.States (598), 288, 74);
            Add_Goto (Table.States (598), 289, 75);
            Add_Goto (Table.States (598), 290, 76);
            Add_Goto (Table.States (598), 310, 82);
            Add_Goto (Table.States (598), 311, 83);
            Add_Goto (Table.States (598), 316, 84);
            Add_Goto (Table.States (598), 318, 85);
            Add_Goto (Table.States (598), 357, 110);
            Add_Goto (Table.States (598), 363, 111);
            Add_Goto (Table.States (598), 364, 112);
            Add_Goto (Table.States (598), 365, 113);
            Add_Goto (Table.States (598), 366, 114);
            Add_Goto (Table.States (598), 367, 115);
            Add_Goto (Table.States (598), 370, 116);
            Add_Goto (Table.States (598), 376, 117);
            Add_Goto (Table.States (598), 378, 118);
            Add_Goto (Table.States (598), 379, 119);
            Add_Goto (Table.States (598), 382, 120);
            Add_Goto (Table.States (598), 401, 133);
            Add_Goto (Table.States (598), 461, 598);
            Add_Goto (Table.States (598), 462, 144);
            Table.States (598).Kernel := To_Vector ((((461, 1),  461,  2, (32767, 0),  0), ((461, 2),  461,  0, (461,
            2),  2), ((461, 2),  461,  2, (32767, 0),  0)));
            Table.States (598).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (461, 2),  2)));
            Table.States (599).Action_List.Set_Capacity (33);
            Add_Action (Table.States (599), 12, (401, 0), 1);
            Add_Action (Table.States (599), 15, (370, 0), 3);
            Add_Action (Table.States (599), 17, (365, 0), 4);
            Add_Action (Table.States (599), 18, (382, 0), 5);
            Add_Action (Table.States (599), 19, (363, 0), 6);
            Add_Action (Table.States (599), 20, (357, 0), 7);
            Add_Action (Table.States (599), 23, Reduce, (259, 0),  2);
            Add_Action (Table.States (599), 30, (316, 0), 13);
            Add_Action (Table.States (599), 31, (290, 0), 14);
            Add_Action (Table.States (599), 32, (289, 0), 15);
            Add_Action (Table.States (599), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (599), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (599), 37, (288, 0), 17);
            Add_Conflict (Table.States (599), 37, (285, 1),  0);
            Add_Action (Table.States (599), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (599), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (599), 41, (271, 0), 18);
            Add_Action (Table.States (599), 42, Reduce, (259, 0),  2);
            Add_Action (Table.States (599), 47, Reduce, (259, 0),  2);
            Add_Action (Table.States (599), 48, Reduce, (259, 0),  2);
            Add_Action (Table.States (599), 49, Reduce, (259, 0),  2);
            Add_Action (Table.States (599), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (599), 63, Reduce, (259, 0),  2);
            Add_Action (Table.States (599), 64, (273, 0), 27);
            Add_Action (Table.States (599), 65, (264, 0), 28);
            Add_Action (Table.States (599), 66, Reduce, (259, 0),  2);
            Add_Action (Table.States (599), 75, Reduce, (259, 0),  2);
            Add_Action (Table.States (599), 84, (124, 0), 32);
            Add_Action (Table.States (599), 86, (252, 0), 33);
            Add_Action (Table.States (599), 90, (268, 0), 34);
            Add_Action (Table.States (599), 105, (265, 0), 35);
            Add_Action (Table.States (599), 116, (196, 0), 146);
            Add_Action (Table.States (599), 117, (196, 1), 37);
            Add_Action (Table.States (599), 118, (195, 6), 38);
            Table.States (599).Goto_List.Set_Capacity (42);
            Add_Goto (Table.States (599), 124, 39);
            Add_Goto (Table.States (599), 195, 52);
            Add_Goto (Table.States (599), 196, 53);
            Add_Goto (Table.States (599), 197, 54);
            Add_Goto (Table.States (599), 198, 55);
            Add_Goto (Table.States (599), 199, 56);
            Add_Goto (Table.States (599), 201, 57);
            Add_Goto (Table.States (599), 251, 58);
            Add_Goto (Table.States (599), 252, 59);
            Add_Goto (Table.States (599), 255, 60);
            Add_Goto (Table.States (599), 262, 320);
            Add_Goto (Table.States (599), 263, 321);
            Add_Goto (Table.States (599), 264, 64);
            Add_Goto (Table.States (599), 265, 322);
            Add_Goto (Table.States (599), 266, 66);
            Add_Goto (Table.States (599), 267, 67);
            Add_Goto (Table.States (599), 268, 68);
            Add_Goto (Table.States (599), 271, 69);
            Add_Goto (Table.States (599), 273, 70);
            Add_Goto (Table.States (599), 275, 71);
            Add_Goto (Table.States (599), 285, 72);
            Add_Goto (Table.States (599), 286, 73);
            Add_Goto (Table.States (599), 288, 74);
            Add_Goto (Table.States (599), 289, 75);
            Add_Goto (Table.States (599), 290, 76);
            Add_Goto (Table.States (599), 310, 82);
            Add_Goto (Table.States (599), 311, 83);
            Add_Goto (Table.States (599), 316, 84);
            Add_Goto (Table.States (599), 318, 85);
            Add_Goto (Table.States (599), 357, 110);
            Add_Goto (Table.States (599), 363, 111);
            Add_Goto (Table.States (599), 364, 112);
            Add_Goto (Table.States (599), 365, 113);
            Add_Goto (Table.States (599), 366, 114);
            Add_Goto (Table.States (599), 367, 115);
            Add_Goto (Table.States (599), 370, 116);
            Add_Goto (Table.States (599), 376, 117);
            Add_Goto (Table.States (599), 378, 118);
            Add_Goto (Table.States (599), 379, 119);
            Add_Goto (Table.States (599), 382, 120);
            Add_Goto (Table.States (599), 401, 133);
            Add_Goto (Table.States (599), 462, 323);
            Table.States (599).Kernel := To_Vector ((((259, 0),  462,  0, (259, 0),  2), ((261, 0),  462,  2, (32767,
            0),  0), ((261, 2),  462,  3, (32767, 0),  0), ((462, 1),  462,  3, (32767, 0),  0), ((462, 2),  462,  3,
            (32767, 0),  0)));
            Table.States (599).Minimal_Complete_Actions := To_Vector (((Reduce, (259, 0),  2), (Shift, (264, 0),  65,
            28)));
            Table.States (600).Action_List.Set_Capacity (1);
            Add_Action (Table.States (600), 66, (370, 0), 954);
            Table.States (600).Kernel := To_Vector ((0 => ((370, 0),  259,  3, (32767, 0),  0)));
            Table.States (600).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (370, 0),  66, 954)));
            Table.States (601).Action_List.Set_Capacity (3);
            Add_Action (Table.States (601), (47, 48, 66), (369, 1),  3);
            Table.States (601).Kernel := To_Vector ((0 => ((369, 1),  368,  0, (369, 1),  3)));
            Table.States (601).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (369, 1),  3)));
            Table.States (602).Action_List.Set_Capacity (1);
            Add_Action (Table.States (602), 108, (370, 1), 955);
            Table.States (602).Kernel := To_Vector ((0 => ((370, 1),  15,  1, (32767, 0),  0)));
            Table.States (602).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (370, 1),  108, 955)));
            Table.States (603).Action_List.Set_Capacity (3);
            Add_Action (Table.States (603), (47, 48, 66), (374, 0),  2);
            Table.States (603).Kernel := To_Vector ((0 => ((374, 0),  260,  0, (374, 0),  2)));
            Table.States (603).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (374, 0),  2)));
            Table.States (604).Action_List.Set_Capacity (1);
            Add_Action (Table.States (604), 66, (378, 0), 956);
            Table.States (604).Kernel := To_Vector ((0 => ((378, 0),  259,  3, (32767, 0),  0)));
            Table.States (604).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (378, 0),  66, 956)));
            Table.States (605).Action_List.Set_Capacity (1);
            Add_Action (Table.States (605), 66, (376, 0), 957);
            Table.States (605).Kernel := To_Vector ((0 => ((376, 0),  374,  3, (32767, 0),  0)));
            Table.States (605).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (376, 0),  66, 957)));
            Table.States (606).Action_List.Set_Capacity (25);
            Add_Action (Table.States (606), 12, (401, 0), 1);
            Add_Action (Table.States (606), 15, (370, 0), 3);
            Add_Action (Table.States (606), 17, (365, 0), 4);
            Add_Action (Table.States (606), 18, (382, 0), 5);
            Add_Action (Table.States (606), 19, (363, 0), 6);
            Add_Action (Table.States (606), 20, (357, 0), 7);
            Add_Action (Table.States (606), 30, (316, 0), 13);
            Add_Action (Table.States (606), 31, (290, 0), 14);
            Add_Action (Table.States (606), 32, (289, 0), 15);
            Add_Action (Table.States (606), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (606), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (606), 37, (288, 0), 17);
            Add_Conflict (Table.States (606), 37, (285, 1),  0);
            Add_Action (Table.States (606), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (606), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (606), 41, (271, 0), 18);
            Add_Action (Table.States (606), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (606), 64, (273, 0), 27);
            Add_Action (Table.States (606), 65, (264, 0), 28);
            Add_Action (Table.States (606), 84, (124, 0), 32);
            Add_Action (Table.States (606), 86, (252, 0), 33);
            Add_Action (Table.States (606), 90, (268, 0), 34);
            Add_Action (Table.States (606), 105, (265, 0), 35);
            Add_Action (Table.States (606), 116, (196, 0), 146);
            Add_Action (Table.States (606), 117, (196, 1), 37);
            Add_Action (Table.States (606), 118, (195, 6), 38);
            Table.States (606).Goto_List.Set_Capacity (46);
            Add_Goto (Table.States (606), 124, 39);
            Add_Goto (Table.States (606), 195, 52);
            Add_Goto (Table.States (606), 196, 53);
            Add_Goto (Table.States (606), 197, 54);
            Add_Goto (Table.States (606), 198, 55);
            Add_Goto (Table.States (606), 199, 56);
            Add_Goto (Table.States (606), 201, 57);
            Add_Goto (Table.States (606), 251, 58);
            Add_Goto (Table.States (606), 252, 59);
            Add_Goto (Table.States (606), 255, 60);
            Add_Goto (Table.States (606), 259, 958);
            Add_Goto (Table.States (606), 261, 331);
            Add_Goto (Table.States (606), 262, 62);
            Add_Goto (Table.States (606), 263, 63);
            Add_Goto (Table.States (606), 264, 64);
            Add_Goto (Table.States (606), 265, 65);
            Add_Goto (Table.States (606), 266, 66);
            Add_Goto (Table.States (606), 267, 67);
            Add_Goto (Table.States (606), 268, 68);
            Add_Goto (Table.States (606), 271, 69);
            Add_Goto (Table.States (606), 273, 70);
            Add_Goto (Table.States (606), 275, 71);
            Add_Goto (Table.States (606), 285, 72);
            Add_Goto (Table.States (606), 286, 73);
            Add_Goto (Table.States (606), 288, 74);
            Add_Goto (Table.States (606), 289, 75);
            Add_Goto (Table.States (606), 290, 76);
            Add_Goto (Table.States (606), 310, 82);
            Add_Goto (Table.States (606), 311, 83);
            Add_Goto (Table.States (606), 316, 84);
            Add_Goto (Table.States (606), 318, 85);
            Add_Goto (Table.States (606), 357, 110);
            Add_Goto (Table.States (606), 363, 111);
            Add_Goto (Table.States (606), 364, 112);
            Add_Goto (Table.States (606), 365, 113);
            Add_Goto (Table.States (606), 366, 114);
            Add_Goto (Table.States (606), 367, 115);
            Add_Goto (Table.States (606), 370, 116);
            Add_Goto (Table.States (606), 376, 117);
            Add_Goto (Table.States (606), 378, 118);
            Add_Goto (Table.States (606), 379, 119);
            Add_Goto (Table.States (606), 381, 959);
            Add_Goto (Table.States (606), 382, 120);
            Add_Goto (Table.States (606), 401, 133);
            Add_Goto (Table.States (606), 461, 332);
            Add_Goto (Table.States (606), 462, 144);
            Table.States (606).Kernel := To_Vector ((0 => ((379, 0),  18,  5, (32767, 0),  0)));
            Table.States (606).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (264, 0),  65, 28)));
            Table.States (607).Action_List.Set_Capacity (13);
            Add_Action (Table.States (607), 44, (233, 2), 167);
            Add_Action (Table.States (607), 52, (233, 3), 168);
            Add_Action (Table.States (607), 65, (234, 1), 169);
            Add_Action (Table.States (607), 76, (256, 0), 170);
            Add_Action (Table.States (607), 85, (205, 4), 171);
            Add_Action (Table.States (607), 86, (213, 2), 172);
            Add_Action (Table.States (607), 90, (268, 0), 34);
            Add_Action (Table.States (607), 106, (237, 1), 173);
            Add_Action (Table.States (607), 107, (237, 0), 174);
            Add_Action (Table.States (607), 115, (234, 0), 175);
            Add_Action (Table.States (607), 116, (196, 0), 146);
            Add_Action (Table.States (607), 117, (196, 1), 37);
            Add_Action (Table.States (607), 118, (195, 6), 38);
            Table.States (607).Goto_List.Set_Capacity (28);
            Add_Goto (Table.States (607), 195, 176);
            Add_Goto (Table.States (607), 196, 148);
            Add_Goto (Table.States (607), 197, 54);
            Add_Goto (Table.States (607), 198, 55);
            Add_Goto (Table.States (607), 199, 56);
            Add_Goto (Table.States (607), 201, 57);
            Add_Goto (Table.States (607), 205, 177);
            Add_Goto (Table.States (607), 206, 178);
            Add_Goto (Table.States (607), 210, 179);
            Add_Goto (Table.States (607), 211, 180);
            Add_Goto (Table.States (607), 213, 181);
            Add_Goto (Table.States (607), 214, 182);
            Add_Goto (Table.States (607), 215, 183);
            Add_Goto (Table.States (607), 218, 184);
            Add_Goto (Table.States (607), 219, 185);
            Add_Goto (Table.States (607), 220, 186);
            Add_Goto (Table.States (607), 231, 960);
            Add_Goto (Table.States (607), 232, 190);
            Add_Goto (Table.States (607), 233, 191);
            Add_Goto (Table.States (607), 234, 192);
            Add_Goto (Table.States (607), 237, 193);
            Add_Goto (Table.States (607), 251, 58);
            Add_Goto (Table.States (607), 252, 59);
            Add_Goto (Table.States (607), 255, 60);
            Add_Goto (Table.States (607), 256, 194);
            Add_Goto (Table.States (607), 268, 68);
            Add_Goto (Table.States (607), 311, 83);
            Add_Goto (Table.States (607), 465, 196);
            Table.States (607).Kernel := To_Vector ((0 => ((402, 0),  61,  1, (32767, 0),  0)));
            Table.States (607).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (608).Action_List.Set_Capacity (50);
            Add_Action (Table.States (608), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (365, 0),  4);
            Table.States (608).Kernel := To_Vector ((0 => ((365, 0),  108,  0, (365, 0),  4)));
            Table.States (608).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (365, 0),  4)));
            Table.States (609).Action_List.Set_Capacity (6);
            Add_Action (Table.States (609), (56, 86, 90, 116, 117, 118), (187, 0),  2);
            Table.States (609).Kernel := To_Vector ((0 => ((187, 0),  65,  0, (187, 0),  2)));
            Table.States (609).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (187, 0),  2)));
            Table.States (610).Action_List.Set_Capacity (5);
            Add_Action (Table.States (610), 85, (198, 0), 281);
            Add_Action (Table.States (610), 87, (258, 0), 961);
            Add_Action (Table.States (610), 96, (197, 0), 283);
            Add_Action (Table.States (610), 113, (121, 0), 285);
            Add_Action (Table.States (610), 114, (121, 1), 286);
            Table.States (610).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (610), 121, 287);
            Add_Goto (Table.States (610), 313, 289);
            Table.States (610).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((258, 0),  195,  1, (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0)));
            Table.States (610).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (258, 0),  87, 961)));
            Table.States (611).Action_List.Set_Capacity (43);
            Add_Action (Table.States (611), 33, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 36, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 42, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 43, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 45, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 46, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 47, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 48, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 49, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 50, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 52, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 61, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 63, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 69, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 72, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 73, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 74, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 75, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 82, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 85, (162, 0), 612);
            Add_Action (Table.States (611), 87, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 88, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 89, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 91, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 94, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 95, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 96, (197, 0), 283);
            Add_Action (Table.States (611), 97, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 98, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 99, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 100, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 101, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 103, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 104, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 106, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 107, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 108, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 109, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 110, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 111, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 112, Reduce, (257, 0),  2);
            Add_Action (Table.States (611), 113, (121, 0), 285);
            Add_Action (Table.States (611), 114, (121, 1), 286);
            Table.States (611).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (611), 121, 287);
            Add_Goto (Table.States (611), 162, 962);
            Add_Goto (Table.States (611), 313, 289);
            Table.States (611).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((257, 0),  195,  0, (257, 0),  2), ((257, 2),  195,  5, (32767, 0),  0), ((311, 0),  195,
             3, (32767, 0),  0)));
            Table.States (611).Minimal_Complete_Actions := To_Vector (((Reduce, (257, 0),  2), (Shift, (162, 0),  85,
            612)));
         end Subr_24;
         procedure Subr_25
         is begin
            Table.States (612).Action_List.Set_Capacity (20);
            Add_Action (Table.States (612), 12, (402, 0), 165);
            Add_Action (Table.States (612), 39, (249, 0), 353);
            Add_Action (Table.States (612), 41, (242, 0), 354);
            Add_Action (Table.States (612), 44, (233, 2), 167);
            Add_Action (Table.States (612), 51, (247, 0), 530);
            Add_Action (Table.States (612), 52, (187, 0), 356);
            Add_Action (Table.States (612), 62, (200, 2), 531);
            Add_Action (Table.States (612), 64, (245, 0), 358);
            Add_Action (Table.States (612), 65, (234, 1), 169);
            Add_Action (Table.States (612), 76, (256, 0), 170);
            Add_Action (Table.States (612), 85, (205, 4), 171);
            Add_Action (Table.States (612), 86, (213, 2), 172);
            Add_Action (Table.States (612), 90, (268, 0), 34);
            Add_Action (Table.States (612), 92, (315, 2), 532);
            Add_Action (Table.States (612), 106, (237, 1), 173);
            Add_Action (Table.States (612), 107, (237, 0), 174);
            Add_Action (Table.States (612), 115, (234, 0), 175);
            Add_Action (Table.States (612), 116, (196, 0), 146);
            Add_Action (Table.States (612), 117, (196, 1), 37);
            Add_Action (Table.States (612), 118, (195, 6), 360);
            Table.States (612).Goto_List.Set_Capacity (45);
            Add_Goto (Table.States (612), 131, 533);
            Add_Goto (Table.States (612), 140, 534);
            Add_Goto (Table.States (612), 163, 963);
            Add_Goto (Table.States (612), 187, 365);
            Add_Goto (Table.States (612), 195, 366);
            Add_Goto (Table.States (612), 196, 367);
            Add_Goto (Table.States (612), 197, 54);
            Add_Goto (Table.States (612), 198, 55);
            Add_Goto (Table.States (612), 199, 56);
            Add_Goto (Table.States (612), 200, 368);
            Add_Goto (Table.States (612), 201, 57);
            Add_Goto (Table.States (612), 203, 369);
            Add_Goto (Table.States (612), 205, 177);
            Add_Goto (Table.States (612), 206, 178);
            Add_Goto (Table.States (612), 209, 536);
            Add_Goto (Table.States (612), 210, 179);
            Add_Goto (Table.States (612), 211, 180);
            Add_Goto (Table.States (612), 213, 181);
            Add_Goto (Table.States (612), 214, 182);
            Add_Goto (Table.States (612), 215, 183);
            Add_Goto (Table.States (612), 218, 184);
            Add_Goto (Table.States (612), 219, 185);
            Add_Goto (Table.States (612), 220, 186);
            Add_Goto (Table.States (612), 227, 537);
            Add_Goto (Table.States (612), 228, 188);
            Add_Goto (Table.States (612), 231, 378);
            Add_Goto (Table.States (612), 232, 190);
            Add_Goto (Table.States (612), 233, 191);
            Add_Goto (Table.States (612), 234, 192);
            Add_Goto (Table.States (612), 237, 193);
            Add_Goto (Table.States (612), 239, 538);
            Add_Goto (Table.States (612), 242, 380);
            Add_Goto (Table.States (612), 245, 381);
            Add_Goto (Table.States (612), 247, 539);
            Add_Goto (Table.States (612), 249, 540);
            Add_Goto (Table.States (612), 251, 58);
            Add_Goto (Table.States (612), 252, 59);
            Add_Goto (Table.States (612), 255, 60);
            Add_Goto (Table.States (612), 256, 194);
            Add_Goto (Table.States (612), 268, 68);
            Add_Goto (Table.States (612), 311, 83);
            Add_Goto (Table.States (612), 312, 541);
            Add_Goto (Table.States (612), 315, 542);
            Add_Goto (Table.States (612), 402, 195);
            Add_Goto (Table.States (612), 465, 196);
            Table.States (612).Kernel := To_Vector ((((162, 0),  85,  4, (32767, 0),  0), ((198, 0),  85,  2, (32767,
            0),  0), ((313, 0),  85,  2, (32767, 0),  0), ((313, 1),  85,  5, (32767, 0),  0), ((313, 2),  85,  8,
            (32767, 0),  0), ((313, 3),  85,  4, (32767, 0),  0)));
            Table.States (612).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (613).Action_List.Set_Capacity (39);
            Add_Action (Table.States (613), (33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 72, 73, 74, 75,
            82, 87, 88, 89, 91, 94, 95, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110, 111, 112), (257, 3),
            2);
            Table.States (613).Kernel := To_Vector ((0 => ((257, 3),  162,  0, (257, 3),  2)));
            Table.States (613).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (257, 3),  2)));
            Table.States (614).Action_List.Set_Capacity (39);
            Add_Action (Table.States (614), (33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 72, 73, 74, 75,
            82, 87, 88, 89, 91, 94, 95, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110, 111, 112), (256, 0),
            3);
            Table.States (614).Kernel := To_Vector ((0 => ((256, 0),  257,  0, (256, 0),  3)));
            Table.States (614).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (256, 0),  3)));
            Table.States (615).Action_List.Set_Capacity (14);
            Add_Action (Table.States (615), 12, (402, 0), 165);
            Add_Action (Table.States (615), 44, (233, 2), 167);
            Add_Action (Table.States (615), 52, (233, 3), 168);
            Add_Action (Table.States (615), 65, (234, 1), 169);
            Add_Action (Table.States (615), 76, (256, 0), 170);
            Add_Action (Table.States (615), 85, (205, 4), 171);
            Add_Action (Table.States (615), 86, (213, 2), 172);
            Add_Action (Table.States (615), 90, (268, 0), 34);
            Add_Action (Table.States (615), 106, (237, 1), 173);
            Add_Action (Table.States (615), 107, (237, 0), 174);
            Add_Action (Table.States (615), 115, (234, 0), 175);
            Add_Action (Table.States (615), 116, (196, 0), 146);
            Add_Action (Table.States (615), 117, (196, 1), 37);
            Add_Action (Table.States (615), 118, (195, 6), 38);
            Table.States (615).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (615), 195, 176);
            Add_Goto (Table.States (615), 196, 148);
            Add_Goto (Table.States (615), 197, 54);
            Add_Goto (Table.States (615), 198, 55);
            Add_Goto (Table.States (615), 199, 56);
            Add_Goto (Table.States (615), 201, 57);
            Add_Goto (Table.States (615), 205, 177);
            Add_Goto (Table.States (615), 206, 178);
            Add_Goto (Table.States (615), 210, 179);
            Add_Goto (Table.States (615), 211, 180);
            Add_Goto (Table.States (615), 213, 181);
            Add_Goto (Table.States (615), 214, 182);
            Add_Goto (Table.States (615), 215, 183);
            Add_Goto (Table.States (615), 218, 184);
            Add_Goto (Table.States (615), 219, 185);
            Add_Goto (Table.States (615), 220, 186);
            Add_Goto (Table.States (615), 227, 964);
            Add_Goto (Table.States (615), 228, 188);
            Add_Goto (Table.States (615), 231, 189);
            Add_Goto (Table.States (615), 232, 190);
            Add_Goto (Table.States (615), 233, 191);
            Add_Goto (Table.States (615), 234, 192);
            Add_Goto (Table.States (615), 237, 193);
            Add_Goto (Table.States (615), 251, 58);
            Add_Goto (Table.States (615), 252, 59);
            Add_Goto (Table.States (615), 255, 60);
            Add_Goto (Table.States (615), 256, 194);
            Add_Goto (Table.States (615), 268, 68);
            Add_Goto (Table.States (615), 311, 83);
            Add_Goto (Table.States (615), 402, 195);
            Add_Goto (Table.States (615), 465, 196);
            Table.States (615).Kernel := To_Vector ((0 => ((249, 1),  38,  1, (32767, 0),  0)));
            Table.States (615).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (616).Action_List.Set_Capacity (1);
            Add_Action (Table.States (616), 116, (347, 0), 260);
            Table.States (616).Kernel := To_Vector ((((347, 0),  59,  9, (32767, 0),  0), ((347, 1),  59,  6, (32767,
            0),  0), ((347, 2),  59,  7, (32767, 0),  0), ((347, 3),  59,  4, (32767, 0),  0)));
            Table.States (616).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (347, 0),  116, 260)));
            Table.States (617).Action_List.Set_Capacity (1);
            Add_Action (Table.States (617), 116, (341, 0), 263);
            Table.States (617).Kernel := To_Vector ((((341, 0),  60,  12, (32767, 0),  0), ((341, 1),  60,  9, (32767,
            0),  0), ((341, 2),  60,  4, (32767, 0),  0), ((341, 3),  60,  10, (32767, 0),  0), ((341, 4),  60,  7,
            (32767, 0),  0), ((341, 5),  60,  2, (32767, 0),  0)));
            Table.States (617).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (341, 0),  116, 263)));
            Table.States (618).Action_List.Set_Capacity (3);
            Add_Action (Table.States (618), 24, (335, 4), 277);
            Add_Action (Table.States (618), 93, (335, 0), 965);
            Add_Conflict (Table.States (618), 93, (136, 0),  1);
            Add_Action (Table.States (618), 95, Reduce, (136, 0),  1);
            Table.States (618).Kernel := To_Vector ((((136, 0),  116,  0, (136, 0),  1), ((335, 0),  116,  9, (32767,
            0),  0), ((335, 1),  116,  7, (32767, 0),  0), ((335, 2),  116,  7, (32767, 0),  0), ((335, 3),  116,  5,
            (32767, 0),  0), ((335, 4),  116,  5, (32767, 0),  0), ((335, 5),  116,  3, (32767, 0),  0), ((335, 6),
            116,  8, (32767, 0),  0), ((335, 7),  116,  6, (32767, 0),  0)));
            Table.States (618).Minimal_Complete_Actions := To_Vector (((Reduce, (136, 0),  1), (Shift, (335, 4),  24,
            277)));
            Table.States (619).Action_List.Set_Capacity (4);
            Add_Action (Table.States (619), (38, 59, 60, 116), (250, 0),  1);
            Table.States (619).Kernel := To_Vector ((0 => ((250, 0),  135,  0, (250, 0),  1)));
            Table.States (619).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (250, 0),  1)));
            Table.States (620).Action_List.Set_Capacity (2);
            Add_Action (Table.States (620), 93, (135, 0), 966);
            Add_Action (Table.States (620), 95, (136, 1), 280);
            Table.States (620).Kernel := To_Vector ((((135, 0),  136,  9, (32767, 0),  0), ((135, 1),  136,  7, (32767,
            0),  0), ((135, 2),  136,  7, (32767, 0),  0), ((135, 3),  136,  5, (32767, 0),  0), ((135, 4),  136,  8,
            (32767, 0),  0), ((135, 5),  136,  6, (32767, 0),  0), ((135, 6),  136,  6, (32767, 0),  0), ((135, 7),
            136,  4, (32767, 0),  0), ((135, 8),  136,  8, (32767, 0),  0), ((135, 9),  136,  6, (32767, 0),  0),
            ((135, 10),  136,  6, (32767, 0),  0), ((135, 11),  136,  4, (32767, 0),  0), ((135, 12),  136,  7, (32767,
            0),  0), ((135, 13),  136,  5, (32767, 0),  0), ((135, 14),  136,  5, (32767, 0),  0), ((135, 15),  136,
            3, (32767, 0),  0), ((135, 16),  136,  10, (32767, 0),  0), ((135, 17),  136,  8, (32767, 0),  0), ((135,
            18),  136,  8, (32767, 0),  0), ((135, 19),  136,  6, (32767, 0),  0), ((135, 20),  136,  9, (32767, 0),
            0), ((135, 21),  136,  7, (32767, 0),  0), ((135, 22),  136,  7, (32767, 0),  0), ((135, 23),  136,  5,
            (32767, 0),  0), ((135, 24),  136,  9, (32767, 0),  0), ((135, 25),  136,  7, (32767, 0),  0), ((135, 26),
            136,  7, (32767, 0),  0), ((135, 27),  136,  5, (32767, 0),  0), ((135, 28),  136,  8, (32767, 0),  0),
            ((135, 29),  136,  6, (32767, 0),  0), ((135, 30),  136,  6, (32767, 0),  0), ((135, 31),  136,  4, (32767,
            0),  0), ((135, 32),  136,  15, (32767, 0),  0), ((135, 33),  136,  13, (32767, 0),  0), ((135, 34),  136,
            13, (32767, 0),  0), ((135, 35),  136,  11, (32767, 0),  0), ((135, 36),  136,  14, (32767, 0),  0), ((135,
            37),  136,  12, (32767, 0),  0), ((135, 38),  136,  12, (32767, 0),  0), ((135, 39),  136,  10, (32767, 0),
             0), ((135, 40),  136,  14, (32767, 0),  0), ((135, 41),  136,  12, (32767, 0),  0), ((135, 42),  136,  12,
            (32767, 0),  0), ((135, 43),  136,  10, (32767, 0),  0), ((135, 44),  136,  13, (32767, 0),  0), ((135,
            45),  136,  11, (32767, 0),  0), ((135, 46),  136,  11, (32767, 0),  0), ((135, 47),  136,  9, (32767, 0),
            0), ((136, 1),  136,  2, (32767, 0),  0)));
            Table.States (620).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 0),  93, 966)));
            Table.States (621).Action_List.Set_Capacity (4);
            Add_Action (Table.States (621), (38, 59, 60, 116), (460, 0),  1);
            Table.States (621).Kernel := To_Vector ((0 => ((460, 0),  250,  0, (460, 0),  1)));
            Table.States (621).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (460, 0),  1)));
            Table.States (622).Action_List.Set_Capacity (4);
            Add_Action (Table.States (622), (38, 59, 60, 116), (250, 1),  1);
            Table.States (622).Kernel := To_Vector ((0 => ((250, 1),  335,  0, (250, 1),  1)));
            Table.States (622).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (250, 1),  1)));
            Table.States (623).Action_List.Set_Capacity (4);
            Add_Action (Table.States (623), 38, (249, 0), 967);
            Add_Action (Table.States (623), 59, (347, 0), 616);
            Add_Action (Table.States (623), 60, (341, 0), 617);
            Add_Action (Table.States (623), 116, (136, 0), 618);
            Table.States (623).Goto_List.Set_Capacity (7);
            Add_Goto (Table.States (623), 135, 619);
            Add_Goto (Table.States (623), 136, 620);
            Add_Goto (Table.States (623), 250, 968);
            Add_Goto (Table.States (623), 335, 622);
            Add_Goto (Table.States (623), 341, 104);
            Add_Goto (Table.States (623), 347, 107);
            Add_Goto (Table.States (623), 460, 969);
            Table.States (623).Kernel := To_Vector ((((249, 0),  460,  2, (32767, 0),  0), ((460, 1),  460,  3, (32767,
            0),  0), ((460, 2),  460,  3, (32767, 0),  0)));
            Table.States (623).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (249, 0),  38, 967)));
            Table.States (624).Action_List.Set_Capacity (1);
            Add_Action (Table.States (624), 49, (242, 0), 970);
            Table.States (624).Kernel := To_Vector ((((242, 0),  243,  8, (32767, 0),  0), ((242, 1),  243,  6, (32767,
            0),  0), ((242, 2),  243,  4, (32767, 0),  0), ((242, 3),  243,  2, (32767, 0),  0)));
            Table.States (624).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (242, 0),  49, 970)));
            Table.States (625).Action_List.Set_Capacity (1);
            Add_Action (Table.States (625), (1 =>  116), (248, 1),  1);
            Table.States (625).Kernel := To_Vector ((0 => ((248, 1),  40,  0, (248, 1),  1)));
            Table.States (625).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (248, 1),  1)));
            Table.States (626).Action_List.Set_Capacity (1);
            Add_Action (Table.States (626), (1 =>  116), (248, 0),  1);
            Table.States (626).Kernel := To_Vector ((0 => ((248, 0),  55,  0, (248, 0),  1)));
            Table.States (626).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (248, 0),  1)));
            Table.States (627).Action_List.Set_Capacity (1);
            Add_Action (Table.States (627), 116, (278, 0), 454);
            Table.States (627).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (627), 278, 971);
            Add_Goto (Table.States (627), 280, 972);
            Table.States (627).Kernel := To_Vector ((((247, 0),  248,  5, (32767, 0),  0), ((247, 1),  248,  5, (32767,
            0),  0)));
            Table.States (627).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (278, 0),  116, 454)));
            Table.States (628).Action_List.Set_Capacity (30);
            Add_Action (Table.States (628), 43, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 45, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 46, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 48, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 52, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 61, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 73, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 75, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 86, Reduce, (187, 0),  2);
            Add_Action (Table.States (628), 87, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 88, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 89, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 90, Reduce, (187, 0),  2);
            Add_Action (Table.States (628), 91, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 95, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 97, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 98, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 99, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 100, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 101, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 103, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 104, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 106, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 107, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 109, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 110, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 111, Reduce, (234, 1),  1);
            Add_Action (Table.States (628), 116, Reduce, (187, 0),  2);
            Add_Action (Table.States (628), 117, Reduce, (187, 0),  2);
            Add_Action (Table.States (628), 118, Reduce, (187, 0),  2);
            Table.States (628).Kernel := To_Vector ((((187, 0),  65,  0, (187, 0),  2), ((234, 1),  65,  0, (234, 1),
            1)));
            Table.States (628).Minimal_Complete_Actions := To_Vector (((Reduce, (187, 0),  2), (Reduce, (234, 1),
            1)));
            Table.States (629).Action_List.Set_Capacity (1);
            Add_Action (Table.States (629), 82, (245, 0), 973);
            Table.States (629).Kernel := To_Vector ((0 => ((245, 0),  227,  5, (32767, 0),  0)));
            Table.States (629).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (245, 0),  82, 973)));
            Table.States (630).Action_List.Set_Capacity (1);
            Add_Action (Table.States (630), (1 =>  87), (207, 1),  2);
            Table.States (630).Kernel := To_Vector ((0 => ((207, 1),  67,  0, (207, 1),  2)));
            Table.States (630).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (207, 1),  2)));
            Table.States (631).Action_List.Set_Capacity (15);
            Add_Action (Table.States (631), 12, (402, 0), 165);
            Add_Action (Table.States (631), 44, (233, 2), 167);
            Add_Action (Table.States (631), 52, (187, 0), 356);
            Add_Action (Table.States (631), 62, (178, 3), 385);
            Add_Action (Table.States (631), 65, (234, 1), 169);
            Add_Action (Table.States (631), 76, (256, 0), 170);
            Add_Action (Table.States (631), 85, (205, 4), 171);
            Add_Action (Table.States (631), 86, (213, 2), 172);
            Add_Action (Table.States (631), 90, (268, 0), 34);
            Add_Action (Table.States (631), 106, (237, 1), 173);
            Add_Action (Table.States (631), 107, (237, 0), 174);
            Add_Action (Table.States (631), 115, (234, 0), 175);
            Add_Action (Table.States (631), 116, (196, 0), 146);
            Add_Action (Table.States (631), 117, (196, 1), 37);
            Add_Action (Table.States (631), 118, (195, 6), 38);
            Table.States (631).Goto_List.Set_Capacity (36);
            Add_Goto (Table.States (631), 131, 361);
            Add_Goto (Table.States (631), 140, 362);
            Add_Goto (Table.States (631), 178, 974);
            Add_Goto (Table.States (631), 187, 365);
            Add_Goto (Table.States (631), 195, 366);
            Add_Goto (Table.States (631), 196, 148);
            Add_Goto (Table.States (631), 197, 54);
            Add_Goto (Table.States (631), 198, 55);
            Add_Goto (Table.States (631), 199, 56);
            Add_Goto (Table.States (631), 201, 57);
            Add_Goto (Table.States (631), 203, 369);
            Add_Goto (Table.States (631), 205, 177);
            Add_Goto (Table.States (631), 206, 178);
            Add_Goto (Table.States (631), 210, 179);
            Add_Goto (Table.States (631), 211, 180);
            Add_Goto (Table.States (631), 213, 181);
            Add_Goto (Table.States (631), 214, 182);
            Add_Goto (Table.States (631), 215, 183);
            Add_Goto (Table.States (631), 218, 184);
            Add_Goto (Table.States (631), 219, 185);
            Add_Goto (Table.States (631), 220, 186);
            Add_Goto (Table.States (631), 227, 975);
            Add_Goto (Table.States (631), 228, 188);
            Add_Goto (Table.States (631), 231, 378);
            Add_Goto (Table.States (631), 232, 190);
            Add_Goto (Table.States (631), 233, 191);
            Add_Goto (Table.States (631), 234, 192);
            Add_Goto (Table.States (631), 237, 193);
            Add_Goto (Table.States (631), 251, 58);
            Add_Goto (Table.States (631), 252, 59);
            Add_Goto (Table.States (631), 255, 60);
            Add_Goto (Table.States (631), 256, 194);
            Add_Goto (Table.States (631), 268, 68);
            Add_Goto (Table.States (631), 311, 83);
            Add_Goto (Table.States (631), 402, 195);
            Add_Goto (Table.States (631), 465, 196);
            Table.States (631).Kernel := To_Vector ((0 => ((177, 1),  91,  1, (32767, 0),  0)));
            Table.States (631).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (632).Action_List.Set_Capacity (15);
            Add_Action (Table.States (632), 12, (402, 0), 165);
            Add_Action (Table.States (632), 44, (233, 2), 167);
            Add_Action (Table.States (632), 52, (233, 3), 168);
            Add_Action (Table.States (632), 65, (234, 1), 169);
            Add_Action (Table.States (632), 76, (256, 0), 170);
            Add_Action (Table.States (632), 85, (205, 4), 171);
            Add_Action (Table.States (632), 86, (213, 2), 172);
            Add_Action (Table.States (632), 90, (268, 0), 34);
            Add_Action (Table.States (632), 92, (314, 1), 976);
            Add_Action (Table.States (632), 106, (237, 1), 173);
            Add_Action (Table.States (632), 107, (237, 0), 174);
            Add_Action (Table.States (632), 115, (234, 0), 175);
            Add_Action (Table.States (632), 116, (196, 0), 146);
            Add_Action (Table.States (632), 117, (196, 1), 37);
            Add_Action (Table.States (632), 118, (195, 6), 38);
            Table.States (632).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (632), 195, 176);
            Add_Goto (Table.States (632), 196, 148);
            Add_Goto (Table.States (632), 197, 54);
            Add_Goto (Table.States (632), 198, 55);
            Add_Goto (Table.States (632), 199, 56);
            Add_Goto (Table.States (632), 201, 57);
            Add_Goto (Table.States (632), 205, 177);
            Add_Goto (Table.States (632), 206, 178);
            Add_Goto (Table.States (632), 210, 179);
            Add_Goto (Table.States (632), 211, 180);
            Add_Goto (Table.States (632), 213, 181);
            Add_Goto (Table.States (632), 214, 182);
            Add_Goto (Table.States (632), 215, 183);
            Add_Goto (Table.States (632), 218, 184);
            Add_Goto (Table.States (632), 219, 185);
            Add_Goto (Table.States (632), 220, 186);
            Add_Goto (Table.States (632), 227, 977);
            Add_Goto (Table.States (632), 228, 188);
            Add_Goto (Table.States (632), 231, 189);
            Add_Goto (Table.States (632), 232, 190);
            Add_Goto (Table.States (632), 233, 191);
            Add_Goto (Table.States (632), 234, 192);
            Add_Goto (Table.States (632), 237, 193);
            Add_Goto (Table.States (632), 251, 58);
            Add_Goto (Table.States (632), 252, 59);
            Add_Goto (Table.States (632), 255, 60);
            Add_Goto (Table.States (632), 256, 194);
            Add_Goto (Table.States (632), 268, 68);
            Add_Goto (Table.States (632), 311, 83);
            Add_Goto (Table.States (632), 402, 195);
            Add_Goto (Table.States (632), 465, 196);
            Table.States (632).Kernel := To_Vector ((((314, 0),  99,  1, (32767, 0),  0), ((314, 1),  99,  1, (32767,
            0),  0)));
            Table.States (632).Minimal_Complete_Actions := To_Vector (((Shift, (234, 0),  115, 175), (Shift, (314, 1),
            92, 976)));
            Table.States (633).Action_List.Set_Capacity (3);
            Add_Action (Table.States (633), (87, 88, 95), (217, 0),  2);
            Table.States (633).Kernel := To_Vector ((0 => ((217, 0),  314,  0, (217, 0),  2)));
            Table.States (633).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (217, 0),  2)));
         end Subr_25;
         procedure Subr_26
         is begin
            Table.States (634).Action_List.Set_Capacity (22);
            Add_Action (Table.States (634), 33, Reduce, (131, 1),  2);
            Add_Action (Table.States (634), 36, Reduce, (131, 1),  2);
            Add_Action (Table.States (634), 45, Reduce, (131, 1),  2);
            Add_Action (Table.States (634), 48, Reduce, (131, 1),  2);
            Add_Action (Table.States (634), 50, Reduce, (131, 1),  2);
            Add_Action (Table.States (634), 61, Reduce, (131, 1),  2);
            Add_Action (Table.States (634), 63, Reduce, (131, 1),  2);
            Add_Action (Table.States (634), 69, Reduce, (131, 1),  2);
            Add_Action (Table.States (634), 71, (453, 0), 635);
            Add_Action (Table.States (634), 72, (153, 0), 636);
            Add_Action (Table.States (634), 74, (139, 0), 637);
            Add_Action (Table.States (634), 75, Reduce, (131, 1),  2);
            Add_Action (Table.States (634), 85, (162, 0), 612);
            Add_Action (Table.States (634), 87, Reduce, (131, 1),  2);
            Add_Action (Table.States (634), 91, Reduce, (131, 1),  2);
            Add_Action (Table.States (634), 94, Reduce, (131, 1),  2);
            Add_Action (Table.States (634), 95, Reduce, (131, 1),  2);
            Add_Action (Table.States (634), 96, (197, 0), 283);
            Add_Action (Table.States (634), 99, Reduce, (131, 1),  2);
            Add_Action (Table.States (634), 108, Reduce, (131, 1),  2);
            Add_Action (Table.States (634), 113, (121, 0), 285);
            Add_Action (Table.States (634), 114, (121, 1), 286);
            Table.States (634).Goto_List.Set_Capacity (8);
            Add_Goto (Table.States (634), 121, 287);
            Add_Goto (Table.States (634), 132, 978);
            Add_Goto (Table.States (634), 133, 640);
            Add_Goto (Table.States (634), 139, 641);
            Add_Goto (Table.States (634), 153, 642);
            Add_Goto (Table.States (634), 162, 643);
            Add_Goto (Table.States (634), 313, 289);
            Add_Goto (Table.States (634), 453, 644);
            Table.States (634).Kernel := To_Vector ((((131, 0),  195,  2, (32767, 0),  0), ((131, 1),  195,  0, (131,
            1),  2), ((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767, 0),  0), ((199, 0),  195,  2,
            (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3, (32767, 0),  0), ((311, 0),
            195,  3, (32767, 0),  0)));
            Table.States (634).Minimal_Complete_Actions := To_Vector (((Shift, (153, 0),  72, 636), (Reduce, (131, 1),
            2)));
            Table.States (635).Action_List.Set_Capacity (13);
            Add_Action (Table.States (635), 44, (233, 2), 167);
            Add_Action (Table.States (635), 52, (233, 3), 168);
            Add_Action (Table.States (635), 65, (234, 1), 169);
            Add_Action (Table.States (635), 76, (256, 0), 170);
            Add_Action (Table.States (635), 85, (205, 4), 171);
            Add_Action (Table.States (635), 86, (213, 2), 172);
            Add_Action (Table.States (635), 90, (268, 0), 34);
            Add_Action (Table.States (635), 106, (237, 1), 173);
            Add_Action (Table.States (635), 107, (237, 0), 174);
            Add_Action (Table.States (635), 115, (234, 0), 175);
            Add_Action (Table.States (635), 116, (196, 0), 146);
            Add_Action (Table.States (635), 117, (196, 1), 37);
            Add_Action (Table.States (635), 118, (195, 6), 38);
            Table.States (635).Goto_List.Set_Capacity (28);
            Add_Goto (Table.States (635), 195, 176);
            Add_Goto (Table.States (635), 196, 148);
            Add_Goto (Table.States (635), 197, 54);
            Add_Goto (Table.States (635), 198, 55);
            Add_Goto (Table.States (635), 199, 56);
            Add_Goto (Table.States (635), 201, 57);
            Add_Goto (Table.States (635), 205, 177);
            Add_Goto (Table.States (635), 206, 178);
            Add_Goto (Table.States (635), 210, 179);
            Add_Goto (Table.States (635), 211, 180);
            Add_Goto (Table.States (635), 213, 181);
            Add_Goto (Table.States (635), 214, 182);
            Add_Goto (Table.States (635), 215, 183);
            Add_Goto (Table.States (635), 218, 184);
            Add_Goto (Table.States (635), 219, 185);
            Add_Goto (Table.States (635), 220, 186);
            Add_Goto (Table.States (635), 231, 979);
            Add_Goto (Table.States (635), 232, 190);
            Add_Goto (Table.States (635), 233, 191);
            Add_Goto (Table.States (635), 234, 192);
            Add_Goto (Table.States (635), 237, 193);
            Add_Goto (Table.States (635), 251, 58);
            Add_Goto (Table.States (635), 252, 59);
            Add_Goto (Table.States (635), 255, 60);
            Add_Goto (Table.States (635), 256, 194);
            Add_Goto (Table.States (635), 268, 68);
            Add_Goto (Table.States (635), 311, 83);
            Add_Goto (Table.States (635), 465, 196);
            Table.States (635).Kernel := To_Vector ((((453, 0),  71,  5, (32767, 0),  0), ((453, 1),  71,  1, (32767,
            0),  0)));
            Table.States (635).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (636).Action_List.Set_Capacity (13);
            Add_Action (Table.States (636), 44, (233, 2), 167);
            Add_Action (Table.States (636), 52, (233, 3), 168);
            Add_Action (Table.States (636), 65, (234, 1), 169);
            Add_Action (Table.States (636), 76, (256, 0), 170);
            Add_Action (Table.States (636), 85, (205, 4), 171);
            Add_Action (Table.States (636), 86, (213, 2), 172);
            Add_Action (Table.States (636), 90, (268, 0), 34);
            Add_Action (Table.States (636), 106, (237, 1), 173);
            Add_Action (Table.States (636), 107, (237, 0), 174);
            Add_Action (Table.States (636), 115, (234, 0), 175);
            Add_Action (Table.States (636), 116, (196, 0), 146);
            Add_Action (Table.States (636), 117, (196, 1), 37);
            Add_Action (Table.States (636), 118, (195, 6), 38);
            Table.States (636).Goto_List.Set_Capacity (28);
            Add_Goto (Table.States (636), 195, 176);
            Add_Goto (Table.States (636), 196, 148);
            Add_Goto (Table.States (636), 197, 54);
            Add_Goto (Table.States (636), 198, 55);
            Add_Goto (Table.States (636), 199, 56);
            Add_Goto (Table.States (636), 201, 57);
            Add_Goto (Table.States (636), 205, 177);
            Add_Goto (Table.States (636), 206, 178);
            Add_Goto (Table.States (636), 210, 179);
            Add_Goto (Table.States (636), 211, 180);
            Add_Goto (Table.States (636), 213, 181);
            Add_Goto (Table.States (636), 214, 182);
            Add_Goto (Table.States (636), 215, 183);
            Add_Goto (Table.States (636), 218, 184);
            Add_Goto (Table.States (636), 219, 185);
            Add_Goto (Table.States (636), 220, 186);
            Add_Goto (Table.States (636), 231, 980);
            Add_Goto (Table.States (636), 232, 190);
            Add_Goto (Table.States (636), 233, 191);
            Add_Goto (Table.States (636), 234, 192);
            Add_Goto (Table.States (636), 237, 193);
            Add_Goto (Table.States (636), 251, 58);
            Add_Goto (Table.States (636), 252, 59);
            Add_Goto (Table.States (636), 255, 60);
            Add_Goto (Table.States (636), 256, 194);
            Add_Goto (Table.States (636), 268, 68);
            Add_Goto (Table.States (636), 311, 83);
            Add_Goto (Table.States (636), 465, 196);
            Table.States (636).Kernel := To_Vector ((((153, 0),  72,  5, (32767, 0),  0), ((153, 1),  72,  1, (32767,
            0),  0)));
            Table.States (636).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (637).Action_List.Set_Capacity (13);
            Add_Action (Table.States (637), 44, (233, 2), 167);
            Add_Action (Table.States (637), 52, (233, 3), 168);
            Add_Action (Table.States (637), 65, (234, 1), 169);
            Add_Action (Table.States (637), 76, (256, 0), 170);
            Add_Action (Table.States (637), 85, (205, 4), 171);
            Add_Action (Table.States (637), 86, (213, 2), 172);
            Add_Action (Table.States (637), 90, (268, 0), 34);
            Add_Action (Table.States (637), 106, (237, 1), 173);
            Add_Action (Table.States (637), 107, (237, 0), 174);
            Add_Action (Table.States (637), 115, (234, 0), 175);
            Add_Action (Table.States (637), 116, (196, 0), 146);
            Add_Action (Table.States (637), 117, (196, 1), 37);
            Add_Action (Table.States (637), 118, (195, 6), 38);
            Table.States (637).Goto_List.Set_Capacity (30);
            Add_Goto (Table.States (637), 140, 981);
            Add_Goto (Table.States (637), 195, 673);
            Add_Goto (Table.States (637), 196, 148);
            Add_Goto (Table.States (637), 197, 54);
            Add_Goto (Table.States (637), 198, 55);
            Add_Goto (Table.States (637), 199, 56);
            Add_Goto (Table.States (637), 201, 57);
            Add_Goto (Table.States (637), 203, 369);
            Add_Goto (Table.States (637), 205, 177);
            Add_Goto (Table.States (637), 206, 178);
            Add_Goto (Table.States (637), 210, 179);
            Add_Goto (Table.States (637), 211, 180);
            Add_Goto (Table.States (637), 213, 181);
            Add_Goto (Table.States (637), 214, 182);
            Add_Goto (Table.States (637), 215, 183);
            Add_Goto (Table.States (637), 218, 184);
            Add_Goto (Table.States (637), 219, 185);
            Add_Goto (Table.States (637), 220, 186);
            Add_Goto (Table.States (637), 231, 696);
            Add_Goto (Table.States (637), 232, 190);
            Add_Goto (Table.States (637), 233, 191);
            Add_Goto (Table.States (637), 234, 192);
            Add_Goto (Table.States (637), 237, 193);
            Add_Goto (Table.States (637), 251, 58);
            Add_Goto (Table.States (637), 252, 59);
            Add_Goto (Table.States (637), 255, 60);
            Add_Goto (Table.States (637), 256, 194);
            Add_Goto (Table.States (637), 268, 68);
            Add_Goto (Table.States (637), 311, 83);
            Add_Goto (Table.States (637), 465, 196);
            Table.States (637).Kernel := To_Vector ((0 => ((139, 0),  74,  3, (32767, 0),  0)));
            Table.States (637).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (638).Action_List.Set_Capacity (8);
            Add_Action (Table.States (638), 56, (202, 1), 548);
            Add_Action (Table.States (638), 71, (202, 2), 549);
            Add_Action (Table.States (638), 72, (202, 3), 550);
            Add_Action (Table.States (638), 73, (202, 4), 551);
            Add_Action (Table.States (638), 74, (204, 0), 982);
            Add_Action (Table.States (638), 85, (205, 4), 171);
            Add_Action (Table.States (638), 86, (213, 2), 552);
            Add_Action (Table.States (638), 116, (202, 0), 553);
            Table.States (638).Goto_List.Set_Capacity (12);
            Add_Goto (Table.States (638), 202, 554);
            Add_Goto (Table.States (638), 204, 983);
            Add_Goto (Table.States (638), 205, 555);
            Add_Goto (Table.States (638), 206, 178);
            Add_Goto (Table.States (638), 210, 179);
            Add_Goto (Table.States (638), 211, 180);
            Add_Goto (Table.States (638), 213, 181);
            Add_Goto (Table.States (638), 214, 182);
            Add_Goto (Table.States (638), 215, 183);
            Add_Goto (Table.States (638), 218, 184);
            Add_Goto (Table.States (638), 219, 185);
            Add_Goto (Table.States (638), 220, 186);
            Table.States (638).Kernel := To_Vector ((((201, 0),  121,  1, (32767, 0),  0), ((203, 0),  121,  1, (32767,
            0),  0), ((255, 0),  121,  2, (32767, 0),  0)));
            Table.States (639).Action_List.Set_Capacity (15);
            Add_Action (Table.States (639), (33, 36, 45, 48, 50, 61, 63, 69, 75, 87, 91, 94, 95, 99, 108), (131, 2),
            2);
            Table.States (639).Kernel := To_Vector ((0 => ((131, 2),  132,  0, (131, 2),  2)));
            Table.States (639).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (131, 2),  2)));
            Table.States (640).Action_List.Set_Capacity (15);
            Add_Action (Table.States (640), (33, 36, 45, 48, 50, 61, 63, 69, 75, 87, 91, 94, 95, 99, 108), (132, 0),
            1);
            Table.States (640).Kernel := To_Vector ((0 => ((132, 0),  133,  0, (132, 0),  1)));
            Table.States (640).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (132, 0),  1)));
            Table.States (641).Action_List.Set_Capacity (15);
            Add_Action (Table.States (641), (33, 36, 45, 48, 50, 61, 63, 69, 75, 87, 91, 94, 95, 99, 108), (133, 0),
            1);
            Table.States (641).Kernel := To_Vector ((0 => ((133, 0),  139,  0, (133, 0),  1)));
            Table.States (641).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (133, 0),  1)));
            Table.States (642).Action_List.Set_Capacity (15);
            Add_Action (Table.States (642), (33, 36, 45, 48, 50, 61, 63, 69, 75, 87, 91, 94, 95, 99, 108), (133, 1),
            1);
            Table.States (642).Kernel := To_Vector ((0 => ((133, 1),  153,  0, (133, 1),  1)));
            Table.States (642).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (133, 1),  1)));
            Table.States (643).Action_List.Set_Capacity (15);
            Add_Action (Table.States (643), (33, 36, 45, 48, 50, 61, 63, 69, 75, 87, 91, 94, 95, 99, 108), (132, 1),
            1);
            Table.States (643).Kernel := To_Vector ((0 => ((132, 1),  162,  0, (132, 1),  1)));
            Table.States (643).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (132, 1),  1)));
            Table.States (644).Action_List.Set_Capacity (15);
            Add_Action (Table.States (644), (33, 36, 45, 48, 50, 61, 63, 69, 75, 87, 91, 94, 95, 99, 108), (133, 2),
            1);
            Table.States (644).Kernel := To_Vector ((0 => ((133, 2),  453,  0, (133, 2),  1)));
            Table.States (644).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (133, 2),  1)));
            Table.States (645).Action_List.Set_Capacity (47);
            Add_Action (Table.States (645), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (206, 0),  3);
            Table.States (645).Kernel := To_Vector ((0 => ((206, 0),  87,  0, (206, 0),  3)));
            Table.States (645).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (206, 0),  3)));
            Table.States (646).Action_List.Set_Capacity (4);
            Add_Action (Table.States (646), 62, (200, 2), 531);
            Add_Action (Table.States (646), 116, (196, 0), 146);
            Add_Action (Table.States (646), 117, (196, 1), 37);
            Add_Action (Table.States (646), 118, (200, 1), 545);
            Table.States (646).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (646), 196, 546);
            Add_Goto (Table.States (646), 200, 984);
            Table.States (646).Kernel := To_Vector ((0 => ((209, 1),  91,  1, (32767, 0),  0)));
            Table.States (646).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (647).Action_List.Set_Capacity (2);
            Add_Action (Table.States (647), (87, 95), (208, 0),  2);
            Table.States (647).Kernel := To_Vector ((0 => ((208, 0),  314,  0, (208, 0),  2)));
            Table.States (647).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (208, 0),  2)));
            Table.States (648).Action_List.Set_Capacity (47);
            Add_Action (Table.States (648), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (213, 0),  3);
            Table.States (648).Kernel := To_Vector ((0 => ((213, 0),  87,  0, (213, 0),  3)));
            Table.States (648).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (213, 0),  3)));
            Table.States (649).Action_List.Set_Capacity (15);
            Add_Action (Table.States (649), 12, (402, 0), 165);
            Add_Action (Table.States (649), 44, (233, 2), 167);
            Add_Action (Table.States (649), 52, (233, 3), 168);
            Add_Action (Table.States (649), 62, (213, 1), 985);
            Add_Action (Table.States (649), 65, (234, 1), 169);
            Add_Action (Table.States (649), 76, (256, 0), 170);
            Add_Action (Table.States (649), 85, (205, 4), 171);
            Add_Action (Table.States (649), 86, (213, 2), 172);
            Add_Action (Table.States (649), 90, (268, 0), 34);
            Add_Action (Table.States (649), 106, (237, 1), 173);
            Add_Action (Table.States (649), 107, (237, 0), 174);
            Add_Action (Table.States (649), 115, (234, 0), 175);
            Add_Action (Table.States (649), 116, (196, 0), 146);
            Add_Action (Table.States (649), 117, (196, 1), 37);
            Add_Action (Table.States (649), 118, (195, 6), 38);
            Table.States (649).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (649), 195, 176);
            Add_Goto (Table.States (649), 196, 148);
            Add_Goto (Table.States (649), 197, 54);
            Add_Goto (Table.States (649), 198, 55);
            Add_Goto (Table.States (649), 199, 56);
            Add_Goto (Table.States (649), 201, 57);
            Add_Goto (Table.States (649), 205, 177);
            Add_Goto (Table.States (649), 206, 178);
            Add_Goto (Table.States (649), 210, 179);
            Add_Goto (Table.States (649), 211, 180);
            Add_Goto (Table.States (649), 213, 181);
            Add_Goto (Table.States (649), 214, 182);
            Add_Goto (Table.States (649), 215, 183);
            Add_Goto (Table.States (649), 218, 184);
            Add_Goto (Table.States (649), 219, 185);
            Add_Goto (Table.States (649), 220, 186);
            Add_Goto (Table.States (649), 227, 986);
            Add_Goto (Table.States (649), 228, 188);
            Add_Goto (Table.States (649), 231, 189);
            Add_Goto (Table.States (649), 232, 190);
            Add_Goto (Table.States (649), 233, 191);
            Add_Goto (Table.States (649), 234, 192);
            Add_Goto (Table.States (649), 237, 193);
            Add_Goto (Table.States (649), 251, 58);
            Add_Goto (Table.States (649), 252, 59);
            Add_Goto (Table.States (649), 255, 60);
            Add_Goto (Table.States (649), 256, 194);
            Add_Goto (Table.States (649), 268, 68);
            Add_Goto (Table.States (649), 311, 83);
            Add_Goto (Table.States (649), 402, 195);
            Add_Goto (Table.States (649), 465, 196);
            Table.States (649).Kernel := To_Vector ((((212, 1),  95,  1, (32767, 0),  0), ((213, 1),  95,  4, (32767,
            0),  0)));
            Table.States (649).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (213, 1),  62, 985)));
            Table.States (650).Action_List.Set_Capacity (47);
            Add_Action (Table.States (650), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (215, 0),  3);
            Table.States (650).Kernel := To_Vector ((0 => ((215, 0),  87,  0, (215, 0),  3)));
            Table.States (650).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (215, 0),  3)));
            Table.States (651).Action_List.Set_Capacity (16);
            Add_Action (Table.States (651), 12, (402, 0), 165);
            Add_Action (Table.States (651), 44, (233, 2), 167);
            Add_Action (Table.States (651), 51, (221, 0), 273);
            Add_Action (Table.States (651), 52, (187, 0), 356);
            Add_Action (Table.States (651), 62, (178, 3), 385);
            Add_Action (Table.States (651), 65, (234, 1), 169);
            Add_Action (Table.States (651), 76, (256, 0), 170);
            Add_Action (Table.States (651), 85, (205, 4), 171);
            Add_Action (Table.States (651), 86, (213, 2), 172);
            Add_Action (Table.States (651), 90, (268, 0), 34);
            Add_Action (Table.States (651), 106, (237, 1), 173);
            Add_Action (Table.States (651), 107, (237, 0), 174);
            Add_Action (Table.States (651), 115, (234, 0), 175);
            Add_Action (Table.States (651), 116, (196, 0), 146);
            Add_Action (Table.States (651), 117, (196, 1), 37);
            Add_Action (Table.States (651), 118, (195, 6), 38);
            Table.States (651).Goto_List.Set_Capacity (40);
            Add_Goto (Table.States (651), 131, 361);
            Add_Goto (Table.States (651), 140, 362);
            Add_Goto (Table.States (651), 177, 363);
            Add_Goto (Table.States (651), 178, 364);
            Add_Goto (Table.States (651), 187, 365);
            Add_Goto (Table.States (651), 195, 366);
            Add_Goto (Table.States (651), 196, 148);
            Add_Goto (Table.States (651), 197, 54);
            Add_Goto (Table.States (651), 198, 55);
            Add_Goto (Table.States (651), 199, 56);
            Add_Goto (Table.States (651), 201, 57);
            Add_Goto (Table.States (651), 203, 369);
            Add_Goto (Table.States (651), 205, 177);
            Add_Goto (Table.States (651), 206, 178);
            Add_Goto (Table.States (651), 210, 179);
            Add_Goto (Table.States (651), 211, 180);
            Add_Goto (Table.States (651), 213, 181);
            Add_Goto (Table.States (651), 214, 182);
            Add_Goto (Table.States (651), 215, 183);
            Add_Goto (Table.States (651), 216, 987);
            Add_Goto (Table.States (651), 217, 988);
            Add_Goto (Table.States (651), 218, 184);
            Add_Goto (Table.States (651), 219, 185);
            Add_Goto (Table.States (651), 220, 186);
            Add_Goto (Table.States (651), 221, 376);
            Add_Goto (Table.States (651), 227, 975);
            Add_Goto (Table.States (651), 228, 188);
            Add_Goto (Table.States (651), 231, 378);
            Add_Goto (Table.States (651), 232, 190);
            Add_Goto (Table.States (651), 233, 191);
            Add_Goto (Table.States (651), 234, 192);
            Add_Goto (Table.States (651), 237, 193);
            Add_Goto (Table.States (651), 251, 58);
            Add_Goto (Table.States (651), 252, 59);
            Add_Goto (Table.States (651), 255, 60);
            Add_Goto (Table.States (651), 256, 194);
            Add_Goto (Table.States (651), 268, 68);
            Add_Goto (Table.States (651), 311, 83);
            Add_Goto (Table.States (651), 402, 195);
            Add_Goto (Table.States (651), 465, 196);
            Table.States (651).Kernel := To_Vector ((((216, 1),  95,  3, (32767, 0),  0), ((216, 2),  95,  3, (32767,
            0),  0)));
            Table.States (652).Action_List.Set_Capacity (16);
            Add_Action (Table.States (652), 12, (402, 0), 165);
            Add_Action (Table.States (652), 44, (233, 2), 167);
            Add_Action (Table.States (652), 52, (233, 3), 168);
            Add_Action (Table.States (652), 62, (200, 2), 531);
            Add_Action (Table.States (652), 65, (207, 1), 359);
            Add_Action (Table.States (652), 71, (219, 0), 989);
            Add_Action (Table.States (652), 76, (256, 0), 170);
            Add_Action (Table.States (652), 85, (205, 4), 171);
            Add_Action (Table.States (652), 86, (213, 2), 172);
            Add_Action (Table.States (652), 90, (268, 0), 34);
            Add_Action (Table.States (652), 106, (237, 1), 173);
            Add_Action (Table.States (652), 107, (237, 0), 174);
            Add_Action (Table.States (652), 115, (234, 0), 175);
            Add_Action (Table.States (652), 116, (196, 0), 146);
            Add_Action (Table.States (652), 117, (196, 1), 37);
            Add_Action (Table.States (652), 118, (195, 6), 360);
            Table.States (652).Goto_List.Set_Capacity (36);
            Add_Goto (Table.States (652), 195, 176);
            Add_Goto (Table.States (652), 196, 367);
            Add_Goto (Table.States (652), 197, 54);
            Add_Goto (Table.States (652), 198, 55);
            Add_Goto (Table.States (652), 199, 56);
            Add_Goto (Table.States (652), 200, 368);
            Add_Goto (Table.States (652), 201, 57);
            Add_Goto (Table.States (652), 205, 177);
            Add_Goto (Table.States (652), 206, 178);
            Add_Goto (Table.States (652), 207, 990);
            Add_Goto (Table.States (652), 208, 371);
            Add_Goto (Table.States (652), 209, 372);
            Add_Goto (Table.States (652), 210, 179);
            Add_Goto (Table.States (652), 211, 180);
            Add_Goto (Table.States (652), 213, 181);
            Add_Goto (Table.States (652), 214, 182);
            Add_Goto (Table.States (652), 215, 183);
            Add_Goto (Table.States (652), 218, 184);
            Add_Goto (Table.States (652), 219, 185);
            Add_Goto (Table.States (652), 220, 186);
            Add_Goto (Table.States (652), 227, 991);
            Add_Goto (Table.States (652), 228, 188);
            Add_Goto (Table.States (652), 231, 189);
            Add_Goto (Table.States (652), 232, 190);
            Add_Goto (Table.States (652), 233, 191);
            Add_Goto (Table.States (652), 234, 192);
            Add_Goto (Table.States (652), 237, 193);
            Add_Goto (Table.States (652), 251, 58);
            Add_Goto (Table.States (652), 252, 59);
            Add_Goto (Table.States (652), 255, 60);
            Add_Goto (Table.States (652), 256, 194);
            Add_Goto (Table.States (652), 268, 68);
            Add_Goto (Table.States (652), 311, 83);
            Add_Goto (Table.States (652), 402, 195);
            Add_Goto (Table.States (652), 459, 384);
            Add_Goto (Table.States (652), 465, 196);
            Table.States (652).Kernel := To_Vector ((((210, 0),  61,  3, (32767, 0),  0), ((219, 0),  61,  4, (32767,
            0),  0), ((220, 0),  61,  5, (32767, 0),  0)));
            Table.States (652).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (207, 1),  65, 359)));
         end Subr_26;
         procedure Subr_27
         is begin
            Table.States (653).Action_List.Set_Capacity (13);
            Add_Action (Table.States (653), 44, (233, 2), 167);
            Add_Action (Table.States (653), 52, (233, 3), 168);
            Add_Action (Table.States (653), 65, (234, 1), 169);
            Add_Action (Table.States (653), 76, (256, 0), 170);
            Add_Action (Table.States (653), 85, (205, 4), 171);
            Add_Action (Table.States (653), 86, (213, 2), 172);
            Add_Action (Table.States (653), 90, (268, 0), 34);
            Add_Action (Table.States (653), 106, (237, 1), 173);
            Add_Action (Table.States (653), 107, (237, 0), 174);
            Add_Action (Table.States (653), 115, (234, 0), 175);
            Add_Action (Table.States (653), 116, (196, 0), 146);
            Add_Action (Table.States (653), 117, (196, 1), 37);
            Add_Action (Table.States (653), 118, (195, 6), 38);
            Table.States (653).Goto_List.Set_Capacity (28);
            Add_Goto (Table.States (653), 195, 176);
            Add_Goto (Table.States (653), 196, 148);
            Add_Goto (Table.States (653), 197, 54);
            Add_Goto (Table.States (653), 198, 55);
            Add_Goto (Table.States (653), 199, 56);
            Add_Goto (Table.States (653), 201, 57);
            Add_Goto (Table.States (653), 205, 177);
            Add_Goto (Table.States (653), 206, 178);
            Add_Goto (Table.States (653), 210, 179);
            Add_Goto (Table.States (653), 211, 180);
            Add_Goto (Table.States (653), 213, 181);
            Add_Goto (Table.States (653), 214, 182);
            Add_Goto (Table.States (653), 215, 183);
            Add_Goto (Table.States (653), 218, 184);
            Add_Goto (Table.States (653), 219, 185);
            Add_Goto (Table.States (653), 220, 186);
            Add_Goto (Table.States (653), 231, 992);
            Add_Goto (Table.States (653), 232, 190);
            Add_Goto (Table.States (653), 233, 191);
            Add_Goto (Table.States (653), 234, 192);
            Add_Goto (Table.States (653), 237, 193);
            Add_Goto (Table.States (653), 251, 58);
            Add_Goto (Table.States (653), 252, 59);
            Add_Goto (Table.States (653), 255, 60);
            Add_Goto (Table.States (653), 256, 194);
            Add_Goto (Table.States (653), 268, 68);
            Add_Goto (Table.States (653), 311, 83);
            Add_Goto (Table.States (653), 465, 196);
            Table.States (653).Kernel := To_Vector ((0 => ((140, 1),  97,  1, (32767, 0),  0)));
            Table.States (653).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (654).Action_List.Set_Capacity (47);
            Add_Action (Table.States (654), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (205, 4),  3);
            Table.States (654).Kernel := To_Vector ((0 => ((205, 4),  87,  0, (205, 4),  3)));
            Table.States (654).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (205, 4),  3)));
            Table.States (655).Action_List.Set_Capacity (47);
            Add_Action (Table.States (655), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (205, 5),  3);
            Table.States (655).Kernel := To_Vector ((0 => ((205, 5),  87,  0, (205, 5),  3)));
            Table.States (655).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (205, 5),  3)));
            Table.States (656).Action_List.Set_Capacity (47);
            Add_Action (Table.States (656), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (205, 6),  3);
            Table.States (656).Kernel := To_Vector ((0 => ((205, 6),  87,  0, (205, 6),  3)));
            Table.States (656).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (205, 6),  3)));
            Table.States (657).Action_List.Set_Capacity (15);
            Add_Action (Table.States (657), 12, (402, 0), 165);
            Add_Action (Table.States (657), 44, (233, 2), 167);
            Add_Action (Table.States (657), 52, (233, 3), 168);
            Add_Action (Table.States (657), 62, (200, 2), 531);
            Add_Action (Table.States (657), 65, (234, 1), 169);
            Add_Action (Table.States (657), 76, (256, 0), 170);
            Add_Action (Table.States (657), 85, (205, 4), 171);
            Add_Action (Table.States (657), 86, (213, 2), 172);
            Add_Action (Table.States (657), 90, (268, 0), 34);
            Add_Action (Table.States (657), 106, (237, 1), 173);
            Add_Action (Table.States (657), 107, (237, 0), 174);
            Add_Action (Table.States (657), 115, (234, 0), 175);
            Add_Action (Table.States (657), 116, (196, 0), 146);
            Add_Action (Table.States (657), 117, (196, 1), 37);
            Add_Action (Table.States (657), 118, (195, 6), 360);
            Table.States (657).Goto_List.Set_Capacity (35);
            Add_Goto (Table.States (657), 195, 176);
            Add_Goto (Table.States (657), 196, 367);
            Add_Goto (Table.States (657), 197, 54);
            Add_Goto (Table.States (657), 198, 55);
            Add_Goto (Table.States (657), 199, 56);
            Add_Goto (Table.States (657), 200, 368);
            Add_Goto (Table.States (657), 201, 57);
            Add_Goto (Table.States (657), 205, 177);
            Add_Goto (Table.States (657), 206, 178);
            Add_Goto (Table.States (657), 208, 993);
            Add_Goto (Table.States (657), 209, 372);
            Add_Goto (Table.States (657), 210, 179);
            Add_Goto (Table.States (657), 211, 180);
            Add_Goto (Table.States (657), 213, 181);
            Add_Goto (Table.States (657), 214, 182);
            Add_Goto (Table.States (657), 215, 183);
            Add_Goto (Table.States (657), 218, 184);
            Add_Goto (Table.States (657), 219, 185);
            Add_Goto (Table.States (657), 220, 186);
            Add_Goto (Table.States (657), 227, 991);
            Add_Goto (Table.States (657), 228, 188);
            Add_Goto (Table.States (657), 231, 189);
            Add_Goto (Table.States (657), 232, 190);
            Add_Goto (Table.States (657), 233, 191);
            Add_Goto (Table.States (657), 234, 192);
            Add_Goto (Table.States (657), 237, 193);
            Add_Goto (Table.States (657), 251, 58);
            Add_Goto (Table.States (657), 252, 59);
            Add_Goto (Table.States (657), 255, 60);
            Add_Goto (Table.States (657), 256, 194);
            Add_Goto (Table.States (657), 268, 68);
            Add_Goto (Table.States (657), 311, 83);
            Add_Goto (Table.States (657), 402, 195);
            Add_Goto (Table.States (657), 459, 994);
            Add_Goto (Table.States (657), 465, 196);
            Table.States (657).Kernel := To_Vector ((((459, 1),  95,  1, (32767, 0),  0), ((459, 2),  95,  3, (32767,
            0),  0)));
            Table.States (658).Action_List.Set_Capacity (47);
            Add_Action (Table.States (658), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (213, 3),  3);
            Table.States (658).Kernel := To_Vector ((0 => ((213, 3),  88,  0, (213, 3),  3)));
            Table.States (658).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (213, 3),  3)));
            Table.States (659).Action_List.Set_Capacity (15);
            Add_Action (Table.States (659), 12, (402, 0), 165);
            Add_Action (Table.States (659), 44, (233, 2), 167);
            Add_Action (Table.States (659), 52, (233, 3), 168);
            Add_Action (Table.States (659), 62, (213, 2), 995);
            Add_Action (Table.States (659), 65, (234, 1), 169);
            Add_Action (Table.States (659), 76, (256, 0), 170);
            Add_Action (Table.States (659), 85, (205, 4), 171);
            Add_Action (Table.States (659), 86, (213, 2), 172);
            Add_Action (Table.States (659), 90, (268, 0), 34);
            Add_Action (Table.States (659), 106, (237, 1), 173);
            Add_Action (Table.States (659), 107, (237, 0), 174);
            Add_Action (Table.States (659), 115, (234, 0), 175);
            Add_Action (Table.States (659), 116, (196, 0), 146);
            Add_Action (Table.States (659), 117, (196, 1), 37);
            Add_Action (Table.States (659), 118, (195, 6), 38);
            Table.States (659).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (659), 195, 176);
            Add_Goto (Table.States (659), 196, 148);
            Add_Goto (Table.States (659), 197, 54);
            Add_Goto (Table.States (659), 198, 55);
            Add_Goto (Table.States (659), 199, 56);
            Add_Goto (Table.States (659), 201, 57);
            Add_Goto (Table.States (659), 205, 177);
            Add_Goto (Table.States (659), 206, 178);
            Add_Goto (Table.States (659), 210, 179);
            Add_Goto (Table.States (659), 211, 180);
            Add_Goto (Table.States (659), 213, 181);
            Add_Goto (Table.States (659), 214, 182);
            Add_Goto (Table.States (659), 215, 183);
            Add_Goto (Table.States (659), 218, 184);
            Add_Goto (Table.States (659), 219, 185);
            Add_Goto (Table.States (659), 220, 186);
            Add_Goto (Table.States (659), 227, 986);
            Add_Goto (Table.States (659), 228, 188);
            Add_Goto (Table.States (659), 231, 189);
            Add_Goto (Table.States (659), 232, 190);
            Add_Goto (Table.States (659), 233, 191);
            Add_Goto (Table.States (659), 234, 192);
            Add_Goto (Table.States (659), 237, 193);
            Add_Goto (Table.States (659), 251, 58);
            Add_Goto (Table.States (659), 252, 59);
            Add_Goto (Table.States (659), 255, 60);
            Add_Goto (Table.States (659), 256, 194);
            Add_Goto (Table.States (659), 268, 68);
            Add_Goto (Table.States (659), 311, 83);
            Add_Goto (Table.States (659), 402, 195);
            Add_Goto (Table.States (659), 465, 196);
            Table.States (659).Kernel := To_Vector ((((212, 1),  95,  1, (32767, 0),  0), ((213, 2),  95,  4, (32767,
            0),  0)));
            Table.States (659).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (213, 2),  62, 995)));
            Table.States (660).Action_List.Set_Capacity (47);
            Add_Action (Table.States (660), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (215, 1),  3);
            Table.States (660).Kernel := To_Vector ((0 => ((215, 1),  88,  0, (215, 1),  3)));
            Table.States (660).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (215, 1),  3)));
            Table.States (661).Action_List.Set_Capacity (1);
            Add_Action (Table.States (661), 71, (220, 1), 996);
            Table.States (661).Kernel := To_Vector ((0 => ((220, 1),  61,  5, (32767, 0),  0)));
            Table.States (661).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (220, 1),  71, 996)));
            Table.States (662).Action_List.Set_Capacity (18);
            Add_Action (Table.States (662), (33, 36, 42, 46, 47, 49, 50, 61, 63, 72, 74, 82, 87, 88, 91, 95, 99, 108),
            (226, 0),  2);
            Table.States (662).Kernel := To_Vector ((0 => ((226, 0),  228,  0, (226, 0),  2)));
            Table.States (662).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (226, 0),  2)));
            Table.States (663).Action_List.Set_Capacity (14);
            Add_Action (Table.States (663), 12, (402, 0), 165);
            Add_Action (Table.States (663), 44, (233, 2), 167);
            Add_Action (Table.States (663), 52, (233, 3), 168);
            Add_Action (Table.States (663), 65, (234, 1), 169);
            Add_Action (Table.States (663), 76, (256, 0), 170);
            Add_Action (Table.States (663), 85, (205, 4), 171);
            Add_Action (Table.States (663), 86, (213, 2), 172);
            Add_Action (Table.States (663), 90, (268, 0), 34);
            Add_Action (Table.States (663), 106, (237, 1), 173);
            Add_Action (Table.States (663), 107, (237, 0), 174);
            Add_Action (Table.States (663), 115, (234, 0), 175);
            Add_Action (Table.States (663), 116, (196, 0), 146);
            Add_Action (Table.States (663), 117, (196, 1), 37);
            Add_Action (Table.States (663), 118, (195, 6), 38);
            Table.States (663).Goto_List.Set_Capacity (30);
            Add_Goto (Table.States (663), 195, 176);
            Add_Goto (Table.States (663), 196, 148);
            Add_Goto (Table.States (663), 197, 54);
            Add_Goto (Table.States (663), 198, 55);
            Add_Goto (Table.States (663), 199, 56);
            Add_Goto (Table.States (663), 201, 57);
            Add_Goto (Table.States (663), 205, 177);
            Add_Goto (Table.States (663), 206, 178);
            Add_Goto (Table.States (663), 210, 179);
            Add_Goto (Table.States (663), 211, 180);
            Add_Goto (Table.States (663), 213, 181);
            Add_Goto (Table.States (663), 214, 182);
            Add_Goto (Table.States (663), 215, 183);
            Add_Goto (Table.States (663), 218, 184);
            Add_Goto (Table.States (663), 219, 185);
            Add_Goto (Table.States (663), 220, 186);
            Add_Goto (Table.States (663), 228, 997);
            Add_Goto (Table.States (663), 231, 189);
            Add_Goto (Table.States (663), 232, 190);
            Add_Goto (Table.States (663), 233, 191);
            Add_Goto (Table.States (663), 234, 192);
            Add_Goto (Table.States (663), 237, 193);
            Add_Goto (Table.States (663), 251, 58);
            Add_Goto (Table.States (663), 252, 59);
            Add_Goto (Table.States (663), 255, 60);
            Add_Goto (Table.States (663), 256, 194);
            Add_Goto (Table.States (663), 268, 68);
            Add_Goto (Table.States (663), 311, 83);
            Add_Goto (Table.States (663), 402, 195);
            Add_Goto (Table.States (663), 465, 196);
            Table.States (663).Kernel := To_Vector ((0 => ((225, 0),  47,  1, (32767, 0),  0)));
            Table.States (663).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (664).Action_List.Set_Capacity (18);
            Add_Action (Table.States (664), (33, 36, 42, 47, 48, 49, 50, 61, 63, 72, 74, 82, 87, 88, 91, 95, 99, 108),
            (224, 0),  2);
            Table.States (664).Kernel := To_Vector ((0 => ((224, 0),  228,  0, (224, 0),  2)));
            Table.States (664).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (224, 0),  2)));
            Table.States (665).Action_List.Set_Capacity (14);
            Add_Action (Table.States (665), 12, (402, 0), 165);
            Add_Action (Table.States (665), 44, (233, 2), 167);
            Add_Action (Table.States (665), 52, (233, 3), 168);
            Add_Action (Table.States (665), 65, (234, 1), 169);
            Add_Action (Table.States (665), 76, (256, 0), 170);
            Add_Action (Table.States (665), 85, (205, 4), 171);
            Add_Action (Table.States (665), 86, (213, 2), 172);
            Add_Action (Table.States (665), 90, (268, 0), 34);
            Add_Action (Table.States (665), 106, (237, 1), 173);
            Add_Action (Table.States (665), 107, (237, 0), 174);
            Add_Action (Table.States (665), 115, (234, 0), 175);
            Add_Action (Table.States (665), 116, (196, 0), 146);
            Add_Action (Table.States (665), 117, (196, 1), 37);
            Add_Action (Table.States (665), 118, (195, 6), 38);
            Table.States (665).Goto_List.Set_Capacity (30);
            Add_Goto (Table.States (665), 195, 176);
            Add_Goto (Table.States (665), 196, 148);
            Add_Goto (Table.States (665), 197, 54);
            Add_Goto (Table.States (665), 198, 55);
            Add_Goto (Table.States (665), 199, 56);
            Add_Goto (Table.States (665), 201, 57);
            Add_Goto (Table.States (665), 205, 177);
            Add_Goto (Table.States (665), 206, 178);
            Add_Goto (Table.States (665), 210, 179);
            Add_Goto (Table.States (665), 211, 180);
            Add_Goto (Table.States (665), 213, 181);
            Add_Goto (Table.States (665), 214, 182);
            Add_Goto (Table.States (665), 215, 183);
            Add_Goto (Table.States (665), 218, 184);
            Add_Goto (Table.States (665), 219, 185);
            Add_Goto (Table.States (665), 220, 186);
            Add_Goto (Table.States (665), 228, 998);
            Add_Goto (Table.States (665), 231, 189);
            Add_Goto (Table.States (665), 232, 190);
            Add_Goto (Table.States (665), 233, 191);
            Add_Goto (Table.States (665), 234, 192);
            Add_Goto (Table.States (665), 237, 193);
            Add_Goto (Table.States (665), 251, 58);
            Add_Goto (Table.States (665), 252, 59);
            Add_Goto (Table.States (665), 255, 60);
            Add_Goto (Table.States (665), 256, 194);
            Add_Goto (Table.States (665), 268, 68);
            Add_Goto (Table.States (665), 311, 83);
            Add_Goto (Table.States (665), 402, 195);
            Add_Goto (Table.States (665), 465, 196);
            Table.States (665).Kernel := To_Vector ((0 => ((223, 0),  49,  1, (32767, 0),  0)));
            Table.States (665).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (666).Action_List.Set_Capacity (18);
            Add_Action (Table.States (666), (33, 36, 42, 47, 49, 50, 61, 63, 72, 74, 75, 82, 87, 88, 91, 95, 99, 108),
            (222, 0),  2);
            Table.States (666).Kernel := To_Vector ((0 => ((222, 0),  228,  0, (222, 0),  2)));
            Table.States (666).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (222, 0),  2)));
            Table.States (667).Action_List.Set_Capacity (14);
            Add_Action (Table.States (667), 12, (402, 0), 165);
            Add_Action (Table.States (667), 44, (233, 2), 167);
            Add_Action (Table.States (667), 52, (233, 3), 168);
            Add_Action (Table.States (667), 65, (234, 1), 169);
            Add_Action (Table.States (667), 76, (256, 0), 170);
            Add_Action (Table.States (667), 85, (205, 4), 171);
            Add_Action (Table.States (667), 86, (213, 2), 172);
            Add_Action (Table.States (667), 90, (268, 0), 34);
            Add_Action (Table.States (667), 106, (237, 1), 173);
            Add_Action (Table.States (667), 107, (237, 0), 174);
            Add_Action (Table.States (667), 115, (234, 0), 175);
            Add_Action (Table.States (667), 116, (196, 0), 146);
            Add_Action (Table.States (667), 117, (196, 1), 37);
            Add_Action (Table.States (667), 118, (195, 6), 38);
            Table.States (667).Goto_List.Set_Capacity (30);
            Add_Goto (Table.States (667), 195, 176);
            Add_Goto (Table.States (667), 196, 148);
            Add_Goto (Table.States (667), 197, 54);
            Add_Goto (Table.States (667), 198, 55);
            Add_Goto (Table.States (667), 199, 56);
            Add_Goto (Table.States (667), 201, 57);
            Add_Goto (Table.States (667), 205, 177);
            Add_Goto (Table.States (667), 206, 178);
            Add_Goto (Table.States (667), 210, 179);
            Add_Goto (Table.States (667), 211, 180);
            Add_Goto (Table.States (667), 213, 181);
            Add_Goto (Table.States (667), 214, 182);
            Add_Goto (Table.States (667), 215, 183);
            Add_Goto (Table.States (667), 218, 184);
            Add_Goto (Table.States (667), 219, 185);
            Add_Goto (Table.States (667), 220, 186);
            Add_Goto (Table.States (667), 228, 999);
            Add_Goto (Table.States (667), 231, 189);
            Add_Goto (Table.States (667), 232, 190);
            Add_Goto (Table.States (667), 233, 191);
            Add_Goto (Table.States (667), 234, 192);
            Add_Goto (Table.States (667), 237, 193);
            Add_Goto (Table.States (667), 251, 58);
            Add_Goto (Table.States (667), 252, 59);
            Add_Goto (Table.States (667), 255, 60);
            Add_Goto (Table.States (667), 256, 194);
            Add_Goto (Table.States (667), 268, 68);
            Add_Goto (Table.States (667), 311, 83);
            Add_Goto (Table.States (667), 402, 195);
            Add_Goto (Table.States (667), 465, 196);
            Table.States (667).Kernel := To_Vector ((0 => ((222, 1),  75,  1, (32767, 0),  0)));
            Table.States (667).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (668).Action_List.Set_Capacity (1);
            Add_Action (Table.States (668), 49, (223, 1), 1000);
            Table.States (668).Kernel := To_Vector ((0 => ((223, 1),  75,  2, (32767, 0),  0)));
            Table.States (668).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (223, 1),  49, 1000)));
            Table.States (669).Action_List.Set_Capacity (14);
            Add_Action (Table.States (669), 12, (402, 0), 165);
            Add_Action (Table.States (669), 44, (233, 2), 167);
            Add_Action (Table.States (669), 52, (233, 3), 168);
            Add_Action (Table.States (669), 65, (234, 1), 169);
            Add_Action (Table.States (669), 76, (256, 0), 170);
            Add_Action (Table.States (669), 85, (205, 4), 171);
            Add_Action (Table.States (669), 86, (213, 2), 172);
            Add_Action (Table.States (669), 90, (268, 0), 34);
            Add_Action (Table.States (669), 106, (237, 1), 173);
            Add_Action (Table.States (669), 107, (237, 0), 174);
            Add_Action (Table.States (669), 115, (234, 0), 175);
            Add_Action (Table.States (669), 116, (196, 0), 146);
            Add_Action (Table.States (669), 117, (196, 1), 37);
            Add_Action (Table.States (669), 118, (195, 6), 38);
            Table.States (669).Goto_List.Set_Capacity (30);
            Add_Goto (Table.States (669), 195, 176);
            Add_Goto (Table.States (669), 196, 148);
            Add_Goto (Table.States (669), 197, 54);
            Add_Goto (Table.States (669), 198, 55);
            Add_Goto (Table.States (669), 199, 56);
            Add_Goto (Table.States (669), 201, 57);
            Add_Goto (Table.States (669), 205, 177);
            Add_Goto (Table.States (669), 206, 178);
            Add_Goto (Table.States (669), 210, 179);
            Add_Goto (Table.States (669), 211, 180);
            Add_Goto (Table.States (669), 213, 181);
            Add_Goto (Table.States (669), 214, 182);
            Add_Goto (Table.States (669), 215, 183);
            Add_Goto (Table.States (669), 218, 184);
            Add_Goto (Table.States (669), 219, 185);
            Add_Goto (Table.States (669), 220, 186);
            Add_Goto (Table.States (669), 228, 1001);
            Add_Goto (Table.States (669), 231, 189);
            Add_Goto (Table.States (669), 232, 190);
            Add_Goto (Table.States (669), 233, 191);
            Add_Goto (Table.States (669), 234, 192);
            Add_Goto (Table.States (669), 237, 193);
            Add_Goto (Table.States (669), 251, 58);
            Add_Goto (Table.States (669), 252, 59);
            Add_Goto (Table.States (669), 255, 60);
            Add_Goto (Table.States (669), 256, 194);
            Add_Goto (Table.States (669), 268, 68);
            Add_Goto (Table.States (669), 311, 83);
            Add_Goto (Table.States (669), 402, 195);
            Add_Goto (Table.States (669), 465, 196);
            Table.States (669).Kernel := To_Vector ((0 => ((224, 1),  48,  1, (32767, 0),  0)));
            Table.States (669).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
         end Subr_27;
         procedure Subr_28
         is begin
            Table.States (670).Action_List.Set_Capacity (1);
            Add_Action (Table.States (670), 47, (225, 1), 1002);
            Table.States (670).Kernel := To_Vector ((0 => ((225, 1),  48,  2, (32767, 0),  0)));
            Table.States (670).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (225, 1),  47, 1002)));
            Table.States (671).Action_List.Set_Capacity (14);
            Add_Action (Table.States (671), 12, (402, 0), 165);
            Add_Action (Table.States (671), 44, (233, 2), 167);
            Add_Action (Table.States (671), 52, (233, 3), 168);
            Add_Action (Table.States (671), 65, (234, 1), 169);
            Add_Action (Table.States (671), 76, (256, 0), 170);
            Add_Action (Table.States (671), 85, (205, 4), 171);
            Add_Action (Table.States (671), 86, (213, 2), 172);
            Add_Action (Table.States (671), 90, (268, 0), 34);
            Add_Action (Table.States (671), 106, (237, 1), 173);
            Add_Action (Table.States (671), 107, (237, 0), 174);
            Add_Action (Table.States (671), 115, (234, 0), 175);
            Add_Action (Table.States (671), 116, (196, 0), 146);
            Add_Action (Table.States (671), 117, (196, 1), 37);
            Add_Action (Table.States (671), 118, (195, 6), 38);
            Table.States (671).Goto_List.Set_Capacity (30);
            Add_Goto (Table.States (671), 195, 176);
            Add_Goto (Table.States (671), 196, 148);
            Add_Goto (Table.States (671), 197, 54);
            Add_Goto (Table.States (671), 198, 55);
            Add_Goto (Table.States (671), 199, 56);
            Add_Goto (Table.States (671), 201, 57);
            Add_Goto (Table.States (671), 205, 177);
            Add_Goto (Table.States (671), 206, 178);
            Add_Goto (Table.States (671), 210, 179);
            Add_Goto (Table.States (671), 211, 180);
            Add_Goto (Table.States (671), 213, 181);
            Add_Goto (Table.States (671), 214, 182);
            Add_Goto (Table.States (671), 215, 183);
            Add_Goto (Table.States (671), 218, 184);
            Add_Goto (Table.States (671), 219, 185);
            Add_Goto (Table.States (671), 220, 186);
            Add_Goto (Table.States (671), 228, 1003);
            Add_Goto (Table.States (671), 231, 189);
            Add_Goto (Table.States (671), 232, 190);
            Add_Goto (Table.States (671), 233, 191);
            Add_Goto (Table.States (671), 234, 192);
            Add_Goto (Table.States (671), 237, 193);
            Add_Goto (Table.States (671), 251, 58);
            Add_Goto (Table.States (671), 252, 59);
            Add_Goto (Table.States (671), 255, 60);
            Add_Goto (Table.States (671), 256, 194);
            Add_Goto (Table.States (671), 268, 68);
            Add_Goto (Table.States (671), 311, 83);
            Add_Goto (Table.States (671), 402, 195);
            Add_Goto (Table.States (671), 465, 196);
            Table.States (671).Kernel := To_Vector ((0 => ((226, 1),  46,  1, (32767, 0),  0)));
            Table.States (671).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (672).Action_List.Set_Capacity (20);
            Add_Action (Table.States (672), (33, 36, 42, 46, 47, 48, 49, 50, 61, 63, 72, 74, 75, 82, 87, 88, 91, 95,
            99, 108), (230, 1),  1);
            Table.States (672).Kernel := To_Vector ((0 => ((230, 1),  140,  0, (230, 1),  1)));
            Table.States (672).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (230, 1),  1)));
            Table.States (673).Action_List.Set_Capacity (33);
            Add_Action (Table.States (673), 33, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 36, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 42, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 43, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 46, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 47, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 48, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 49, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 50, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 61, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 63, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 72, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 73, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 74, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 75, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 82, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 85, (198, 0), 281);
            Add_Action (Table.States (673), 87, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 88, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 89, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 91, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 95, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 96, (197, 0), 283);
            Add_Action (Table.States (673), 97, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 99, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 106, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 107, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 108, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 109, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 111, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 112, Reduce, (234, 3),  1);
            Add_Action (Table.States (673), 113, (121, 0), 285);
            Add_Action (Table.States (673), 114, (121, 1), 286);
            Table.States (673).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (673), 121, 638);
            Add_Goto (Table.States (673), 313, 289);
            Table.States (673).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((203, 0),  195,  2,
            (32767, 0),  0), ((234, 3),  195,  0, (234, 3),  1), ((255, 0),  195,  3, (32767, 0),  0), ((311, 0),  195,
             3, (32767, 0),  0)));
            Table.States (673).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (234, 3),  1)));
            Table.States (674).Action_List.Set_Capacity (20);
            Add_Action (Table.States (674), 33, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 36, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 42, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 46, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 47, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 48, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 49, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 50, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 61, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 63, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 72, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 74, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 75, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 82, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 87, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 88, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 91, (229, 1), 1004);
            Add_Conflict (Table.States (674), 91, (228, 3),  3);
            Add_Action (Table.States (674), 95, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 99, Reduce, (228, 3),  3);
            Add_Action (Table.States (674), 108, Reduce, (228, 3),  3);
            Table.States (674).Kernel := To_Vector ((((228, 3),  229,  0, (228, 3),  3), ((229, 1),  229,  2, (32767,
            0),  0), ((229, 2),  229,  2, (32767, 0),  0)));
            Table.States (674).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (228, 3),  3)));
            Table.States (675).Action_List.Set_Capacity (20);
            Add_Action (Table.States (675), (33, 36, 42, 46, 47, 48, 49, 50, 61, 63, 72, 74, 75, 82, 87, 88, 91, 95,
            99, 108), (229, 0),  1);
            Table.States (675).Kernel := To_Vector ((0 => ((229, 0),  230,  0, (229, 0),  1)));
            Table.States (675).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (229, 0),  1)));
            Table.States (676).Action_List.Set_Capacity (21);
            Add_Action (Table.States (676), 33, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 36, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 42, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 46, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 47, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 48, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 49, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 50, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 61, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 63, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 72, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 74, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 75, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 82, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 87, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 88, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 91, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 95, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 97, (140, 1), 653);
            Add_Action (Table.States (676), 99, Reduce, (230, 0),  1);
            Add_Action (Table.States (676), 108, Reduce, (230, 0),  1);
            Table.States (676).Kernel := To_Vector ((((140, 1),  231,  2, (32767, 0),  0), ((230, 0),  231,  0, (230,
            0),  1)));
            Table.States (676).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (230, 0),  1)));
            Table.States (677).Action_List.Set_Capacity (13);
            Add_Action (Table.States (677), 44, (233, 2), 167);
            Add_Action (Table.States (677), 52, (233, 3), 168);
            Add_Action (Table.States (677), 65, (234, 1), 169);
            Add_Action (Table.States (677), 76, (256, 0), 170);
            Add_Action (Table.States (677), 85, (205, 4), 171);
            Add_Action (Table.States (677), 86, (213, 2), 172);
            Add_Action (Table.States (677), 90, (268, 0), 34);
            Add_Action (Table.States (677), 106, (237, 1), 173);
            Add_Action (Table.States (677), 107, (237, 0), 174);
            Add_Action (Table.States (677), 115, (234, 0), 175);
            Add_Action (Table.States (677), 116, (196, 0), 146);
            Add_Action (Table.States (677), 117, (196, 1), 37);
            Add_Action (Table.States (677), 118, (195, 6), 38);
            Table.States (677).Goto_List.Set_Capacity (32);
            Add_Goto (Table.States (677), 140, 672);
            Add_Goto (Table.States (677), 195, 673);
            Add_Goto (Table.States (677), 196, 148);
            Add_Goto (Table.States (677), 197, 54);
            Add_Goto (Table.States (677), 198, 55);
            Add_Goto (Table.States (677), 199, 56);
            Add_Goto (Table.States (677), 201, 57);
            Add_Goto (Table.States (677), 203, 369);
            Add_Goto (Table.States (677), 205, 177);
            Add_Goto (Table.States (677), 206, 178);
            Add_Goto (Table.States (677), 210, 179);
            Add_Goto (Table.States (677), 211, 180);
            Add_Goto (Table.States (677), 213, 181);
            Add_Goto (Table.States (677), 214, 182);
            Add_Goto (Table.States (677), 215, 183);
            Add_Goto (Table.States (677), 218, 184);
            Add_Goto (Table.States (677), 219, 185);
            Add_Goto (Table.States (677), 220, 186);
            Add_Goto (Table.States (677), 229, 1005);
            Add_Goto (Table.States (677), 230, 675);
            Add_Goto (Table.States (677), 231, 676);
            Add_Goto (Table.States (677), 232, 190);
            Add_Goto (Table.States (677), 233, 191);
            Add_Goto (Table.States (677), 234, 192);
            Add_Goto (Table.States (677), 237, 193);
            Add_Goto (Table.States (677), 251, 58);
            Add_Goto (Table.States (677), 252, 59);
            Add_Goto (Table.States (677), 255, 60);
            Add_Goto (Table.States (677), 256, 194);
            Add_Goto (Table.States (677), 268, 68);
            Add_Goto (Table.States (677), 311, 83);
            Add_Goto (Table.States (677), 465, 196);
            Table.States (677).Kernel := To_Vector ((0 => ((228, 2),  45,  1, (32767, 0),  0)));
            Table.States (677).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (678).Action_List.Set_Capacity (20);
            Add_Action (Table.States (678), (33, 36, 42, 46, 47, 48, 49, 50, 61, 63, 72, 74, 75, 82, 87, 88, 91, 95,
            99, 108), (228, 0),  3);
            Table.States (678).Kernel := To_Vector ((0 => ((228, 0),  231,  0, (228, 0),  3)));
            Table.States (678).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (228, 0),  3)));
            Table.States (679).Action_List.Set_Capacity (38);
            Add_Action (Table.States (679), (33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 72, 73, 74, 75,
            82, 87, 88, 89, 91, 94, 95, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110, 111), (232, 2),  3);
            Table.States (679).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (679), 238, 413);
            Table.States (679).Kernel := To_Vector ((((232, 1),  232,  2, (32767, 0),  0), ((232, 2),  232,  0, (232,
            2),  3), ((232, 2),  232,  2, (32767, 0),  0)));
            Table.States (679).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (232, 2),  3)));
            Table.States (680).Action_List.Set_Capacity (38);
            Add_Action (Table.States (680), (33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 72, 73, 74, 75,
            82, 87, 88, 89, 91, 94, 95, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110, 111), (232, 1),  3);
            Table.States (680).Kernel := To_Vector ((((232, 0),  233,  0, (232, 0),  1), ((232, 1),  233,  0, (232, 1),
             3)));
            Table.States (680).Minimal_Complete_Actions := To_Vector (((Reduce, (232, 0),  1), (Reduce, (232, 1),
            3)));
            Table.States (681).Action_List.Set_Capacity (38);
            Add_Action (Table.States (681), (33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 72, 73, 74, 75,
            82, 87, 88, 89, 91, 94, 95, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110, 111), (233, 0),  3);
            Table.States (681).Kernel := To_Vector ((0 => ((233, 0),  234,  0, (233, 0),  3)));
            Table.States (681).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (233, 0),  3)));
            Table.States (682).Action_List.Set_Capacity (38);
            Add_Action (Table.States (682), 33, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 36, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 42, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 43, (238, 3), 409);
            Add_Action (Table.States (682), 45, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 46, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 47, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 48, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 49, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 50, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 52, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 61, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 63, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 69, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 72, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 73, (238, 2), 410);
            Add_Action (Table.States (682), 74, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 75, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 82, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 87, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 88, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 89, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 91, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 94, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 95, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 97, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 98, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 99, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 100, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 101, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 103, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 104, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 106, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 107, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 108, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 109, (238, 1), 411);
            Add_Action (Table.States (682), 110, Reduce, (465, 1),  3);
            Add_Action (Table.States (682), 111, (238, 0), 412);
            Table.States (682).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (682), 238, 413);
            Table.States (682).Kernel := To_Vector ((((232, 1),  232,  2, (32767, 0),  0), ((232, 2),  232,  2, (32767,
            0),  0), ((465, 0),  232,  0, (465, 0),  1), ((465, 1),  232,  0, (465, 1),  3)));
            Table.States (682).Minimal_Complete_Actions := To_Vector (((Reduce, (465, 0),  1), (Reduce, (465, 1),
            3)));
            Table.States (683).Action_List.Set_Capacity (34);
            Add_Action (Table.States (683), (33, 36, 42, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 72, 74, 75, 82, 87,
            88, 89, 91, 94, 95, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 110), (465, 2),  3);
            Table.States (683).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (683), 236, 419);
            Table.States (683).Kernel := To_Vector ((((465, 1),  465,  2, (32767, 0),  0), ((465, 2),  465,  0, (465,
            2),  3), ((465, 2),  465,  2, (32767, 0),  0)));
            Table.States (683).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (465, 2),  3)));
            Table.States (684).Action_List.Set_Capacity (7);
            Add_Action (Table.States (684), 85, (198, 0), 281);
            Add_Action (Table.States (684), 87, Reduce, (306, 1),  3);
            Add_Action (Table.States (684), 95, Reduce, (306, 1),  3);
            Add_Action (Table.States (684), 96, (197, 0), 283);
            Add_Action (Table.States (684), 108, Reduce, (306, 1),  3);
            Add_Action (Table.States (684), 113, (121, 0), 285);
            Add_Action (Table.States (684), 114, (121, 1), 286);
            Table.States (684).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (684), 121, 287);
            Add_Goto (Table.States (684), 313, 289);
            Table.States (684).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((306, 0),  195,  0, (306, 0),  1), ((306, 1),  195,  0, (306, 1),  3), ((311, 0),  195,
            3, (32767, 0),  0)));
            Table.States (684).Minimal_Complete_Actions := To_Vector (((Reduce, (306, 0),  1), (Reduce, (306, 1),
            3)));
            Table.States (685).Action_List.Set_Capacity (3);
            Add_Action (Table.States (685), (87, 95, 108), (306, 2),  3);
            Table.States (685).Kernel := To_Vector ((((306, 1),  306,  2, (32767, 0),  0), ((306, 2),  306,  0, (306,
            2),  3), ((306, 2),  306,  2, (32767, 0),  0)));
            Table.States (685).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (306, 2),  3)));
            Table.States (686).Action_List.Set_Capacity (1);
            Add_Action (Table.States (686), 108, (363, 0), 1006);
            Table.States (686).Kernel := To_Vector ((0 => ((363, 0),  18,  1, (32767, 0),  0)));
            Table.States (686).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (363, 0),  108, 1006)));
            Table.States (687).Action_List.Set_Capacity (32);
            Add_Action (Table.States (687), 43, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 45, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 46, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 48, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 52, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 71, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 72, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 73, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 74, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 75, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 85, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 87, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 89, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 91, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 93, Reduce, (136, 0),  1);
            Add_Action (Table.States (687), 95, Reduce, (136, 0),  1);
            Add_Conflict (Table.States (687), 95, (196, 0),  1);
            Add_Action (Table.States (687), 96, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 97, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 98, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 99, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 100, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 101, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 103, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 104, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 106, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 107, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 109, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 110, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 111, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 112, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 113, Reduce, (196, 0),  1);
            Add_Action (Table.States (687), 114, Reduce, (196, 0),  1);
            Table.States (687).Kernel := To_Vector ((((136, 0),  116,  0, (136, 0),  1), ((196, 0),  116,  0, (196, 0),
             1)));
            Table.States (687).Minimal_Complete_Actions := To_Vector (((Reduce, (136, 0),  1), (Reduce, (196, 0),
            1)));
         end Subr_28;
         procedure Subr_29
         is begin
            Table.States (688).Action_List.Set_Capacity (2);
            Add_Action (Table.States (688), 93, (300, 0), 749);
            Add_Action (Table.States (688), 95, (136, 1), 280);
            Table.States (688).Kernel := To_Vector ((((136, 1),  136,  2, (32767, 0),  0), ((300, 0),  136,  7, (32767,
            0),  0), ((300, 1),  136,  5, (32767, 0),  0), ((300, 2),  136,  5, (32767, 0),  0), ((300, 3),  136,  3,
            (32767, 0),  0), ((300, 4),  136,  6, (32767, 0),  0), ((300, 5),  136,  4, (32767, 0),  0), ((300, 6),
            136,  4, (32767, 0),  0), ((300, 7),  136,  2, (32767, 0),  0), ((300, 8),  136,  5, (32767, 0),  0),
            ((300, 9),  136,  3, (32767, 0),  0)));
            Table.States (688).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (300, 0),  93, 749)));
            Table.States (689).Action_List.Set_Capacity (1);
            Add_Action (Table.States (689), (1 =>  87), (358, 0),  1);
            Table.States (689).Kernel := To_Vector ((0 => ((358, 0),  227,  0, (358, 0),  1)));
            Table.States (689).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (358, 0),  1)));
            Table.States (690).Action_List.Set_Capacity (1);
            Add_Action (Table.States (690), 87, (357, 0), 1007);
            Table.States (690).Kernel := To_Vector ((((357, 0),  358,  6, (32767, 0),  0), ((357, 1),  358,  2, (32767,
            0),  0)));
            Table.States (690).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (357, 0),  87, 1007)));
            Table.States (691).Action_List.Set_Capacity (25);
            Add_Action (Table.States (691), 12, (401, 0), 1);
            Add_Action (Table.States (691), 15, (370, 0), 3);
            Add_Action (Table.States (691), 17, (365, 0), 4);
            Add_Action (Table.States (691), 18, (382, 0), 5);
            Add_Action (Table.States (691), 19, (363, 0), 6);
            Add_Action (Table.States (691), 20, (357, 0), 7);
            Add_Action (Table.States (691), 30, (316, 0), 13);
            Add_Action (Table.States (691), 31, (290, 0), 14);
            Add_Action (Table.States (691), 32, (289, 0), 15);
            Add_Action (Table.States (691), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (691), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (691), 37, (288, 0), 17);
            Add_Conflict (Table.States (691), 37, (285, 1),  0);
            Add_Action (Table.States (691), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (691), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (691), 41, (271, 0), 18);
            Add_Action (Table.States (691), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (691), 64, (273, 0), 27);
            Add_Action (Table.States (691), 65, (264, 0), 28);
            Add_Action (Table.States (691), 84, (124, 0), 32);
            Add_Action (Table.States (691), 86, (252, 0), 33);
            Add_Action (Table.States (691), 90, (268, 0), 34);
            Add_Action (Table.States (691), 105, (265, 0), 35);
            Add_Action (Table.States (691), 116, (196, 0), 146);
            Add_Action (Table.States (691), 117, (196, 1), 37);
            Add_Action (Table.States (691), 118, (195, 6), 38);
            Table.States (691).Goto_List.Set_Capacity (46);
            Add_Goto (Table.States (691), 124, 39);
            Add_Goto (Table.States (691), 195, 52);
            Add_Goto (Table.States (691), 196, 53);
            Add_Goto (Table.States (691), 197, 54);
            Add_Goto (Table.States (691), 198, 55);
            Add_Goto (Table.States (691), 199, 56);
            Add_Goto (Table.States (691), 201, 57);
            Add_Goto (Table.States (691), 251, 58);
            Add_Goto (Table.States (691), 252, 59);
            Add_Goto (Table.States (691), 255, 60);
            Add_Goto (Table.States (691), 259, 452);
            Add_Goto (Table.States (691), 261, 331);
            Add_Goto (Table.States (691), 262, 62);
            Add_Goto (Table.States (691), 263, 63);
            Add_Goto (Table.States (691), 264, 64);
            Add_Goto (Table.States (691), 265, 65);
            Add_Goto (Table.States (691), 266, 66);
            Add_Goto (Table.States (691), 267, 67);
            Add_Goto (Table.States (691), 268, 68);
            Add_Goto (Table.States (691), 271, 69);
            Add_Goto (Table.States (691), 273, 70);
            Add_Goto (Table.States (691), 275, 71);
            Add_Goto (Table.States (691), 285, 72);
            Add_Goto (Table.States (691), 286, 73);
            Add_Goto (Table.States (691), 288, 74);
            Add_Goto (Table.States (691), 289, 75);
            Add_Goto (Table.States (691), 290, 76);
            Add_Goto (Table.States (691), 310, 82);
            Add_Goto (Table.States (691), 311, 83);
            Add_Goto (Table.States (691), 316, 84);
            Add_Goto (Table.States (691), 318, 85);
            Add_Goto (Table.States (691), 357, 110);
            Add_Goto (Table.States (691), 363, 111);
            Add_Goto (Table.States (691), 364, 112);
            Add_Goto (Table.States (691), 365, 113);
            Add_Goto (Table.States (691), 366, 114);
            Add_Goto (Table.States (691), 367, 115);
            Add_Goto (Table.States (691), 370, 116);
            Add_Goto (Table.States (691), 376, 117);
            Add_Goto (Table.States (691), 378, 118);
            Add_Goto (Table.States (691), 379, 119);
            Add_Goto (Table.States (691), 382, 120);
            Add_Goto (Table.States (691), 396, 1008);
            Add_Goto (Table.States (691), 401, 133);
            Add_Goto (Table.States (691), 461, 332);
            Add_Goto (Table.States (691), 462, 144);
            Table.States (691).Kernel := To_Vector ((0 => ((357, 2),  33,  4, (32767, 0),  0)));
            Table.States (691).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (264, 0),  65, 28)));
            Table.States (692).Action_List.Set_Capacity (50);
            Add_Action (Table.States (692), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (357, 3),  4);
            Table.States (692).Kernel := To_Vector ((0 => ((357, 3),  108,  0, (357, 3),  4)));
            Table.States (692).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (357, 3),  4)));
            Table.States (693).Action_List.Set_Capacity (6);
            Add_Action (Table.States (693), (36, 50, 63, 87, 95, 99), (160, 0),  1);
            Table.States (693).Kernel := To_Vector ((0 => ((160, 0),  131,  0, (160, 0),  1)));
            Table.States (693).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (160, 0),  1)));
            Table.States (694).Action_List.Set_Capacity (6);
            Add_Action (Table.States (694), (36, 50, 63, 87, 95, 99), (160, 1),  1);
            Table.States (694).Kernel := To_Vector ((0 => ((160, 1),  140,  0, (160, 1),  1)));
            Table.States (694).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (160, 1),  1)));
            Table.States (695).Action_List.Set_Capacity (1);
            Add_Action (Table.States (695), 87, (356, 4), 1009);
            Table.States (695).Kernel := To_Vector ((((356, 4),  160,  4, (32767, 0),  0), ((356, 5),  160,  2, (32767,
            0),  0)));
            Table.States (695).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (356, 4),  87, 1009)));
            Table.States (696).Action_List.Set_Capacity (1);
            Add_Action (Table.States (696), 97, (140, 1), 653);
            Table.States (696).Kernel := To_Vector ((0 => ((140, 1),  231,  2, (32767, 0),  0)));
            Table.States (696).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (140, 1),  97, 653)));
            Table.States (697).Action_List.Set_Capacity (43);
            Add_Action (Table.States (697), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (356, 7),  4);
            Table.States (697).Kernel := To_Vector ((0 => ((356, 7),  108,  0, (356, 7),  4)));
            Table.States (697).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (356, 7),  4)));
            Table.States (698).Action_List.Set_Capacity (1);
            Add_Action (Table.States (698), 108, (356, 6), 1010);
            Table.States (698).Kernel := To_Vector ((0 => ((356, 6),  434,  1, (32767, 0),  0)));
            Table.States (698).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (356, 6),  108, 1010)));
            Table.States (699).Action_List.Set_Capacity (5);
            Add_Action (Table.States (699), 86, (252, 0), 33);
            Add_Action (Table.States (699), 90, (268, 0), 34);
            Add_Action (Table.States (699), 116, (196, 0), 146);
            Add_Action (Table.States (699), 117, (196, 1), 37);
            Add_Action (Table.States (699), 118, (195, 6), 38);
            Table.States (699).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (699), 195, 1011);
            Add_Goto (Table.States (699), 196, 148);
            Add_Goto (Table.States (699), 197, 54);
            Add_Goto (Table.States (699), 198, 55);
            Add_Goto (Table.States (699), 199, 56);
            Add_Goto (Table.States (699), 201, 57);
            Add_Goto (Table.States (699), 251, 58);
            Add_Goto (Table.States (699), 252, 59);
            Add_Goto (Table.States (699), 255, 60);
            Add_Goto (Table.States (699), 268, 68);
            Add_Goto (Table.States (699), 311, 83);
            Table.States (699).Kernel := To_Vector ((((339, 0),  24,  4, (32767, 0),  0), ((339, 1),  24,  2, (32767,
            0),  0)));
            Table.States (699).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (700).Action_List.Set_Capacity (5);
            Add_Action (Table.States (700), 86, (252, 0), 33);
            Add_Action (Table.States (700), 90, (268, 0), 34);
            Add_Action (Table.States (700), 116, (196, 0), 146);
            Add_Action (Table.States (700), 117, (196, 1), 37);
            Add_Action (Table.States (700), 118, (195, 6), 38);
            Table.States (700).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (700), 195, 1012);
            Add_Goto (Table.States (700), 196, 148);
            Add_Goto (Table.States (700), 197, 54);
            Add_Goto (Table.States (700), 198, 55);
            Add_Goto (Table.States (700), 199, 56);
            Add_Goto (Table.States (700), 201, 57);
            Add_Goto (Table.States (700), 251, 58);
            Add_Goto (Table.States (700), 252, 59);
            Add_Goto (Table.States (700), 255, 60);
            Add_Goto (Table.States (700), 268, 68);
            Add_Goto (Table.States (700), 311, 83);
            Table.States (700).Kernel := To_Vector ((((339, 4),  24,  4, (32767, 0),  0), ((339, 5),  24,  2, (32767,
            0),  0)));
            Table.States (700).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (701).Action_List.Set_Capacity (5);
            Add_Action (Table.States (701), 86, (252, 0), 33);
            Add_Action (Table.States (701), 90, (268, 0), 34);
            Add_Action (Table.States (701), 116, (196, 0), 146);
            Add_Action (Table.States (701), 117, (196, 1), 37);
            Add_Action (Table.States (701), 118, (195, 6), 38);
            Table.States (701).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (701), 195, 1013);
            Add_Goto (Table.States (701), 196, 148);
            Add_Goto (Table.States (701), 197, 54);
            Add_Goto (Table.States (701), 198, 55);
            Add_Goto (Table.States (701), 199, 56);
            Add_Goto (Table.States (701), 201, 57);
            Add_Goto (Table.States (701), 251, 58);
            Add_Goto (Table.States (701), 252, 59);
            Add_Goto (Table.States (701), 255, 60);
            Add_Goto (Table.States (701), 268, 68);
            Add_Goto (Table.States (701), 311, 83);
            Table.States (701).Kernel := To_Vector ((((339, 2),  24,  4, (32767, 0),  0), ((339, 3),  24,  2, (32767,
            0),  0)));
            Table.States (701).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (702).Action_List.Set_Capacity (1);
            Add_Action (Table.States (702), 82, (430, 0), 1014);
            Table.States (702).Kernel := To_Vector ((((430, 0),  116,  6, (32767, 0),  0), ((430, 1),  116,  4, (32767,
            0),  0)));
            Table.States (702).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (430, 0),  82, 1014)));
            Table.States (703).Action_List.Set_Capacity (8);
            Add_Action (Table.States (703), 65, (428, 2), 1015);
            Add_Action (Table.States (703), 78, (427, 0), 1016);
            Add_Action (Table.States (703), 86, (252, 0), 33);
            Add_Action (Table.States (703), 90, (268, 0), 34);
            Add_Action (Table.States (703), 92, (428, 1), 1017);
            Add_Action (Table.States (703), 116, (196, 0), 146);
            Add_Action (Table.States (703), 117, (196, 1), 37);
            Add_Action (Table.States (703), 118, (195, 6), 38);
            Table.States (703).Goto_List.Set_Capacity (13);
            Add_Goto (Table.States (703), 195, 1018);
            Add_Goto (Table.States (703), 196, 148);
            Add_Goto (Table.States (703), 197, 54);
            Add_Goto (Table.States (703), 198, 55);
            Add_Goto (Table.States (703), 199, 56);
            Add_Goto (Table.States (703), 201, 57);
            Add_Goto (Table.States (703), 251, 58);
            Add_Goto (Table.States (703), 252, 59);
            Add_Goto (Table.States (703), 255, 60);
            Add_Goto (Table.States (703), 268, 68);
            Add_Goto (Table.States (703), 311, 83);
            Add_Goto (Table.States (703), 428, 1019);
            Add_Goto (Table.States (703), 429, 1020);
            Table.States (703).Kernel := To_Vector ((((426, 0),  82,  4, (32767, 0),  0), ((426, 1),  82,  2, (32767,
            0),  0), ((427, 0),  82,  5, (32767, 0),  0), ((427, 1),  82,  3, (32767, 0),  0), ((427, 2),  82,  4,
            (32767, 0),  0), ((427, 3),  82,  2, (32767, 0),  0)));
            Table.States (703).Minimal_Complete_Actions := To_Vector (((Shift, (196, 0),  116, 146), (Shift, (427, 0),
            78, 1016)));
            Table.States (704).Action_List.Set_Capacity (8);
            Add_Action (Table.States (704), (28, 50, 53, 54, 61, 83, 84, 116), (426, 3),  3);
            Table.States (704).Kernel := To_Vector ((0 => ((426, 3),  108,  0, (426, 3),  3)));
            Table.States (704).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (426, 3),  3)));
            Table.States (705).Action_List.Set_Capacity (1);
            Add_Action (Table.States (705), 108, (426, 2), 1021);
            Table.States (705).Kernel := To_Vector ((0 => ((426, 2),  434,  1, (32767, 0),  0)));
            Table.States (705).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (426, 2),  108, 1021)));
            Table.States (706).Action_List.Set_Capacity (1);
            Add_Action (Table.States (706), 50, (412, 6), 1022);
            Table.States (706).Kernel := To_Vector ((0 => ((412, 6),  48,  3, (32767, 0),  0)));
            Table.States (706).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (412, 6),  50, 1022)));
            Table.States (707).Action_List.Set_Capacity (17);
            Add_Action (Table.States (707), 27, (414, 5), 1023);
            Add_Action (Table.States (707), 52, (187, 0), 347);
            Add_Action (Table.States (707), 56, (183, 4), 816);
            Add_Action (Table.States (707), 57, (181, 8), 817);
            Add_Action (Table.States (707), 58, (181, 6), 1024);
            Add_Action (Table.States (707), 59, (181, 4), 819);
            Add_Action (Table.States (707), 60, (181, 2), 820);
            Add_Action (Table.States (707), 68, (412, 4), 1025);
            Add_Action (Table.States (707), 70, (156, 0), 519);
            Add_Action (Table.States (707), 71, (420, 0), 1026);
            Add_Action (Table.States (707), 72, (419, 0), 1027);
            Add_Action (Table.States (707), 73, (418, 0), 1028);
            Add_Action (Table.States (707), 74, (417, 0), 1029);
            Add_Action (Table.States (707), 76, (415, 15), 1030);
            Add_Action (Table.States (707), 77, (181, 0), 1031);
            Add_Action (Table.States (707), 78, (414, 0), 1032);
            Add_Action (Table.States (707), 85, (416, 0), 1033);
            Table.States (707).Goto_List.Set_Capacity (19);
            Add_Goto (Table.States (707), 154, 1034);
            Add_Goto (Table.States (707), 156, 524);
            Add_Goto (Table.States (707), 159, 525);
            Add_Goto (Table.States (707), 181, 1035);
            Add_Goto (Table.States (707), 183, 1036);
            Add_Goto (Table.States (707), 184, 848);
            Add_Goto (Table.States (707), 187, 849);
            Add_Goto (Table.States (707), 413, 1037);
            Add_Goto (Table.States (707), 414, 1038);
            Add_Goto (Table.States (707), 415, 1039);
            Add_Goto (Table.States (707), 416, 1040);
            Add_Goto (Table.States (707), 417, 1041);
            Add_Goto (Table.States (707), 418, 1042);
            Add_Goto (Table.States (707), 419, 1043);
            Add_Goto (Table.States (707), 420, 1044);
            Add_Goto (Table.States (707), 421, 1045);
            Add_Goto (Table.States (707), 422, 1046);
            Add_Goto (Table.States (707), 423, 1047);
            Add_Goto (Table.States (707), 424, 1048);
            Table.States (707).Kernel := To_Vector ((((411, 4),  82,  7, (32767, 0),  0), ((411, 5),  82,  5, (32767,
            0),  0), ((411, 6),  82,  4, (32767, 0),  0), ((411, 7),  82,  2, (32767, 0),  0), ((412, 4),  82,  5,
            (32767, 0),  0), ((412, 5),  82,  2, (32767, 0),  0)));
            Table.States (707).Minimal_Complete_Actions := To_Vector (((Shift, (414, 5),  27, 1023), (Shift, (412, 4),
            68, 1025)));
            Table.States (708).Action_List.Set_Capacity (8);
            Add_Action (Table.States (708), (28, 50, 53, 54, 61, 83, 84, 116), (412, 7),  3);
            Table.States (708).Kernel := To_Vector ((0 => ((412, 7),  108,  0, (412, 7),  3)));
            Table.States (708).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (412, 7),  3)));
            Table.States (709).Action_List.Set_Capacity (3);
            Add_Action (Table.States (709), 48, (412, 2), 1049);
            Add_Action (Table.States (709), 82, (411, 0), 1050);
            Add_Action (Table.States (709), 108, (412, 3), 1051);
            Table.States (709).Kernel := To_Vector ((((411, 0),  164,  8, (32767, 0),  0), ((411, 1),  164,  6, (32767,
            0),  0), ((411, 2),  164,  5, (32767, 0),  0), ((411, 3),  164,  3, (32767, 0),  0), ((412, 0),  164,  6,
            (32767, 0),  0), ((412, 1),  164,  3, (32767, 0),  0), ((412, 2),  164,  4, (32767, 0),  0), ((412, 3),
            164,  1, (32767, 0),  0)));
            Table.States (709).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (412, 3),  108, 1051)));
            Table.States (710).Action_List.Set_Capacity (3);
            Add_Action (Table.States (710), (48, 82, 108), (164, 1),  1);
            Table.States (710).Kernel := To_Vector ((0 => ((164, 1),  167,  0, (164, 1),  1)));
            Table.States (710).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (164, 1),  1)));
            Table.States (711).Action_List.Set_Capacity (7);
            Add_Action (Table.States (711), (52, 56, 86, 90, 116, 117, 118), (301, 3),  1);
            Table.States (711).Kernel := To_Vector ((0 => ((301, 3),  29,  0, (301, 3),  1)));
            Table.States (711).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (301, 3),  1)));
            Table.States (712).Action_List.Set_Capacity (8);
            Add_Action (Table.States (712), 29, (301, 2), 1052);
            Add_Action (Table.States (712), 52, Reduce, (301, 0),  1);
            Add_Action (Table.States (712), 56, Reduce, (301, 0),  1);
            Add_Action (Table.States (712), 86, Reduce, (301, 0),  1);
            Add_Action (Table.States (712), 90, Reduce, (301, 0),  1);
            Add_Action (Table.States (712), 116, Reduce, (301, 0),  1);
            Add_Action (Table.States (712), 117, Reduce, (301, 0),  1);
            Add_Action (Table.States (712), 118, Reduce, (301, 0),  1);
            Table.States (712).Kernel := To_Vector ((((301, 0),  45,  0, (301, 0),  1), ((301, 2),  45,  1, (32767, 0),
             0)));
            Table.States (712).Minimal_Complete_Actions := To_Vector (((Reduce, (301, 0),  1), (Shift, (301, 2),  29,
            1052)));
            Table.States (713).Action_List.Set_Capacity (7);
            Add_Action (Table.States (713), 52, (187, 0), 347);
            Add_Action (Table.States (713), 56, (188, 2), 514);
            Add_Action (Table.States (713), 86, (252, 0), 33);
            Add_Action (Table.States (713), 90, (268, 0), 34);
            Add_Action (Table.States (713), 116, (196, 0), 146);
            Add_Action (Table.States (713), 117, (196, 1), 37);
            Add_Action (Table.States (713), 118, (195, 6), 38);
            Table.States (713).Goto_List.Set_Capacity (13);
            Add_Goto (Table.States (713), 187, 1053);
            Add_Goto (Table.States (713), 188, 1054);
            Add_Goto (Table.States (713), 195, 1055);
            Add_Goto (Table.States (713), 196, 148);
            Add_Goto (Table.States (713), 197, 54);
            Add_Goto (Table.States (713), 198, 55);
            Add_Goto (Table.States (713), 199, 56);
            Add_Goto (Table.States (713), 201, 57);
            Add_Goto (Table.States (713), 251, 58);
            Add_Goto (Table.States (713), 252, 59);
            Add_Goto (Table.States (713), 255, 60);
            Add_Goto (Table.States (713), 268, 68);
            Add_Goto (Table.States (713), 311, 83);
            Table.States (713).Kernel := To_Vector ((((409, 0),  301,  8, (32767, 0),  0), ((409, 1),  301,  6, (32767,
            0),  0), ((409, 2),  301,  6, (32767, 0),  0), ((409, 3),  301,  4, (32767, 0),  0), ((409, 4),  301,  6,
            (32767, 0),  0), ((409, 5),  301,  4, (32767, 0),  0), ((409, 6),  301,  4, (32767, 0),  0), ((409, 7),
            301,  2, (32767, 0),  0), ((409, 8),  301,  7, (32767, 0),  0), ((409, 9),  301,  5, (32767, 0),  0),
            ((409, 10),  301,  5, (32767, 0),  0), ((409, 11),  301,  3, (32767, 0),  0)));
            Table.States (713).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (714).Action_List.Set_Capacity (42);
            Add_Action (Table.States (714), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (387,
            0),  4);
            Table.States (714).Kernel := To_Vector ((0 => ((387, 0),  108,  0, (387, 0),  4)));
            Table.States (714).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (387, 0),  4)));
            Table.States (715).Action_List.Set_Capacity (1);
            Add_Action (Table.States (715), 13, (390, 0), 1056);
            Table.States (715).Kernel := To_Vector ((((390, 0),  82,  4, (32767, 0),  0), ((390, 1),  82,  2, (32767,
            0),  0)));
            Table.States (715).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (390, 0),  13, 1056)));
            Table.States (716).Action_List.Set_Capacity (16);
            Add_Action (Table.States (716), 22, (339, 0), 9);
            Add_Action (Table.States (716), 25, (329, 1), 10);
            Add_Action (Table.States (716), 28, (325, 0), 12);
            Add_Action (Table.States (716), 38, Reduce, (192, 1),  0);
            Add_Action (Table.States (716), 50, (332, 0), 19);
            Add_Action (Table.States (716), 51, (437, 0), 221);
            Add_Action (Table.States (716), 52, (329, 0), 21);
            Add_Action (Table.States (716), 53, (294, 0), 22);
            Add_Action (Table.States (716), 54, (293, 0), 23);
            Add_Action (Table.States (716), 59, (346, 0), 24);
            Add_Action (Table.States (716), 60, (340, 0), 25);
            Add_Action (Table.States (716), 66, Reduce, (192, 1),  0);
            Add_Action (Table.States (716), 81, (130, 0), 30);
            Add_Action (Table.States (716), 83, (128, 0), 31);
            Add_Action (Table.States (716), 84, (124, 0), 32);
            Add_Action (Table.States (716), 116, (136, 0), 223);
            Table.States (716).Goto_List.Set_Capacity (60);
            Add_Goto (Table.States (716), 124, 561);
            Add_Goto (Table.States (716), 126, 40);
            Add_Goto (Table.States (716), 127, 41);
            Add_Goto (Table.States (716), 128, 42);
            Add_Goto (Table.States (716), 130, 43);
            Add_Goto (Table.States (716), 135, 44);
            Add_Goto (Table.States (716), 136, 45);
            Add_Goto (Table.States (716), 137, 46);
            Add_Goto (Table.States (716), 180, 47);
            Add_Goto (Table.States (716), 189, 48);
            Add_Goto (Table.States (716), 190, 562);
            Add_Goto (Table.States (716), 191, 563);
            Add_Goto (Table.States (716), 192, 1057);
            Add_Goto (Table.States (716), 193, 50);
            Add_Goto (Table.States (716), 194, 51);
            Add_Goto (Table.States (716), 291, 77);
            Add_Goto (Table.States (716), 292, 78);
            Add_Goto (Table.States (716), 293, 79);
            Add_Goto (Table.States (716), 294, 80);
            Add_Goto (Table.States (716), 309, 81);
            Add_Goto (Table.States (716), 320, 86);
            Add_Goto (Table.States (716), 321, 87);
            Add_Goto (Table.States (716), 322, 88);
            Add_Goto (Table.States (716), 325, 89);
            Add_Goto (Table.States (716), 326, 90);
            Add_Goto (Table.States (716), 327, 91);
            Add_Goto (Table.States (716), 328, 92);
            Add_Goto (Table.States (716), 329, 225);
            Add_Goto (Table.States (716), 330, 94);
            Add_Goto (Table.States (716), 332, 95);
            Add_Goto (Table.States (716), 333, 96);
            Add_Goto (Table.States (716), 334, 97);
            Add_Goto (Table.States (716), 335, 98);
            Add_Goto (Table.States (716), 336, 99);
            Add_Goto (Table.States (716), 337, 100);
            Add_Goto (Table.States (716), 338, 101);
            Add_Goto (Table.States (716), 339, 102);
            Add_Goto (Table.States (716), 340, 103);
            Add_Goto (Table.States (716), 341, 104);
            Add_Goto (Table.States (716), 345, 105);
            Add_Goto (Table.States (716), 346, 106);
            Add_Goto (Table.States (716), 347, 107);
            Add_Goto (Table.States (716), 354, 108);
            Add_Goto (Table.States (716), 388, 126);
            Add_Goto (Table.States (716), 389, 127);
            Add_Goto (Table.States (716), 390, 128);
            Add_Goto (Table.States (716), 391, 129);
            Add_Goto (Table.States (716), 392, 130);
            Add_Goto (Table.States (716), 394, 132);
            Add_Goto (Table.States (716), 403, 134);
            Add_Goto (Table.States (716), 404, 135);
            Add_Goto (Table.States (716), 405, 136);
            Add_Goto (Table.States (716), 406, 137);
            Add_Goto (Table.States (716), 408, 138);
            Add_Goto (Table.States (716), 431, 139);
            Add_Goto (Table.States (716), 437, 140);
            Add_Goto (Table.States (716), 438, 141);
            Add_Goto (Table.States (716), 440, 142);
            Add_Goto (Table.States (716), 454, 143);
            Add_Goto (Table.States (716), 458, 565);
            Table.States (716).Kernel := To_Vector ((((326, 2),  82,  5, (32767, 0),  0), ((326, 3),  82,  2, (32767,
            0),  0)));
            Table.States (716).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (192, 1),  0)));
         end Subr_29;
         procedure Subr_30
         is begin
            Table.States (717).Action_List.Set_Capacity (1);
            Add_Action (Table.States (717), 82, (326, 0), 1058);
            Table.States (717).Kernel := To_Vector ((((326, 0),  434,  6, (32767, 0),  0), ((326, 1),  434,  3, (32767,
            0),  0)));
            Table.States (717).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (326, 0),  82, 1058)));
            Table.States (718).Action_List.Set_Capacity (6);
            Add_Action (Table.States (718), 61, (434, 0), 299);
            Add_Action (Table.States (718), 85, (198, 0), 281);
            Add_Action (Table.States (718), 96, (197, 0), 283);
            Add_Action (Table.States (718), 108, (337, 1), 1059);
            Add_Action (Table.States (718), 113, (121, 0), 285);
            Add_Action (Table.States (718), 114, (121, 1), 286);
            Table.States (718).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (718), 121, 287);
            Add_Goto (Table.States (718), 313, 289);
            Add_Goto (Table.States (718), 434, 1060);
            Table.States (718).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((337, 0),  195,  3, (32767, 0),  0), ((337, 1),
            195,  1, (32767, 0),  0)));
            Table.States (718).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (337, 1),  108, 1059)));
            Table.States (719).Action_List.Set_Capacity (15);
            Add_Action (Table.States (719), 22, (339, 0), 9);
            Add_Action (Table.States (719), 25, (329, 1), 10);
            Add_Action (Table.States (719), 28, (325, 0), 720);
            Add_Action (Table.States (719), 50, (332, 0), 19);
            Add_Action (Table.States (719), 51, (437, 0), 221);
            Add_Action (Table.States (719), 52, (329, 0), 21);
            Add_Action (Table.States (719), 53, (294, 0), 22);
            Add_Action (Table.States (719), 54, (293, 0), 23);
            Add_Action (Table.States (719), 59, (346, 0), 721);
            Add_Action (Table.States (719), 60, (340, 0), 722);
            Add_Action (Table.States (719), 66, (325, 10), 1061);
            Add_Action (Table.States (719), 81, (130, 0), 30);
            Add_Action (Table.States (719), 83, (128, 0), 31);
            Add_Action (Table.States (719), 84, (124, 0), 32);
            Add_Action (Table.States (719), 116, (136, 0), 223);
            Table.States (719).Goto_List.Set_Capacity (48);
            Add_Goto (Table.States (719), 124, 725);
            Add_Goto (Table.States (719), 126, 40);
            Add_Goto (Table.States (719), 127, 41);
            Add_Goto (Table.States (719), 128, 42);
            Add_Goto (Table.States (719), 130, 43);
            Add_Goto (Table.States (719), 135, 44);
            Add_Goto (Table.States (719), 136, 45);
            Add_Goto (Table.States (719), 137, 46);
            Add_Goto (Table.States (719), 180, 47);
            Add_Goto (Table.States (719), 189, 48);
            Add_Goto (Table.States (719), 193, 726);
            Add_Goto (Table.States (719), 291, 77);
            Add_Goto (Table.States (719), 292, 727);
            Add_Goto (Table.States (719), 293, 79);
            Add_Goto (Table.States (719), 294, 80);
            Add_Goto (Table.States (719), 320, 86);
            Add_Goto (Table.States (719), 321, 87);
            Add_Goto (Table.States (719), 322, 88);
            Add_Goto (Table.States (719), 323, 728);
            Add_Goto (Table.States (719), 324, 1062);
            Add_Goto (Table.States (719), 325, 89);
            Add_Goto (Table.States (719), 327, 91);
            Add_Goto (Table.States (719), 328, 92);
            Add_Goto (Table.States (719), 329, 730);
            Add_Goto (Table.States (719), 330, 94);
            Add_Goto (Table.States (719), 332, 95);
            Add_Goto (Table.States (719), 333, 96);
            Add_Goto (Table.States (719), 334, 97);
            Add_Goto (Table.States (719), 335, 98);
            Add_Goto (Table.States (719), 336, 99);
            Add_Goto (Table.States (719), 337, 100);
            Add_Goto (Table.States (719), 338, 101);
            Add_Goto (Table.States (719), 339, 102);
            Add_Goto (Table.States (719), 340, 103);
            Add_Goto (Table.States (719), 341, 104);
            Add_Goto (Table.States (719), 346, 106);
            Add_Goto (Table.States (719), 347, 107);
            Add_Goto (Table.States (719), 394, 132);
            Add_Goto (Table.States (719), 403, 134);
            Add_Goto (Table.States (719), 404, 135);
            Add_Goto (Table.States (719), 405, 136);
            Add_Goto (Table.States (719), 406, 137);
            Add_Goto (Table.States (719), 408, 138);
            Add_Goto (Table.States (719), 431, 139);
            Add_Goto (Table.States (719), 437, 140);
            Add_Goto (Table.States (719), 438, 141);
            Add_Goto (Table.States (719), 440, 142);
            Add_Goto (Table.States (719), 454, 143);
            Table.States (719).Kernel := To_Vector ((((325, 9),  27,  4, (32767, 0),  0), ((325, 10),  27,  1, (32767,
            0),  0)));
            Table.States (719).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (325, 10),  66, 1061)));
            Table.States (720).Action_List.Set_Capacity (5);
            Add_Action (Table.States (720), 86, (252, 0), 33);
            Add_Action (Table.States (720), 90, (268, 0), 34);
            Add_Action (Table.States (720), 116, (196, 0), 146);
            Add_Action (Table.States (720), 117, (196, 1), 37);
            Add_Action (Table.States (720), 118, (195, 6), 38);
            Table.States (720).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (720), 195, 227);
            Add_Goto (Table.States (720), 196, 148);
            Add_Goto (Table.States (720), 197, 54);
            Add_Goto (Table.States (720), 198, 55);
            Add_Goto (Table.States (720), 199, 56);
            Add_Goto (Table.States (720), 201, 57);
            Add_Goto (Table.States (720), 251, 58);
            Add_Goto (Table.States (720), 252, 59);
            Add_Goto (Table.States (720), 255, 60);
            Add_Goto (Table.States (720), 268, 68);
            Add_Goto (Table.States (720), 311, 83);
            Table.States (720).Kernel := To_Vector ((((325, 0),  28,  12, (32767, 0),  0), ((325, 1),  28,  9, (32767,
            0),  0), ((325, 2),  28,  8, (32767, 0),  0), ((325, 3),  28,  9, (32767, 0),  0), ((325, 4),  28,  6,
            (32767, 0),  0), ((325, 5),  28,  5, (32767, 0),  0), ((325, 6),  28,  10, (32767, 0),  0), ((325, 7),  28,
             7, (32767, 0),  0), ((325, 8),  28,  6, (32767, 0),  0), ((325, 9),  28,  7, (32767, 0),  0), ((325, 10),
            28,  4, (32767, 0),  0), ((325, 11),  28,  3, (32767, 0),  0), ((337, 0),  28,  6, (32767, 0),  0), ((337,
            1),  28,  4, (32767, 0),  0), ((408, 0),  28,  7, (32767, 0),  0), ((408, 1),  28,  5, (32767, 0),  0)));
            Table.States (720).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (721).Action_List.Set_Capacity (2);
            Add_Action (Table.States (721), 83, (346, 0), 259);
            Add_Action (Table.States (721), 116, (347, 0), 260);
            Table.States (721).Kernel := To_Vector ((((346, 0),  59,  15, (32767, 0),  0), ((346, 1),  59,  12, (32767,
            0),  0), ((346, 2),  59,  13, (32767, 0),  0), ((346, 3),  59,  10, (32767, 0),  0), ((346, 4),  59,  10,
            (32767, 0),  0), ((346, 5),  59,  7, (32767, 0),  0), ((346, 6),  59,  8, (32767, 0),  0), ((346, 7),  59,
            5, (32767, 0),  0), ((347, 0),  59,  9, (32767, 0),  0), ((347, 1),  59,  6, (32767, 0),  0), ((347, 2),
            59,  7, (32767, 0),  0), ((347, 3),  59,  4, (32767, 0),  0)));
            Table.States (721).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (347, 0),  116, 260)));
            Table.States (722).Action_List.Set_Capacity (2);
            Add_Action (Table.States (722), 83, (340, 0), 262);
            Add_Action (Table.States (722), 116, (341, 0), 263);
            Table.States (722).Kernel := To_Vector ((((340, 0),  60,  18, (32767, 0),  0), ((340, 1),  60,  15, (32767,
            0),  0), ((340, 2),  60,  10, (32767, 0),  0), ((340, 3),  60,  16, (32767, 0),  0), ((340, 4),  60,  13,
            (32767, 0),  0), ((340, 5),  60,  8, (32767, 0),  0), ((340, 6),  60,  13, (32767, 0),  0), ((340, 7),  60,
             10, (32767, 0),  0), ((340, 8),  60,  5, (32767, 0),  0), ((340, 9),  60,  11, (32767, 0),  0), ((340,
            10),  60,  8, (32767, 0),  0), ((340, 11),  60,  3, (32767, 0),  0), ((341, 0),  60,  12, (32767, 0),  0),
            ((341, 1),  60,  9, (32767, 0),  0), ((341, 2),  60,  4, (32767, 0),  0), ((341, 3),  60,  10, (32767, 0),
            0), ((341, 4),  60,  7, (32767, 0),  0), ((341, 5),  60,  2, (32767, 0),  0)));
            Table.States (722).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (341, 0),  116, 263)));
            Table.States (723).Action_List.Set_Capacity (6);
            Add_Action (Table.States (723), 86, (252, 0), 33);
            Add_Action (Table.States (723), 90, (268, 0), 34);
            Add_Action (Table.States (723), 108, Reduce, (308, 1),  0);
            Add_Action (Table.States (723), 116, (196, 0), 146);
            Add_Action (Table.States (723), 117, (196, 1), 37);
            Add_Action (Table.States (723), 118, (195, 6), 38);
            Table.States (723).Goto_List.Set_Capacity (12);
            Add_Goto (Table.States (723), 195, 1063);
            Add_Goto (Table.States (723), 196, 148);
            Add_Goto (Table.States (723), 197, 54);
            Add_Goto (Table.States (723), 198, 55);
            Add_Goto (Table.States (723), 199, 56);
            Add_Goto (Table.States (723), 201, 57);
            Add_Goto (Table.States (723), 251, 58);
            Add_Goto (Table.States (723), 252, 59);
            Add_Goto (Table.States (723), 255, 60);
            Add_Goto (Table.States (723), 268, 68);
            Add_Goto (Table.States (723), 308, 1064);
            Add_Goto (Table.States (723), 311, 83);
            Table.States (723).Kernel := To_Vector ((0 => ((325, 11),  66,  0, (308, 1),  0)));
            Table.States (723).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (308, 1),  0)));
            Table.States (724).Action_List.Set_Capacity (5);
            Add_Action (Table.States (724), 86, (252, 0), 33);
            Add_Action (Table.States (724), 90, (268, 0), 34);
            Add_Action (Table.States (724), 116, (196, 0), 146);
            Add_Action (Table.States (724), 117, (196, 1), 37);
            Add_Action (Table.States (724), 118, (195, 6), 38);
            Table.States (724).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (724), 195, 1065);
            Add_Goto (Table.States (724), 196, 148);
            Add_Goto (Table.States (724), 197, 54);
            Add_Goto (Table.States (724), 198, 55);
            Add_Goto (Table.States (724), 199, 56);
            Add_Goto (Table.States (724), 201, 57);
            Add_Goto (Table.States (724), 251, 58);
            Add_Goto (Table.States (724), 252, 59);
            Add_Goto (Table.States (724), 255, 60);
            Add_Goto (Table.States (724), 268, 68);
            Add_Goto (Table.States (724), 311, 83);
            Table.States (724).Kernel := To_Vector ((((408, 0),  76,  4, (32767, 0),  0), ((408, 1),  76,  2, (32767,
            0),  0)));
            Table.States (724).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (725).Action_List.Set_Capacity (16);
            Add_Action (Table.States (725), (22, 25, 27, 28, 50, 51, 52, 53, 54, 59, 60, 66, 81, 83, 84, 116), (323,
            1),  1);
            Table.States (725).Kernel := To_Vector ((0 => ((323, 1),  124,  0, (323, 1),  1)));
            Table.States (725).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (323, 1),  1)));
            Table.States (726).Action_List.Set_Capacity (16);
            Add_Action (Table.States (726), (22, 25, 27, 28, 50, 51, 52, 53, 54, 59, 60, 66, 81, 83, 84, 116), (323,
            0),  1);
            Table.States (726).Kernel := To_Vector ((0 => ((323, 0),  193,  0, (323, 0),  1)));
            Table.States (726).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (323, 0),  1)));
            Table.States (727).Action_List.Set_Capacity (4);
            Add_Action (Table.States (727), 24, (338, 2), 298);
            Add_Action (Table.States (727), 61, (434, 0), 299);
            Add_Action (Table.States (727), 82, (180, 2), 1066);
            Add_Action (Table.States (727), 108, (291, 3), 301);
            Table.States (727).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (727), 434, 1067);
            Table.States (727).Kernel := To_Vector ((((180, 2),  292,  5, (32767, 0),  0), ((180, 3),  292,  3, (32767,
            0),  0), ((291, 2),  292,  3, (32767, 0),  0), ((291, 3),  292,  1, (32767, 0),  0), ((338, 2),  292,  5,
            (32767, 0),  0), ((338, 3),  292,  3, (32767, 0),  0)));
            Table.States (727).Minimal_Complete_Actions := To_Vector (((Shift, (180, 2),  82, 1066), (Shift, (338, 2),
            24, 298)));
            Table.States (728).Action_List.Set_Capacity (16);
            Add_Action (Table.States (728), (22, 25, 27, 28, 50, 51, 52, 53, 54, 59, 60, 66, 81, 83, 84, 116), (324,
            0),  1);
            Table.States (728).Kernel := To_Vector ((0 => ((324, 0),  323,  0, (324, 0),  1)));
            Table.States (728).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (324, 0),  1)));
            Table.States (729).Action_List.Set_Capacity (16);
            Add_Action (Table.States (729), 22, (339, 0), 9);
            Add_Action (Table.States (729), 25, (329, 1), 10);
            Add_Action (Table.States (729), 27, (325, 6), 1068);
            Add_Action (Table.States (729), 28, (325, 0), 720);
            Add_Action (Table.States (729), 50, (332, 0), 19);
            Add_Action (Table.States (729), 51, (437, 0), 221);
            Add_Action (Table.States (729), 52, (329, 0), 21);
            Add_Action (Table.States (729), 53, (294, 0), 22);
            Add_Action (Table.States (729), 54, (293, 0), 23);
            Add_Action (Table.States (729), 59, (346, 0), 721);
            Add_Action (Table.States (729), 60, (340, 0), 722);
            Add_Action (Table.States (729), 66, (325, 8), 1069);
            Add_Action (Table.States (729), 81, (130, 0), 30);
            Add_Action (Table.States (729), 83, (128, 0), 31);
            Add_Action (Table.States (729), 84, (124, 0), 32);
            Add_Action (Table.States (729), 116, (136, 0), 223);
            Table.States (729).Goto_List.Set_Capacity (48);
            Add_Goto (Table.States (729), 124, 725);
            Add_Goto (Table.States (729), 126, 40);
            Add_Goto (Table.States (729), 127, 41);
            Add_Goto (Table.States (729), 128, 42);
            Add_Goto (Table.States (729), 130, 43);
            Add_Goto (Table.States (729), 135, 44);
            Add_Goto (Table.States (729), 136, 45);
            Add_Goto (Table.States (729), 137, 46);
            Add_Goto (Table.States (729), 180, 47);
            Add_Goto (Table.States (729), 189, 48);
            Add_Goto (Table.States (729), 193, 726);
            Add_Goto (Table.States (729), 291, 77);
            Add_Goto (Table.States (729), 292, 727);
            Add_Goto (Table.States (729), 293, 79);
            Add_Goto (Table.States (729), 294, 80);
            Add_Goto (Table.States (729), 320, 86);
            Add_Goto (Table.States (729), 321, 87);
            Add_Goto (Table.States (729), 322, 88);
            Add_Goto (Table.States (729), 323, 1070);
            Add_Goto (Table.States (729), 324, 1071);
            Add_Goto (Table.States (729), 325, 89);
            Add_Goto (Table.States (729), 327, 91);
            Add_Goto (Table.States (729), 328, 92);
            Add_Goto (Table.States (729), 329, 730);
            Add_Goto (Table.States (729), 330, 94);
            Add_Goto (Table.States (729), 332, 95);
            Add_Goto (Table.States (729), 333, 96);
            Add_Goto (Table.States (729), 334, 97);
            Add_Goto (Table.States (729), 335, 98);
            Add_Goto (Table.States (729), 336, 99);
            Add_Goto (Table.States (729), 337, 100);
            Add_Goto (Table.States (729), 338, 101);
            Add_Goto (Table.States (729), 339, 102);
            Add_Goto (Table.States (729), 340, 103);
            Add_Goto (Table.States (729), 341, 104);
            Add_Goto (Table.States (729), 346, 106);
            Add_Goto (Table.States (729), 347, 107);
            Add_Goto (Table.States (729), 394, 132);
            Add_Goto (Table.States (729), 403, 134);
            Add_Goto (Table.States (729), 404, 135);
            Add_Goto (Table.States (729), 405, 136);
            Add_Goto (Table.States (729), 406, 137);
            Add_Goto (Table.States (729), 408, 138);
            Add_Goto (Table.States (729), 431, 139);
            Add_Goto (Table.States (729), 437, 140);
            Add_Goto (Table.States (729), 438, 141);
            Add_Goto (Table.States (729), 440, 142);
            Add_Goto (Table.States (729), 454, 143);
            Table.States (729).Kernel := To_Vector ((((324, 1),  324,  3, (32767, 0),  0), ((324, 2),  324,  3, (32767,
            0),  0), ((325, 6),  324,  5, (32767, 0),  0), ((325, 7),  324,  2, (32767, 0),  0), ((325, 8),  324,  1,
            (32767, 0),  0)));
            Table.States (729).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (325, 8),  66, 1069)));
            Table.States (730).Action_List.Set_Capacity (2);
            Add_Action (Table.States (730), 53, (294, 0), 307);
            Add_Action (Table.States (730), 54, (293, 0), 308);
            Table.States (730).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (730), 292, 1072);
            Add_Goto (Table.States (730), 293, 310);
            Add_Goto (Table.States (730), 294, 311);
            Table.States (730).Kernel := To_Vector ((((180, 0),  329,  7, (32767, 0),  0), ((180, 1),  329,  5, (32767,
            0),  0), ((291, 0),  329,  5, (32767, 0),  0), ((291, 1),  329,  3, (32767, 0),  0), ((320, 0),  329,  7,
            (32767, 0),  0), ((320, 1),  329,  5, (32767, 0),  0), ((321, 0),  329,  10, (32767, 0),  0), ((321, 1),
            329,  8, (32767, 0),  0), ((338, 0),  329,  7, (32767, 0),  0), ((338, 1),  329,  5, (32767, 0),  0),
            ((408, 2),  329,  8, (32767, 0),  0), ((408, 3),  329,  6, (32767, 0),  0), ((408, 6),  329,  8, (32767,
            0),  0), ((408, 7),  329,  6, (32767, 0),  0)));
            Table.States (730).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (293, 0),  54, 308)));
            Table.States (731).Action_List.Set_Capacity (16);
            Add_Action (Table.States (731), 22, (339, 0), 9);
            Add_Action (Table.States (731), 25, (329, 1), 10);
            Add_Action (Table.States (731), 27, (325, 3), 1073);
            Add_Action (Table.States (731), 28, (325, 0), 720);
            Add_Action (Table.States (731), 50, (332, 0), 19);
            Add_Action (Table.States (731), 51, (437, 0), 221);
            Add_Action (Table.States (731), 52, (329, 0), 21);
            Add_Action (Table.States (731), 53, (294, 0), 22);
            Add_Action (Table.States (731), 54, (293, 0), 23);
            Add_Action (Table.States (731), 59, (346, 0), 721);
            Add_Action (Table.States (731), 60, (340, 0), 722);
            Add_Action (Table.States (731), 66, (325, 5), 1074);
            Add_Action (Table.States (731), 81, (130, 0), 30);
            Add_Action (Table.States (731), 83, (128, 0), 31);
            Add_Action (Table.States (731), 84, (124, 0), 32);
            Add_Action (Table.States (731), 116, (136, 0), 223);
            Table.States (731).Goto_List.Set_Capacity (48);
            Add_Goto (Table.States (731), 124, 725);
            Add_Goto (Table.States (731), 126, 40);
            Add_Goto (Table.States (731), 127, 41);
            Add_Goto (Table.States (731), 128, 42);
            Add_Goto (Table.States (731), 130, 43);
            Add_Goto (Table.States (731), 135, 44);
            Add_Goto (Table.States (731), 136, 45);
            Add_Goto (Table.States (731), 137, 46);
            Add_Goto (Table.States (731), 180, 47);
            Add_Goto (Table.States (731), 189, 48);
            Add_Goto (Table.States (731), 193, 726);
            Add_Goto (Table.States (731), 291, 77);
            Add_Goto (Table.States (731), 292, 727);
            Add_Goto (Table.States (731), 293, 79);
            Add_Goto (Table.States (731), 294, 80);
            Add_Goto (Table.States (731), 320, 86);
            Add_Goto (Table.States (731), 321, 87);
            Add_Goto (Table.States (731), 322, 88);
            Add_Goto (Table.States (731), 323, 728);
            Add_Goto (Table.States (731), 324, 1075);
            Add_Goto (Table.States (731), 325, 89);
            Add_Goto (Table.States (731), 327, 91);
            Add_Goto (Table.States (731), 328, 92);
            Add_Goto (Table.States (731), 329, 730);
            Add_Goto (Table.States (731), 330, 94);
            Add_Goto (Table.States (731), 332, 95);
            Add_Goto (Table.States (731), 333, 96);
            Add_Goto (Table.States (731), 334, 97);
            Add_Goto (Table.States (731), 335, 98);
            Add_Goto (Table.States (731), 336, 99);
            Add_Goto (Table.States (731), 337, 100);
            Add_Goto (Table.States (731), 338, 101);
            Add_Goto (Table.States (731), 339, 102);
            Add_Goto (Table.States (731), 340, 103);
            Add_Goto (Table.States (731), 341, 104);
            Add_Goto (Table.States (731), 346, 106);
            Add_Goto (Table.States (731), 347, 107);
            Add_Goto (Table.States (731), 394, 132);
            Add_Goto (Table.States (731), 403, 134);
            Add_Goto (Table.States (731), 404, 135);
            Add_Goto (Table.States (731), 405, 136);
            Add_Goto (Table.States (731), 406, 137);
            Add_Goto (Table.States (731), 408, 138);
            Add_Goto (Table.States (731), 431, 139);
            Add_Goto (Table.States (731), 437, 140);
            Add_Goto (Table.States (731), 438, 141);
            Add_Goto (Table.States (731), 440, 142);
            Add_Goto (Table.States (731), 454, 143);
            Table.States (731).Kernel := To_Vector ((((325, 0),  82,  8, (32767, 0),  0), ((325, 1),  82,  5, (32767,
            0),  0), ((325, 2),  82,  4, (32767, 0),  0), ((325, 3),  82,  5, (32767, 0),  0), ((325, 4),  82,  2,
            (32767, 0),  0), ((325, 5),  82,  1, (32767, 0),  0)));
            Table.States (731).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (325, 5),  66, 1074)));
            Table.States (732).Action_List.Set_Capacity (7);
            Add_Action (Table.States (732), 52, (187, 0), 347);
            Add_Action (Table.States (732), 56, (188, 2), 514);
            Add_Action (Table.States (732), 86, (252, 0), 33);
            Add_Action (Table.States (732), 90, (268, 0), 34);
            Add_Action (Table.States (732), 116, (196, 0), 146);
            Add_Action (Table.States (732), 117, (196, 1), 37);
            Add_Action (Table.States (732), 118, (195, 6), 38);
            Table.States (732).Goto_List.Set_Capacity (15);
            Add_Goto (Table.States (732), 131, 734);
            Add_Goto (Table.States (732), 187, 526);
            Add_Goto (Table.States (732), 188, 735);
            Add_Goto (Table.States (732), 195, 528);
            Add_Goto (Table.States (732), 196, 148);
            Add_Goto (Table.States (732), 197, 54);
            Add_Goto (Table.States (732), 198, 55);
            Add_Goto (Table.States (732), 199, 56);
            Add_Goto (Table.States (732), 201, 57);
            Add_Goto (Table.States (732), 251, 58);
            Add_Goto (Table.States (732), 252, 59);
            Add_Goto (Table.States (732), 255, 60);
            Add_Goto (Table.States (732), 268, 68);
            Add_Goto (Table.States (732), 311, 83);
            Add_Goto (Table.States (732), 319, 1076);
            Table.States (732).Kernel := To_Vector ((((317, 4),  79,  3, (32767, 0),  0), ((317, 5),  79,  1, (32767,
            0),  0)));
            Table.States (732).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (733).Action_List.Set_Capacity (8);
            Add_Action (Table.States (733), 52, (187, 0), 347);
            Add_Action (Table.States (733), 56, (188, 2), 514);
            Add_Action (Table.States (733), 79, (317, 0), 1077);
            Add_Action (Table.States (733), 86, (252, 0), 33);
            Add_Action (Table.States (733), 90, (268, 0), 34);
            Add_Action (Table.States (733), 116, (196, 0), 146);
            Add_Action (Table.States (733), 117, (196, 1), 37);
            Add_Action (Table.States (733), 118, (195, 6), 38);
            Table.States (733).Goto_List.Set_Capacity (15);
            Add_Goto (Table.States (733), 131, 734);
            Add_Goto (Table.States (733), 187, 526);
            Add_Goto (Table.States (733), 188, 735);
            Add_Goto (Table.States (733), 195, 528);
            Add_Goto (Table.States (733), 196, 148);
            Add_Goto (Table.States (733), 197, 54);
            Add_Goto (Table.States (733), 198, 55);
            Add_Goto (Table.States (733), 199, 56);
            Add_Goto (Table.States (733), 201, 57);
            Add_Goto (Table.States (733), 251, 58);
            Add_Goto (Table.States (733), 252, 59);
            Add_Goto (Table.States (733), 255, 60);
            Add_Goto (Table.States (733), 268, 68);
            Add_Goto (Table.States (733), 311, 83);
            Add_Goto (Table.States (733), 319, 1078);
            Table.States (733).Kernel := To_Vector ((((317, 0),  80,  4, (32767, 0),  0), ((317, 1),  80,  2, (32767,
            0),  0), ((317, 2),  80,  3, (32767, 0),  0), ((317, 3),  80,  1, (32767, 0),  0)));
            Table.States (733).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
         end Subr_30;
         procedure Subr_31
         is begin
            Table.States (734).Action_List.Set_Capacity (3);
            Add_Action (Table.States (734), (33, 94, 108), (319, 0),  1);
            Table.States (734).Kernel := To_Vector ((0 => ((319, 0),  131,  0, (319, 0),  1)));
            Table.States (734).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (319, 0),  1)));
            Table.States (735).Action_List.Set_Capacity (3);
            Add_Action (Table.States (735), (33, 94, 108), (319, 1),  1);
            Table.States (735).Kernel := To_Vector ((0 => ((319, 1),  188,  0, (319, 1),  1)));
            Table.States (735).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (319, 1),  1)));
            Table.States (736).Action_List.Set_Capacity (3);
            Add_Action (Table.States (736), 33, Reduce, (317, 7),  3);
            Add_Action (Table.States (736), 94, (134, 0), 282);
            Add_Action (Table.States (736), 108, Reduce, (317, 7),  3);
            Table.States (736).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (736), 134, 1079);
            Table.States (736).Kernel := To_Vector ((((317, 6),  319,  2, (32767, 0),  0), ((317, 7),  319,  0, (317,
            7),  3)));
            Table.States (736).Minimal_Complete_Actions := To_Vector (((Shift, (134, 0),  94, 282), (Reduce, (317, 7),
            3)));
            Table.States (737).Action_List.Set_Capacity (1);
            Add_Action (Table.States (737), 66, (318, 0), 1080);
            Table.States (737).Kernel := To_Vector ((0 => ((318, 0),  396,  3, (32767, 0),  0)));
            Table.States (737).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (318, 0),  66, 1080)));
            Table.States (738).Action_List.Set_Capacity (50);
            Add_Action (Table.States (738), (12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 32, 35, 36,
            37, 38, 39, 41, 42, 47, 48, 49, 50, 51, 52, 53, 54, 59, 60, 61, 63, 64, 65, 66, 75, 77, 81, 83, 84, 86, 90,
            105, 116, 117, 118, 119), (289, 2),  4);
            Table.States (738).Kernel := To_Vector ((0 => ((289, 2),  108,  0, (289, 2),  4)));
            Table.States (738).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (289, 2),  4)));
            Table.States (739).Action_List.Set_Capacity (1);
            Add_Action (Table.States (739), 108, (289, 0), 1081);
            Table.States (739).Kernel := To_Vector ((0 => ((289, 0),  243,  1, (32767, 0),  0)));
            Table.States (739).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (289, 0),  108, 1081)));
            Table.States (740).Action_List.Set_Capacity (2);
            Add_Action (Table.States (740), 63, (398, 0), 1082);
            Add_Action (Table.States (740), 84, (124, 0), 32);
            Table.States (740).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (740), 124, 1083);
            Add_Goto (Table.States (740), 395, 1084);
            Add_Goto (Table.States (740), 398, 1085);
            Table.States (740).Kernel := To_Vector ((0 => ((396, 0),  23,  3, (32767, 0),  0)));
            Table.States (740).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (124, 0),  84, 32)));
            Table.States (741).Action_List.Set_Capacity (25);
            Add_Action (Table.States (741), 12, (401, 0), 1);
            Add_Action (Table.States (741), 15, (370, 0), 3);
            Add_Action (Table.States (741), 17, (365, 0), 4);
            Add_Action (Table.States (741), 18, (382, 0), 5);
            Add_Action (Table.States (741), 19, (363, 0), 6);
            Add_Action (Table.States (741), 20, (357, 0), 7);
            Add_Action (Table.States (741), 30, (316, 0), 13);
            Add_Action (Table.States (741), 31, (290, 0), 14);
            Add_Action (Table.States (741), 32, (289, 0), 15);
            Add_Action (Table.States (741), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (741), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (741), 37, (288, 0), 17);
            Add_Conflict (Table.States (741), 37, (285, 1),  0);
            Add_Action (Table.States (741), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (741), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (741), 41, (271, 0), 18);
            Add_Action (Table.States (741), 51, Reduce, (285, 1),  0);
            Add_Action (Table.States (741), 64, (273, 0), 27);
            Add_Action (Table.States (741), 65, (264, 0), 28);
            Add_Action (Table.States (741), 84, (124, 0), 32);
            Add_Action (Table.States (741), 86, (252, 0), 33);
            Add_Action (Table.States (741), 90, (268, 0), 34);
            Add_Action (Table.States (741), 105, (265, 0), 35);
            Add_Action (Table.States (741), 116, (196, 0), 146);
            Add_Action (Table.States (741), 117, (196, 1), 37);
            Add_Action (Table.States (741), 118, (195, 6), 38);
            Table.States (741).Goto_List.Set_Capacity (47);
            Add_Goto (Table.States (741), 124, 39);
            Add_Goto (Table.States (741), 195, 52);
            Add_Goto (Table.States (741), 196, 53);
            Add_Goto (Table.States (741), 197, 54);
            Add_Goto (Table.States (741), 198, 55);
            Add_Goto (Table.States (741), 199, 56);
            Add_Goto (Table.States (741), 201, 57);
            Add_Goto (Table.States (741), 251, 58);
            Add_Goto (Table.States (741), 252, 59);
            Add_Goto (Table.States (741), 255, 60);
            Add_Goto (Table.States (741), 259, 452);
            Add_Goto (Table.States (741), 261, 331);
            Add_Goto (Table.States (741), 262, 62);
            Add_Goto (Table.States (741), 263, 63);
            Add_Goto (Table.States (741), 264, 64);
            Add_Goto (Table.States (741), 265, 65);
            Add_Goto (Table.States (741), 266, 66);
            Add_Goto (Table.States (741), 267, 67);
            Add_Goto (Table.States (741), 268, 68);
            Add_Goto (Table.States (741), 271, 69);
            Add_Goto (Table.States (741), 273, 70);
            Add_Goto (Table.States (741), 275, 71);
            Add_Goto (Table.States (741), 285, 72);
            Add_Goto (Table.States (741), 286, 73);
            Add_Goto (Table.States (741), 287, 1086);
            Add_Goto (Table.States (741), 288, 74);
            Add_Goto (Table.States (741), 289, 75);
            Add_Goto (Table.States (741), 290, 76);
            Add_Goto (Table.States (741), 310, 82);
            Add_Goto (Table.States (741), 311, 83);
            Add_Goto (Table.States (741), 316, 84);
            Add_Goto (Table.States (741), 318, 85);
            Add_Goto (Table.States (741), 357, 110);
            Add_Goto (Table.States (741), 363, 111);
            Add_Goto (Table.States (741), 364, 112);
            Add_Goto (Table.States (741), 365, 113);
            Add_Goto (Table.States (741), 366, 114);
            Add_Goto (Table.States (741), 367, 115);
            Add_Goto (Table.States (741), 370, 116);
            Add_Goto (Table.States (741), 376, 117);
            Add_Goto (Table.States (741), 378, 118);
            Add_Goto (Table.States (741), 379, 119);
            Add_Goto (Table.States (741), 382, 120);
            Add_Goto (Table.States (741), 396, 1087);
            Add_Goto (Table.States (741), 401, 133);
            Add_Goto (Table.States (741), 461, 332);
            Add_Goto (Table.States (741), 462, 144);
            Table.States (741).Kernel := To_Vector ((0 => ((288, 0),  75,  5, (32767, 0),  0)));
            Table.States (741).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (264, 0),  65, 28)));
            Table.States (742).Action_List.Set_Capacity (13);
            Add_Action (Table.States (742), 44, (233, 2), 167);
            Add_Action (Table.States (742), 52, (187, 0), 356);
            Add_Action (Table.States (742), 65, (234, 1), 169);
            Add_Action (Table.States (742), 76, (256, 0), 170);
            Add_Action (Table.States (742), 85, (205, 4), 171);
            Add_Action (Table.States (742), 86, (213, 2), 172);
            Add_Action (Table.States (742), 90, (268, 0), 34);
            Add_Action (Table.States (742), 106, (237, 1), 173);
            Add_Action (Table.States (742), 107, (237, 0), 174);
            Add_Action (Table.States (742), 115, (234, 0), 175);
            Add_Action (Table.States (742), 116, (196, 0), 146);
            Add_Action (Table.States (742), 117, (196, 1), 37);
            Add_Action (Table.States (742), 118, (195, 6), 38);
            Table.States (742).Goto_List.Set_Capacity (33);
            Add_Goto (Table.States (742), 131, 693);
            Add_Goto (Table.States (742), 140, 694);
            Add_Goto (Table.States (742), 160, 1088);
            Add_Goto (Table.States (742), 187, 365);
            Add_Goto (Table.States (742), 195, 366);
            Add_Goto (Table.States (742), 196, 148);
            Add_Goto (Table.States (742), 197, 54);
            Add_Goto (Table.States (742), 198, 55);
            Add_Goto (Table.States (742), 199, 56);
            Add_Goto (Table.States (742), 201, 57);
            Add_Goto (Table.States (742), 203, 369);
            Add_Goto (Table.States (742), 205, 177);
            Add_Goto (Table.States (742), 206, 178);
            Add_Goto (Table.States (742), 210, 179);
            Add_Goto (Table.States (742), 211, 180);
            Add_Goto (Table.States (742), 213, 181);
            Add_Goto (Table.States (742), 214, 182);
            Add_Goto (Table.States (742), 215, 183);
            Add_Goto (Table.States (742), 218, 184);
            Add_Goto (Table.States (742), 219, 185);
            Add_Goto (Table.States (742), 220, 186);
            Add_Goto (Table.States (742), 231, 696);
            Add_Goto (Table.States (742), 232, 190);
            Add_Goto (Table.States (742), 233, 191);
            Add_Goto (Table.States (742), 234, 192);
            Add_Goto (Table.States (742), 237, 193);
            Add_Goto (Table.States (742), 251, 58);
            Add_Goto (Table.States (742), 252, 59);
            Add_Goto (Table.States (742), 255, 60);
            Add_Goto (Table.States (742), 256, 194);
            Add_Goto (Table.States (742), 268, 68);
            Add_Goto (Table.States (742), 311, 83);
            Add_Goto (Table.States (742), 465, 196);
            Table.States (742).Kernel := To_Vector ((0 => ((277, 1),  45,  1, (32767, 0),  0)));
            Table.States (742).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (743).Action_List.Set_Capacity (1);
            Add_Action (Table.States (743), 51, (276, 5), 1089);
            Table.States (743).Kernel := To_Vector ((((276, 5),  87,  4, (32767, 0),  0), ((276, 7),  87,  4, (32767,
            0),  0)));
            Table.States (743).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (276, 5),  51, 1089)));
            Table.States (744).Action_List.Set_Capacity (3);
            Add_Action (Table.States (744), 42, (269, 0), 1090);
            Add_Action (Table.States (744), 47, (271, 2), 1091);
            Add_Action (Table.States (744), 66, (271, 3), 1092);
            Table.States (744).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (744), 269, 1093);
            Add_Goto (Table.States (744), 270, 1094);
            Table.States (744).Kernel := To_Vector ((((271, 0),  259,  11, (32767, 0),  0), ((271, 1),  259,  8,
            (32767, 0),  0), ((271, 2),  259,  6, (32767, 0),  0), ((271, 3),  259,  3, (32767, 0),  0)));
            Table.States (744).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (271, 3),  66, 1092)));
            Table.States (745).Action_List.Set_Capacity (2);
            Add_Action (Table.States (745), 95, (331, 1), 464);
            Add_Action (Table.States (745), 108, (333, 0), 1095);
            Table.States (745).Kernel := To_Vector ((((331, 1),  331,  2, (32767, 0),  0), ((333, 0),  331,  1, (32767,
            0),  0)));
            Table.States (745).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (333, 0),  108, 1095)));
            Table.States (746).Action_List.Set_Capacity (43);
            Add_Action (Table.States (746), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (333, 1),  4);
            Table.States (746).Kernel := To_Vector ((0 => ((333, 1),  108,  0, (333, 1),  4)));
            Table.States (746).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (333, 1),  4)));
            Table.States (747).Action_List.Set_Capacity (6);
            Add_Action (Table.States (747), 85, (198, 0), 281);
            Add_Action (Table.States (747), 95, Reduce, (331, 1),  3);
            Add_Action (Table.States (747), 96, (197, 0), 283);
            Add_Action (Table.States (747), 108, Reduce, (331, 1),  3);
            Add_Action (Table.States (747), 113, (121, 0), 285);
            Add_Action (Table.States (747), 114, (121, 1), 286);
            Table.States (747).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (747), 121, 287);
            Add_Goto (Table.States (747), 313, 289);
            Table.States (747).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((331, 1),  195,  0, (331, 1),  3)));
            Table.States (747).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (331, 1),  3)));
            Table.States (748).Action_List.Set_Capacity (1);
            Add_Action (Table.States (748), (1 =>  69), (283, 1),  3);
            Table.States (748).Kernel := To_Vector ((0 => ((283, 1),  87,  0, (283, 1),  3)));
            Table.States (748).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (283, 1),  3)));
            Table.States (749).Action_List.Set_Capacity (10);
            Add_Action (Table.States (749), 29, (301, 3), 711);
            Add_Action (Table.States (749), 45, (301, 0), 712);
            Add_Action (Table.States (749), 52, (187, 0), 347);
            Add_Conflict (Table.States (749), 52, (301, 1),  0);
            Add_Action (Table.States (749), 56, (188, 2), 514);
            Add_Action (Table.States (749), 80, (300, 0), 1096);
            Add_Action (Table.States (749), 86, Reduce, (301, 1),  0);
            Add_Action (Table.States (749), 90, Reduce, (301, 1),  0);
            Add_Action (Table.States (749), 116, Reduce, (301, 1),  0);
            Add_Action (Table.States (749), 117, Reduce, (301, 1),  0);
            Add_Action (Table.States (749), 118, Reduce, (301, 1),  0);
            Table.States (749).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (749), 187, 1097);
            Add_Goto (Table.States (749), 188, 1098);
            Add_Goto (Table.States (749), 301, 1099);
            Table.States (749).Kernel := To_Vector ((((300, 0),  93,  6, (32767, 0),  0), ((300, 1),  93,  4, (32767,
            0),  0), ((300, 2),  93,  4, (32767, 0),  0), ((300, 3),  93,  2, (32767, 0),  0), ((300, 4),  93,  5,
            (32767, 0),  0), ((300, 5),  93,  3, (32767, 0),  0), ((300, 6),  93,  3, (32767, 0),  0), ((300, 7),  93,
            1, (32767, 0),  0), ((300, 8),  93,  4, (32767, 0),  0), ((300, 9),  93,  2, (32767, 0),  0)));
            Table.States (749).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (301, 1),  0)));
            Table.States (750).Action_List.Set_Capacity (12);
            Add_Action (Table.States (750), (24, 30, 33, 45, 48, 61, 63, 69, 82, 87, 94, 108), (299, 0),  3);
            Table.States (750).Kernel := To_Vector ((0 => ((299, 0),  87,  0, (299, 0),  3)));
            Table.States (750).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (299, 0),  3)));
            Table.States (751).Action_List.Set_Capacity (1);
            Add_Action (Table.States (751), 116, (136, 0), 207);
            Table.States (751).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (751), 136, 688);
            Add_Goto (Table.States (751), 298, 1100);
            Add_Goto (Table.States (751), 300, 1101);
            Table.States (751).Kernel := To_Vector ((((298, 1),  108,  3, (32767, 0),  0), ((298, 2),  108,  3, (32767,
            0),  0)));
            Table.States (752).Action_List.Set_Capacity (13);
            Add_Action (Table.States (752), 44, (233, 2), 167);
            Add_Action (Table.States (752), 52, (187, 0), 356);
            Add_Action (Table.States (752), 65, (234, 1), 169);
            Add_Action (Table.States (752), 76, (256, 0), 170);
            Add_Action (Table.States (752), 85, (205, 4), 171);
            Add_Action (Table.States (752), 86, (213, 2), 172);
            Add_Action (Table.States (752), 90, (268, 0), 34);
            Add_Action (Table.States (752), 106, (237, 1), 173);
            Add_Action (Table.States (752), 107, (237, 0), 174);
            Add_Action (Table.States (752), 115, (234, 0), 175);
            Add_Action (Table.States (752), 116, (196, 0), 146);
            Add_Action (Table.States (752), 117, (196, 1), 37);
            Add_Action (Table.States (752), 118, (195, 6), 38);
            Table.States (752).Goto_List.Set_Capacity (33);
            Add_Goto (Table.States (752), 131, 693);
            Add_Goto (Table.States (752), 140, 694);
            Add_Goto (Table.States (752), 160, 1102);
            Add_Goto (Table.States (752), 187, 365);
            Add_Goto (Table.States (752), 195, 1103);
            Add_Goto (Table.States (752), 196, 148);
            Add_Goto (Table.States (752), 197, 54);
            Add_Goto (Table.States (752), 198, 55);
            Add_Goto (Table.States (752), 199, 56);
            Add_Goto (Table.States (752), 201, 57);
            Add_Goto (Table.States (752), 203, 369);
            Add_Goto (Table.States (752), 205, 177);
            Add_Goto (Table.States (752), 206, 178);
            Add_Goto (Table.States (752), 210, 179);
            Add_Goto (Table.States (752), 211, 180);
            Add_Goto (Table.States (752), 213, 181);
            Add_Goto (Table.States (752), 214, 182);
            Add_Goto (Table.States (752), 215, 183);
            Add_Goto (Table.States (752), 218, 184);
            Add_Goto (Table.States (752), 219, 185);
            Add_Goto (Table.States (752), 220, 186);
            Add_Goto (Table.States (752), 231, 696);
            Add_Goto (Table.States (752), 232, 190);
            Add_Goto (Table.States (752), 233, 191);
            Add_Goto (Table.States (752), 234, 192);
            Add_Goto (Table.States (752), 237, 193);
            Add_Goto (Table.States (752), 251, 58);
            Add_Goto (Table.States (752), 252, 59);
            Add_Goto (Table.States (752), 255, 60);
            Add_Goto (Table.States (752), 256, 194);
            Add_Goto (Table.States (752), 268, 68);
            Add_Goto (Table.States (752), 311, 83);
            Add_Goto (Table.States (752), 465, 196);
            Table.States (752).Kernel := To_Vector ((((278, 0),  34,  3, (32767, 0),  0), ((278, 1),  34,  1, (32767,
            0),  0), ((280, 4),  34,  3, (32767, 0),  0), ((280, 5),  34,  1, (32767, 0),  0)));
            Table.States (752).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (753).Action_List.Set_Capacity (4);
            Add_Action (Table.States (753), 36, Reduce, (278, 3),  3);
            Add_Action (Table.States (753), 50, Reduce, (278, 3),  3);
            Add_Action (Table.States (753), 63, (279, 0), 1104);
            Add_Action (Table.States (753), 99, Reduce, (278, 3),  3);
            Table.States (753).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (753), 279, 1105);
            Table.States (753).Kernel := To_Vector ((((278, 2),  160,  2, (32767, 0),  0), ((278, 3),  160,  0, (278,
            3),  3)));
            Table.States (753).Minimal_Complete_Actions := To_Vector (((Shift, (279, 0),  63, 1104), (Reduce, (278, 3),
             3)));
            Table.States (754).Action_List.Set_Capacity (20);
            Add_Action (Table.States (754), 36, Reduce, (131, 3),  1);
            Add_Conflict (Table.States (754), 36, (280, 7),  3);
            Add_Action (Table.States (754), 43, Reduce, (234, 3),  1);
            Add_Action (Table.States (754), 50, Reduce, (131, 3),  1);
            Add_Conflict (Table.States (754), 50, (280, 7),  3);
            Add_Action (Table.States (754), 63, (279, 0), 1104);
            Add_Conflict (Table.States (754), 63, (131, 3),  1);
            Add_Action (Table.States (754), 71, (453, 0), 635);
            Add_Action (Table.States (754), 72, (153, 0), 636);
            Add_Action (Table.States (754), 73, Reduce, (234, 3),  1);
            Add_Action (Table.States (754), 74, (139, 0), 637);
            Add_Action (Table.States (754), 85, (162, 0), 612);
            Add_Action (Table.States (754), 89, Reduce, (234, 3),  1);
            Add_Action (Table.States (754), 96, (197, 0), 283);
            Add_Action (Table.States (754), 97, Reduce, (234, 3),  1);
            Add_Action (Table.States (754), 99, Reduce, (131, 3),  1);
            Add_Conflict (Table.States (754), 99, (280, 7),  3);
            Add_Action (Table.States (754), 106, Reduce, (234, 3),  1);
            Add_Action (Table.States (754), 107, Reduce, (234, 3),  1);
            Add_Action (Table.States (754), 109, Reduce, (234, 3),  1);
            Add_Action (Table.States (754), 111, Reduce, (234, 3),  1);
            Add_Action (Table.States (754), 112, Reduce, (234, 3),  1);
            Add_Action (Table.States (754), 113, (121, 0), 285);
            Add_Action (Table.States (754), 114, (121, 1), 286);
            Table.States (754).Goto_List.Set_Capacity (9);
            Add_Goto (Table.States (754), 121, 638);
            Add_Goto (Table.States (754), 132, 639);
            Add_Goto (Table.States (754), 133, 640);
            Add_Goto (Table.States (754), 139, 641);
            Add_Goto (Table.States (754), 153, 642);
            Add_Goto (Table.States (754), 162, 643);
            Add_Goto (Table.States (754), 279, 1106);
            Add_Goto (Table.States (754), 313, 289);
            Add_Goto (Table.States (754), 453, 644);
            Table.States (754).Kernel := To_Vector ((((131, 2),  195,  2, (32767, 0),  0), ((131, 3),  195,  0, (131,
            3),  1), ((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767, 0),  0), ((199, 0),  195,  2,
            (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((203, 0),  195,  2, (32767, 0),  0), ((234, 3),
            195,  0, (234, 3),  1), ((255, 0),  195,  3, (32767, 0),  0), ((280, 6),  195,  2, (32767, 0),  0), ((280,
            7),  195,  0, (280, 7),  3), ((311, 0),  195,  3, (32767, 0),  0)));
            Table.States (754).Minimal_Complete_Actions := To_Vector (((Reduce, (131, 3),  1), (Reduce, (234, 3),  1),
            (Shift, (279, 0),  63, 1104), (Reduce, (280, 7),  3)));
            Table.States (755).Action_List.Set_Capacity (5);
            Add_Action (Table.States (755), 86, (252, 0), 33);
            Add_Action (Table.States (755), 90, (268, 0), 34);
            Add_Action (Table.States (755), 116, (196, 0), 146);
            Add_Action (Table.States (755), 117, (196, 1), 37);
            Add_Action (Table.States (755), 118, (195, 6), 38);
            Table.States (755).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (755), 195, 1107);
            Add_Goto (Table.States (755), 196, 148);
            Add_Goto (Table.States (755), 197, 54);
            Add_Goto (Table.States (755), 198, 55);
            Add_Goto (Table.States (755), 199, 56);
            Add_Goto (Table.States (755), 201, 57);
            Add_Goto (Table.States (755), 251, 58);
            Add_Goto (Table.States (755), 252, 59);
            Add_Goto (Table.States (755), 255, 60);
            Add_Goto (Table.States (755), 268, 68);
            Add_Goto (Table.States (755), 311, 83);
            Table.States (755).Kernel := To_Vector ((((280, 12),  34,  3, (32767, 0),  0), ((280, 13),  34,  1, (32767,
            0),  0)));
            Table.States (755).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (756).Action_List.Set_Capacity (8);
            Add_Action (Table.States (756), 36, Reduce, (280, 15),  3);
            Add_Action (Table.States (756), 50, Reduce, (280, 15),  3);
            Add_Action (Table.States (756), 63, (279, 0), 1104);
            Add_Action (Table.States (756), 85, (198, 0), 281);
            Add_Action (Table.States (756), 96, (197, 0), 283);
            Add_Action (Table.States (756), 99, Reduce, (280, 15),  3);
            Add_Action (Table.States (756), 113, (121, 0), 285);
            Add_Action (Table.States (756), 114, (121, 1), 286);
            Table.States (756).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (756), 121, 287);
            Add_Goto (Table.States (756), 279, 1108);
            Add_Goto (Table.States (756), 313, 289);
            Table.States (756).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((280, 14),  195,  2, (32767, 0),  0), ((280, 15),  195,  0, (280, 15),  3), ((311, 0),
            195,  3, (32767, 0),  0)));
            Table.States (756).Minimal_Complete_Actions := To_Vector (((Shift, (279, 0),  63, 1104), (Reduce, (280,
            15),  3)));
         end Subr_31;
         procedure Subr_32
         is begin
            Table.States (757).Action_List.Set_Capacity (2);
            Add_Action (Table.States (757), (45, 69), (281, 0),  1);
            Table.States (757).Kernel := To_Vector ((0 => ((281, 0),  131,  0, (281, 0),  1)));
            Table.States (757).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (281, 0),  1)));
            Table.States (758).Action_List.Set_Capacity (2);
            Add_Action (Table.States (758), (45, 69), (281, 1),  1);
            Table.States (758).Kernel := To_Vector ((0 => ((281, 1),  188,  0, (281, 1),  1)));
            Table.States (758).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (281, 1),  1)));
            Table.States (759).Action_List.Set_Capacity (2);
            Add_Action (Table.States (759), 45, (280, 0), 1109);
            Add_Action (Table.States (759), 69, (280, 8), 1110);
            Table.States (759).Kernel := To_Vector ((((280, 0),  281,  5, (32767, 0),  0), ((280, 1),  281,  3, (32767,
            0),  0), ((280, 2),  281,  4, (32767, 0),  0), ((280, 3),  281,  2, (32767, 0),  0), ((280, 8),  281,  5,
            (32767, 0),  0), ((280, 9),  281,  3, (32767, 0),  0), ((280, 10),  281,  4, (32767, 0),  0), ((280, 11),
            281,  2, (32767, 0),  0)));
            Table.States (759).Minimal_Complete_Actions := To_Vector (((Shift, (280, 0),  45, 1109), (Shift, (280, 8),
            69, 1110)));
            Table.States (760).Action_List.Set_Capacity (7);
            Add_Action (Table.States (760), 11, (455, 0), 1111);
            Add_Action (Table.States (760), 66, (440, 6), 1112);
            Add_Action (Table.States (760), 86, (252, 0), 33);
            Add_Action (Table.States (760), 90, (268, 0), 34);
            Add_Action (Table.States (760), 116, (196, 0), 146);
            Add_Action (Table.States (760), 117, (196, 1), 37);
            Add_Action (Table.States (760), 118, (195, 6), 38);
            Table.States (760).Goto_List.Set_Capacity (14);
            Add_Goto (Table.States (760), 195, 1113);
            Add_Goto (Table.States (760), 196, 148);
            Add_Goto (Table.States (760), 197, 54);
            Add_Goto (Table.States (760), 198, 55);
            Add_Goto (Table.States (760), 199, 56);
            Add_Goto (Table.States (760), 201, 57);
            Add_Goto (Table.States (760), 251, 58);
            Add_Goto (Table.States (760), 252, 59);
            Add_Goto (Table.States (760), 255, 60);
            Add_Goto (Table.States (760), 268, 68);
            Add_Goto (Table.States (760), 311, 83);
            Add_Goto (Table.States (760), 441, 1114);
            Add_Goto (Table.States (760), 455, 1115);
            Add_Goto (Table.States (760), 466, 1116);
            Table.States (760).Kernel := To_Vector ((((440, 0),  67,  16, (32767, 0),  0), ((440, 1),  67,  15, (32767,
            0),  0), ((440, 2),  67,  8, (32767, 0),  0), ((440, 3),  67,  7, (32767, 0),  0), ((440, 4),  67,  12,
            (32767, 0),  0), ((440, 5),  67,  11, (32767, 0),  0), ((440, 6),  67,  4, (32767, 0),  0), ((440, 7),  67,
             3, (32767, 0),  0)));
            Table.States (760).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (440, 6),  66, 1112)));
            Table.States (761).Action_List.Set_Capacity (16);
            Add_Action (Table.States (761), 12, (402, 0), 165);
            Add_Action (Table.States (761), 44, (233, 2), 167);
            Add_Action (Table.States (761), 51, (221, 0), 273);
            Add_Action (Table.States (761), 52, (187, 0), 356);
            Add_Action (Table.States (761), 62, (178, 3), 385);
            Add_Action (Table.States (761), 65, (234, 1), 169);
            Add_Action (Table.States (761), 76, (256, 0), 170);
            Add_Action (Table.States (761), 85, (205, 4), 171);
            Add_Action (Table.States (761), 86, (213, 2), 172);
            Add_Action (Table.States (761), 90, (268, 0), 34);
            Add_Action (Table.States (761), 106, (237, 1), 173);
            Add_Action (Table.States (761), 107, (237, 0), 174);
            Add_Action (Table.States (761), 115, (234, 0), 175);
            Add_Action (Table.States (761), 116, (196, 0), 146);
            Add_Action (Table.States (761), 117, (196, 1), 37);
            Add_Action (Table.States (761), 118, (195, 6), 38);
            Table.States (761).Goto_List.Set_Capacity (41);
            Add_Goto (Table.States (761), 131, 361);
            Add_Goto (Table.States (761), 140, 362);
            Add_Goto (Table.States (761), 177, 363);
            Add_Goto (Table.States (761), 178, 364);
            Add_Goto (Table.States (761), 187, 365);
            Add_Goto (Table.States (761), 195, 366);
            Add_Goto (Table.States (761), 196, 148);
            Add_Goto (Table.States (761), 197, 54);
            Add_Goto (Table.States (761), 198, 55);
            Add_Goto (Table.States (761), 199, 56);
            Add_Goto (Table.States (761), 201, 57);
            Add_Goto (Table.States (761), 203, 369);
            Add_Goto (Table.States (761), 205, 177);
            Add_Goto (Table.States (761), 206, 178);
            Add_Goto (Table.States (761), 210, 179);
            Add_Goto (Table.States (761), 211, 180);
            Add_Goto (Table.States (761), 212, 373);
            Add_Goto (Table.States (761), 213, 181);
            Add_Goto (Table.States (761), 214, 182);
            Add_Goto (Table.States (761), 215, 183);
            Add_Goto (Table.States (761), 216, 374);
            Add_Goto (Table.States (761), 217, 375);
            Add_Goto (Table.States (761), 218, 184);
            Add_Goto (Table.States (761), 219, 185);
            Add_Goto (Table.States (761), 220, 186);
            Add_Goto (Table.States (761), 221, 376);
            Add_Goto (Table.States (761), 227, 1117);
            Add_Goto (Table.States (761), 228, 188);
            Add_Goto (Table.States (761), 231, 378);
            Add_Goto (Table.States (761), 232, 190);
            Add_Goto (Table.States (761), 233, 191);
            Add_Goto (Table.States (761), 234, 192);
            Add_Goto (Table.States (761), 237, 193);
            Add_Goto (Table.States (761), 251, 58);
            Add_Goto (Table.States (761), 252, 59);
            Add_Goto (Table.States (761), 255, 60);
            Add_Goto (Table.States (761), 256, 194);
            Add_Goto (Table.States (761), 268, 68);
            Add_Goto (Table.States (761), 311, 83);
            Add_Goto (Table.States (761), 402, 195);
            Add_Goto (Table.States (761), 465, 196);
            Table.States (761).Kernel := To_Vector ((((213, 0),  85,  2, (32767, 0),  0), ((213, 1),  85,  6, (32767,
            0),  0), ((215, 0),  85,  4, (32767, 0),  0)));
            Table.States (761).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (762).Action_List.Set_Capacity (17);
            Add_Action (Table.States (762), 12, (402, 0), 165);
            Add_Action (Table.States (762), 44, (233, 2), 167);
            Add_Action (Table.States (762), 51, (221, 0), 273);
            Add_Action (Table.States (762), 52, (187, 0), 356);
            Add_Action (Table.States (762), 62, (178, 3), 385);
            Add_Action (Table.States (762), 65, (234, 1), 169);
            Add_Action (Table.States (762), 76, (256, 0), 170);
            Add_Action (Table.States (762), 85, (205, 4), 171);
            Add_Action (Table.States (762), 86, (213, 2), 172);
            Add_Action (Table.States (762), 88, (214, 0), 386);
            Add_Action (Table.States (762), 90, (268, 0), 34);
            Add_Action (Table.States (762), 106, (237, 1), 173);
            Add_Action (Table.States (762), 107, (237, 0), 174);
            Add_Action (Table.States (762), 115, (234, 0), 175);
            Add_Action (Table.States (762), 116, (196, 0), 146);
            Add_Action (Table.States (762), 117, (196, 1), 37);
            Add_Action (Table.States (762), 118, (195, 6), 38);
            Table.States (762).Goto_List.Set_Capacity (41);
            Add_Goto (Table.States (762), 131, 361);
            Add_Goto (Table.States (762), 140, 362);
            Add_Goto (Table.States (762), 177, 363);
            Add_Goto (Table.States (762), 178, 364);
            Add_Goto (Table.States (762), 187, 365);
            Add_Goto (Table.States (762), 195, 366);
            Add_Goto (Table.States (762), 196, 148);
            Add_Goto (Table.States (762), 197, 54);
            Add_Goto (Table.States (762), 198, 55);
            Add_Goto (Table.States (762), 199, 56);
            Add_Goto (Table.States (762), 201, 57);
            Add_Goto (Table.States (762), 203, 369);
            Add_Goto (Table.States (762), 205, 177);
            Add_Goto (Table.States (762), 206, 178);
            Add_Goto (Table.States (762), 210, 179);
            Add_Goto (Table.States (762), 211, 180);
            Add_Goto (Table.States (762), 212, 387);
            Add_Goto (Table.States (762), 213, 181);
            Add_Goto (Table.States (762), 214, 182);
            Add_Goto (Table.States (762), 215, 183);
            Add_Goto (Table.States (762), 216, 388);
            Add_Goto (Table.States (762), 217, 375);
            Add_Goto (Table.States (762), 218, 184);
            Add_Goto (Table.States (762), 219, 185);
            Add_Goto (Table.States (762), 220, 186);
            Add_Goto (Table.States (762), 221, 376);
            Add_Goto (Table.States (762), 227, 1117);
            Add_Goto (Table.States (762), 228, 188);
            Add_Goto (Table.States (762), 231, 378);
            Add_Goto (Table.States (762), 232, 190);
            Add_Goto (Table.States (762), 233, 191);
            Add_Goto (Table.States (762), 234, 192);
            Add_Goto (Table.States (762), 237, 193);
            Add_Goto (Table.States (762), 251, 58);
            Add_Goto (Table.States (762), 252, 59);
            Add_Goto (Table.States (762), 255, 60);
            Add_Goto (Table.States (762), 256, 194);
            Add_Goto (Table.States (762), 268, 68);
            Add_Goto (Table.States (762), 311, 83);
            Add_Goto (Table.States (762), 402, 195);
            Add_Goto (Table.States (762), 465, 196);
            Table.States (762).Kernel := To_Vector ((((213, 2),  86,  6, (32767, 0),  0), ((213, 3),  86,  2, (32767,
            0),  0), ((214, 0),  86,  1, (32767, 0),  0), ((215, 1),  86,  4, (32767, 0),  0)));
            Table.States (762).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (214, 0),  88, 386)));
            Table.States (763).Action_List.Set_Capacity (1);
            Add_Action (Table.States (763), (1 =>  108), (439, 0),  1);
            Table.States (763).Kernel := To_Vector ((0 => ((439, 0),  211,  0, (439, 0),  1)));
            Table.States (763).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (439, 0),  1)));
            Table.States (764).Action_List.Set_Capacity (1);
            Add_Action (Table.States (764), 108, (438, 0), 1118);
            Table.States (764).Kernel := To_Vector ((0 => ((438, 0),  439,  1, (32767, 0),  0)));
            Table.States (764).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (438, 0),  108, 1118)));
            Table.States (765).Action_List.Set_Capacity (5);
            Add_Action (Table.States (765), 50, (437, 0), 1119);
            Add_Conflict (Table.States (765), 50, (201, 0),  3);
            Add_Action (Table.States (765), 85, Reduce, (201, 0),  3);
            Add_Action (Table.States (765), 96, Reduce, (201, 0),  3);
            Add_Action (Table.States (765), 113, Reduce, (201, 0),  3);
            Add_Action (Table.States (765), 114, Reduce, (201, 0),  3);
            Table.States (765).Kernel := To_Vector ((((201, 0),  202,  0, (201, 0),  3), ((437, 0),  202,  3, (32767,
            0),  0)));
            Table.States (765).Minimal_Complete_Actions := To_Vector (((Reduce, (201, 0),  3), (Shift, (437, 0),  50,
            1119)));
            Table.States (766).Action_List.Set_Capacity (14);
            Add_Action (Table.States (766), 12, (402, 0), 165);
            Add_Action (Table.States (766), 44, (233, 2), 167);
            Add_Action (Table.States (766), 52, (233, 3), 168);
            Add_Action (Table.States (766), 65, (234, 1), 169);
            Add_Action (Table.States (766), 76, (256, 0), 170);
            Add_Action (Table.States (766), 85, (205, 4), 171);
            Add_Action (Table.States (766), 86, (213, 2), 172);
            Add_Action (Table.States (766), 90, (268, 0), 34);
            Add_Action (Table.States (766), 106, (237, 1), 173);
            Add_Action (Table.States (766), 107, (237, 0), 174);
            Add_Action (Table.States (766), 115, (234, 0), 175);
            Add_Action (Table.States (766), 116, (196, 0), 146);
            Add_Action (Table.States (766), 117, (196, 1), 37);
            Add_Action (Table.States (766), 118, (195, 6), 38);
            Table.States (766).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (766), 195, 176);
            Add_Goto (Table.States (766), 196, 148);
            Add_Goto (Table.States (766), 197, 54);
            Add_Goto (Table.States (766), 198, 55);
            Add_Goto (Table.States (766), 199, 56);
            Add_Goto (Table.States (766), 201, 57);
            Add_Goto (Table.States (766), 205, 177);
            Add_Goto (Table.States (766), 206, 178);
            Add_Goto (Table.States (766), 210, 179);
            Add_Goto (Table.States (766), 211, 180);
            Add_Goto (Table.States (766), 213, 181);
            Add_Goto (Table.States (766), 214, 182);
            Add_Goto (Table.States (766), 215, 183);
            Add_Goto (Table.States (766), 218, 184);
            Add_Goto (Table.States (766), 219, 185);
            Add_Goto (Table.States (766), 220, 186);
            Add_Goto (Table.States (766), 227, 1120);
            Add_Goto (Table.States (766), 228, 188);
            Add_Goto (Table.States (766), 231, 189);
            Add_Goto (Table.States (766), 232, 190);
            Add_Goto (Table.States (766), 233, 191);
            Add_Goto (Table.States (766), 234, 192);
            Add_Goto (Table.States (766), 237, 193);
            Add_Goto (Table.States (766), 251, 58);
            Add_Goto (Table.States (766), 252, 59);
            Add_Goto (Table.States (766), 255, 60);
            Add_Goto (Table.States (766), 256, 194);
            Add_Goto (Table.States (766), 268, 68);
            Add_Goto (Table.States (766), 311, 83);
            Add_Goto (Table.States (766), 402, 195);
            Add_Goto (Table.States (766), 465, 196);
            Table.States (766).Kernel := To_Vector ((0 => ((454, 0),  11,  2, (32767, 0),  0)));
            Table.States (766).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (767).Action_List.Set_Capacity (4);
            Add_Action (Table.States (767), 85, (198, 0), 281);
            Add_Action (Table.States (767), 96, (197, 0), 283);
            Add_Action (Table.States (767), 113, (121, 0), 285);
            Add_Action (Table.States (767), 114, (121, 1), 286);
            Table.States (767).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (767), 121, 287);
            Add_Goto (Table.States (767), 313, 289);
            Table.States (767).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0)));
            Table.States (768).Action_List.Set_Capacity (6);
            Add_Action (Table.States (768), 36, Reduce, (282, 1),  3);
            Add_Action (Table.States (768), 63, (279, 0), 1104);
            Add_Action (Table.States (768), 85, Reduce, (195, 5),  1);
            Add_Action (Table.States (768), 96, Reduce, (195, 5),  1);
            Add_Action (Table.States (768), 113, Reduce, (195, 5),  1);
            Add_Action (Table.States (768), 114, Reduce, (195, 5),  1);
            Table.States (768).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (768), 279, 1121);
            Table.States (768).Kernel := To_Vector ((((195, 5),  311,  0, (195, 5),  1), ((282, 0),  311,  2, (32767,
            0),  0), ((282, 1),  311,  0, (282, 1),  3)));
            Table.States (768).Minimal_Complete_Actions := To_Vector (((Reduce, (195, 5),  1), (Shift, (279, 0),  63,
            1104), (Reduce, (282, 1),  3)));
            Table.States (769).Action_List.Set_Capacity (6);
            Add_Action (Table.States (769), 56, (188, 0), 880);
            Add_Action (Table.States (769), 86, (252, 0), 33);
            Add_Action (Table.States (769), 90, (268, 0), 34);
            Add_Action (Table.States (769), 116, (196, 0), 146);
            Add_Action (Table.States (769), 117, (196, 1), 37);
            Add_Action (Table.States (769), 118, (195, 6), 38);
            Table.States (769).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (769), 195, 1122);
            Add_Goto (Table.States (769), 196, 148);
            Add_Goto (Table.States (769), 197, 54);
            Add_Goto (Table.States (769), 198, 55);
            Add_Goto (Table.States (769), 199, 56);
            Add_Goto (Table.States (769), 201, 57);
            Add_Goto (Table.States (769), 251, 58);
            Add_Goto (Table.States (769), 252, 59);
            Add_Goto (Table.States (769), 255, 60);
            Add_Goto (Table.States (769), 268, 68);
            Add_Goto (Table.States (769), 311, 83);
            Table.States (769).Kernel := To_Vector ((((188, 0),  187,  3, (32767, 0),  0), ((188, 1),  187,  2, (32767,
            0),  0), ((188, 4),  187,  3, (32767, 0),  0), ((188, 5),  187,  2, (32767, 0),  0), ((188, 8),  187,  5,
            (32767, 0),  0), ((188, 9),  187,  4, (32767, 0),  0), ((296, 0),  187,  1, (32767, 0),  0)));
            Table.States (769).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (770).Action_List.Set_Capacity (10);
            Add_Action (Table.States (770), (24, 33, 45, 48, 61, 69, 82, 87, 94, 108), (296, 2),  2);
            Table.States (770).Kernel := To_Vector ((0 => ((296, 2),  188,  0, (296, 2),  2)));
            Table.States (770).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (296, 2),  2)));
            Table.States (771).Action_List.Set_Capacity (14);
            Add_Action (Table.States (771), 24, Reduce, (296, 1),  2);
            Add_Action (Table.States (771), 33, Reduce, (296, 1),  2);
            Add_Action (Table.States (771), 45, Reduce, (296, 1),  2);
            Add_Action (Table.States (771), 48, Reduce, (296, 1),  2);
            Add_Action (Table.States (771), 61, Reduce, (296, 1),  2);
            Add_Action (Table.States (771), 69, Reduce, (296, 1),  2);
            Add_Action (Table.States (771), 82, Reduce, (296, 1),  2);
            Add_Action (Table.States (771), 85, (198, 0), 281);
            Add_Action (Table.States (771), 87, Reduce, (296, 1),  2);
            Add_Action (Table.States (771), 94, Reduce, (296, 1),  2);
            Add_Action (Table.States (771), 96, (197, 0), 283);
            Add_Action (Table.States (771), 108, Reduce, (296, 1),  2);
            Add_Action (Table.States (771), 113, (121, 0), 285);
            Add_Action (Table.States (771), 114, (121, 1), 286);
            Table.States (771).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (771), 121, 287);
            Add_Goto (Table.States (771), 313, 289);
            Table.States (771).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((296, 1),  195,  0, (296, 1),  2), ((311, 0),  195,  3, (32767, 0),  0)));
            Table.States (771).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (296, 1),  2)));
            Table.States (772).Action_List.Set_Capacity (5);
            Add_Action (Table.States (772), 86, (252, 0), 33);
            Add_Action (Table.States (772), 90, (268, 0), 34);
            Add_Action (Table.States (772), 116, (196, 0), 146);
            Add_Action (Table.States (772), 117, (196, 1), 37);
            Add_Action (Table.States (772), 118, (195, 6), 38);
            Table.States (772).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (772), 195, 1123);
            Add_Goto (Table.States (772), 196, 148);
            Add_Goto (Table.States (772), 197, 54);
            Add_Goto (Table.States (772), 198, 55);
            Add_Goto (Table.States (772), 199, 56);
            Add_Goto (Table.States (772), 201, 57);
            Add_Goto (Table.States (772), 251, 58);
            Add_Goto (Table.States (772), 252, 59);
            Add_Goto (Table.States (772), 255, 60);
            Add_Goto (Table.States (772), 268, 68);
            Add_Goto (Table.States (772), 311, 83);
            Table.States (772).Kernel := To_Vector ((((408, 8),  76,  4, (32767, 0),  0), ((408, 9),  76,  2, (32767,
            0),  0)));
            Table.States (772).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (773).Action_List.Set_Capacity (10);
            Add_Action (Table.States (773), (24, 33, 45, 48, 61, 69, 82, 87, 94, 108), (297, 0),  2);
            Table.States (773).Kernel := To_Vector ((0 => ((297, 0),  296,  0, (297, 0),  2)));
            Table.States (773).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (297, 0),  2)));
            Table.States (774).Action_List.Set_Capacity (5);
            Add_Action (Table.States (774), 86, (252, 0), 33);
            Add_Action (Table.States (774), 90, (268, 0), 34);
            Add_Action (Table.States (774), 116, (196, 0), 146);
            Add_Action (Table.States (774), 117, (196, 1), 37);
            Add_Action (Table.States (774), 118, (195, 6), 38);
            Table.States (774).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (774), 195, 1124);
            Add_Goto (Table.States (774), 196, 148);
            Add_Goto (Table.States (774), 197, 54);
            Add_Goto (Table.States (774), 198, 55);
            Add_Goto (Table.States (774), 199, 56);
            Add_Goto (Table.States (774), 201, 57);
            Add_Goto (Table.States (774), 251, 58);
            Add_Goto (Table.States (774), 252, 59);
            Add_Goto (Table.States (774), 255, 60);
            Add_Goto (Table.States (774), 268, 68);
            Add_Goto (Table.States (774), 311, 83);
            Table.States (774).Kernel := To_Vector ((((408, 4),  76,  4, (32767, 0),  0), ((408, 5),  76,  2, (32767,
            0),  0)));
            Table.States (774).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (775).Action_List.Set_Capacity (8);
            Add_Action (Table.States (775), 13, (392, 0), 1125);
            Add_Action (Table.States (775), 21, (359, 0), 1126);
            Add_Action (Table.States (775), 25, (329, 1), 10);
            Add_Action (Table.States (775), 51, (437, 0), 221);
            Add_Action (Table.States (775), 52, (329, 0), 21);
            Add_Action (Table.States (775), 53, (294, 0), 314);
            Add_Action (Table.States (775), 54, (293, 0), 315);
            Add_Action (Table.States (775), 66, (354, 3), 1127);
            Table.States (775).Goto_List.Set_Capacity (16);
            Add_Goto (Table.States (775), 291, 1128);
            Add_Goto (Table.States (775), 292, 1129);
            Add_Goto (Table.States (775), 293, 79);
            Add_Goto (Table.States (775), 294, 80);
            Add_Goto (Table.States (775), 309, 1130);
            Add_Goto (Table.States (775), 320, 1131);
            Add_Goto (Table.States (775), 321, 1132);
            Add_Goto (Table.States (775), 329, 1133);
            Add_Goto (Table.States (775), 353, 1134);
            Add_Goto (Table.States (775), 355, 1135);
            Add_Goto (Table.States (775), 359, 1136);
            Add_Goto (Table.States (775), 431, 1137);
            Add_Goto (Table.States (775), 437, 140);
            Add_Goto (Table.States (775), 438, 141);
            Add_Goto (Table.States (775), 440, 142);
            Add_Goto (Table.States (775), 454, 143);
            Table.States (775).Kernel := To_Vector ((((354, 2),  82,  5, (32767, 0),  0), ((354, 3),  82,  2, (32767,
            0),  0), ((392, 0),  82,  4, (32767, 0),  0), ((392, 1),  82,  2, (32767, 0),  0)));
            Table.States (775).Minimal_Complete_Actions := To_Vector (((Shift, (354, 3),  66, 1127), (Shift, (392, 0),
            13, 1125)));
         end Subr_32;
         procedure Subr_33
         is begin
            Table.States (776).Action_List.Set_Capacity (1);
            Add_Action (Table.States (776), 82, (354, 0), 1138);
            Table.States (776).Kernel := To_Vector ((((354, 0),  434,  6, (32767, 0),  0), ((354, 1),  434,  3, (32767,
            0),  0)));
            Table.States (776).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (354, 0),  82, 1138)));
            Table.States (777).Action_List.Set_Capacity (10);
            Add_Action (Table.States (777), 21, (356, 4), 8);
            Add_Action (Table.States (777), 25, (329, 1), 10);
            Add_Action (Table.States (777), 27, (350, 6), 781);
            Add_Action (Table.States (777), 51, (437, 0), 221);
            Add_Action (Table.States (777), 52, (329, 0), 21);
            Add_Action (Table.States (777), 53, (294, 0), 314);
            Add_Action (Table.States (777), 54, (293, 0), 315);
            Add_Action (Table.States (777), 66, (350, 10), 782);
            Add_Action (Table.States (777), 76, (346, 6), 1139);
            Add_Action (Table.States (777), 84, (124, 0), 32);
            Table.States (777).Goto_List.Set_Capacity (15);
            Add_Goto (Table.States (777), 124, 784);
            Add_Goto (Table.States (777), 291, 785);
            Add_Goto (Table.States (777), 292, 786);
            Add_Goto (Table.States (777), 293, 317);
            Add_Goto (Table.States (777), 294, 318);
            Add_Goto (Table.States (777), 329, 787);
            Add_Goto (Table.States (777), 348, 788);
            Add_Goto (Table.States (777), 350, 1140);
            Add_Goto (Table.States (777), 351, 790);
            Add_Goto (Table.States (777), 356, 791);
            Add_Goto (Table.States (777), 431, 792);
            Add_Goto (Table.States (777), 437, 140);
            Add_Goto (Table.States (777), 438, 141);
            Add_Goto (Table.States (777), 440, 142);
            Add_Goto (Table.States (777), 454, 143);
            Table.States (777).Kernel := To_Vector ((((346, 6),  82,  5, (32767, 0),  0), ((346, 7),  82,  2, (32767,
            0),  0)));
            Table.States (777).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (350, 10),  66, 782)));
            Table.States (778).Action_List.Set_Capacity (1);
            Add_Action (Table.States (778), 116, (136, 0), 207);
            Table.States (778).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (778), 136, 851);
            Add_Goto (Table.States (778), 166, 852);
            Add_Goto (Table.States (778), 168, 853);
            Table.States (778).Kernel := To_Vector ((0 => ((167, 0),  85,  4, (32767, 0),  0)));
            Table.States (778).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (136, 0),  116, 207)));
            Table.States (779).Action_List.Set_Capacity (2);
            Add_Action (Table.States (779), 61, (434, 0), 299);
            Add_Action (Table.States (779), 82, (346, 2), 1141);
            Table.States (779).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (779), 434, 1142);
            Table.States (779).Kernel := To_Vector ((((346, 0),  167,  8, (32767, 0),  0), ((346, 1),  167,  5, (32767,
            0),  0), ((346, 2),  167,  6, (32767, 0),  0), ((346, 3),  167,  3, (32767, 0),  0)));
            Table.States (779).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (346, 2),  82, 1141)));
            Table.States (780).Action_List.Set_Capacity (1);
            Add_Action (Table.States (780), 82, (346, 4), 1143);
            Table.States (780).Kernel := To_Vector ((((346, 4),  434,  6, (32767, 0),  0), ((346, 5),  434,  3, (32767,
            0),  0)));
            Table.States (780).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (346, 4),  82, 1143)));
            Table.States (781).Action_List.Set_Capacity (9);
            Add_Action (Table.States (781), 21, (356, 4), 8);
            Add_Action (Table.States (781), 25, (329, 1), 10);
            Add_Action (Table.States (781), 51, (437, 0), 221);
            Add_Action (Table.States (781), 52, (329, 0), 21);
            Add_Action (Table.States (781), 53, (294, 0), 314);
            Add_Action (Table.States (781), 54, (293, 0), 315);
            Add_Action (Table.States (781), 66, (350, 8), 1144);
            Add_Action (Table.States (781), 84, (124, 0), 32);
            Add_Action (Table.States (781), 116, (136, 0), 207);
            Table.States (781).Goto_List.Set_Capacity (17);
            Add_Goto (Table.States (781), 124, 784);
            Add_Goto (Table.States (781), 136, 1145);
            Add_Goto (Table.States (781), 173, 1146);
            Add_Goto (Table.States (781), 291, 785);
            Add_Goto (Table.States (781), 292, 786);
            Add_Goto (Table.States (781), 293, 317);
            Add_Goto (Table.States (781), 294, 318);
            Add_Goto (Table.States (781), 329, 787);
            Add_Goto (Table.States (781), 349, 1147);
            Add_Goto (Table.States (781), 351, 1148);
            Add_Goto (Table.States (781), 352, 1149);
            Add_Goto (Table.States (781), 356, 791);
            Add_Goto (Table.States (781), 431, 792);
            Add_Goto (Table.States (781), 437, 140);
            Add_Goto (Table.States (781), 438, 141);
            Add_Goto (Table.States (781), 440, 142);
            Add_Goto (Table.States (781), 454, 143);
            Table.States (781).Kernel := To_Vector ((((350, 6),  27,  5, (32767, 0),  0), ((350, 7),  27,  4, (32767,
            0),  0), ((350, 8),  27,  2, (32767, 0),  0), ((350, 9),  27,  1, (32767, 0),  0)));
            Table.States (781).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (350, 8),  66, 1144)));
            Table.States (782).Action_List.Set_Capacity (2);
            Add_Action (Table.States (782), 108, Reduce, (350, 11),  1);
            Add_Action (Table.States (782), 116, (350, 10), 1150);
            Table.States (782).Kernel := To_Vector ((((350, 10),  66,  1, (32767, 0),  0), ((350, 11),  66,  0, (350,
            11),  1)));
            Table.States (782).Minimal_Complete_Actions := To_Vector (((Shift, (350, 10),  116, 1150), (Reduce, (350,
            11),  1)));
            Table.States (783).Action_List.Set_Capacity (5);
            Add_Action (Table.States (783), 86, (252, 0), 33);
            Add_Action (Table.States (783), 90, (268, 0), 34);
            Add_Action (Table.States (783), 116, (196, 0), 146);
            Add_Action (Table.States (783), 117, (196, 1), 37);
            Add_Action (Table.States (783), 118, (195, 6), 38);
            Table.States (783).Goto_List.Set_Capacity (12);
            Add_Goto (Table.States (783), 182, 1151);
            Add_Goto (Table.States (783), 195, 1152);
            Add_Goto (Table.States (783), 196, 148);
            Add_Goto (Table.States (783), 197, 54);
            Add_Goto (Table.States (783), 198, 55);
            Add_Goto (Table.States (783), 199, 56);
            Add_Goto (Table.States (783), 201, 57);
            Add_Goto (Table.States (783), 251, 58);
            Add_Goto (Table.States (783), 252, 59);
            Add_Goto (Table.States (783), 255, 60);
            Add_Goto (Table.States (783), 268, 68);
            Add_Goto (Table.States (783), 311, 83);
            Table.States (783).Kernel := To_Vector ((0 => ((347, 2),  76,  4, (32767, 0),  0)));
            Table.States (783).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (784).Action_List.Set_Capacity (10);
            Add_Action (Table.States (784), (21, 25, 27, 51, 52, 53, 54, 66, 84, 116), (351, 1),  1);
            Table.States (784).Kernel := To_Vector ((0 => ((351, 1),  124,  0, (351, 1),  1)));
            Table.States (784).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (351, 1),  1)));
            Table.States (785).Action_List.Set_Capacity (10);
            Add_Action (Table.States (785), (21, 25, 27, 51, 52, 53, 54, 66, 84, 116), (351, 0),  1);
            Table.States (785).Kernel := To_Vector ((0 => ((351, 0),  291,  0, (351, 0),  1)));
            Table.States (785).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (351, 0),  1)));
            Table.States (786).Action_List.Set_Capacity (2);
            Add_Action (Table.States (786), 61, (434, 0), 299);
            Add_Action (Table.States (786), 108, (291, 3), 301);
            Table.States (786).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (786), 434, 1067);
            Table.States (786).Kernel := To_Vector ((((291, 2),  292,  3, (32767, 0),  0), ((291, 3),  292,  1, (32767,
            0),  0)));
            Table.States (787).Action_List.Set_Capacity (3);
            Add_Action (Table.States (787), 21, (356, 0), 306);
            Add_Action (Table.States (787), 53, (294, 0), 314);
            Add_Action (Table.States (787), 54, (293, 0), 315);
            Table.States (787).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (787), 292, 1153);
            Add_Goto (Table.States (787), 293, 317);
            Add_Goto (Table.States (787), 294, 318);
            Table.States (787).Kernel := To_Vector ((((291, 0),  329,  5, (32767, 0),  0), ((291, 1),  329,  3, (32767,
            0),  0), ((356, 0),  329,  8, (32767, 0),  0), ((356, 1),  329,  6, (32767, 0),  0), ((356, 2),  329,  5,
            (32767, 0),  0), ((356, 3),  329,  3, (32767, 0),  0)));
            Table.States (787).Minimal_Complete_Actions := To_Vector (((Shift, (293, 0),  54, 315), (Shift, (356, 0),
            21, 306)));
            Table.States (788).Action_List.Set_Capacity (9);
            Add_Action (Table.States (788), 21, (356, 4), 8);
            Add_Action (Table.States (788), 25, (329, 1), 10);
            Add_Action (Table.States (788), 27, (350, 0), 1154);
            Add_Action (Table.States (788), 51, (437, 0), 221);
            Add_Action (Table.States (788), 52, (329, 0), 21);
            Add_Action (Table.States (788), 53, (294, 0), 314);
            Add_Action (Table.States (788), 54, (293, 0), 315);
            Add_Action (Table.States (788), 66, (350, 4), 1155);
            Add_Action (Table.States (788), 84, (124, 0), 32);
            Table.States (788).Goto_List.Set_Capacity (13);
            Add_Goto (Table.States (788), 124, 784);
            Add_Goto (Table.States (788), 291, 785);
            Add_Goto (Table.States (788), 292, 786);
            Add_Goto (Table.States (788), 293, 317);
            Add_Goto (Table.States (788), 294, 318);
            Add_Goto (Table.States (788), 329, 787);
            Add_Goto (Table.States (788), 351, 1156);
            Add_Goto (Table.States (788), 356, 791);
            Add_Goto (Table.States (788), 431, 792);
            Add_Goto (Table.States (788), 437, 140);
            Add_Goto (Table.States (788), 438, 141);
            Add_Goto (Table.States (788), 440, 142);
            Add_Goto (Table.States (788), 454, 143);
            Table.States (788).Kernel := To_Vector ((((348, 1),  348,  3, (32767, 0),  0), ((350, 0),  348,  6, (32767,
            0),  0), ((350, 1),  348,  5, (32767, 0),  0), ((350, 2),  348,  3, (32767, 0),  0), ((350, 3),  348,  2,
            (32767, 0),  0), ((350, 4),  348,  2, (32767, 0),  0), ((350, 5),  348,  1, (32767, 0),  0)));
            Table.States (789).Action_List.Set_Capacity (1);
            Add_Action (Table.States (789), 108, (347, 3), 1157);
            Table.States (789).Kernel := To_Vector ((0 => ((347, 3),  350,  1, (32767, 0),  0)));
            Table.States (789).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (347, 3),  108, 1157)));
            Table.States (790).Action_List.Set_Capacity (9);
            Add_Action (Table.States (790), (21, 25, 27, 51, 52, 53, 54, 66, 84), (348, 0),  1);
            Table.States (790).Kernel := To_Vector ((0 => ((348, 0),  351,  0, (348, 0),  1)));
            Table.States (790).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (348, 0),  1)));
            Table.States (791).Action_List.Set_Capacity (10);
            Add_Action (Table.States (791), (21, 25, 27, 51, 52, 53, 54, 66, 84, 116), (351, 2),  1);
            Table.States (791).Kernel := To_Vector ((0 => ((351, 2),  356,  0, (351, 2),  1)));
            Table.States (791).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (351, 2),  1)));
            Table.States (792).Action_List.Set_Capacity (10);
            Add_Action (Table.States (792), (21, 25, 27, 51, 52, 53, 54, 66, 84, 116), (351, 3),  1);
            Table.States (792).Kernel := To_Vector ((0 => ((351, 3),  431,  0, (351, 3),  1)));
            Table.States (792).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (351, 3),  1)));
            Table.States (793).Action_List.Set_Capacity (10);
            Add_Action (Table.States (793), 21, (356, 4), 8);
            Add_Action (Table.States (793), 25, (329, 1), 10);
            Add_Action (Table.States (793), 27, (350, 6), 781);
            Add_Action (Table.States (793), 51, (437, 0), 221);
            Add_Action (Table.States (793), 52, (329, 0), 21);
            Add_Action (Table.States (793), 53, (294, 0), 314);
            Add_Action (Table.States (793), 54, (293, 0), 315);
            Add_Action (Table.States (793), 66, (350, 10), 782);
            Add_Action (Table.States (793), 76, (347, 0), 1158);
            Add_Action (Table.States (793), 84, (124, 0), 32);
            Table.States (793).Goto_List.Set_Capacity (15);
            Add_Goto (Table.States (793), 124, 784);
            Add_Goto (Table.States (793), 291, 785);
            Add_Goto (Table.States (793), 292, 786);
            Add_Goto (Table.States (793), 293, 317);
            Add_Goto (Table.States (793), 294, 318);
            Add_Goto (Table.States (793), 329, 787);
            Add_Goto (Table.States (793), 348, 788);
            Add_Goto (Table.States (793), 350, 1159);
            Add_Goto (Table.States (793), 351, 790);
            Add_Goto (Table.States (793), 356, 791);
            Add_Goto (Table.States (793), 431, 792);
            Add_Goto (Table.States (793), 437, 140);
            Add_Goto (Table.States (793), 438, 141);
            Add_Goto (Table.States (793), 440, 142);
            Add_Goto (Table.States (793), 454, 143);
            Table.States (793).Kernel := To_Vector ((((347, 0),  82,  5, (32767, 0),  0), ((347, 1),  82,  2, (32767,
            0),  0)));
            Table.States (793).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (350, 10),  66, 782)));
            Table.States (794).Action_List.Set_Capacity (16);
            Add_Action (Table.States (794), 13, (391, 0), 1160);
            Add_Action (Table.States (794), 22, (339, 0), 9);
            Add_Action (Table.States (794), 25, (329, 1), 10);
            Add_Action (Table.States (794), 28, (325, 0), 12);
            Add_Action (Table.States (794), 38, Reduce, (192, 1),  0);
            Add_Action (Table.States (794), 50, (332, 0), 19);
            Add_Action (Table.States (794), 51, (437, 0), 221);
            Add_Action (Table.States (794), 52, (329, 0), 21);
            Add_Action (Table.States (794), 53, (294, 0), 22);
            Add_Action (Table.States (794), 54, (293, 0), 23);
            Add_Action (Table.States (794), 59, (346, 0), 24);
            Add_Action (Table.States (794), 60, (340, 0), 25);
            Add_Action (Table.States (794), 81, (130, 0), 30);
            Add_Action (Table.States (794), 83, (128, 0), 31);
            Add_Action (Table.States (794), 84, (124, 0), 32);
            Add_Action (Table.States (794), 116, (136, 0), 223);
            Table.States (794).Goto_List.Set_Capacity (60);
            Add_Goto (Table.States (794), 124, 561);
            Add_Goto (Table.States (794), 126, 40);
            Add_Goto (Table.States (794), 127, 41);
            Add_Goto (Table.States (794), 128, 42);
            Add_Goto (Table.States (794), 130, 43);
            Add_Goto (Table.States (794), 135, 44);
            Add_Goto (Table.States (794), 136, 45);
            Add_Goto (Table.States (794), 137, 46);
            Add_Goto (Table.States (794), 180, 47);
            Add_Goto (Table.States (794), 189, 48);
            Add_Goto (Table.States (794), 190, 562);
            Add_Goto (Table.States (794), 191, 563);
            Add_Goto (Table.States (794), 192, 1161);
            Add_Goto (Table.States (794), 193, 50);
            Add_Goto (Table.States (794), 194, 51);
            Add_Goto (Table.States (794), 291, 77);
            Add_Goto (Table.States (794), 292, 78);
            Add_Goto (Table.States (794), 293, 79);
            Add_Goto (Table.States (794), 294, 80);
            Add_Goto (Table.States (794), 309, 81);
            Add_Goto (Table.States (794), 320, 86);
            Add_Goto (Table.States (794), 321, 87);
            Add_Goto (Table.States (794), 322, 88);
            Add_Goto (Table.States (794), 325, 89);
            Add_Goto (Table.States (794), 326, 90);
            Add_Goto (Table.States (794), 327, 91);
            Add_Goto (Table.States (794), 328, 92);
            Add_Goto (Table.States (794), 329, 225);
            Add_Goto (Table.States (794), 330, 94);
            Add_Goto (Table.States (794), 332, 95);
            Add_Goto (Table.States (794), 333, 96);
            Add_Goto (Table.States (794), 334, 97);
            Add_Goto (Table.States (794), 335, 98);
            Add_Goto (Table.States (794), 336, 99);
            Add_Goto (Table.States (794), 337, 100);
            Add_Goto (Table.States (794), 338, 101);
            Add_Goto (Table.States (794), 339, 102);
            Add_Goto (Table.States (794), 340, 103);
            Add_Goto (Table.States (794), 341, 104);
            Add_Goto (Table.States (794), 345, 105);
            Add_Goto (Table.States (794), 346, 106);
            Add_Goto (Table.States (794), 347, 107);
            Add_Goto (Table.States (794), 354, 108);
            Add_Goto (Table.States (794), 388, 126);
            Add_Goto (Table.States (794), 389, 127);
            Add_Goto (Table.States (794), 390, 128);
            Add_Goto (Table.States (794), 391, 129);
            Add_Goto (Table.States (794), 392, 130);
            Add_Goto (Table.States (794), 394, 132);
            Add_Goto (Table.States (794), 403, 134);
            Add_Goto (Table.States (794), 404, 135);
            Add_Goto (Table.States (794), 405, 136);
            Add_Goto (Table.States (794), 406, 137);
            Add_Goto (Table.States (794), 408, 138);
            Add_Goto (Table.States (794), 431, 139);
            Add_Goto (Table.States (794), 437, 140);
            Add_Goto (Table.States (794), 438, 141);
            Add_Goto (Table.States (794), 440, 142);
            Add_Goto (Table.States (794), 454, 143);
            Add_Goto (Table.States (794), 458, 565);
            Table.States (794).Kernel := To_Vector ((((345, 1),  82,  5, (32767, 0),  0), ((391, 0),  82,  4, (32767,
            0),  0), ((391, 1),  82,  2, (32767, 0),  0)));
            Table.States (794).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (391, 0),  13, 1160)));
            Table.States (795).Action_List.Set_Capacity (1);
            Add_Action (Table.States (795), 82, (345, 0), 1162);
            Table.States (795).Kernel := To_Vector ((0 => ((345, 0),  434,  6, (32767, 0),  0)));
            Table.States (795).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (345, 0),  82, 1162)));
            Table.States (796).Action_List.Set_Capacity (5);
            Add_Action (Table.States (796), 21, (356, 4), 8);
            Add_Action (Table.States (796), 25, (329, 1), 10);
            Add_Action (Table.States (796), 51, (437, 0), 221);
            Add_Action (Table.States (796), 52, (329, 0), 21);
            Add_Action (Table.States (796), 76, (340, 9), 1163);
            Table.States (796).Goto_List.Set_Capacity (10);
            Add_Goto (Table.States (796), 329, 801);
            Add_Goto (Table.States (796), 342, 802);
            Add_Goto (Table.States (796), 343, 1164);
            Add_Goto (Table.States (796), 344, 804);
            Add_Goto (Table.States (796), 356, 805);
            Add_Goto (Table.States (796), 431, 806);
            Add_Goto (Table.States (796), 437, 140);
            Add_Goto (Table.States (796), 438, 141);
            Add_Goto (Table.States (796), 440, 142);
            Add_Goto (Table.States (796), 454, 143);
            Table.States (796).Kernel := To_Vector ((((340, 9),  82,  8, (32767, 0),  0), ((340, 10),  82,  5, (32767,
            0),  0)));
            Table.States (796).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (356, 4),  21, 8)));
            Table.States (797).Action_List.Set_Capacity (43);
            Add_Action (Table.States (797), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (340, 11),  4);
            Table.States (797).Kernel := To_Vector ((0 => ((340, 11),  108,  0, (340, 11),  4)));
            Table.States (797).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (340, 11),  4)));
            Table.States (798).Action_List.Set_Capacity (3);
            Add_Action (Table.States (798), 61, (434, 0), 299);
            Add_Action (Table.States (798), 82, (340, 3), 1165);
            Add_Action (Table.States (798), 108, (340, 5), 1166);
            Table.States (798).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (798), 434, 1167);
            Table.States (798).Kernel := To_Vector ((((340, 0),  167,  11, (32767, 0),  0), ((340, 1),  167,  8,
            (32767, 0),  0), ((340, 2),  167,  3, (32767, 0),  0), ((340, 3),  167,  9, (32767, 0),  0), ((340, 4),
            167,  6, (32767, 0),  0), ((340, 5),  167,  1, (32767, 0),  0)));
            Table.States (798).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (340, 5),  108, 1166)));
            Table.States (799).Action_List.Set_Capacity (2);
            Add_Action (Table.States (799), 82, (340, 6), 1168);
            Add_Action (Table.States (799), 108, (340, 8), 1169);
            Table.States (799).Kernel := To_Vector ((((340, 6),  434,  9, (32767, 0),  0), ((340, 7),  434,  6, (32767,
            0),  0), ((340, 8),  434,  1, (32767, 0),  0)));
            Table.States (799).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (340, 8),  108, 1169)));
            Table.States (800).Action_List.Set_Capacity (5);
            Add_Action (Table.States (800), 86, (252, 0), 33);
            Add_Action (Table.States (800), 90, (268, 0), 34);
            Add_Action (Table.States (800), 116, (196, 0), 146);
            Add_Action (Table.States (800), 117, (196, 1), 37);
            Add_Action (Table.States (800), 118, (195, 6), 38);
            Table.States (800).Goto_List.Set_Capacity (12);
            Add_Goto (Table.States (800), 182, 1170);
            Add_Goto (Table.States (800), 195, 1152);
            Add_Goto (Table.States (800), 196, 148);
            Add_Goto (Table.States (800), 197, 54);
            Add_Goto (Table.States (800), 198, 55);
            Add_Goto (Table.States (800), 199, 56);
            Add_Goto (Table.States (800), 201, 57);
            Add_Goto (Table.States (800), 251, 58);
            Add_Goto (Table.States (800), 252, 59);
            Add_Goto (Table.States (800), 255, 60);
            Add_Goto (Table.States (800), 268, 68);
            Add_Goto (Table.States (800), 311, 83);
            Table.States (800).Kernel := To_Vector ((0 => ((341, 3),  76,  7, (32767, 0),  0)));
            Table.States (800).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (801).Action_List.Set_Capacity (1);
            Add_Action (Table.States (801), 21, (356, 0), 306);
            Table.States (801).Kernel := To_Vector ((((356, 0),  329,  8, (32767, 0),  0), ((356, 1),  329,  6, (32767,
            0),  0), ((356, 2),  329,  5, (32767, 0),  0), ((356, 3),  329,  3, (32767, 0),  0)));
            Table.States (801).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (356, 0),  21, 306)));
            Table.States (802).Action_List.Set_Capacity (6);
            Add_Action (Table.States (802), 21, (356, 4), 8);
            Add_Action (Table.States (802), 25, (329, 1), 10);
            Add_Action (Table.States (802), 27, (343, 0), 1171);
            Add_Action (Table.States (802), 51, (437, 0), 221);
            Add_Action (Table.States (802), 52, (329, 0), 21);
            Add_Action (Table.States (802), 66, (343, 1), 1172);
            Table.States (802).Goto_List.Set_Capacity (8);
            Add_Goto (Table.States (802), 329, 801);
            Add_Goto (Table.States (802), 344, 1173);
            Add_Goto (Table.States (802), 356, 805);
            Add_Goto (Table.States (802), 431, 806);
            Add_Goto (Table.States (802), 437, 140);
            Add_Goto (Table.States (802), 438, 141);
            Add_Goto (Table.States (802), 440, 142);
            Add_Goto (Table.States (802), 454, 143);
            Table.States (802).Kernel := To_Vector ((((342, 1),  342,  3, (32767, 0),  0), ((343, 0),  342,  5, (32767,
            0),  0), ((343, 1),  342,  1, (32767, 0),  0)));
            Table.States (803).Action_List.Set_Capacity (1);
            Add_Action (Table.States (803), 108, (341, 4), 1174);
            Table.States (803).Kernel := To_Vector ((0 => ((341, 4),  343,  1, (32767, 0),  0)));
            Table.States (803).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (341, 4),  108, 1174)));
            Table.States (804).Action_List.Set_Capacity (6);
            Add_Action (Table.States (804), (21, 25, 27, 51, 52, 66), (342, 0),  1);
            Table.States (804).Kernel := To_Vector ((0 => ((342, 0),  344,  0, (342, 0),  1)));
            Table.States (804).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (342, 0),  1)));
         end Subr_33;
         procedure Subr_34
         is begin
            Table.States (805).Action_List.Set_Capacity (6);
            Add_Action (Table.States (805), (21, 25, 27, 51, 52, 66), (344, 0),  1);
            Table.States (805).Kernel := To_Vector ((0 => ((344, 0),  356,  0, (344, 0),  1)));
            Table.States (805).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (344, 0),  1)));
            Table.States (806).Action_List.Set_Capacity (6);
            Add_Action (Table.States (806), (21, 25, 27, 51, 52, 66), (344, 1),  1);
            Table.States (806).Kernel := To_Vector ((0 => ((344, 1),  431,  0, (344, 1),  1)));
            Table.States (806).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (344, 1),  1)));
            Table.States (807).Action_List.Set_Capacity (5);
            Add_Action (Table.States (807), 21, (356, 4), 8);
            Add_Action (Table.States (807), 25, (329, 1), 10);
            Add_Action (Table.States (807), 51, (437, 0), 221);
            Add_Action (Table.States (807), 52, (329, 0), 21);
            Add_Action (Table.States (807), 76, (341, 0), 1175);
            Table.States (807).Goto_List.Set_Capacity (10);
            Add_Goto (Table.States (807), 329, 801);
            Add_Goto (Table.States (807), 342, 802);
            Add_Goto (Table.States (807), 343, 1176);
            Add_Goto (Table.States (807), 344, 804);
            Add_Goto (Table.States (807), 356, 805);
            Add_Goto (Table.States (807), 431, 806);
            Add_Goto (Table.States (807), 437, 140);
            Add_Goto (Table.States (807), 438, 141);
            Add_Goto (Table.States (807), 440, 142);
            Add_Goto (Table.States (807), 454, 143);
            Table.States (807).Kernel := To_Vector ((((341, 0),  82,  8, (32767, 0),  0), ((341, 1),  82,  5, (32767,
            0),  0)));
            Table.States (807).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (356, 4),  21, 8)));
            Table.States (808).Action_List.Set_Capacity (43);
            Add_Action (Table.States (808), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (341, 2),  4);
            Table.States (808).Kernel := To_Vector ((0 => ((341, 2),  108,  0, (341, 2),  4)));
            Table.States (808).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (341, 2),  4)));
            Table.States (809).Action_List.Set_Capacity (15);
            Add_Action (Table.States (809), 12, (402, 0), 165);
            Add_Action (Table.States (809), 44, (233, 2), 167);
            Add_Action (Table.States (809), 52, (187, 0), 356);
            Add_Action (Table.States (809), 62, (178, 3), 385);
            Add_Action (Table.States (809), 65, (234, 1), 169);
            Add_Action (Table.States (809), 76, (256, 0), 170);
            Add_Action (Table.States (809), 85, (205, 4), 171);
            Add_Action (Table.States (809), 86, (213, 2), 172);
            Add_Action (Table.States (809), 90, (268, 0), 34);
            Add_Action (Table.States (809), 106, (237, 1), 173);
            Add_Action (Table.States (809), 107, (237, 0), 174);
            Add_Action (Table.States (809), 115, (234, 0), 175);
            Add_Action (Table.States (809), 116, (196, 0), 146);
            Add_Action (Table.States (809), 117, (196, 1), 37);
            Add_Action (Table.States (809), 118, (195, 6), 38);
            Table.States (809).Goto_List.Set_Capacity (37);
            Add_Goto (Table.States (809), 131, 361);
            Add_Goto (Table.States (809), 140, 362);
            Add_Goto (Table.States (809), 177, 1177);
            Add_Goto (Table.States (809), 178, 364);
            Add_Goto (Table.States (809), 187, 365);
            Add_Goto (Table.States (809), 195, 366);
            Add_Goto (Table.States (809), 196, 148);
            Add_Goto (Table.States (809), 197, 54);
            Add_Goto (Table.States (809), 198, 55);
            Add_Goto (Table.States (809), 199, 56);
            Add_Goto (Table.States (809), 201, 57);
            Add_Goto (Table.States (809), 203, 369);
            Add_Goto (Table.States (809), 205, 177);
            Add_Goto (Table.States (809), 206, 178);
            Add_Goto (Table.States (809), 210, 179);
            Add_Goto (Table.States (809), 211, 180);
            Add_Goto (Table.States (809), 213, 181);
            Add_Goto (Table.States (809), 214, 182);
            Add_Goto (Table.States (809), 215, 183);
            Add_Goto (Table.States (809), 218, 184);
            Add_Goto (Table.States (809), 219, 185);
            Add_Goto (Table.States (809), 220, 186);
            Add_Goto (Table.States (809), 227, 975);
            Add_Goto (Table.States (809), 228, 188);
            Add_Goto (Table.States (809), 231, 378);
            Add_Goto (Table.States (809), 232, 190);
            Add_Goto (Table.States (809), 233, 191);
            Add_Goto (Table.States (809), 234, 192);
            Add_Goto (Table.States (809), 237, 193);
            Add_Goto (Table.States (809), 251, 58);
            Add_Goto (Table.States (809), 252, 59);
            Add_Goto (Table.States (809), 255, 60);
            Add_Goto (Table.States (809), 256, 194);
            Add_Goto (Table.States (809), 268, 68);
            Add_Goto (Table.States (809), 311, 83);
            Add_Goto (Table.States (809), 402, 195);
            Add_Goto (Table.States (809), 465, 196);
            Table.States (809).Kernel := To_Vector ((0 => ((274, 0),  63,  4, (32767, 0),  0)));
            Table.States (809).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (178, 3),  62, 385)));
            Table.States (810).Action_List.Set_Capacity (2);
            Add_Action (Table.States (810), 63, (274, 0), 809);
            Add_Action (Table.States (810), 66, (273, 0), 1178);
            Table.States (810).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (810), 274, 1179);
            Table.States (810).Kernel := To_Vector ((((272, 1),  272,  5, (32767, 0),  0), ((273, 0),  272,  3, (32767,
            0),  0)));
            Table.States (810).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (273, 0),  66, 1178)));
            Table.States (811).Action_List.Set_Capacity (2);
            Add_Action (Table.States (811), (63, 66), (272, 0),  1);
            Table.States (811).Kernel := To_Vector ((0 => ((272, 0),  274,  0, (272, 0),  1)));
            Table.States (811).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (272, 0),  1)));
            Table.States (812).Action_List.Set_Capacity (2);
            Add_Action (Table.States (812), 95, (331, 1), 464);
            Add_Action (Table.States (812), 108, (386, 0), 1180);
            Table.States (812).Kernel := To_Vector ((((331, 1),  331,  2, (32767, 0),  0), ((386, 0),  331,  1, (32767,
            0),  0)));
            Table.States (812).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (386, 0),  108, 1180)));
            Table.States (813).Action_List.Set_Capacity (42);
            Add_Action (Table.States (813), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119), (386,
            1),  4);
            Table.States (813).Kernel := To_Vector ((0 => ((386, 1),  108,  0, (386, 1),  4)));
            Table.States (813).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (386, 1),  4)));
            Table.States (814).Action_List.Set_Capacity (2);
            Add_Action (Table.States (814), 61, (434, 0), 299);
            Add_Action (Table.States (814), 108, (130, 1), 1181);
            Table.States (814).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (814), 434, 1182);
            Table.States (814).Kernel := To_Vector ((((130, 0),  131,  3, (32767, 0),  0), ((130, 1),  131,  1, (32767,
            0),  0)));
            Table.States (814).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (130, 1),  108, 1181)));
            Table.States (815).Action_List.Set_Capacity (2);
            Add_Action (Table.States (815), 61, (434, 0), 299);
            Add_Action (Table.States (815), 108, (327, 23), 1183);
            Table.States (815).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (815), 434, 1184);
            Table.States (815).Kernel := To_Vector ((((327, 22),  27,  3, (32767, 0),  0), ((327, 23),  27,  1, (32767,
            0),  0)));
            Table.States (815).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (327, 23),  108, 1183)));
            Table.States (816).Action_List.Set_Capacity (11);
            Add_Action (Table.States (816), 52, (187, 0), 347);
            Add_Action (Table.States (816), 53, (186, 1), 1185);
            Add_Action (Table.States (816), 54, (186, 0), 1186);
            Add_Action (Table.States (816), 55, (185, 0), 1187);
            Add_Action (Table.States (816), 59, (183, 4), 1188);
            Add_Action (Table.States (816), 79, (185, 1), 1189);
            Add_Action (Table.States (816), 86, (252, 0), 33);
            Add_Action (Table.States (816), 90, (268, 0), 34);
            Add_Action (Table.States (816), 116, (196, 0), 146);
            Add_Action (Table.States (816), 117, (196, 1), 37);
            Add_Action (Table.States (816), 118, (195, 6), 38);
            Table.States (816).Goto_List.Set_Capacity (15);
            Add_Goto (Table.States (816), 131, 1190);
            Add_Goto (Table.States (816), 185, 1191);
            Add_Goto (Table.States (816), 186, 1192);
            Add_Goto (Table.States (816), 187, 365);
            Add_Goto (Table.States (816), 195, 528);
            Add_Goto (Table.States (816), 196, 148);
            Add_Goto (Table.States (816), 197, 54);
            Add_Goto (Table.States (816), 198, 55);
            Add_Goto (Table.States (816), 199, 56);
            Add_Goto (Table.States (816), 201, 57);
            Add_Goto (Table.States (816), 251, 58);
            Add_Goto (Table.States (816), 252, 59);
            Add_Goto (Table.States (816), 255, 60);
            Add_Goto (Table.States (816), 268, 68);
            Add_Goto (Table.States (816), 311, 83);
            Table.States (816).Kernel := To_Vector ((((183, 4),  56,  2, (32767, 0),  0), ((183, 5),  56,  1, (32767,
            0),  0), ((184, 0),  56,  2, (32767, 0),  0), ((184, 1),  56,  1, (32767, 0),  0)));
            Table.States (816).Minimal_Complete_Actions := To_Vector (((Shift, (186, 0),  54, 1186), (Shift, (196, 0),
            116, 146)));
            Table.States (817).Action_List.Set_Capacity (4);
            Add_Action (Table.States (817), 48, Reduce, (181, 9),  1);
            Add_Action (Table.States (817), 61, Reduce, (181, 9),  1);
            Add_Action (Table.States (817), 75, (181, 8), 1193);
            Add_Action (Table.States (817), 108, Reduce, (181, 9),  1);
            Table.States (817).Kernel := To_Vector ((((181, 8),  57,  2, (32767, 0),  0), ((181, 9),  57,  0, (181, 9),
             1)));
            Table.States (817).Minimal_Complete_Actions := To_Vector (((Shift, (181, 8),  75, 1193), (Reduce, (181, 9),
             1)));
            Table.States (818).Action_List.Set_Capacity (2);
            Add_Action (Table.States (818), 57, (181, 6), 1194);
            Add_Action (Table.States (818), 76, (328, 40), 1195);
            Table.States (818).Kernel := To_Vector ((((181, 6),  58,  3, (32767, 0),  0), ((181, 7),  58,  1, (32767,
            0),  0), ((328, 40),  58,  9, (32767, 0),  0), ((328, 41),  58,  7, (32767, 0),  0), ((328, 42),  58,  7,
            (32767, 0),  0), ((328, 43),  58,  5, (32767, 0),  0)));
            Table.States (818).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (181, 6),  57, 1194)));
            Table.States (819).Action_List.Set_Capacity (1);
            Add_Action (Table.States (819), 57, (181, 4), 1196);
            Table.States (819).Kernel := To_Vector ((((181, 4),  59,  3, (32767, 0),  0), ((181, 5),  59,  1, (32767,
            0),  0)));
            Table.States (819).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (181, 4),  57, 1196)));
            Table.States (820).Action_List.Set_Capacity (1);
            Add_Action (Table.States (820), 57, (181, 2), 1197);
            Table.States (820).Kernel := To_Vector ((((181, 2),  60,  3, (32767, 0),  0), ((181, 3),  60,  1, (32767,
            0),  0)));
            Table.States (820).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (181, 2),  57, 1197)));
            Table.States (821).Action_List.Set_Capacity (1);
            Add_Action (Table.States (821), 67, (170, 2), 1198);
            Table.States (821).Kernel := To_Vector ((0 => ((170, 2),  65,  1, (32767, 0),  0)));
            Table.States (821).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (170, 2),  67, 1198)));
            Table.States (822).Action_List.Set_Capacity (4);
            Add_Action (Table.States (822), 51, (437, 0), 221);
            Add_Action (Table.States (822), 64, (175, 0), 1199);
            Add_Action (Table.States (822), 65, (171, 3), 1200);
            Add_Action (Table.States (822), 116, (136, 0), 207);
            Table.States (822).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (822), 136, 1145);
            Add_Goto (Table.States (822), 171, 1201);
            Add_Goto (Table.States (822), 172, 1202);
            Add_Goto (Table.States (822), 173, 1203);
            Add_Goto (Table.States (822), 175, 1204);
            Add_Goto (Table.States (822), 431, 1205);
            Add_Goto (Table.States (822), 437, 140);
            Add_Goto (Table.States (822), 438, 141);
            Add_Goto (Table.States (822), 440, 142);
            Add_Goto (Table.States (822), 454, 143);
            Add_Goto (Table.States (822), 457, 1206);
            Table.States (822).Kernel := To_Vector ((((170, 0),  67,  5, (32767, 0),  0), ((170, 1),  67,  4, (32767,
            0),  0)));
            Table.States (822).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (171, 3),  65, 1200)));
            Table.States (823).Action_List.Set_Capacity (5);
            Add_Action (Table.States (823), 27, (327, 18), 1207);
            Add_Action (Table.States (823), 65, (170, 2), 821);
            Add_Action (Table.States (823), 67, (170, 0), 822);
            Add_Action (Table.States (823), 77, (169, 2), 1208);
            Add_Action (Table.States (823), 108, (189, 2), 1209);
            Table.States (823).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (823), 170, 1210);
            Table.States (823).Kernel := To_Vector ((((169, 2),  68,  3, (32767, 0),  0), ((169, 3),  68,  2, (32767,
            0),  0), ((189, 2),  68,  1, (32767, 0),  0), ((327, 16),  68,  5, (32767, 0),  0), ((327, 17),  68,  3,
            (32767, 0),  0), ((327, 18),  68,  4, (32767, 0),  0), ((327, 19),  68,  2, (32767, 0),  0)));
            Table.States (823).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (189, 2),  108, 1209)));
            Table.States (824).Action_List.Set_Capacity (14);
            Add_Action (Table.States (824), 12, (402, 0), 165);
            Add_Action (Table.States (824), 44, (233, 2), 167);
            Add_Action (Table.States (824), 52, (233, 3), 168);
            Add_Action (Table.States (824), 65, (234, 1), 169);
            Add_Action (Table.States (824), 76, (256, 0), 170);
            Add_Action (Table.States (824), 85, (205, 4), 171);
            Add_Action (Table.States (824), 86, (213, 2), 172);
            Add_Action (Table.States (824), 90, (268, 0), 34);
            Add_Action (Table.States (824), 106, (237, 1), 173);
            Add_Action (Table.States (824), 107, (237, 0), 174);
            Add_Action (Table.States (824), 115, (234, 0), 175);
            Add_Action (Table.States (824), 116, (196, 0), 146);
            Add_Action (Table.States (824), 117, (196, 1), 37);
            Add_Action (Table.States (824), 118, (195, 6), 38);
            Table.States (824).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (824), 195, 176);
            Add_Goto (Table.States (824), 196, 148);
            Add_Goto (Table.States (824), 197, 54);
            Add_Goto (Table.States (824), 198, 55);
            Add_Goto (Table.States (824), 199, 56);
            Add_Goto (Table.States (824), 201, 57);
            Add_Goto (Table.States (824), 205, 177);
            Add_Goto (Table.States (824), 206, 178);
            Add_Goto (Table.States (824), 210, 179);
            Add_Goto (Table.States (824), 211, 180);
            Add_Goto (Table.States (824), 213, 181);
            Add_Goto (Table.States (824), 214, 182);
            Add_Goto (Table.States (824), 215, 183);
            Add_Goto (Table.States (824), 218, 184);
            Add_Goto (Table.States (824), 219, 185);
            Add_Goto (Table.States (824), 220, 186);
            Add_Goto (Table.States (824), 227, 1211);
            Add_Goto (Table.States (824), 228, 188);
            Add_Goto (Table.States (824), 231, 189);
            Add_Goto (Table.States (824), 232, 190);
            Add_Goto (Table.States (824), 233, 191);
            Add_Goto (Table.States (824), 234, 192);
            Add_Goto (Table.States (824), 237, 193);
            Add_Goto (Table.States (824), 251, 58);
            Add_Goto (Table.States (824), 252, 59);
            Add_Goto (Table.States (824), 255, 60);
            Add_Goto (Table.States (824), 256, 194);
            Add_Goto (Table.States (824), 268, 68);
            Add_Goto (Table.States (824), 311, 83);
            Add_Goto (Table.States (824), 402, 195);
            Add_Goto (Table.States (824), 465, 196);
            Table.States (824).Kernel := To_Vector ((((151, 0),  71,  5, (32767, 0),  0), ((152, 0),  71,  7, (32767,
            0),  0), ((152, 1),  71,  3, (32767, 0),  0)));
            Table.States (824).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (825).Action_List.Set_Capacity (14);
            Add_Action (Table.States (825), 12, (402, 0), 165);
            Add_Action (Table.States (825), 44, (233, 2), 167);
            Add_Action (Table.States (825), 52, (233, 3), 168);
            Add_Action (Table.States (825), 65, (234, 1), 169);
            Add_Action (Table.States (825), 76, (256, 0), 170);
            Add_Action (Table.States (825), 85, (205, 4), 171);
            Add_Action (Table.States (825), 86, (213, 2), 172);
            Add_Action (Table.States (825), 90, (268, 0), 34);
            Add_Action (Table.States (825), 106, (237, 1), 173);
            Add_Action (Table.States (825), 107, (237, 0), 174);
            Add_Action (Table.States (825), 115, (234, 0), 175);
            Add_Action (Table.States (825), 116, (196, 0), 146);
            Add_Action (Table.States (825), 117, (196, 1), 37);
            Add_Action (Table.States (825), 118, (195, 6), 38);
            Table.States (825).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (825), 195, 176);
            Add_Goto (Table.States (825), 196, 148);
            Add_Goto (Table.States (825), 197, 54);
            Add_Goto (Table.States (825), 198, 55);
            Add_Goto (Table.States (825), 199, 56);
            Add_Goto (Table.States (825), 201, 57);
            Add_Goto (Table.States (825), 205, 177);
            Add_Goto (Table.States (825), 206, 178);
            Add_Goto (Table.States (825), 210, 179);
            Add_Goto (Table.States (825), 211, 180);
            Add_Goto (Table.States (825), 213, 181);
            Add_Goto (Table.States (825), 214, 182);
            Add_Goto (Table.States (825), 215, 183);
            Add_Goto (Table.States (825), 218, 184);
            Add_Goto (Table.States (825), 219, 185);
            Add_Goto (Table.States (825), 220, 186);
            Add_Goto (Table.States (825), 227, 1212);
            Add_Goto (Table.States (825), 228, 188);
            Add_Goto (Table.States (825), 231, 189);
            Add_Goto (Table.States (825), 232, 190);
            Add_Goto (Table.States (825), 233, 191);
            Add_Goto (Table.States (825), 234, 192);
            Add_Goto (Table.States (825), 237, 193);
            Add_Goto (Table.States (825), 251, 58);
            Add_Goto (Table.States (825), 252, 59);
            Add_Goto (Table.States (825), 255, 60);
            Add_Goto (Table.States (825), 256, 194);
            Add_Goto (Table.States (825), 268, 68);
            Add_Goto (Table.States (825), 311, 83);
            Add_Goto (Table.States (825), 402, 195);
            Add_Goto (Table.States (825), 465, 196);
            Table.States (825).Kernel := To_Vector ((((148, 0),  72,  5, (32767, 0),  0), ((148, 1),  72,  1, (32767,
            0),  0)));
            Table.States (825).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (826).Action_List.Set_Capacity (14);
            Add_Action (Table.States (826), 12, (402, 0), 165);
            Add_Action (Table.States (826), 44, (233, 2), 167);
            Add_Action (Table.States (826), 52, (233, 3), 168);
            Add_Action (Table.States (826), 65, (234, 1), 169);
            Add_Action (Table.States (826), 76, (256, 0), 170);
            Add_Action (Table.States (826), 85, (205, 4), 171);
            Add_Action (Table.States (826), 86, (213, 2), 172);
            Add_Action (Table.States (826), 90, (268, 0), 34);
            Add_Action (Table.States (826), 106, (237, 1), 173);
            Add_Action (Table.States (826), 107, (237, 0), 174);
            Add_Action (Table.States (826), 115, (234, 0), 175);
            Add_Action (Table.States (826), 116, (196, 0), 146);
            Add_Action (Table.States (826), 117, (196, 1), 37);
            Add_Action (Table.States (826), 118, (195, 6), 38);
            Table.States (826).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (826), 195, 176);
            Add_Goto (Table.States (826), 196, 148);
            Add_Goto (Table.States (826), 197, 54);
            Add_Goto (Table.States (826), 198, 55);
            Add_Goto (Table.States (826), 199, 56);
            Add_Goto (Table.States (826), 201, 57);
            Add_Goto (Table.States (826), 205, 177);
            Add_Goto (Table.States (826), 206, 178);
            Add_Goto (Table.States (826), 210, 179);
            Add_Goto (Table.States (826), 211, 180);
            Add_Goto (Table.States (826), 213, 181);
            Add_Goto (Table.States (826), 214, 182);
            Add_Goto (Table.States (826), 215, 183);
            Add_Goto (Table.States (826), 218, 184);
            Add_Goto (Table.States (826), 219, 185);
            Add_Goto (Table.States (826), 220, 186);
            Add_Goto (Table.States (826), 227, 1213);
            Add_Goto (Table.States (826), 228, 188);
            Add_Goto (Table.States (826), 231, 189);
            Add_Goto (Table.States (826), 232, 190);
            Add_Goto (Table.States (826), 233, 191);
            Add_Goto (Table.States (826), 234, 192);
            Add_Goto (Table.States (826), 237, 193);
            Add_Goto (Table.States (826), 251, 58);
            Add_Goto (Table.States (826), 252, 59);
            Add_Goto (Table.States (826), 255, 60);
            Add_Goto (Table.States (826), 256, 194);
            Add_Goto (Table.States (826), 268, 68);
            Add_Goto (Table.States (826), 311, 83);
            Add_Goto (Table.States (826), 402, 195);
            Add_Goto (Table.States (826), 465, 196);
            Table.States (826).Kernel := To_Vector ((0 => ((146, 0),  73,  1, (32767, 0),  0)));
            Table.States (826).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (827).Action_List.Set_Capacity (13);
            Add_Action (Table.States (827), 44, (233, 2), 167);
            Add_Action (Table.States (827), 52, (233, 3), 168);
            Add_Action (Table.States (827), 65, (234, 1), 169);
            Add_Action (Table.States (827), 76, (256, 0), 170);
            Add_Action (Table.States (827), 85, (205, 4), 171);
            Add_Action (Table.States (827), 86, (213, 2), 172);
            Add_Action (Table.States (827), 90, (268, 0), 34);
            Add_Action (Table.States (827), 106, (237, 1), 173);
            Add_Action (Table.States (827), 107, (237, 0), 174);
            Add_Action (Table.States (827), 115, (234, 0), 175);
            Add_Action (Table.States (827), 116, (196, 0), 146);
            Add_Action (Table.States (827), 117, (196, 1), 37);
            Add_Action (Table.States (827), 118, (195, 6), 38);
            Table.States (827).Goto_List.Set_Capacity (28);
            Add_Goto (Table.States (827), 195, 176);
            Add_Goto (Table.States (827), 196, 148);
            Add_Goto (Table.States (827), 197, 54);
            Add_Goto (Table.States (827), 198, 55);
            Add_Goto (Table.States (827), 199, 56);
            Add_Goto (Table.States (827), 201, 57);
            Add_Goto (Table.States (827), 205, 177);
            Add_Goto (Table.States (827), 206, 178);
            Add_Goto (Table.States (827), 210, 179);
            Add_Goto (Table.States (827), 211, 180);
            Add_Goto (Table.States (827), 213, 181);
            Add_Goto (Table.States (827), 214, 182);
            Add_Goto (Table.States (827), 215, 183);
            Add_Goto (Table.States (827), 218, 184);
            Add_Goto (Table.States (827), 219, 185);
            Add_Goto (Table.States (827), 220, 186);
            Add_Goto (Table.States (827), 231, 1214);
            Add_Goto (Table.States (827), 232, 190);
            Add_Goto (Table.States (827), 233, 191);
            Add_Goto (Table.States (827), 234, 192);
            Add_Goto (Table.States (827), 237, 193);
            Add_Goto (Table.States (827), 251, 58);
            Add_Goto (Table.States (827), 252, 59);
            Add_Goto (Table.States (827), 255, 60);
            Add_Goto (Table.States (827), 256, 194);
            Add_Goto (Table.States (827), 268, 68);
            Add_Goto (Table.States (827), 311, 83);
            Add_Goto (Table.States (827), 465, 196);
            Table.States (827).Kernel := To_Vector ((0 => ((145, 0),  74,  3, (32767, 0),  0)));
            Table.States (827).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
         end Subr_34;
         procedure Subr_35
         is begin
            Table.States (828).Action_List.Set_Capacity (6);
            Add_Action (Table.States (828), 52, (187, 0), 347);
            Add_Action (Table.States (828), 86, (252, 0), 33);
            Add_Action (Table.States (828), 90, (268, 0), 34);
            Add_Action (Table.States (828), 116, (196, 0), 146);
            Add_Action (Table.States (828), 117, (196, 1), 37);
            Add_Action (Table.States (828), 118, (195, 6), 38);
            Table.States (828).Goto_List.Set_Capacity (13);
            Add_Goto (Table.States (828), 131, 1215);
            Add_Goto (Table.States (828), 187, 365);
            Add_Goto (Table.States (828), 195, 528);
            Add_Goto (Table.States (828), 196, 148);
            Add_Goto (Table.States (828), 197, 54);
            Add_Goto (Table.States (828), 198, 55);
            Add_Goto (Table.States (828), 199, 56);
            Add_Goto (Table.States (828), 201, 57);
            Add_Goto (Table.States (828), 251, 58);
            Add_Goto (Table.States (828), 252, 59);
            Add_Goto (Table.States (828), 255, 60);
            Add_Goto (Table.States (828), 268, 68);
            Add_Goto (Table.States (828), 311, 83);
            Table.States (828).Kernel := To_Vector ((((138, 9),  76,  6, (32767, 0),  0), ((138, 10),  76,  4, (32767,
            0),  0), ((138, 11),  76,  1, (32767, 0),  0), ((328, 44),  76,  8, (32767, 0),  0), ((328, 45),  76,  6,
            (32767, 0),  0), ((328, 46),  76,  6, (32767, 0),  0), ((328, 47),  76,  4, (32767, 0),  0)));
            Table.States (828).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (829).Action_List.Set_Capacity (5);
            Add_Action (Table.States (829), 27, (327, 20), 1216);
            Add_Action (Table.States (829), 57, (181, 0), 1217);
            Add_Action (Table.States (829), 65, (170, 2), 821);
            Add_Action (Table.States (829), 67, (170, 0), 822);
            Add_Action (Table.States (829), 76, (138, 6), 1218);
            Table.States (829).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (829), 170, 1219);
            Table.States (829).Kernel := To_Vector ((((138, 6),  77,  7, (32767, 0),  0), ((138, 7),  77,  5, (32767,
            0),  0), ((138, 8),  77,  2, (32767, 0),  0), ((169, 4),  77,  2, (32767, 0),  0), ((181, 0),  77,  3,
            (32767, 0),  0), ((181, 1),  77,  1, (32767, 0),  0), ((327, 20),  77,  4, (32767, 0),  0), ((327, 21),
            77,  2, (32767, 0),  0), ((328, 36),  77,  9, (32767, 0),  0), ((328, 37),  77,  7, (32767, 0),  0), ((328,
            38),  77,  7, (32767, 0),  0), ((328, 39),  77,  5, (32767, 0),  0)));
            Table.States (829).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (181, 0),  57, 1217)));
            Table.States (830).Action_List.Set_Capacity (4);
            Add_Action (Table.States (830), 58, (328, 28), 1220);
            Add_Action (Table.States (830), 68, (169, 0), 1221);
            Add_Action (Table.States (830), 76, (138, 3), 1222);
            Add_Action (Table.States (830), 77, (138, 0), 1223);
            Table.States (830).Kernel := To_Vector ((((138, 0),  78,  8, (32767, 0),  0), ((138, 1),  78,  6, (32767,
            0),  0), ((138, 2),  78,  3, (32767, 0),  0), ((138, 3),  78,  7, (32767, 0),  0), ((138, 4),  78,  5,
            (32767, 0),  0), ((138, 5),  78,  2, (32767, 0),  0), ((169, 0),  78,  4, (32767, 0),  0), ((169, 1),  78,
            3, (32767, 0),  0), ((327, 12),  78,  6, (32767, 0),  0), ((327, 13),  78,  4, (32767, 0),  0), ((327, 14),
             78,  5, (32767, 0),  0), ((327, 15),  78,  3, (32767, 0),  0), ((328, 24),  78,  10, (32767, 0),  0),
            ((328, 25),  78,  8, (32767, 0),  0), ((328, 26),  78,  8, (32767, 0),  0), ((328, 27),  78,  6, (32767,
            0),  0), ((328, 28),  78,  10, (32767, 0),  0), ((328, 29),  78,  8, (32767, 0),  0), ((328, 30),  78,  8,
            (32767, 0),  0), ((328, 31),  78,  6, (32767, 0),  0), ((328, 32),  78,  9, (32767, 0),  0), ((328, 33),
            78,  7, (32767, 0),  0), ((328, 34),  78,  7, (32767, 0),  0), ((328, 35),  78,  5, (32767, 0),  0)));
            Table.States (830).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (138, 3),  76, 1222)));
            Table.States (831).Action_List.Set_Capacity (2);
            Add_Action (Table.States (831), 116, (143, 0), 1224);
            Add_Action (Table.States (831), 118, (143, 1), 1225);
            Table.States (831).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (831), 141, 1226);
            Add_Goto (Table.States (831), 143, 1227);
            Table.States (831).Kernel := To_Vector ((0 => ((142, 0),  85,  2, (32767, 0),  0)));
            Table.States (831).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (143, 0),  116, 1224)));
            Table.States (832).Action_List.Set_Capacity (2);
            Add_Action (Table.States (832), 61, (434, 0), 299);
            Add_Action (Table.States (832), 108, (128, 3), 1228);
            Table.States (832).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (832), 434, 1229);
            Table.States (832).Kernel := To_Vector ((((128, 2),  129,  3, (32767, 0),  0), ((128, 3),  129,  1, (32767,
            0),  0)));
            Table.States (832).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (128, 3),  108, 1228)));
            Table.States (833).Action_List.Set_Capacity (2);
            Add_Action (Table.States (833), (61, 108), (129, 6),  1);
            Table.States (833).Kernel := To_Vector ((0 => ((129, 6),  138,  0, (129, 6),  1)));
            Table.States (833).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (129, 6),  1)));
            Table.States (834).Action_List.Set_Capacity (2);
            Add_Action (Table.States (834), (61, 108), (129, 0),  1);
            Table.States (834).Kernel := To_Vector ((0 => ((129, 0),  142,  0, (129, 0),  1)));
            Table.States (834).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (129, 0),  1)));
            Table.States (835).Action_List.Set_Capacity (2);
            Add_Action (Table.States (835), (61, 108), (129, 1),  1);
            Table.States (835).Kernel := To_Vector ((0 => ((129, 1),  144,  0, (129, 1),  1)));
            Table.States (835).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (129, 1),  1)));
            Table.States (836).Action_List.Set_Capacity (2);
            Add_Action (Table.States (836), (61, 108), (144, 0),  1);
            Table.States (836).Kernel := To_Vector ((0 => ((144, 0),  145,  0, (144, 0),  1)));
            Table.States (836).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (144, 0),  1)));
            Table.States (837).Action_List.Set_Capacity (2);
            Add_Action (Table.States (837), (61, 108), (144, 1),  1);
            Table.States (837).Kernel := To_Vector ((0 => ((144, 1),  146,  0, (144, 1),  1)));
            Table.States (837).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (144, 1),  1)));
            Table.States (838).Action_List.Set_Capacity (2);
            Add_Action (Table.States (838), (61, 108), (129, 2),  1);
            Table.States (838).Kernel := To_Vector ((0 => ((129, 2),  147,  0, (129, 2),  1)));
            Table.States (838).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (129, 2),  1)));
            Table.States (839).Action_List.Set_Capacity (2);
            Add_Action (Table.States (839), (61, 108), (147, 0),  1);
            Table.States (839).Kernel := To_Vector ((0 => ((147, 0),  148,  0, (147, 0),  1)));
            Table.States (839).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (147, 0),  1)));
            Table.States (840).Action_List.Set_Capacity (2);
            Add_Action (Table.States (840), (61, 108), (147, 1),  1);
            Table.States (840).Kernel := To_Vector ((0 => ((147, 1),  150,  0, (147, 1),  1)));
            Table.States (840).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (147, 1),  1)));
            Table.States (841).Action_List.Set_Capacity (2);
            Add_Action (Table.States (841), (61, 108), (150, 0),  1);
            Table.States (841).Kernel := To_Vector ((0 => ((150, 0),  151,  0, (150, 0),  1)));
            Table.States (841).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (150, 0),  1)));
            Table.States (842).Action_List.Set_Capacity (2);
            Add_Action (Table.States (842), (61, 108), (150, 1),  1);
            Table.States (842).Kernel := To_Vector ((0 => ((150, 1),  152,  0, (150, 1),  1)));
            Table.States (842).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (150, 1),  1)));
            Table.States (843).Action_List.Set_Capacity (2);
            Add_Action (Table.States (843), (61, 108), (129, 3),  1);
            Table.States (843).Kernel := To_Vector ((0 => ((129, 3),  154,  0, (129, 3),  1)));
            Table.States (843).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (129, 3),  1)));
            Table.States (844).Action_List.Set_Capacity (2);
            Add_Action (Table.States (844), (61, 108), (129, 4),  1);
            Table.States (844).Kernel := To_Vector ((0 => ((129, 4),  169,  0, (129, 4),  1)));
            Table.States (844).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (129, 4),  1)));
            Table.States (845).Action_List.Set_Capacity (2);
            Add_Action (Table.States (845), (61, 108), (169, 5),  1);
            Table.States (845).Kernel := To_Vector ((0 => ((169, 5),  170,  0, (169, 5),  1)));
            Table.States (845).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (169, 5),  1)));
            Table.States (846).Action_List.Set_Capacity (2);
            Add_Action (Table.States (846), (61, 108), (129, 7),  1);
            Table.States (846).Kernel := To_Vector ((0 => ((129, 7),  181,  0, (129, 7),  1)));
            Table.States (846).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (129, 7),  1)));
            Table.States (847).Action_List.Set_Capacity (2);
            Add_Action (Table.States (847), (61, 108), (129, 5),  1);
            Table.States (847).Kernel := To_Vector ((0 => ((129, 5),  183,  0, (129, 5),  1)));
            Table.States (847).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (129, 5),  1)));
            Table.States (848).Action_List.Set_Capacity (3);
            Add_Action (Table.States (848), (48, 61, 108), (183, 1),  1);
            Table.States (848).Kernel := To_Vector ((0 => ((183, 1),  184,  0, (183, 1),  1)));
            Table.States (848).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (183, 1),  1)));
            Table.States (849).Action_List.Set_Capacity (1);
            Add_Action (Table.States (849), 56, (183, 2), 1230);
            Table.States (849).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (849), 184, 1231);
            Table.States (849).Kernel := To_Vector ((((183, 0),  187,  2, (32767, 0),  0), ((183, 2),  187,  3, (32767,
            0),  0), ((183, 3),  187,  2, (32767, 0),  0)));
            Table.States (849).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (183, 2),  56, 1230)));
            Table.States (850).Action_List.Set_Capacity (1);
            Add_Action (Table.States (850), 87, (165, 0), 1232);
            Table.States (850).Kernel := To_Vector ((0 => ((165, 0),  92,  1, (32767, 0),  0)));
            Table.States (850).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (165, 0),  87, 1232)));
            Table.States (851).Action_List.Set_Capacity (2);
            Add_Action (Table.States (851), 93, (168, 0), 1233);
            Add_Action (Table.States (851), 95, (136, 1), 280);
            Table.States (851).Kernel := To_Vector ((((136, 1),  136,  2, (32767, 0),  0), ((168, 0),  136,  6, (32767,
            0),  0), ((168, 1),  136,  4, (32767, 0),  0), ((168, 2),  136,  4, (32767, 0),  0), ((168, 3),  136,  2,
            (32767, 0),  0), ((168, 4),  136,  5, (32767, 0),  0), ((168, 5),  136,  3, (32767, 0),  0)));
            Table.States (851).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (168, 0),  93, 1233)));
            Table.States (852).Action_List.Set_Capacity (2);
            Add_Action (Table.States (852), 87, (167, 0), 1234);
            Add_Action (Table.States (852), 108, (166, 1), 1235);
            Table.States (852).Kernel := To_Vector ((((166, 1),  166,  4, (32767, 0),  0), ((166, 2),  166,  4, (32767,
            0),  0), ((167, 0),  166,  1, (32767, 0),  0)));
            Table.States (852).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (167, 0),  87, 1234)));
            Table.States (853).Action_List.Set_Capacity (2);
            Add_Action (Table.States (853), (87, 108), (166, 0),  1);
            Table.States (853).Kernel := To_Vector ((0 => ((166, 0),  168,  0, (166, 0),  1)));
            Table.States (853).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (166, 0),  1)));
            Table.States (854).Action_List.Set_Capacity (6);
            Add_Action (Table.States (854), 27, (327, 10), 1236);
            Add_Action (Table.States (854), 58, (328, 16), 1237);
            Add_Action (Table.States (854), 68, (189, 0), 1238);
            Add_Action (Table.States (854), 76, (328, 20), 1239);
            Add_Action (Table.States (854), 77, (327, 8), 1240);
            Add_Action (Table.States (854), 78, (327, 0), 1241);
            Table.States (854).Kernel := To_Vector ((((189, 0),  82,  2, (32767, 0),  0), ((327, 0),  82,  7, (32767,
            0),  0), ((327, 1),  82,  5, (32767, 0),  0), ((327, 2),  82,  6, (32767, 0),  0), ((327, 3),  82,  4,
            (32767, 0),  0), ((327, 4),  82,  6, (32767, 0),  0), ((327, 5),  82,  4, (32767, 0),  0), ((327, 6),  82,
            5, (32767, 0),  0), ((327, 7),  82,  3, (32767, 0),  0), ((327, 8),  82,  5, (32767, 0),  0), ((327, 9),
            82,  3, (32767, 0),  0), ((327, 10),  82,  4, (32767, 0),  0), ((327, 11),  82,  2, (32767, 0),  0), ((328,
            0),  82,  11, (32767, 0),  0), ((328, 1),  82,  9, (32767, 0),  0), ((328, 2),  82,  9, (32767, 0),  0),
            ((328, 3),  82,  7, (32767, 0),  0), ((328, 4),  82,  11, (32767, 0),  0), ((328, 5),  82,  9, (32767, 0),
            0), ((328, 6),  82,  9, (32767, 0),  0), ((328, 7),  82,  7, (32767, 0),  0), ((328, 8),  82,  10, (32767,
            0),  0), ((328, 9),  82,  8, (32767, 0),  0), ((328, 10),  82,  8, (32767, 0),  0), ((328, 11),  82,  6,
            (32767, 0),  0), ((328, 12),  82,  10, (32767, 0),  0), ((328, 13),  82,  8, (32767, 0),  0), ((328, 14),
            82,  8, (32767, 0),  0), ((328, 15),  82,  6, (32767, 0),  0), ((328, 16),  82,  10, (32767, 0),  0),
            ((328, 17),  82,  8, (32767, 0),  0), ((328, 18),  82,  8, (32767, 0),  0), ((328, 19),  82,  6, (32767,
            0),  0), ((328, 20),  82,  9, (32767, 0),  0), ((328, 21),  82,  7, (32767, 0),  0), ((328, 22),  82,  7,
            (32767, 0),  0), ((328, 23),  82,  5, (32767, 0),  0)));
            Table.States (854).Minimal_Complete_Actions := To_Vector (((Shift, (189, 0),  68, 1238), (Shift, (327, 10),
             27, 1236)));
            Table.States (855).Action_List.Set_Capacity (43);
            Add_Action (Table.States (855), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (189, 1),  4);
            Table.States (855).Kernel := To_Vector ((0 => ((189, 1),  108,  0, (189, 1),  4)));
            Table.States (855).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (189, 1),  4)));
            Table.States (856).Action_List.Set_Capacity (18);
            Add_Action (Table.States (856), 52, (187, 0), 347);
            Add_Action (Table.States (856), 56, (183, 4), 816);
            Add_Action (Table.States (856), 57, (181, 8), 817);
            Add_Action (Table.States (856), 58, (181, 6), 1242);
            Add_Action (Table.States (856), 59, (181, 4), 819);
            Add_Action (Table.States (856), 60, (181, 2), 820);
            Add_Action (Table.States (856), 65, (170, 2), 821);
            Add_Action (Table.States (856), 67, (170, 0), 822);
            Add_Action (Table.States (856), 68, (169, 2), 1243);
            Add_Action (Table.States (856), 70, (156, 0), 519);
            Add_Action (Table.States (856), 71, (151, 0), 824);
            Add_Action (Table.States (856), 72, (148, 0), 825);
            Add_Action (Table.States (856), 73, (146, 0), 826);
            Add_Action (Table.States (856), 74, (145, 0), 827);
            Add_Action (Table.States (856), 76, (138, 9), 1244);
            Add_Action (Table.States (856), 77, (138, 6), 1245);
            Add_Action (Table.States (856), 78, (138, 0), 1246);
            Add_Action (Table.States (856), 85, (142, 0), 831);
            Table.States (856).Goto_List.Set_Capacity (20);
            Add_Goto (Table.States (856), 129, 1247);
            Add_Goto (Table.States (856), 138, 833);
            Add_Goto (Table.States (856), 142, 834);
            Add_Goto (Table.States (856), 144, 835);
            Add_Goto (Table.States (856), 145, 836);
            Add_Goto (Table.States (856), 146, 837);
            Add_Goto (Table.States (856), 147, 838);
            Add_Goto (Table.States (856), 148, 839);
            Add_Goto (Table.States (856), 150, 840);
            Add_Goto (Table.States (856), 151, 841);
            Add_Goto (Table.States (856), 152, 842);
            Add_Goto (Table.States (856), 154, 843);
            Add_Goto (Table.States (856), 156, 524);
            Add_Goto (Table.States (856), 159, 525);
            Add_Goto (Table.States (856), 169, 844);
            Add_Goto (Table.States (856), 170, 845);
            Add_Goto (Table.States (856), 181, 846);
            Add_Goto (Table.States (856), 183, 847);
            Add_Goto (Table.States (856), 184, 848);
            Add_Goto (Table.States (856), 187, 849);
            Table.States (856).Kernel := To_Vector ((((128, 0),  82,  4, (32767, 0),  0), ((128, 1),  82,  2, (32767,
            0),  0)));
            Table.States (856).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (181, 8),  57, 817)));
            Table.States (857).Action_List.Set_Capacity (26);
            Add_Action (Table.States (857), 43, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 45, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 46, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 48, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 52, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 73, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 75, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 85, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 87, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 89, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 95, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 96, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 98, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 99, Reduce, (435, 1),  1);
            Add_Action (Table.States (857), 100, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 101, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 103, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 104, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 106, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 107, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 109, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 110, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 111, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 112, Reduce, (196, 0),  1);
            Add_Action (Table.States (857), 113, (121, 0), 285);
            Add_Conflict (Table.States (857), 113, (196, 0),  1);
            Add_Action (Table.States (857), 114, (121, 1), 286);
            Add_Conflict (Table.States (857), 114, (196, 0),  1);
            Table.States (857).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (857), 121, 920);
            Table.States (857).Kernel := To_Vector ((((196, 0),  116,  0, (196, 0),  1), ((435, 0),  116,  2, (32767,
            0),  0), ((435, 1),  116,  0, (435, 1),  1)));
            Table.States (857).Minimal_Complete_Actions := To_Vector (((Reduce, (196, 0),  1), (Shift, (121, 0),  113,
            285), (Reduce, (435, 1),  1)));
            Table.States (858).Action_List.Set_Capacity (1);
            Add_Action (Table.States (858), 87, (124, 2), 1248);
            Table.States (858).Kernel := To_Vector ((0 => ((124, 2),  122,  2, (32767, 0),  0)));
            Table.States (858).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (124, 2),  87, 1248)));
            Table.States (859).Action_List.Set_Capacity (2);
            Add_Action (Table.States (859), 87, (124, 0), 1249);
            Add_Action (Table.States (859), 95, (123, 1), 1250);
            Table.States (859).Kernel := To_Vector ((((123, 1),  123,  2, (32767, 0),  0), ((124, 0),  123,  2, (32767,
            0),  0)));
            Table.States (859).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (124, 0),  87, 1249)));
            Table.States (860).Action_List.Set_Capacity (2);
            Add_Action (Table.States (860), (87, 95), (123, 0),  1);
            Table.States (860).Kernel := To_Vector ((0 => ((123, 0),  125,  0, (123, 0),  1)));
            Table.States (860).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (123, 0),  1)));
            Table.States (861).Action_List.Set_Capacity (2);
            Add_Action (Table.States (861), (87, 95), (125, 1),  1);
            Table.States (861).Kernel := To_Vector ((0 => ((125, 1),  227,  0, (125, 1),  1)));
            Table.States (861).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (125, 1),  1)));
            Table.States (862).Action_List.Set_Capacity (1);
            Add_Action (Table.States (862), (1 =>  87), (122, 0),  1);
            Table.States (862).Kernel := To_Vector ((0 => ((122, 0),  242,  0, (122, 0),  1)));
            Table.States (862).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (122, 0),  1)));
            Table.States (863).Action_List.Set_Capacity (1);
            Add_Action (Table.States (863), (1 =>  87), (122, 1),  1);
            Table.States (863).Kernel := To_Vector ((0 => ((122, 1),  245,  0, (122, 1),  1)));
            Table.States (863).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (122, 1),  1)));
            Table.States (864).Action_List.Set_Capacity (1);
            Add_Action (Table.States (864), (1 =>  87), (122, 2),  1);
            Table.States (864).Kernel := To_Vector ((0 => ((122, 2),  247,  0, (122, 2),  1)));
            Table.States (864).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (122, 2),  1)));
            Table.States (865).Action_List.Set_Capacity (1);
            Add_Action (Table.States (865), 99, (125, 0), 1251);
            Table.States (865).Kernel := To_Vector ((0 => ((125, 0),  435,  2, (32767, 0),  0)));
            Table.States (865).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (125, 0),  99, 1251)));
            Table.States (866).Action_List.Set_Capacity (1);
            Add_Action (Table.States (866), 87, (252, 0), 1252);
            Table.States (866).Kernel := To_Vector ((0 => ((252, 0),  277,  8, (32767, 0),  0)));
            Table.States (866).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (252, 0),  87, 1252)));
            Table.States (867).Action_List.Set_Capacity (2);
            Add_Action (Table.States (867), (113, 114), (252, 1),  4);
            Table.States (867).Kernel := To_Vector ((0 => ((252, 1),  88,  0, (252, 1),  4)));
            Table.States (867).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (252, 1),  4)));
            Table.States (868).Action_List.Set_Capacity (14);
            Add_Action (Table.States (868), 12, (402, 0), 165);
            Add_Action (Table.States (868), 44, (233, 2), 167);
            Add_Action (Table.States (868), 52, (233, 3), 168);
            Add_Action (Table.States (868), 65, (234, 1), 169);
            Add_Action (Table.States (868), 76, (256, 0), 170);
            Add_Action (Table.States (868), 85, (205, 4), 171);
            Add_Action (Table.States (868), 86, (213, 2), 172);
            Add_Action (Table.States (868), 90, (268, 0), 34);
            Add_Action (Table.States (868), 106, (237, 1), 173);
            Add_Action (Table.States (868), 107, (237, 0), 174);
            Add_Action (Table.States (868), 115, (234, 0), 175);
            Add_Action (Table.States (868), 116, (196, 0), 146);
            Add_Action (Table.States (868), 117, (196, 1), 37);
            Add_Action (Table.States (868), 118, (195, 6), 38);
            Table.States (868).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (868), 195, 176);
            Add_Goto (Table.States (868), 196, 148);
            Add_Goto (Table.States (868), 197, 54);
            Add_Goto (Table.States (868), 198, 55);
            Add_Goto (Table.States (868), 199, 56);
            Add_Goto (Table.States (868), 201, 57);
            Add_Goto (Table.States (868), 205, 177);
            Add_Goto (Table.States (868), 206, 178);
            Add_Goto (Table.States (868), 210, 179);
            Add_Goto (Table.States (868), 211, 180);
            Add_Goto (Table.States (868), 213, 181);
            Add_Goto (Table.States (868), 214, 182);
            Add_Goto (Table.States (868), 215, 183);
            Add_Goto (Table.States (868), 218, 184);
            Add_Goto (Table.States (868), 219, 185);
            Add_Goto (Table.States (868), 220, 186);
            Add_Goto (Table.States (868), 227, 1253);
            Add_Goto (Table.States (868), 228, 188);
            Add_Goto (Table.States (868), 231, 189);
            Add_Goto (Table.States (868), 232, 190);
            Add_Goto (Table.States (868), 233, 191);
            Add_Goto (Table.States (868), 234, 192);
            Add_Goto (Table.States (868), 237, 193);
            Add_Goto (Table.States (868), 251, 58);
            Add_Goto (Table.States (868), 252, 59);
            Add_Goto (Table.States (868), 255, 60);
            Add_Goto (Table.States (868), 256, 194);
            Add_Goto (Table.States (868), 268, 68);
            Add_Goto (Table.States (868), 311, 83);
            Add_Goto (Table.States (868), 402, 195);
            Add_Goto (Table.States (868), 465, 196);
            Table.States (868).Kernel := To_Vector ((0 => ((221, 0),  50,  3, (32767, 0),  0)));
            Table.States (868).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (869).Action_List.Set_Capacity (3);
            Add_Action (Table.States (869), (87, 88, 95), (221, 1),  3);
            Table.States (869).Kernel := To_Vector ((0 => ((221, 1),  314,  0, (221, 1),  3)));
            Table.States (869).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (221, 1),  3)));
            Table.States (870).Action_List.Set_Capacity (14);
            Add_Action (Table.States (870), 12, (402, 0), 165);
            Add_Action (Table.States (870), 44, (233, 2), 167);
            Add_Action (Table.States (870), 52, (233, 3), 168);
            Add_Action (Table.States (870), 65, (234, 1), 169);
            Add_Action (Table.States (870), 76, (256, 0), 170);
            Add_Action (Table.States (870), 85, (205, 4), 171);
            Add_Action (Table.States (870), 86, (213, 2), 172);
            Add_Action (Table.States (870), 90, (268, 0), 34);
            Add_Action (Table.States (870), 106, (237, 1), 173);
            Add_Action (Table.States (870), 107, (237, 0), 174);
            Add_Action (Table.States (870), 115, (234, 0), 175);
            Add_Action (Table.States (870), 116, (196, 0), 146);
            Add_Action (Table.States (870), 117, (196, 1), 37);
            Add_Action (Table.States (870), 118, (195, 6), 38);
            Table.States (870).Goto_List.Set_Capacity (31);
            Add_Goto (Table.States (870), 195, 176);
            Add_Goto (Table.States (870), 196, 148);
            Add_Goto (Table.States (870), 197, 54);
            Add_Goto (Table.States (870), 198, 55);
            Add_Goto (Table.States (870), 199, 56);
            Add_Goto (Table.States (870), 201, 57);
            Add_Goto (Table.States (870), 205, 177);
            Add_Goto (Table.States (870), 206, 178);
            Add_Goto (Table.States (870), 210, 179);
            Add_Goto (Table.States (870), 211, 180);
            Add_Goto (Table.States (870), 213, 181);
            Add_Goto (Table.States (870), 214, 182);
            Add_Goto (Table.States (870), 215, 183);
            Add_Goto (Table.States (870), 218, 184);
            Add_Goto (Table.States (870), 219, 185);
            Add_Goto (Table.States (870), 220, 186);
            Add_Goto (Table.States (870), 227, 1254);
            Add_Goto (Table.States (870), 228, 188);
            Add_Goto (Table.States (870), 231, 189);
            Add_Goto (Table.States (870), 232, 190);
            Add_Goto (Table.States (870), 233, 191);
            Add_Goto (Table.States (870), 234, 192);
            Add_Goto (Table.States (870), 237, 193);
            Add_Goto (Table.States (870), 251, 58);
            Add_Goto (Table.States (870), 252, 59);
            Add_Goto (Table.States (870), 255, 60);
            Add_Goto (Table.States (870), 256, 194);
            Add_Goto (Table.States (870), 268, 68);
            Add_Goto (Table.States (870), 311, 83);
            Add_Goto (Table.States (870), 402, 195);
            Add_Goto (Table.States (870), 465, 196);
            Table.States (870).Kernel := To_Vector ((0 => ((221, 2),  50,  3, (32767, 0),  0)));
            Table.States (870).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
         end Subr_35;
         procedure Subr_36
         is begin
            Table.States (871).Action_List.Set_Capacity (3);
            Add_Action (Table.States (871), (87, 88, 95), (221, 3),  3);
            Table.States (871).Kernel := To_Vector ((0 => ((221, 3),  314,  0, (221, 3),  3)));
            Table.States (871).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (221, 3),  3)));
            Table.States (872).Action_List.Set_Capacity (43);
            Add_Action (Table.States (872), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (335, 5),  4);
            Table.States (872).Kernel := To_Vector ((0 => ((335, 5),  108,  0, (335, 5),  4)));
            Table.States (872).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (335, 5),  4)));
            Table.States (873).Action_List.Set_Capacity (1);
            Add_Action (Table.States (873), 108, (335, 4), 1255);
            Table.States (873).Kernel := To_Vector ((0 => ((335, 4),  434,  1, (32767, 0),  0)));
            Table.States (873).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (335, 4),  108, 1255)));
            Table.States (874).Action_List.Set_Capacity (5);
            Add_Action (Table.States (874), 86, (252, 0), 33);
            Add_Action (Table.States (874), 90, (268, 0), 34);
            Add_Action (Table.States (874), 116, (196, 0), 146);
            Add_Action (Table.States (874), 117, (196, 1), 37);
            Add_Action (Table.States (874), 118, (195, 6), 38);
            Table.States (874).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (874), 195, 1256);
            Add_Goto (Table.States (874), 196, 148);
            Add_Goto (Table.States (874), 197, 54);
            Add_Goto (Table.States (874), 198, 55);
            Add_Goto (Table.States (874), 199, 56);
            Add_Goto (Table.States (874), 201, 57);
            Add_Goto (Table.States (874), 251, 58);
            Add_Goto (Table.States (874), 252, 59);
            Add_Goto (Table.States (874), 255, 60);
            Add_Goto (Table.States (874), 268, 68);
            Add_Goto (Table.States (874), 311, 83);
            Table.States (874).Kernel := To_Vector ((((336, 0),  24,  4, (32767, 0),  0), ((336, 1),  24,  2, (32767,
            0),  0)));
            Table.States (874).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (875).Action_List.Set_Capacity (2);
            Add_Action (Table.States (875), 30, (296, 0), 476);
            Add_Action (Table.States (875), 85, (299, 0), 1257);
            Table.States (875).Goto_List.Set_Capacity (3);
            Add_Goto (Table.States (875), 296, 479);
            Add_Goto (Table.States (875), 297, 1258);
            Add_Goto (Table.States (875), 299, 481);
            Table.States (875).Kernel := To_Vector ((0 => ((188, 11),  53,  2, (32767, 0),  0)));
            Table.States (875).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (296, 0),  30, 476)));
            Table.States (876).Action_List.Set_Capacity (11);
            Add_Action (Table.States (876), 24, Reduce, (295, 1),  0);
            Add_Action (Table.States (876), 33, Reduce, (295, 1),  0);
            Add_Action (Table.States (876), 45, Reduce, (295, 1),  0);
            Add_Action (Table.States (876), 48, Reduce, (295, 1),  0);
            Add_Action (Table.States (876), 61, Reduce, (295, 1),  0);
            Add_Action (Table.States (876), 69, Reduce, (295, 1),  0);
            Add_Action (Table.States (876), 82, Reduce, (295, 1),  0);
            Add_Action (Table.States (876), 85, (299, 0), 1257);
            Add_Action (Table.States (876), 87, Reduce, (295, 1),  0);
            Add_Action (Table.States (876), 94, Reduce, (295, 1),  0);
            Add_Action (Table.States (876), 108, Reduce, (295, 1),  0);
            Table.States (876).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (876), 295, 1259);
            Add_Goto (Table.States (876), 299, 426);
            Table.States (876).Kernel := To_Vector ((0 => ((188, 7),  54,  0, (295, 1),  0)));
            Table.States (876).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (295, 1),  0)));
            Table.States (877).Action_List.Set_Capacity (2);
            Add_Action (Table.States (877), 53, (188, 10), 1260);
            Add_Action (Table.States (877), 54, (188, 6), 1261);
            Table.States (877).Kernel := To_Vector ((((188, 6),  59,  1, (32767, 0),  0), ((188, 10),  59,  3, (32767,
            0),  0)));
            Table.States (877).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (188, 6),  54, 1261)));
            Table.States (878).Action_List.Set_Capacity (5);
            Add_Action (Table.States (878), 86, (252, 0), 33);
            Add_Action (Table.States (878), 90, (268, 0), 34);
            Add_Action (Table.States (878), 116, (196, 0), 146);
            Add_Action (Table.States (878), 117, (196, 1), 37);
            Add_Action (Table.States (878), 118, (195, 6), 38);
            Table.States (878).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (878), 195, 1262);
            Add_Goto (Table.States (878), 196, 148);
            Add_Goto (Table.States (878), 197, 54);
            Add_Goto (Table.States (878), 198, 55);
            Add_Goto (Table.States (878), 199, 56);
            Add_Goto (Table.States (878), 201, 57);
            Add_Goto (Table.States (878), 251, 58);
            Add_Goto (Table.States (878), 252, 59);
            Add_Goto (Table.States (878), 255, 60);
            Add_Goto (Table.States (878), 268, 68);
            Add_Goto (Table.States (878), 311, 83);
            Table.States (878).Kernel := To_Vector ((0 => ((188, 2),  79,  1, (32767, 0),  0)));
            Table.States (878).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (879).Action_List.Set_Capacity (14);
            Add_Action (Table.States (879), 24, Reduce, (188, 3),  2);
            Add_Action (Table.States (879), 33, Reduce, (188, 3),  2);
            Add_Action (Table.States (879), 45, Reduce, (188, 3),  2);
            Add_Action (Table.States (879), 48, Reduce, (188, 3),  2);
            Add_Action (Table.States (879), 61, Reduce, (188, 3),  2);
            Add_Action (Table.States (879), 69, Reduce, (188, 3),  2);
            Add_Action (Table.States (879), 82, Reduce, (188, 3),  2);
            Add_Action (Table.States (879), 85, (198, 0), 281);
            Add_Action (Table.States (879), 87, Reduce, (188, 3),  2);
            Add_Action (Table.States (879), 94, Reduce, (188, 3),  2);
            Add_Action (Table.States (879), 96, (197, 0), 283);
            Add_Action (Table.States (879), 108, Reduce, (188, 3),  2);
            Add_Action (Table.States (879), 113, (121, 0), 285);
            Add_Action (Table.States (879), 114, (121, 1), 286);
            Table.States (879).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (879), 121, 287);
            Add_Goto (Table.States (879), 313, 289);
            Table.States (879).Kernel := To_Vector ((((188, 3),  195,  0, (188, 3),  2), ((197, 0),  195,  2, (32767,
            0),  0), ((198, 0),  195,  3, (32767, 0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2,
            (32767, 0),  0), ((255, 0),  195,  3, (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0)));
            Table.States (879).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (188, 3),  2)));
            Table.States (880).Action_List.Set_Capacity (9);
            Add_Action (Table.States (880), 53, (188, 9), 1263);
            Add_Action (Table.States (880), 54, (188, 5), 1264);
            Add_Action (Table.States (880), 59, (188, 4), 1265);
            Add_Action (Table.States (880), 79, (188, 0), 1266);
            Add_Action (Table.States (880), 86, (252, 0), 33);
            Add_Action (Table.States (880), 90, (268, 0), 34);
            Add_Action (Table.States (880), 116, (196, 0), 146);
            Add_Action (Table.States (880), 117, (196, 1), 37);
            Add_Action (Table.States (880), 118, (195, 6), 38);
            Table.States (880).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (880), 195, 1267);
            Add_Goto (Table.States (880), 196, 148);
            Add_Goto (Table.States (880), 197, 54);
            Add_Goto (Table.States (880), 198, 55);
            Add_Goto (Table.States (880), 199, 56);
            Add_Goto (Table.States (880), 201, 57);
            Add_Goto (Table.States (880), 251, 58);
            Add_Goto (Table.States (880), 252, 59);
            Add_Goto (Table.States (880), 255, 60);
            Add_Goto (Table.States (880), 268, 68);
            Add_Goto (Table.States (880), 311, 83);
            Table.States (880).Kernel := To_Vector ((((188, 0),  56,  2, (32767, 0),  0), ((188, 1),  56,  1, (32767,
            0),  0), ((188, 4),  56,  2, (32767, 0),  0), ((188, 5),  56,  1, (32767, 0),  0), ((188, 8),  56,  4,
            (32767, 0),  0), ((188, 9),  56,  3, (32767, 0),  0)));
            Table.States (880).Minimal_Complete_Actions := To_Vector (((Shift, (196, 0),  116, 146), (Shift, (188, 5),
            54, 1264)));
            Table.States (881).Action_List.Set_Capacity (5);
            Add_Action (Table.States (881), 24, (335, 0), 1268);
            Add_Action (Table.States (881), 85, (198, 0), 281);
            Add_Action (Table.States (881), 96, (197, 0), 283);
            Add_Action (Table.States (881), 113, (121, 0), 285);
            Add_Action (Table.States (881), 114, (121, 1), 286);
            Table.States (881).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (881), 121, 287);
            Add_Goto (Table.States (881), 313, 289);
            Table.States (881).Kernel := To_Vector ((((197, 0),  195,  2, (32767, 0),  0), ((198, 0),  195,  3, (32767,
            0),  0), ((199, 0),  195,  2, (32767, 0),  0), ((201, 0),  195,  2, (32767, 0),  0), ((255, 0),  195,  3,
            (32767, 0),  0), ((311, 0),  195,  3, (32767, 0),  0), ((335, 0),  195,  5, (32767, 0),  0), ((335, 1),
            195,  3, (32767, 0),  0)));
            Table.States (881).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (335, 0),  24, 1268)));
            Table.States (882).Action_List.Set_Capacity (5);
            Add_Action (Table.States (882), 86, (252, 0), 33);
            Add_Action (Table.States (882), 90, (268, 0), 34);
            Add_Action (Table.States (882), 116, (196, 0), 146);
            Add_Action (Table.States (882), 117, (196, 1), 37);
            Add_Action (Table.States (882), 118, (195, 6), 38);
            Table.States (882).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (882), 195, 1269);
            Add_Goto (Table.States (882), 196, 148);
            Add_Goto (Table.States (882), 197, 54);
            Add_Goto (Table.States (882), 198, 55);
            Add_Goto (Table.States (882), 199, 56);
            Add_Goto (Table.States (882), 201, 57);
            Add_Goto (Table.States (882), 251, 58);
            Add_Goto (Table.States (882), 252, 59);
            Add_Goto (Table.States (882), 255, 60);
            Add_Goto (Table.States (882), 268, 68);
            Add_Goto (Table.States (882), 311, 83);
            Table.States (882).Kernel := To_Vector ((((335, 6),  24,  4, (32767, 0),  0), ((335, 7),  24,  2, (32767,
            0),  0)));
            Table.States (882).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (883).Action_List.Set_Capacity (5);
            Add_Action (Table.States (883), 86, (252, 0), 33);
            Add_Action (Table.States (883), 90, (268, 0), 34);
            Add_Action (Table.States (883), 116, (196, 0), 146);
            Add_Action (Table.States (883), 117, (196, 1), 37);
            Add_Action (Table.States (883), 118, (195, 6), 38);
            Table.States (883).Goto_List.Set_Capacity (11);
            Add_Goto (Table.States (883), 195, 1270);
            Add_Goto (Table.States (883), 196, 148);
            Add_Goto (Table.States (883), 197, 54);
            Add_Goto (Table.States (883), 198, 55);
            Add_Goto (Table.States (883), 199, 56);
            Add_Goto (Table.States (883), 201, 57);
            Add_Goto (Table.States (883), 251, 58);
            Add_Goto (Table.States (883), 252, 59);
            Add_Goto (Table.States (883), 255, 60);
            Add_Goto (Table.States (883), 268, 68);
            Add_Goto (Table.States (883), 311, 83);
            Table.States (883).Kernel := To_Vector ((((335, 2),  24,  4, (32767, 0),  0), ((335, 3),  24,  2, (32767,
            0),  0)));
            Table.States (883).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (884).Action_List.Set_Capacity (43);
            Add_Action (Table.States (884), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (394, 1),  4);
            Table.States (884).Kernel := To_Vector ((0 => ((394, 1),  108,  0, (394, 1),  4)));
            Table.States (884).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (394, 1),  4)));
            Table.States (885).Action_List.Set_Capacity (1);
            Add_Action (Table.States (885), 108, (394, 0), 1271);
            Table.States (885).Kernel := To_Vector ((0 => ((394, 0),  434,  1, (32767, 0),  0)));
            Table.States (885).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (394, 0),  108, 1271)));
            Table.States (886).Action_List.Set_Capacity (13);
            Add_Action (Table.States (886), 44, (233, 2), 167);
            Add_Action (Table.States (886), 52, (187, 0), 356);
            Add_Action (Table.States (886), 65, (234, 1), 169);
            Add_Action (Table.States (886), 76, (256, 0), 170);
            Add_Action (Table.States (886), 85, (205, 4), 171);
            Add_Action (Table.States (886), 86, (213, 2), 172);
            Add_Action (Table.States (886), 90, (268, 0), 34);
            Add_Action (Table.States (886), 106, (237, 1), 173);
            Add_Action (Table.States (886), 107, (237, 0), 174);
            Add_Action (Table.States (886), 115, (234, 0), 175);
            Add_Action (Table.States (886), 116, (196, 0), 146);
            Add_Action (Table.States (886), 117, (196, 1), 37);
            Add_Action (Table.States (886), 118, (195, 6), 38);
            Table.States (886).Goto_List.Set_Capacity (36);
            Add_Goto (Table.States (886), 131, 693);
            Add_Goto (Table.States (886), 140, 694);
            Add_Goto (Table.States (886), 155, 1272);
            Add_Goto (Table.States (886), 157, 1273);
            Add_Goto (Table.States (886), 158, 1274);
            Add_Goto (Table.States (886), 160, 1275);
            Add_Goto (Table.States (886), 187, 365);
            Add_Goto (Table.States (886), 195, 1276);
            Add_Goto (Table.States (886), 196, 148);
            Add_Goto (Table.States (886), 197, 54);
            Add_Goto (Table.States (886), 198, 55);
            Add_Goto (Table.States (886), 199, 56);
            Add_Goto (Table.States (886), 201, 57);
            Add_Goto (Table.States (886), 203, 369);
            Add_Goto (Table.States (886), 205, 177);
            Add_Goto (Table.States (886), 206, 178);
            Add_Goto (Table.States (886), 210, 179);
            Add_Goto (Table.States (886), 211, 180);
            Add_Goto (Table.States (886), 213, 181);
            Add_Goto (Table.States (886), 214, 182);
            Add_Goto (Table.States (886), 215, 183);
            Add_Goto (Table.States (886), 218, 184);
            Add_Goto (Table.States (886), 219, 185);
            Add_Goto (Table.States (886), 220, 186);
            Add_Goto (Table.States (886), 231, 696);
            Add_Goto (Table.States (886), 232, 190);
            Add_Goto (Table.States (886), 233, 191);
            Add_Goto (Table.States (886), 234, 192);
            Add_Goto (Table.States (886), 237, 193);
            Add_Goto (Table.States (886), 251, 58);
            Add_Goto (Table.States (886), 252, 59);
            Add_Goto (Table.States (886), 255, 60);
            Add_Goto (Table.States (886), 256, 194);
            Add_Goto (Table.States (886), 268, 68);
            Add_Goto (Table.States (886), 311, 83);
            Add_Goto (Table.States (886), 465, 196);
            Table.States (886).Kernel := To_Vector ((((156, 0),  85,  6, (32767, 0),  0), ((159, 0),  85,  4, (32767,
            0),  0)));
            Table.States (886).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (887).Action_List.Set_Capacity (3);
            Add_Action (Table.States (887), 61, (434, 0), 299);
            Add_Action (Table.States (887), 94, (134, 0), 282);
            Add_Action (Table.States (887), 108, (135, 11), 1277);
            Table.States (887).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (887), 134, 1278);
            Add_Goto (Table.States (887), 434, 1279);
            Table.States (887).Kernel := To_Vector ((((135, 8),  131,  5, (32767, 0),  0), ((135, 9),  131,  3, (32767,
            0),  0), ((135, 10),  131,  3, (32767, 0),  0), ((135, 11),  131,  1, (32767, 0),  0)));
            Table.States (887).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 11),  108, 1277)));
            Table.States (888).Action_List.Set_Capacity (1);
            Add_Action (Table.States (888), 108, (137, 0), 1280);
            Table.States (888).Kernel := To_Vector ((0 => ((137, 0),  134,  1, (32767, 0),  0)));
            Table.States (888).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (137, 0),  108, 1280)));
            Table.States (889).Action_List.Set_Capacity (3);
            Add_Action (Table.States (889), 61, (434, 0), 299);
            Add_Action (Table.States (889), 94, (134, 0), 282);
            Add_Action (Table.States (889), 108, (135, 43), 1281);
            Table.States (889).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (889), 134, 1282);
            Add_Goto (Table.States (889), 434, 1283);
            Table.States (889).Kernel := To_Vector ((((135, 40),  154,  5, (32767, 0),  0), ((135, 41),  154,  3,
            (32767, 0),  0), ((135, 42),  154,  3, (32767, 0),  0), ((135, 43),  154,  1, (32767, 0),  0)));
            Table.States (889).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 43),  108, 1281)));
            Table.States (890).Action_List.Set_Capacity (3);
            Add_Action (Table.States (890), 61, (434, 0), 299);
            Add_Action (Table.States (890), 94, (134, 0), 282);
            Add_Action (Table.States (890), 108, (135, 27), 1284);
            Table.States (890).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (890), 134, 1285);
            Add_Goto (Table.States (890), 434, 1286);
            Table.States (890).Kernel := To_Vector ((((135, 24),  188,  5, (32767, 0),  0), ((135, 25),  188,  3,
            (32767, 0),  0), ((135, 26),  188,  3, (32767, 0),  0), ((135, 27),  188,  1, (32767, 0),  0)));
            Table.States (890).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 27),  108, 1284)));
            Table.States (891).Action_List.Set_Capacity (8);
            Add_Action (Table.States (891), 52, (187, 0), 347);
            Add_Action (Table.States (891), 56, (188, 2), 514);
            Add_Action (Table.States (891), 70, (156, 0), 519);
            Add_Action (Table.States (891), 86, (252, 0), 33);
            Add_Action (Table.States (891), 90, (268, 0), 34);
            Add_Action (Table.States (891), 116, (196, 0), 146);
            Add_Action (Table.States (891), 117, (196, 1), 37);
            Add_Action (Table.States (891), 118, (195, 6), 38);
            Table.States (891).Goto_List.Set_Capacity (17);
            Add_Goto (Table.States (891), 131, 1287);
            Add_Goto (Table.States (891), 154, 1288);
            Add_Goto (Table.States (891), 156, 524);
            Add_Goto (Table.States (891), 159, 525);
            Add_Goto (Table.States (891), 187, 526);
            Add_Goto (Table.States (891), 188, 1289);
            Add_Goto (Table.States (891), 195, 528);
            Add_Goto (Table.States (891), 196, 148);
            Add_Goto (Table.States (891), 197, 54);
            Add_Goto (Table.States (891), 198, 55);
            Add_Goto (Table.States (891), 199, 56);
            Add_Goto (Table.States (891), 201, 57);
            Add_Goto (Table.States (891), 251, 58);
            Add_Goto (Table.States (891), 252, 59);
            Add_Goto (Table.States (891), 255, 60);
            Add_Goto (Table.States (891), 268, 68);
            Add_Goto (Table.States (891), 311, 83);
            Table.States (891).Kernel := To_Vector ((((135, 0),  79,  6, (32767, 0),  0), ((135, 1),  79,  4, (32767,
            0),  0), ((135, 2),  79,  4, (32767, 0),  0), ((135, 3),  79,  2, (32767, 0),  0), ((135, 16),  79,  7,
            (32767, 0),  0), ((135, 17),  79,  5, (32767, 0),  0), ((135, 18),  79,  5, (32767, 0),  0), ((135, 19),
            79,  3, (32767, 0),  0), ((135, 32),  79,  12, (32767, 0),  0), ((135, 33),  79,  10, (32767, 0),  0),
            ((135, 34),  79,  10, (32767, 0),  0), ((135, 35),  79,  8, (32767, 0),  0)));
            Table.States (891).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (892).Action_List.Set_Capacity (3);
            Add_Action (Table.States (892), 61, (434, 0), 299);
            Add_Action (Table.States (892), 94, (134, 0), 282);
            Add_Action (Table.States (892), 108, (135, 7), 1290);
            Table.States (892).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (892), 134, 1291);
            Add_Goto (Table.States (892), 434, 1292);
            Table.States (892).Kernel := To_Vector ((((135, 4),  131,  5, (32767, 0),  0), ((135, 5),  131,  3, (32767,
            0),  0), ((135, 6),  131,  3, (32767, 0),  0), ((135, 7),  131,  1, (32767, 0),  0)));
            Table.States (892).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 7),  108, 1290)));
            Table.States (893).Action_List.Set_Capacity (3);
            Add_Action (Table.States (893), 61, (434, 0), 299);
            Add_Action (Table.States (893), 94, (134, 0), 282);
            Add_Action (Table.States (893), 108, (135, 39), 1293);
            Table.States (893).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (893), 134, 1294);
            Add_Goto (Table.States (893), 434, 1295);
            Table.States (893).Kernel := To_Vector ((((135, 36),  154,  5, (32767, 0),  0), ((135, 37),  154,  3,
            (32767, 0),  0), ((135, 38),  154,  3, (32767, 0),  0), ((135, 39),  154,  1, (32767, 0),  0)));
            Table.States (893).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 39),  108, 1293)));
            Table.States (894).Action_List.Set_Capacity (3);
            Add_Action (Table.States (894), 61, (434, 0), 299);
            Add_Action (Table.States (894), 94, (134, 0), 282);
            Add_Action (Table.States (894), 108, (135, 23), 1296);
            Table.States (894).Goto_List.Set_Capacity (2);
            Add_Goto (Table.States (894), 134, 1297);
            Add_Goto (Table.States (894), 434, 1298);
            Table.States (894).Kernel := To_Vector ((((135, 20),  188,  5, (32767, 0),  0), ((135, 21),  188,  3,
            (32767, 0),  0), ((135, 22),  188,  3, (32767, 0),  0), ((135, 23),  188,  1, (32767, 0),  0)));
            Table.States (894).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 23),  108, 1296)));
            Table.States (895).Action_List.Set_Capacity (43);
            Add_Action (Table.States (895), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (135, 15),  4);
            Table.States (895).Kernel := To_Vector ((0 => ((135, 15),  108,  0, (135, 15),  4)));
            Table.States (895).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (135, 15),  4)));
            Table.States (896).Action_List.Set_Capacity (2);
            Add_Action (Table.States (896), 61, (434, 0), 299);
            Add_Action (Table.States (896), 108, (135, 13), 1299);
            Table.States (896).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (896), 434, 1300);
            Table.States (896).Kernel := To_Vector ((((135, 12),  134,  3, (32767, 0),  0), ((135, 13),  134,  1,
            (32767, 0),  0)));
            Table.States (896).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 13),  108, 1299)));
            Table.States (897).Action_List.Set_Capacity (1);
            Add_Action (Table.States (897), 108, (135, 14), 1301);
            Table.States (897).Kernel := To_Vector ((0 => ((135, 14),  434,  1, (32767, 0),  0)));
            Table.States (897).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 14),  108, 1301)));
            Table.States (898).Action_List.Set_Capacity (43);
            Add_Action (Table.States (898), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (135, 47),  4);
            Table.States (898).Kernel := To_Vector ((0 => ((135, 47),  108,  0, (135, 47),  4)));
            Table.States (898).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (135, 47),  4)));
            Table.States (899).Action_List.Set_Capacity (2);
            Add_Action (Table.States (899), 61, (434, 0), 299);
            Add_Action (Table.States (899), 108, (135, 45), 1302);
            Table.States (899).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (899), 434, 1303);
            Table.States (899).Kernel := To_Vector ((((135, 44),  134,  3, (32767, 0),  0), ((135, 45),  134,  1,
            (32767, 0),  0)));
            Table.States (899).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 45),  108, 1302)));
         end Subr_36;
         procedure Subr_37
         is begin
            Table.States (900).Action_List.Set_Capacity (1);
            Add_Action (Table.States (900), 108, (135, 46), 1304);
            Table.States (900).Kernel := To_Vector ((0 => ((135, 46),  434,  1, (32767, 0),  0)));
            Table.States (900).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 46),  108, 1304)));
            Table.States (901).Action_List.Set_Capacity (43);
            Add_Action (Table.States (901), (12, 13, 15, 17, 18, 19, 20, 21, 22, 25, 27, 28, 30, 31, 32, 35, 36, 37,
            38, 39, 41, 50, 51, 52, 53, 54, 59, 60, 61, 64, 65, 66, 77, 81, 83, 84, 86, 90, 105, 116, 117, 118, 119),
            (135, 31),  4);
            Table.States (901).Kernel := To_Vector ((0 => ((135, 31),  108,  0, (135, 31),  4)));
            Table.States (901).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (135, 31),  4)));
            Table.States (902).Action_List.Set_Capacity (2);
            Add_Action (Table.States (902), 61, (434, 0), 299);
            Add_Action (Table.States (902), 108, (135, 29), 1305);
            Table.States (902).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (902), 434, 1306);
            Table.States (902).Kernel := To_Vector ((((135, 28),  134,  3, (32767, 0),  0), ((135, 29),  134,  1,
            (32767, 0),  0)));
            Table.States (902).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 29),  108, 1305)));
            Table.States (903).Action_List.Set_Capacity (1);
            Add_Action (Table.States (903), 108, (135, 30), 1307);
            Table.States (903).Kernel := To_Vector ((0 => ((135, 30),  434,  1, (32767, 0),  0)));
            Table.States (903).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (135, 30),  108, 1307)));
            Table.States (904).Action_List.Set_Capacity (47);
            Add_Action (Table.States (904), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (198, 0),  4);
            Table.States (904).Kernel := To_Vector ((0 => ((198, 0),  87,  0, (198, 0),  4)));
            Table.States (904).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (198, 0),  4)));
            Table.States (905).Action_List.Set_Capacity (2);
            Add_Action (Table.States (905), (87, 95), (315, 0),  2);
            Table.States (905).Kernel := To_Vector ((0 => ((315, 0),  314,  0, (315, 0),  2)));
            Table.States (905).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (315, 0),  2)));
            Table.States (906).Action_List.Set_Capacity (47);
            Add_Action (Table.States (906), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (313, 1),  3);
            Table.States (906).Kernel := To_Vector ((0 => ((313, 1),  87,  0, (313, 1),  3)));
            Table.States (906).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (313, 1),  3)));
            Table.States (907).Action_List.Set_Capacity (47);
            Add_Action (Table.States (907), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (313, 2),  3);
            Table.States (907).Kernel := To_Vector ((0 => ((313, 2),  87,  0, (313, 2),  3)));
            Table.States (907).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (313, 2),  3)));
            Table.States (908).Action_List.Set_Capacity (47);
            Add_Action (Table.States (908), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (313, 3),  3);
            Table.States (908).Kernel := To_Vector ((0 => ((313, 3),  87,  0, (313, 3),  3)));
            Table.States (908).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (313, 3),  3)));
            Table.States (909).Action_List.Set_Capacity (47);
            Add_Action (Table.States (909), (11, 24, 30, 33, 36, 42, 43, 45, 46, 47, 48, 49, 50, 52, 61, 63, 69, 71,
            72, 73, 74, 75, 82, 85, 87, 88, 89, 91, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109,
            110, 111, 112, 113, 114), (313, 0),  3);
            Table.States (909).Kernel := To_Vector ((0 => ((313, 0),  87,  0, (313, 0),  3)));
            Table.States (909).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (313, 0),  3)));
            Table.States (910).Action_List.Set_Capacity (16);
            Add_Action (Table.States (910), 12, (402, 0), 165);
            Add_Action (Table.States (910), 44, (233, 2), 167);
            Add_Action (Table.States (910), 52, (233, 3), 168);
            Add_Action (Table.States (910), 62, (200, 2), 531);
            Add_Action (Table.States (910), 65, (234, 1), 169);
            Add_Action (Table.States (910), 76, (256, 0), 170);
            Add_Action (Table.States (910), 85, (205, 4), 171);
            Add_Action (Table.States (910), 86, (213, 2), 172);
            Add_Action (Table.States (910), 90, (268, 0), 34);
            Add_Action (Table.States (910), 92, (315, 2), 532);
            Add_Action (Table.States (910), 106, (237, 1), 173);
            Add_Action (Table.States (910), 107, (237, 0), 174);
            Add_Action (Table.States (910), 115, (234, 0), 175);
            Add_Action (Table.States (910), 116, (196, 0), 146);
            Add_Action (Table.States (910), 117, (196, 1), 37);
            Add_Action (Table.States (910), 118, (195, 6), 360);
            Table.States (910).Goto_List.Set_Capacity (34);
            Add_Goto (Table.States (910), 195, 176);
            Add_Goto (Table.States (910), 196, 367);
            Add_Goto (Table.States (910), 197, 54);
            Add_Goto (Table.States (910), 198, 55);
            Add_Goto (Table.States (910), 199, 56);
            Add_Goto (Table.States (910), 200, 368);
            Add_Goto (Table.States (910), 201, 57);
            Add_Goto (Table.States (910), 205, 177);
            Add_Goto (Table.States (910), 206, 178);
            Add_Goto (Table.States (910), 209, 536);
            Add_Goto (Table.States (910), 210, 179);
            Add_Goto (Table.States (910), 211, 180);
            Add_Goto (Table.States (910), 213, 181);
            Add_Goto (Table.States (910), 214, 182);
            Add_Goto (Table.States (910), 215, 183);
            Add_Goto (Table.States (910), 218, 184);
            Add_Goto (Table.States (910), 219, 185);
            Add_Goto (Table.States (910), 220, 186);
            Add_Goto (Table.States (910), 227, 537);
            Add_Goto (Table.States (910), 228, 188);
            Add_Goto (Table.States (910), 231, 189);
            Add_Goto (Table.States (910), 232, 190);
            Add_Goto (Table.States (910), 233, 191);
            Add_Goto (Table.States (910), 234, 192);
            Add_Goto (Table.States (910), 237, 193);
            Add_Goto (Table.States (910), 251, 58);
            Add_Goto (Table.States (910), 252, 59);
            Add_Goto (Table.States (910), 255, 60);
            Add_Goto (Table.States (910), 256, 194);
            Add_Goto (Table.States (910), 268, 68);
            Add_Goto (Table.States (910), 311, 83);
            Add_Goto (Table.States (910), 315, 1308);
            Add_Goto (Table.States (910), 402, 195);
            Add_Goto (Table.States (910), 465, 196);
            Table.States (910).Kernel := To_Vector ((0 => ((312, 1),  95,  1, (32767, 0),  0)));
            Table.States (910).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (234, 0),  115, 175)));
            Table.States (911).Action_List.Set_Capacity (5);
            Add_Action (Table.States (911), 86, (252, 0), 33);
            Add_Action (Table.States (911), 90, (268, 0), 34);
            Add_Action (Table.States (911), 116, (196, 0), 146);
            Add_Action (Table.States (911), 117, (196, 1), 37);
            Add_Action (Table.States (911), 118, (195, 6), 38);
            Table.States (911).Goto_List.Set_Capacity (12);
            Add_Goto (Table.States (911), 195, 1309);
            Add_Goto (Table.States (911), 196, 148);
            Add_Goto (Table.States (911), 197, 54);
            Add_Goto (Table.States (911), 198, 55);
            Add_Goto (Table.States (911), 199, 56);
            Add_Goto (Table.States (911), 201, 57);
            Add_Goto (Table.States (911), 251, 58);
            Add_Goto (Table.States (911), 252, 59);
            Add_Goto (Table.States (911), 254, 1310);
            Add_Goto (Table.States (911), 255, 60);
            Add_Goto (Table.States (911), 268, 68);
            Add_Goto (Table.States (911), 311, 83);
            Table.States (911).Kernel := To_Vector ((0 => ((253, 0),  85,  4, (32767, 0),  0)));
            Table.States (911).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (196, 0),  116, 146)));
            Table.States (912).Action_List.Set_Capacity (1);
            Add_Action (Table.States (912), 36, (275, 1), 1311);
            Table.States (912).Kernel := To_Vector ((0 => ((275, 1),  66,  2, (32767, 0),  0)));
            Table.States (912).Minimal_Complete_Actions := To_Vector ((0 => (Shift, (275, 1),  36, 1311)));
            Table.States (913).Action_List.Set_Capacity (2);
            Add_Action (Table.States (913), 108, Reduce, (284, 1),  0);
            Add_Action (Table.States (913), 116, (284, 0), 1312);
            Table.States (913).Goto_List.Set_Capacity (1);
            Add_Goto (Table.States (913), 284, 1313);
            Table.States (913).Kernel := To_Vector ((0 => ((286, 1),  66,  1, (32767, 0),  0)));
            Table.States (913).Minimal_Complete_Actions := To_Vector ((0 => (Reduce, (284, 1),  0)));
            Table.States (914).Action_List.Set_Capacity (25);
            Add_Action (Table.States (914), 12, (401, 0), 1);
            Add_Action (Table.States (914), 15, (370, 0), 3);
            Add_Action (Table.States (914), 17, (365, 0), 4);
            Add_Action (Table.States (914), 18, (382, 0), 5);
            Add_Action (Table.States (914), 19, (363, 0), 6);
            Add_Action (Table.States (914), 20, (357, 0), 7);
            Add_Action (Table.States (914), 30, (316, 0), 13);
            Add_Action (Table.States (914), 31, (290, 0), 14);
            Add_Action (Table.States (914), 32, (289, 0), 15);
            Add_Action (Table.States (914), 35, Reduce, (285, 1),  0);
            Add_Action (Table.States (914), 36, Reduce, (285, 1),  0);
            Add_Action (Table.States (914), 37, (288, 0), 17);
            Add_Conflict (Table.States (914), 37, (285, 1),  0);
            Add_Action (Table.States (914), 38, Reduce, (285, 1),  0);
            Add_Action (Table.States (914), 39, Reduce, (285, 1),  0);
            Add_Action (Table.States (914), 41, (271, 0), 18);
        