/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Grappa;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionDisplay {
    private String title = null;
    Exception exception = null;
    Display display = null;

    public ExceptionDisplay(String title) {
        this.title = title;
    }

    public void displayException(Exception ex) {
        this.displayException(ex, null);
    }

    public void displayException(Exception ex, String msg) {
        if (this.display == null) {
            this.display = new Display(this.title);
        }
        this.exception = ex;
        if (ex == null && msg == null) {
            return;
        }
        if (msg != null) {
            if (ex == null) {
                this.display.setText(msg);
            } else {
                this.display.setText(msg + Grappa.NEW_LINE + ex.getMessage());
            }
        } else {
            this.display.setText(ex.getMessage());
        }
        this.display.setVisible(true);
    }

    class Display
    extends Frame {
        private TextArea textarea;
        private Panel buttonPanel;
        private Button trace;
        private Button dismiss;
        private WindowObserver observer;

        Display(String title) {
            super(title);
            this.textarea = null;
            this.buttonPanel = null;
            this.trace = null;
            this.dismiss = null;
            this.observer = null;
            this.observer = new WindowObserver();
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridwidth = 0;
            this.setLayout(gbl);
            this.textarea = new TextArea("", 7, 80);
            this.textarea.setEditable(false);
            this.buttonPanel = new Panel();
            this.buttonPanel.setLayout(new BorderLayout());
            this.trace = new Button("Stack Trace");
            this.trace.addActionListener(this.observer);
            this.dismiss = new Button("Dismiss");
            this.dismiss.addActionListener(this.observer);
            this.buttonPanel.add("West", this.trace);
            this.buttonPanel.add("East", this.dismiss);
            gbc.fill = 1;
            gbl.setConstraints(this.textarea, gbc);
            this.add(this.textarea);
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbl.setConstraints(this.buttonPanel, gbc);
            this.add(this.buttonPanel);
            this.addWindowListener(this.observer);
            this.pack();
        }

        void setText(String text) {
            if (text == null) {
                text = "No message to display, try stack trace.";
            }
            this.textarea.setText(text);
        }

        Exception getException() {
            return ExceptionDisplay.this.exception;
        }

        class WindowObserver
        extends WindowAdapter
        implements ActionListener {
            WindowObserver() {
            }

            public void windowClosing(WindowEvent evt) {
                this.dismiss();
            }

            private void dismiss() {
                Display.this.setVisible(false);
                Display.this.dispose();
                ExceptionDisplay.this.display = null;
            }

            public void actionPerformed(ActionEvent evt) {
                Object src = evt.getSource();
                if (src instanceof Button) {
                    Button btn = (Button)src;
                    if (btn.getLabel().equals("Dismiss")) {
                        Display.this.setVisible(false);
                    } else if (btn.getLabel().equals("Stack Trace")) {
                        if (Display.this.getException() == null) {
                            Display.this.setText("No stack trace available (exception is null).");
                        } else {
                            StringWriter swriter = new StringWriter();
                            PrintWriter pwriter = new PrintWriter(swriter);
                            Display.this.getException().printStackTrace(pwriter);
                            pwriter.flush();
                            Display.this.setText(swriter.toString());
                            pwriter.close();
                        }
                    }
                }
            }
        }
    }
}

