/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.Command;
import com.parctechnologies.eclipse.visualisation.ScenarioIterator;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Scenario
implements Serializable {
    private Object viewableName;
    private LinkedList eventList;

    public Scenario(String string) {
        this.setViewableName(string);
        this.eventList = new LinkedList();
    }

    public void add(Object object, int n) {
        if (object instanceof VisEvent) {
            this.addEvent((VisEvent)object, n);
        } else if (object instanceof Command) {
            this.addCommand((Command)object, n);
        } else {
            throw new IllegalArgumentException("Scenario was unable to add an object of type " + String.valueOf(object.getClass()));
        }
    }

    public void addEvent(VisEvent visEvent, int n) {
        this.eventList.add(new EventCommandList(visEvent));
    }

    public void addCommand(Command command, int n) {
        ((EventCommandList)this.eventList.getLast()).add(command, n);
    }

    public Object getViewableName() {
        return this.viewableName;
    }

    public void setViewableName(String string) {
        this.viewableName = string;
    }

    List getEventList() {
        return this.eventList;
    }

    public ScenarioIterator iterator() {
        return new ScenarioIterator(this);
    }

    public void save(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\n\nScenario for " + String.valueOf(this.viewableName) + "\n");
        for (EventCommandList eventCommandList : this.eventList) {
            stringBuffer.append(eventCommandList.toString());
        }
        return stringBuffer.toString();
    }

    final class EventCommandList
    implements Serializable {
        private VisEvent visEvent;
        private List commandList;
        private List stateList;

        public final List getCommandList() {
            return this.commandList;
        }

        public final List getCommandList(int n) {
            LinkedList<Command> linkedList = new LinkedList<Command>();
            Iterator iterator = this.commandList.iterator();
            Iterator iterator2 = this.stateList.iterator();
            while (iterator.hasNext()) {
                Command command = (Command)iterator.next();
                Integer n2 = (Integer)iterator2.next();
                if (n2 != n) continue;
                linkedList.add(command);
            }
            return linkedList;
        }

        private final void setCommandList(List list) {
            this.commandList = list;
        }

        public final VisEvent getVisEvent() {
            return this.visEvent;
        }

        private final void setVisEvent(VisEvent visEvent) {
            this.visEvent = visEvent;
        }

        public EventCommandList(VisEvent visEvent) {
            this.setCommandList(new LinkedList());
            this.stateList = new LinkedList();
            this.setVisEvent(visEvent);
        }

        public final void add(Command command, int n) {
            this.commandList.add(command);
            this.stateList.add(new Integer(n));
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("\nCommandList\n");
            LinkedList linkedList = new LinkedList();
            Iterator iterator = this.commandList.iterator();
            Iterator iterator2 = this.stateList.iterator();
            while (iterator.hasNext()) {
                Command command = (Command)iterator.next();
                Integer n = (Integer)iterator2.next();
                stringBuffer.append("state:" + n + " command:" + String.valueOf(command));
            }
            return stringBuffer.toString();
        }
    }
}

