/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Grappa;
import att.grappa.GrappaConstants;
import att.grappa.GrappaPoint;
import att.grappa.GrappaSupport;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GrappaShape
implements GrappaConstants,
Cloneable,
Shape {
    protected GeneralPath path = new GeneralPath(Grappa.windingRule);
    private static final double RBCONST = 12.0;
    private static final double RBCURVE = 0.5;
    private static final double CIRCLE_XDIAG = Math.sqrt(0.4375);
    private static final double CIRCLE_YDIAG = 0.75;

    public GrappaShape(int type, double x, double y, double width, double height, int sidesArg, int peripheriesArg, double distortionArg, double skewArg, double orientationArg, boolean roundedArg, boolean diagonalsArg, Object extra) {
        GrappaPoint Pt0;
        double gSkew;
        double gDist;
        double skewDist;
        int i;
        int sides = 120;
        int peripheries = 1;
        double distortion = 0.0;
        double skew = 0.0;
        double orientation = 0.0;
        boolean rounded = false;
        boolean diagonals = false;
        float[] rects = null;
        Point2D.Float rectsMin = null;
        Point2D.Float rectsMax = null;
        switch (type &= 0x3FF) {
            case 27: {
                diagonals = true;
                type = 2;
            }
            case 2: {
                sides = 4;
                break;
            }
            case 25: {
                diagonals = true;
                type = 3;
            }
            case 3: {
                sides = 4;
                orientation = 0.7853981633974483;
                break;
            }
            case 4: {
                peripheries = 2;
                break;
            }
            case 5: {
                sides = 8;
                peripheries = 2;
                break;
            }
            case 6: {
                distortion = -0.3;
                break;
            }
            case 7: {
                sides = 6;
                break;
            }
            case 8: {
                sides = 5;
                distortion = -0.64;
                break;
            }
            case 9: {
                sides = 5;
                distortion = -0.64;
                orientation = Math.PI;
                break;
            }
            case 10: {
                sides = 4;
                distortion = -0.4;
                orientation = Math.PI;
                break;
            }
            case 11: {
                sides = 3;
                orientation = Math.PI;
                break;
            }
            case 26: {
                rounded = true;
                type = 19;
            }
            case 19: {
                sides = 4;
                break;
            }
            case 14: {
                sides = 4;
                skew = 0.6;
                break;
            }
            case 15: {
                sides = 5;
                break;
            }
            case 12: {
                sides = 8;
                break;
            }
            case 16: {
                sides = 0;
                break;
            }
            case 20: {
                sides = 4;
                rounded = true;
                break;
            }
            case 21: {
                sides = 4;
                distortion = -0.4;
                break;
            }
            case 22: {
                sides = 3;
                break;
            }
            case 23: {
                sides = 8;
                peripheries = 3;
                break;
            }
            case 24: {
                diagonals = true;
                type = 13;
            }
            default: {
                break;
            }
            case 28: {
                sidesArg = 4;
                peripheriesArg = 0;
                distortionArg = 0.0;
                skewArg = 0.0;
                orientationArg = 0.0;
                roundedArg = false;
                diagonalsArg = false;
                extra = null;
            }
        }
        sides = sidesArg >= 0 ? sidesArg : sides;
        peripheries = peripheriesArg >= 0 ? peripheriesArg : peripheries;
        distortion = distortionArg != 0.0 ? distortionArg : distortion;
        skew = skewArg != 0.0 ? skewArg : skew;
        orientation = orientationArg != 0.0 ? orientationArg : orientation;
        rounded = roundedArg ? roundedArg : rounded;
        boolean bl = diagonals = diagonalsArg ? diagonalsArg : diagonals;
        if (sides < 3) {
            sides = 0;
        }
        if (type == 13 || type == 17) {
            sides = 120;
        } else if (type == 19) {
            sides = 4;
            peripheries = 1;
            distortion = 0.0;
            skew = 0.0;
            orientation = 0.0;
            diagonals = false;
            if (extra != null && extra instanceof String) {
                rects = GrappaSupport.floatArrayForTuple((String)extra);
                if (rects.length % 4 == 0) {
                    rectsMin = new Point2D.Float();
                    rectsMax = new Point2D.Float();
                    rectsMax.x = rectsMin.x = rects[0];
                    rectsMax.y = Grappa.negateStringYCoord ? (rectsMin.y = -rects[1]) : (rectsMin.y = rects[1]);
                    for (i = 0; i < rects.length; i += 2) {
                        if (Grappa.negateStringYCoord) {
                            rects[i + 1] = -rects[i + 1];
                        }
                        if (rects[i] < rectsMin.x) {
                            rectsMin.x = rects[i];
                        }
                        if (rects[i] > rectsMax.x) {
                            rectsMax.x = rects[i];
                        }
                        if (rects[i + 1] < rectsMin.y) {
                            rectsMin.y = rects[i + 1];
                        }
                        if (!(rects[i + 1] > rectsMax.y)) continue;
                        rectsMax.y = rects[i + 1];
                    }
                    width = rectsMax.x - rectsMin.x;
                    height = rectsMax.y - rectsMin.y;
                    x = (double)rectsMin.x + width / 2.0;
                    y = (double)rectsMin.y + height / 2.0;
                } else {
                    rects = null;
                }
            }
        }
        if (peripheries < 1 || sides == 0) {
            this.path.moveTo((float)x, (float)y);
            return;
        }
        double sectorAngle = Math.PI * 2 / (double)sides;
        double sideLength = Math.sin(sectorAngle / 2.0);
        if (skew == 0.0 && distortion == 0.0) {
            skewDist = 1.0;
            gDist = 0.0;
            gSkew = 0.0;
        } else {
            skewDist = Math.abs(distortion) + Math.abs(skew);
            skewDist = Math.sqrt(skewDist * skewDist + 1.0);
            gDist = distortion * Math.sqrt(2.0) / Math.cos(sectorAngle / 2.0);
            gSkew = skew / 2.0;
        }
        GrappaPoint Rpt = new GrappaPoint();
        GrappaPoint Ppt = new GrappaPoint();
        GrappaPoint Bpt = new GrappaPoint();
        int verts = 0;
        GrappaPoint[] rawVertices = new GrappaPoint[sides];
        GrappaPoint[] tmpVertices = null;
        if (diagonals) {
            tmpVertices = new GrappaPoint[2 * sides];
        } else if (rounded) {
            tmpVertices = new GrappaPoint[4 * sides];
        }
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        int tverts = 0;
        double delta_w = 0.0;
        double delta_h = 0.0;
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        boolean tooSmall = false;
        tmp1 = (peripheries - 1) * 8;
        if (width - tmp1 <= 0.0 || height - tmp2 <= 0.0) {
            peripheries = 1;
        }
        for (int j = 0; j < peripheries; ++j) {
            double cosX;
            double sinX;
            double dtmp;
            double alpha;
            if (j > 0) {
                if (j == 1) {
                    Ppt.x = rawVertices[sides - 1].x;
                    Ppt.y = rawVertices[sides - 1].y;
                    Rpt.x = rawVertices[0].x;
                    Rpt.y = rawVertices[0].y;
                    double beta = Math.atan2(Rpt.y - Ppt.y, Rpt.x - Ppt.x);
                    for (i = 0; i < sides; ++i) {
                        Ppt.x = Rpt.x;
                        Ppt.y = Rpt.y;
                        Rpt.x = rawVertices[(i + 1) % sides].x;
                        Rpt.y = rawVertices[(i + 1) % sides].y;
                        alpha = beta;
                        beta = Math.atan2(Rpt.y - Ppt.y, Rpt.x - Ppt.x);
                        tmp1 = (alpha + Math.PI - beta) / 2.0;
                        dtmp = 4.0 / Math.sin(tmp1);
                        tmp2 = alpha - tmp1;
                        sinX = Math.sin(tmp2);
                        cosX = Math.cos(tmp2);
                        tmp1 = Ppt.x - (cosX *= dtmp);
                        tmp2 = Ppt.y - (sinX *= dtmp);
                        if (i == 0) {
                            maxX = minX = tmp1;
                            maxY = minY = tmp2;
                            continue;
                        }
                        if (minX > tmp1) {
                            minX = tmp1;
                        }
                        if (maxX < tmp1) {
                            maxX = tmp1;
                        }
                        if (minY > tmp2) {
                            minY = tmp2;
                        }
                        if (!(maxY < tmp2)) continue;
                        maxY = tmp2;
                    }
                    delta_w = width - (maxX - minX);
                    delta_h = height - (maxY - minY);
                }
                width -= delta_w;
                height -= delta_h;
            }
            double angle = (sectorAngle - Math.PI) / 2.0;
            sinX = Math.sin(angle);
            cosX = Math.cos(angle);
            Rpt.x = 0.5 * cosX;
            Rpt.y = 0.5 * sinX;
            angle += (Math.PI - sectorAngle) / 2.0;
            Bpt.x = 0.0;
            Bpt.y = 0.0;
            verts = 0;
            for (i = 0; i < sides; ++i) {
                sinX = Math.sin(angle += sectorAngle);
                cosX = Math.cos(angle);
                Rpt.x += sideLength * cosX;
                Rpt.y += sideLength * sinX;
                Ppt.x = Rpt.x * (skewDist + Rpt.y * gDist) + Rpt.y * gSkew;
                Ppt.y = Rpt.y;
                if (orientation != 0.0) {
                    alpha = orientation + Math.atan2(Ppt.y, Ppt.x);
                    sinX = Math.sin(alpha);
                    cosX = Math.cos(alpha);
                    dtmp = Ppt.distance(0.0, 0.0);
                    Ppt.x = dtmp * cosX;
                    Ppt.y = dtmp * sinX;
                }
                Ppt.x *= width;
                Ppt.y *= height;
                rawVertices[verts++] = (GrappaPoint)Ppt.clone();
                if (Bpt.x < Math.abs(Ppt.x)) {
                    Bpt.x = Math.abs(Ppt.x);
                }
                if (!(Bpt.y < Math.abs(Ppt.y))) continue;
                Bpt.y = Math.abs(Ppt.y);
            }
            Bpt.x = width / (2.0 * Bpt.x);
            Bpt.y = height / (2.0 * Bpt.y);
            for (i = 0; i < sides; ++i) {
                rawVertices[i].x *= Bpt.x;
                rawVertices[i].y *= Bpt.y;
            }
            if ((rounded || diagonals) && type != 13 && type != 17 && j == peripheries - 1) {
                tooSmall = false;
                tverts = 0;
                Pt0 = rawVertices[0];
                for (i = 0; i < sides; ++i) {
                    Pt0 = rawVertices[i];
                    GrappaPoint Pt1 = i < sides - 1 ? rawVertices[i + 1] : rawVertices[0];
                    tmp2 = Pt0.distance(Pt1);
                    if (tmp2 < 12.0) {
                        tooSmall = true;
                        break;
                    }
                    tmp1 = 12.0 / tmp2;
                    if (!diagonals) {
                        tmp2 = 0.5 * tmp1;
                        tmpVertices[tverts++] = new GrappaPoint(Pt0.x + tmp2 * (Pt1.x - Pt0.x), Pt0.y + tmp2 * (Pt1.y - Pt0.y));
                    }
                    tmpVertices[tverts++] = new GrappaPoint(Pt0.x + tmp1 * (Pt1.x - Pt0.x), Pt0.y + tmp1 * (Pt1.y - Pt0.y));
                    tmp1 = 1.0 - tmp1;
                    tmpVertices[tverts++] = new GrappaPoint(Pt0.x + tmp1 * (Pt1.x - Pt0.x), Pt0.y + tmp1 * (Pt1.y - Pt0.y));
                    if (diagonals) continue;
                    tmp2 = 1.0 - tmp2;
                    tmpVertices[tverts++] = new GrappaPoint(Pt0.x + tmp2 * (Pt1.x - Pt0.x), Pt0.y + tmp2 * (Pt1.y - Pt0.y));
                }
                if (tooSmall) {
                    for (i = 0; i < sides; ++i) {
                        if (i == 0) {
                            this.path.moveTo((float)(x + rawVertices[i].x), (float)(y - rawVertices[i].y));
                            continue;
                        }
                        this.path.lineTo((float)(x + rawVertices[i].x), (float)(y - rawVertices[i].y));
                    }
                } else if (diagonals) {
                    this.path.moveTo((float)(x + tmpVertices[0].x), (float)(y - tmpVertices[0].y));
                    for (i = 2 * sides - 1; i > 0; i -= 2) {
                        this.path.lineTo((float)(x + tmpVertices[i].x), (float)(y - tmpVertices[i].y));
                        this.path.moveTo((float)(x + tmpVertices[i - 1].x), (float)(y - tmpVertices[i - 1].y));
                    }
                    for (i = 0; i < sides; ++i) {
                        if (i == 0) {
                            this.path.moveTo((float)(x + rawVertices[i].x), (float)(y - rawVertices[i].y));
                            continue;
                        }
                        this.path.lineTo((float)(x + rawVertices[i].x), (float)(y - rawVertices[i].y));
                    }
                } else {
                    this.path.moveTo((float)(x + tmpVertices[2].x), (float)(y - tmpVertices[2].y));
                    for (i = 3; i < 4 * sides - 2; i += 4) {
                        this.path.curveTo((float)(x + tmpVertices[i].x), (float)(y - tmpVertices[i].y), (float)(x + tmpVertices[i + 1].x), (float)(y - tmpVertices[i + 1].y), (float)(x + tmpVertices[i + 2].x), (float)(y - tmpVertices[i + 2].y));
                        this.path.lineTo((float)(x + tmpVertices[i + 3].x), (float)(y - tmpVertices[i + 3].y));
                    }
                    i = 4 * sides - 1;
                    this.path.curveTo((float)(x + tmpVertices[i].x), (float)(y - tmpVertices[i].y), (float)(x + tmpVertices[0].x), (float)(y - tmpVertices[0].y), (float)(x + tmpVertices[1].x), (float)(y - tmpVertices[1].y));
                }
            } else {
                for (i = 0; i < sides; ++i) {
                    if (i == 0) {
                        this.path.moveTo((float)(x + rawVertices[i].x), (float)(y - rawVertices[i].y));
                        continue;
                    }
                    this.path.lineTo((float)(x + rawVertices[i].x), (float)(y - rawVertices[i].y));
                }
            }
            this.path.closePath();
        }
        if (type == 13 && diagonals) {
            Pt0 = new GrappaPoint(width * CIRCLE_XDIAG / 2.0, height * 0.75 / 2.0);
            Ppt.x = x + Pt0.x;
            Ppt.y = y - Pt0.y;
            Rpt.x = Ppt.x - 2.0 * Pt0.x;
            Rpt.y = Ppt.y;
            this.path.moveTo((float)Ppt.x, (float)Ppt.y);
            this.path.lineTo((float)Rpt.x, (float)Rpt.y);
            Ppt.y += 2.0 * Pt0.y - 1.0;
            Rpt.y = Ppt.y;
            this.path.moveTo((float)Ppt.x, (float)Ppt.y);
            this.path.lineTo((float)Rpt.x, (float)Rpt.y);
        } else if (type == 19 && rects != null) {
            for (i = 0; i < rects.length; i += 4) {
                if (rects[i] > rects[i + 2]) {
                    float tmp = rects[i];
                    rects[i] = rects[i + 2];
                    rects[i + 2] = tmp;
                }
                if (rects[i + 1] > rects[i + 3]) {
                    float tmp = rects[i + 1];
                    rects[i + 1] = rects[i + 3];
                    rects[i + 3] = tmp;
                }
                if (rects[i] != rectsMin.x || rects[i + 2] != rectsMax.x || rects[i + 1] != rectsMin.y) {
                    this.path.moveTo(rects[i], rects[i + 1]);
                    this.path.lineTo(rects[i + 2], rects[i + 1]);
                }
                if (rects[i + 2] != rectsMax.x || rects[i + 1] != rectsMin.y || rects[i + 3] != rectsMax.y) {
                    this.path.moveTo(rects[i + 2], rects[i + 1]);
                    this.path.lineTo(rects[i + 2], rects[i + 3]);
                }
                if (rects[i] != rectsMin.x || rects[i + 2] != rectsMax.x || rects[i + 3] != rectsMax.y) {
                    this.path.moveTo(rects[i + 2], rects[i + 3]);
                    this.path.lineTo(rects[i], rects[i + 3]);
                }
                if (rects[i] == rectsMin.x && rects[i + 1] == rectsMin.y && rects[i + 3] == rectsMax.y) continue;
                this.path.moveTo(rects[i], rects[i + 3]);
                this.path.lineTo(rects[i], rects[i + 1]);
            }
        }
    }

    public Object clone() {
        try {
            GrappaShape copy = (GrappaShape)super.clone();
            copy.path = (GeneralPath)this.path.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public final boolean contains(double x, double y) {
        return this.path.contains(x, y);
    }

    public final boolean contains(double x, double y, double width, double height) {
        return this.path.contains(x, y, width, height);
    }

    public final boolean contains(Point2D p) {
        return this.path.contains(p);
    }

    public final boolean contains(Rectangle2D r) {
        return this.path.contains(r);
    }

    public final Rectangle getBounds() {
        return this.path.getBounds2D().getBounds();
    }

    public final Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    public final PathIterator getPathIterator() {
        return this.path.getPathIterator(null);
    }

    public final PathIterator getPathIterator(AffineTransform at) {
        return this.path.getPathIterator(at);
    }

    public final PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.path.getPathIterator(at), flatness);
    }

    public final boolean intersects(double x, double y, double width, double height) {
        return this.path.intersects(x, y, width, height);
    }

    public final boolean intersects(Rectangle2D r) {
        return this.path.intersects(r);
    }
}

