/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.Colors;
import ie.ucc.cccc.viz.FullDomain;
import ie.ucc.cccc.viz.FullDomainMap;
import ie.ucc.cccc.viz.InvariantType;
import ie.ucc.cccc.viz.Pair;
import ie.ucc.cccc.viz.VisualContext;
import ie.ucc.cccc.viz.VisualState;
import ie.ucc.cccc.viz.VisualizerBinaryMatrix;
import java.io.PrintWriter;
import java.util.Map;

public class VisualizerSoftPrec
extends VisualizerBinaryMatrix {
    public VisualizerSoftPrec(VisualContext visualContext) {
        super(visualContext);
    }

    @Override
    public void draw(PrintWriter printWriter, VisualState visualState) {
        int n;
        FullDomain[] fullDomainArray = visualState.argumentDomainArray("features");
        FullDomain[] fullDomainArray2 = visualState.getRemovedValues("features", fullDomainArray);
        FullDomainMap fullDomainMap = visualState.argument("soft Precedences").asDomainMap();
        FullDomainMap fullDomainMap2 = visualState.getRemovedValues("soft Precedences", fullDomainMap);
        FullDomainMap fullDomainMap3 = visualState.argument("hard Precedences").asDomainMap();
        FullDomainMap fullDomainMap4 = visualState.getRemovedValues("hard Precedences", fullDomainMap3);
        FullDomainMap fullDomainMap5 = visualState.argument("components").asDomainMap();
        FullDomainMap fullDomainMap6 = visualState.getRemovedValues("components", fullDomainMap5);
        FullDomain fullDomain = visualState.argumentDomain("cost");
        FullDomain fullDomain2 = visualState.getRemovedValues("cost", fullDomain);
        int n2 = fullDomainArray.length;
        this.setWidth(n2 - 1 + this.context.getIndexStart());
        this.setHeight(n2 - 1 + this.context.getIndexStart());
        printWriter.println("<!-- SoftPrec " + String.valueOf(this.context) + " -->");
        this.standardGrid(printWriter);
        for (n = this.context.getIndexStart(); n < this.width() + this.context.getIndexStart(); ++n) {
            this.textSVG(printWriter, this.posX(n), (double)this.label2Y(), n, Colors.LABEL_TEXT_COLOR);
            this.textSVG(printWriter, (double)this.label2X(), this.posY(n), n, Colors.LABEL_TEXT_COLOR);
        }
        for (n = this.context.getIndexStart(); n < this.height() + this.context.getIndexStart(); ++n) {
            for (int i = this.context.getIndexStart(); i < this.width() + this.context.getIndexStart(); ++i) {
                Pair pair = new Pair(n, i);
                this.drawSoftPrecEntry(printWriter, n, i, (FullDomain)fullDomainMap.get(pair), (FullDomain)fullDomainMap2.get(pair), (FullDomain)fullDomainMap3.get(pair), (FullDomain)fullDomainMap4.get(pair));
            }
        }
        for (Map.Entry entry : fullDomainMap5.entrySet()) {
            this.drawComponentEntry(printWriter, (Pair)entry.getKey(), (FullDomain)entry.getValue(), (FullDomain)fullDomainMap6.get(entry.getKey()));
        }
        for (int i = this.context.getIndexStart(); i < n2 - 1 + this.context.getIndexStart(); ++i) {
            this.unitSquareSVG(printWriter, this.posX(i), this.top2Y(), this.booleanColor(fullDomainArray[i], fullDomainArray2[i]));
            this.unitSquareSVG(printWriter, this.left2X(), this.posY(i), this.booleanColor(fullDomainArray[i], fullDomainArray2[i]));
            if (!fullDomainArray[i].isFixed()) continue;
            this.textSVG(printWriter, this.posX(i), (double)this.top2Y(), fullDomainArray[i].getIntValue(), Colors.ASSIGNED_TEXT_COLOR);
            this.textSVG(printWriter, (double)this.left2X(), this.posY(i), fullDomainArray[i].getIntValue(), Colors.ASSIGNED_TEXT_COLOR);
        }
        this.lineSVG(printWriter, this.posX(0.0), this.posY(0.0), this.posX(n2 - 1), this.posY(n2 - 1), Colors.GRID_COLOR, 0.05);
        String string = "Value: " + this.domainChangeMsg(fullDomain, fullDomain2);
        this.textStartSVG(printWriter, this.posX(0.0), (double)this.top2Y() + 1.75, 0.5, string, Colors.ASSIGNED_TEXT_COLOR);
    }

    protected String domainChangeMsg(FullDomain fullDomain, FullDomain fullDomain2) {
        if (fullDomain2 == null || fullDomain2.isEmpty()) {
            return fullDomain.getMin() + " .. " + fullDomain.getMax();
        }
        Object object = fullDomain2.getMin() < fullDomain.getMin() ? "(" + fullDomain2.getMin() + ") -- " + fullDomain.getMin() : Integer.toString(fullDomain.getMin());
        Object object2 = fullDomain2.getMax() > fullDomain.getMax() ? fullDomain.getMax() + " -- (" + fullDomain2.getMax() + ")" : Integer.toString(fullDomain.getMax());
        return (String)object + " .. " + (String)object2;
    }

    protected void drawSoftPrecEntry(PrintWriter printWriter, int n, int n2, FullDomain fullDomain, FullDomain fullDomain2, FullDomain fullDomain3, FullDomain fullDomain4) {
        this.unitSquareSVG(printWriter, this.posX(n2), this.posY(n), this.softPrecFillColor(n, n2, fullDomain, fullDomain2, fullDomain3, fullDomain4));
        this.textSVG(printWriter, this.posX(n2), this.posY(n), this.softPrecText(n, n2, fullDomain, fullDomain2, fullDomain3, fullDomain4), this.softPrecTextColor(n, n2, fullDomain, fullDomain2, fullDomain3, fullDomain4));
    }

    protected Colors softPrecFillColor(int n, int n2, FullDomain fullDomain, FullDomain fullDomain2, FullDomain fullDomain3, FullDomain fullDomain4) {
        if (fullDomain3 == null) {
            return Colors.HARDPREC_UNKNOWN_COLOR;
        }
        if (fullDomain3.size() > 1) {
            return Colors.HARDPREC_UNKNOWN_COLOR;
        }
        if (fullDomain3.getIntValue() == 0) {
            if (fullDomain4 == null || fullDomain4.isEmpty()) {
                return Colors.HARDPREC_OLD_ZERO_COLOR;
            }
            return Colors.HARDPREC_ZERO_COLOR;
        }
        if (fullDomain3.getIntValue() == 1) {
            if (fullDomain4 == null || fullDomain4.isEmpty()) {
                return Colors.HARDPREC_OLD_ONE_COLOR;
            }
            return Colors.HARDPREC_ONE_COLOR;
        }
        return Colors.INTERESTING_COLOR;
    }

    protected Colors softPrecTextColor(int n, int n2, FullDomain fullDomain, FullDomain fullDomain2, FullDomain fullDomain3, FullDomain fullDomain4) {
        if (fullDomain == null) {
            return Colors.SOFTPREC_COLOR;
        }
        if (fullDomain.size() > 1) {
            return Colors.SOFTPREC_COLOR;
        }
        if (fullDomain2 == null || fullDomain2.isEmpty()) {
            return Colors.SOFTPREC_OLD_COLOR;
        }
        return Colors.SOFTPREC_COLOR;
    }

    protected String softPrecText(int n, int n2, FullDomain fullDomain, FullDomain fullDomain2, FullDomain fullDomain3, FullDomain fullDomain4) {
        if (fullDomain == null) {
            return "";
        }
        if (fullDomain.size() > 1) {
            return "01";
        }
        if (fullDomain.getIntValue() == 0) {
            return "0";
        }
        if (fullDomain.getIntValue() == 1) {
            return "1";
        }
        return "E";
    }

    protected void drawComponentEntry(PrintWriter printWriter, Pair pair, FullDomain fullDomain, FullDomain fullDomain2) {
        printWriter.println("<!-- index " + pair.getX() + " " + pair.getY() + " domain " + String.valueOf(fullDomain) + " -->");
        Colors colors = switch (fullDomain.getIntValue()) {
            case 0 -> Colors.COMPONENT_COLOR0;
            case 1 -> Colors.COMPONENT_COLOR1;
            case 2 -> Colors.COMPONENT_COLOR2;
            case 3 -> Colors.COMPONENT_COLOR3;
            case 4 -> Colors.COMPONENT_COLOR4;
            case 5 -> Colors.COMPONENT_COLOR5;
            default -> Colors.COMPONENT_COLOR;
        };
        double d = fullDomain2 == null || fullDomain2.size() == 0 ? 0.2 : 0.1;
        this.hollowRectSVG(printWriter, this.posX(pair), this.posY(pair), 1.0, 1.0, colors, d);
        this.lineSVG(printWriter, this.posX(pair), this.posY(pair) + 0.8, this.posX(pair) + 1.0, this.posY(pair) + 0.8, colors);
    }

    @Override
    public InvariantType invariant(PrintWriter printWriter, VisualState visualState) {
        FullDomainMap fullDomainMap = visualState.argument("components").asDomainMap();
        if (fullDomainMap.size() == 0) {
            return InvariantType.INTERESTING;
        }
        return InvariantType.TRUE;
    }
}

