/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.Colors;
import ie.ucc.cccc.viz.FullDomain;
import ie.ucc.cccc.viz.VisualContext;
import ie.ucc.cccc.viz.VisualState;
import ie.ucc.cccc.viz.VisualizerDrawer;
import ie.ucc.cccc.viz.VizFailed;
import ie.ucc.cccc.viz.VizFocus;
import java.io.PrintWriter;

public class VisualizerBinaryVector
extends VisualizerDrawer {
    public VisualizerBinaryVector(VisualContext visualContext) {
        super(visualContext);
    }

    @Override
    public void draw(PrintWriter printWriter, VisualState visualState) {
        FullDomain[] fullDomainArray = visualState.getEntries().asDomainArray();
        FullDomain[] fullDomainArray2 = visualState.getRemovedValues(fullDomainArray);
        int n = fullDomainArray.length;
        printWriter.println("<!-- Binary Vector " + String.valueOf(this.context) + " -->");
        this.standardGrid(printWriter);
        for (int i = 1; i < n; ++i) {
            this.unitSquareSVG(printWriter, this.posX(i), this.topY(), this.booleanColor(fullDomainArray[i], fullDomainArray2[i]));
        }
        this.drawFocus(printWriter, visualState.getFocus());
        this.drawFailed(printWriter, visualState.getFailed());
    }

    private void drawFocus(PrintWriter printWriter, VizFocus vizFocus) {
        if (this.isInFocus(vizFocus)) {
            double d = this.posX(vizFocus.getSingleIndex());
            double d2 = this.topY();
            printWriter.println("<!-- " + String.valueOf(vizFocus) + " -->");
            this.hollowRectSVG(printWriter, d, d2, 1.0, 1.0, Colors.FOCUS_COLOR);
        }
    }

    private void drawFailed(PrintWriter printWriter, VizFailed vizFailed) {
        if (this.isFailed(vizFailed)) {
            double d = this.posX(vizFailed.getSingleIndex());
            double d2 = this.topY();
            printWriter.println("<!-- Failed " + String.valueOf(vizFailed) + " -->");
            this.hollowRectSVG(printWriter, d, d2, 1.0, 1.0, Colors.FAILED_COLOR);
            this.unitSquareSVG(printWriter, d, d2, this.booleanColor(vizFailed.getValue()));
        }
    }

    @Override
    public void standardGrid(PrintWriter printWriter) {
        this.gridSVG(printWriter, this.leftX(), this.topY(), this.width(), 1);
        for (int i = 1; i <= this.width(); ++i) {
            this.textSVG(printWriter, this.posX(i), (double)this.labelY(), i, Colors.LABEL_TEXT_COLOR);
        }
        this.textSVG(printWriter, (double)this.labelX(), (double)this.topY(), "0/1", Colors.LABEL_TEXT_COLOR);
    }

    @Override
    public int top2Y() {
        return this.topY() + 2;
    }
}

