/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.GraphParserException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import java_cup.runtime.Symbol;

public class Lexer {
    private int next_char = 10;
    private int next_char2 = 10;
    private int current_line = -1;
    private int current_position = 1;
    private static final int EOF_CHAR = -1;
    private boolean haveId = false;
    private int old_char;
    private int old_position;
    boolean retreated = false;
    private int error_count = 0;
    private int warning_count = 0;
    private HashMap<String, Integer> keywords = new HashMap(32);
    private HashMap<Integer, Integer> char_symbols = new HashMap(32);
    private Reader inReader;
    private PrintWriter errWriter = null;
    private StringBuilder cmnstrbuf = new StringBuilder();

    public Lexer(Reader input, PrintWriter error) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("Reader cannot be null");
        }
        this.inReader = input;
        this.errWriter = error;
    }

    public void init() throws IOException {
        this.keywords.put("strict", new Integer(8));
        this.keywords.put("strictdigraph", new Integer(11));
        this.keywords.put("strictgraph", new Integer(10));
        this.keywords.put("digraph", new Integer(9));
        this.keywords.put("graph", new Integer(2));
        this.keywords.put("subgraph", new Integer(5));
        this.keywords.put("node", new Integer(3));
        this.keywords.put("edge", new Integer(4));
        this.keywords.put("--", new Integer(7));
        this.keywords.put("->", new Integer(6));
        this.char_symbols.put(new Integer(59), new Integer(12));
        this.char_symbols.put(new Integer(44), new Integer(13));
        this.char_symbols.put(new Integer(123), new Integer(14));
        this.char_symbols.put(new Integer(125), new Integer(15));
        this.char_symbols.put(new Integer(91), new Integer(16));
        this.char_symbols.put(new Integer(93), new Integer(17));
        this.char_symbols.put(new Integer(61), new Integer(18));
        this.char_symbols.put(new Integer(58), new Integer(19));
        this.advance();
        this.advance();
    }

    public void advance() throws IOException {
        if (this.retreated) {
            this.retreated = false;
            int tmp_char = this.old_char;
            this.old_char = this.next_char;
            this.next_char = this.next_char2;
            this.next_char2 = tmp_char;
        } else {
            this.old_char = this.next_char;
            this.next_char = this.next_char2;
            this.next_char2 = this.next_char == -1 ? -1 : this.inReader.read();
        }
        if (this.next_char == 92 && (this.next_char2 == 10 || this.next_char2 == 13)) {
            this.next_char = this.next_char2;
            this.next_char2 = this.inReader.read();
            if (this.next_char == 13 && this.next_char2 == 10) {
                this.next_char = this.next_char2;
                this.next_char2 = this.inReader.read();
            }
            this.next_char = this.next_char2;
            this.next_char2 = this.inReader.read();
        }
        if (this.next_char == 13) {
            if (this.next_char2 == 10) {
                this.next_char2 = this.inReader.read();
            }
            this.next_char = 10;
        }
        if (this.old_char == 10) {
            ++this.current_line;
            this.old_position = this.current_position;
            this.current_position = 1;
        } else {
            ++this.current_position;
        }
    }

    private void retreat() {
        if (this.retreated) {
            return;
        }
        this.retreated = true;
        if (this.old_char == 10) {
            --this.current_line;
            this.current_position = this.old_position;
        } else {
            --this.current_position;
        }
        int tmp_char = this.next_char2;
        this.next_char2 = this.next_char;
        this.next_char = this.old_char;
        this.old_char = tmp_char;
    }

    private void emit_error(String message) {
        String output = "Lexer" + this.getLocation() + ": " + message;
        if (this.errWriter != null) {
            this.errWriter.println("ERROR: " + output);
        }
        ++this.error_count;
        throw new GraphParserException(output);
    }

    public String getLocation() {
        return "[" + this.current_line + "(" + this.current_position + ")]";
    }

    private void emit_warn(String message) {
        if (this.errWriter != null) {
            this.errWriter.println("WARNING: Lexer" + this.getLocation() + ": " + message);
        }
        ++this.warning_count;
    }

    public static boolean id_char(int ch) {
        return Lexer.id_char((char)ch);
    }

    public static boolean id_char(char ch) {
        return Character.isJavaIdentifierStart(ch) && Character.getType(ch) != 26 || Character.isDigit(ch);
    }

    private int find_single_char(int ch) {
        Integer result = this.char_symbols.get(new Integer((char)ch));
        if (result == null) {
            return -1;
        }
        return result;
    }

    private void swallow_comment() throws IOException {
        if (this.next_char2 == 42) {
            this.advance();
            this.advance();
            while (true) {
                if (this.next_char == -1) {
                    this.emit_error("Specification file ends inside a comment");
                    return;
                }
                if (this.next_char == 42 && this.next_char2 == 47) {
                    this.advance();
                    this.advance();
                    return;
                }
                this.advance();
            }
        }
        if (this.next_char2 == 47) {
            this.advance();
            this.advance();
            while (this.next_char != 10 && this.next_char != 12 && this.next_char != -1) {
                this.advance();
            }
            return;
        }
        this.emit_error("Malformed comment in specification -- ignored");
        this.advance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Symbol do_quote_string() throws IOException {
        String result_str;
        this.advance();
        StringBuilder stringBuilder = this.cmnstrbuf;
        synchronized (stringBuilder) {
            this.cmnstrbuf.delete(0, this.cmnstrbuf.length());
            while (this.next_char != 34) {
                if (this.next_char == 92 && this.next_char2 == 34) {
                    this.advance();
                }
                if (this.next_char == -1) {
                    this.emit_error("Specification file ends inside a code string");
                    break;
                }
                this.cmnstrbuf.append(new Character((char)this.next_char));
                this.advance();
            }
            result_str = this.cmnstrbuf.toString();
        }
        this.advance();
        this.haveId = true;
        return new Symbol(21, result_str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Symbol do_html_string() throws IOException {
        String result_str;
        int angles = 0;
        StringBuilder stringBuilder = this.cmnstrbuf;
        synchronized (stringBuilder) {
            this.cmnstrbuf.delete(0, this.cmnstrbuf.length());
            do {
                if (this.next_char == -1) {
                    this.emit_error("Specification file ends inside an html string");
                    break;
                }
                if (this.next_char == 60) {
                    ++angles;
                } else if (this.next_char == 62) {
                    --angles;
                }
                this.cmnstrbuf.append(new Character((char)this.next_char));
                this.advance();
            } while (angles > 0);
            result_str = this.cmnstrbuf.toString();
        }
        this.advance();
        this.haveId = true;
        return new Symbol(21, result_str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Symbol do_id() throws IOException {
        String result_str;
        char buffer = (char)this.next_char;
        StringBuilder stringBuilder = this.cmnstrbuf;
        synchronized (stringBuilder) {
            this.cmnstrbuf.delete(0, this.cmnstrbuf.length());
            this.cmnstrbuf.append(buffer);
            this.advance();
            while (Lexer.id_char(this.next_char)) {
                buffer = (char)this.next_char;
                this.cmnstrbuf.append(buffer);
                this.advance();
            }
            result_str = this.cmnstrbuf.toString();
        }
        Integer keyword_num = this.keywords.get(result_str);
        if (keyword_num != null) {
            this.haveId = false;
            return new Symbol(keyword_num);
        }
        this.haveId = true;
        return new Symbol(21, result_str);
    }

    private Symbol real_next_token() throws IOException {
        while (true) {
            int sym_num;
            if (this.next_char == 32 || this.next_char == 9 || this.next_char == 10 || this.next_char == 12) {
                this.advance();
                continue;
            }
            if (this.next_char == 45) {
                if (this.next_char2 == 62) {
                    this.advance();
                    this.advance();
                    this.haveId = false;
                    return new Symbol(6);
                }
                if (this.next_char2 == 45) {
                    this.advance();
                    this.advance();
                    this.haveId = false;
                    return new Symbol(7);
                }
            }
            if ((sym_num = this.find_single_char(this.next_char)) != -1) {
                if (sym_num == 14 && !this.haveId) {
                    Symbol result = new Symbol(5);
                    this.haveId = true;
                    this.retreat();
                    return result;
                }
                this.advance();
                this.haveId = false;
                return new Symbol(sym_num);
            }
            if (this.next_char == 34) {
                return this.do_quote_string();
            }
            if (this.next_char == 60) {
                return this.do_html_string();
            }
            if (this.next_char == 47 && (this.next_char2 == 42 || this.next_char2 == 47)) {
                this.swallow_comment();
                continue;
            }
            if (Lexer.id_char(this.next_char)) {
                return this.do_id();
            }
            if (this.next_char == -1) {
                this.haveId = false;
                return new Symbol(0);
            }
            this.emit_warn("Unrecognized character '" + new Character((char)this.next_char) + "'(" + this.next_char + ") -- ignored");
            this.advance();
        }
    }

    public Symbol next_token(int debugLevel) throws IOException {
        if (debugLevel > 0) {
            Symbol result = this.real_next_token();
            if (this.errWriter != null && debugLevel >= 5) {
                this.errWriter.println("DEBUG: Lexer: next_token() => " + result.sym);
            }
            return result;
        }
        return this.real_next_token();
    }
}

