/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.GrappaSupport;
import att.grappa.GrappaSupportPrintf;
import java.awt.geom.Dimension2D;

public class GrappaSize
extends Dimension2D {
    public double width;
    public double height;

    public GrappaSize() {
    }

    public GrappaSize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public GrappaSize(String dimenString) {
        double[] coords = null;
        try {
            coords = GrappaSupport.arrayForTuple(dimenString);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("coordinate string (" + dimenString + ") has a bad number format (" + nfe.getMessage() + ")");
        }
        if (coords == null || coords.length != 1 && coords.length != 2) {
            throw new IllegalArgumentException("coordinate string (" + dimenString + ") does not contain 2 valid coordinates");
        }
        this.width = coords[0];
        this.height = coords.length > 1 ? coords[1] : this.width;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setSize(Dimension2D d) {
        this.setSize(d.getWidth(), d.getHeight());
    }

    public void setSize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public String toAttributeString() {
        return this.toFormattedString("%p");
    }

    public String toFormattedString(String format) {
        return GrappaSupportPrintf.sprintf(new Object[]{format, this});
    }

    public String toString() {
        return this.width + "," + this.height;
    }
}

