""" xrtemplate (xulrunner template) is aimed at providing an easy to setup minimal
xulrunner application, with development tools. It works by unpacking an
application template, and making it ready for immediate use. xrtemplate comes
with a default application template, but you may use your own template if it
suits you better. """


from distutils.core import setup
import os.path, py_compile
templates_dir = "templates"
dist = setup(name="xrtemplate",
        version="0.2",
        author='arno renevier',
        author_email='arno@renevier.net',
        license='MPL/GPL/LGPL',
        url='http://xrtemplate.mozdev.org/',
        description="creates a minimal xulrunner development environment",
        scripts=["xrtemplate"],
        py_modules=["extractor"],
        data_files = [ ( "templates", ["main.tar.gz"]) ],
        long_description = __doc__
        )

# hack necessary to get know where data is installed
# See http://www.gossamer-threads.com/lists/python/python/163159
if (not dist.dry_run and dist.command_obj.has_key('install_data') and dist.command_obj.has_key('install_lib')):
    name = dist.metadata.name
    dirname =  dist.data_files[0][0]
    filename = dist.data_files[0][1][0]
    data_install_dir = dist.command_obj['install_data'].install_dir 
    data_path = os.path.join(data_install_dir, dirname, filename)
    lib_install_dir = dist.command_obj['install_lib'].install_dir
    lib_file = os.path.join(lib_install_dir, name + os.extsep + 'py') 
    f = open(lib_file,'w') 
    f.write("data_path = %s\n" % repr(data_path)) 
    f.close() 
    py_compile.compile(lib_file)
