/* 
 * HaShao's buffer class. Hold a pointer too an array of primary types,
 * either _null terminated or with a given size.
 * Meanly used as type for container (map) templates.
 **/

#include <cstdlib>
#include <string>

using namespace std;


template <typename _Tp>
class hsBuffer
{
public:
    typedef _Tp         buffer_type;
    typedef size_t      size_type;

    hsBuffer():_mysize(0), _mydata(NULL), _owndata(false), _null(0){;}

    hsBuffer(const _Tp* udata, bool nullend=true):_mysize(0),_mydata(NULL),
	_owndata(false), _null(0)
    { assign(udata, nullend); }

    hsBuffer(const _Tp* udata, size_t s):_mysize(0), _mydata(NULL),
    _owndata(false), _null(0)
    { assign(udata, s, false); }

    hsBuffer(const hsBuffer<_Tp> &x):_mysize(0), _mydata(NULL), 
    _owndata(false)
    { 
	assign(x, true); 
    }

    ~hsBuffer() {
	if (_owndata and (_mydata != NULL))
	    delete [] _mydata;
    }

    inline const size_t size() const { return _mysize; }
    inline const _Tp *data() const { return _mydata; }
    void set_null(_Tp n) { _null = n; };
    _Tp get_null() const { return _null; };

    void assign(const hsBuffer<_Tp> &x, bool owndata=true)
    { 
	assign(x.data(), x.size(), owndata); 
	_null = x.get_null();
    }

    void assign(const _Tp* udata, size_t s, bool owndata=true) {
	if (_mydata != NULL) {
	    if(_owndata)
		delete [] _mydata;
	    _mydata = NULL;
	    _mysize = 0;
	    _owndata = false;
	}

	if (udata == NULL)
	    return;

	if (owndata) {
	    _mydata = new _Tp[s];
	    memcpy(reinterpret_cast<void*>(_mydata), 
		    reinterpret_cast<const void*>(udata), sizeof(_Tp)*s);
	    _owndata = true;
	} else {
	    _mydata = const_cast<_Tp*>(udata);
	    _owndata = false;
	}
	_mysize = s;
    }

    void assign(const _Tp *udata, bool nullend=true) {
	size_t s = 0;
	if (udata == NULL) {
	    if ((_mydata != NULL) and _owndata)
		delete [] _mydata;
	    _mydata = NULL;
	    _mysize = 0;
	    _owndata = false;
	    return;
	}

	while ((*(udata+s)) !=  _null) { s++; }

	if(nullend)
	    s++;
	assign(udata, s, true);
    }

    hsBuffer<_Tp>& operator= (const _Tp *y) {
	assign(y, true);
	return *this;
    }

    hsBuffer<_Tp>& operator= (const hsBuffer<_Tp> &y) {
	assign(y, true);
	return *this;
    }
    template <typename _Tp2>
	friend bool operator== (const hsBuffer<_Tp2> &x, const hsBuffer<_Tp2> &y);
    template <typename _Tp2>
	friend bool operator< (const hsBuffer<_Tp2> &x, const hsBuffer<_Tp2> &y);

private:
    _Tp _null;
    _Tp *_mydata;
    size_t _mysize;
    bool _owndata;
};

template <typename _Tp2>
bool operator== (const hsBuffer<_Tp2> &x, const hsBuffer<_Tp2> &y) {
    const _Tp2 *ydata;
    const _Tp2 *xdata;
    if (x.size() != y.size())
	return false;
    ydata = y.data();
    xdata = x.data();
    for(size_t i = 0; i < x.size(); i++) {
	if (*(xdata+i) != *(ydata+i))
	    return false;
    }
    return true;
}

template <typename _Tp2>
inline bool operator< (const hsBuffer<_Tp2> &x, const hsBuffer<_Tp2> &y) {
    const _Tp2 *xdata;
    const _Tp2 *ydata;
    if (x.size() > y.size())
	return false;
    else if (x.size() < y.size())
	return true;
    xdata = x.data();
    ydata = y.data();
    for (size_t i = 0; i < x.size(); i++) {
	if ((*(xdata+i)) != (*(ydata+i)))
	    return (*(xdata+i)) < (*(ydata+i));
    }
    return false;
}
