#include <iostream>
#include <string>
#include <map>

using namespace std;

#include "nsIGenericFactory.h"
#include "nsXPCOM.h"

#include "iTransString.h"
#include "hsBuffer.h"

// generate unique ID here with uuidgen: libuuid
#define TRANSSTRING_CID \
		           {0xed3ef8bc, 0x9a6d, 0x11d8, \
			    {0xbe, 0x17, 0x00, 0x00, 0xb4, 0x9c, 0x50, 0xa9}}

#define TransString_ContractID "@hashao/transstring"

typedef hsBuffer<PRUnichar> uBuffer;
typedef uBuffer::size_type ubsize;

/* Get string length of a PRUnichar* */
inline size_t sizeof_uchar(const PRUnichar *uc) {
    size_t s;
    for (s = 0; (*(uc+s)) != 0; s++)
	;
    return s+1;
}

class TransString : public iTransString
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_ITRANSSTRING        

  TransString();
  virtual ~TransString();

  /* additional members */
private:
  typedef map<uBuffer, uBuffer> ubMap;
  ubMap tTable;
  unsigned int leap;

};

/* Implementation file */
NS_IMPL_ISUPPORTS1(TransString, iTransString)

TransString::TransString() : leap(1)
{
  /* member initializers and constructor code */
  NS_INIT_ISUPPORTS();
}

TransString::~TransString()
{
  /* destructor code */
}

/* wstring trans (in wstring srcstr); */
NS_IMETHODIMP TransString::Trans(const PRUnichar *srcstr, PRUnichar **_retval)
{
    PRUnichar *retval;
    const PRUnichar *uvdata;
    ubsize slen;
    ubMap::iterator findresult, mapend;
    uBuffer ukey, uval;

    PRBool result;
    unsigned int fstep, len, lleap;
    wstring::size_type n;

    slen = sizeof_uchar(srcstr);

    retval = new PRUnichar[slen];
    memcpy(reinterpret_cast<void*>(retval), reinterpret_cast<const void*>(srcstr), 
	    sizeof(PRUnichar)*slen);

    *_retval = retval;

    mapend = tTable.end();
    n = 0;
    while(*retval != 0) {
	fstep = 1;
	lleap = slen - n;
	
	lleap = leap < lleap? leap : lleap;
	for (ubsize i = lleap; i > 0; i--) {
	    ukey.assign(retval, i, false);
	    findresult = tTable.find(ukey);
	    if (findresult != mapend){
		uval = (*findresult).second;
		uvdata = uval.data();
		for(int v = 0; v < uval.size(); v++)
		    *(retval+v) = *(uvdata+v);
		fstep = uval.size();
		break;
	    } 
	}
	retval += fstep;
	n += fstep;
    }
    return NS_OK;
}

    
/* boolean tableInsert ([const] in wstring key, [const] in wstring val); */
NS_IMETHODIMP TransString::TableInsert(const PRUnichar *key, const PRUnichar *val, PRBool *_retval)
{
    uBuffer mykey(key, false), myval(val, false);

    /* We are transfroming, not replacing. */
    if (mykey.size() != myval.size()) {
	*_retval = PR_FALSE;
	//return NS_ERROR_ILLEGAL_VALUE;
	return NS_OK;
    }
    
    /* if key exists, erase first, else insert will fail. */
    if (tTable.find(mykey) != tTable.end())
	tTable.erase(mykey);
    tTable[mykey] = myval;
    if (mykey.size() > leap)
	leap = mykey.size();
    *_retval = PR_TRUE;

    return NS_OK;
}

/* Entry point stuff. */
NS_GENERIC_FACTORY_CONSTRUCTOR(TransString);

static const nsModuleComponentInfo components[] = {
    {"Transform String Class",
     TRANSSTRING_CID,
     TransString_ContractID,
     TransStringConstructor
    }
};

NS_IMPL_NSGETMODULE(nsTransStringModule, components)

