;Saved 3rd Jan 2006
!define FULLNAME "Portable Firefox Live"
!define NAME "PortableFirefox"
!define APP "Firefox"
!define VER "0.5.2.0"
!define WEBSITE "portableapps.com/portable_firefox"
;=== Program Details
Name "${NAME}"
Caption "${FULLNAME} - your browser, your way... in your pocket"
VIProductVersion "${VER}"
VIAddVersionKey FileDescription "${FULLNAME} Launcher runs ${APP} from a CD-R"
VIAddVersionKey LegalCopyright "2004-2005 John T. Haller, portions 2004 by Gerard Balagu"
VIAddVersionKey Comments "Allows ${APP} to be run from a CD-R.  For additional details, visit ${WEBSITE}"
VIAddVersionKey CompanyName "by John T. Haller, portions by Gerard Balagu"
VIAddVersionKey OriginalFilename "${NAME}.exe"
VIAddVersionKey FileVersion "${VER}"
OutFile "PortableFirefoxLive.exe"
InstallDir "$TEMP\PortableFirefoxTempDir"
Icon "PortableFirefoxLive.ico"
SilentInstall silent
SetCompress off


Section Checksetup
 IfFileExists $EXEDIR\${NAME}.exe Insamedir 0
 IfFileExists $EXEDIR\${NAME}\${NAME}.exe InPortFf 0
 IfFileExists $EXEDIR\PortableApps\${NAME}\${NAME}.exe InPortApps 0
 IfFileExists $EXEDIR\Apps\${NAME}\${NAME}.exe InPortAppsPortFf NonExistent

 InPortFf:
 StrCpy $3 "$EXEDIR\${NAME}"
 Goto Copythemfiles

 Insamedir:
 StrCpy $3 "$EXEDIR"
 Goto Copythemfiles

 InPortApps:
 StrCpy $3 "$EXEDIR\PortableApps\${NAME}"
 Goto Copythemfiles

 InPortAppsPortFf:
 StrCpy $3 "$EXEDIR\Apps\${NAME}"
 Goto Copythemfiles
 NonExistent:
 MessageBox MB_OK "${NAME}.exe couldn't be found. Please put it in in a folder according to the readme.txt"
 Abort
 Copythemfiles:
;Splash Screen for Firefox Live
InitPluginsDir
			File /oname=$PLUGINSDIR\splash.jpg "${NAME}Live.jpg"

		;	StrCmp $WAITFORPROGRAM "true" ShortSplashScreen
		;	newadvsplash::show /NOUNLOAD 30000 400 0 -1 /L $PLUGINSDIR\splash.jpg
		;	GoTo SkipSplashScreen

			ShortSplashScreen:
				newadvsplash::show /NOUNLOAD 3000 200 0 -1 /L $PLUGINSDIR\splash.jpg
SkipSplashScreen:
SectionEnd

Section Copyfilesover
 CreateDirectory $INSTDIR
 CopyFiles /SILENT $3\*.* $INSTDIR
SectionEnd

Section Runprog
 newadvsplash::stop
SectionEnd

Var PROGRAMDIRECTORY
Var PROFILEDIRECTORY
Var PLUGINSDIRECTORY
Var USERPROFILEDIRECTORY
Var ADDITIONALPARAMETERS
Var ALLOWMULTIPLEINSTANCES
Var SKIPCHROMEFIX
Var SKIPCOMPREGFIX
Var EXECSTRING
Var WAITFORPROGRAM
Var PROGRAMEXECUTABLE
Var INIPATH
Var ISFILELINE
Var DISABLESPLASHSCREEN


Section "Main"
	;=== Find the INI file, if there is one
		IfFileExists "$INSTDIR\${NAME}.ini" "" CheckSubINI
			StrCpy "$INIPATH" "$INSTDIR\"
			Goto ReadINI

	CheckSubINI:
		IfFileExists "$INSTDIR\${NAME}\${NAME}.ini" "" CheckSubSubINI
			StrCpy "$INIPATH" "$INSTDIR\${NAME}\"
			Goto ReadINI

	CheckSubSubINI:
		IfFileExists "$INSTDIR\PortableApps\${NAME}\${NAME}.ini" "" CheckPortableAppsINI
			StrCpy "$INIPATH" "$INSTDIR\PortableApps\${NAME}\"
			Goto ReadINI

	CheckPortableAppsINI:
		IfFileExists "$INSTDIR\Data\${NAME}\${NAME}.ini" ""  NoINI
			StrCpy "$INIPATH" "$INSTDIR\Data\${NAME}\"
			Goto ReadINI

	ReadINI:
		;=== Read the parameters from the INI file
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "${APP}Directory"
		StrCpy "$PROGRAMDIRECTORY" "$INSTDIR\$0"
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "ProfileDirectory"
		StrCpy "$PROFILEDIRECTORY" "$INSTDIR\$0"

		;=== Check that the above required parameters are present
		IfErrors NoINI

		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "PluginsDirectory"
		StrCpy "$PLUGINSDIRECTORY" "$0"
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "AppDataDirectory"
		StrCpy "$USERPROFILEDIRECTORY" "$0"
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "AdditionalParameters"
		StrCpy "$ADDITIONALPARAMETERS" $0
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "AllowMultipleInstances"
		StrCpy "$ALLOWMULTIPLEINSTANCES" $0
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "SkipChromeFix"
		StrCpy "$SKIPCHROMEFIX" $0
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "SkipCompregFix"
		StrCpy "$SKIPCOMPREGFIX" $0
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "WaitFor${APP}"
		StrCpy "$WAITFORPROGRAM" $0
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "${APP}Executable"
		StrCpy "$PROGRAMEXECUTABLE" $0
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "DisableSplashScreen"
		StrCpy "$DISABLESPLASHSCREEN" $0

		;=== Any missing unrequired INI entries will be an empty string, ignore associated errors
		ClearErrors

		;=== Correct PROGRAMEXECUTABLE if blank
		StrCmp $PROGRAMEXECUTABLE "" "" EndINI
			StrCpy "$PROGRAMEXECUTABLE" "${DEFAULTEXE}"
			Goto EndINI

	NoINI:
		;=== No INI file, so we'll use the defaults
		StrCpy "$ADDITIONALPARAMETERS" ""
		StrCpy "$ALLOWMULTIPLEINSTANCES" "false"
		StrCpy "$SKIPCHROMEFIX" "false"
		StrCpy "$SKIPCOMPREGFIX" "false"
		StrCpy "$WAITFORPROGRAM" "false"
		StrCpy "$PROGRAMEXECUTABLE" "${DEFAULTEXE}"
		StrCpy "$DISABLESPLASHSCREEN" "false"

		IfFileExists "$INSTDIR\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" CheckPortableProgramDIR
			StrCpy "$PROGRAMDIRECTORY" "$INSTDIR\${DEFAULTAPPDIR}"
			StrCpy "$PROFILEDIRECTORY" "$INSTDIR\profile"
			StrCpy "$PLUGINSDIRECTORY" "plugins"
			StrCpy "$USERPROFILEDIRECTORY" "userprofile"
			GoTo EndINI

		CheckPortableProgramDIR:
			IfFileExists "$INSTDIR\${NAME}\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" CheckPortableAppsDIR
			StrCpy "$PROGRAMDIRECTORY" "$INSTDIR\${NAME}\${DEFAULTAPPDIR}"
			StrCpy "$PROFILEDIRECTORY" "$INSTDIR\${NAME}\profile"
			StrCpy "$PLUGINSDIRECTORY" "${NAME}\plugins"
			StrCpy "$USERPROFILEDIRECTORY" "${NAME}\userprofile"
			GoTo EndINI

		CheckPortableAppsDIR:
			IfFileExists "$INSTDIR\PortableApps\${NAME}\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" CheckPortableAppsSplitDIR
			StrCpy "$PROGRAMDIRECTORY" "$INSTDIR\PortableApps\${NAME}\${DEFAULTAPPDIR}"
			StrCpy "$PROFILEDIRECTORY" "$INSTDIR\PortableApps\${NAME}\profile"
			StrCpy "$PLUGINSDIRECTORY" "PortableApps\${NAME}\plugins"
			StrCpy "$USERPROFILEDIRECTORY" "PortableApps\${NAME}\userprofile"
			GoTo EndINI

		CheckPortableAppsSplitDIR:
			IfFileExists "$INSTDIR\Apps\${NAME}\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" NoProgramEXE
			StrCpy "$PROGRAMDIRECTORY" "$INSTDIR\Apps\${NAME}\${DEFAULTAPPDIR}"
			StrCpy "$PROFILEDIRECTORY" "$INSTDIR\Data\${NAME}\profile"
			StrCpy "$PLUGINSDIRECTORY" "Apps\${NAME}\plugins"
			IfFileExists "$INSTDIR\Data\UserProfile\*.*" "" UniqueUserProfileDIR
				;=== Shared UserProfile directory
				StrCpy "$USERPROFILEDIRECTORY" "Data\UserProfile"
				GoTo EndINI

			UniqueUserProfileDIR:
				StrCpy "$USERPROFILEDIRECTORY" "Data\${NAME}\userprofile"
			GoTo EndINI

	EndINI:
		IfFileExists "$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" FoundProgramEXE

	NoProgramEXE:
		;=== Program executable not where expected
		MessageBox MB_OK|MB_ICONEXCLAMATION `$PROGRAMEXECUTABLE was not found.  Please check your configuration`
		Abort

	FoundProgramEXE:
	;=== Check if Firefox is running
	StrCmp $ALLOWMULTIPLEINSTANCES "true" ProfileWork
	FindProcDLL::FindProc "firefox.exe"
		Pop $R0
		StrCmp $R0 "1" "" ProfileWork
		;=== Firefox is already running, check if it is using the portable profile
		IfFileExists "$PROFILEDIRECTORY\parent.lock" ProfileWork

		MessageBox MB_OK|MB_ICONINFORMATION `Another instance of Firefox is already running.  Please close other instances of Firefox before launching Portable Firefox.`
                RMDir /r $INSTDIR
                Abort

	ProfileWork:
	;=== Check for an existing profile
	IfFileExists "$PROFILEDIRECTORY\prefs.js" ProfileFound
		;=== No profile was found
		MessageBox MB_YESNO|MB_ICONQUESTION `No profile was found. Create a new profile here? $\n$PROFILEDIRECTORY\` IDYES CreateProfile
		MessageBox MB_OK|MB_ICONINFORMATION `${NAME} can not run without a profile directory.  Please check your configuration.`
                RMDir /r $INSTDIR
                Abort

	CreateProfile:
		IfFileExists "$PROFILEDIRECTORY\*.*" ProfileFound
		CreateDirectory "$PROFILEDIRECTORY"

	ProfileFound:
		StrCmp $DISABLESPLASHSCREEN "true" SkipSplashScreen
			;=== Show the splash screen before processing the files
			InitPluginsDir
			File /oname=$PLUGINSDIR\splash.jpg "${NAME}.jpg"

			StrCmp $WAITFORPROGRAM "true" ShortSplashScreen
			newadvsplash::show /NOUNLOAD 30000 400 0 -1 /L $PLUGINSDIR\splash.jpg
			GoTo SkipSplashScreen

			ShortSplashScreen:
				newadvsplash::show /NOUNLOAD 3000 200 0 -1 /L $PLUGINSDIR\splash.jpg

	SkipSplashScreen:
		IfFileExists "$PROFILEDIRECTORY\chrome\chrome.rdf" "" FixCalendarManager

		;=== Adjust the chrome.rdf
		StrCmp $SKIPCHROMEFIX "true" RunProgram
		FileOpen $0 "$PROFILEDIRECTORY\chrome\chrome.rdf" r
		FileOpen $R0 "$PROFILEDIRECTORY\chrome\chrome.rdf.new" w
		ClearErrors ; if there's an error, we're done with the file

		NextLine:
			FileWrite $R0 $4
			FileRead $0 $4
			IfErrors NoMoreLines ;== we've reached the end of the file
			StrCpy $5 $4 35
			StrCmp $5 `                   c:baseURL="jar:f` FoundJarLine
			StrCmp $5 `                   c:baseURL="file:` FoundFileLine NextLine

		FoundJarLine:
			StrCpy $R4 40
			StrCpy $ISFILELINE "0"
			GoTo NotYet

		FoundFileLine:
			StrCpy $R4 40
			StrCpy $ISFILELINE "1"

		NotYet:
			IntOp $R4 $R4 + 1
			StrCpy $7 $4 10 $R4 ;=== looking for the point to strip the extension path
			StrCmp $7 "extensions" PathFound NotYet

		PathFound:
			StrCpy $5 $4 "" $R4
			StrCmp $ISFILELINE "0" MakeJarLine MakeFileLine

		MakeJarLine:
			StrCpy $4 `                   c:baseURL="jar:file:///$PROFILEDIRECTORY/$5`
			GoTo NextLine

		MakeFileLine:
			StrCpy $4 `                   c:baseURL="file:///$PROFILEDIRECTORY/$5`
			GoTo NextLine

		NoMoreLines:
			FileClose $0
			FileClose $R0

			;=== Backup the chrome.rdf
			CopyFiles "$PROFILEDIRECTORY\chrome\chrome.rdf" "$PROFILEDIRECTORY\chrome\chrome.rdf.old"
			CopyFiles "$PROFILEDIRECTORY\chrome\chrome.rdf.new" "$PROFILEDIRECTORY\chrome\chrome.rdf"

	FixCalendarManager:
		IfFileExists "$PROFILEDIRECTORY\Calendar\CalendarManager.rdf" "" FixPrefsJs

		FileOpen $0 "$PROFILEDIRECTORY\Calendar\CalendarManager.rdf" r
		FileOpen $R0 "$PROFILEDIRECTORY\Calendar\CalendarManager.rdf.new" w
		ClearErrors ; if there's an error, we're done with the file

		CMNextLine:
			FileWrite $R0 $4
			FileRead $0 $4
			IfErrors CMNoMoreLines ;== we've reached the end of the file
			StrCpy $5 $4 28
			StrCmp $5 `                   NC:path="` "" CMNextLine
			StrCpy $R4 28

		CMNotYet:
			IntOp $R4 $R4 + 1
			StrCpy $7 $4 9 $R4 ; looking for the point to strip the calendar path
			StrCmp $7 "Calendar\" "" CMNotYet
			StrCpy $5 $4 "" $R4
			StrCpy $4 `                   NC:path="$PROFILEDIRECTORY\$5` ;=== the adjusted extension path
			GoTo CMNextLine

		CMNoMoreLines:
			FileClose $0
			FileClose $R0

			;=== Backup the Calendar\CalendarManager.rdf just in case
			CopyFiles "$PROFILEDIRECTORY\Calendar\CalendarManager.rdf" "$PROFILEDIRECTORY\Calendar\CalendarManager.rdf.old"
			CopyFiles "$PROFILEDIRECTORY\Calendar\CalendarManager.rdf.new" "$PROFILEDIRECTORY\Calendar\CalendarManager.rdf"

	FixPrefsJs:
		IfFileExists "$PROFILEDIRECTORY\prefs.js" "" RunProgram
		;=== Be sure the xul cache is enabled and default browser check is disabled
		FileOpen $0 "$PROFILEDIRECTORY\prefs.js" a
		FileSeek $0 0 END
		FileWriteByte $0 "13"
		FileWriteByte $0 "10"
		FileWrite $0 `user_pref("nglayout.debug.disable_xul_cache", false);`
		FileWriteByte $0 "13"
		FileWriteByte $0 "10"
		FileWrite $0 `user_pref("browser.shell.checkDefaultBrowser", false);`
		FileWriteByte $0 "13"
		FileWriteByte $0 "10"
		FileClose $0

	RunProgram:
		StrCmp $SKIPCOMPREGFIX "true" GetPassedParameters

		;=== Delete component registry to ensure compatibility with all extensions
		Delete $PROFILEDIRECTORY\compreg.dat

	GetPassedParameters:
		;=== Get any passed parameters
		Call GetParameters
		Pop $0
		StrCmp "'$0'" "''" "" LaunchProgramParameters

		;=== No parameters
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" -profile "$PROFILEDIRECTORY"`
		Goto CheckMultipleInstances

	LaunchProgramParameters:
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" -profile "$PROFILEDIRECTORY" $0`

	CheckMultipleInstances:
		StrCmp $ALLOWMULTIPLEINSTANCES "true" "" AdditionalParameters
		System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("MOZ_NO_REMOTE", "1").r0'

	AdditionalParameters:
		StrCmp $ADDITIONALPARAMETERS "" PluginsEnvironment

		;=== Additional Parameters
		StrCpy $EXECSTRING `$EXECSTRING $ADDITIONALPARAMETERS`

	PluginsEnvironment:
		;=== Set the plugins directory if we have a path
		StrCmp $PLUGINSDIRECTORY "" UserProfileEnvironment
		IfFileExists "$INSTDIR\$PLUGINSDIRECTORY\*.*" "" UserProfileEnvironment
		System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("MOZ_PLUGIN_PATH", "$INSTDIR\$PLUGINSDIRECTORY").r0'

	UserProfileEnvironment:
		;=== Set the %USERPROFILE% directory if we have a path
		StrCmp $USERPROFILEDIRECTORY "" LaunchNow
		IfFileExists "$INSTDIR\$USERPROFILEDIRECTORY\*.*" "" LaunchNow
		System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("USERPROFILE", "$INSTDIR\$USERPROFILEDIRECTORY").r0'

	LaunchNow:
		StrCmp $WAITFORPROGRAM "true" LaunchAndWait LaunchAndClose

	LaunchAndWait:
		ExecWait $EXECSTRING
		GoTo TheEnd

	LaunchAndClose:
		Exec $EXECSTRING
		Sleep 3000 ;=== allow the splash screen to show for at least 2 seconds after starting Firefox
		StrCmp $DISABLESPLASHSCREEN "true" TheEnd
			newadvsplash::stop

	TheEnd:
RMDir /r $INSTDIR
SectionEnd

Function "GetParameters"
  Push $R0
  Push $R1
  Push $R2
  StrCpy $R0 $CMDLINE 1
  StrCpy $R1 '"'
  StrCpy $R2 1
  StrCmp $R0 '"' loop
    StrCpy $R1 ' ' ; we're scanning for a space instead of a quote
  loop:
    StrCpy $R0 $CMDLINE 1 $R2
    StrCmp $R0 $R1 loop2
    StrCmp $R0 "\" "" "nofile"
      IntOp $2 $R2 + 1
    nofile:
    ;MessageBox MB_OK "r0: $R0"
    StrCmp $R0 "" loop2
    IntOp $R2 $R2 + 1
    Goto loop
  loop2:
    IntOp $R0 $R2 - $2
    IntOp $R0 $R0 - 4
    ;MessageBox MB_OK "$R2 - $2 = $R0"
    StrCpy $R7 $CMDLINE $R0 $2 ; we save the filename
    ;MessageBox MB_OK "$2"
  loop2b:
    IntOp $R2 $R2 + 1
    StrCpy $R0 $CMDLINE 1 $R2
    ;MessageBox MB_OK "rr0: $R0"
    StrCmp $R0 " " loop2b
  StrCpy $R0 $CMDLINE "" $R2
  Pop $R2
  Pop $R1
  Exch $R0
FunctionEnd


