
const MOZILLA_CONTENT_PACK = "chrome://help/locale/nvu.rdf";

var helpFileURI = MOZILLA_CONTENT_PACK;

function openHelp(topic, contentPack)
{
  helpFileURI = contentPack || helpFileURI;

  var topWindow = locateHelpWindow(helpFileURI);

  if ( topWindow ) {
    topWindow.focus();
    topWindow.displayTopic(topic);
  } else {
    const params = Components.classes["@mozilla.org/embedcomp/dialogparam;1"]
                             .createInstance(Components.interfaces.nsIDialogParamBlock);
    params.SetNumberStrings(2);
    params.SetString(0, helpFileURI);
    params.SetString(1, topic);
    const ww = Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
                         .getService(Components.interfaces.nsIWindowWatcher);
    ww.openWindow(null, "chrome://help/content/help.xul", "_blank", "chrome,all,dialog=no", params);
  }
}

function setHelpFileURI(rdfURI)
{
  helpFileURI = rdfURI;
}

function locateHelpWindow(contentPack) {
    const windowManagerInterface = Components
        .classes['@mozilla.org/appshell/window-mediator;1'].getService()
        .QueryInterface(Components.interfaces.nsIWindowMediator);
    const iterator = windowManagerInterface.getEnumerator("mozilla:help");
    var topWindow = null;
    var aWindow;

    while (iterator.hasMoreElements()) {
        aWindow = iterator.getNext();
        if (aWindow.getHelpFileURI() == contentPack) {
            topWindow = aWindow;
        }
    }
    return topWindow;
}
