/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/license.html
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Playsophy code (www.playsophy.com).
 *
 * The Initial Developer of the Original Code is Playsophy
 * Portions created by the Initial Developer are Copyright (C) 2002-2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	Conor Dowling <ronoc@playsophy.com>
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */

/*
 * mozileLoader V0.52
 *
 * Loads mozile for a page if in a Geiko browser. This is the only javascript
 * file that a user needs to explicitly include in a page. This shields Mozile
 * from IE. 
 *
 * Methods: http://devedge.netscape.com/viewsource/2002/browser-detection/
 *          http://devedge.netscape.com/library/manuals/2001/xpinstall/1.0/Chap4.html#1005439
 *
 * POST05:
 * - set default directory for config file location in extension [TBD: James]
 * - support loading config file based on a user's explicit in-document "link"
 * - distinguish old Geiko browsers (once tested to see which have 
 * problems)
 * - if IE:
 *   - put up msg to upgrade to Geiko based browser
 *   - load IE toolbar
 */
mozile_js_files = new Array();
mozile_js_files.push("eDOM.js");
mozile_js_files.push("eDOMXHTML.js");
mozile_js_files.push("domlevel3.js");
mozile_js_files.push("mozCE.js");
mozile_js_files.push("mozWrappers.js");
mozile_js_files.push("mozIECE.js");
mozile_js_files.push("mozDataTransport.js");
mozile_js_files.push("jsdav.js");
mozile_js_files.push("mozilekb.js");
mozile_js_files.push("mozileSave.js");

var MOZILE_ROOT_DIR = "chrome://mozile/content/"; // default location of mozile is in an extension
var MOZILE_CONFIG_DOC_DIR; // no default set: TBD - set to default location for extension config file [TBD: James]
var MOZILE_CONFIG_DOC; // starts at null - must be loaded

// Detect Gecko but exclude Safari (for now); for now, only support XHTML
if((navigator.product == 'Gecko') && (navigator.userAgent.indexOf("Safari") == -1))
{
	// navigator.productSub > '20020801' (test to see what the date should be)

	// POST05: if document.documentElement != HTML then ... or no "head" ...
	var head = document.getElementsByTagName("head")[0];

	if(head)
	{
		// if there is no Mozile installed already then use a remote Mozile hosted along with this Loader file
		if(!InstallTrigger.getVersion("mozile"))
		{
			var loaderInstruction;

			// get the location of this script and reuse it for the others
			for(var i=0; i<head.childNodes.length; i++)
			{
				var mozileLoaderRE = /(.*)mozileLoader.js$/;
				if(head.childNodes[i].nodeName == "SCRIPT")
				{
					var src = head.childNodes[i].src;
					var result = mozileLoaderRE.exec(src);
					if(result)
					{
						MOZILE_ROOT_DIR = result[1];
						MOZILE_CONFIG_DOC_DIR = MOZILE_ROOT_DIR;
						break;
					}
				}
			}

			// remote has an in-page toolbar: the chrome version has the toolbar in the browser itself
			mozile_js_files.push("mozilehtmltb.js");
		}
	
		for (var i=0; i < mozile_js_files.length; i++) 
		{
			var scr = document.createElementNS("http://www.w3.org/1999/xhtml","script");
			var src = MOZILE_ROOT_DIR + mozile_js_files[i];
			scr.setAttribute("src", src);
			scr.setAttribute("language","JavaScript");
			head.appendChild(scr);
			head.removeChild(scr); // add and then remove Mozile file. It is loaded but won't show in view-source!
		}
		
		MOZILE_CONFIG_DOC = document.implementation.createDocument("", "mozileConfig", null);
		MOZILE_CONFIG_DOC.async = true;
		MOZILE_CONFIG_DOC.addEventListener("load", __MOZILE_CONFIG_Loaded, false);
		try {
			if(!MOZILE_CONFIG_DOC.load(MOZILE_CONFIG_DOC_DIR + "mozileConfig.xml"))
				MOZILE_CONFIG = null;
		}
		catch(e)
		{
			MOZILE_CONFIG_DOC = null;
		}
	}
	else
		alert("*** ALERT: MozileLoader only works in XHTML - load Mozile JS explicitly in XML files");
}

function __MOZILE_CONFIG_Loaded(e)
{
	// catch parsing errors
	if (!MOZILE_CONFIG_DOC.documentElement || MOZILE_CONFIG_DOC.documentElement.tagName == "parsererror")
		MOZILE_CONFIG = null;
}