/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom;

import org.mozilla.dom.AttrImpl;
import org.mozilla.dom.CDATASectionImpl;
import org.mozilla.dom.CommentImpl;
import org.mozilla.dom.DocumentFragmentImpl;
import org.mozilla.dom.DocumentImpl;
import org.mozilla.dom.DocumentTypeImpl;
import org.mozilla.dom.ElementImpl;
import org.mozilla.dom.EntityImpl;
import org.mozilla.dom.EntityReferenceImpl;
import org.mozilla.dom.NodeImpl;
import org.mozilla.dom.NotationImpl;
import org.mozilla.dom.ProcessingInstructionImpl;
import org.mozilla.dom.TextImpl;
import org.mozilla.xpcom.nsIDOMAttr;
import org.mozilla.xpcom.nsIDOMCDATASection;
import org.mozilla.xpcom.nsIDOMComment;
import org.mozilla.xpcom.nsIDOMDocument;
import org.mozilla.xpcom.nsIDOMDocumentFragment;
import org.mozilla.xpcom.nsIDOMDocumentType;
import org.mozilla.xpcom.nsIDOMElement;
import org.mozilla.xpcom.nsIDOMEntity;
import org.mozilla.xpcom.nsIDOMEntityReference;
import org.mozilla.xpcom.nsIDOMEventTarget;
import org.mozilla.xpcom.nsIDOMNode;
import org.mozilla.xpcom.nsIDOMNotation;
import org.mozilla.xpcom.nsIDOMProcessingInstruction;
import org.mozilla.xpcom.nsIDOMText;
import org.w3c.dom.Node;

public class NodeFactory {
    private NodeFactory() {
    }

    public static Node getNodeInstance(nsIDOMEventTarget eventTarget) {
        if (eventTarget == null) {
            return null;
        }
        nsIDOMNode node = (nsIDOMNode)eventTarget.queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}");
        return NodeFactory.getNodeInstance(node);
    }

    public static Node getNodeInstance(nsIDOMNode node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 1: {
                return ElementImpl.getDOMInstance((nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}"));
            }
            case 2: {
                return AttrImpl.getDOMInstance((nsIDOMAttr)node.queryInterface("{a6cf9070-15b3-11d2-932e-00805f8add32}"));
            }
            case 3: {
                return TextImpl.getDOMInstance((nsIDOMText)node.queryInterface("{a6cf9082-15b3-11d2-932e-00805f8add32}"));
            }
            case 4: {
                return CDATASectionImpl.getDOMInstance((nsIDOMCDATASection)node.queryInterface("{a6cf9071-15b3-11d2-932e-00805f8add32}"));
            }
            case 5: {
                return EntityReferenceImpl.getDOMInstance((nsIDOMEntityReference)node.queryInterface("{a6cf907a-15b3-11d2-932e-00805f8add32}"));
            }
            case 6: {
                return EntityImpl.getDOMInstance((nsIDOMEntity)node.queryInterface("{a6cf9079-15b3-11d2-932e-00805f8add32}"));
            }
            case 7: {
                return ProcessingInstructionImpl.getDOMInstance((nsIDOMProcessingInstruction)node.queryInterface("{a6cf907f-15b3-11d2-932e-00805f8add32}"));
            }
            case 8: {
                return CommentImpl.getDOMInstance((nsIDOMComment)node.queryInterface("{a6cf9073-15b3-11d2-932e-00805f8add32}"));
            }
            case 9: {
                return DocumentImpl.getDOMInstance((nsIDOMDocument)node.queryInterface("{a6cf9075-15b3-11d2-932e-00805f8add32}"));
            }
            case 10: {
                return DocumentTypeImpl.getDOMInstance((nsIDOMDocumentType)node.queryInterface("{a6cf9077-15b3-11d2-932e-00805f8add32}"));
            }
            case 11: {
                return DocumentFragmentImpl.getDOMInstance((nsIDOMDocumentFragment)node.queryInterface("{a6cf9076-15b3-11d2-932e-00805f8add32}"));
            }
            case 12: {
                return NotationImpl.getDOMInstance((nsIDOMNotation)node.queryInterface("{a6cf907e-15b3-11d2-932e-00805f8add32}"));
            }
        }
        return NodeImpl.getDOMInstance(node);
    }

    public static nsIDOMNode getnsIDOMNode(Node node) {
        if (node instanceof NodeImpl) {
            NodeImpl ni = (NodeImpl)node;
            return ni.getInstance();
        }
        return null;
    }
}

