/*
 * Decompiled with CFR 0.152.
 */
package org.mozdev.mbs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import org.mozdev.mbs.Bookmark;
import org.mozdev.mbs.Folder;
import org.mozdev.mbs.MBSException;

public class MBS {
    public static final String VERSION = "1.3.2";
    public static final String ABOUT = "Mozilla Bookmark Sorter 1.3.2\nCopyright 2003-2005 Corey Taylor\nThis is free (GNU GPL) software\nhttp://www.versaqual.com/mbs/";
    private static final String BACKUP_FILE_SUFFIX = ".bak";
    private static final String BOOKMARK = "<DT><A HREF=";
    private static final String BOOKMARK_FOLDER = "<DT><H3";
    public static final String BOOKMARK_FOLDER_END = "</DL><p>";
    public static final String BOOKMARK_FOLDER_START = "<DL><p>";
    public static final String DESCRIPTION = "<DD>";
    private static final String DOCTYPE = "<!DOCTYPE NETSCAPE-Bookmark-file-1>";
    public static final int ERR_FILE_IO = 3;
    public static final int ERR_FILE_NOT_FOUND = 1;
    public static final int ERR_FILE_NOT_VALID = 2;
    public static final int ERR_STDIN_IO = 4;
    public static final String MES_FILE_NOT_VALID = "Invalid bookmark file (not Netscape/Mozilla compatible)";
    public static final String QUOTE_GREATER_THAN = "\">";
    private static final String SEPARATOR = "<HR>";
    public static final String SLASH_A = "</A>";
    public static final String SLASH_H3 = "</H3>";
    private static final String DEFAULT_BOOKMARK_FILE = "bookmarks.html";
    private ArrayList bookmarkFile = new ArrayList();
    private ArrayList bookmarks = new ArrayList();
    private ArrayList folders = new ArrayList();
    private boolean quiet = true;

    public static int getBookmarkLevel(String string) {
        return string.indexOf(BOOKMARK) / 4 - 1;
    }

    public static int getFolderLevel(String string) {
        return string.indexOf(BOOKMARK_FOLDER) / 4 - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length == 0) {
            string = "";
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    arrayList.add(string2);
                }
                try {
                    new MBS(arrayList);
                }
                catch (MBSException mBSException) {
                    System.err.println(mBSException.getMessage());
                    System.exit(mBSException.getCode());
                }
                finally {
                    System.exit(0);
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                System.exit(4);
            }
        } else {
            string = stringArray[0];
        }
        File file = new File(string);
        try {
            new MBS(file);
        }
        catch (MBSException mBSException) {
            System.err.println(mBSException.getMessage());
            System.exit(mBSException.getCode());
        }
    }

    public MBS(ArrayList arrayList) throws MBSException {
        this.bookmarkFile = arrayList;
        if (!this.isValidBookmarkFile()) {
            throw new MBSException(MES_FILE_NOT_VALID, 2);
        }
        this.setBookmarks();
        this.setFolders(0);
        this.sortFolders();
        this.setSortedFolders();
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.println((String)arrayList.get(i));
        }
    }

    public MBS(File file) throws MBSException {
        FileReader fileReader;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MBSException(fileNotFoundException.getMessage(), 1);
        }
        LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
        try {
            String string;
            while ((string = lineNumberReader.readLine()) != null) {
                this.bookmarkFile.add(string);
            }
        }
        catch (IOException iOException) {
            throw new MBSException(iOException.getMessage(), 3);
        }
        if (!this.isValidBookmarkFile()) {
            throw new MBSException(MES_FILE_NOT_VALID, 2);
        }
        try {
            this.writeBackupFile(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            throw new MBSException(iOException.getMessage(), 3);
        }
        this.setBookmarks();
        this.setFolders(0);
        this.sortFolders();
        this.setSortedFolders();
        try {
            this.writeSortedFile(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            throw new MBSException(iOException.getMessage(), 3);
        }
    }

    private Folder findParentFolder(String string) {
        Folder folder = null;
        for (int i = 0; i < this.folders.size(); ++i) {
            folder = (Folder)this.folders.get(i);
            if (folder.line().equals(string)) {
                return folder;
            }
            if ((folder = folder.find(string)) == null) continue;
            return folder;
        }
        return folder;
    }

    private int getFolderEndLevel(String string) {
        return string.indexOf(BOOKMARK_FOLDER_END) / 4 - 1;
    }

    private int getFolderStartLevel(String string) {
        return string.indexOf(BOOKMARK_FOLDER_START) / 4 - 1;
    }

    private boolean isBookmark(String string) {
        return string.indexOf(BOOKMARK) != -1;
    }

    private boolean isDescription(String string) {
        return string.indexOf(DESCRIPTION) != -1;
    }

    private boolean isFolder(String string) {
        return string.indexOf(BOOKMARK_FOLDER) != -1;
    }

    private boolean isFolderEnd(String string) {
        return string.indexOf(BOOKMARK_FOLDER_END) != -1;
    }

    private boolean isFolderStart(String string) {
        return string.indexOf(BOOKMARK_FOLDER_START) != -1;
    }

    private boolean isSeparator(String string) {
        return string.indexOf(SEPARATOR) != -1;
    }

    private boolean isValidBookmarkFile() {
        return ((String)this.bookmarkFile.get(0)).indexOf(DOCTYPE) != -1;
    }

    private void setBookmarks() {
        String string = "";
        for (int i = 0; i < this.bookmarkFile.size(); ++i) {
            Bookmark bookmark;
            String string2 = (String)this.bookmarkFile.get(i);
            if (this.isSeparator(string2)) {
                string = string2;
            }
            if (this.isBookmark(string2) && MBS.getBookmarkLevel(string2) == 0) {
                bookmark = new Bookmark(string2);
                this.bookmarks.add(bookmark);
                if (this.bookmarkFile.get(i - 1).equals(string)) {
                    bookmark.setPreSeparator(string);
                }
                if (i + 1 < this.bookmarkFile.size() && this.isDescription(string2 = (String)this.bookmarkFile.get(i + 1))) {
                    bookmark.setDescription(string2);
                }
            }
            if (!this.isFolderEnd(string2) || this.getFolderEndLevel(string2) != -1 || !this.bookmarkFile.get(i - 1).equals(string) || this.bookmarks.size() == 0) continue;
            bookmark = (Bookmark)this.bookmarks.get(this.bookmarks.size() - 1);
            bookmark.setPostSeparator(string);
        }
    }

    private int setFolders(int n) {
        String string = "";
        String string2 = "";
        Bookmark bookmark = null;
        int n2 = 0;
        for (int i = 0; i < this.bookmarkFile.size(); ++i) {
            Folder folder;
            Folder folder2;
            String string3 = (String)this.bookmarkFile.get(i);
            if (this.isSeparator(string3)) {
                string2 = string3;
            }
            if (!this.isFolder(string3)) continue;
            if (MBS.getFolderLevel(string3) == n - 1) {
                string = string3;
            }
            if (MBS.getFolderLevel(string3) != n) continue;
            if (n == 0) {
                folder2 = null;
                folder = new Folder(string3, folder2);
            } else {
                folder2 = this.findParentFolder(string);
                folder = new Folder(string3, folder2);
            }
            boolean bl = false;
            if (this.bookmarkFile.get(i - 1).equals(string2)) {
                folder.setSeparator(string2);
            }
            if (this.isDescription(string3 = (String)this.bookmarkFile.get(++i))) {
                folder.setDescription(string3);
                string3 = (String)this.bookmarkFile.get(++i);
            }
            while (!bl) {
                if (this.isSeparator(string3 = (String)this.bookmarkFile.get(++i))) {
                    string2 = string3;
                }
                if (this.isBookmark(string3) && (bookmark = new Bookmark(string3)).level() == folder.level() + 1) {
                    folder.addBookmark(bookmark);
                    if (this.bookmarkFile.get(i - 1).equals(string2)) {
                        bookmark.setPreSeparator(string2);
                    }
                }
                if (this.isDescription(string3) && (bookmark = folder.getLastBookmark()) != null) {
                    bookmark.setDescription(string3);
                }
                if (!this.isFolderEnd(string3) || this.getFolderEndLevel(string3) != n) continue;
                bl = true;
                if (!this.bookmarkFile.get(i - 1).equals(string2) || (bookmark = folder.getLastBookmark()) == null) continue;
                bookmark.setPostSeparator(string2);
            }
            if (n == 0) {
                folder.sortBookmarks();
                this.folders.add(folder);
                ++n2;
                continue;
            }
            folder.sortBookmarks();
            folder2.addSubFolder(folder);
            ++n2;
        }
        if (n2 == 0) {
            return n2;
        }
        return this.setFolders(n + 1);
    }

    private void setSortedFolders() {
        String string;
        int n;
        int n2 = 0;
        for (n = 0; n < this.bookmarkFile.size(); ++n) {
            string = (String)this.bookmarkFile.get(n);
            if (!this.isFolderStart(string) || this.getFolderStartLevel(string) != -1) continue;
            n2 = n + 1;
            break;
        }
        for (n = 0; n < this.folders.size(); ++n) {
            ArrayList arrayList = new ArrayList();
            ((Folder)this.folders.get(n)).outputFolder(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                string = (String)arrayList.get(i);
                this.bookmarkFile.set(n2, string);
                ++n2;
            }
        }
        Collections.sort(this.bookmarks);
        for (n = 0; n < this.bookmarks.size(); ++n) {
            Bookmark bookmark = (Bookmark)this.bookmarks.get(n);
            if (bookmark.preSeparator() != null) {
                this.bookmarkFile.set(n2, bookmark.preSeparator());
                ++n2;
            }
            this.bookmarkFile.set(n2, bookmark.line());
            ++n2;
            if (bookmark.description() != null) {
                this.bookmarkFile.set(n2, bookmark.description());
                ++n2;
            }
            if (bookmark.postSeparator() == null) continue;
            this.bookmarkFile.set(n2, bookmark.postSeparator());
            ++n2;
        }
    }

    private void sortFolders() {
        Collections.sort(this.folders);
        for (int i = 0; i < this.folders.size(); ++i) {
            ((Folder)this.folders.get(i)).sortSubFolders();
        }
    }

    private void writeBackupFile(String string) throws IOException {
        if (new File(string + BACKUP_FILE_SUFFIX).exists()) {
            if (!this.quiet) {
                System.out.println(string + BACKUP_FILE_SUFFIX + " already exists, not overwriting");
            }
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(new File(string + BACKUP_FILE_SUFFIX));
            for (int i = 0; i < this.bookmarkFile.size(); ++i) {
                fileWriter.write(this.bookmarkFile.get(i) + "\n");
            }
            fileWriter.flush();
            fileWriter.close();
            if (!this.quiet) {
                System.out.println("Backed up " + string + " to " + string + BACKUP_FILE_SUFFIX);
            }
        }
        catch (IOException iOException) {
            throw new IOException("Could not write " + string + BACKUP_FILE_SUFFIX + ". Try again.");
        }
    }

    private void writeSortedFile(String string) throws IOException {
        try {
            FileWriter fileWriter = new FileWriter(string);
            for (int i = 0; i < this.bookmarkFile.size(); ++i) {
                fileWriter.write(this.bookmarkFile.get(i) + "\n");
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new IOException("Could not write sorted bookmark file. Try again.");
        }
    }
}

