/*
 * Decompiled with CFR 0.152.
 */
package org.l10nZilla.writer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.l10nZilla.Phrase;
import org.l10nZilla.TranslationFile;
import org.l10nZilla.l10nZillaConfigurationProperties;
import org.l10nZilla.writer.translationsWriter;

public class mozDBWriter
extends translationsWriter {
    private String destinationURL;
    private String languageCode;
    private Connection dbConn;
    private Statement stmt;
    private String presentInstall;
    private String presentFileName;
    private String presentFilePath;
    private int presentInstallId;
    private int presentFileId;
    private PreparedStatement prepSourceTextExport;
    private PreparedStatement prepNewSourceTextSearch;
    private PreparedStatement prepTranslatedTextExport;
    private PreparedStatement prepTranslatedTextSearch;
    private int numberOfNewFiles = 0;
    private int numberOfTextsInserted = 0;
    private int numberOfTextsUpdated = 0;
    private int numberOfTranslatedTextsInserted = 0;
    private int translatorId = 0;

    public mozDBWriter(String install, String destDBURL) {
        super(install, destDBURL);
        String strSQL = "";
        this.presentInstall = install;
        this.presentFileName = "";
        this.presentFilePath = "";
        this.destinationURL = destDBURL;
        try {
            Class.forName("org.gjt.mm.mysql.Driver").newInstance();
            this.dbConn = DriverManager.getConnection(this.destinationURL);
            this.stmt = this.dbConn.createStatement();
            this.stmt.setEscapeProcessing(true);
            this.translatorId = this.getTranslatorId();
            this.exportInstall();
            strSQL = "select SourceText_ID ";
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" from SourceTexts ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" where SourceString=?");
            this.prepNewSourceTextSearch = this.dbConn.prepareStatement(strSQL);
            strSQL = "replace into SourceTexts (SourceText_ID,SourceString,SourceComment) ";
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" values (?,?,?)");
            this.prepSourceTextExport = this.dbConn.prepareStatement(strSQL);
            strSQL = "replace into TranslatedTexts (TranslatedText_ID, Lang_ID, TranslatedString, TranslatedComment, Status_ID, Quality_ID)";
            strSQL = String.valueOf(String.valueOf(strSQL)).concat(" values (?,?,?,?,?,?)");
            this.prepTranslatedTextExport = this.dbConn.prepareStatement(strSQL);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }

    public String getTargetLanguageCode() {
        return this.languageCode;
    }

    public void setTargetLanguageCode(String targetLanguage) {
        this.languageCode = targetLanguage;
    }

    private void exportInstall() throws SQLException {
        String strSQL = String.valueOf(String.valueOf(new StringBuffer("select Install_ID from Installs where Install_Name='").append(this.presentInstall).append("'")));
        ResultSet rs = this.stmt.executeQuery(strSQL);
        if (rs.next()) {
            this.presentInstallId = rs.getInt("Install_ID");
        } else {
            strSQL = "select max(Install_ID) + 1 as maxInstallId from Installs";
            ResultSet rs2 = this.stmt.executeQuery(strSQL);
            if (rs2.next()) {
                int newInstallId = rs2.getInt("maxInstallId");
                if (newInstallId == 0) {
                    ++newInstallId;
                }
                strSQL = "insert into Installs (Install_ID, Install_Name) values";
                strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append("(").append(newInstallId).append(",'").append(this.presentInstall).append("')")));
                this.stmt.executeUpdate(strSQL);
                this.presentInstallId = newInstallId;
            }
        }
    }

    public void exportFile(TranslationFile currentFile) {
        String strSQL = "";
        boolean intInstallId = false;
        try {
            this.commitFileInfoToDB(currentFile);
            this.presentFileName = currentFile.getFileName();
            this.presentFilePath = currentFile.getFilePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void commitFileInfoToDB(TranslationFile currentFile) throws SQLException {
        String strSQL = "";
        int fileId = 0;
        if (currentFile.getFilePath().length() > 14) {
            fileId = this.getAnyExistingFileId(currentFile);
            if (fileId == 0) {
                fileId = this.getNewId("File_ID", "Files");
                ++this.numberOfNewFiles;
                strSQL = "replace into Files (File_ID, File_Name, File_Location) ";
                strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" values (").append(fileId).append(",'").append(currentFile.getFileName()).append("'")));
                strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" ,'").append(currentFile.getFilePath()).append("')")));
                this.stmt.executeUpdate(strSQL);
            }
            this.presentFileId = fileId;
        }
    }

    private int getNewId(String attribute, String table) throws SQLException {
        int newId = 0;
        String strSQL = String.valueOf(String.valueOf(new StringBuffer("select max(").append(attribute).append(") + 1 as maxId from ").append(table)));
        ResultSet rs = this.stmt.executeQuery(strSQL);
        if (rs.next() && (newId = rs.getInt("maxId")) == 0) {
            ++newId;
        }
        return newId;
    }

    private int getAnyExistingFileId(TranslationFile currentFile) throws SQLException {
        int fileId = 0;
        boolean continueLoop = true;
        String fileLocation = "";
        String localDirectory = currentFile.getFilePath().substring(14);
        String strSQL = "select File_ID, File_Location from Files ";
        strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" where File_Name='").append(currentFile.getFileName()).append("'")));
        strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" and File_Location like '%").append(localDirectory).append("%'")));
        ResultSet rs = this.stmt.executeQuery(strSQL);
        while (rs.next() && continueLoop) {
            fileLocation = rs.getString("File_Location");
            if (currentFile.getFilePath().length() <= 14 || !currentFile.getFilePath().endsWith(fileLocation.substring(14))) continue;
            fileId = rs.getInt("File_ID");
            continueLoop = false;
        }
        return fileId;
    }

    public void exportPhrase(Phrase currentPhrase) {
        int labelId = 0;
        try {
            labelId = this.exportLabels(currentPhrase);
            currentPhrase.setKeyId(labelId);
            int sourceTextId = 0;
            int translatedTextId = 0;
            if (this.languageCode.equalsIgnoreCase("en")) {
                sourceTextId = this.exportSourceTexts(currentPhrase, labelId);
                this.updateInstallsLabelsSources(labelId, sourceTextId);
            } else {
                sourceTextId = currentPhrase.getTextId();
                if (sourceTextId == 0) {
                    this.getTranslatedTextsSource(currentPhrase);
                    sourceTextId = currentPhrase.getTextId();
                }
                if ((translatedTextId = this.exportTranslatedText(currentPhrase, sourceTextId)) != 0) {
                    this.updateInstallsLabelsSourcesTargets(labelId, sourceTextId, translatedTextId);
                }
            }
            if (sourceTextId == 0) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("SourceTextID=0 - ").append(currentPhrase.getKey()).append(" : ").append(currentPhrase.getText()))));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Wrote: ").append(currentPhrase.getKey()).append("(").append(labelId).append(")"))));
    }

    private int exportLabels(Phrase currentPhrase) throws SQLException {
        String strSQL = "";
        int labelId = currentPhrase.getKeyId();
        if (labelId == 0) {
            labelId = this.getAnyLabelId(currentPhrase);
        }
        if (labelId == 0) {
            labelId = this.getNewId("Label_ID", "Labels");
        }
        strSQL = "replace into Labels (File_ID, Label_ID, Label_Name) ";
        strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" values (").append(this.presentFileId).append(",'").append(labelId).append("'")));
        strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" ,'").append(currentPhrase.getKey()).append("')")));
        this.stmt.executeUpdate(strSQL);
        return labelId;
    }

    private int getAnyLabelId(Phrase currentPhrase) throws SQLException {
        int labelId = 0;
        String strSQL = "select l.Label_ID from Labels as l ";
        strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" where l.File_ID=").append(this.presentFileId)));
        ResultSet rs = this.stmt.executeQuery(strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" and l.Label_Name='").append(currentPhrase.getKey()).append("'"))));
        if (rs.next()) {
            labelId = rs.getInt("Label_ID");
        }
        return labelId;
    }

    private int exportSourceTexts(Phrase currentPhrase, int labelId) throws SQLException {
        int sourceTextId = currentPhrase.getTextId();
        String strSQL = "";
        if (sourceTextId == 0) {
            sourceTextId = this.getAnySourceTextID(currentPhrase);
        }
        if (sourceTextId == 0) {
            sourceTextId = this.getNewId("SourceText_ID", "SourceTexts");
            ++this.numberOfTextsInserted;
        } else {
            ++this.numberOfTextsUpdated;
        }
        this.prepSourceTextExport.setInt(1, sourceTextId);
        this.prepSourceTextExport.setString(2, this.replaceQuote(currentPhrase.getText()));
        this.prepSourceTextExport.setString(3, "[L10NZILLA] Archive");
        this.prepSourceTextExport.executeUpdate();
        return sourceTextId;
    }

    private int getAnySourceTextID(Phrase currentPhrase) throws SQLException {
        String strSQL = "";
        int intSourceTextId = 0;
        this.prepNewSourceTextSearch.setString(1, this.replaceQuote(currentPhrase.getText()));
        ResultSet rs = this.prepNewSourceTextSearch.executeQuery();
        if (rs.next()) {
            intSourceTextId = rs.getInt("SourceText_ID");
        }
        return intSourceTextId;
    }

    private void getTranslatedTextsSource(Phrase currentPhrase) throws SQLException {
        String strSQL = "";
        boolean sourceTextId = false;
        ResultSet rs = null;
        strSQL = "select s.SourceString, ils.SourceText_ID from Installs_Labels_Source as ils , SourceTexts as s ";
        strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" where ils.Label_ID=").append(currentPhrase.getKeyId())));
        strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" and ils.Install_ID=").append(this.presentInstallId)));
        rs = this.stmt.executeQuery(strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and ils.SourceText_ID=s.SourceText_ID"));
        if (rs.next()) {
            currentPhrase.setTextId(rs.getInt("SourceText_ID"));
            currentPhrase.setText(rs.getString("SourceString"));
        }
    }

    private int exportTranslatedText(Phrase currentPhrase, int sourceTextId) throws SQLException {
        int translatedTextId = 0;
        int statusID = 0;
        String comment = "";
        if (!currentPhrase.getText().equalsIgnoreCase(currentPhrase.getTranslatedText()) && this.languageCode != "en") {
            if (currentPhrase.isTranslationNeeded()) {
                statusID = 2;
                comment = "[L10NZILLA] Translation Needed";
            } else {
                comment = "[L10NZILLA] Translation Archived";
                statusID = 1;
            }
            translatedTextId = currentPhrase.getTranslatedTextId();
            String strSQL = "";
            if (translatedTextId == 0) {
                translatedTextId = this.getAnyTranslatedTextID(currentPhrase, sourceTextId);
            }
            if (translatedTextId == 0) {
                translatedTextId = this.getNewId("TranslatedText_ID", "TranslatedTexts");
            }
            this.prepTranslatedTextExport.setInt(1, translatedTextId);
            this.prepTranslatedTextExport.setString(2, this.languageCode);
            this.prepTranslatedTextExport.setString(3, this.replaceQuote(currentPhrase.getTranslatedText()));
            this.prepTranslatedTextExport.setString(4, comment);
            this.prepTranslatedTextExport.setInt(5, statusID);
            this.prepTranslatedTextExport.setInt(6, currentPhrase.getTranslationQuality());
            this.prepTranslatedTextExport.executeUpdate();
            ++this.numberOfTranslatedTextsInserted;
        }
        return translatedTextId;
    }

    private int getAnyTranslatedTextID(Phrase currentPhrase, int sourceTextId) throws SQLException {
        int intTranslatedTextId;
        block1: {
            String strSQL = "";
            intTranslatedTextId = 0;
            strSQL = "select ilst.TranslatedText_ID, t.TranslatedString from Installs_Labels_Source_Target as ilst, TranslatedTexts as t ";
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" where ilst.Install_ID=").append(this.presentInstallId)));
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" and ilst.Label_ID=").append(currentPhrase.getKeyId())));
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" and ilst.SourceText_ID=").append(currentPhrase.getTextId())));
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" and ilst.Lang_ID='").append(this.languageCode).append("'")));
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" and ilst.Translator_ID=").append(this.translatorId)));
            ResultSet rs = this.stmt.executeQuery(strSQL = String.valueOf(String.valueOf(strSQL)).concat(" and ilst.TranslatedText_ID = t.TranslatedText_ID"));
            if (!rs.next()) break block1;
            intTranslatedTextId = rs.getInt("TranslatedText_ID");
            String originalText = rs.getString("TranslatedString");
            if (!originalText.equalsIgnoreCase(currentPhrase.getTranslatedText())) {
                System.out.println("**** Updated Translation, Text_ID: ".concat(String.valueOf(String.valueOf(intTranslatedTextId))));
                System.out.println(currentPhrase.getTranslatedText());
                System.out.println(originalText);
            }
        }
        return intTranslatedTextId;
    }

    private void updateInstallsLabelsSources(int labelId, int sourceTextId) throws SQLException {
        String strSQL = "";
        strSQL = "replace into Installs_Labels_Source (Install_ID, Label_ID, SourceText_ID) ";
        strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" values (").append(this.presentInstallId).append(",").append(labelId).append(",").append(sourceTextId).append(")")));
        this.stmt.executeUpdate(strSQL);
    }

    private void updateInstallsLabelsSourcesTargets(int labelId, int sourceTextId, int translatedTextId) throws SQLException {
        String strSQL = "";
        strSQL = "replace into Installs_Labels_Source_Target (Install_ID, Label_ID, SourceText_ID, TranslatedText_ID, Lang_ID, Translator_ID) ";
        strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" values (").append(this.presentInstallId).append(",").append(labelId).append(",").append(sourceTextId).append(",").append(translatedTextId).append(",'").append(this.languageCode).append("',").append(this.translatorId).append(")")));
        this.stmt.executeUpdate(strSQL);
    }

    private String replaceQuote(String someText) {
        String resultText = "";
        Object phrase_b = null;
        Object enc_textString = null;
        try {
            for (int i = 0; i < someText.length(); ++i) {
                String ch = someText.substring(i, i + 1);
                resultText = ch.equalsIgnoreCase("'") ? String.valueOf(String.valueOf(resultText)).concat("'") : String.valueOf(String.valueOf(resultText)).concat(String.valueOf(String.valueOf(ch)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return resultText;
    }

    public void concludeExportFile() {
    }

    public void prepareExportFile() {
    }

    private int getTranslatorId() {
        String enteredTranslator = l10nZillaConfigurationProperties.instance().getProperty("translatorName");
        boolean translatorId = false;
        String strSQL = "";
        ResultSet rs = null;
        try {
            strSQL = "select Translator_ID from Translators ";
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(" where Translator_Login like '%").append(enteredTranslator).append("%'")));
            rs = this.stmt.executeQuery(strSQL);
            if (rs.next()) {
                int n = rs.getInt("Translator_ID");
                return n;
            }
            System.out.println("Translator Login+Password Not Found");
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println("Trouble getting log in information from database ");
        }
        return 0;
    }

    private String getTranslatorNameFromCommandLine() {
        System.out.print("Enter your name: ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String userName = null;
        try {
            userName = br.readLine();
        }
        catch (IOException ioe) {
            System.out.println("IO error trying to read your name!");
            System.exit(1);
        }
        return userName;
    }

    private String getTranslatorPasswordFromCommandLine() {
        System.out.print("Password: ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String password = null;
        try {
            password = br.readLine();
        }
        catch (IOException ioe) {
            System.out.println("IO error trying to read your password!");
            System.exit(1);
        }
        return password;
    }

    public boolean needTranslatorObject() {
        return true;
    }

    public void close() {
        System.out.println("");
        System.out.println("");
        System.out.println("Summary Of L10NZilla Writing To SQL database operation");
        System.out.println("------------------------------------------------------------------------");
        System.out.println("");
        System.out.println("Number Of New Files inserted : ".concat(String.valueOf(String.valueOf(this.numberOfNewFiles))));
        System.out.println("Number Of New Texts inserted : ".concat(String.valueOf(String.valueOf(this.numberOfTextsInserted))));
        System.out.println("Number Of Texts Updated with Edits : ".concat(String.valueOf(String.valueOf(this.numberOfTextsUpdated))));
        System.out.println("Number Of Translated Texts inserted  : ".concat(String.valueOf(String.valueOf(this.numberOfTranslatedTextsInserted))));
        System.out.println("");
        System.out.println("");
        System.out.println("");
        if (!this.languageCode.equalsIgnoreCase("en")) {
            this.buildStatistics();
        }
    }

    private void setFileStatisticsField(Statement updateStatement, int fileID, int installID, String fieldName, int fieldValue) throws SQLException {
        String updateSQL = "";
        updateSQL = "update Files_Statistics ";
        updateSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(updateSQL))).append(" set ").append(fieldName).append("=").append(fieldValue)));
        updateSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(updateSQL))).append(" where File_ID=").append(fileID)));
        updateSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(updateSQL))).append(" and Install_ID=").append(installID)));
        updateSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(updateSQL))).append(" and Lang_ID='").append(this.languageCode).append("'")));
        updateStatement.execute(updateSQL);
    }

    private void buildStatistics() {
        String strSQL = "";
        String updateSQL = "";
        System.out.println("Building Statistics.....");
        try {
            Statement updateStatement = this.dbConn.createStatement();
            strSQL = "select Install_ID,l.File_ID,count(Label_Name) as Total_Labels ";
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        from Installs_Labels_Source as ils, ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        Labels as l, Files as f ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        where l.Label_ID = ils.Label_ID and ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        l.File_ID = f.File_ID and ");
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append("        Install_ID = ").append(this.presentInstallId)));
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        group by File_ID");
            ResultSet rs = this.stmt.executeQuery(strSQL);
            while (rs.next()) {
                updateSQL = "replace into Files_Statistics ";
                updateSQL = String.valueOf(String.valueOf(updateSQL)).concat(" (Lang_ID,Install_ID,File_ID,Total_Labels) values ( ");
                updateSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(updateSQL))).append("'").append(this.languageCode).append("' ,")));
                updateSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(updateSQL))).append(this.presentInstallId).append(" ,")));
                updateSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(updateSQL))).append(rs.getInt("File_ID")).append(" ,")));
                updateSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(updateSQL))).append(rs.getInt("Total_Labels")).append(")")));
                updateStatement.execute(updateSQL);
            }
            rs.close();
            strSQL = "select Install_ID,l.File_ID,count(TranslatedText_ID) as Proposed_Translations ";
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("  from Installs_Labels_Source_Target as ilst, Labels as l, Files as f, SourceTexts as st ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("  where  l.Label_ID = ilst.Label_ID and ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("  l.File_ID = f.File_ID and ");
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append("  Install_ID = ").append(this.presentInstallId).append(" and ")));
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("  st.SourceText_ID = ilst.SourceText_ID and ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("  length(st.SourceString) > 1 and ");
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append("  ilst.Lang_ID='").append(this.languageCode).append("'")));
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("  group by File_ID");
            rs = this.stmt.executeQuery(strSQL);
            while (rs.next()) {
                this.setFileStatisticsField(updateStatement, rs.getInt("File_ID"), rs.getInt("Install_ID"), "Proposed_Translations", rs.getInt("Proposed_Translations"));
            }
            rs.close();
            strSQL = "select Install_ID,l.File_ID,count(TranslatedText_ID) as Proposed_AccessKeys from ";
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("  Installs_Labels_Source_Target as ilst, ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("  Labels as l, Files as f, SourceTexts as st ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("  where l.Label_ID = ilst.Label_ID and ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("   l.File_ID = f.File_ID and ");
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append("   Install_ID = ").append(this.presentInstallId).append(" and ")));
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("   st.SourceText_ID = ilst.SourceText_ID and ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("   length(st.SourceString) = 1 and ");
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append("   ilst.Lang_ID='").append(this.languageCode).append("'")));
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("   group by File_ID");
            rs = this.stmt.executeQuery(strSQL);
            while (rs.next()) {
                this.setFileStatisticsField(updateStatement, rs.getInt("File_ID"), rs.getInt("Install_ID"), "Proposed_AccessKeys", rs.getInt("Proposed_AccessKeys"));
            }
            rs.close();
            strSQL = "select Install_ID,l.File_ID,count(ils.SourceText_ID) as Total_AccessKeys from ";
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("  Installs_Labels_Source as ils, ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        Labels as l, Files as f, SourceTexts as st ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        where l.Label_ID = ils.Label_ID and ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        l.File_ID = f.File_ID and ");
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append("        Install_ID = ").append(this.presentInstallId).append(" and ")));
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        st.SourceText_ID = ils.SourceText_ID and ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        length(st.SourceString) = 1 ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        group by File_ID");
            rs = this.stmt.executeQuery(strSQL);
            while (rs.next()) {
                this.setFileStatisticsField(updateStatement, rs.getInt("File_ID"), rs.getInt("Install_ID"), "Total_AccessKeys", rs.getInt("Total_AccessKeys"));
            }
            rs.close();
            strSQL = "select Install_ID,l.File_ID,count(Quality_ID) as Accepted_Translations from ";
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("  Installs_Labels_Source_Target as ilst, SourceTexts as st, ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        Labels as l, Files as f, TranslatedTexts as tt where ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        l.Label_ID = ilst.Label_ID and ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        l.File_ID = f.File_ID and ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        tt.TranslatedText_ID = ilst.TranslatedText_ID and ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        ilst.SourceText_ID = st.SourceText_ID and ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        length(SourceString) > 1 and ");
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append("        Install_ID = ").append(this.presentInstallId).append(" and ")));
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("       (Quality_ID = 1 OR Quality_ID = 3) and ");
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append("        ilst.Lang_ID='").append(this.languageCode).append("'")));
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        group by File_ID ");
            rs = this.stmt.executeQuery(strSQL);
            while (rs.next()) {
                this.setFileStatisticsField(updateStatement, rs.getInt("File_ID"), rs.getInt("Install_ID"), "Accepted_Translations", rs.getInt("Accepted_Translations"));
            }
            rs.close();
            strSQL = "select Install_ID,l.File_ID,count(Quality_ID) as Accepted_AccessKeys from ";
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("  Installs_Labels_Source_Target as ilst, ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("  Labels as l, Files as f, TranslatedTexts as tt,SourceTexts as st where ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        l.Label_ID = ilst.Label_ID and ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        l.File_ID = f.File_ID and ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        tt.TranslatedText_ID = ilst.TranslatedText_ID and ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        ilst.SourceText_ID = st.SourceText_ID and ");
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        length(SourceString) = 1 and ");
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append("        Install_ID = ").append(this.presentInstallId).append(" and ")));
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        (Quality_ID = 1 OR Quality_ID = 3) and ");
            strSQL = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append("        ilst.Lang_ID='").append(this.languageCode).append("'")));
            strSQL = String.valueOf(String.valueOf(strSQL)).concat("        group by File_ID");
            rs = this.stmt.executeQuery(strSQL);
            while (rs.next()) {
                this.setFileStatisticsField(updateStatement, rs.getInt("File_ID"), rs.getInt("Install_ID"), "Accepted_AccessKeys", rs.getInt("Accepted_AccessKeys"));
            }
            rs.close();
            System.out.println("Building Statistics done. Take a look with php-l10nZilla.");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(strSQL);
            System.out.println("Trouble building statistics");
        }
    }
}

