#! /usr/bin/perl -w

# ****** Generate Mozilla Application Stubs ******
# ****** Copyright 2003 Jim Massey - all rights reserved ******

use Cwd;
use CGI;


$cgi_query = new CGI;

# **** The two sets of global variables are for cgi or standalone *****
# **** use. Only one set should be uncommented for use!           *****
# ***** These are for CGI usage *****
#$appName = $cgi_query->param('appName');
#$appNameString = $cgi_query->param('appString');
#$appNameAuthor = $cgi_query->param('appAuthor');
# ***** These are for Stand Alone usage *****
$appName = "MoZapptest";
$appNameString = "Jims Test Moz-app";
$appNameAuthor = "Jim Massey";

if ($appName eq "") { $appName = "no-name" }
$appName = lc $appName;

$appNameStringOriginal = "Mozilla Application Stub";

# ***** Set these to match your installation *****
$appDownloadUri = "http://stlouis-shopper.com/~massey/mozappgen/apps/";
#$savePath = "/home/massey/public_html/mozappgen/apps/";
$savePath = "./";
$generaterStyleSheet = "http://stlouis-shopper.com/~massey/mozappgen/style1.css";

# ***** Stub directories and file definitions *****
@app_directories = ("/content", "/skin", "/skin/default", "/locale", "/locale/en-US", "/app-installer");

@app_items = ("README.txt",
	    "mozilla-rebuild-databases.pl",
	    "remove-lock.sh",
	    "rebuild-databases.sh",
	    "install.js",
	    "installed-chrome.txt",
	    "InstallMaker.pl",
	    "content/contents.rdf",
	    "content/appstubs.xul",
	    "content/quit-btnOverlay.xul",
	    "content/print-btnOverlay.xul",
	    "content/sizeOverlay.xul",
	    "content/appstubs.js",
	    "locale/en-US/contents.rdf",
	    "locale/en-US/appstubs.dtd",
	    "locale/en-US/appstubsDefault.properties",
	    "skin/default/contents.rdf",
	    "skin/default/appstubs.css",
	    "app-installer/appStubInstall.html",
	    "app-installer/style1.css",
	    );

@app_overlay_resources = ("$appName", "browser");
#@app_overlay_resources = ("$appName");
@app_overlay_lineitems = ("quit-btnOverlay.xul", "print-btnOverlay.xul", "sizeOverlay.xul");

sub make_app_directories() {
    mkdir "$appName", 0755;
    foreach $directory ( @app_directories ) {
	my $temp = $appName . $directory;
	mkdir "$temp", 0755;
	#print ("\n*** Directory:  $temp");
    }
    #add_gtoolbar();
    #add_xbuttons();
    fill_app_directories();
}


sub fill_app_directories() {
    my $outfile = "";
    foreach $file ( @app_items ) {
	#print ("**** FILE: $file\n");
	$outfile = $file;
	if ( $file =~ /appstubs/ ) { $outfile =~ s/appstubs/$appName/ ;}
	#print ("**** FILE: $outfile\n");
	open (CONTENT, "> $appName/$outfile");
	open (STUBRDF, "< ./appStubs/$file") || die print "$! \n";
	 if ( $file =~ m/rdf/) {
	     #print ("****\n**** AN RDF File ***\n\n");
	     fix_appname_string();
	 } else {
	 common_fix_files();
	 build_content_rdf();
         }
    }
 add_gtoolbar();
 add_xbuttons();
}


sub add_gtoolbar {
    system("cp -r ./appStubs/content/gtoolbar $appName/content");
    append_app_stylesheet("gtoolbar/skin/gtoolbar.css");
}

sub add_xbuttons {
    system("cp -r ./appStubs/content/xbutton $appName/content");
    append_app_stylesheet("xbutton/style/xbutton.css");
    append_app_stylesheet("xbutton/style/button.css");
}

sub append_app_stylesheet($temp) {
    my $temp = $_[0];
    my $tempLine = '@import url("chrome://' . $appName . '/content/' . $temp . '");';
    #print ("**** SHEET FIXUP: $tempLine \n");
    open SHEET, ">>$appName/skin/default/$appName.css" or die "** $! \n";
    print SHEET "\n$tempLine";
    close SHEET;
    #print ("**** SHEET FIXUP: $temp \n");
}

# **** Build /content/contents.rdf for Overlays ****
sub build_content_rdf () {
open (CONTENT, "> $appName/content/contentsB.rdf");
my $newLine = '<?xml version="1.0"?> 

  <RDF:RDF xmlns:RDF="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
              xmlns:chrome="http://www.mozilla.org/rdf/chrome#"> 

    <RDF:Seq about="urn:mozilla:package:root"> 
      <RDF:li resource="urn:mozilla:appstubs"/>
    </RDF:Seq> 

    <RDF:Description about="urn:mozilla:package:appstubs" 
          chrome:displayName="Xul AppStubs for mozilla application" 
          chrome:author="Mozilla AppStub" 
          chrome:name="appstubs"> 
    </RDF:Description>
';
print CONTENT $newLine;

 if (@app_overlay_resources ne "null") {
  foreach $file (@app_overlay_resources) {
      print CONTENT "\n    ";
      print CONTENT '<RDF:Seq about="urn:mozilla:overlays">';
      print CONTENT "\n      ";
      $newLine = '<RDF:li resource="chrome://' 
	  . $file 
	      . '/content/' 
		  . $file
		      . '.xul"/>';
      print CONTENT $newLine;
      print CONTENT "\n    </RDF:Seq>\n    ";
   if (@app_overlay_lineitems) {
       $newLine = '<RDF:Seq about="chrome://' 
	   . $file 
	       . '/content/' 
		   . $file 
		       . '.xul">';
     print CONTENT $newLine;
       foreach $lineitem (@app_overlay_lineitems) {
	   print CONTENT "\n      ";
	   $newLine = '<RDF:li>chrome://'
	       . $appName 
		   . '/content/' 
		       . $lineitem 
			   . '</RDF:li>';
	  print CONTENT $newLine;
       }
     print CONTENT "\n    </RDF:Seq>\n";
   }
  }
#print CONTENT "\n  </RDF:RDF>\n";
 }
print CONTENT "\n  </RDF:RDF>\n";
open (CONTENT, "> $appName/content/contents.rdf");
open (STUBRDF, "< $appName/content/contentsB.rdf") || die print "$! \n";
fix_appname_string();
close CONTENT;
unlink "$appName/content/contentsB.rdf";

}

# ***** Html output *****
sub html_output() {
print $cgi_query->header();
print $cgi_query->start_html(-title=>"Mozilla App Download",
			     -style=>{'src'=>"$generaterStyleSheet"});
print ("<div class='neat-li'>\n");
print $cgi_query->p("<h2>You Had Success in generating $appName!</h2>\n");
print ("<br>Here is a link to download your mozilla application stub:<br>\n");
print $cgi_query->p("<a href=" . $appDownloadUri . $appName . ".zip>$appName Zip File</a>\n");
print ("<p><b>This file will be removed in a few minutes. Download it NOW!</b></p>\n");
print ("<p>A complete mozilla application has been generated from the simple information you provided. Download and unzip in the mozilla/chrome directory. There is an xpi in the application's root directory that is installable, just to prove that you have a complete mozilla application stub that is ready for you to build your application from.</p>\n");
print ("</div>\n");
print $cgi_query->end_html;

}

# ***** Fixup for download *****
sub package_for_download() {
chmod (0755, "$appName/InstallMaker.pl");
system ("./$appName/InstallMaker.pl");
system ("cp $appName/$appName.xpi $appName/app-installer/$appName.xpi");
system ("zip -rq $appName.zip  $appName");
#system ("cp $appName.zip $savePath");
#system ("rm -r ./$appName");
#unlink "./$appName.zip";

}

# ***** Common fix files routine *****
sub common_fix_files() {
    while (<STUBRDF>) {
	my $newLine = $_;
	$newLine =~ s/appstubs/$appName/g;
	print CONTENT $newLine;
	#print $newLine;
    }
}

# ***** Fix Appname String routine case insensitive *****
# ***** for the contents.rdf                        *****
sub fix_appname_string() {
    while (<STUBRDF>) {
	my $newLine = $_;
	$newLine =~ s/"Mozilla Appstub"/"$appNameAuthor"/i;
	$newLine =~ s/"AppStubs application stub"/"$appNameString"/;
	$newLine =~ s/$appNameStringOriginal/$appNameString/i;
	$newLine =~ s/appstubs/$appName/gi;
	print CONTENT $newLine;
	#print $newLine;
    }
}

# ***** Cleanup any old zips in the downloads directory *****
sub clean_download_dir() {
    opendir (APPDIR, "$savePath");
    #opendir (APPDIR, "./");
    while ($filename = readdir(APPDIR)) {
	if ($filename =~ m/\.zip/g) {
	    ($atime, $mtime) = (stat "$savePath$filename") [8,9];
	    #($atime, $mtime) = (stat "./$filename") [8,9];
	   # print (" *** HI - $filename :: $atime : $mtime \n" .  time() . "\n");
	    if ( ($atime + 300)  < time()) {
		#print ("**** WOULD DELTE:" .  $savePath . $filename . "****\n<br>");
		    unlink "$savePath$filename" || die print (" $! \n");
		    #unlink "./$filename" || die print (" $! \n");
	    };
	}
    }
    close APPDIR;
}

# **** Run the generater ****
clean_download_dir();
&make_app_directories();
package_for_download();
html_output();

