/* 
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 *
 * Contributor(s): Jeremie Miller, jer@jabber.org
 *                 Rob Ginda,      rginda@netscape.com
 *                 Eric Murphy,    ericmurphy@jabber.org
 *
 * Date: 2001.01.02
 *
 */

function Socket()
{
   var sockServiceClass =
      Components.classesByID["{c07e81e0-ef12-11d2-92b6-00105a1b0d64}"];
   
   if (!sockServiceClass) {
		dump("Couldn't get socket service class.");
      throw ("Couldn't get socket service class.");
   }

   var sockService = sockServiceClass.getService();
   if (!sockService) {
       dump ("Couldn't get socket service.");
      throw ("Couldn't get socket service.");
	}

   this._sockService = sockService.QueryInterface
      (Components.interfaces.nsISocketTransportService);

   // to preserve ourselves within necko/async
   this.wrappedJSObject = this;
}

Socket.prototype.open = function(host, port)
{
   this.host = host.toLowerCase();
   this.port = port;

   this._channel = this._sockService.createTransport (host, port, null, -1,
                                          0, 0);

   if (!this._channel) {
       dump ("Error opening channel.");
      throw ("Error opening channel.");
	}

   this._outputStream = this._channel.openOutputStream(0);
   if (!this._outputStream) {
      dump ("Error getting output stream.");
      throw ("Error getting output stream.");
	}

   this.isConnected = true;

   return this.isConnected;
}

Socket.prototype.close = function()
{
   if (this.isConnected) {
      this.isConnected = false;
//this._inputStream.close();
      this._outputStream.close();
   }
}

Socket.prototype.write = function(str)
{
   if (!this.isConnected)
      throw "Not Connected.";

   var rv = false;

   try
   {
      this._outputStream.write(str, str.length);
      rv = true;
   }
   catch (ex)
   {
      if (typeof ex != "undefined")
      {
         this.isConnected = false;
         throw (ex);
      }
      else
         rv = false;
   }
   
   return rv;
}

Socket.prototype.read = function(timeout)
{
   if (!this.isConnected)
      throw "Not Connected.";

   if (!this._inputStream)
   {
      this._inputStream =
         this.toScriptableInputStream(this._channel.openInputStream (0, 0));
      if (!this._inputStream)
         throw ("Error getting input stream.");
   }
   
   var rv, av;

   try
   {
      av = this._inputStream.available();
      if (av)
         rv = this._inputStream.read (av);
      else
         rv = "";
   }
   catch (ex)
   {
      if (typeof ex != "undefined") {
         this.isConnected = false;
         throw (ex);
      } else {
         rv = "";
      }
   }
   
   return rv;
}

Socket.prototype.async = function(handler)
{
	this.async = handler;
	this._channel.asyncRead (new SocketListener(), this);
}

// async callbacks
function SocketListener(){}
SocketListener.prototype.onStartRequest = function(channel, ctxt)
{
// dd ("onStartRequest: " + channel + ", " + ctxt);
}
SocketListener.prototype.onStopRequest = function(channel, ctxt, status, errorMsg)
{
 // dd ("onStopRequest: " + channel + ", " + ctxt + ", " + status + ", " + errorMsg+"\n");
   ctxt = ctxt.wrappedJSObject;
	ctxt.async(""); // signal socket failed?
}
SocketListener.prototype.onDataAvailable = function(channel, ctxt, inStr, sourceOffset, count)
{
   dump ("onDataAvailable: " + channel + ", " + ctxt + ", " + ctxt.wrappedJSObject + ", " + inStr + ", " + sourceOffset + ", " + count);
   ctxt = ctxt.wrappedJSObject;

   if (!ctxt._inputStream)
      ctxt._inputStream = ctxt.toScriptableInputStream(inStr);

   ctxt.async(ctxt.read());
}

// util
Socket.prototype.toScriptableInputStream = function(i)
{
   var si = Components.classes["@mozilla.org/scriptableinputstream;1"];
   
   si = si.createInstance();
   si = si.QueryInterface(Components.interfaces.nsIScriptableInputStream);
   si.init(i);

   return si;
}
