/* components defined in this file */
const CLINE_SERVICE_CONTRACTID =
    "@mozilla.org/commandlinehandler/general-startup;1?type=xulmine";
const CATMAN_CONTRACTID = "@mozilla.org/categorymanager;1";
const CLINE_SERVICE_CID =
    Components.ID("{00000000-0000-0000-0000-000000000000}");
const WINDOW_MANAGER_CONTRACTID = "@mozilla.org/appshell/window-mediator;1";

/* Command Line handler service */
function CLineService() {}

CLineService.prototype = {
  commandLineArgument: "-xulmine",
  prefNameForStartup: "general.startup.xulmine",
  get chromeUrlForTask() {
    var windowManager = Components.classes[WINDOW_MANAGER_CONTRACTID]
                                  .getService(Components.interfaces.nsIWindowMediator);
    var xulmineWindow = windowManager.getMostRecentWindow('xulmine');
    if (xulmineWindow)
      xulmineWindow.setTimeout(function() { xulmineWindow.close(); }, 0);
    return "chrome://xulmine/content";
  },
  helpText: "Start with XULmine.",
  handlesArgs: false,
  defaultArgs: "",
  openWindowWithArgs: false,
  QueryInterface: function QueryInterface(iid) {
    if (iid.equals(Components.interfaces.nsICmdLineHandler) ||
        iid.equals(Components.interfaces.nsISupports))
      return this;
    throw Components.results.NS_ERROR_NO_INTERFACE;
  }
}

/* factory for command line handler service (CLineService) */
var CLineFactory = {

  createInstance: function createInstance(outer, iid) {
    if (outer != null)
      throw Components.results.NS_ERROR_NO_AGGREGATION;
  
    if (!iid.equals(Components.interfaces.nsICmdLineHandler) &&
        !iid.equals(Components.interfaces.nsISupports))
      throw Components.results.NS_ERROR_INVALID_ARG;
  
    return new CLineService();
  }
}

var Module = {

  registerSelf: function registerSelf(compMgr, fileSpec, location, type) {
    compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar)
           .registerFactoryLocation(CLINE_SERVICE_CID,
                                    "XULmine command line service",
                                    CLINE_SERVICE_CONTRACTID,
                                    fileSpec,
                                    location,
                                    type);
  
    Components.classes[CATMAN_CONTRACTID]
              .getService(Components.interfaces.nsICategoryManager)
              .addCategoryEntry("command-line-argument-handlers",
                                  "XULmine command line handler",
                                  CLINE_SERVICE_CONTRACTID, true, true);
  },

  unregisterSelf: function unregisterSelf(compMgr, fileSpec, location) {
    compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar)
           .unregisterFactoryLocation(CLINE_SERVICE_CID, fileSpec);
  
    Components.classes[CATMAN_CONTRACTID]
              .getService(Components.interfaces.nsICategoryManager)
              .deleteCategoryEntry("command-line-argument-handlers", CLINE_SERVICE_CONTRACTID, true);
  },

  getClassObject: function getClassObject(compMgr, cid, iid) {
    if (cid.equals(CLINE_SERVICE_CID))
      return CLineFactory;
  
    if (!iid.equals(Components.interfaces.nsIFactory))
      throw Components.results.NS_ERROR_NOT_IMPLEMENTED;
  
    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  canUnload: function canUnload(compMgr) {
    return true;
  }
}

/* entrypoint */
function NSGetModule(compMgr, fileSpec) {
  return Module;
}
