var rows, cols, mines;

function onLoad() {
  window.addEventListener("keypress", onKeyPress, true);
  rows = document.getElementById('rows');
  cols = document.getElementById('cols');
  mines = document.getElementById('mines');
  rows.value = opener.cols;
  cols.value = opener.rows;
  mines.value = opener.mines;
  window.screenX += 24;
  window.screenY += 45;
  setTimeout(ensureSizeAndPosition, 0);
}

function ensureSizeAndPosition() {
  var windowX = window.screenX;
  if (windowX < screen.availLeft)
    windowX = screen.availLeft;
  else {
    var availX = screen.availLeft + screen.availWidth - window.outerWidth;
    if (windowX > availX)
      windowX = availX;
  }
  var windowY = window.screenY;
  if (windowY < screen.availTop)
    windowY = screen.availTop;
  else {
    var availY = screen.availTop + screen.availHeight - window.outerHeight;
    if (windowY > availY)
      windowY = availY;
  }
  window.moveTo(windowX, windowY);
}

function onKeyPress(event) {
  if (event.charCode && (event.charCode < 48 || event.charCode > 57))
    event.stopPropagation();
}

function ensure(value, min, max) {
  return value < min ? min : value > max ? max : value;
}

function onAccept() {
  var custom = {};
  custom.rows = ensure(rows.value, 8, 24);
  custom.cols = ensure(cols.value, 8, 30);
  custom.mines = ensure(mines.value, 10, (custom.rows - 1) * (custom.cols - 1));
  opener.custom = custom;
}

function onCancel() {
  opener.custom = {
    rows: opener.rows,
    cols: opener.cols,
    mines: opener.mines
  }
}
